;+++++++++++++++++++++++
;  Taucher's Freeware Private Message Logger for mIRC (tested on 5.51)
;  to load type        /load -rs Awaylog.mrc
;  to unload type    /unload -rs Awaylog.mrc
;  LAST UPDATE: Added several filters and !log? trigger, 30s dead-time after joining a  channel
;+++++++++++++++++++++++

on *:START: {
  %awaylog.ver = 15.05.99 8
  return
  echo 2 -s >>>
  echo 2 -s $+ $ps_ki Taucher's Freeware Private Message Logger for mIRC (tested on mIRC 5.51) - %awaylog.ver 
  echo 2 -s To unload type 1/unload -rs Awaylog.mrc2 - to reload unload and then type 1/load -rs Awaylog.mrc
  echo 2 -s It will timestamp and write a logfile regardless of mirc-settings!
  echo 2 -s It will ignore your away-status and it won't say anything to the world out there - it simply logs the text
  echo 2 -s It will react to a $+ $ps_ki !log?2 request sent to you in private message with a version reply
  echo 2 -s It will react to a $+ $ps_ki !note ....text... 2 request with a prompt to read that note and send an acknowledgement  to the sender!
  echo 2 -s Not to forget: it will ignore leech-messages and notifications sent by scripts (except for failed sends)
  echo 2 -s Note: As most channels have onjoin-greetings the script will deactivate @AwayLog for a moment after you join a channel
  echo 2 -s <<<
  %awaylog.ignore = $false
}
; #####
on ^*:NOTICE:*:?:{
  var %ps_a = PS_OnNotice_awaylog_<all>
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  away.notecheck $1-
  if (%awaylog.ignore == $false) {
    away.log $1-
  }
}
; #####
on *:TEXT:*:?:{ 
  var %ps_a = PS_OnText_awaylog_<all>
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  away.notecheck $1-
  if (%awaylog.ignore == $false) {
    away.log $1-
  }
}
; #####
alias awaylog.tempdisable {
  %awaylog.ignore = $true
  echo $timestamp 10>> AwayLog disabled in order to ignore OnJoin-Messages in $chan
}
; #####
alias awaylog.tempundisable {
  %awaylog.ignore = $false
  echo $timestamp 10>> AwayLog re-enabled
}
; #####
on *:JOIN:#:{
  if ($nick = $me) {
    ; Note: the use of a named timer helps to reduce load
    ; when joining several channels at the same time
    if ($chan = #alsscan) {
      ; ALS-Channel has longer dead-time after join  
      awaylog.tempdisable
      .timer 1 65 /awaylog.tempundisable
    }
    else {
      ; Any other channel has just 10s dead-time after join  
      awaylog.tempdisable
      .timer 1 15 /awaylog.tempundisable
    }
  }
}
; #####
alias away.log {
  ; #### Prepare a COPY of the original string for processing ####
  %awaylog.temp1 = $strip($lower($1- ))
  if (!log? = %awaylog.temp1 ) { 
    /msg $nick 3AwayLog $+ (Ver. $+ %awaylog.ver $+ ) is active 
    return
  }
  ; #### Filter Basic Strings ####
  if ($nick == $me ) { goto unset }
  if ($comchan($nick,0) < 1) {
    if (serv !isin $nick) {
      haltdef
      goto unset 
    }
  }
  if (! isin $1) { goto unset }
  if (@ isin $gettok(%awaylog.temp1,1,58)) { goto unset }
  if (dcc send == $left(%awaylog.temp1,8)) { goto unset }
  if ( isin %awaylog.temp1) { goto unset }
  if (ne><gen isin %awaylog.temp1) { goto unset }
  if (by lobo isin %awaylog.temp1) { goto unset }
  if (Send Of isin %awaylog.temp1) { goto unset }
  if ((Leech isin %awaylog.temp1) && (from $me isin %awaylog.temp1)) { goto unset }
  if (Sorry my sends are full isin %awaylog.temp1) { goto unset }
  if (queue isin %awaylog.temp1) { goto unset }
  if (Trigger: isin %awaylog.temp1) { goto unset }
  if (Series: isin %awaylog.temp1) { goto unset }
  if (Message: isin %awaylog.temp1) { goto unset }
  if (Duration: isin %awaylog.temp1) { goto unset }
  if (PhotoServe Version isin %awaylog.temp1) { goto unset }
  if (StatsMaker: isin %awaylog.temp1) { goto unset }
  if (PhotoServe bot isin %awaylog.temp1) { goto unset }
  if (~invalid~ isin %awaylog.temp1) { goto unset }
  if (DCC Chat isin %awaylog.temp1) { goto unset }
  if (I have reached my user defined gig isin %awaylog.temp1) { goto unset }
  if ((sending of file isin %awaylog.temp1) && (has failed!! isin %awaylog.temp1)) { goto unset }
  if (Generating PhotoServe Backup isin %awaylog.temp1) { goto unset }
  if (Sending PhotoServe Backup isin %awaylog.temp1) { goto unset }
  if (My Triggers are OFF isin %awaylog.temp1) { goto unset }
  if (OK updating Count isin  %awaylog.temp1) { goto unset }


  ; #### Filter Botnicks to Exclude ####
  if (dart isin $lower($nick)) { goto unset }
  if (stone isin $lower($nick)) { goto unset }
  if (eeche isin $lower($nick)) { goto unset }
  if (uperwor isin $lower($nick)) { goto unset }
  if (bot isin $lower($nick)) { goto unset }
  if (^asr isin $lower($nick)) { goto unset }
  if (Thump isin $lower($nick)) { goto unset }
  if (byte isin $lower($nick)) { goto unset }
  if (pervert isin $lower($nick)) { goto unset }
  if (chanserv isin $lower($nick)) { goto unset }
  if (nickserv isin $lower($nick)) { goto unset }
  if (global == $lower($nick)) { goto unset }
  if (daedalus isin $lower($nick)) { goto unset }
  if (narf isin $lower($nick)) { goto unset }
  if (xanadu isin $lower($nick)) { goto unset }

  ; #### Filter using Combined Statements - Dynamic Filters ####
  if (( $me isin %awaylog.temp1) && (recieved isin %awaylog.temp1)) { goto unset }
  if ((auto isin %awaylog.temp1) && (sending isin %awaylog.temp1)) { goto unset }
  if (((you isin %awaylog.temp1) && (just isin %awaylog.temp1)) && (recieved isin %awaylog.temp1)) { goto unset }

  ; #### Filter Script-Strings ####
  if (not found isin %awaylog.temp1) { goto unset }
  if (try again later isin %awaylog.temp1) { goto unset }
  if (send of isin %awaylog.temp1) { goto unset }
  if (already getting isin %awaylog.temp1) { goto unset }
  if (Allready Sending. isin %awaylog.temp1) { goto unset }
  if (You must be verified isin %awaylog.temp1) { goto unset }
  ;  if (fail = $left(%awaylog.temp1,8)) { goto unset }

  ; #### Send-Start ####
  if (here is a file from isin %awaylog.temp1) { goto unset }
  if (found! isin %awaylog.temp1) { goto unset }
  if (match found isin %awaylog.temp1) { goto unset }
  if (been put on isin %awaylog.temp1) { goto unset }
  if (ERROR: isin %awaylog.temp1) { goto unset }

  ; #### Auto-Messages ####
  if (offers: isin %awaylog.temp1) { goto unset }
  if (i have sent isin %awaylog.temp1) { goto unset }
  if (sent since isin %awaylog.temp1) { goto unset }
  if (press f7 to isin %awaylog.temp1 ) { goto unset }
  if (thank you for isin %awaylog.temp1) { goto unset }
  if (thanks for isin %awaylog.temp1 ) { goto unset }
  if (filesys/ isin %awaylog.temp1 ) { goto unset }
  if (has received a file from isin %awaylog.temp1 ) { goto unset }
  if (Transfer of isin %awaylog.temp1) { goto unset }
  if (This is an automated message - DO NOT REPLY!! isin %awaylog.temp1) { goto unset }
  if (this is an auto message, do not reply isin %awaylog.temp1) { goto unset }

  ; #### Filter Script-Help-Texts ####
  if (to search a isin %awaylog.temp1) { goto unset }
  if (welcome to isin %awaylog.temp1) { goto unset }

  ; #### Filters done ####
  /AwayLog.Check $1-
  :unset
  unset %awaylog.temp1
}
; #####
alias AwayLog.Check {
  if ($window(@AwayLog) != @AwayLog ) {  
    ; ##### CREATE WINDOW AND INIT LOGFILE IF NEEDED #####
    /window -b @AwayLog 5 5 600 100 verdana 12
    ; e = editbox h = hide n = minimize b = update h-pos
    %AwayLog.Logfilename  =  $logdir $+ AwayLog_ $+ $asctime(yyyymm) $+ .log
    if ($exists( %AwayLog.Logfilename ) == $false ) {
      if ( %AwayLog.Logfilename != $null ) { /write " $+ %AwayLog.Logfilename $+ " Creating Log $date $time }
      /aline -p @AwayLog 12Logfile Created : %AwayLog.Logfilename 
    }
    else {
      if ( %AwayLog.Logfilename != $null ) { /write " $+ %AwayLog.Logfilename $+ " Appending Log $date $time }
      /aline -p @AwayLog 12Logfile appended : %AwayLog.Logfilename 
    }
    ; #####
  }
  ; ##### EXECUTE EVERY TIME #####
  /aline -p @AwayLog $timestamp 3 $+ $network 14 $+ < $+ $nick $+ > $1-
  /titlebar @AwayLog -- $timestamp < $+ $nick $+ > $strip($1- )
  if ( %AwayLog.Logfilename != $null ) { /write " $+ %AwayLog.Logfilename $+ " $timestamp < $+ $nick $+ > $strip($1- ) }
  /flash @AwayLog MESSAGE ARRIVED : $timestamp  < $+ $nick $+ > $strip($1- )
}
; #####
alias AwayLog.Attention {
  if ($window(@Attention) != @Attention ) {
    /window -dbh @Attention 5 5 350 150
    /aline -ph @Attention 14Don't forget to check your AwayLog-Window for messages that might be related to this note(s).
    /aline -ph @Attention     
  }
  /aline -ph @Attention $timestamp 04 $+ $nick left you this note 04>> $1-
  /aline -ph @Attention      
  .timer997 1 10 .msg $nick Your note has been stored - local time: $time

  ;#### Now give the user a chance to prevent the message-window auto-pop up
  echo $ps_n -at 04YOU RECIEVED A NOTE
  echo $ps_n -at Use the "/notes read" to read it now
  .timer987 1 120   /notes read
}
; #####
alias away.notecheck {
  %awaylog.temp1 = $strip($lower($1- ))
  if (!not isin $left(%awaylog.temp1,5) ) { 
    ; Note: the $Left-Tolerance is intentional!
    /AwayLog.Attention $2-
    /AwayLog.Check $1-
  }
  unset %awaylog.temp1
}
; #####
alias note {
  echo $ps_n -at 4 What's the difference between plural and sigular ?
  notes $1-
}
; #####
alias notes {
  if (read isin $strip($1-)) {
    /window -rdobah @Attention 5 5  -1 300
    .timer987 off
  }
}
; #####
