;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;  Taucher's Freeware DCC SEND and GET Logger for mIRC
;  to load type        /load -rs DCClog.txt
;  to unload type    /unload -rs DCClog.txt
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; SPECIAL FUNCTION: Automatic F-Serve Anti-Idle
; Added 11/2000: Listing of queued Botfiles
; Changed the color layout  07/2004 (valen)
; Updated script to work with multi-nick pserve leech
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
on *:START: {
  %DCClog.ver = 6.23.2K7 V1.7
  echo 2 >>>
  echo 12 Taucher's Freeware DCC SEND and GET Logger for mIRC (tested on mIRC 5.61) - %DCClog.ver 
  echo 2 To unload type 1/unload -rs DCClog.txt2 - to reload unload and then type 1/load -rs DCClog.txt
  echo 2 It will timestamp and write a logfile regardless of mirc-settings!
  echo 2 It won't say anything to the world out there - it simply logs the DCCs
  echo 2 It will react to a 12!dcclog?2 request sent to you in private message with a version reply
  echo 2 <<<
}
;=================================

; This does keep Fserve from auto-closing - if needed exchange the dot at the msg with "who"
on *:CHAT:*Closing Idle connection in*:{
  msg =$nick .
  echo -s IDLE-WARNING for Fserve with $nick (triggered in script $script $+ )
}

;--------------

on *:TEXT:*DCC*:*:{
  ; LogDCC.log TEXTCATCHER: $nick ( $+ $chan $+ ) $1-
}

on *:NOTICE:*DCC*:*:{
  ; LogDCC.log 5NOTICE: $nick ( $+ $chan $+ ) $1-
}

on *:NOTICE:*Sending*:*:{
  %dcclog.list = $remove($1-,Sending)
  %dcclog.list = $remove(%dcclog.list,incoming/)
  %dcclog.list = $remove(%dcclog.list,filesys/)
  ; LogDCC.log 12FILES $nick ( $+ $chan $+ ): %dcclog.list
}

on *:NOTICE:*timed out*:*:{
  %dcclog.list = $remove($1-,Sending)
  %dcclog.list = $remove(%dcclog.list,incoming/)
  %dcclog.list = $remove(%dcclog.list,filesys/)
  ; LogDCC.log 12TIMEOUT $nick ( $+ $chan $+ ): %dcclog.list
}


on *:NOTICE:*Updated your*:*:{
  ; LogDCC.log 5NOTICE: $nick ( $+ $chan $+ ) $1-
}

on *:NOTICE:*fail*:*:{
  LogDCC.log 4FAIL-NOTICE: $nick ( $+ $chan $+ ) $1-
}

on *:DCCSERVER:CHAT:{
  LogDCC.log CHAT REQ $nick $1-
}

on *:DCCSERVER:FSERVE:{
  LogDCC.log FSERVE REQ $nick $1-
}

on *:DCCSERVER:SEND:{
  LogDCC.log SEND REQ $nick $filename $1-
}

on *:OPEN:!:{
  LogDCC.log FILESERVER OPEN: $nick $1-
}

on *:CLOSE:!:{
  LogDCC.log FILESERVER CLOSE: $nick $1-
}

on *:OPEN:=:{
  LogDCC.log DCCCHAT OPEN: $nick $1-
}

on *:CLOSE:=:{
  LogDCC.log DCCCHAT CLOSE: $nick $1-
}

;$get(N/nick,[N])
;Returns the nickname and filename of the Nth open dcc get window.
;Properties: ip, status, file, path, size, rcvd, cps, pc
;$get(0)         returns the total number of open dcc gets.
;$get(2)         returns the nickname of the 2nd dcc get.
;$get(2).rcvd  returns the number of bytes received for the 2nd dcc get.
;$get(2).cps   returns the character per second rate for the 2nd dcc get.
;$get(3).pc     returns the percent complete of transfer for the 3rd dcc get.

on *:FILESENT:*:{
  LogDCC.log 3Sent file to [ $+ 12< $+ $nick $+ >] in $duration($send(-1).secs) @3 $bytes($send(-1).cps,k3).suf $+ /sec - 14 $+ $filename $1-
}

on *:FILERCVD:*:{
  LogDCC.log 3Get file from [ $+ 12< $+ $nick $+ >] in $duration($get(-1).secs) @4 $bytes($get(-1).cps,k3).suf $+ /sec - 14 $+ $filename $1-
}

on *:SENDFAIL:*:{
  LogDCC.log 4Send FAILED $send(-1).status [ $+ 4< $+ $nick $+ >] $send(-1).sent sent 14 $+ $filename $1-
}

on *:GETFAIL:*:{
  LogDCC.log 4Get FAILED $get(-1).status [ $+ 4< $+ $nick $+ >] $get(-1).rcvd received 14 $+ $filename $1-
}

on *:ERROR:*:{
  LogDCC.log 6IRC ERROR $1- - $matchtext
}

;=================================
alias LogDCC.log {
  ; #### Prepare a COPY of the original string for processing ####
  %dcclog.temp1 = $strip($lower( $1- ))
  if (!dcclog? = %dcclog.temp1) { 
    msg $nick 3DCCLog $+ $chr(160) $+ (Ver. $+ %dcclog.ver $+ ) is active 
    return
  }

  DCCLog.Check $1-

  return

  ; #### Filter Basic Strings ####
  if (! = $left(%dcclog.temp1,1)) { return }
  if (dcc send = $left(%dcclog.temp1,8)) { return }
  if ( isin %dcclog.temp1) { return }
  if (ne><gen isin %dcclog.temp1) { return }
  if ($chr(160) isin $1-) { return } 

  ; #### Filter using Combined Statements - Dynamic Filters ####
  if (($me isin %dcclog.temp1) && (recieved isin %dcclog.temp1)) { return }
  if ((auto isin %dcclog.temp1) && (sending isin %dcclog.temp1)) { return }
  if (((you isin %dcclog.temp1) && (just isin %dcclog.temp1)) && (received isin %dcclog.temp1)) { return }

  ; #### Filter Script-Strings ####
  ;    Send-Errors
  if (not found isin %dcclog.temp1) { return }
  if (try again later isin %dcclog.temp1) { return }
  if (i have sent isin %dcclog.temp1) { return }
  if (send of isin %dcclog.temp1) { return }
  if (already getting isin %dcclog.temp1) { return }
  ;  if (fail = $left(%dcclog.temp1,8)) { return }

  ;    Send-Start
  if (here is a file from isin %dcclog.temp1) { return }
  if (found! isin %dcclog.temp1) { return }
  if (match found isin %dcclog.temp1) { return }
  if (been put on isin %dcclog.temp1) { return }

  ;    Auto-Messages
  if (offers: isin %dcclog.temp1) { return }
  if (sent since isin %dcclog.temp1) { return }
  if (has served isin %dcclog.temp1) { return }
  if (NOTICE: isin %dcclog.templ) { return }
  if (press f7 to isin %dcclog.temp1 ) { return }
  if (thank you for isin %dcclog.temp1) { return }
  if (thanks for isin %dcclog.temp1 ) { return }

  ; #### Filters done ####
}
;=================================
alias DCCLog.Check {
  if ( $window( @DCCLog) != @DCCLog ) {  
    ; ====== CREATE WINDOW AND INIT LOGFILE IF NEEDED =======
    window -nb @DCCLog 5 205 600 100 verdana 11
    ; e = editbox h = hide n = minimize b = update h-pos
    %dccLog.Logfilename  =  $logdir $+ DCCLog_ $+ $asctime(yyyymm) $+ .log
    if ( $exists( %dccLog.Logfilename ) == $false ) {
      if ( %dccLog.Logfilename != $null ) { write " $+ %dccLog.Logfilename $+ " Creating Log $date $time }
      aline -p @DCCLog 12Logfile Created : %dccLog.Logfilename 
    }
    else {
      if ( %dccLog.Logfilename != $null ) { write " $+ %dccLog.Logfilename $+ " Appending Log $date $time }
      aline -p @DCCLog 12Logfile appended : %dccLog.Logfilename 
    }
  }
  ; ================ EXECUTE EVERY TIME ===================
  aline -p @DCCLog $timestamp 4 $+ [ $+ $network $+ ]  $1-
  titlebar @DCCLog -- $timestamp $+ [ $+ $PS_network $+ ] < $+ $nick $+ > $strip( $1- )
  if ( %dccLog.Logfilename != $null ) { write " $+ %dccLog.Logfilename $+ " $timestamp $ps_network < $+ $nick $+ > $strip( $1- ) }
  ; flash @DCCLog : $timestamp  < $+ $nick $+ > $strip( $1- )
}

;----------------------
; self -serve this script
;----------------------

on *:TEXT:*sendme dcclog:*: {
  if ($me == $1) {
    timer555 1 4 notice $nick DCC sending you the DCClog $dcclog.version (use a recent mIRC-version)
    timer556 1 8 dcc send $nick " $+ $script $+ "
  }
}

on *:TEXT:*version*dcclog:*: {
  timer557 1 4 notice $nick DCClog - %dcclog.version
}
