
; PhotoServe 4.20

/****************************************************************************************
* <b>PS_Install</b>
* <p>
* <h4>Goals</h4><ul>
* <li>A more flexible way to install the PhotoServe Files
* <li>Update and fresh install should work in the same way
* <li>A web update function that can fetch only the required changed or new files
* </ul>
*
* <h4>Signals</h4>
* There are several signals sent during update or install. The idea is that each PS module takes care
* of the work that is required to be done for an update
* <ul>
* <li><b>PSUPDATESTART %win</b> is sent when there is an update to be installed.
* <li><b>PSUPDATEDONE</b> is sent when the updated files are all installed. This is the event
*  that should be handled like the ON START event. PS_Install has such an event as an example.
* <li><b>PSUPDATEPROBLEM %file</b> is sent when the install function was not able to replace a %file
*     this is only called if the file needs to be replaced (like if source and target is the same)
*     and it was not possible. The update is retried 100 times every few seconds. So there is time to shut down.
* </ul>
*
* <h4>How it works</h4>
*  The update works now with 2 required files. the <b>!installlist</b> and <b>ps_install.loc<b>. Both files are deleted after install.
*  <ul>
*  <li><b>!installlist</b> holds the list of photoserve relevant files. This list is generated by the makeupdate perl script
*          but it can also be done manualy by listing all files from the rar. Only files in this list are handled during install.
*          Otherwise general rules for locations (*.exe) would move mirc.exe or mirc.ini or other unexpected files in mirc dir.
*  <li><b>ps_install.loc</b> This file holds the location of all files. Since it is done with patterns there is no need to 
*       change anything to include new files in the future. Just add a new mrc script to the developers folder and it is installed
*       and loaded as long as it matches a pattern in this file.  
*  </ul>
*  
*  <b>pserve_*</b> files are treated additionaly different. All script files that start with pserve_ that are loaded and NOT in the  <b>!installlist</b> 
*   are unloaded and deleted. This means when renaming a script the old file will automaticaly be deleted and the new is installed without any changes
*   required to the install file. <br>
*   All files in PhotoServe Folder are loaded automatically. Either add code to unload it on the PSUPDATEDONE signal or move it to the addon location 
*          if it is not desired to be loaded all the time. During install it is loaded and it can perform some install only work.
*
* <p>
* Primary contact for bugs/questions/suggestions: _store_
*/




;; every time the script is manualy loaded OR still loaded in mirc the update is Started
ON *:START: {

  ; check for configured mirc
  if (!$me) {
    echo $ps_n -at --> 4Error: You must configure mirc before loading PhotoServe.
    goto error
  }

  ; check for correct mirc version
  if (($version < 6.3) || (!$version)) {
    echo $ps_n -at --> 4Error: This Script needs mIRC version 6.3 or newer.  Please upgrade if you want to use PhotoServe.
    goto error
  }

  ; Check for supported windows version
  if ($os isin :95:98:NT:ME:) {
    echo $ps_n -at --> 4Error: This Script requires Windows 2000 or newer. Please upgrade if you want to use PhotoServe.
    goto error
  }

  ; ##### Check for /run command #####
  if ($lock(run)) {
    echo $ps_n -at --> You must enable the /run command if you want to use PhotoServe.
    var %error = $true
  }
  if ($lock(dll)) {
    echo $ps_n -at --> You must enable the /dll command if you want to use PhotoServe.
    var %error = $true
  }

  if (%error) goto error

  var %s = $script(0)
  while (%s) {
    if (($script(%s) !== $script) && ($nopath($script(%s)) == $nopath($script))) .timer 1 0 unload -rs $qt($script(%s))
    dec %s 
  }

  .timer 1 0 InstallUpdate
  return
  :error
  .unload -rs $qt($script)
}


;; this installs the full PS by using the  ps_install.loc file and all files in $mircdir
alias InstallUpdate {
  var %listfile = $mircdir $+ !installlist
  if (!$Locate().check || !$exists(%listfile)) {
    echo -sat PhotoServe Install Not Possible.  Required Files are not found. ( %listfile or ps_install.loc )
    echo -sat Only loading pserve files... Stand By 
    LoadScriptFiles
    signal PSUPDATEDONE
    halt
  }
  var %win = @PSUPDATE
  window -hl -t50 %win
  loadbuf -r %win $qt(%listfile)

  ;; we need to check what pserve_* files are no longer in the update and are already loaded so 
  ;; we can auto remove and unload them just by the fact that they are not included
  var %scripts = $script(0)
  if ($hget(PSUPDATEPURGE)) hfree PSUPDATEPURGE
  hmake PSUPDATEPURGE
  while (%scripts) {
    var %script = $script(%scripts)
    dec %scripts
    var %scriptname = $nopath(%script)
    if ($left(%scriptname,7) == pserve_) hadd PSUPDATEPURGE %scriptname %script
  }
  var %dir = $nofile($Locate($nopath($script)))
  var %files = $findfile(%dir,pserve*.mrc,0,1)
  while (%files) {
    var %script = $findfile(%dir,pserve*.mrc,%files,1)
    dec %files
    var %scriptname = $nopath(%script)
    if ($left(%scriptname,7) == pserve_) hadd PSUPDATEPURGE %scriptname %script
  }

  var %delfiles = $false
  ;; check the install file list
  var %line = $line(%win,0)
  while (%line) {
    var %name = $deltok($line(%win,%line),2-,9)
    if (pserve*.mrc iswm %name) var %delfiles = $true
    var %source = $mircdir $+ %name
    var %target = $Locate(%name)
    if ($nopath(%target)) hdel PSUPDATEPURGE $ifmatch
    if ((%target == %source) || (!%target)) dline %win %line
    else  rline %col %win %line $+(%source,$chr(9),%target)
    dec %line
  }

  ;; if we had a pserve*.mrc file included in this update (there might be non pserve files updates)
  ;; all pserve*.mrc files are deleted that are not included in the update
  if (%delfiles) {
    var %remove = $hget(PSUPDATEPURGE,0).item
    while (%remove) {
      var %delfile = $hget(PSUPDATEPURGE,%remove).data
      dec %remove
      if ($script(%delfile)) unload -rs $qt(%delfile)
      remove -b $qt(%delfile)
    }
  }
  if ($hget(PSUPDATEPURGE)) hfree PSUPDATEPURGE

  ;; send a signal so all loaded scripts can kill tasks or stop work..
  .signal PSUPDATESTART %win

  ;; try for 6 minutes to install all files.. (every 6 seconds)
  timerpsinstall -o 60 6 ProcessUpdate %win
  return
  :error
  unload -rs $qt($script)
}


;; this is a local Alias but it cannot be set to Local due the self-reloading of the script during install
alias ProcessUpdate {
  var %win = $1
  if ($window(%win)) {
    var %lines = $line(%win,0)
    while (%lines) {
      var %line = $line(%win,%lines)

      var %source = $gettok(%line,1,9) , %target = $gettok(%line,2,9)
      if ($file(%source)) {
        ;echo -st Update07 %source -->07 %target 5(From line %lines $+ ) 
        var %good = $InstallFile(%source,%target,$Locate($nopath(%target)).mode)
        if (%good) dline %win %lines
      }
      ;; not existing source files are removed
      else dline %win %lines
      dec %lines  
    }

    if (!$line(%win,0)) {
      echo -set all file operations done. closing window. 
      window -c %win
      goto end    
    }

  }
  else goto end

  if ($ctimer) {
    var %timerid = $timer(0)
    while (%timerid) {
      if ($ctimer == $timer(%timerid)) break
      dec %timerid
    }

    if ($timer(%timerid).reps) echo -set Timer $timer(%timerid) is repeated $ifmatch times before giving up
    else goto error
  }

  return
  :error
  echo -set ProcessUpdate gave up on trying and will now try to continue...
  window -a %win
  titlebar %win Installer Failed to install these files.
  :end
  timer $+ $ctimer off
  LoadScriptFiles
  LoadTriggers 
  .signal PSUPDATEDONE
}

alias -l LoadScriptFiles {
  echo -set Loading of scriptfiles starting ...
  var %dir = $nofile($Locate($nopath($script)))
  if (!%dir) var %dir = $nofile($script)
  window -lh @load
  var %foundmax = $findfile(%dir,pserve*.mrc,0,@load,1)
  var %found = 0

  while (%found < %foundmax) {
    inc %found
    var %script = $line(@load,%found)
    if ($script == %script) echo -set install script detected and skipped: %script
    elseif ($isScriptLoaded($nopath(%script))) {
      var %old = $ifmatch
      ;echo -st Found %old for %script
      if (%old == %script) .reload -rs $+ %found $qt(%script)
      else {
        ; echo -set old %old is somewhere else.. must be removed
        .unload -rs $qt(%old)
        remove -b $qt(%old)
        .reload -rs $+ %found $qt(%script)
      }
    }
    else {
      ;; this is a new file load. but loading it would trigger the start event.. we send a signal at the end to all scripts to init
      reload -rs $+ %found $qt(%script)
    }
  }
  echo -set Loading of scriptfiles done... 
  :error
  window -c @load
}

alias -l LoadTriggers {
  if ($findfile($mircdir,*.trm,1,0)) {
    echo -st Loading/Updating/Installing of Triggers starting...
    var %file = $PSTC_UpdateTriggers
    echo -st Loading of Triggers done.
    echo -st Trigger Update result: $read(%file,1)
    .remove $qt(%file)
  }
}
alias -l delfile {
  var %file = $1-
  if ($exists(%file)) .remove $qt(%file)
  return
  :error
  reseterror
}

;; installs a file. return @boolean shows success
alias -l InstallFile {
  var %source = $1 , %target = $2 , %mode = $3

  var  %targetpath = $nofile(%target)
  if (!$exists(%targetpath)) CreatePath %targetpath

  var %loaded = $isScriptLoaded($nopath(%target))
  var %ok = $false
  if (($script == %source) || ($script == %target)) {
    ;; this file is me ..
    ;    if ($crc(%source) !== $crc(%target)) {
    if ($exists(%source)) {
      ;in 1 ms remove the old target
      if ($exists(%target)) timerbootstrapcleanup 1 2 remove -b $qt(%target)
      ; in 900 ms move ourself to the target place and reload immediatly (or the Mirc Dialog pops up)
      timerbootstrapinstall 1 4 rename $qt(%source) $qt(%target) $chr(124) reload -rs $qt(%target)
      echo -set Bootstrap activated.. (Script is unloaded and reloaded in 4 seconds)
      unload -rs $qt($script)
      ;after self unloading the script ends here.. 
    }
    elseif ($script == %target) delfile %source
    %ok = $true
  }
  elseif (%mode == 1) {
    var %ok = $UpdateIni(%source,%target)
    if (%ok) {
      .remove $qt(%source)
      echo -st %target 13was Updated with UpdateIni()
    }
  }
  elseif ($exists(%target)) {
    ; there is already some target file  there 
    ; in mode 2 we dont update at all   OR  if the file is the same 
    if ((%mode == 2) || ($crc(%source) == $crc(%target))) {
      echo -st %target not needed. 3removing source file
      .remove $qt(%source)
      %ok = $true
    }
    else {
      .remove $qt(%target)
      .rename $qt(%source) $qt(%target)
      echo -st %target 6replaced and new file installed
      if ($script(%target)) {
        reload -rs $qt(%target)
      }
      %ok = $true
    }
  }
  else {
    ; target does not exist
    .rename $qt(%source) $qt(%target)
    echo -st %target 7installed
    %ok = $true
  }


  if ((%ok) && (%loaded)) {
    if (%loaded !== %target) {
      echo -set script %target was previously loaded at %loaded .. cleaning up now
      unload -rs $qt(%loaded)
      remove -b $qt(%loaded)
      reload -rs $qt(%target)
    }
  }

  :error
  if ($error) {
    echo -> Installer waiting ->15 $error <- Try to correct the error.
    .signal PSUPDATEPROBLEM %target
    reseterror
  }
  return %ok
}

;for some reason $script(name) does not work in here.. 
alias -l isScriptLoaded {
  var %name = $1
  var %c = $script(0)
  while (%c > 0) {
    if ($nopath($script(%c)) == %name) return $script(%c)
    dec %c
  }
  return $false
}


;; updates existing fields from source to dest without removing additional sections and fields
alias -l UpdateIni {
  var %source = $1 , %dest = $2
  if (($isfile(%source)) && ($isfile(%dest))) {
    var %maxsource = $ini(%source,0)
    var %i = 0
    while (%i < %maxsource) {
      inc %i
      var %sec = $ini(%source,%i)
      var %maxinsec = $ini(%source,%i,0)
      var %j = 0
      while (%j < %maxinsec) {
        inc %j
        var %name = $ini(%source,%i,%j)
        var %val = $readini(%source,n,%sec,%name)
        writeini -n $qt(%dest) %sec %name %val
      }
    }
  }
  else .copy -o $qt(%source) $qt(%dest)
  return $true
  :error
  echo -set cant UpdateIni() %source -> %dest
  reseterror
  return $false
}



;; creates the full path of \ separated folders. does not matter if trailing \ exists @return void
alias -l CreatePath {
  var %path = $1-
  var %sect = $numtok(%path,92)
  var %i = 1
  while (%i < %sect) {
    inc %i
    var %what = 1- $+ %i
    var %md = $gettok(%path,%what,92)
    if (!$exists(%md)) mkdir $qt(%md)
  }
  echo -set Created path %path
}

;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;

; stop the download and reset everything 
alias PS_DownloadUpdateReset {
  unset -s %ps_update_url
  sockclose PSUPDOWNLOAD
  unload -rs $qt($script)
}

alias PS_DownloadUpdate {
  var %downloadurl = $1-
  if (%ps_update_url) {
    echo -set Download of Update already running.. try again later or type /PS_DownloadUpdateReset and try again. 
    return
  }
  ;; unset the var after 1 hour (it has failed then for sure). startdownload() will close the Socket
  set -u3600 %ps_update_url %downloadurl
  startdownload !installlist.zip
}


;; downloads from the %ps_update_url the file
alias -l startdownload {
  var %what = $1-
  set %update_what %what
  var %file = $mircdir $+ %update_what
  delfile %file
  sockclose PSUPDOWNLOAD
  http_get PSUPDOWNLOAD $geturl(%update_what)
  ;; will continue at on sockread events and end with on sockclose
}

on *:signal:HttpErr_PSUPDOWNLOAD:{
  var %retrytime = $rand(10,100)
  echo -set HTTP connection error : $1- (auto retry in %retrytime seconds)
  ; try again in %retrytime seconds
  .timer 1 %retrytime startdownload %update_what
}

on *:sockread:PSUPDOWNLOAD: {
  if ($sockerr > 0) { 
    echo -set Sockerror $sockerr from $sockname
    return
  }
  var %file = $mircdir $+ %update_what
  :nextread
  sockread &temp
  if ($sockbr > 0) {
    if (%ps_showdownload) echo -st read06 $bvar(&temp,0) bytes from5 $sockname while downloading from07 %update_what to06 %file
    bwrite $qt(%file) -1 &temp
    goto nextread
  }
}

on *:sockclose:PSUPDOWNLOAD: {
  var %file = $mircdir $+ %update_what
  unset %update_what
  echo -set download of06 %file complete with05 $bytes($file(%file),k).suf
  sockclose $sockname
  var %win = @PSUPDATE
  ;; uncompress the file if necessary here ... 
  if ($right(%file,4) == .zip) {
    var %temp = $mircdir $+ PSUPDATE $ticks $+ \
    mkdir $qt(%temp)
    var %r = $PS_Decompress(keep,%file,%temp)
    var %found = $findfile(%temp,*,1)
    delfile %file
    var %file = $nofile(%file) $+ $nopath(%found)
    delfile %file
    .rename $qt(%found) $qt(%file)
    var %r = $findfile(%temp,*,0,delfile $1-)
    rmdir $qt(%temp)
  }

  echo -st processing07 %file (size $bytes($file(%file),k).suf $+ )

  ;; continue using the uncompressed file
  if ($nopath(%file) == !installlist) {
    window -lh %win
    loadbuf -r %win $qt(%file)
    ;; need to check what we have and what we need

    var %lines = $line(%win,0)
    while (%lines) {
      var %line = $line(%win,%lines)
      var %file = $gettok(%line,1,9)
      if (%file == ps_install.loc) {
        var %url = $gettok(%line,6,9)
        echo -st found initial needed file ... %file at %url 
        startdownload %url
        break
      }

      dec %lines
    }
    ;; start to get the first file...
  }
  elseif ( ($Locate().check) && ($window(%win))) {
    var %wasupdate = $nopath(%file)
    ;; checking all required files left in %win
    var %lines = $line(%win,0)
    while (%lines) {
      var %line = $line(%win,%lines)
      var %file = $gettok(%line,1,9)
      if ($isBetterVersion($gettok(%line,2,9),$gettok(%line,3,9),$gettok(%line,4,9)).issame) {
        var %crc = $base($gettok(%line,5,9),16,10)

        var %downloaded = $mircdir $+ $nopath(%file)

        if ($base($crc(%downloaded),16,10) !== %crc) {
          var %installed = $Locate($nopath(%file))
          var %mode = $Locate($nopath(%file)).mode
          var %iscrc = $base($crc(%installed),16,10)

          if ((%mode == 2) && (%iscrc)) {
            echo -st installed file %file 05OK(mode2) 15( $+ %installed $+ )
            dline %win %lines
          }
          elseif (%iscrc !== %crc) {

            if (%wasupdate == $nopath(%file)) {
              echo -st download of %file 04NOT OK 15( $+ %downloaded $+ )
              ;; this is to prevent continued download of the same wrong file. if it was downloaded and it does not match we give up here
              dline %win %lines

            }
            else {
              var %url = $gettok(%line,6,9)
              echo -set must download file06 %file from07 %url
              startdownload %url
              halt
            }
          }

          else {
            echo -st installed file %file 03OK 15( $+ %installed $+ )
            dline %win %lines
          }
        }
        else {
          echo -st download of %file 10OK 15( $+ %downloaded $+ )
          dline %win %lines
        }

      }
      else {
        echo -st version of %file 2is too low.
        dline %win %lines
      }

      dec %lines
    }


    echo -set 3Download COMPLETE We are done.. we reach this point ONLY when all files are downloaded OR crc matching
    ;; cleanup
    window -c %win
    unset %ps_update_url 

    ;; run the install function (from this script, it will auto reload a possible new one)
    echo -set The install will start in 10 seconds... Hang on
    .timer 1 10 InstallUpdate

  }
  else echo --> something is wrong !! locationfile: $Locate().check

}

;; @return Boolean
alias -l isBetterVersion {
  var %vmaj = $1 , %vmin = $2 , %vbeta = $3
  var %this = $PS.Version.main , %thisb = $PS.Version.beta
  var %tmaj = $gettok(%this,1,46) , %tmin = $gettok(%this,2,46) , %tbeta = $right(%thisb,-2)
  if (!%tbeta) var %tbeta = 0
  if (%vmaj > %tmaj) return $true
  if ((%vmaj == %tmaj) && (%vmin > %tmin)) return $true
  if ((%vmaj == %tmaj) && (%vmin == %tmin) && (%vbeta > %tbeta)) return $true
  if ((%vmaj == %tmaj) && (%vmin == %tmin) && (%vbeta == %tbeta) && ($prop == issame)) return $true
  return $false
}

alias -l GetUrl {
  var %url = $1
  if ($left(%url,5) == http:) return %url
  if (%ps_update_url) return %ps_update_url $+ %url
}

/* checks the ps_install.txt to find out the correct location of the file..
* @prop mode
* @prop check 
* @return String
*/
alias -l Locate {
  var %file = $1
  var %installfile = $mircdir $+ ps_install.loc
  if ($prop == check) return $exists(%installfile)
  var %return = $Null
  if ($file(%installfile)) {
    .fopen IN $qt(%installfile)
    while (!$fopen(IN).eof) {
      var %read = $fread(IN)
      tokenize 9 %read
      if (!$1) continue
      if ($left($1,1) == ;) continue
      if ($1 iswm %file) {
        if ($prop == mode) var %return = $3
        else var %return = $mircdir $+ $2 $+ %file
        break
      }
    }

  }
  :error
  if ($fopen(IN)) .fclose IN
  return %return
}

on *:SIGNAL:PSUPDATESTART:{
  ;; close all existing dialog windows...  before update
  var %dialog = $dialog(0)
  while (%dialog) {
    echo -set closing dialog %dialog -> $dialog(%dialog)
    dialog -x $dialog(%dialog)
    dec %dialog
  }
}

on *:SIGNAL:PSUPDATEDONE:{
  echo -set Script $script detected PS Update - cleaning up and reinitializing...

  delfile $mircdir $+ ps_install.loc
  delfile $mircdir $+ !installlist


  ;  ########
  ;  ########  TAKEN from the OLD install mrc .. should be moved away from here...

  ; ##### Check DCC ALLOW list for .rar / .zip / .gz / .flt #####
  if (.rar !isin $readini(mirc.ini,n,text,accept)) writeini mirc.ini text accept $+($readini(mirc.ini,n,text,accept),$chr(44),*.rar)
  if (.zip !isin $readini(mirc.ini,n,text,accept)) writeini mirc.ini text accept $+($readini(mirc.ini,n,text,accept),$chr(44),*.zip)
  if (.gz !isin $readini(mirc.ini,n,text,accept)) writeini mirc.ini text accept $+($readini(mirc.ini,n,text,accept),$chr(44),*.gz)
  if (.flt !isin $readini(mirc.ini,n,text,accept)) writeini mirc.ini text accept $+($readini(mirc.ini,n,text,accept),$chr(44),*.flt)

  ; ##### Set important settings #####
  if (!%PS.date) set %PS.date $asctime($ctime,yyyy/mmm/dd  HH:nn:ss)
  if (!%PS.wintrigwin) set %PS.wintrigwin 8 24 745 340
  if (!%PS.wintrigwinfont) set %PS.wintrigwinfont Verdana 12
  if (!%PS.sortfiles) set %PS.sortfiles Yes
  if (!%PS.usepleech) set %PS.usepleech Yes
  if (!%PS.hidepathmsg) set %PS.hidepathmsg No
  if (!%PS.duperetry) set %PS.duperetry 5
  if (!%PS.busyretry) set %PS.busyretry 30
  if (!%PS.getfaildelay) set %PS.getfaildelay 5
  if (!%PS.getdelay) set %PS.getdelay 5
  if (!%PS.shownotfound) set %PS.shownotfound Yes
  if (!%PS.notfound) set %PS.notfound 5
  if (!%PS.notfounddelay) set %PS.notfounddelay 5
  if (!%PS.checkfreespace) set %PS.checkfreespace 20
  if (!%PS.leechlim) set %PS.leechlim 1000
  if (!%PS.lch.sfp.restart) set %PS.lch.sfp.restart ON
  if (!%PS.makedownp) set %PS.makedownp Yes

  if (!%PS.notfoundtotal) set %PS.notfoundtotal 5
  if (!%PS.notfoundwait) set %PS.notfoundwait 10
  if (!%PS.maxcrcsearch) set %PS.maxcrcsearch 10
  if (!%PS.whereis.getmsg) set %PS.whereis.getmsg I am trying to quit leeching.
  if (!%PS.whereis.sendmsg) set %PS.whereis.sendmsg Hey vampires. I still have blood.
  if (!%PS.whereis.eqmsg) set %PS.whereis.eqmsg To Leech or not to Leech, That is the question.

  if (!%PS.whereisformat) set %PS.whereisformat Ip
  elseif (%PS.whereisformat == No) {
    set %PS.whereisformat Ip
    set %PS.maskip $true
  }
  if (!%ps.dccserverport) { set %ps.dccserverport endrange | PS_InitDccServer }

  if (!%PS.dbl.s.wi) set %PS.dbl.s.wi None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ $date
  if (!%PS.dbl.s.ldtop5) set %PS.dbl.s.ldtop5 None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0
  if (!%PS.dbl.s.lwtop5) set %PS.dbl.s.lwtop5 None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0 $+ $chr(124) $+ None $+ $chr(124) $+ 0

  if ((!%PS.trigger) || ($left(%PS.trigger,1) != !) || (%PS.trigger == !) || ($chr(35) isin %PS.trigger)) {
    if ($mnick) set %PS.trigger ! $+ $ifmatch
    elseif ($anick) set %PS.trigger ! $+ $ifmatch
    elseif ($me) set %PS.trigger ! $+ $ifmatch
  }
  if ((!%PS.Speed) || (%PS.Speed == n/a)) $PS_SpeedDialog(%ps_a)
  if (!%PS.downp) set %PS.downp $$sdir="Select Download Folder" $getdir(*.jpg)
  if (!%PS.csvdir) set %PS.csvdir $$sdir="Set .CSV folder" $getdir

  if (%ps.appearance.dialogs.listcolor == $null)  set %ps.appearance.dialogs.listcolor  default default
  if (%ps.appearance.dialogs.showgrid == $null)   set %ps.appearance.dialogs.showgrid   $false
  if (%ps.appearance.nickcolor.nontrade == $null) set %ps.appearance.nickcolor.nontrade $true
  if (%ps.appearance.nickcolor.clist == $null)    set %ps.appearance.nickcolor.clist    4:13:12:10:3:7:9:5:3:3
  if (%ps.appearance.nickcolor.enabled == $null)  set %ps.appearance.nickcolor.enabled  $true
  if (%ps.appearance.hide.voice == $null)         set %ps.appearance.hide.voice         $false
  if (%ps.appearance.hide.botgreet == $null)      set %ps.appearance.hide.botgreet      $false
  if (%ps.appearance.hide.whereis == $null)       set %ps.appearance.hide.whereis       $false
  if (%ps.appearance.hide.trigger == $null)       set %ps.appearance.hide.trigger       $false
  if (%ps.appearance.hide.trignews == $null)      set %ps.appearance.hide.trignews      $false
  if (%ps.appearance.hide.trigstatus == $null)    set %ps.appearance.hide.trigstatus    $false
  if (%ps.appearance.hide.statsmaker == $null)    set %ps.appearance.hide.statsmaker    $false
  if (%ps.appearance.hide.xferstats == $null)     set %ps.appearance.hide.xferstats     $false
  if (%ps.appearance.hide.bwstats == $null)       set %ps.appearance.hide.bwstats       $false
  if (%ps.appearance.hide.collstats == $null)     set %ps.appearance.hide.collstats     $false
  if (%ps.appearance.hide.sysinfo  == $null)      set %ps.appearance.hide.sysinfo       $false
  if (%ps.appearance.offnotify == $null)          set %ps.appearance.offnotify          $true
  if (%ps.appearance.ondesktop.pscc == $null)     set %ps.appearance.ondesktop.pscc     $true
  if (%ps.appearance.ondesktop.dialogs == $null)  set %ps.appearance.ondesktop.dialogs  $true
  if (%ps.appearance.ondesktop.triglist == $null) set %ps.appearance.ondesktop.triglist $false
  if (%ps.appearance.ondesktop.servinfo == $null) set %ps.appearance.ondesktop.servinfo $false
  if (%ps.appearance.ondesktop.whereis == $null)  set %ps.appearance.ondesktop.whereis  $false
  if (%ps.debug.gets == $null)                    set %ps.debug.gets                    $false
  if (%ps.debug.gets_all == $null)                set %ps.debug.gets_all                $false
  if (%ps.debug.whereis == $null)                 set %ps.debug.whereis                 $false

  ;  #############
  ;  #############




  ; ##### Show changelog #####
  window -l @PS_ChangeLog
  .timer 1 1 loadbuf -r @PS_ChangeLog $qt($PS_ReadMeDir $+ PS_ChangeLog.txt)

  ;events are not turned off.. this is just if the user turned them off
  events on
  ;ctcps are not turned off.. this is just if the user turned them off
  ctcps on

  echo -set End. All files installed. $script is unloading now
  ;; unload myself at the end
  unload -rs $qt($script)
}
