
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



alias PS_BrowsePath {
  var %ps_a = PS_BrowsePath
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($1 == 886) var %ps_browse_path = $sdir($scriptdir,Select The Backup Directory.)
  else var %ps_browse_path = $sdir($scriptdir,Select The Download Path.)
  if (%ps_browse_path == $null) return
  did -ra PS_Dlg_AX $1 %ps_browse_path
  if ($1 == 508) { set %PS.csvdir $PS_MakePath(%ps_browse_path) | saveini }
  if ($1 == 886) set %PS.backup.path $PS_MakePath(%ps_browse_path)
}



; ##### alias's #####
alias PS_MakePath {
  var %path = $noqt($1-)
  var %ps_a = PS_MakePath
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * %path

  ; %path = Directory
  if ((!$isdir(%path)) && ($pos(%path,:\,1) == 2)) {
    var %ps_subdirs = $numtok(%path,92)
    var %ps_counter = 2
    while (%ps_counter <= %ps_subdirs) {
      if (!$isdir($gettok(%path,1- $+ %ps_counter,92))) .mkdir $+(",$gettok(%path,1- $+ %ps_counter,92),")
      inc %ps_counter
    }
  }
  return %path
}
/****
* list channels, checks nick permissions, gets channel config. 
* @optparam command possible commands are: voice active check, "voice" returns the voice (yes|no) setting for the channel. "active" and "check" are commands for "list" channel
* @param channel either the #channelname or "list" to list all. for list it can be command "active" to list all active channels. ELSE it will list all channels where PS is configured
* @optparam nick if channel is "list" and command is "check" the "nick" will be checked and "yes" or "no" is returned if user has leech permissions
* @optparam skipcheckchannel if option is set this channel will not be checked. (only implemented for backward compatibility, unsure where used)
* @return String yes|no|$Null
*/

alias PS_Channel {
  var %channel = $1 , %command = $2 , %nick = $3 , %skipcheckchannel = $4
  var %ps_channelfile = $PS_ChannelsFile(PS_Channel)

  if (%command == voice) return $readini(%ps_channelfile,n,%channel,#voice)
  elseif (%channel = list) {

    if (%command == active) {
      ;; list all active channels
      var %max = $chan(0)
      var %i = 0
      while (%i < %max) {
        inc %i
        var %chan = $chan(%i)
        var %list = %list $+ $iif(%list,$chr(59) $+ %chan,%chan)
      }
      return %list
    }
    elseif (%command = check) {
      ;;; check if %Nick is allowed for leeching me
      if ( $me == %nick ) return Yes
      var %max = $ini(%ps_channelfile,0)
      var %i = 0
      while (%i < %max) {
        inc %i
        var %chan = $ini(%ps_channelfile,%i)
        if (%skipcheckchannel == %chan) continue
        if ($nick(%chan,%nick) !== $Null) {
          ;; user is in this channel
          if ($readini(%ps_channelfile,n,%chan,#status) !== OFF) {
            ;; channel is turned on in PS
            if ($readini(%ps_channelfile,n,%chan,#voice) != OFF) {
              if ((%nick !isreg %chan) || ($readini(%ps_channelfile,n,%chan,%nick) == Yes)) return Yes
            }
            else return Yes
          }
        }
      }
      return No
    }
    else {
      ;; just list all channels from %ps_channelfile
      var %max = $ini(%ps_channelfile,0)
      var %i = 0
      while (%i < %max) {
        inc %i
        var %chan = $ini(%ps_channelfile,%i)
        var %list = %list $+ $iif(%list,$chr(59) $+ %chan,%chan)
      }
      return %list
    }


  }
  else return $readini(%ps_channelfile,n,%channel,#status)

}



alias PS_ChannelOP {
  var %ps_a = PS_ChannelOP
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_channelfile = $PS_ChannelsFile(PS_ChannelOP)

  if ($1 = list) {
    var %ps_channel.stat = NO
    if ($2 != active) var %ps_channel_total = $ini(%ps_channelfile,0)
    else var %ps_channel_total = $chan(0)
    var %ps_channel_loop = 0
    :loop
    inc %ps_channel_loop
    if (%ps_channel_loop > %ps_channel_total) goto end
    if ($2 == check) {
      if ($4 == $ini(%ps_channelfile,%ps_channel_loop)) goto loop
      if (($nick($ini(%ps_channelfile,%ps_channel_loop),$3) != $null) && ($readini(%ps_channelfile,n,$ini(%ps_channelfile,%ps_channel_loop),#status) != OFF)) {
        if ($3 isop $ini(%ps_channelfile,%ps_channel_loop)) return Yes
      }
      goto loop
      :end
    }
  }
}


alias PS_SetNickSend {
  var %ps_a = PS_SetNickSend
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_SetNickSend)
  var %ps_setnicksend_data = $2-
  var %ps_setnicksend_total = $numtok(%ps_setnicksend_data,59)
  while (%ps_setnicksend_total > 0) {
    var %ps_setnicksend_read = $gettok(%ps_setnicksend_data,%ps_setnicksend_total,59)
    var %ps_setnicksend_1 = $gettok(%ps_setnicksend_read,1,58)
    var %ps_setnicksend_2 = $gettok(%ps_setnicksend_read,2,58)
    if ($ps_netWork_send(PS_SetNickSend,%ps_setnicksend_1,0) < 1) {
      var %ps_setnicksend_num = $findtok($($+(%,ps.,%ps_network,.nicksend),2),$+(%ps_setnicksend_1,$chr(58),%ps_setnicksend_2),1,59)
      var %ps_setnicksend_data = $deltok(%ps_setnicksend_data,%ps_setnicksend_num,59)
    }
    dec %ps_setnicksend_total
  }
  if (%ps_setnicksend_data != $null) set $+(%,ps.,%ps_network,.nicksend) %ps_setnicksend_data
  if ($ps_netWork_send(PS_SetNickSend,0) == 00) unset [ $+(%,ps.,%ps_network,.nicksend) ]
}



alias PS_LastDL {
  var %ps_a = PS_LastDL
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  haltdef
  if ($PS_Channel(list,check,$1) == Yes) {
    var %ps_last_dl = $asctime($readini($PS_ReadIni($2,findfile,11),n,$2,lastdl))
    if (%ps_last_dl == $null) var %ps_last_dl = n/a
    .notice $1 10Last Download for07 $2 10was07 %ps_last_dl 10Currently its07 $asctime($ctime)
  }
}



alias PS_LastSend {
  var %ps_a = PS_LastSend
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  haltdef
  if ($PS_Channel(list,check,$1) == Yes) {
    var %ps_last_send = $asctime($readini($PS_ReadIni($2,findfile,12),n,$2,lastsend))
    if (%ps_last_send == $null) var %ps_last_send = n/a
    .notice $1 10Last Send for07 $2 10was07 %ps_last_send
  }
}



alias PS_Count {
  var %ps_a = PS_Count
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  haltdef
  if ($PS_Channel(list,check,$1) == Yes) {
    if ($2 == *) $PSTC_IterateAllTrigs(PsMassCount, async, PSTC_Count)
    else $PSTC_Count($2)
    .notice $1 10OK updating Count for07 $2
  }
}



alias PS_Off_Reason {
  var %ps_a = PS_OffReason
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_settingsfile = $PS_ServeSettings(PS_Off_Reason)
  if ($readini(%ps_settingsfile,n,#Status,#Reason) != $null) {
    var %ps_reason = $readini(%ps_settingsfile,n,#Status,#Reason)
    if (Auto On isin %ps_reason) return My Triggers are OFF, %ps_reason Current Time $asctime(HH:nn)
    else return My Triggers are OFF, %ps_reason
  }
  else return My triggers are OFF, N/A
}




; ##### Path alias's #####
alias PS_ScriptDir {
  var %ps_a = PS_ScriptDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if (" isin %PS.scriptdir) set %PS.scriptdir $remove(%PS.scriptdir,")
  if ((~1 isin %PS.scriptdir) || (%PS.scriptdir == $null)) {
    if (\PhotoServe isin $scriptdir) set -s %PS.scriptdir $scriptdir
    else set -s %PS.scriptdir $+($mircdir,PhotoServe\)
  }
  if (!$isdir(%PS.scriptdir)) {
    mkdir " $+ %PS.scriptdir $+ "
  }
  return " $+ %PS.scriptdir
}



alias PS_SettingsDir {
  var %ps_a = PS_SettingsDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_scriptdir = $PS_ScriptDir(%ps_a)

  var %ps_temp = %ps_scriptdir $+ Settings\
  if (!$isdir(%ps_temp)) {
    mkdir %ps_temp $+ "
    var %ps_temp_total = $findfile(%ps_scriptdir,PS_ServeSettings*.ini,0,1)
    while (%ps_temp_total > 0) {
      var %ps_temp_find = $findfile(%ps_scriptdir,PS_ServeSettings*.ini,%ps_temp_total,1)
      copy -o $+(",%ps_temp_find,") $+(%ps_temp,$nopath(%ps_temp_find),")
      remove $+(",%ps_temp_find,")
      dec %ps_temp_total
    }
    var %ps_temp_total = $findfile(%ps_scriptdir,PServeChannels*.ini,0,1)
    while (%ps_temp_total > 0) {
      var %ps_temp_find = $findfile(%ps_scriptdir,PServeChannels*.ini,%ps_temp_total,1)
      copy -o $+(",%ps_temp_find,") $+(%ps_temp,$nopath(%ps_temp_find),")
      remove $+(",%ps_temp_find,")
      dec %ps_temp_total
    }
  }
  var %ps_temp_total = $findfile(%ps_scriptdir,PServe*.ini,0,1)
  while (%ps_temp_total > 0) {
    var %ps_temp_find = $findfile(%ps_scriptdir,PServe*.ini,%ps_temp_total,1)
    remove $+(",%ps_temp_find,")
    dec %ps_temp_total
  }
  var %ps_temp_total = $findfile(%ps_scriptdir,PSleechHist*.ini,0,1)
  while (%ps_temp_total > 0) {
    var %ps_temp_find = $findfile(%ps_scriptdir,PSleechHist*.ini,%ps_temp_total,1)
    remove $+(",%ps_temp_find,")
    dec %ps_temp_total
  }
  return %ps_temp
}



alias PS_ServeSettings {
  var %ps_a = PS_ServeSettings
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_ServeSettings)
  var %ps_check_file = $PS_SettingsDir(PS_ServeSettings) $+ PServeSettings_ $+ %ps_network $+ .ini $+ "
  if (!$isfile(%ps_check_file)) {
    $PS_Write(PS_ServeSettings,%ps_check_file)
    var %ps_temp = $PS_SetSendTotal(%ps_a)
    var %ps_temp = $PS_SetSendLimit(%ps_a)
    var %ps_temp = $PS_SetQueueTotal(%ps_a)
    var %ps_temp = $PS_SetQueueLimit(%ps_a)
  }
  return %ps_check_file
}



alias PS_PserveCheckDir {
  var %ps_a = PS_PserveCheckDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_PserveCheckDir) $+ PserveCheck\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_PSCProDir {
  var %ps_a = PS_PSCProDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_PSCProDir) $+ PSCPro\
  ; if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_WhereIsPing {
  var %ps_a = PS_WhereIsPing
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($readini($PS_ServeSettings(PS_WhereisPing),n,#whereis,#ping) == OFF) return OFF
  else return ON
}



alias PS_WhereIsPingTime {
  var %ps_a = PS_WhereIsPingTime
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_settingsfile = $PS_ServeSettings(PS_WhereIsPingTime)
  if ($1 == $null) var %ps_temp = $readini(%ps_settingsfile,n,#WhereIs,#PingTime)
  if (%ps_temp == $null) {
    if ($1 != $null) var %ps_temp = $1
    else var %ps_temp = 20
    $PS_WriteIni(PS_WhereIsPingtime,%ps_settingsfile,#WhereIs,#PingTime,%ps_temp)
  }
  if ($1 == $null) return %ps_temp
}






alias PS_ChannelsFile {
  var %ps_a = PS_ChannelsFile
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_ChannelsFile)
  var %ps_check_file = $PS_SettingsDir(PS_ChannelsFile) $+ PServeChannels_ $+ %ps_network $+ .ini $+ "
  return %ps_check_file
}



alias PS_HistFile {
  var %ps_a = PS_HistFile
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_HistFile)
  var %ps_check_file = $PS_SettingsDir(PS_HistFile) $+ PServeLeechHist_ $+ %ps_network $+ .ini $+ "
  if (!$isfile(%ps_check_file)) $PS_Write(PS_HistFile,%ps_check_file)
  return %ps_check_file
}



alias PS_TriggersDir {
  var %ps_a = PS_TriggersDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_TriggersDir) $+ Triggers\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}


alias PS_UnloadedTriggersDir {
  var %ps_a = PS_UnloadedTriggersDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_UnloadedTriggersDir) $+ UnloadedTriggers\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}




alias PS_FiltersDir {
  var %ps_a = PS_FiltersDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_FiltersDir) $+ Filters\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_IconDir {
  var %ps_a = PS_IconDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_IconDir) $+ Icons\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_UploadDir {
  var %ps_a = PS_UploadDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_UploadDir) $+ Upload\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_ListDir {
  var %ps_a = PS_ListDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_ListDir) $+ SavedLists\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_DllDir {
  var %ps_a = PS_DllDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_DllDir) $+ Programs\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return $remove(%ps_check_file,")
}



alias PS_ProgramDir {
  var %ps_a = PS_ProgramDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_ProgramDir) $+ Programs\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_TrigDir {
  var %ps_a = PS_TrigDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_TrigDir) $+ SavedTrigs\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}

alias PS_Par2Dir {
  var %ps_a = PS_Par2Dir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_Par2Dir) $+ Par2s\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}

alias PS_Par2RepairDir {
  var %ps_a = PS_Par2RepairDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_DownLoadDir(PS_HaveDir) $+ PSPar2_ForRepairs\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}

alias PS_DownLoadDir {
  var %ps_a = PS_DownLoadDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = " $+ %ps.downp
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}


alias PS_HaveDir {
  var %ps_a = PS_HaveDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_HaveDir) $+ SavedHave\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_HaveSavedDir {
  var %ps_a = PS_HaveSavedDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_HaveSavedDir) $+ SavedHaveLists\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_SplashDir {
  var %d = $+($PS_ScriptDir,Splash,\)
  if (!$isdir(%d)) mkdir %d $+ "
  return %d
}



alias PS_TmpDir {
  var %ps_a = PS_TmpDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-
  var %ps_check_file = $PS_ScriptDir(PS_TmpDir) $+ Temp\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_BackupDir {
  var %ps_a = PS_BackupDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_BackupDir) $+ SavedBackups\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_ReadMeDir {
  var %ps_a = PS_ReadMeDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_AddonDir) $+ ReadMe\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}



alias PS_AddonDir {
  var %ps_a = PS_AddonDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_check_file = $PS_ScriptDir(PS_AddonDir) $+ PSadd-ons\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}


alias PS_DownloadLogDir {
  var %ps_check_file = $PS_ScriptDir $+ DownloadLogs\
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}


alias PS_StatsDir {
  var %dir = $PS_ScriptDir $+ Stats\
  if (!$isdir(%dir)) mkdir %dir $+ "
  return %dir
}


alias PS_Location {
  var %ps_a = PS_Location
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $window($1).x $window($1).y $window($1).w $window($1).h
}



alias PS_Font {
  var %ps_a = PS_Font
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $window($1).font $window($1).fontsize
}



alias PS_NetWork {
  var %ps_a = PS_Network
  if (%ps_debug_alias != $null) echo 9 -st * %ps_a * $1-

  if ($network != $null) return $network
  if ($network == $cid) return PhotoServe
  if ($server != $null) {
    if (.undernet.org isin $server) return UnderNet
    if (.fef.net isin $server) return FEFnet
    if (.accessirc.net isin $server) return AccessIRC
    if (.dal.net isin $server) return DALnet
  }
  return PhotoServe
}



alias PS_GetAllSends {
  var %ps_a = PS_GetAllSends
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $gettok($readini($mircini,n,options,n2),21,44)
}



alias PS_Ports {
  var %ps_a = PS_Ports
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp = $readini(" $+ $mircdir $+ mirc.ini",n,options,n4)
  return $gettok(%ps_temp,13,44) $+ - $+ $gettok(%ps_temp,26,44)
}



alias PS_SetStatusDialog {
  var %ps_a = PS_SetStatusDialog
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_total = $scon(0)
  var %ps_count = 1
  while (%ps_count <= %ps_total) {
    if ($scon(%ps_count).network == $1) {
      scid $scon(%ps_count) PS_SetStatus PS_SetStatusDialog $2 $3
    }
    scid -r
    inc %ps_count
  }
  var %ps_file = $PS_SettingsDir(PS_SetStatusDialog) $+ PServeSettings_ $+ $1 $+ .ini"
}



alias PS_SetStatus {
  var %ps_a = PS_SetStatus
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network
  var %ps_settingsfile = $PS_ServeSettings(PS_SetStatus)
  if ($2 == Get) {
    if ($readini(%ps_settingsfile,n,#Status,#OnOff) == Off) return OFF
    else return ON
  }
  if ($2 == ON) {
    $PS_RemIni(PS_SetStatus,%ps_settingsfile,#Status,#OnOff)
    $PS_RemIni(PS_SetStatus,%ps_settingsfile,#Status,#Reason)
    saveini
  }
  else {
    $PS_WriteIni(PS_SetStatus,%ps_settingsfile,#Status,#OnOff,Off)
    PSE_ClearQueue
    $PS_FileStatsHashSave(PS_SetStatusDialog,,%ps_network)
    if ($3 == YES) {
      var %ps_temp = $??="Enter a reason"
    }
    if ($3 == Auto) {
      var %ps_temp = $4
    }
    if (%ps_temp == $null) var %ps_temp = n/a
    $PS_WriteIni(PS_SetStatus,%ps_settingsfile,#Status,#Reason,%ps_temp)
    if ($1 == PS_SetStatusDialog) did -f PS_Dlg_AX 361
    saveini
  }
}



alias PS_SetTrigMsg {
  var %ps_a = PS_SetTrigMsg
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_settingsfile = $PS_ServeSettings(PS_SetTrigMsg)
  if ($2 == Set) {
    if ($3 != $null) $PS_WriteIni(PS_SetTrigMsg,%ps_settingsfile,#Status,#TrigMsg,$3)
    else $PS_RemIni(PS_SetTrigMsg,%ps_settingsfile,#Status,#TrigMsg)
  }
  else {
    return $readini(%ps_settingsfile,n,#Status,#TrigMsg)
  }
}



alias PS_NickRemove {
  var %ps_a = PS_NickRemove
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,|,@,[,&,],+,^,~)
}



alias PS_NickReplace {
  var %ps_a = PS_NickReplace
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,@,|,&,[,+,],~,^)
}



alias PS_NickServSend {
  var %ps_a = PS_NickServSend
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,|,_,[,_,],_,^,_,~,_,-,_)
}



alias PS_TrigReplace {
  var %ps_a = PS_TrigReplace
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,^,_)
}



alias PS_PathRemove {
  var %ps_a = PS_PathRemove
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,$chr(44),$chr(47))
}



alias PS_PathReplace {
  var %ps_a = PS_PathReplace
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $replace($1,$chr(47),$chr(44))
}



alias PS_RemoveSpaces {
  var %ps_a = PS_RemoveSpaces
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  return $1-
}



alias PS_SettingsRem {
  var %ps_a = PS_SettingsRem
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp = $findfile($PS_SettingsDir(PS_SettingsRem),$1 $+ *.ini,0,PS_SettingsDel $1-)
}



alias PS_SettingsDel {
  var %ps_a = PS_SettingsDel
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  .remove " $+ $1- $+ "
}



; ##### Send/Get/Fserve #####
alias PS_Network_Fserv {
  var %ps_a = PS_Network_Fserv
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp_nick_count = 0
  var %ps_temp_return = 00
  var %ps_temp_total = $fserv(0)
  var %ps_temp_count = 1
  while (%ps_temp_count <= %ps_temp_total) {
    if ($fserv(%ps_temp_count).cid == $cid) {
      if (($2 isnum) && (($left($3,1) == .) || ($3 == $null))) {
        if ($2 == 0) inc %ps_temp_return
        if ($2 > 0) {
          inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $2) {
            return $($+($,fserv,$chr(40),%ps_temp_count,$chr(41),$3),2)
          }
        }
      }
      if (($3 isnum) && (($left($4,1) == .) || ($4 == $null))) {
        if ($3 == 0) {
          if ($fserv(%ps_temp_count) == $2) inc %ps_temp_return
        }
        if ($3 > 0) {
          if ($fserv(%ps_temp_count) == $2) inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $3) {
            return $($+($,fserv,$chr(40),%ps_temp_count,$chr(41),$4),2)
          }
        }
      }
    }
    inc %ps_temp_count
  }
  return %ps_temp_return
}



alias PS_Network_Get {
  var %ps_a = PS_Network_Get
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp_nick_count = 0
  var %ps_temp_return = 00
  var %ps_temp_total = $get(0)
  var %ps_temp_count = 1
  while (%ps_temp_count <= %ps_temp_total) {
    if ($get(%ps_temp_count).cid == $cid) {
      if (($2 isnum) && (($left($3,1) == .) || ($3 == $null))) {
        if ($2 == 0) inc %ps_temp_return
        if ($2 > 0) {
          inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $2) {
            return $($+($,get,$chr(40),%ps_temp_count,$chr(41),$3),2)
          }
        }
      }
      if (($3 isnum) && (($left($4,1) == .) || ($4 == $null))) {
        if ($3 == 0) {
          if ($get(%ps_temp_count) == $2) inc %ps_temp_return
        }
        if ($3 > 0) {
          if ($get(%ps_temp_count) == $2) inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $3) {
            return $($+($,get,$chr(40),%ps_temp_count,$chr(41),$4),2)
          }
        }
      }
      if (($left($3,1) == .) && ($4 != $null)) {
        var %ps_get_count = 1
        var %ps_get_total = $send($2,0)
        while (%ps_get_count <= %ps_get_total) {
          if ($get($2,%ps_get_count).file == $4) {
            return $($+($,get,$chr(40),$2,$chr(44),%ps_get_count,$chr(41),$3),2)
          }
          inc %ps_get_count
        }
      }
    }
    inc %ps_temp_count
  }
  return %ps_temp_return
}



alias PS_Network_Send {
  var %ps_a = PS_Network_Send
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp_nick_count = 0
  var %ps_temp_return = 00
  var %ps_temp_total = $send(0)
  var %ps_temp_count = 1
  var %ps_temp_cid = $cid
  while (%ps_temp_count <= %ps_temp_total) {
    if ($send(%ps_temp_count).cid == $cid) {
      if (($2 isnum) && (($left($3,1) == .) || ($3 == $null))) {
        if ($2 == 0) inc %ps_temp_return
        if ($2 > 0) {
          inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $2) {
            return $($+($,send,$chr(40),%ps_temp_count,$chr(41),$3),2)
          }
        }
      }
      if (($3 isnum) && (($left($4,1) == .) || ($4 == $null))) {
        if ($3 == 0) {
          if ($send(%ps_temp_count) == $2) inc %ps_temp_return
        }
        if ($3 > 0) {
          if ($send(%ps_temp_count) == $2) inc %ps_temp_nick_count
          if (%ps_temp_nick_count == $3) {
            return $($+($,send,$chr(40),%ps_temp_count,$chr(41),$4),2)
          }
        }
      }
      if (($left($3,1) == .) && ($4 != $null)) {
        var %ps_send_count = 1
        var %ps_send_total = $send($2,0)
        while (%ps_send_count <= %ps_send_total) {
          if ($send($2,%ps_send_count).file == $4) {
            return $($+($,send,$chr(40),$2,$chr(44),%ps_send_count,$chr(41),$3),2)
          }
          inc %ps_send_count
        }
      }
    }
    inc %ps_temp_count
  }
  return %ps_temp_return
}



alias PS_Crc {
  var %ps_a = PS_Crc
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($1 == $null) return
  if (!$isfile($1)) return
  return $crc($1)
}



alias PS_CrcCheck {
  var %ps_a = PS_CrcCheck
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($2 == $null) return
  var %ps_len = $len($2)
  if (%ps_len == 8) return $2
  elseif (%ps_len < 8) return $str(0,$calc(8 - %ps_len)) $+ $2
  elseif (%ps_len > 8) return $left($2,8)
}



alias PS_AboutEchoClose {
  if ($dialog(PS_AboutDialog)) dialog -x PS_AboutDialog
  if ($dialog(PS_SampleDlg)) dialog -x PS_SampleDlg
}


alias PS_n return $color(notify text).dd
alias PS_h return $color(highlight text).dd
alias PS_i return $color(info2 text).dd
alias PS_k return $color(kick text).dd

alias PS_kn return  $+ $color(notify text).dd
alias PS_kh return  $+ $color(highlight text).dd
alias PS_ki return  $+ $color(info2 text).dd



;;;;;;;;;;;;;;;;;; A MINI UPLOAD SYSTEM FOR DISTRIBUTION

on 1:FILESENT:*:{
  var %win = $SUWindow 
  if (!$window(%win)) return
  if ($issending($nick,$filename)) {
    $delFile($nick,$filename)
    PS_StartSpecialUpload
  }

}
on 1:SENDFAIL:*:{
  var %win = $SUWindow 
  if (!$window(%win)) return
  if ($issending($nick,$filename)) {
    $issending($nick,$filename,0)
    PS_StartSpecialUpload
  }
}

on *:NICK: ChangeNickName $SUWindow $nick $newnick


alias PS_QueueFileToNick {
  var %nick = $1 , %channel = $2 , %file = $3-

  var %win = $SUWindow
  if (!$window(%win)) window %win

  var %l = $SearchNickLine(%nick,%win)

  if (!%l) {
    aline %win %nick
    %l = $line(%win,0)
  }

  var %line = $line(%win,%l)
  var %files = $addtok($gettok(%line,2,9),$+(%file,*,%channel,*0),63)
  rline %win %l $iif($numtok(%line,9) > 1,$puttok(%line,%files,2,9),$addtok(%line,%files,9))
}

alias PS_StartSpecialUpload {
  var %num = $1 
  if (!%num) var %num = 1 

  while (%num > 0) {
    dec %num
    if ($getnextunsend) {
      var %result = $ifmatch
      var %nick = $gettok(%result,1,32)
      var %file = $gettok(%result,2-,32)
      $issending(%nick,%file,1)
      ;      if (%nolimit) 
      ;      var %ip = $PS_DataPortDBAccess(%nick,dccport)
      echo -set sending %file to %nick ( %ip )
      .dcc send -cnm $iif(%ip,%ip,%nick) $+(",%file,")
      ;     else  var %res = $PSE_RegisterAndSend(%nick,na:na,!PSGET,%file,$file(%file).size,SpecialUpload)
      ;  var %nick = $1 , %ip = $2 , %req = $3 , %file = $4 , %size = $5 , %trigger = $6
    }
    else return
  }
}


; Changes the nickname from old to new in the window "where" @param swin searchwindowname send|queue @return void 
alias -l ChangeNickName {
  var %swin = $1 , %old = $2 , %new = $3
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %nick = $gettok(%line,1,9)
    if (%nick == %old) rline %swin %sendcur $puttok(%line,%new,1,9)
    dec %sendcur
  }
}

alias -l getnextunsend {
  var %window = $SUWindow

  var %i = $line(%window,0)
  while (%i > 0) {
    var %line = $line(%window,%i)
    var %nick = $gettok(%line,1,9)
    echo -set checking %Nick in line %line ( %i )
    var %files = $gettok(%line,2,9)
    var %max = $numtok(%files,63)
    var %j = 0
    while (%j < %max) {
      inc %j
      var %filerec = $gettok(%files,%j,63)
      var %sent = $gettok(%filerec,3,42)
      if (!%sent) {
        var %chan = $gettok(%filerec,2,42)
        if (%nick ison %chan) return %nick $gettok(%filerec,1,42)
      }
    }
    dec %i 
  }
}

alias -l issending {
  var %nick = $1 , %file = $2 , %yn = $3

  var %win = $SUWindow
  if ($SearchNickLine(%nick,%win)) {
    var %l = $ifmatch
    if ($isAsend(%nick,%file)) {
      var %t = $ifmatch
      var %line = $line(%win,%l)
      var %files = $gettok(%line,2,9)
      var %new = $gettok(%files,%t,63)
      var %mode = $gettok(%new,3,42)
      if (%yn == $null) return %mode
      %new = $puttok(%new,%yn,3,42)
      %files = $puttok(%files,%new,%t,63)
      rline %win %l $puttok(%line,%files,2,9)
    }
  }
}

alias -l delFile {
  var %nick = $1 , %file = $2
  var %win = $SUWindow
  if ($SearchNickLine(%nick,%win)) {
    var %l = $ifmatch
    if ($isAsend(%nick,%file)) {
      var %t = $ifmatch
      var %line = $line(%win,%l)
      var %files = $gettok(%line,2,9)
      if ($numtok(%files,63) > 1) rline %win %l $puttok(%line,$deltok(%files,%t,63),2,9)
      else {
        dline %win %l
        if ($line(%win,0) < 1) window -c %win
      }
    }
  }
}

alias -l isAsend {
  var %nick = $1 , %file = $2
  var %win = $SUWindow
  if (!$window(%win)) return
  var %l = $SearchNickLine(%nick,%win)
  if (%l) {
    var %files = $gettok($line(%win,%l),2,9)
    var %max = $numtok(%files,63)
    while (%max > 0) {
      var %list = $gettok(%files,%max,63)
      if ($gettok(%list,1,42) == %file) return %max
      dec %max
    }
  }
  return 0
}

alias -l SUWindow {
  return @SpecialUpload_ $+ $PS_Network
}

alias -l SearchNickLine {
  var %nick = $1 , %window = $2
  var %i = $line(%window,0)
  while (%i > 0) {
    var %line = $line(%window,%i)
    if ($gettok(%line,1,9) == %nick) return %i
    dec %i 
  }
  return 0
}
