
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

; #####Loading the leech windows #####
alias PS_LeechLimits {
  var %ps_network = $ps_network(LeechOpen)

  ; ##### Determine Max Sends #####
  ; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
  var %ps_globalcurrent = $window($+(@PSleech_,*),0)
  var %ps_leech_current = $window($+(@PSleech_,%ps_network,_,*),0)

  var %ps_sends_max = $PS_SetSendTotal
  var %ps_leech_limit = %ps_sends_max

  if ($PS_CheckNetWorkChannelLeechLimits) var %ps_globallimit = $ifmatch
  else {
    ; ##### Determine Complete Triggers Online #####
    ; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
    var %ps_gbcredit_calc = $calc($PSTC_TriggerStats(AllChannels).creditbytes / 1024^3)
    var %ps_globallimit = $PS_LeechLimit_Calc(%ps_gbcredit_calc)
  }

  ; ##### Calculate Max Allowed Leech Windows #####
  ; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
  if (%ps_leech_limit > %ps_globallimit) var %ps_leech_limit = %ps_globallimit

  ; ##### Return values for allowed leeches  #####
  ; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
  if ($1 == return) {
    return %ps_leech_limit %ps_globallimit
  }

  echo $ps_n -st --> Based on the $+ $ps_ki lower of your 3Max Sends on %ps_network $+ : $+ $ps_kh %ps_sends_max and 3Complete Online Triggers: $+ $ps_kh %ps_gbcredit_calc you qualify to run a total of:
  echo $ps_n -st --> $+ $ps_kh %blkblk Leech Window(s) on $+ $ps_kh %ps_network $+ .  Current Leech Window(s) in use:03 %ps_leech_current of04 %blkblk
  echo $ps_n -st --> $+ $ps_kh %ps_globallimit Leech Window(s) on $+ $ps_kh All Networks Combined. Current Leech Window(s) in use:03 %ps_globalcurrent of04 %ps_globallimit

  if ($2 == PS_Dlg_AX) {
    return
  }

  ; ##### Process Leech Status and allow or deny a leech #####
  ; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
  if (%ps_leech_current >= %ps_limit_leech) return Stop
  if (%ps_globalcurrent >= %ps_globallimit) return Stop
  return Go
}



; ##### Calculate Max Allowed Leech Windows #####
; ##### Disabling or Modifying the Leech Limitations built into PhotoServe will earn you a permanent ban.  NO excuses. #####
alias PS_LeechLimit_Calc {
  if ($1 >= 500) return 15
  if ($1 >= 400) return 12
  if ($1 >= 300) return 10
  if ($1 >= 240) return 9
  if ($1 >= 190) return 8
  if ($1 >= 140) return 7
  if ($1 >= 100) return 6
  if ($1 >= 70)  return 5
  if ($1 >= 45)  return 4
  if ($1 >= 25)  return 3
  if ($1 >= 10)  return 2
  if ($1 >= 2)   return 1
  if ($1 >= 0)   return 0
  return -1
}



alias PS_LeechOpen {
  var %ps_a = PS_LeechOpen
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)

  if ($PS_CheckVersion != go) goto end
  if ($2 == $me) goto end
  if ($PS_SetStatus(%ps_a,Get) == OFF) { echo $ps_n -sat --> PhotoServe $+ $ps_kh OFF Leech $+ $ps_kh $5 Killed. | goto end }
  if (($1 == -) && (%PS.sortfiles == No)) { echo -st 10Automatic Leeching when the AutoSort Leech option is 4OFF10 is not allowed.  Please start a manual leech. | goto end }

  var %ps_ip = $PS_ReturnIp(%ps_a)

  var %ps_giglimit = $PS_DialogGigCurrentCount(%ps_a,get,return)
  if ($gettok(%ps_giglimit,1,32) == off) {
    echo $ps_n -sat --> 4Leech Stopped.  You have reached your user defined gig limit of $+ $ps_kh $PS_FileSize($gettok(%ps_giglimit,2,32),2) for today.
    return
  }

  if (($window($5) == $5) && ($5 != $null)) {
    var %ps_leech_window = $5
    goto LimitSkip
  }

  var %ps_leechlimit = $PS_LeechLimits(%ps_a)
  if (%ps_leechlimit != Go) {
    $PS_LeechKillMsg
    goto end
  }
  :LimitSkip

  if ($2 != $null) set %ps_leech_nick $2
  else set %ps_leech_nick $dialog(PS_Nick,PS_Nick)
  if (%ps_leech_nick == $null) goto end
  if ($3 != $null) set %ps_leech_trigger $3
  else set %ps_leech_trigger $??="What is the nicks trigger"
  if (%ps_leech_trigger == $null) goto end
  if ($4 != $null) set %ps_leech_seriestrigger $4
  else set %ps_leech_seriestrigger $??="What is the series trigger"
  if (%ps_leech_seriestrigger == $null) set %ps_leech_seriestrigger -
  if (%ps_leech_seriestrigger != -) {
    set %ps_leech_fileexists $PS_ListDir $+ %ps_leech_seriestrigger $+ .txt"
    set %ps_leech_fileexists2 $PS_ListDir $+ %ps_leech_seriestrigger $+ _miss.txt"
    if ($readini($PS_ReadIni(%ps_leech_seriestrigger,findfile,33),n,%ps_leech_seriestrigger,path) == $null) {
      echo $ps_n -sat --> You cannot leech $+ $ps_kh %ps_leech_seriestrigger with out setting it up first.  Photoserve did not find a path setup for this trigger.
      goto end
    }
  }
  if (%PS.leech.refilter.type != $null) {
    set %ps_leech_type %PS.leech.refilter.type
    unset %PS.leech.refilter.type
    goto skiptype
  }
  if ((($isfile(%ps_leech_fileexists)) && ($lines(%ps_leech_fileexists) > 0) && (%ps_leech_fileexists != $null)) || (($isfile(%ps_leech_fileexists2)) && (%ps_leech_fileexists2 != $null))) {
    set %ps_leech_saved $?!="Do you want to load the saved list?"
    if (%ps_leech_saved == $true) {
      set %ps_leech_filename saved
    }
    else goto dialog
    goto load
  }
  :dialog
  set %ps_leech_type $dialog(PS_OpenLeech,PS_OpenLeech)
  :skiptype
  if (%ps_leech_type == $null) goto end
  set %PS.leech.window.type %ps_leech_type
  if (%ps_leech_type == pathfile) {
    set %PS.usecrc NO
    set %PS.usepath Yes
  }
  if (%ps_leech_type == file) {
    set %PS.usecrc NO
    set %PS.usepath NO
  }
  if (%ps_leech_type == pathcrc) {
    set %PS.usecrc Yes 
    set %PS.usepath Yes
  }
  if (%ps_leech_type == crc) {
    set %PS.usecrc YES 
    set %PS.usepath NO
  }
  set %ps_leech_fileexists $PS_ReadIni(%ps_leech_seriestrigger,rep)
  if ($isfile(%ps_leech_fileexists)) {
    if ($PS_LeechCheckMissing(" $+ %ps_leech_fileexists $+ ",%ps_leech_seriestrigger) != go) goto end
    set %ps_leech_filename " $+ %ps_leech_fileexists $+ "
    set %PS.leech.filename %ps_leech_filename
    goto pleech
  }
  :set
  $PSTC_ConfigureReport(%ps_leech_seriestrigger)
  set %ps_leech_filename " $+ $PSTC_GetReport(%ps_leech_seriestrigger) $+ "
  if (%ps_leech_filename == $null) goto end
  if ($PS_LeechCheckMissing(%ps_leech_filename,%ps_leech_seriestrigger) != go) goto end
  set %PS.leech.filename %ps_leech_filename
  ;This is for a Misc Colllection
  if (%ps_leech_seriestrigger == -) {
    goto pleech
  }
  if ($right(%ps_leech_filename,5) == .txt") $PS_WriteIni(%ps_a,$PS_ReadIni(%ps_leech_seriestrigger,findfile,34),%ps_leech_seriestrigger,rep,%ps_leech_filename)
  :pleech
  set %ps_leech_checkforpleech $PS_ProgramDir $+ pserve.dll"
  if ((!$isfile(%ps_leech_checkforpleech)) && (%PS.usepleech != NO)) { echo $ps_n -sat --> Pserve.dll 4NOT FOUND please make sure it is in the directory $+ $ps_kh $remove($PS_ProgramDir,") }
  if (($isfile(%ps_leech_checkforpleech)) && (%PS.usepleech != NO)) {
    set %ps_leech_havecheck $PS_HaveSavedDir $+ $remove($PS_TrigReplace(%ps_leech_trigger),!) $+ _HAVE_ $+ %ps_leech_seriestrigger $+ .txt"
    if ($isfile(%ps_leech_havecheck)) set %ps_leech_havefile %ps_leech_havecheck
    if (%ps_leech_havefile == $null) set %ps_leech_havefile " "
    set %ps_leech_filtered $PS_ProgramDir $+ LOAD.TXT"
    if (%ps_leech_type == pathcrc) var %temp = $dll($PS_ProgramDir $+ pserve.dll",PleechPathCRC, [ %ps_leech_filename %ps_leech_havefile %ps_leech_filtered ] )
    elseif (%ps_leech_type == crc) var %temp = $dll($PS_ProgramDir $+ pserve.dll",PleechCRC, [ %ps_leech_filename %ps_leech_havefile %ps_leech_filtered ] )
    elseif (%ps_leech_type == file) var %temp = $dll($PS_ProgramDir $+ pserve.dll",PleechFile, [ %ps_leech_filename %ps_leech_havefile %ps_leech_filtered ] )
    else var %temp = $dll($PS_ProgramDir $+ pserve.dll",Pleech, [ %ps_leech_filename %ps_leech_havefile %ps_leech_filtered ] )
    if (%ps_leech_window != $null) $PS_LeechLoadWindow(%ps_leech_nick,%ps_leech_trigger,%ps_leech_seriestrigger,%ps_leech_window,filtered,%ps_leech_filtered,%ps_leech_filename)
    else $PS_LeechLoadWindow(%ps_leech_nick,%ps_leech_trigger,%ps_leech_seriestrigger,filtered,%ps_leech_filtered,0,%ps_leech_filename)
    goto end
  }
  :load
  if (%ps_leech_window != $null) $PS_LeechLoadWindow(%ps_leech_nick,%ps_leech_trigger,%ps_leech_seriestrigger,%ps_leech_window,%ps_leech_filename)
  else $PS_LeechLoadWindow(%ps_leech_nick,%ps_leech_trigger,%ps_leech_seriestrigger,%ps_leech_filename)
  :end
}

alias PS_LeechKillMsg {
  var %ps_a = PS_LeechKillMsg
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  echo $ps_n -sat --> 4LEECH ERROR Your leech was stopped since you are over your allowed Network and or Global Leech Limits.
  dialog -m PS_KillOKButton PS_KillOKButton
}

dialog PS_KillOKButton {
  size -1 -1 200 100
  title Leech Error
  button "OK",1,60 60 80 20, OK
  text "No more Leech Windows available",2,20 10 170 15
  text "Check mIRC's Status Window for info",3,10 30 200 15
}

dialog PS_MissingOKButton* {
  size -1 -1 200 100
  button "OK",1,60 75 80 20, OK
  text "* LEECH ERROR *",2,45 10 170 15
  text "",3,20 30 170 40
}


alias PS_LeechLoadWindow {
  var %ps_a = PS_LeechLoadWindow
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  unset %ps_leech_*
  var %ps_leech_getallsends = $PS_GetAllSends
  var %ps_leech_serversends = $PS_ServerSends
  var %ps_leech_servernetworks = $PS_ServerNetworks
  var %ps_leech_ports = $PS_Ports

  var %ps_leech_servercap = $calc(%ps_leech_serversends + %ps_leech_servernetworks)
  if (%ps_leech_getallsends < %ps_leech_servercap) {
    if (%ps_leech_getallsends < 50) {
      if ($dialog(PS_SendsOKButton) == $null) {
        dialog -m PS_SendsOKButton PS_SendsOKButton
        did -a PS_SendsOKButton 3 You must set your Tools, Options, Dcc, Options, Max
        did -a PS_SendsOKButton 4 Sends to: %ps_leech_servercap OR Greater
        did -a PS_SendsOKButton 5 to Leech.  All Leeches Stopped.
      }
      echo $ps_n -sat --> 4REQUIREMENT You must set your 4Tools, Options, Dcc, Options, Max Sends: to $+ $ps_kh %ps_leech_servercap OR Greater to Leech.
      goto last
    }
  }

  var %ps_leech_servercap = $calc($gettok(%ps_leech_ports,2,45) - $gettok(%ps_leech_ports,1,45))
  if (%ps_leech_servercap < %ps_leech_getallsends) {
    if (%ps_leech_servercap < 50) {
      if ($dialog(PS_SendsOKButton) == $null) {
        dialog -m PS_SendsOKButton PS_SendsOKButton
        did -a PS_SendsOKButton 3 You must set your Tools, Options, Connect, Options, Advanced
        did -a PS_SendsOKButton 4 Dcc Ports First: $gettok(%ps_leech_ports,1,45) Last: $calc($gettok(%ps_leech_ports,1,45) + %ps_leech_getallsends)
        did -a PS_SendsOKButton 5 to Leech.  All Leeches Stopped.
      }
      echo $ps_n -sat --> 4REQUIREMENT You must set your 4Tools, Options, Connection, Options, Advanced, Dcc Ports: $+ $ps_kh First: $gettok(%ps_leech_ports,1,45) Last: $calc($gettok(%ps_leech_ports,1,45) + %ps_leech_getallsends)  IF you use a router you MUST set this same port range in the router for your sends to work correctly.
      goto last
    }
  }

  if ($PS_SetStatus(PS_LeechLoadWindow,Get) == OFF) goto last
  if ($1 == $null) goto last
  if ($4 == PSREC) goto recursive
  if ($window($4) == $4) {
    var %ps_leech_windowcheck = Yes
    var %ps_leech_window = $4
    goto window
  }
  ;  Determine next available leech window number
  var %ps_leech_winnumber = 0
  :newwindow
  inc %ps_leech_winnumber
  var %ps_leech_wintest = $+(@PSleech_,%ps_network,_,%ps_leech_winnumber)
  if ($window(%ps_leech_wintest) == $null) {
    var %ps_leech_window = %ps_leech_wintest
    unset [ $+(%,psleech_,%ps_network,_,%ps_leech_winnumber,_,*) ]
    set $+(%,psleech_,%ps_network,_,%ps_leech_winnumber,_getmode) %PS.leech.mode
    set $+(%,psleech_,%ps_network,_,%ps_leech_winnumber,_type) %PS.leech.window.type
    set $+(%,psleech_,%ps_network,_,%ps_leech_winnumber,_badcrc) 0
    unset %PS.leech.window.type
  }
  else goto newwindow
  ;Check if a Misc Collection first
  ; if (($3 != -) && (%PS.el-toro.disable != OFF)) var %ps_leech_etsearch = $PS_El-ToroCSVSearch(leech,$3,$nopath($PS_ReadIni($3,findfile,35)),%ps_leech_window)
  ; Build a new leech window
  if (%PS.leech.windowpram == $null) set %PS.leech.windowpram -lark0
  window %PS.leech.windowpram %ps_leech_window %PS.winleechloc $+(@PSleech_,%ps_network,_) %PS.winleechfont
  unset %PS.leech.windowpram
  :window
  clear %ps_leech_window
  titlebar %ps_leech_window Nick: $1 - Trigger: $2 - Series: $3 - Files: $line(%ps_leech_window,0)
  var %ps_leech_misscheck = $PS_ListDir $+ $3 $+ _miss.txt"
  var %ps_leech_savecheck = $PS_ListDir $+ $3 $+ .txt"
  if ($5 == saved) {
    if ($isfile(%ps_leech_misscheck)) loadbuf %ps_leech_window $PS_ListDir $+ $3 $+ _miss.txt"
    if ($isfile(%ps_leech_savecheck)) loadbuf %ps_leech_window $PS_ListDir $+ $3 $+ .txt"
    goto end
  }
  if ($4 == saved) {
    if ($isfile(%ps_leech_misscheck)) loadbuf %ps_leech_window $PS_ListDir $+ $3 $+ _miss.txt"
    if ($isfile(%ps_leech_savecheck)) loadbuf %ps_leech_window $PS_ListDir $+ $3 $+ .txt"
    goto end
  }
  if ($5 == have) {
    loadbuf %ps_leech_window $3
    dline %ps_leech_window 1-3
    goto end
  }
  if ($4 == have) {
    loadbuf %ps_leech_window $3
    dline %ps_leech_window 1-3
    goto end
  }
  if (%ps_leech_windowcheck != Yes) {
    if ($4 == filtered) {
      var %ps_leech_lines = $lines($7)
      var %ps_leech_file = $7
    }
    else {
      var %ps_leech_lines = $lines($4-)
      var %ps_leech_file = $4-
    }
  }
  else {
    var %ps_leech_lines = $lines($5-)
    var %ps_leech_file = $5-
  }
  set $+(%,psleech_,%ps_network,_,$remove(%ps_leech_window,$+(@PSleech_,%ps_network,_)),_rep) $remove(%ps_leech_file,")
  if ($5 == filtered) {
    if (!$isfile($6)) {
      echo $ps_n -sat =-> 4Leech Error The leech file $+ $ps_kh $6 Not Found!
      return
    }
    ps_leech_remove_dupes $6
    loadbuf %ps_leech_window $6
    .remove $6-
    $PS_LeechHistoryWrite(%ps_leech_window,$1,$2,$3,0)
    $PS_LeechSaveBuffer(Save,%ps_leech_window)
    if (($dialog($+(PS_LeechDialog,%ps_network))) && ($did($+(PS_LeechDialog,%ps_network),103).state == 1)) {
      .timer 1 0 did -a $+(PS_LeechDialog,%ps_network) 102 $PS_MdxTab(+ 0 0 0 %ps_leech_window,+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,nick),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,trigger),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,series),+ 0 0 0 $line(%ps_leech_window,0), + 0 0 0 0)
    }
    titlebar %ps_leech_window Nick: $PS_LeechTitleInfo(%ps_leech_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leech_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leech_window,series) - Files: $line( [ %ps_leech_window ] ,0)
    goto last
  }
  if ($4 == filtered) {
    if (!$isfile($5)) {
      echo $ps_n -sat --> 4Leech Error The leech file $+ $ps_kh $5 Not Found!
      return
    }
    ps_leech_remove_dupes $5
    loadbuf %ps_leech_window $5
    .remove $5-
    $PS_LeechHistoryWrite(%ps_leech_window,$1,$2,$3,0)
    $PS_LeechSaveBuffer(Save,%ps_leech_window)
    if (($dialog($+(PS_LeechDialog,%ps_network))) && ($did($+(PS_LeechDialog,%ps_network),103).state == 1)) {
      .timer 1 0 did -a $+(PS_LeechDialog,%ps_network) 102 $PS_MdxTab(+ 0 0 0 %ps_leech_window,+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,nick),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,trigger),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,series),+ 0 0 0 $line(%ps_leech_window,0),+ 0 0 0 0)
    }
    titlebar %ps_leech_window Nick: $PS_LeechTitleInfo(%ps_leech_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leech_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leech_window,series) - Files: $line( [ %ps_leech_window ] ,0)
    goto last
  }
  set %ps_leech_line 1
  set %ps_leech_getline false
  set %ps_leech_curline $read(%ps_leech_file,n,%ps_leech_line)
  if ($numtok(%ps_leech_curline,44) >= 3) {
    set %ps_leech_coltype CSV
    set %ps_leech_havefile $PS_HaveSavedDir $+ $remove($PS_LeechTitleInfo(%ps_leech_window,trigger),!) $+ _Have_ $+ $PS_LeechTitleInfo(%ps_leech_window,series) $+ .txt"
    if ($isfile(%ps_leech_havefile)) set %ps_leech_aline $PS_LeechHaveFilter(%ps_leech_window,$PS_LeechReportParse(%ps_leech_curline))
    else set %ps_leech_aline $PS_LeechReportParse(%ps_leech_curline)
    if (%ps_leech_aline != $null) aline %ps_leech_window %ps_leech_aline
  }
  elseif (ScanSort isin %ps_leech_curline) set %ps_leech_coltype ScanSort
  else set %ps_leech_coltype Other
  ; ##### The start of Loading the leech windows if reading from a file #####
  :recursive
  if ($4 == PSREC) {
    var %ps_leech_lines = $5
    var %ps_leech_line = $6
    var %ps_leech_getline = $7
    var %ps_leech_coltype = $8
    var %ps_leech_window = $9
    set %ps_leech_havefile $PS_HaveSavedDir $+ $remove($PS_LeechTitleInfo(%ps_leech_window,trigger),!) $+ _Have_ $+ $PS_LeechTitleInfo(%ps_leech_window,series) $+ .txt"
    if ($window(%ps_leech_window) == $null) goto end
    var %ps_leech_file = $10-
  }
  :loop
  inc %ps_leech_line
  if (%ps_leech_line > %ps_leech_lines) goto end
  if ($line(%ps_leech_window,0) >= %PS.leechlim) goto end
  set %ps_leech_curline $read(%ps_leech_file,n,%ps_leech_line)
  if (%ps_leech_coltype == ScanSort) {
    if (%ps_leech_curline == $null) { if (%ps_leech_getline == true) set %ps_leech_getline false }
    if (Summary Information isin %ps_leech_curline) goto end
    if (------ isin %ps_leech_curline) {
      set %ps_leech_coltype Other
      set %ps_leech_getline True
      goto rec
    }
    if ((Files missing: isin %ps_leech_curline) || (Wrong Size: isin %ps_leech_curline)) {
      set %ps_leech_getline true
      goto rec
    }
    if (%ps_leech_getline == true) {
      if ($isfile(%ps_leech_havefile)) set %ps_leech_aline $PS_LeechHaveFilter(%ps_leech_window,$PS_LeechReportParse(Scansort,%ps_leech_curline))
      else set %ps_leech_aline $PS_LeechReportParse(Scansort,%ps_leech_curline)
      if (%ps_leech_aline != $null) aline %ps_leech_window %ps_leech_aline
    }
    goto rec
  }
  elseif (%ps_leech_coltype == CSV) {
    if ($isfile(%ps_leech_havefile)) set %ps_leech_aline $PS_LeechHaveFilter(%ps_leech_window,$PS_LeechReportParse(%ps_leech_curline))
    else set %ps_leech_aline $PS_LeechReportParse(%ps_leech_curline)
    if (%ps_leech_aline != $null) aline %ps_leech_window %ps_leech_aline
  }
  elseif (%ps_leech_coltype == Other) {
    if (Results for collection: isin %ps_leech_curline) goto end
    if (Summary Information isin %ps_leech_curline) goto end
    if (Summary Info: isin %ps_leech_curline) goto end
    if (ECSV-Pathnames: isin %ps_leech_curline) goto end
    if (Extra files: isin %ps_leech_curline) goto end
    if (------ isin %ps_leech_curline) {
      set %ps_leech_getline true
      goto rec
    }
    if (%ps_leech_getline == true) {
      if ($isfile(%ps_leech_havefile)) set %ps_leech_aline $PS_LeechHaveFilter(%ps_leech_window,$PS_LeechReportParse(%ps_leech_curline))
      else set %ps_leech_aline $PS_LeechReportParse(%ps_leech_curline)
    }
    if (%ps_leech_aline != $null) aline %ps_leech_window %ps_leech_aline
  }
  :rec
  if ($4 == PSREC)  .timer 1 0 $!PS_LeechLoadWindow( $+ [ $1 ] $+ , $+ [ $2 ] $+ , $+ [ $3 ] $+ ,PSREC, $+ [ %ps_leech_lines ] $+ , $+ [ %ps_leech_line ] $+ , $+ [ %ps_leech_getline ] $+ , $+ [ %ps_leech_coltype ] $+ , $+  [ $9 ] $+ , $+ [ $10- ] )
  else .timer 1 0 $!PS_LeechLoadWindow( $+ [ $1 ] $+ , $+ [ $2 ] $+ , $+ [ $3 ] $+ ,PSREC, $+ [ %ps_leech_lines ] $+ , $+ [ %ps_leech_line ] $+ , $+ [ %ps_leech_getline ] $+ , $+ [ %ps_leech_coltype ] $+ , $+ [ %ps_leech_window ] $+ , $+ [ %ps_leech_file ] )
  titlebar %ps_leech_window Nick: $PS_LeechTitleInfo(%ps_leech_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leech_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leech_window,series) - Files: $line(%ps_leech_window,0) - Loaded: $round($calc((%ps_leech_line / %ps_leech_lines) * 100),2) $+ %
  goto last
  :end
  titlebar %ps_leech_window Nick: $PS_LeechTitleInfo(%ps_leech_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leech_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leech_window,series) - Files: $line(%ps_leech_window,0)
  $PS_LeechHistoryWrite(%ps_leech_window,$1,$2,$3,0)
  $PS_LeechSaveBuffer(Check,%ps_leech_window)
  if (($dialog($+(PS_LeechDialog,%ps_network))) && ($did($+(PS_LeechDialog,%ps_network),103).state == 1)) {
    .timer 1 0 did -a $+(PS_LeechDialog,%ps_network) 102 $PS_MdxTab(+ 0 0 0 %ps_leech_window,+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,nick),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,trigger),+ 0 0 0 $PS_LeechTitleInfo(%ps_leech_window,series),+ 0 0 0 $line(%ps_leech_window,0),+ 0 0 0 0)
  }
  unset %ps_leech_*
  unset %ps_Rparse_*
  :last
}

alias ps_leech_remove_dupes {
  var %f = $1

  ; get total # of lines from file
  var %lines = $lines(%f)

  ; find line which repeats
  var %last = $read(%f,n,%lines)

  ; find first matching repeated line
  var %match = $read(%f,s,%last)

  ; determine line number of first matching line
  var %first = $readn

  ; remove repeating lines from the end of the file
  while %lines > %first {
    write -dl $+ %lines %f
    dec %lines
  }

}

dialog PS_SendsOKButton {
  size -1 -1 300 110
  button "OK",1,100 80 100 20, OK
  text "* SEND PROBLEM *",2,100 10 170 15
  text "",3,20 30 270 15
  text "",4,20 45 270 15
  text "",5,20 60 270 15
}

; ##### General Leech aliases #####
alias PS_LeechCheckMissing {
  var %ps_a = PS_LeechCheckMissing
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($right($1,5) == .txt") {
    var %ps_leech_missing_search = $read($1,wn,missing*)
    if (Missing Files: isin %ps_leech_missing_search) goto search_missing
  }
  elseif ($right($1,5) == .csv") var %ps_leech_missing_search = $read($1,wn,*,missing)
  if (%ps_leech_missing_search == $null) {
    :search_missing
    if (!$dialog(PS_MissingOKButton $+ $2)) dialog -m PS_MissingOKButton $+ $2 PS_MissingOKButton $+ $2
    did -a PS_MissingOKButton $+ $2 3 Your leech report for $2 must list at least 1 MISSING file or mirc will crash.
    return end
  }
  return go
}

alias PS_LeechHistoryWrite {
  var %ps_a = PS_LeechHistoryWrite
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($1-6 != $null) $PS_WriteIni(PS_LeechHistoryWrite,$PS_HistFile,$1,data,$2 $+ ; $+ $3 $+ ; $+ $4 $+ ; $+ $line($1,0) $+ ; $+ $6)
}

alias PS_LeechTitleInfo {
  var %ps_a = PS_LeechTitleInfo
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($2 == nick) return $gettok($gettok($window($1).title,2,58),1,32)
  if ($2 == trigger) return $gettok($gettok($window($1).title,3,58),1,32)
  if ($2 == series) return $gettok($gettok($window($1).title,4,58),1,32)
  if ($2 == files) return $line($1,0)
  if ($2 == gets) {
    if ($gettok($gettok($window($1).title,6,58),1,32) == $null) return 0
    else return $gettok($gettok($window($1).title,6,58),1,32)
  }
}

alias PS_LeechSaveBuffer {
  var %ps_a = PS_LeechSaveBuffer
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_LeechSaveBuffer)
  if ($2 != $null) var %ps_save_buf = $2
  else var %ps_save_buf = %PS.active
  if ($1 == Save) goto skip
  if (%PS.saveleech == No) goto end
  :skip
  if ($PS_LeechTitleInfo(%ps_save_buf,series) == -) goto end
  if ($line(%ps_save_buf,0) > 0) savebuf %ps_save_buf $PS_ListDir $+ $PS_LeechTitleInfo(%ps_save_buf,series) $+ .txt"
  else .remove $PS_ListDir $+ $PS_LeechTitleInfo(%ps_save_buf,series) $+ .txt"
  if ($($+(%,psleech_,%ps_network,_,$remove(%ps_save_buf,$+(@PSleech_,%ps_network,_)),_miss),2) == $null) .remove $PS_ListDir $+ $PS_LeechTitleInfo(%ps_save_buf,series) $+ _miss.txt"
  :end
}

alias PS_LeechHaveFilter {
  var %ps_a = PS_LeechHaveFilter
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_havefilter_return
  if ($PS_LeechCheckCRC($2) == Yes) {
    set %ps_havefilter_return $right($2,$calc($len($2) - 9))
  }
  else set %ps_havefilter_return $2
  set %ps_havefilter_return $read($PS_HaveSavedDir $+ $remove($PS_LeechTitleInfo($1,trigger),!) $+ _Have_ $+ $PS_LeechTitleInfo($1,series) $+ .txt",wn,%ps_havefilter_return $+ *)
  if (%ps_havefilter_return != $null) return $2
}

alias PS_LeechCheckCRC {
  var %ps_a = PS_LeechCheckCRC
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_checkforcrc_crc = $left($1,$pos($1,$chr(32),1))
  if ($len(%ps_checkforcrc_crc) == 8) {
    if (\ isin %ps_checkforcrc_crc) return NO
    if (. isin %ps_checkforcrc_crc) return NO
    if (* isin %ps_checkforcrc_crc) return NO
    return Yes
  }
  return NO
}

alias PS_LeechReportParse {
  var %ps_a = PS_LeechReportParse
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  set %ps_Rparse_line $1-
  if (%ps_Rparse_line == $null) goto end
  set %ps_Rparse_linecheck $left(%ps_Rparse_line,14)
  set %ps_Rparse_csvcheck $numtok(%ps_Rparse_line,44)
  if (%ps_Rparse_csvcheck >= 3) {
    if ((Scansort isin %ps_Rparse_linecheck) || (Missing isin %ps_Rparse_linecheck)) goto skipcsv
    set %ps_Rparse_file $gettok(%ps_Rparse_line,1,44)
    set %ps_Rparse_crc $gettok(%ps_Rparse_line,3,44)
    set %ps_Rparse_path $nofile($gettok(%ps_Rparse_line,4-,44))
    if (\ !isin %ps_Rparse_path) unset %ps_Rparse_path
    goto csv
  }
  :skipcsv
  if (Scansort isin %ps_Rparse_linecheck) {
    set %ps_Rparse_lookforcrc NO
    set %ps_Rparse_line $right(%ps_Rparse_line,$calc(($len(%ps_Rparse_line)) - 8))
    goto scansort
  }
  if ((Missing isin %ps_Rparse_linecheck) || (Wrong Size isin %ps_Rparse_linecheck) || (Wrong CRC isin %ps_Rparse_linecheck) || (Bad Crc32 isin %ps_Rparse_linecheck) || (Bad filesize isin %ps_Rparse_linecheck))  {
    set %ps_Rparse_line $right(%ps_Rparse_line,$calc(($len(%ps_Rparse_line)) - 12))
    :scansort
    set %ps_Rparse_line $PS_RemoveSpaces(%ps_Rparse_line)
    set %ps_Rparse_pos $pos(%ps_Rparse_line,$chr(92),1)
    if (%ps_Rparse_pos == $null) {
      set %ps_Rparse_pos $pos(%ps_Rparse_line,$chr(32),1)
      set %ps_Rparse_file $left(%ps_Rparse_line,%ps_Rparse_pos)
      if (%ps_Rparse_pos == $null) set %ps_Rparse_file %ps_Rparse_line
      if (. !isin $right(%ps_Rparse_file,6)) set %ps_Rparse_file %ps_Rparse_file $+ .jpg
      ;Returns only files with no spaces
      return %ps_Rparse_file
    }
    else {
      set %ps_Rparse_part $left(%ps_Rparse_line,$calc(%ps_Rparse_pos - 1))
      set %ps_Rparse_path $right(%ps_Rparse_line,$calc($len(%ps_Rparse_line) - (%ps_Rparse_pos - 1)))
      set %ps_Rparse_pathslashcount $count(%ps_Rparse_path,\)
      set %ps_Rparse_pathslashpos $pos(%ps_Rparse_path,\,%ps_Rparse_pathslashcount)
      set %ps_Rparse_path $left(%ps_Rparse_path,$calc(%ps_Rparse_pathslashpos))
      if (%ps_Rparse_lookforcrc != NO) {
        set %ps_Rparse_crc $right(%ps_Rparse_part,8)
        set %ps_Rparse_part $left(%ps_Rparse_part,$calc($len(%ps_Rparse_part) - 8))
        set %ps_Rparse_size $right(%ps_Rparse_part,$calc($len(%ps_Rparse_part) - $pos(%ps_Rparse_part,$chr(32),$count(%ps_Rparse_part,$chr(32)))))
        set %ps_Rparse_file $left(%ps_Rparse_part,$calc($len(%ps_Rparse_part) - $len(%ps_Rparse_size)))
      }
      else {
        set %ps_Rparse_pos $pos(%ps_Rparse_part,$chr(32),1)
        set %ps_Rparse_file $left(%ps_Rparse_part,%ps_Rparse_pos)
      }
      :csv
      if (. !isin $right(%ps_Rparse_file,6)) set %ps_Rparse_file %ps_Rparse_file $+ .jpg
      if (%PS.usepath == $null) set %PS.usepath Yes
      if (%PS.usecrc == $null) set %PS.usecrc No
      if (%ps_Rparse_lookforcrc != NO) {
        if (%ps_whereis_chan != $null) {
          if ((%ps_whereis_usecrc == Yes) && (%ps_whereis_usepath == Yes)) return %ps_Rparse_crc %ps_Rparse_path $+ %ps_Rparse_file
          elseif ((%ps_whereis_usecrc == Yes) && (%ps_whereis_usepath == No)) return %ps_Rparse_crc %ps_Rparse_file
          elseif ((%ps_whereis_usecrc == No) && (%ps_whereis_usepath == Yes)) return %ps_Rparse_path $+ %ps_Rparse_file
          else return %ps_Rparse_file
        }
        else {
          if ((%PS.usecrc == Yes) && (%PS.usepath == Yes)) return %ps_Rparse_crc %ps_Rparse_path $+ %ps_Rparse_file
          elseif ((%PS.usecrc == Yes) && (%PS.usepath == No)) return %ps_Rparse_crc %ps_Rparse_file
          elseif ((%PS.usecrc == No) && (%PS.usepath == Yes)) return %ps_Rparse_path $+ %ps_Rparse_file
          else return %ps_Rparse_file
        }
      }
      else {
        if (%PS.usepath == No) return %ps_Rparse_file
        else return %ps_Rparse_path $+ %ps_Rparse_file
      }
    }
  }
  else {
    if (OK isin %ps_Rparse_linecheck) {
      goto end
    }
    else {
      set %ps_Rparse_pos $pos(%ps_Rparse_line,$chr(92),1)
      if (%ps_Rparse_pos == $null) {
        set %ps_Rparse_pos $pos(%ps_Rparse_line,$chr(32),1)
        set %ps_Rparse_file $left(%ps_Rparse_line,%ps_Rparse_pos)
        if (%ps_Rparse_pos == $null) set %ps_Rparse_file %ps_Rparse_line
        if (. !isin $right(%ps_Rparse_file,6)) set %ps_Rparse_file %ps_Rparse_file $+ .jpg
        ;Returns only files with no spaces
        return %ps_Rparse_file
      }
    }
  }
  :end
}

alias PS_LeechReFilter {
  var %ps_a = PS_LeechReFilter
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_LeechReFilter)
  if ((%ps_filter_stat == yes) && ($($+(%,psleech_,%ps_network,_,$remove(%ps_filter_win,$+(@PSleech_,%ps_network,_)),_rep),2) != $null)) {
    set %PS.leech.refilter.type $($+(%,psleech_,%ps_network,_,$remove(%ps_filter_win,$+(@PSleech_,%ps_network,_)),_type),2)
    var %ps_leech_refilter_nick = $PS_LeechTitleInfo(%ps_filter_win,nick)
    var %ps_leech_refilter_trig = $PS_LeechTitleInfo(%ps_filter_win,trigger)
    var %ps_leech_refilter_ser = $PS_LeechTitleInfo(%ps_filter_win,series)
    if (%ps_leech_refilter_nick != $1) goto end
    if ($dialog(PS_LeechMenu) != $null) dialog -x PS_LeechMenu
    if (%PS.usepleech == Yes) {
      window -c %ps_filter_win
      $PS_LeechOpen(%ps_a,%ps_leech_refilter_nick,%ps_leech_refilter_trig,%ps_leech_refilter_ser)
      unset %ps_filter_*
    }
    else {
      clear %ps_filter_win
      $PS_LeechLoadWindow(%ps_leech_refilter_nick,%ps_leech_refilter_trig,%ps_leech_refilter_ser,%ps_filter_win,$($+(%,psleech_,%ps_network,_,$remove(%ps_filter_win,$+(@PSleech_,%ps_network,_)),_rep),2))
      unset %ps_filter_*
    }
  }
  :end
}

alias PS_LeechCheckGets {
  var %ps_a = PS_LeechCheckGets
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_checkgets_count = 0
  var %ps_checkgets_total = $ps_netWork_get(PS_LeechCheckGets,0)
  if (%ps_checkgets_total >= 1) {
    var %ps_checkgets_loop = 1
    while (%ps_checkgets_loop <= %ps_checkgets_total) {
      if ($ps_netWork_get(PS_LeechCheckGets,%ps_checkgets_loop,.file) == $2) {
        inc %ps_checkgets_count
        var %ps_checkgets_nick = %ps_checkgets_nick $ps_netWork_get(PS_LeechCheckGets,%ps_checkgets_loop)
      }
      inc %ps_checkgets_loop
    }
    return %ps_checkgets_count %ps_checkgets_nick
  }
  else return 0
}

; ##### Start/Resume Leech #####
alias PS_StartLeech {
  var %ps_a = PS_StartLeech
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; if too many bad trigger errors kill leech
  if (%ps.errorlevel > 1) { 
    if ($window(@PSTriggerError) == $null) {
      echo -sat 04Leeching is disabled due to trigger errors. Rechecking now, if no errors are found leeches will be re-enabled...
      PSTC_CheckErrors $me AllChannels $true
    }
    else {
      echo -st 04Leeching is disabled due to trigger errors. Fix errors and re-run check to be able to leech again
    }
    return
  }

  ; if invalid ip is found kill leech
  var %ps_ip = $PS_ReturnIp(PS_StartLeech)

  if ($2 == $null) return
  if ($window($2) == $null) return
  else var %ps_leechs_window = $2
  if (PS_ !isin $1) var %ps_leechs_uc = UC

  var %ps_network = $ps_network(PS_StartLeech)
  var %ps_leechs_curwin = $remove(%ps_leechs_window,$+(@PSleech_,%ps_network,_))
  var %ps_leechs_nick = $PS_LeechTitleInfo(%ps_leechs_window,nick)
  var %ps_leechs_trigger = $PS_LeechTitleInfo(%ps_leechs_window,trigger)
  var %ps_leechs_series = $PS_LeechTitleInfo(%ps_leechs_window,series)
  var %ps_leechs_checkpath = $PS_ReadIni(%ps_leechs_series,path)

  ; if leech window is off kill leech
  if ($($+(%,psleech_,%ps_network,_,$remove(%ps_leechs_window,$+(@PSleech_,%ps_network,_)),_status),2) == OFF) {
    return
  }
  ;  if leech is done set OFF and kill leech
  if ($line(%ps_leechs_window,0) < 1) {
    .timer 1 10 PSDV_TrimLog

    set $+(%,psleech_,%ps_network,_,$remove(%ps_leechs_window,$+(@PSleech_,%ps_network,_)),_status) OFF
    if ($ini($+($PS_ScriptDir,Settings\PServeUCPoll_,$PS_Network,.ini,"),%ps_leechs_series) == 0) {
      echo $ps_n -sat --> 3Leech Completed window closed: $+ $ps_kh %ps_leechs_window Nick: $+ $ps_kh %ps_leechs_nick Trigger: $ps_kh %ps_leechs_series
      window -c %ps_leechs_window
    }

    var %ps_leechs_trgfile = $PS_ReadIni(%ps_leechs_series,findfile,a1)
    var %ps_counttrig = $readini(%ps_leechs_trgfile,n,%ps_leechs_series,Count)
    var %ps_countcsv = $readini(%ps_leechs_trgfile,n,%ps_leechs_series,CsvCount)
    if (%PS.sortfiles == Yes) {
      if (%ps_counttrig >= %ps_countcsv) {
        $PS_LeechPurgeDir(LeechDone,$+(%PS.downp,PSTemp\,%ps_leechs_series,\))
      }
      else {
        echo $ps_n -st --> 4PSTemp Directory $+ $ps_kh $+(%PS.downp,PSTemp\,%ps_leechs_series,\) 4Not Purged Trigger not complete.  Current count: $+ $ps_kh %ps_counttrig Csv count: $+ $ps_kh %ps_countcsv
      }
      return
    }
  }

  ; if daily gig limit has been reached kill leech
  var %ps_giglimit = $PS_DialogGigCurrentCount(PS_StartLeech,get,return)
  if ($gettok(%ps_giglimit,1,32) == off) {
    echo $ps_n -st --> PhotoServe Leech $+ $ps_kh %ps_leechs_window 4Stopped.  You have reached your user defined gig limit of $+ $ps_kh $PS_FileSize($gettok(%ps_giglimit,2,32),2) for today.
    return
  }

  ;if server is off kill leech
  if ($PS_SetStatus(PS_StartLeech,Get) == OFF) {
    echo $ps_n -sat --> PhotoServe $+ $ps_kh OFF Leech $+ $ps_kh %ps_leechs_window Killed.
    return
  }

  ; if On Join is restarting leech block UC restarts
  if (%ps_leechs_uc == UC) {
    if ($($+(%,psleech_,%ps_network,_,$remove(%ps_leechs_window,$+(@PSleech_,%ps_network,_)),_status),2) == Retry) {
      return
    }
  }

  ; if leeching misc files skip checks
  if (%ps_leechs_series != -) {

    ; if the trigger does not have a .csv file set kill the leech
    if ($PS_ReadIni(%ps_leechs_series,csv) == $null) {
      echo $ps_n -sat --> 4PhotoServe Leech $+ $ps_kh %ps_leechs_window Killed, Collection $+ $ps_kh %ps_leechs_series .csv does not exist.
      goto killleech
    }

    ; if the triggers path does not exist kill the leech
    if (!$isdir(%ps_leechs_checkpath)) {
      echo $ps_n -sat --> 4PhotoServe Leech $+ $ps_kh %ps_leechs_window Killed, Collection $+ $ps_kh %ps_leechs_series path does not exist.
      goto killleech
    }

    ; if the triggers count is $null kill the leech
    if ($PS_ReadIni(%ps_leechs_series,count) == $null) {
      echo $ps_n -sat --> 4PhotoServe Leech $+ $ps_kh %ps_leechs_window Killed, Collection $+ $ps_kh %ps_leechs_series count not found.
      goto killleech
    }

    ; if the triggers status is off kill the leech
    if ($PS_ReadIni(%ps_leechs_series,status) == OFF) {
      echo $ps_n -sat --> 4PhotoServe Leech $+ $ps_kh %ps_leechs_window Killed, Trigger $+ $ps_kh %ps_leechs_series is 4OFF.
      goto killleech
    }
  }

  ; if _mask for the nick == $null set it
  if ($($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_mask),2) == $null) {
    set $+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_mask) $address(%ps_leechs_nick,3)
  }

  ; if _total == $null set it
  if ($($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_total),2) == $null) set $+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_total) 0

  ; if CRC is in line set _curfile accordingly
  if ($PS_LeechCheckCRC($line(%ps_leechs_window,1)) == YES) set $+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_curfile) $right($line(%ps_leechs_window,1),$calc($len($line(%ps_leechs_window,1)) - 9))
  else set $+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_curfile) $line(%ps_leechs_window,1)

  ; check to see if pserve is downloading the same file from the same nick
  var %ps_leechs_getsnick = $PS_LeechCheckGets(PS_StartLeech,$nopath($($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_curfile),2)))
  if (($gettok(%ps_leechs_getsnick,1,32) != 0) && (%ps_leechs_nick $+ : !isin $gettok(%ps_leechs_getsnick,1,32))) {

    ;    if (.jpg isin $nopath($($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_curfile),2))) {
    ;      echo $ps_n -sat --> Already downloading $+ $ps_kh $nopath($($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_curfile),2)) from07 $gettok(%ps_leechs_getsnick,2,32) Restarting leech in 0760 seconds.
    ;      aline %ps_leechs_window $line(%ps_leechs_window,1)
    ;      dline %ps_leechs_window 1
    ;      .timer 1 60 $!PS_StartLeech(PS_StartLeech, [ %ps_leechs_window ] )
    ;    }

    return
  }

  if (%ps_leechs_nick == $null) echo $ps_n -sat --> 4Bug: The nick is unset, Window: $+ $ps_kh %ps_leechs_window
  ; Leech ctcp Leech Notice Leech msg notice leech msg leech ctcp leech
  var %PS.leech.mode.check = $($+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_getmode),2)
  if (%PS.leech.mode.check == $null) var %PS.leech.mode.type = %PS.leech.mode
  elseif (%PS.leech.mode.check == Notice) var %PS.leech.mode.type = Notice
  elseif (%PS.leech.mode.check == Msg) var %PS.leech.mode.type = Msg
  elseif (%PS.leech.mode.check == Ctcp) var %PS.leech.mode.type = Ctcp
  set $+(%,psleech_,%ps_network,_,%ps_leechs_curwin,_getmode) %PS.leech.mode.type

  ; ensure !psserv is not used to leech due to mirc crashing windows XP
  if (%ps_leechs_trigger == !PSserv) var %ps_leechs_trigger = !PSget
  var %ps_leechs_vartrigger = %ps_leechs_trigger

  if (%ps_leechs_series == -) {
    if ($comchan(%ps_leechs_nick,0) > 0) {
      echo $ps_n -st $CHR(91) $+ %ps_leechs_nick $+ $CHR(93) =-> %ps_leechs_vartrigger $replace($line(%ps_leechs_window,1),\\,\)
      if (%PS.leech.mode.type == Notice) .notice %ps_leechs_nick %ps_leechs_vartrigger $replace($line(%ps_leechs_window,1),\\,\)
      elseif (%PS.leech.mode.type == Msg) .msg %ps_leechs_nick %ps_leechs_vartrigger $replace($line(%ps_leechs_window,1),\\,\)
      else .ctcp %ps_leechs_nick %ps_leechs_vartrigger $line(%ps_leechs_window,1)
      cline 4 %ps_leechs_window 1
      .timer $+ %ps_leechs_window 1 125 cline 8 %ps_leechs_window 1
    }
  }
  else {
    if ($comchan(%ps_leechs_nick,0) > 0) {
      echo $ps_n -st $CHR(91) $+ %ps_leechs_nick $+ $CHR(93) --> %ps_leechs_vartrigger %ps_leechs_series $replace($line(%ps_leechs_window,1),\\,\)
      if (%PS.leech.mode == Notice) .timer 1 0 .notice %ps_leechs_nick %ps_leechs_vartrigger %ps_leechs_series $replace($line(%ps_leechs_window,1),\\,\)
      elseif (%PS.leech.mode == Msg) .timer 1 0 .msg %ps_leechs_nick %ps_leechs_vartrigger %ps_leechs_series $replace($line(%ps_leechs_window,1),\\,\)
      else .timer 1 0 .ctcp %ps_leechs_nick %ps_leechs_vartrigger %ps_leechs_series $line(%ps_leechs_window,1)
      cline 4 %ps_leechs_window 1
      .timer $+ %ps_leechs_window 1 125 cline 8 %ps_leechs_window 1
    }
  }

  return

  :killleech
  set $+(%,psleech_,%ps_network,_,$remove(%ps_leechs_window,$+(@PSleech_,%ps_network,_)),_status) OFF
  if (!$dialog(PS_TriggerOKButton $+ %ps_leechs_series)) dialog -m PS_TriggerOKButton $+ %ps_leechs_series PS_TriggerOKButton $+ %ps_leechs_series
  did -ra PS_TriggerOKButton $+ %ps_leechs_series 3 Trigger: %ps_leechs_series
}





; #### Leech Error OK Button ####
dialog PS_TriggerOKButton* {
  size -1 -1 200 100
  title Leech Error
  button "OK",1,50 70 80 20, OK
  text "There is an error with this trigger!",2,20 10 180 20,
  text "",3,20 40 170 20,
}

on *:dialog:PS_TriggerOKButton*:sclick:*: {
  var %ps_a = PS_OnDialog_PS4_TriggerOkButton
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  if ($did == 10) {
    dialog -x PS_LeechMenu
  }
}







alias PS_ServerSends {
  var %ps_a = PS_ServerSends
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_server_sends = 0
  var %ps_server_count = 1
  var %ps_server_total = $scon(0)
  while (%ps_server_count <= %ps_server_total) {
    scid $scon(%ps_server_count)
    if ($PS_SetStatus(PS_ServerSends,Get) != OFF) {
      var %ps_server_sends = $calc($PS_SetSendTotal(%ps_a) + %ps_server_sends)
    }
    inc %ps_server_count
  }
  scid -r
  return %ps_server_sends
}

alias PS_ServerQueues {
  var %ps_a = PS_ServerQueues
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_server_queues = 0
  var %ps_server_count = 1
  var %ps_server_total = $scon(0)
  while (%ps_server_count <= %ps_server_total) {
    scid $scon(%ps_server_count)
    if ($PS_SetStatus(PS_ServerQueues,Get) != OFF) {
      var %ps_server_queues = $calc($PS_SetQueueTotal(%ps_a) + %ps_server_queues)
    }
    inc %ps_server_count
  }
  scid -r
  return %ps_server_queues
}

alias PS_ServerNetworks {
  var %ps_a = PS_ServerNetworks
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_server_networks = 0
  var %ps_server_count = 1
  var %ps_server_total = $scon(0)
  while (%ps_server_count <= %ps_server_total) {
    scid $scon(%ps_server_count)
    if ($PS_SetStatus(PS_ServerNetworks,Get) != OFF) {
      var %ps_server_networks = $calc(%ps_server_networks + 1)
    }
    inc %ps_server_count
  }
  scid -r
  return %ps_server_networks
}

alias PS_mIRCSends {
  var %ps_a = PS_mIRCSends
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  echo $ps_n -sat --> mIRC Sends: $+ $ps_kh $calc($PS_ServerSends + $PS_ServerNetworks)
}
















; ##### Leech Type Dialog #####
dialog PS_OpenLeech {
  title "Leech"
  size -1 -1 100 125
  button "Path and File",1,5 5 90 20,
  button "File",2,5 35 90 20,
  button "Size and File",3,5 55 90 20, disable
  button "CRC and File",4,5 75 90 20, disable
  text "",5,1 1 1 1,RESULT
  button "",6,1 1 1 1,OK
  button "Cancel",7,5 100 90 20,Cancel
}

ON *:dialog:PS_OpenLeech:sclick:*: {
  var %ps_a = PS_OnDialog_PS4_OpenLeechSclick
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  if ($did == 1) did -a PS_OpenLeech 5 pathfile
  if ($did == 2) did -a PS_OpenLeech 5 file
  if ($did == 3) did -a PS_OpenLeech 5 pathcrc
  if ($did == 4) did -a PS_OpenLeech 5 crc
  dialog -k PS_OpenLeech
}
















; ##### Leech Window Options Dialog #####
menu @PSleech* {
  rclick {
    if ($dialog(PS_LeechMenu).ok != $null) dialog -x PS_LeechMenu PS_LeechMenu
    dialog -ma PS_LeechMenu PS_LeechMenu 
  }
  lbclick {
    if ((%PS.active == $active) && ($dialog(PS_LeechMenu).ok != $null)) $PS_LeechMenuInit
  }
}

dialog PS_LeechMenu {
  title Leech Options
  size -1 -1 400 120
  box "", 1,5 0 390 55,
  text "Nick:",2,10 13 50 20,
  edit "",3,35 10 70 20,autohs
  button "Change",4,110 10 60 20,
  text "Trigger:",5,175 13 50 20,
  edit "",6,212 10 70 20,autohs
  text "Series:",7,287 13 50 20,
  edit "",8,320 10 70 20,autohs
  button "Filter",9,5 75 78 20,
  button "Clear",10,83 75 78 20,
  button "Remove",11,161 75 78 20,
  button "Save",12,239 75 78 20,
  button "Options",13,317 75 78 20,
  button "Start",14,5 95 78 20,
  button "Stop",15,83 95 78 20,
  button "Load",16,161 95 78 20
  button "Randomize",17,239 95 78 20,
  button "Done",18,317 95 78 20,OK
  edit "",19,10 30 380 21,autohs
  button "Add",20,5 55 78 20,
  button "Up",21,83 55 78 20,
  button "Down",22,161 55 78 20,
  button "Top",23,239 55 78 20,
  button "Bottom",24,317 55 78 20,
  button "ReStart",25,5 95 78 20,hide
}

ON *:dialog:PS_LeechMenu:init:0: {
  var %ps_a = PS_OnDialog_PS4_LeechMenuInit
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  set %PS.active $active
  $PS_LeechMenuInit
}

alias PS_LeechMenuInit {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_LeechMenuInit)
  did -r PS_LeechMenu 3,6,8,19
  did -a PS_LeechMenu 3 $PS_LeechTitleInfo(%PS.active,nick)
  did -a PS_LeechMenu 6 $PS_LeechTitleInfo(%PS.active,trigger)
  if ( $PS_LeechTitleInfo(%PS.active,series) != -) did -a PS_LeechMenu 8 $PS_LeechTitleInfo(%PS.active,series)
  if (($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status),2) == ON) || ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status),2) == Retry)) {
    did -h PS_LeechMenu 14
    did -v PS_LeechMenu 25
  }
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status),2) == OFF) did -b PS_LeechMenu 15
  did -a PS_LeechMenu 19 $sline(%PS.active,1)
  if ($sline(%PS.active,1) == $null) did -b PS_LeechMenu 21,22,23,24
  else did -e PS_LeechMenu 21,22,23,24
  if ($sline(%PS.active,1).ln == 1) did -b PS_LeechMenu 21,23
  if ($sline(%PS.active,$sline(%PS.active,0)).ln == $line(%PS.active,0)) did -b PS_LeechMenu 22,24
}

ON *:dialog:PS_LeechMenu:sclick:4: dialog -ma PS_Nick PS_Nick
ON *:dialog:PS_LeechMenu:sclick:9: $PS_LeechStartFilter(%PS.active)

alias PS_LeechStartFilter {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  set %ps_filter_win $1
  set %ps_filter_stat yes
  ctcp $PS_LeechTitleInfo(%ps_filter_win,nick) $PS_LeechTitleInfo(%ps_filter_win,trigger) $PS_LeechTitleInfo(%ps_filter_win,series) have
}

ON *:dialog:PS_LeechMenu:sclick:10: Clear %PS.active | titlebar %PS.active Nick: $PS_LeechTitleInfo(%PS.active,nick) - Trigger: $PS_LeechTitleInfo(%PS.active,trigger) - Series: $PS_LeechTitleInfo(%PS.active,series) - Files: $line(%PS.active,0)
ON *:dialog:PS_LeechMenu:sclick:11: {
  ;Remove
  var %ps_lch_rem_count = $sline(%PS.active,0).ln
  while (%ps_lch_rem_count > 0) {
    dline %PS.active $sline(%PS.active,1).ln
    dec %ps_lch_rem_count
  }
  titlebar %PS.active Nick: $PS_LeechTitleInfo(%PS.active,nick) - Trigger: $PS_LeechTitleInfo(%PS.active,trigger) - Series: $PS_LeechTitleInfo(%PS.active,series) - Files: $line(%PS.active,0)
}

ON *:dialog:PS_LeechMenu:sclick:12: $PS_LeechSaveBuffer(Save)
ON *:dialog:PS_LeechMenu:sclick:13: .timer 1 0 $!dialog(PSLeechOptions,PSLeechOptions)
ON *:dialog:PS_LeechMenu:sclick:14: {
  ;Start
  var %ps_network = $ps_network(PS_LeechMenu_sclick14)
  set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status) ON
  $PS_StartLeech(PS_LeechMenu_sclick14,%PS.active)
  did -b PS_LeechMenu 14
  did -e PS_LeechMenu 15
  echo $ps_n -st --> %PS.active $ps_kh $+ Started.
}

ON *:dialog:PS_LeechMenu:sclick:15: {
  ;Stop
  var %ps_network = $ps_network(PS_LeechMenu_sclick15)
  set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status) OFF
  did -b PS_LeechMenu 15
  did -e PS_LeechMenu 14
}

ON *:dialog:PS_LeechMenu:sclick:16: {
  .timer 1 0 $!PS_LeechOpen(PS_LeechMenu,$PS_LeechTitleInfo(%PS.active,nick),$PS_LeechTitleInfo(%PS.active,trigger),$PS_LeechTitleInfo(%PS.active,series),%PS.active)
  dialog -k PS_LeechMenu
}

ON *:dialog:PS_LeechMenu:sclick:18: {
  if ($did($dname,3).text != $null) {
    titlebar %PS.active Nick: $did($dname,3).text - Trigger: $PS_LeechTitleInfo(%PS.active,trigger) - Series: $PS_LeechTitleInfo(%PS.active,series) - Files: $line(%PS.active,0)
    set % $+ $remove(%PS.active,@) $+ _mask $address($did($dname,3).text,3)
    $PS_LeechHistoryWrite(%PS.active,$PS_LeechTitleInfo(%PS.active,nick),$PS_LeechTitleInfo(%PS.active,trigger),$PS_LeechTitleInfo(%PS.active,series),$PS_LeechTitleInfo(%PS.active,files),$PS_LeechTitleInfo(%PS.active,gets))
  }
  if ($did($dname,6).text != $null) {
    titlebar %PS.active Nick: $PS_LeechTitleInfo(%PS.active,nick) - Trigger: $did($dname,6).text - Series: $PS_LeechTitleInfo(%PS.active,series) - Files: $line(%PS.active,0)
  }
  if (($did($dname,19).text != $null) && ($did($dname,19).text != $sline(%PS.active,1)) && ($sline(%PS.active,0) != $null)) rline %PS.active $sline(%PS.active,1).ln $did($dname,19).text
  titlebar %PS.active Nick: $PS_LeechTitleInfo(%PS.active,nick) - Trigger: $PS_LeechTitleInfo(%PS.active,trigger) - Series: $did($dname,8).text - Files: $line(%PS.active,0)
}

ON *:dialog:PS_LeechMenu:sclick:20:{ if ($did($dname,19).text != $null) aline %PS.active $did($dname,19).text | sline %PS.active $line(%PS.active,0) }

ON *:dialog:PS_LeechMenu:sclick:21:{
  ;UP
  var %ps_network = $ps_network(PS_LeechMenu_sclick21)
  set %ps_up_stotal $sline(%PS.active,0)
  if (%ps_up_stotal == $null) goto end
  :loop
  if (%ps_up_total == 0) goto end
  set %ps_up_line $sline(%PS.active,1).ln
  set %ps_up_total $sline(%PS.active,0)
  if (%ps_up_line == 2) did -b PS_LeechMenu 21,23
  if (%ps_up_line <= $line(%PS.active,0)) did -e PS_LeechMenu 22,24
  if (($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status),2) == ON) && ($calc(%ps_up_line - 1) < 2)) goto end
  if ($sline(%PS.active,0) > 0) iline %PS.active $calc(%ps_up_line - 1) $sline(%PS.active,1)
  if (%ps_up_total == 1) dec %ps_up_total
  if (%ps_up_stotal == 1) sline %PS.active $calc(%ps_up_line - 1)
  dline %PS.active $calc(%ps_up_line + 1)
  goto loop
  :end
  unset %ps_up_*
}

ON *:dialog:PS_LeechMenu:sclick:17:{
  ;RANDOMIZE
  var %ps_rand_total = $line(%PS.active,0)
  var %ps_rand_count = 1
  while (%ps_rand_count <= %ps_rand_total) {
    var %ps_rand_number = $rand(2,%ps_rand_total)
    var %ps_rand_line = $line(%PS.active,%ps_rand_number)
    dline %PS.active %ps_rand_number
    iline %PS.active $rand(2,%ps_rand_total) %ps_rand_line
    inc %ps_rand_count
  }
}

ON *:dialog:PS_LeechMenu:sclick:22:{
  ;Down
  set %ps_down_stotal $sline(%PS.active,0)
  set %ps_down_line $calc(%ps_down_stotal + 1)
  :loop
  dec %ps_down_line
  if (%ps_down_line > 0) {
    set %ps_down_text $sline(%PS.active,%ps_down_line)
    set %ps_down_linnum $sline(%PS.active,%ps_down_line).ln
    if (%ps_down_linnum > 0) did -e PS_LeechMenu 21,23
    if (%ps_down_linnum == $calc($line(%PS.active,0) - 1)) did -b PS_LeechMenu 22,24
    dline %PS.active %ps_down_linnum
    iline %PS.active $calc(%ps_down_linnum + 1) %ps_down_text
    if (%ps_down_stotal == 1) sline %PS.active $calc(%ps_down_linnum + 1)
    goto loop
  }
  :end
  unset %ps_down_*
}

ON *:dialog:PS_LeechMenu:sclick:23:{
  ;Top
  var %ps_network = $ps_network(PS_LeechMenu_sclick23)
  var %ps_top_stotal = $sline(%PS.active,0)
  var %ps_top_loop = 0
  :loop
  inc %ps_top_loop
  if (%ps_top_loop <= %ps_top_stotal) {
    set %ps_top_text $sline(%PS.active,1)
    set %ps_top_linnum $sline(%PS.active,1).ln
    dline %PS.active %ps_top_linnum
    if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status),2) == ON) iline %PS.active $calc(%ps_top_loop + 1) %ps_top_text
    else iline %PS.active %ps_top_loop %ps_top_text
    goto loop
  }
  :end
  unset %ps_top_*
}

ON *:dialog:PS_LeechMenu:sclick:24:{
  ;Bottom
  :loop
  if ($sline(%PS.active,0) == $null) goto end
  aline %PS.active $sline(%PS.active,1)
  dline %PS.active $sline(%PS.active,1).ln
  goto loop
  :end
}

ON *:dialog:PS_LeechMenu:sclick:25: {
  ;ReStart
  var %ps_network = $ps_network(PS_LeechMenu_sclick25)
  set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_status) ON
  $PS_StartLeech(PS_LeechMenu_sclick25,%PS.active)
  did -h PS_LeechMenu 14
  did -b PS_LeechMenu 25
  did -e PS_LeechMenu 15
  echo $ps_n -st --> %PS.active $ps_kh $+ Started.
}
















; ##### Leech Window Advanced Options Dialog #####
dialog PSLeechOptions {
  title $gettok(%PS.active,1-,32) Options
  size -1 -1 210 200

  button "OK",1,120 177 30 20, OK,
  button "Cancel",2,155 177 50 20, CANCEL
  button "Save Window",3,5 177 105 20,

  text "Get Delay",4,5 12 60 20,
  edit "",5,65 10 30 20,autohs
  text "Fail Delay",6,5 32 60 20,
  edit "",7,65 30 30 20,autohs
  text "Busy Delay",8,5 52 60 20,
  edit "",9,65 50 30 20,autohs
  text "Dupe Delay",10,5 72 60 20,
  edit "",11,65 70 30 20,autohs
  box "Not Found",12,100 5 105 40,
  text "#",13,102 22 60 20,
  edit "",14,110 20 30 20,autohs
  text "Wait",15,145 22 30 20,
  edit "",16,170 20 30 20,autohs
  check "Start Time ex: 10:30:15",22,5 92 135 20,
  edit "",23,140 92 65 20,
  check "Stop Time ex: 22:45:00",24,5 112 135 20,
  edit "",25,140 112 65 20,
  text "Leech Type",26,5 133 55 20,
  radio "Notice",19,61 132 50 20,group
  radio "Ctcp",20,118 132 45 20,
  radio "Msg",21,161 132 50 20,
  text "Failed / Bad Downloads",27,5 149 55 25,
  radio "Del",28,118 152 50 20,group
  radio "Resume",29,61 152 55 20,
  check "Move",30,161 152 50 20,
}

ON *:dialog:PSLeechOptions:init:0:{
  var %ps_a = PS_OnDialog_PS4_LeechOptionsInit
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $ps_network(PSLeechOptions_init)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getdelay),2) == $null) did -a $dname 5 %PS.getdelay
  else did -a $dname 5 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getdelay),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getfaildelay),2) == $null) did -a $dname 7 %PS.getfaildelay
  else did -a $dname 7 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getfaildelay),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_busyretry),2) == $null) did -a $dname 9 %PS.busyretry
  else did -a $dname 9 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_busyretry),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_duperetry),2) == $null) did -a $dname 11 %PS.duperetry
  else did -a $dname 11 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_duperetry),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_Inotfound),2) == $null) did -a $dname 14 %PS.notfound
  else did -a $dname 14 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_Inotfound),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_notfounddelay),2) == $null) did -a $dname 16 %PS.notfounddelay
  else did -a $dname 16 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_notfounddelay),2)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimer),2) == ON) {
    did -c $dname 22
    did -a $dname 23 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime),2)
  }
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimer),2) == ON) {
    did -c $dname 24
    did -a $dname 25 $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime),2)
  }
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failremove),2) == Yes)  did -c $dname 28
  elseif ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failremove),2) == NO) did -c $dname 29
  elseif (%PS.lch.fail.del == ON) did -c $dname 28
  else did -c $dname 29
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failmove),2) == Move)  did -c $dname 30
  if (%PS.lch.fail.move == Move) did -c $dname 30
  :go
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode),2) == Notice) did -c $dname 19
  elseif ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode),2) == Msg) did -c $dname 21
  elseif ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode),2) == Ctcp) did -c $dname 20
  else did -c $dname 20
}

ON *:dialog:PSLeechOptions:sclick:1: {
  var %ps_a = PS_OnDialog_PS4_LeechOptionsSclick
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  if ($did == 1) {
    var %ps_network = $ps_network(PSLeechOptions_sclick1)
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getdelay) $did($dname,5).text
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getfaildelay) $did($dname,7).text
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_busyretry) $did($dname,9).text
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_duperetry) $did($dname,11).text
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_Inotfound) $did($dname,14).text
    set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_notfounddelay) $did($dname,16).text
    if ($did($dname,28).state == 1) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failremove) YES
    else set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failremove) NO
    if ($did($dname,30).state == 1) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failmove) Move
    else set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_failmove) NO
    if ($did($dname,19).state == 1) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode) Notice
    elseif ($did($dname,21).state == 1) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode) Msg
    else set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_getmode) Ctcp
    if ($did($dname,22).state == 1) {
      set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimer) ON
    }
    else {
      set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimer) OFF
      .timer $+ $+(psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_on) off
    }
    if ($did($dname,24).state == 1) {
      set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimer) ON
    }
    else {
      set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimer) OFF
      .timer $+ $+(psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_off) off
    }
    if (($did($dname,23).text != $null) && ($count($did($dname,23).text,:) == 2)) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime) $did($dname,23).text
    if (($did($dname,25).text != $null) && ($count($did($dname,23).text,:) == 2)) set $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime) $did($dname,25).text
    $PS_LeechAutoOnOffTimer
  }

  if ($did == 3) {
    set %PS.winleechloc $PS_Location(%PS.active) | set %PS.winleechfont $PS_Font(%PS.active)
  }

  if ($did == 22) {
    did -r $dname 23
    var %ps_network = $ps_network(PSLeechOptions_sclick22)
    .timer 1 0 unset $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime)
  }

  if ($did == 24) {
    did -r $dname 25
    var %ps_network = $ps_network(PSLeechOptions_sclick24)
    .timer 1 0 unset $+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime)
  }
}

alias PS_LeechAutoOnOffTimer {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_LeechAutoOnOffTimer)
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimer),2) == ON) {
    if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime),2) != $null) {
      .timer $+ $+(psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_on) $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime),2) 1 1 PS_LeechAutoOnOffStatus ON %ps_network $remove(%PS.active,$+(@PSleech_,%ps_network,_))
      echo $ps_n -sat --> Photoserve set to automatically 3START $+ $ps_kh $+(@PSLeech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_))) at $+ $ps_kh $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_ontimertime),2)
    }
  }
  if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimer),2) == ON) {
    if ($($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime),2) != $null) {
      .timer $+ $+(psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_off) $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime),2) 1 1 PS_LeechAutoOnOffStatus OFF %ps_network $remove(%PS.active,$+(@PSleech_,%ps_network,_))
      echo $ps_n -sat --> Photoserve set to automatically 4STOP $+ $ps_kh $+(@PSLeech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_))) at $+ $ps_kh $($+(%,psleech_,%ps_network,_,$remove(%PS.active,$+(@PSleech_,%ps_network,_)),_offtimertime),2)
    }  
  }
}

alias PS_LeechAutoOnOffStatus {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($1 == ON) {
    set $+(%,psleech_,$2,_,$3,_status) ON
    $PS_ReStartLeech($+(@PSleech_,$2,_,$3))
    echo $ps_n -sat --> Photoserve automatically turned 3ON $+ $ps_kh $+(@PSLeech_,$2,_,$3)  
  }
  if ($1 == OFF) {
    unset [ $+(%,psleech_,$2,_,$3,_status) ]
    echo $ps_n -sat --> Photoserve automatically turned 4OFF $+ $ps_kh $+(@PSLeech_,$2,_,$3)  
  }
}

alias PS_ReStartLeech {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_ReStartLeech)
  set %ps_restart_num $remove($1,$+(@PSleech_,%ps_network,_))
  if ($($+(%,psleech_,%ps_network,_,%ps_restart_num,_status),2) == ON) {
    set %ps_restart_filename $($+(%,psleech_,%ps_network,_,%ps_restart_num,_curfile),2)
    if ($comchan($PS_LeechTitleInfo($1,nick),0) > 0) {
      echo $ps_n -st --> Restarting $+ $ps_kh $1
      $PS_StartLeech(PS_ReStartLeech,$1)
    }
  }
  unset %ps_restart_*
}



; ##### Leech Current/History Dialog #####
alias PS_LeechDialogOpen {
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($PS_CheckVersion != go) return
  var %ps_network = $ps_network(%ps_a)
  if ($dialog($+(PS_LeechDialog,%ps_network))) dialog -x PS_LeechDialog $+ %ps_network
  .timer 1 0 $!PS_LeechDialogCreate
}



alias PS_LeechDialogCreate {
  var %ps_a = PS_LeechDialogCreate
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (($isfile(" $+ $PS_vdll $+ ")) && ($isfile(" $+ $PS_ddll $+ ")) && ($isfile(" $+ $PS_udll $+ "))) {
    if (!$+(%,PS.lchstat.ontop.,%ps_network)) set $+(%,PS.lchstat.ontop.,%ps_network) d
    dialog - $+ $($+(%,PS.lchstat.ontop.,%ps_network),2) $+ m PS_LeechDialog $+ %ps_network PS_LeechDialog
  }
  else echo $ps_n -sat --> 4,1ERROR, 8mdx.dll and 8views.mdx and 8dialog.mdx are Required to be in $+ $ps_kh $PS_DllDir for this dialog box to work.
}



dialog PS_LeechDialog {
  size -1 -1 230 110
  title $ps_network(PS_LeechDialog) Leech Windows
  option dbu

  text "Leech Type:"109,10 2 30 10
  radio "Single Nick",110,42 2 35 10, group
  radio "Multi Nick",111,80 2 50 10

  button "Close",1,185 2 30 10,OK
  check "OnTop",8,150 2 30 10

  box "Single File Leech List",7, 5 12 220 95
  list 102, 10 21 210 68
  button "Hide",3,45 81 30 10
  button "Show",4,80 81 30 10
  button "mIRC",5,115 81 30 10
  button "Desktop",6,150 81 30 10
  radio "Current",103,10 81 30 10, group
  radio "History",104,10 93 30 10
  button "Load",105,45 93 30 10
  button "Remove",106,80 93 30 10
  button "!WhereIs",108,150 93 30 10
  button "Options",107,185 81 30 10

  box "Multi-Nick Leech List",201, 5 12 220 95
  list 202, 10 21 210 78
  text "Leech Filter:",203,15 95 30 10
  button "Pics Only",204,45 94 30 10
  button "Vids Only",205,80 94 30 10
  button "Show",206,145 94 20 10
  edit "MDX UpDown", 207, 115 93 25 13
  button "Cancel Leech",208,170 94 45 10
}



on *:dialog:PS_LeechDialog*:init:0:{

  var %ps_a = PS_OnDialog_PS4_LeechDialogInit
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %PS = $PS_Mdx(SetMircVersion,$version)
  var %PS = $PS_Mdx(MarkDialog,$dname)

  var %ps_network = $ps_network(%ps_a)

  ; Single File Leech
  var %PS = $PS_Mdx(SetControlMDX,$dname 102 listview showsel infotip rowselect report sortascending > [ $PS_vdll ] )
  did -i $dname 102 1 setbkg color $gettok(%ps.appearance.dialogs.listcolor,2,32)
  did -i $dname 102 1 settxt bgcolor $gettok(%ps.appearance.dialogs.listcolor,2,32)
  did -i $dname 102 1 settxt color $gettok(%ps.appearance.dialogs.listcolor,1,32)
  did -i $dname 102 1 headerdims 60:0 60:0 60:0 60:0 60:0 60:0
  did -i $dname 102 1 headertext $PS_MdxTab(+l Leech,+l Name,+l Trig,+l Series,+r Remain,+r Gets)

  ; MultiHeaded Leech
  var %PS = $PS_Mdx(SetControlMDX,202 listview showsel infotip rowselect report sortascending > [ $PS_vdll ] )
  did -i $dname 202 1 setbkg color $gettok(%ps.appearance.dialogs.listcolor,2,32)
  did -i $dname 202 1 settxt bgcolor $gettok(%ps.appearance.dialogs.listcolor,2,32)
  did -i $dname 202 1 settxt color $gettok(%ps.appearance.dialogs.listcolor,1,32)
  did -i $dname 202 1 headerdims 0:0 60:0 50:0 50:0 50:0 60:0 50:0 50:0
  did -i $dname 202 1 headertext $PS_MdxTab(+l Leech,+l Network,+l Series,+r Count, +r Remain,+r Threads, +r Targets, +r Priority)

  var %ps = $PS_Mdx(SetControlMDX,207 updown edit alignright numeric right > [ $PS_gdll ] )
  did -i $dname 207 1 50 1 150 10

  if ($($+(%,PS.lchstat.ontop.,%ps_network),2) == o) did -c $dname 8

  did -c $dname 103
  did -c $dname 111

  did -h $dname 7,102,3,4,5,6,103,104,105,106,107,108

  $PS_ML-Hist

}



alias PS_LeechDialogInit {
  var %ps_a = PS_LeechDialogInit
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  did -r PS_LeechMenu 3,6,8,19
  did -a PS_LeechMenu 3 $PS_LeechTitleInfo($1,nick)
  did -a PS_LeechMenu 6 $PS_LeechTitleInfo($1,trigger)
  if ($PS_LeechTitleInfo($1,series) != -) did -a PS_LeechMenu 8 $PS_LeechTitleInfo($1,series)
  if (($($+(%,psleech_,%ps_network,_,$remove($1,$+(@PSleech_,%ps_network,_)),_status),2) == ON) || ($($+(%,psleech_,%ps_network,_,$remove($1,$+(@PSleech_,%ps_network,_)),_status),2) == Retry)) did -b PS_LeechMenu 14
  if ($($+(%,psleech_,%ps_network,_,$remove($1,$+(@PSleech_,%ps_network,_)),_status),2) == OFF) did -b PS_LeechMenu 15
  did -a PS_LeechMenu 19 $sline($1,1)
  if ($sline($1,1) == $null) did -b PS_LeechMenu 21,22,23,24
  else did -e PS_LeechMenu 21,22,23,24
  if ($sline($1,1).ln == 1) did -b PS_LeechMenu 21,23
  if ($sline($1,$sline($1,0)).ln == $line($1,0)) did -b PS_LeechMenu 22,24
}



on *:dialog:PS_LeechDialog*:sclick:*: {
  var %ps_a = PS_OnDialog_PS4_LeechDialogSclick
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if ($did == 3) $PS_LeechDialogReload(hide,%ps_Leech_Dialog_No)
  if ($did == 4) $PS_LeechDialogReload(show,%ps_Leech_Dialog_No)
  if ($did == 5) $PS_LeechDialogReload(mirc,%ps_Leech_Dialog_No)
  if ($did == 6) $PS_LeechDialogReload(desktop,%ps_Leech_Dialog_No)
  if ($did == 8) {
    if ($did($dname,8).state == 1) set $+(%,PS.lchstat.ontop.,%ps_network) o
    else set $+(%,PS.lchstat.ontop.,%ps_network) d
    $PS_LeechDialogOpen
  }
  if ($did == 102) {
    unset %ps_Leech_Dialog_No
    if ($did($dname,102).seltext != $null) {
      if ($did($dname,103).state == 1) did -e $dname 3,4,5,6,107
      if ($did($dname,104).state == 1) did -e $dname 105,106
      did -e $dname 108
      tokenize 32 $gettok($did($dname,$did).seltext,1,9)
      set %ps_Leech_Dialog_No $6
    }
  }
  if ($did == 103) {
    $PS_LeechHistoryDialog($dname,current)
    did -b $dname 3,4,5,6,105,106,107,108
  }
  if ($did == 104) {
    $PS_LeechHistoryDialog($dname,history)
    did -b $dname 3,4,5,6,105,106,107,108
  }
  if ($did == 105) {
    while ($did($dname,102).sel != $null) {
      $PS_LeechDialogLoad($dname)
    }
  }
  if ($did == 106) {
    if ($did($dname,102).seltext != $null) {
      $PS_RemIni(PS_LeechDialogsclick,$PS_HistFile,$gettok($gettok($did($dname,102).seltext,1,9),6,32))
      did -b $dname 3,4,5,6,105,106,108
      $PS_LeechHistoryDialog($dname,history)
    }
  }
  if ($did == 107) {
    if ($dialog(PS_LeechMenu).ok != $null) dialog -x PS_LeechMenu PS_LeechMenu
    dialog -ma PS_LeechMenu PS_LeechMenu
    set %PS.active %ps_Leech_Dialog_No
    $PS_LeechDialogInit(%ps_Leech_Dialog_No)
  }
  if ($did == 108) {
    if ($did($dname,102).seltext != $null) {
      $PS_WhereIs($gettok($gettok($did($dname,102).seltext,4,9),5,32))
      did -b $dname 3,4,5,6
    }
  }
  if ($did == 110) {
    did -v $dname 7,102,3,4,5,6,103,104,105,106,107,108
    did -h $dname 201,202,203,204,205,206,207,208
    $PS_LeechHistoryDialog($dname,current)
  }
  if ($did == 111) {
    did -h $dname 7,102,3,4,5,6,103,104,105,106,107,108
    did -v $dname 201,202,203,204,205,206,207,208
    $PS_ML-Hist($dname)
  }
  if ($did == 202) {

    unset %ps.ml-leech.line
    set %ps.ml-leech.line $did($dname,202).sel
    unset %ps.ml-leech.value
    set %ps.ml-leech.value $gettok($gettok($did($dname,202).seltext,8,9),5,32)

    if (!%ps.ml-leech.value) set %ps.ml-leech.value 75
    did -ir $dname 207 1 %ps.ml-leech.value 1 5000 10
  }
  if ($did == 204) {
    if (!$did($dname,202).seltext) return
    $PSL_LeechFilter($gettok($gettok($did($dname,202).seltext,3,9),5,32),pics)
    $PS_ML-Hist-Up($dname,line,%ps.ml-leech.line)
  }
  if ($did == 205) {
    if (!$did($dname,202).seltext) return
    $PSL_LeechFilter($gettok($gettok($did($dname,202).seltext,3,9),5,32),vids)
    $PS_ML-Hist-Up($dname,line,%ps.ml-leech.line)
  }
  if ($did == 206) {
    if (!$did($dname,202).seltext) return
    window -ra $gettok($gettok($did($dname,202).seltext,1,9),6,32)
  }
  if ($did == 208) {
    if (!$did($dname,202).seltext) return
    window -c $gettok($gettok($did($dname,202).seltext,1,9),6,32)
    $PS_ML-Hist-Up($dname,line,%ps.ml-leech.line)
  }
}



alias PS_LeechDialogLoad {
  var %ps_a = PS_LeechDialogLoad
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  if ($gettok($gettok($did(%dname,102).seltext,5,9),5,32) > 0) {
    set $+(%,psleech_,%ps_network,_,$remove($gettok($gettok($did(%dname,102).seltext,1,9),6,32),$+(@PSleech_,%ps_network,_)),_status) OFF
    if ($window($gettok($gettok($did(%dname,102).seltext,1,9),6,32)) == $null) {
      window -lark0 $gettok($gettok($did(%dname,102).seltext,1,9),6,32) %PS.winleechloc $+(@PSleech_,%ps_network,_) %PS.winleechfont
      $PS_LeechOpen(%ps_a,$gettok($gettok($did(%dname,102).seltext,2,9),5,32),$gettok($gettok($did(%dname,102).seltext,3,9),5,32),$gettok($gettok($did(%dname,102).seltext,4,9),5,32),$gettok($gettok($did(%dname,102).seltext,1,9),6,32))
    }
    else {
      $PS_LeechOpen(%ps_a,$gettok($gettok($did(%dname,102).seltext,2,9),5,32),$gettok($gettok($did(%dname,102).seltext,3,9),5,32),$gettok($gettok($did(%dname,102).seltext,4,9),5,32),$remove($gettok($gettok($did(%dname,102).seltext,1,9),6,32),$+(@PSleech_,%ps_network,_)))
    }
  }
  did -d %dname 102 $did($dname,102).sel
}



;; Leech Priority Spinner
ON *:dialog:PS_LeechDialog*:edit:207: {

  var %value = $gettok($did($dname,$did,1).text,1,32)
  if (!%ps.ml-leech.value) return
  if (%value == %ps.ml-leech.value) return

  $PSL_SetPriority($gettok($gettok($did($dname,202).seltext,3,9),5,32),%value)
  $PS_ML-Hist-Up($dname,line,%ps.ml-leech.line)
  did -c $dname 202 %ps.ml-leech.line
}



alias PS_ML-Hist {
  var %a = PS_ML-Hist
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  did -r %dname 202

  var %ps_network = $PS_Network(%ps_a)
  var %ps_c = 1
  var %ps_t = $window(0)
  while (%ps_c <= %ps_t) {
    var %ps_r = $window(%ps_c)
    if (%ps_r = @PSL_LeechLog) goto inc
    if (_Whereis_ isin %ps_r) goto inc
    if ($+(_,%ps_network,_) !isin %ps_r) goto inc
    if (@PSL_ isin %ps_r) {
      var %ps_w = $gettok(%ps_r,4,95)
      var %ps_files = $psl_status(%ps_w,files)

      var %ps_threads = $psl_status(%ps_w,threads)
      if (!%ps_threads) var %ps_threads = 0
      var %ps_targets = $psl_status(%ps_w,targets)
      if (!%ps_targets) var %ps_targets = 0
      var %ps_priority = $psl_status(%ps_w,priority)
      if (!%ps_priority) var %ps_priority = 0 

      did -i %dname 202 2 $PS_MdxTab(+ 0 0 0 %ps_r,+ 0 0 0 $gettok(%ps_r,2,95),+ 0 0 0 %ps_w,+ 0 0 0 $PS_ReadIni(%ps_w,count),+ 0 0 0 %ps_files,+ 0 0 0 %ps_threads,+ 0 0 0 %ps_targets,+ 0 0 0 %ps_priority)
      did -i %dname 202 1 headerdims 0:0 auto:0 auto:0 50:0 50:0 60:0 50:0 50:0
    }
    :inc
    inc %ps_c
  }
}



alias PS_ML-Hist-Up {
  var %ps_a = PS_ML-Hist-Up
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  if (!$dialog(%dname)) return
  if ($did(%dname,111).state != 1) return

  var %ps_l = $3

  if ($2 == trigger) {
    if (!$3) return
    var %ps_t = $did(%dname,202).lines
    var %ps_c = 1
    while (%ps_c <= %ps_t) {
      var %ps_r = $gettok($gettok($did(%dname,202,%ps_c),1,9),6,32)
      if ($+(_,$3) isin %ps_r) {
        var %ps_l = %ps_c
        goto line
      }
      inc %ps_c
    }
  }

  if ($2 == line) {
    if (!$3) return
    var %ps_r = $gettok($gettok($did(%dname,202,$3),1,9),6,32)
    :line

    if (!%ps_r) return

    if (!$window(%ps_r)) {
      did -d %dname 202 %ps_l
      return
    }

    var %ps_w = $gettok(%ps_r,4,95)
    var %ps_files = $psl_status(%ps_w,files)

    var %ps_threads = $psl_status(%ps_w,threads)
    if (!%ps_threads) var %ps_threads = 0
    var %ps_targets = $psl_status(%ps_w,targets)
    if (!%ps_targets) var %ps_targets = 0
    var %ps_priority = $psl_status(%ps_w,priority)
    if (!%ps_priority) var %ps_priority = 0 

    did -o %dname 202 %ps_l $PS_MdxTab(+ 0 0 0 %ps_r,+ 0 0 0 $gettok(%ps_r,2,95),+ 0 0 0 %ps_w,+ 0 0 0 $PS_ReadIni(%ps_w,count),+ 0 0 0 %ps_files,+ 0 0 0 %ps_threads,+ 0 0 0 %ps_targets,+ 0 0 0 %ps_priority)
    did -i %dname 202 1 headerdims 0:0 auto:0 auto:0 50:0 50:0 60:0 50:0 50:0
    return
  }

  $PS_ML-Hist(%dname)
}



alias PS_LeechHistoryDialog {
  var %a = PS_LeechHistoryDialog
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  did -r %dname 102
  var %ps_leechdialog_loop = 1
  var %ps_leechdialog_total = $ini($PS_HistFile,0)
  while (%ps_leechdialog_loop <= %ps_leechdialog_total) {
    var %ps_leechdialog_read = $ini($PS_HistFile,%ps_leechdialog_loop)
    if (($2 == current) && ($window(%ps_leechdialog_read) == $null)) goto go
    if (($2 == history) && ($window(%ps_leechdialog_read) != $null)) goto go
    if ($readini($PS_HistFile,n,%ps_leechdialog_read,data) == $null) {
      if ($ini($PS_HistFile,%ps_leechdialog_read) != $null) {
        $PS_RemIni(PS_LeechDialog,$PS_HistFile,%ps_leechdialog_read)
      }
      goto go
    }
    var %ps_leechdialog_auto = 1
    var %ps_leechdialog_data = $readini($PS_HistFile,n,%ps_leechdialog_read,data)
    did -i %dname 102 2 $PS_MdxTab(+ 0 0 0 %ps_leechdialog_read,+ 0 0 0 $gettok(%ps_leechdialog_data,1,59),+ 0 0 0 $gettok(%ps_leechdialog_data,2,59),+ 0 0 0 $gettok(%ps_leechdialog_data,3,59),+ 0 0 0 $gettok(%ps_leechdialog_data,4,59),+ 0 0 0 $gettok(%ps_leechdialog_data,5,59))
    :go
    inc %ps_leechdialog_loop
  }
  if (%ps_leechdialog_auto == 1) did -i %dname 102 1 headerdims auto:0 60:0 auto:0 auto:0 60:0 60:0
  else did -i %dname 102 1 headerdims 60:0 60:0 60:0 60:0 60:0 60:0
  did -b %dname 3,4,5,6,105,106,107,108
}



alias PS_LeechHistoryDialogUp {
  var %ps_a = PS_LeechHistoryDialogUp
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  if ($did(%dname,110).state != 1) return
  if ($did(%dname,103).state != 1) return
  var %ps_leechdialog_loop = 2
  var %ps_leechdialog_total = $calc($PS_SetSendTotal(%ps_a) + 10)
  while (%ps_leechdialog_loop <= %ps_leechdialog_total) {
    if ($gettok($gettok($did(%dname,102,%ps_leechdialog_loop).text,1,9),6,32) == $1) {
      did -o %dname 102 %ps_leechdialog_loop $PS_MdxTab(+ 0 0 0 $1,+ 0 0 0 $2,+ 0 0 0 $3,+ 0 0 0 $4,+ 0 0 0 $5,+ 0 0 0 $6)
    }
    :go
    inc %ps_leechdialog_loop
  }
  did -i %dname 102 1 headerdims auto:0 auto:0 auto:0 auto:0 45:0 45:0
  did -b %dname 3,4,5,6,105,106
}



alias PS_LeechHistoryDialogRem {
  var %ps_a = PS_LeechHistoryDialogRem
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  if (PS_LeechDialog isin $dname) var %dname = $dname
  elseif (PS_LeechDialog isin $1) var %dname = $1
  else var %dname = $+(PS_LeechDialog,%ps_network)

  if ($did(%dname,103).state == 1) {
    var %ps_leechdialog_loop = 2
    var %ps_leechdialog_total = $calc($PS_SetSendTotal(%ps_a) + 10)
    while (%ps_leechdialog_loop <= %ps_leechdialog_total) {
      if ($gettok($gettok($did(%dname,102,%ps_leechdialog_loop).text,1,9),6,32) == $1) did -d %dname 102 %ps_leechdialog_loop
      :go
      inc %ps_leechdialog_loop
    }
    did -i %dname 102 1 headerdims auto:0 auto:0 auto:0 auto:0 45:0 45:0
    did -b %dname 3,4,5,6,105,106
  }
}



alias PS_LeechDialogReload {
  var %ps_a = PS_LeechDialogReload
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  var %ps_reloadlw_win = $2
  var %ps_reloadlw_winnum = $remove($2,$+(@PSleech_,%ps_network,_))
  if (($window(%ps_reloadlw_win).state == hidden) && ($1 == hide)) return
  if (($window(%ps_reloadlw_win).state != hidden) && ($1 == show)) return
  if ($($+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state),2) == $null) set $+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state) mirc
  var %ps_reloadlw_state = $($+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state),2)
  if (($1 == mirc) && (%ps_reloadlw_state == mirc)) return
  if (($1 == mirc) && (%ps_reloadlw_state != mirc)) set $+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state) mirc
  if (($1 == desktop) && (%ps_reloadlw_state == desktop)) return
  if (($1 == desktop) && (%ps_reloadlw_state != desktop)) set $+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state) desktop
  var %ps_reloadlw_state = $($+(%,psleech_,%ps_network,_,%ps_reloadlw_winnum,_state),2)
  if ($1 == hide) {
    window -h %ps_reloadlw_win
    return
  }
  if ($1 == show) {
    window -w %ps_reloadlw_win
    return
  }
  var %ps_reloadlw_titlebar = $window(%ps_reloadlw_win).title
  var %ps_reloadlw_tmp = $PS_TmpDir(%ps_a)
  savebuf %ps_reloadlw_win %ps_reloadlw_tmp $+ leechbuf.txt"
  window -c %ps_reloadlw_win
  if (%ps_reloadlw_state == desktop) window -ldnak0 %ps_reloadlw_win %PS.winleechloc $+(@PSleech_,%ps_network,_) %PS.winleechfont
  if (%ps_reloadlw_state == mirc) window -lak0 %ps_reloadlw_win %PS.winleechloc $+(@PSleech_,%ps_network,_) %PS.winleechfont
  loadbuf %ps_reloadlw_win %ps_reloadlw_tmp $+ leechbuf.txt"
  .remove %ps_reloadlw_tmp $+ leechbuf.txt"
  titlebar %ps_reloadlw_win %ps_reloadlw_titlebar
}



; ##### Leech Events #####
ON *:CLOSE:*:{
  var %ps_a = PS_OnClose_PS4
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ($+(@PSleech_,%ps_network,_) isin $active) {
    $PS_LeechSaveBuffer(Check,$active)
    .timer 1 3 $!PSTC_Count( [ $PS_LeechTitleInfo($active,series) ] )
    unset [ $+(%,psleech_,%ps_network,_,$remove($active,$+(@PSleech_,%ps_network,_)),_,*) ]
    if ($dialog($+(PS_LeechDialog,%ps_network))) .timer 1 0 $!PS_LeechHistoryDialogRem( $+ [ $active ] $+ )
  }
}

on *:KEYDOWN:@PSleech_*:46: {
  var %ps_a = PS_OnKeydown_PS4_@psleech
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ($sline($active,0).ln == $null) return
  var %ps_lch_rem_count = $sline($active,0).ln
  var %ps_lch_selected = $sline($active,1).ln
  while (%ps_lch_rem_count > 0) {
    dline $active $sline($active,1).ln
    dec %ps_lch_rem_count
  }
  sline $active %ps_lch_selected
  titlebar $active Nick: $PS_LeechTitleInfo($active,nick) - Trigger: $PS_LeechTitleInfo($active,trigger) - Series: $PS_LeechTitleInfo($active,series) - Files: $line($active,0)
}

alias PS_CheckNetWorkChannelLeechLimits {
  var %keywords = LeechShitList,LeechBadList,LeechLimitedList
  var %c = $chan(0)
  var %min = 99
  var %found = $false
  while (%c) {
    var %chan = $chan(%c)
    dec %c
    if ($PSC_isPSonInChannel(%chan)) {
      var %k  = $numtok(%keywords,44)
      while (%k) {
        var %key = $gettok(%keywords,%k,44)
        if ($PSF_GetChanSetting(%key, %chan)) {
          var %list = $ifmatch
          if ($istok(%list,%ps.trigger,44)) {
            if (%k < %min) %min = %k
            %found  = $true
          }
        }
        dec %k
      }
    }
  }
  return $iif(%found,%min,0)
}
