
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####


; ##### ON EVENTS #####
on *:PART:#:{
  var %ps_a = PS_OnPart_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ($nick == $me) {
    $PS_AutoOnOffTimer
  }
}


on *:QUIT: {
  var %ps_a = PS_OnQuit_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick
}


on *:Connect: {
  var %ps_a = PS_OnConnect_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)

  $PS_IgnoreServerReplies(Connect, Joining Channels)
  $PS_AutoOnOffTimer(%ps_a)

  .timer 1 15 $!PS_Init_Whereis_Socket(update)
  .timer 1 90 $!PS_Init_Whereis_Socket(renew)
}


on *:DisConnect: {
  var %ps_a = PS_OnDisConnect_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)

  $PS_FileStatsHashSave(OnDisConnect,,%ps_network)
  $PS_SendFilePurge
  $PS_UploadFilePurge
}


on *:EXIT:{
  var %ps_a = PS_OnExit_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_c = 1
  var %ps_t = $scon(0)
  while (%ps_c <= %ps_t) {
    if ($scon(%ps_c).network != $null) {
      scid $scon(%ps_c) disconnect
    }
    inc %ps_c
  }
  scid -r
}


on *:CLOSE:*:{
  var %ps_a = PS_OnClose_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)

  if ((@PSSends_ isin $active) && ($line($active,0) > 0)) savebuf $active $PS_SendsFile
  if ((@PSQueue_ isin $active) && ($line($active,0) > 0)) savebuf $active $PS_QueueFile
}


on *:INVITE:*: {
  var %ps_a = PS_OnInvite_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  var %hchan = $PS_GetHelpChannelName($chan)

  if (%hchan ischan) {
    join $chan
    if ($me !isop %hchan) part %hchan
    echo  $ps_n -set --> Auto Joined $chan and left %hchan after invite
  }
  elseif ($PS_SetStatus(Invite,Get) != OFF) {
    if ($readini($PS_ChannelsFile(OnInvite_pserve5),n,$chan,#status) != $null) {
      echo $ps_n -sat --> Auto Joining PhotoServe Channel $+ $ps_kh $chan
      join $chan
    }
  }
}


alias PS_Redirect {
  var %chan = $1 , %nick = $2 , %server = $3 , %channels = $4 , %network = $5
  if ($me ison %chan) {
    if ($PSC_isPSonInChannel(%chan)) {
      if (%nick isop %chan) {
        haltdef
        if ($me !isop %chan) echo -sat Redirection command received by %nick in %chan -> Moving to7 %server into6 %channels

        if (!%network) %network = $server(%server).group

        var %connections = $scon(0)
        var %usecon = 0
        while (%connections) {
          var -s %connet = $scon(%connections).network 
          if (%network == %connet) var -s  %usecon = %connections
          dec %connections
        }

        if (%usecon) {
          scon %usecon 
          var %i = $numtok(%channels,44)
          while (%i) {
            var %chan = $gettok(%channels,%i,44)
            if ($me !ison %chan) join %chan
            dec %i
          }
        }
        else {
          if (%network)   server -a %server -g %network -d %network
          server -pom  %server -j %channels 
        }
        if ($me !isop %chan) part %chan

      }
    }
  }

}


on *:NICK: {
  var %ps_a = PS_OnNick_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick
  var %ps_newnick = $newnick

  ;Trigger File nick Change
  var %ps_network = $ps_network(OnNick_pserve5)
  var %ps_nick_name = $nick
  var %ps_nick_newname = $newnick
  var %ps_nick_file = $+($PS_TrigDir,$ps_nickRemove(%ps_nick_name),Trig.txt,")
  var %ps_nick_filenew = $+($PS_TrigDir,$ps_nickRemove(%ps_nick_newname),Trig.txt,")
  if ($isfile(%ps_nick_file)) {
    if ($lower(%ps_nick_name) != $lower(%ps_nick_newname)) {
      .copy -o %ps_nick_file %ps_nick_filenew
      .remove %ps_nick_file
    }
  }
  $PS_UploadNick(%ps_nick_name,%ps_nick_newname)
  if ($me == %ps_nick_name) goto end
  if ($me == %ps_nick_newname) goto end
  var %ps_nick_leechwintotal = $window($+(@PSleech_,%ps_network,_,*),0)
  var %ps_nick_leechloop = 1
  while (%ps_nick_leechloop <= %ps_nick_leechwintotal) {
    var %ps_nick_leechwin = $window($+(@PSleech_,%ps_network,_,*),%ps_nick_leechloop)
    var %ps_nick_winloop_find = $remove(%ps_nick_leechwin,$+(@PSleech_,%ps_network,_))
    if (%ps_nick_name == $PS_LeechTitleInfo(%ps_nick_leechwin,nick)) {  
      set $+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_oldnick) %ps_nick_name
      if (%ps_nick_leechwin != $null) {
        titlebar %ps_nick_leechwin Nick: %ps_nick_newname - Trigger: $PS_LeechTitleInfo(%ps_nick_leechwin,trigger) - Series: $PS_LeechTitleInfo(%ps_nick_leechwin,series) - Files: $line(%ps_nick_leechwin,0) - Gets: $($+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_total),2) - Missing: $($+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_miss),2)
      }
      $PS_LeechHistoryWrite(%ps_nick_leechwin,$PS_LeechTitleInfo(%ps_nick_leechwin,nick),$PS_LeechTitleInfo(%ps_nick_leechwin,trigger),$PS_LeechTitleInfo(%ps_nick_leechwin,series),$($+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_total),2),$PS_LeechTitleInfo(%ps_nick_leechwin,gets))
      echo $ps_n -st --> Updating $+ $ps_kh %ps_nick_name $+ 's nickname to $+ $ps_kh %ps_nick_newname for $+ $ps_kh %ps_nick_leechwin
      var %ps_nick_filename = $($+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_curfile),2)
      if ($($+(%,psleech_,%ps_network,_,%ps_nick_leechloop,_status),2) == ON) {
        .timer 1 30 $!PS_ReStartLeech( $+ [ %ps_nick_leechwin ] $+ )
      }
    }
    inc %ps_nick_leechloop
  }
  :end
}


on *:JOIN:#: {
  var %ps_a = PS_OnJoin_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  ;check for a valid channel
  var %ps_network = $ps_network(OnJoin_pserve5)
  var %ps_onjoin_nick = $nick
  var %ps_onjoin_chan = $chan
  if ($window($+(@PSleech_,%ps_network,_,*),0) == 0) goto end
  if ($PS_Channel(%ps_onjoin_chan) == ON) {
    var %ps_onjoin_wintotal = $window($+(@PSleech_,%ps_network,_,*),0)
    var %ps_onjoin_winloop = 1
    if (%ps_onjoin_nick == $me) {
      while (%ps_onjoin_winloop <= %ps_onjoin_wintotal) {
        var %ps_onjoin_window = $window($+(@PSleech_,%ps_network,_,*),%ps_onjoin_winloop)
        var %ps_onjoin_winloop_find = $remove(%ps_onjoin_window,$+(@PSleech_,%ps_network,_))
        if ($window(%ps_onjoin_window) != $null) {
          var %ps_onjoin_rejoinnick = $PS_LeechTitleInfo(%ps_onjoin_window,nick)
          if (%ps_onjoin_rejoinnick != $null) {
            .timer 1 0 $!PS_ReJoinChan( $+ [ %ps_onjoin_winloop_find ] $+ , $+ [ %ps_onjoin_rejoinnick ] $+ , $+ [ %ps_onjoin_chan ] $+ )
          }
        }
        inc %ps_onjoin_winloop
      }
    }
    else {
      while (%ps_onjoin_winloop <= %ps_onjoin_wintotal) {
        var %ps_onjoin_window = $window($+(@PSleech_,%ps_network,_,*),%ps_onjoin_winloop)
        var %ps_onjoin_winloop_find = $remove(%ps_onjoin_window,$+(@PSleech_,%ps_network,_))
        if ($window(%ps_onjoin_window) == $null) goto go
        ; ##### Check with a nick #####
        if (%ps_onjoin_nick == $PS_LeechTitleInfo(%ps_onjoin_window,nick,join)) {
          echo $ps_n -st --> Found $+ $ps_kh %ps_onjoin_nick in $+ $ps_kh %ps_onjoin_window using a Leech nick match.
          $PS_OnJoinStartWin(%ps_onjoin_winloop_find,%ps_onjoin_nick,join)
          goto go
        }
        ; ##### Check with a host mask #####
        if ($address(%ps_onjoin_nick,3) == $($+(%,psleech_,%ps_network,_,%ps_onjoin_winloop_find,_mask),2)) {
          echo $ps_n -st --> Found $+ $ps_kh %ps_onjoin_nick in $+ $ps_kh %ps_onjoin_window using a Leech host mask match.
          $PS_OnJoinStartWin(%ps_onjoin_winloop_find,%ps_onjoin_nick,join)
        }
        :go
        inc %ps_onjoin_winloop
      }
    }
  }
  :end
  $PS_UploadJoin(%ps_onjoin_nick)
}


alias PS_ReJoinChan {
  var %ps_a = PS_ReJoinChan
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_ReJoinChan)
  if ($2 ison $3) {
    echo $ps_n -st --> Found $+ $ps_kh $2 on $+ $ps_kh $3 and in $+ $ps_kh $+(@PSleech_,%ps_network,_,$1)
    $PS_OnJoinStartWin($1,$2,rejoin)
  }
}


alias PS_OnJoinStartWin {
  var %ps_a = PS_OnJoinStartWin
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_OnJoinStartWin)
  var %ps_onjoinstart_window = $+(@PSleech_,%ps_network,_,$1)
  if ($($+(%,psleech_,%ps_network,_,$1,_status),2) == ON) {
    set $+(%,psleech_,%ps_network,_,$1,_status) Retry
    var %ps_onjoinstart_timer = $rand(30,240)
    echo $ps_n -st --> Resuming leech on $+ $ps_kh %ps_onjoinstart_window for $+ $ps_kh $2 in $+ $ps_kh %ps_onjoinstart_timer seconds
    ; ##### Change the nick in the Leech window #####
    titlebar %ps_onjoinstart_window Nick: $2 - Trigger: $PS_LeechTitleInfo(%ps_onjoinstart_window,trigger) - Series: $PS_LeechTitleInfo(%ps_onjoinstart_window,series) - Files: $line(%ps_onjoinstart_window,0) - Gets: $($+(%,psleech_,%ps_network,_,$1,_total),2) - Missing: $($+(%,psleech_,%ps_network,_,$1,_miss),2)
    .timer 1 %ps_onjoinstart_timer $!PS_StartLeech(PS_OnJoinStartWin, $+ [ %ps_onjoinstart_window ] $+ )
    .timer 1 %ps_onjoinstart_timer set $+(%,psleech_,%ps_network,_,$1,_status) ON
  }
}


alias PS_CheckWindowFile {
  var %ps_a = PS_CheckWindowFile
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_CheckWindowFile)
  var %ps_leechwf_count = 1
  var %ps_leechwf_total = $window($+(@PSleech_,%ps_network,_,*),0)
  while (%ps_leechwf_count <= %ps_leechwf_total) {
    var %ps_leechwf_find = $remove($window($+(@PSleech_,%ps_network,_,*),%ps_leechwf_count),$+(@PSleech_,%ps_network,_))
    var %ps_leechwf_curfile = $($+(%,psleech_,%ps_network,_,%ps_leechwf_find,_curfile),2)
    var %ps_leechwf_curwindow = $+(@PSleech_,%ps_network,_,%ps_leechwf_find)
    if (($nopath($2) == $replace($nopath(%ps_leechwf_curfile),$chr(32),_)) && (($1 == $PS_LeechTitleInfo(%ps_leechwf_curwindow,nick)) || ($1 == $($+(%,psleech_,%ps_network,_,%ps_leechwf_find,_oldnick),2) ))) {
      return %ps_leechwf_find
    }
    inc %ps_leechwf_count
  }
  return
}



; ##### ON FILE EVENTS #####
ctcp *:DCC Send:*: {
  var %ps_a = PS_OnDccSend
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if (_HAVE_ isincs $3) return

  if ($PS_IsLeechNick($nick)) {
    var %ps_dest = $PS_GetTempPath($nick,$3)
    if (%ps_dest) {
      var %ps_temp = $PS_MakePath(%ps_dest)
      dcc get %ps_dest
    }
  }
}


alias PS_IsLeechNick {
  var %ps_a = PS_IsLeechNick
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = nick
  var %ps_counter = $window(@PSLeech_*,0)
  while (%ps_counter > 0) {
    var %ps_window = $window(@PSLeech_*,%ps_counter)
    if ($PS_LeechTitleInfo(%ps_window,nick) == $1) {
      return %ps_window
    }
    dec %ps_counter
  }
}


alias PS_GetTempPath {
  var %ps_a = PS_GetTempPath
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = nick, $2 = filename

  var %ps_counter = $window(@PSLeech_*,0)
  while (%ps_counter > 0) {
    var %ps_window = $window(@PSLeech_*,%ps_counter)
    if (($gettok($window(%ps_window).title,2,32) == $1) && ($replace($nopath($line(%ps_window,1)),$chr(32),_) == $2-)) {
      var %ps_nick_leeches = $addtok(%ps_nick_leeches,%ps_window,59)
    }
    dec %ps_counter
  }

  var %ps_window = %ps_nick_leeches

  ; Determine which drive to download to
  var %ps_downp = %PS.downp

  if ($calc($calc($disk($left(%PS.downp,1)).free / 1024) / 1024) <= %PS.checkfreespace) {
    echo $ps_n -st --> PhotoServe $+ $ps_kh ERROR Your Drive $+ $ps_kh $left(%ps_downp,2) is full
    var %ps_downp = $+($mircdir,Download\)
  }

  ; This has not been tested:
  if ($numtok(%ps_nick_leeches,59) > 1) {
    var %ps_gets = $get($1,0)
    while (%ps_gets > 0) {
      if ($get($1,%ps_gets).file == $2) {
        var %ps_counter = $numtok(%ps_nick_leeches,59)
        while (%ps_counter > 0) {
          var %ps_window = $gettok(%ps_nick_leeches,%ps_counter,59)
          ; does $get path end with a \ ?
          if (($get($1,%ps_gets).path == $+(%PS.downp,PSTemp\,$gettok($window(%ps_window).title,8,32))) || ($line(%ps_window,0) == 0)) {
            var %ps_nick_leeches = $deltok(%ps_nick_leeches,%ps_counter,59)
          }
          dec %ps_counter
        }
      }
      dec %ps_gets
    }
    if ($numtok(%ps_nick_leeches,59) > 1) {
      ; Guessing.. :(
      var %ps_window = $gettok(%ps_nick_leeches,1,59)
    }
  }

  if (%ps_window) {
    return $+(%PS.downp,PSTemp\,$gettok($window(%ps_window).title,8,32),$nofile($line(%ps_window,1)))
  }

  return
}


alias -l ps5handlehave {
  var %ps_frcvd_fullfile = $1 , %ps_frcvd_nopath = $2 , %ps_frcvd_nick = $3
  if ($exists(%ps_frcvd_fullfile))  {
    ; Compressed havelists have $nick prepended to the name. First clean the filename and then decompress
    if ((.zip == $right(%ps_frcvd_fullfile,4)) || (.rar == $right(%ps_frcvd_fullfile,4)) || (.gz == $right(%ps_frcvd_fullfile,3))) {
      var %cleanname = $nofile(%ps_frcvd_fullfile) $+ $right(%ps_frcvd_nopath, - $+ $len($PS_NickRemove(%ps_frcvd_nick $+ _)))
      $PS_MoveFile(%ps_frcvd_fullfile, %cleanname)
      %ps_frcvd_fullfile = $ps_decompress(rem, %cleanname)
      %ps_frcvd_nopath = $nopath(%ps_frcvd_fullfile)
    }
    var %dest = $PS_HaveSavedDir $+ %ps_frcvd_nopath $+ "
    $PS_SortHave(%ps_frcvd_fullfile)
    $PS_MoveFile(%ps_frcvd_fullfile, %dest)
    .timer 1 0 echo $ps_n -st --> Have List From $+ $ps_kh %ps_frcvd_nick Saved to $+ $ps_kh %dest
    $PS_LeechReFilter(%ps_frcvd_nick)
  }

}

on *:FILERCVD:*.*: {
  var %ps_a = PS_OnFileRcvd_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  var %ps_frcvd_network = $ps_network(OnFileRcvd_pserve5)
  var %ps_frcvd_nick = $nick
  var %ps_frcvd_fullfile = $filename
  var %ps_frcvd_nopath = $nopath($filename)

  var %ps_frcvd_xcount = 1
  var %ps_frcvd_xtotal = $ps_netWork_Get(FILESENT,%ps_frcvd_nick,0)
  while (%ps_frcvd_xcount <= %ps_frcvd_xtotal) {
    if ($ps_netWork_Get(FILESENT,%ps_frcvd_nick,%ps_frcvd_xcount,.file) == %ps_frcvd_nopath) {
      var %ps_frcvd_cps = $ps_netWork_Get(FILERCVD,%ps_frcvd_nick,%ps_frcvd_xcount,.cps)
      var %ps_frcvd_size = $ps_netWork_Get(FILERCVD,%ps_frcvd_nick,%ps_frcvd_xcount,.rcvd)
      var %ps_frcvd_secs = $ps_netWork_Get(FILERCVD,%ps_frcvd_nick,%ps_frcvd_xcount,.secs)
      var %ps_frcvd_resume = $ps_netWork_Get(FILERCVD,%ps_frcvd_nick,%ps_frcvd_xcount,.resume)
      var %ps_frcvd_ip = $ps_netWork_Get(FILERCVD,%ps_frcvd_nick,%ps_frcvd_xcount,.ip)
      goto cpsgo
    }
    inc %ps_frcvd_xcount
  }
  :cpsgo

  var %ps_frcvd_rcvd = $calc(%ps_frcvd_size - %ps_frcvd_resume)

  ;  @TriggerList window unzip and load
  if ($regex(%ps_frcvd_nopath,/^TriggerList_.+_\d+\..+/i)) {
    if ((.zip == $right(%ps_frcvd_fullfile,4)) || (.rar == $right(%ps_frcvd_fullfile,4)) || (.gz == $right(%ps_frcvd_fullfile,3))) {
      var %ps_temp = $ps_decompress(rem,%ps_frcvd_fullfile)
    }
    .timer 1 0 $!psTL_MoveToSavedTrigsDir( $+ [ $remove(%ps_frcvd_fullfile,.gz,.rar,.zip) ] $+ )
    return
  }

  ;  HaveList unzip & move & load
  if ($regex(%ps_frcvd_nopath, /_HAVE_.*\.(gz|rar|zip|txt)$/i)) {
    ;; start checking in 1 second. if leech2 has handled the file it would be gone by then
    .timer 1 1 noop $!ps5handlehave( %ps_frcvd_fullfile , %ps_frcvd_nopath , %ps_frcvd_nick )
    return
  }


  ;  PS_Backup download 
  if ($+(Backup_,$PS_NickServSend($nick),_) isin %ps_frcvd_nopath) {
    .copy -o $+(",$filename,") $PS_BackupDir $+ %ps_frcvd_nopath $+ "
    .timer 1 3 .remove $+(",$filename,")
    return
  }

  ;  CSV and Report unzip & move
  if ($ps_nickRemove(%ps_frcvd_nick) $+ _ isin %ps_frcvd_nopath) {
    if (Backup_ $+ $ps_nickRemove(%ps_frcvd_nick) $+ _ isin %ps_frcvd_nopath) return
    if ((.zip == $right(%ps_frcvd_fullfile,4)) || (.rar == $right(%ps_frcvd_fullfile,4)) || (.gz == $right(%ps_frcvd_fullfile,3))) {
      if ((.csv. !isin %ps_frcvd_nopath) && (.txt. !isin %ps_frcvd_nopath)) return
      if (.gz == $right(%ps_frcvd_fullfile,3)) var %ps_time = 1
      else var %ps_time = 3
      var %ps_temp = $ps_decompress(rem,%ps_frcvd_fullfile)
      .timer 1 %ps_time $!PS_MoveZipFileCsv( $+ [ %ps_frcvd_nick ] $+ , $+ [ %ps_frcvd_fullfile ] $+ )
      return
    }
  }

  ;  Auto update of beta scripts.
  if ((Pcode_v == $left(%ps_frcvd_nopath,7)) && (.rar == $right(%ps_frcvd_nopath,4))) {
    if (($PS_ChannelOP(list,check,$nick) == Yes) && ($gettok($readini(" $+ $mircdir $+ mirc.ini",n,options,n5),27,44) == 0)) {
      ;      var %ps_temp = $ps_decompress(rem,%ps_frcvd_fullfile,$mircdir)
      ;      .timer 1 15 $!PS_LoadBetaScript( $+ [ %ps_frcvd_nick ] $+ , $+ [ %ps_frcvd_fullfile ] $+ )
      ;      .timer 1 3 .remove $+(",$filename,")
      return
    }
  }

  ;Determine which window the file was recieved from
  var %ps_frcvd_curwin = $PS_CheckWindowFile(%ps_frcvd_nick,%ps_frcvd_fullfile)

  ;  if file is not from a leech stop processing
  if (%ps_frcvd_curwin == $null) {
    .timer 1 1 $!PSDV_LogMiscDownload( [ $nick ] , [ %ps_frcvd_fullfile ] )
    return
  }

  var %ps_frcvd_window = $+(@PSleech_,%ps_frcvd_network,_,%ps_frcvd_curwin)
  var %ps_frcvd_windowfile = $($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_curfile),2)
  var %ps_frcvd_tmpcurfile = %ps_frcvd_windowfile
  var %ps_frcvd_trigger = $PS_LeechTitleInfo(%ps_frcvd_window,series)
  var %ps_frcvd_psget = $PS_LeechTitleInfo(%ps_frcvd_window,trigger)
  var %ps_frcvd_windownick = $PS_LeechTitleInfo(%ps_frcvd_window,nick)
  var %ps_frcvd_trgfile = $PS_Readini(%ps_frcvd_trigger,findfile,39)


  $PSST_RecordGet(%ps_frcvd_nick, $iif(%ps_frcvd_trigger == -, $null, %ps_frcvd_trigger), !psget, -1, $false)
  $PS_DialogGigCurrentCount(FileRcvd)

  if (%ps_frcvd_trigger == -) goto leechskiprem

  ; Chekc CRC of downloaded file
  var %ps_frcvd_crcfile = $PS_Crc($+(",%ps_frcvd_fullfile,"))
  var %ps_frcvd_csvfile = $PS_Readini(%ps_frcvd_trigger,csv)
  var %ps_frcvd_crccsv = $PS_CrcCheck(Filercvd1,$read($+(",%ps_frcvd_csvfile,"),wn, $replace(%ps_frcvd_nopath,$chr(95),$chr(63)) $+ * $+ %ps_frcvd_crcfile $+ * ))
  if (%ps_frcvd_crccsv != $null) {
    $PSTC_IncFileCount(%ps_frcvd_trigger)
    $PSTC_IncByteCount(%ps_frcvd_trigger, %ps_frcvd_size)
  }
  else {
    if (%PS.lch.fail.del == ON) {
      var %ps_frcvd_crcexpected = $upper($PS_CrcCheck(Filercvd2,$gettok($read(" $+ %ps_frcvd_csvfile $+ ",wn, %ps_frcvd_nopath $+ * ),3,44)))
      if (%ps_frcvd_crcexpected == $null) {
        var %ps_frcvd_crcexpected = 04ERROR crc for %ps_frcvd_nopath Not Found.
        return
      }
      echo $ps_n -st --> 4CRC Mismatch! Deleting File: $+ $ps_kh %ps_frcvd_nopath CRC: $+ $ps_kh %ps_frcvd_crcfile Not found in $+ $ps_kh $nopath(%ps_frcvd_csvfile) Expected CRC: $+ $ps_kh %ps_frcvd_crcexpected
      .timer 1 3 .remove %ps.recycle $+(",$filename,")
      inc $+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_badcrc)
      if ($($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_badcrc),2) >= 5) {
        set $+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_badcrc) 0
        .signal PSCleech_BadCrc %ps_frcvd_nick %ps_frcvd_window
        return
      }
    }
    goto leechskiprem
  }

  ;  Determine the root path
  if (%ps_frcvd_trigger == -) {
    var %ps_frcvd_root = %PS.downp $+ Misc\
    goto finalpath
  }
  if (%PS.sortfiles == $null) set %PS.sortfiles Yes
  if (%PS.sortfiles == Yes) var %ps_frcvd_root = $PS_Readini(%ps_frcvd_trigger,path)
  else var %ps_frcvd_root = $+(%PS.downp,%ps_frcvd_trigger,\)

  ;  Determine the subdir path
  if (%PS.makedownp == $null) set %PS.makedownp Yes
  if (%PS.makedownp == Yes) var %ps_frcvd_sortpath = $nofile(%ps_frcvd_windowfile)
  else var %ps_frcvd_sortpath = \ $+ $nofile(%ps_frcvd_windowfile)
  if (%ps_frcvd_sortpath == $null) var %ps_frcvd_sortpath = \unknown\

  ;  Assemble final path and preliminary filename
  :finalpath
  var %ps_frcvd_destpath = $replace($+(%ps_frcvd_root,%ps_frcvd_sortpath),\\,\)
  var %ps_frcvd_destfile = $nopath(%ps_frcvd_windowfile)
  var %ps_frcvd_dest = %ps_frcvd_destpath $+ %ps_frcvd_destfile

  ;  Make the final destination path
  if (!$isdir(%ps_frcvd_destpath)) {
    var %ps_frcvd_makepath = $PS_MakePath(%ps_frcvd_destpath)
  }

  ;  Determine final filename
  if ($isfile($+(",%ps_frcvd_dest,"))) {
    var %ps_frcvd_xcrc = $PS_Crc($+(",%ps_frcvd_dest,"))
    if (%ps_frcvd_xcrc != %ps_frcvd_crcfile) {
      var %ps_frcvd_xnumtok = $numtok(%ps_frcvd_destfile,46)
      var %ps_frcvd_xfile = $gettok(%ps_frcvd_destfile,1 - $calc(%ps_frcvd_xnumtok - 1),46)
      var %ps_frcvd_xext = $gettok(%ps_frcvd_destfile,%ps_frcvd_xnumtok,46)
      var %ps_frcvd_xnum = 0
      :xexists
      inc %ps_frcvd_xnum
      var %ps_frcvd_xchk = $+(%ps_frcvd_xfile,_,%ps_frcvd_xnum,.,%ps_frcvd_xext)
      var %ps_frcvd_xdest = $+(%ps_frcvd_destpath,%ps_frcvd_xchk)
      if ((!$isfile($+(",%ps_frcvd_xdest,"))) && (%ps_frcvd_xdest != $null)) goto xcancopy
      goto xexists
      :xcancopy
      echo $ps_n -st --> 4CRC Mismatch Existing File: $+ $ps_kh $nopath(%ps_frcvd_dest) CRC: $+ $ps_kh %ps_frcvd_xcrc New File: $+ $ps_kh $nopath(%ps_frcvd_xdest) CRC: $+ $ps_kh %ps_frcvd_crcfile Path: $+ $ps_kh $nofile(%ps_frcvd_xdest) Trigger: $+ $ps_kh %ps_frcvd_trigger Leech Window: $+ $ps_kh %ps_frcvd_window
      var %ps_frcvd_dest = %ps_frcvd_xdest
    }
  }

  ;  Check for free space on destination drive
  if ($file($+(",$filename,")).size >= $disk($left(%ps_frcvd_dest,1)).free) {
    echo $ps_n -ast --> Leech File: $+ $ps_kh $nopath($filename) not moved, not enough free space on drive $+ $ps_kh $left(%ps_frcvd_dest,1) $+ :
    goto leechskiprem
  }

  ;  Copy/Remove (Move) the file to its determined destination folder.

  ;if (%ps.move.legacy == on) .timer 1 0 .copy -o $+(",$filename,") $+(",%ps_frcvd_dest,")
  ;else .timer 1 0 .copy -o $shortfn($+(",$filename,")) $+($shortfn($nofile(%ps_frcvd_dest)),$nopath(%ps_frcvd_dest))

  ;if (%ps.move.legacy == on) .timer 1 3 .remove $+(",$filename,")
  ;else .timer 1 3 .remove $shortfn($+(",$filename,"))

  var %dummy = $PS_MoveFile($filename,%ps_frcvd_dest)

  :leechskiprem
  ;  Continue with next file in the leech
  inc $+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_total)
  dline %ps_frcvd_window 1
  titlebar %ps_frcvd_window Nick: %ps_frcvd_windownick - Trigger: %ps_frcvd_psget - Series: %ps_frcvd_trigger - Files: $line(%ps_frcvd_window,0) - Gets: $($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_total),2) - Missing: $($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_miss),2)
  $PSDV_LogLeechDownload($nick, %ps_frcvd_trigger, %ps_frcvd_sortpath $+ %ps_frcvd_destfile)

  ;  Write lastdl time to trigger data
  $PS_WriteIni(PS_LeechHistoryWrite,%ps_frcvd_trgfile,%ps_frcvd_trigger,lastdl,$ctime)

  ; Update Leech History file with current data
  .timer 1 0 $!PS_LeechHistoryWrite( [ %ps_frcvd_window ] , [ %ps_frcvd_windownick ] , [ %ps_frcvd_psget ] , [ %ps_frcvd_trigger ] , [ $($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_total),2) ] , [ $PS_LeechTitleInfo(%ps_frcvd_window,gets) ] )

  ; Update Leech History dialog if open
  if ($dialog($+(PS_LeechDialog,%ps_network))) .timer 1 0 PS_LeechHistoryDialogUp %ps_frcvd_window %ps_frcvd_windownick %ps_frcvd_psget %ps_frcvd_trigger $line(%ps_frcvd_window,0) $($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_total),2)

  ;  Check leech retry setting
  if ($($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_status),2) == Retry) return

  ;  Check download drive for adequate free space
  if (%PS.checkfreespace != $null) {
    var %ps_frcvd_drivespace = $PS_FileSize($disk($left(%ps_frcvd_dest,1)).free,2)
    if (MB isin %ps_frcvd_drivespace) {
      var %ps_frcvd_drivespace = $remove(%ps_frcvd_drivespace,MB)
      if (%ps_frcvd_drivespace < %PS.checkfreespace) {
        echo $ps_n -sat --> The leech from $+ $ps_kh %ps_frcvd_window has been stopped because there is less then $+ $ps_kh %PS.checkfreespace MB free on your hard drive.
        set $+(%,psleech_,%ps_frcvd_network,_,$remove(%ps_frcvd_curwin,$+(@PSleech_,%ps_frcvd_network,_)),_status) OFF
        return
      }
    }
  }

  ;  Calculate get delay and get next file
  if (%PS.getdelay == $null) set %PS.getdelay 10
  var %ps_frcvd_getdelay = %PS.getdelay
  if ($($+(%,psleech_,%ps_frcvd_network,_,%ps_frcvd_curwin,_getdelay),2) != $null) {
    var %ps_frcvd_getdelay = $ifmatch
  }
  if ((%PS.makedownp != yes) || (%PS.sortfiles != yes)) var %ps_frcvd_getdelay = $calc(%ps_frcvd_getdelay + 30)

  ; request the next file to download
  .timer 1 %ps_frcvd_getdelay $!PS_StartLeech(PS_OnFileRcvd, $+ [ %ps_frcvd_window ] $+ )

  ; save leech window buffer
  .timer 1 $round($calc(%ps_frcvd_getdelay / 2),1) $!PS_LeechSaveBuffer(Check, [ %ps_frcvd_window ] )

}

alias PS_MoveFile {
  var %source = $1 , %destination = $2
  var %re = $PS_MakePath($nofile(%destination))
  var %destination = " $+ $remove(%destination,") $+ "
  var %source = " $+ $remove(%source,") $+ "
  if (($isfile(%destination)) && ($isfile(%source))) .remove %destination
  .rename %source %destination
}


on *:GETFAIL:*.*: {
  var %ps_a = PS_OnGetFail_PS5
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1- * $filename

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  var %ps_gfail_network = $ps_network(OnGetFail_pserve5)
  var %ps_gfail_nick = $nick
  var %ps_gfail_fullfile = $filename
  var %ps_gfail_nopath = $nopath($filename)

  if (.csv == $right($nopath($filename),4)) {
    echo $ps_n -st --> Download of $ps_kh $nopath($filename) 4Failed Deleting incomplete .CSV file.
    .remove $+(",$filename,")
    return
  }

  if (Triggerlist_*txt* iswm $nopath($filename)) {
    echo $ps_n -st --> Download of $ps_kh $nopath($filename) 4Failed Deleting Triggerlist.
    .remove $+(",$filename,")
    return
  }

  if (_HAVE_ isin $nopath($filename)) remove $qt($filename)

  var %ps_gfail_xcount = 1
  var %ps_gfail_xtotal = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,0)
  while (%ps_gfail_xcount <= %ps_gfail_xtotal) {
    if ($ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.file).file == %ps_gfail_nopath) {
      var %ps_gfail_cps = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.cps)
      var %ps_gfail_size = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.rcvd)
      var %ps_gfail_secs = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.secs)
      var %ps_gfail_resume = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.resume)
      var %ps_gfail_ip = $ps_netWork_Get(GETFAIL,%ps_gfail_nick,%ps_gfail_xcount,.ip)
      goto cpsgo
    }
    inc %ps_gfail_xcount
  }
  :cpsgo

  var %ps_gfail_rcvd = $calc(%ps_gfail_size - %ps_gfail_resume)

  if (TriggerList_ $+ $ps_nickRemove($me) $+ _ isin %ps_fsent_nopath) {
    .timer 1 3 .remove $+(",$filename,")
    return
  }

  if (($remove($PS_TrigReplace(%PS.trigger),!) $+ _HAVE_ isin %ps_fsent_nopath) && (.txt. isin %ps_fsent_nopath)) {
    .timer 1 3 .remove $+(",$filename,")
    return
  }

  if ($+(Backup_,$ps_nickRemove($nick),_) isin %ps_gfail_nopath) {
    .timer 1 3 .remove $+(",$filename,")
    return
  }

  if (%PS.getfaildelay == $null) set %PS.getfaildelay 10

  var %ps_gfail_curwin = $PS_CheckWindowFile(%ps_gfail_nick,%ps_gfail_fullfile)
  if (%ps_gfail_curwin == $null) return

  var %ps_gfail_window = $+(@PSleech_,%ps_gfail_network,_,%ps_gfail_curwin)
  var %trig = $PS_LeechTitleInfo(%ps_gfail_window)
  $PSST_RecordGet($nick, $iif(%trig == -, $null, %trig), !psget, -1, $false)
  $PS_DialogGigCurrentCount(GetFail)

  var %ps_gfail_failremove = $($+(%,psleech_,%ps_gfail_network,_,%ps_gfail_curwin,_failremove),2)
  if (%ps_gfail_failremove == NO) goto go
  elseif (%ps_gfail_failremove == YES) {
    .timer 1 3 .remove $+(",$filename,")
    goto go
  }
  elseif (%PS.lch.fail.del == ON) {
    .timer 1 3 .remove $+(",$filename,")
    goto go
  }
  :go

  if ($($+(%,psleech_,%ps_gfail_network,_,%ps_gfail_curwin,_failmove),2) == MOVE) goto move
  if (%PS.lch.fail.move == Move) goto move
  goto timer
  :move
  aline %ps_gfail_window $line(%ps_gfail_window,1)
  dline %ps_gfail_window 1
  :timer
  var %ps_leechgf_delay = %PS.getfaildelay
  if ($($+(%,psleech_,%ps_gfail_network,_,%ps_gfail_curwin,_getfaildelay),2) != $null) var %ps_leechgf_delay = $ifmatch
  echo $ps_n -st --> PhotoServe 4Download Failed! $ps_kn $+ From: $+ $ps_kh $nick $ps_kn $+ File: $+ $ps_kh $nopath($filename) $ps_kn $+ Attempting to Restart Leech: $+ $ps_kh %ps_gfail_window $ps_kn $+ in $+ $ps_kh %ps_leechgf_delay $ps_kn $+ seconds
  .timer 1 %ps_leechgf_delay $!PS_StartLeech(PS_OnGetFail, $+ [ %ps_gfail_window ] $+ )

}


alias PS_DccPacketSize {
  var %ps_a = PS_DccPacketSize
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_read = $gettok($readini($mircdir $+ mirc.ini,n,options,n0),21,44)
  return %ps_read
}


alias PS_MoveZipFileCsv {
  var %ps_a = PS_MoveZipFileCsv
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if (.csv. isin $nopath($2-)) var %ps_type = .csv
  if (.txt. isin $nopath($2-)) var %ps_type = .txt
  if (%ps_type $+ .gz isin $nopath($2-)) var %ps_source = $+(",$remove($2-,.zip,.rar,.gz,.csv,.txt),%ps_type,")
  else var %ps_source = $+(",$remove($2-,$ps_nickRemove($1) $+ _,.zip,.rar,.gz,.csv,.txt),%ps_type,")
  var %ps_dest = $+($remove($2-,$ps_nickRemove($1) $+ _,.zip,.rar,.gz,.csv,.txt),%ps_type)
  if ($isfile(%ps_source)) {
    echo $ps_n -st --> %ps_type saved to $+ $ps_kh $getdir(%ps_type) $+ $nopath(%ps_dest)
    if (%ps_source != $+(",$getdir(%ps_type),$nopath(%ps_dest),")) {
      .copy -o %ps_source $+(",$getdir(%ps_type),$nopath(%ps_dest),")
      .remove %ps_source
    }
  }
}


alias PS_LoadBetaScript {
  var %ps_a = PS_LoadBetaScript
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($findfile($mircdir,ps_install.mrc,0,1) > 0) {
    .notice $1 Photoserve update in progress.
    .load -rs ps_install.mrc
  }
}


;; Sort Havelist @param havelist filename with full path @return void
alias PS_SortHave {
  var %havelist = $1-
  var %ps_a = PS_SortHave
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-
  %havelist = " $+ $remove(%havelist,") $+ "

  window -lhs @PS_SortHave
  loadbuf 4-99999 @PS_SortHave %havelist
  iline @PS_SortHave 1 Made by PhotoServe v $+ $PS.Version.main $PS.Version.beta
  iline @PS_SortHave 2 Total Files: $calc($line(@PS_SortHave, 0) - 1)
  iline @PS_SortHave 3 -
  savebuf @PS_SortHave %havelist
  window -c @PS_SortHave
}


; ##### ON NOTICE #####
on ^*:NOTICE:DCC Send*:*: {
  var %ps_a = PS_OnNotice_PS5_DccSend
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  haltdef
  var %ps_network = $ps_network(OnNotice_pserve5_dccsend)
  var %ps_leechds_curwindow = $+(@PSleech_,%ps_network,_,$PS_CheckWindowFile($nick,$3))
  if ($line(%ps_leechds_curwindow,0) > 0) {
    cline 12 %ps_leechds_curwindow 1
    .timer $+ %ps_leechds_curwindow off
  }
  if ((.csv isin $3) || (_HAVE_ isin $3)) echo $ps_n -st --> Receiving $+ $ps_kh $3-
}


on *:DCCSERVER:Send: {
  var %ps_a = PS_OnDccServer_PS5_Send
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  ;  echo $ps_n -st --> 8* [ $nick ] , [ $nopath($filename) ] , [ %ps_network ]

  var %ps_leechds_curwin = $PS_CheckWindowFile( [ $nick ] , [ $nopath($filename) ] )

  if ($line($+(@PSleech_,%ps_network,_,%ps_leechds_curwin),0) > 0) {
    cline 12 $+(@PSleech_,%ps_network,_,%ps_leechds_curwin) 1
  }

  if ((.csv isin $nopath($filename)) || (_HAVE_ isin $nopath($filename))) {
    echo $ps_n -st --> Receiving $+ $ps_kh $nopath($filename)
  }

}


on ^*:NOTICE:*Sorry my sends are full. The file*:?: {
  var %ps_network = $ps_network(OnNotice_pserve5_sendsfull)
  var %ps_leechds_curwindow = $+(@PSleech_,%ps_network,_,$PS_CheckWindowFile($nick,$8))
  if ($line(%ps_leechds_curwindow,0) > 0) {
    cline 3 %ps_leechds_curwindow 1
    .timer $+ %ps_leechds_curwindow off
  }
}


on ^*:NOTICE:@PSleech*:?: {
  var %ps_a = PS_OnNotice_PS5_@PSleech
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ($window(@PS_LeechTest) == $null) window -lh @PS_LeechTest
  aline @PS_LeechTest $time $network $nick $1-
  haltdef
  var %ps_network = $ps_network(OnNotice_pserve5)
  if ($2 == DLqueueU) {
    echo $ps_n -st --> $nick Sorry I only allow a user to queue $+ $ps_kh $3 file(s).  File $+ $ps_kh $4 not queue'ed.
    var %ps_notice_color = 5
  }
  if ($2 == DLqueueT) {
    echo $ps_n -st --> $nick Sorry I only allow a total of $+ $ps_kh $3 queue'ed file(s).  File $+ $ps_kh $4 not queue'ed.
    var %ps_notice_color = 5
  }
  if ($2 == DLnoqueueT) {
    echo $ps_n -st --> $nick Sorry I do not offer a Queue and I only allow $+ $ps_kh $3 send(s) total.  File $+ $ps_kh $4 not queue'ed.
    var %ps_notice_color = 5
  }
  if ($2 == DLnoqueueU) {
    echo $ps_n -st --> $nick Sorry I do not offer a Queue and I only allow $+ $ps_kh $3 send(s) per user.  File $+ $ps_kh $4 not queue'ed.
    var %ps_notice_color = 5
  }

  if ($2 == DLsendU) {
    echo $ps_n -st --> $nick Sorry you have reached your download limit.  The file $+ $ps_kh $4 is $+ $ps_kh $3 in my send queue.
    var %ps_notice_color = 8
  }
  if ($2 == DLsendT) {
    echo $ps_n -st --> $nick Sorry my sends are full.  The file $+ $ps_kh $4 is $+ $ps_kh $3 in my send queue.
    var %ps_notice_color = 8
  }

  if ($2 == DLwait) {
    echo $ps_n -st --> $nick Trigger $+ $ps_kh $3 Pause of $+ $ps_kh $4 seconds for the not found.
    goto end
  }
  if ($2 == DLnotfound) {
    if (%PS.shownotfound != No) echo $ps_n -st --> $nick Trigger $+ $ps_kh $3 File $+ $ps_kh $4 Not Found.
    $PS_OnNotFound(OnNotice,$PS_RemoveSpaces($remove($4,not found)))
    goto end
  }

  if ($2 == DLpath) {
    if (%PS.hidepathmsg != Yes) echo $ps_n -st --> $nick This series $+ $ps_kh $3 needs a path.
    goto end
  }

  if ($2 == DLqueueE) {
    echo $ps_n -st --> $nick The file $+ $ps_kh $4 is already in my send queue, please wait.
    goto end
  }

  if ($2 == DLvoice) {
    echo $ps_n -st --> $nick You must be verified (+v) and on a valid channel to receive files.
    var %ps_voice_winloop = 1
    var %ps_voice_wintotal = $window($+(@PSleech_,%ps_network,_,*),0)
    while (%ps_voice_winloop <= %ps_voice_wintotal) {
      var %ps_voice_winloop_find = $remove($window($+(@PSleech_,%ps_network,_,*),%ps_voice_winloop),$+(@PSleech_,%ps_network,_))
      var %ps_voice_window = $+(@PSleech_,%ps_network,_,%ps_voice_winloop_find)
      if ($nick == $PS_LeechTitleInfo(%ps_voice_window,nick)) {
        .timer 1 300 $!PS_OnJoinStartWin( $+ [ %ps_voice_winloop ] $+ , $+ [ $nick ] $+ ,voice)
      }
      inc %ps_voice_winloop
    }
    goto end
  }
  var %ps_notice_win = $PS_CheckWindowFile( [ $nick ] , [ $4 ] )
  var %ps_notice_window = $+(@PSleech_,%ps_network,_,%ps_notice_win)
  if ((%ps_notice_win != $null) && (%ps_notice_color != $null)) cline %ps_notice_color %ps_notice_window 1
  :end
}



alias PS_OnNotFound {
  var %ps_a = PS_OnNotFound
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  var %ps_leechnf_notfound = $nopath($2)
  if (%PS.notfounddelay == $null) set %PS.notfounddelay 5
  if (%PS.notfound == $null) set %PS.notfound 1
  var %ps_leechnf_winloop = 1
  var %ps_leechnf_wintotal = $window($+(@PSleech_,%ps_network,_,*),0)
  while (%ps_leechnf_winloop <= %ps_leechnf_wintotal) {
    var %ps_leechnf_winloop_find = $remove($window($+(@PSleech_,%ps_network,_,*),%ps_leechnf_winloop),$+(@PSleech_,%ps_network,_))
    if (%ps_leechnf_notfound == $nopath($($+(%,psleech_,%ps_network,_,%ps_leechnf_winloop_find,_curfile),2)) ) {
      var %ps_leechnf_curwin = %ps_leechnf_winloop_find
      goto endwinloop
    }
    inc %ps_leechnf_winloop
  }
  :endwinloop
  if (%ps_leechnf_curwin == $null) goto end
  var %ps_leechnf_window = $+(@PSleech_,%ps_network,_,%ps_leechnf_curwin)
  if ($($+(%,psleech_,%ps_network,_,$remove(%ps_leechnf_window,$+(@PSleech_,%ps_network,_)),_status),2) != Retry) {
    if (%PS.savemiss != No) {
      if ($($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_miss),2) == $null) {
        $PS_Write(%ps_a,-c,$PS_ListDir $+ $PS_LeechTitleInfo(%ps_leechnf_window,series) $+ _miss.txt")
      }
    }
    $PS_Write(%ps_a,$PS_ListDir $+ $PS_LeechTitleInfo(%ps_leechnf_window,series) $+ _miss.txt",$($+(%,psleech_,%ps_network,_,%ps_leechnf_winloop_find,_curfile),2))
    dline %ps_leechnf_window 1
    inc $+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_miss)
    titlebar %ps_leechnf_window Nick: $PS_LeechTitleInfo(%ps_leechnf_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leechnf_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leechnf_window,series) - Files: $line(%ps_leechnf_window,0) - Gets: $($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_total),2) - Missing: $($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_miss),2)
    if ($line(%ps_leechnf_window,0) == 0 ) goto end
  }
  set %ps_leechnf_nftotal %PS.notfound
  set %ps_leechnf_delay %PS.notfounddelay
  if ($($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_Inotfound),2) != $null) set %ps_leechnf_nftotal $ifmatch
  if ($($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_notfounddelay),2) != $null) set %ps_leechnf_delay $ifmatch
  if ($($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_notfound),2) > %ps_leechnf_nftotal) unset $ifmatch
  inc $+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_notfound)
  .timernfdelay1 off
  .timernfdelay1 1 %ps_leechnf_delay unset $+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_notfound)
  if ($+(%,psleech_,%ps_network,_,%ps_leechnf_curwin,_notfound) >= %ps_leechnf_nftotal) {
    .timer 1 %ps_leechnf_delay $!PS_StartLeech(%ps_a, $+ [ %ps_leechnf_window ] $+ )
  }
  else $PS_StartLeech(%ps_a, $+ [ %ps_leechnf_window ] )
  :end
  unset %ps_leechnf_*
}



alias PS_FindTriggerRest {
  var %ps_a = PS_FindTriggerRest
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_rest_in = $remove($mid($strip($2-),$pos($strip($2-),resets in)),resets in,~REST~)
  var %ps_rest_min = $left(%ps_rest_in,$calc($pos(%ps_rest_in,mins) - 1))
  var %ps_rest_sec = $remove($right(%ps_rest_in,$calc($len(%ps_rest_in) - ($pos(%ps_rest_in,mins) + 4))),secs)
  var %ps_rest_total = $calc((%ps_rest_min * 60) + %ps_rest_sec)
  $PS_LeechBusy($1,%ps_rest_total)
}



; Still must check if getting from the same nick twice this will cause a problem
alias PS_LeechBusy {
  var %ps_a = PS_LeechBusy
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_LeechBusy)
  var %ps_leechsb_nick = $1
  var %ps_leechsb_winloop = 0
  var %ps_leechsb_wintotal = $window($+(@PSleech_,%ps_network,_,*),0)
  :winloop
  inc %ps_leechsb_winloop
  if (%ps_leechsb_winloop > %ps_leechsb_wintotal) goto endwinloop
  var %ps_leechsb_winloop_find = $remove($window($+(@PSleech_,%ps_network,_,*),%ps_leechsb_winloop),$+(@PSleech_,%ps_network,_))
  set %ps_leechsb_window $+(@PSleech_,%ps_network,_,%ps_leechsb_winloop_find)
  set %ps_leechsb_nickcheck $PS_LeechTitleInfo(%ps_leechsb_window,nick)
  if ((%ps_leechsb_nick == %ps_leechsb_nickcheck) || (%ps_leechsb_nick == $($+(%,psleech_,%ps_network,_,%ps_leechsb_winloop,_oldnick),2))) {
    set %ps_leechsb_curwin %ps_leechsb_winloop
    goto endwinloop
  }
  goto winloop
  :endwinloop
  if (%ps_leechsb_curwin == $null) goto end
  if (%PS.busyretry == $null) set %PS.busyretry 30
  if (%PS.busyretry < 15) set %PS.busyretry 30
  set %ps_leechsb_delay %PS.busyretry
  if ($($+(%,psleech_,%ps_network,_,%ps_leechsb_curwin,_busyretry),2) != $null) set %ps_leechsb_delay $ifmatch
  if ($2 != $null) {
    echo $ps_n -st --> Rest for $+ $ps_kh %ps_leechsb_nick will try again in $+ $ps_kh $2 seconds.
    titlebar %ps_leechsb_window Nick: $PS_LeechTitleInfo(%ps_leechsb_window,nick) - Trigger: $PS_LeechTitleInfo(%ps_leechsb_window,trigger) - Series: $PS_LeechTitleInfo(%ps_leechsb_window,series) - Files: $line(%ps_leechsb_window,0) - Gets: $($+(%,psleech_,%ps_network,_,%ps_leechsb_curwin,_total),2) - Missing: $($+(%,psleech_,%ps_network,_,%ps_leechsb_curwin,_miss),2) - RESTING
    .timer 1 $2 $!PS_StartLeech(PS_LeechBusy1, $+ [ %ps_leechsb_window ] $+ )
  }
  else {
    echo $ps_n -st --> Triggers for $+ $ps_kh %ps_leechsb_nick are busy will try again in $+ $ps_kh %ps_leechsb_delay seconds.
    .timer 1 %ps_leechsb_delay $!PS_StartLeech(PS_LeechBusy2, $+ [ %ps_leechsb_window ] $+ )
  }
  :end
  unset %ps_leechsb_*
}



; ##### Leech purge download dir for completed leeches #####
alias PS_LeechPurgeDir {
  var %ps_a = PS_LeechPurgeDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp = $findfile($2,*.*,0,PS_RemoveFileDir file $1-)
  .timer 1 2 $!PS_RemoveFileDir(dir, [ $2 ] )
}


alias PS_RemoveFileDir {
  var %ps_a = PS_RemoveFileDir
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($1 == file) {
    .timer 1 0 .remove " $+ $2- $+ "
  }
  if ($1 == dir) {
    var %ps_total = $finddir($2-,*,0)
    while (%ps_total > 0) {
      .timer 1 1 .rmdir " $+ $finddir($2,*,%ps_total) $+ \"
      dec %ps_total
    }
    .timer 1 3 .rmdir " $+ $2 $+ "
    echo $ps_n -st --> PhotoServe Directory:07 $2 Purged & Removed
  }
}


; ##### Leech flood restart #####
raw 439:*:{
  var %ps_network = $ps_network(raw439)
  var %ps_time = $calc($9 + 1)
  var %ps_count = 1
  var %ps_total = $window($+(@PSleech_,%ps_network,_,*),0)
  while (%ps_count <= %ps_total) {
    var %ps_window = $window($+(@PSleech_,%ps_network,_,*),%ps_count)
    if ($PS_LeechTitleInfo(%ps_window,nick) == $2) {
      echo $ps_n -st --> Leech $+ $ps_kh %ps_window for $+ $ps_kh $2 restarting in $+ $ps_kh %ps_time seconds.
      .timer 1 %ps_time $!PS_StartLeech(PS_raw439, $+ [ %ps_window ] $+ )
    }
    inc %ps_count
  }
}


on *:snotice:*d protection activated*: {
  var %ps_a = PS_OnSnotice_PS5_protectionactivated
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if (%PS.lch.sfp.restart == Yes) PS_ReStartCycle
  else PS_ReStart
}


alias PS_ReStart {
  var %ps_a = PS_ReStart
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(PS_ReStart)
  var %ps_restart_leech = 1
  var %ps_restart_leech_tmp = $PS_SetSendTotal(%ps_a)
  while (%ps_restart_leech <= %ps_restart_leech_tmp) {
    if ($window($+(@PSleech_,%ps_network,_,%ps_restart_leech)) != $null) {
      .timer 1 $calc($calc(%ps_restart_leech * 5) + 60) PS_ReStartLeech $ifmatch
      echo $ps_n -sat --> Restarting $+ $ps_kh $ifmatch in $+ $ps_kh $calc($calc(%ps_restart_leech * 5) + 60) Seconds.
    }
    inc %ps_restart_leech
  }
}


alias PS_ReStartCycle {
  var %ps_a = PS_ReStartCycle
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_channelfile = $PS_ChannelsFile(PS_ReStartCycle)
  var %ps_restart_cycle_loop = 1
  var %ps_restart_cycle_loop_tmp = $ini(%ps_channelfile,0)
  while (%ps_restart_cycle_loop <= %ps_restart_cycle_loop_tmp) {
    var %ps_restart_cycle_chan = $ini(%ps_channelfile,%ps_restart_cycle_loop)
    if ($me ison %ps_restart_cycle_chan) {
      if (!%PS.getdelay) set %PS.getdelay 10
      .timer 1 0 echo $ps_n -sat --> Server Flood Protection Leech Auto Restart.  Performing a $+ $ps_kh /hop %ps_restart_cycle_chan in $+ $ps_kh 60 seconds
      .timer 1 60 hop -c %ps_restart_cycle_chan
    }
    inc %ps_restart_cycle_loop
  }
}
; ##### Leech flood restart #####


alias PS_DlgChanVoice {
  var %ps_a = PS_DlgChanVoice
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_channelfile = $PS_ChannelsFile(PS_DlgChanVoice)
  did -r PS_Dlg_AX 613
  set %ps_dlgchan_chan $did(PS_Dlg_AX,604,$did(PS_Dlg_AX,604,1).sel).text
  set %ps_dlgchan_total $ini(%ps_channelfile,%ps_dlgchan_chan,0)
  if (%ps_dlgchan_total == $null) set %ps_dlgchan_total 0
  var %ps_dlgchan_loop = 0
  :loop
  inc %ps_dlgchan_loop
  if (%ps_dlgchan_loop > %ps_dlgchan_total) goto end
  set %ps_dlgchan_nick $ini(%ps_channelfile,%ps_dlgchan_chan,%ps_dlgchan_loop)
  if ((%ps_dlgchan_nick != #status) && (%ps_dlgchan_nick != #voice) && (%ps_dlgchan_nick != #autojoin)) did -a PS_Dlg_AX 613 %ps_dlgchan_nick
  goto loop
  :end
  unset %ps_dlgchan_*
}


alias PS_DlgChanStat {
  var %ps_a = PS_DlgChanStat
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($PS_Channel($gettok($didtok($dname,604,0,44),$did(PS_Dlg_AX,604).sel,44)) == ON) did -c PS_Dlg_AX 605
  else did -c PS_Dlg_AX 606
}



alias PS_DlgChanVoiceStat {
  var %ps_a = PS_DlgChanVoiceStat
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($PS_Channel($gettok($didtok($dname,604,0,44),$did($dname,604).sel,44),voice) == OFF) did -u $dname 610
  else did -c PS_Dlg_AX 610
}


alias PS_DlgChan {
  var %ps_a = PS_DlgChan
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; clear listbox
  did -r PS_Dlg_AX 604

  ; populate channel list selected network
  scon $PS_ResolveNetworkNametoSCon($1)

  ; add channels to list
  didtok PS_Dlg_AX 604 59 $PS_Channel(list) 

  ; highlight channel for which the PSCC was executed from
  did -c PS_Dlg_AX 604 $findtok($didtok(PS_Dlg_AX,604,0,44),$eval($+(%,ps.active.,$PS_network,.chan),2),1,44)

  did -eu $dname 605,606,610,611
  $PS_DlgChanStat
  $PS_DlgChanVoice
  $PS_DlgChanVoiceStat
  $PS_InitAutoConnect
  $PS_InitAutoJoin

  scon -r
}


alias PS_ChanList {
  var %ps_a = PS_ChanList
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  set %ps_ChanDialog_type $1
  set %ps_ChanDialog_type2 $2
  return $dialog(PS_ChanDialog,PS_ChanDialog)
}


dialog PS_ChanDialog {
  size -1 -1 220 30
  title $network - Add Channels

  button "OK",1,135 5 30 20, OK,
  combo 2,5 5 120 200,DROP,RESULT,EDIT,SORT
  button "Cancel",3,170 5 45 20,CANCEL
}


ON *:dialog: PS_ChanDialog:init:0: {
  var %ps_a = PS_OnDialog_PS5_ChanDialogInit
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  didtok PS_ChanDialog 2 59 $PS_Channel(%ps_ChanDialog_type,%ps_ChanDialog_type2)
  unset %ps_ChanDialog_*
}


alias PS_DlgNetwork {
  var %ps_a = PS_DlgNetwork
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  did -r PS_Dlg_AX 361
  var %ps_temp = $findfile($PS_SettingsDir(%ps_a),PServe*.ini,0,PS_DlgNetWorkAdd $1-)
  did -c PS_Dlg_AX 361 $findtok($didtok(PS_Dlg_AX,361,35),$ps_network(%ps_a),35)
}


alias PS_DlgNetWorkAdd {
  var %ps_a = PS_DlgNetWorkAdd
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_proc = $remove($gettok($nopath($1-),2,95),.ini)
  if (PhotoServe isin %ps_proc) return
  if ($didwm(PS_Dlg_AX,361,%ps_proc) == 0) did -a PS_Dlg_AX 361 %ps_proc
}


alias PS_DlgNetRemove {
  var %ps_a = PS_DlgNetRemove
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_temp = $findfile($PS_SettingsDir(PS_DlgNetRemove),*_ $+ $1 $+ .ini,0,.remove " $+ $1- $+ ")
  unset $+(%,ps.active.,$1,.chan)

  $PS_DlgNetWork
}


alias PS_Server_Auto_On_Off {
  ; populate channel list selected network
  var %ps_networkget = $did($dname,361).seltext
  scon $PS_ResolveNetworkNametoSCon(%ps_networkget)

  if ($did == 372) {
    if ($did($dname,372).state == 1) {
      did -e $dname 375,377
    }
    else {
      var %ps_netstatusfile = $PS_SettingsDir(PS_Dlg_AX_sclick2) $+ PServeSettings_ $+ $did($dname,361).seltext $+ .ini"
      .timer $+ PS_AutoOn_ $+ $did($dname,361).seltext off
      .timer $+ PS_AutoOff_ $+ $did($dname,361).seltext off
      $PS_RemIni(372,%ps_netstatusfile,#Status,#TimeOn)
      $PS_RemIni(372,%ps_netstatusfile,#Status,#TimeDuration)
      $PS_RemIni(372,%ps_netstatusfile,#Status,#TimeOff)
      did -c $dname 375 $findtok($didtok($dname,375,35),$chr(32),35)
      did -c $dname 377 $findtok($didtok($dname,377,35),$chr(32),35)
      did -b $dname 375,377
      did -ra $dname 379
    }
  }
  if ($did == 375) {
    if ($did($dname,377).text != $null) {
      $PS_AutoOnOffWrite($did($dname,375).seltext,$did($dname,377).seltext)
    }
  }
  if ($did == 377) {
    if ($did($dname,375).text != $null) {
      $PS_AutoOnOffWrite($did($dname,375).text,$did($dname,377).text)
    }
  }
  scon -r
}
