
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####


alias -l GeneralInit {
  .ial on
  .events on
  .ctcps on
  .raw on
  .fsend on
  .pdcc on
  .dcc packetsize 8192
  .ignore -r
  .sreq +m auto

  PS_InitDccServer
  ; unset old unused settings and internal vars that became global due to missing "var"
  unset %stats %trigstoff %PS.whereisusepath

  if (%PS.leech.mode == Msg) unset %PS.leech.mode
  if ($hget(PsTriggerMap) == $null) .timer 1 1 PSTC_ReloadTriggers
  .timer 1 15 PSTC_CheckErrors $me Allchannels $true
  .timer 1 25 PS_InitDDEServer
  .timer 1 90 PSBU_CreateBackup
  .timerPSBACKUP -o 0 $calc(24 * 3600) PSBU_CreateBackup
  PS_RemoteCommands init
  .timerremotecommands -o 0 5 PS_RemoteCommands
  ;  .writeini $UC_Filename(pscsettings) BitTorrent Active 1
  echo $ps_n -st --> PhotoServe $+ $ps_kh $PS.Version $+ $PS.Version.beta Started.
  ;; check all dataports every 3 minutes if they are still working
  .timercheckdataports -o 0 180 checkdataconalive
  .timertouchdataports -o 0 20 keepdataconalive

  ;; do a daily update check
  .timerautoupdatetriggersdaily -o 0 86400 /scon -at1 PS_CheckAllChannelsForTriggerUpdate
  ;; do a check one hour after connected
  .timerautoupdatetriggersonce -o 1 3600 /scon -at1 PS_CheckAllChannelsForTriggerUpdate



}

on *:SIGNAL:PSUPDATEDONE:{
  GeneralInit
}
on *:start:{
  var %ps_a = PS_OnStart_PS7
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-
  ; unset temp globals
  unset %ps_* %ps $+(%,ps.,*,.nicksend) %PS.StatusScripts
  ; Purge saved havelists (both yours and others')
  PS_SavedHaveListsPurge


  GeneralInit
}



alias PS_CheckVersion {
  var %ps_a = PS_CheckVersion
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %PS.check.ver = 6.21
  if ($version < %PS.check.ver) {
    :error
    echo $ps_n -sat 4ERROR: This Script requires mIRC version07 %PS.check.ver $+ .  Please install the correct version if you want to use PhotosServe.
    return no
  }
  else return go
}




/* Returns the CON number (to be used in /scon) for a network name
*/

alias PS_ResolveNetworkNametoSCon {
  var %name = $1
  var %count = $scon(0)
  while (%count > 0) {
    if $scon(%count).network == %name return %count
    dec %count
  }
  return 0 
}

alias -l PS_RemoteCommands {
  var %init = $1
  var %rf = $PS_ScriptDir $+ Settings\PServeRemoteCommands.txt"
  if ($exists(%rf)) {
    if (%init) {
      remove %rf
      return
    }
    if ($fopen(RC)) .fclose RC
    .fopen RC %rf
    while (!$feof) {
      var %line = $fread(RC)
      tokenize 9 %line
      var %command = $1 , %network = $2
      if (%network) {
        var %scon = $PS_ResolveNetworkNametoSCon(%network)
        if (%scon == 0) return 
      }
      echo 7 -st command:6 %command in network6 %network (id=11 %scon ) 
      if (%scon > 0) scon %scon %command
      else   %command
    }
    .fclose RC
    .remove %rf
  }
  ; else echo -s no %rf found
}




alias PS_InitDDEServer {
  .ddeserver off
  if (%ps.ddeserver == off) return
  var %c = -1
  :loop
  inc %c
  if (%c > 20) return 
  var %servername = PServe $+ %c
  if ($isdde(%servername)) goto loop
  .ddeserver on %servername
}


alias PS_InitDccServer {
  var %mode = $1
  var %ps_portall = $PS_Ports
  var %ps_portfirst = $gettok(%ps_portall,1,45)
  var %ps_portlast = $gettok(%ps_portall,2,45)

  if (%mode == repair) {
    var %new = $rand(%ps_portfirst,%ps_portlast)
    var %new_temp = %new
    while (%new < %ps_portlast) {
      if ($portfree(%new)) {
        .dccserver +scf on %new
        return %new
      }
      inc %new
    }
    %new = %new_temp
    while (%new >= %ps_portfirst) {
      if ($portfree(%new)) {
        .dccserver +scf on %new
        return %new
      }
      dec %new
    }
  }

  if ((!%ps.dccserverport) || (standard == %ps.dccserverport)) {
    .dccserver +scf on 59
    return
  }

  if (%ps.dccserverport isnum 1-65535) {
    .dccserver +scf on %ps.dccserverport
    return
  }

  if (%ps.dccserverport == endrange) {
    %ps_portlast = %ps_portlast - 2
    .dccserver +scf on %ps_portlast
    return
  }

}


alias PS_ReturnIp {
  var %ps_a = PS_ReturnIp
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; CIDR Network Calculator
  ; http://www.arda.homeunix.net/cidr.shtml

  ; Get ip address
  var %ps_ip = $ip

  ; This is for speical configurations only.
  if (%PS.returnip != $null) return %PS.returnip

  var %ps_longip = $longip(%ps_ip)
  if (%ps_longip == $null) goto error | ; ip did not resolve
  elseif ((%ps_longip >= 1) && (%ps_longip <= 255)) goto error | ; 0.0.0.0/8 #loopback, and other invalid "outside" networks
  elseif ((%ps_longip >= 16777216) && (%ps_longip <= 16777471)) goto error | ; 1.0.0.0/24 Reserved
  elseif ((%ps_longip >= 167772160) && (%ps_longip <= 184549375)) goto error | ; 10.0.0.0/8 Class A rfc1918
  elseif ((%ps_longip >= 2130706432) && (%ps_longip <= 2147483647)) goto error | ; 127.0.0.0/8 #loopback, and other invalid "outside" networks
  elseif ((%ps_longip >= 2851995648) && (%ps_longip <= 2852061183)) goto error | ; 169.254.0.0/16 #default dynamic ip broadcast when all else fails
  ;  elseif ((%ps_longip >= 2886729728) && (%ps_longip <= 2887778303)) goto error | ; 172.16.0.0/12 Class B rfc1918
  elseif ((%ps_longip >= 3221225472) && (%ps_longip <= 3221291007)) goto error | ; 192.0.0.0/16 Lab Networks
  elseif ((%ps_longip >= 3232235520) && (%ps_longip <= 3232301055)) goto error | ; 192.168.0.0/16 Class C rfc1918
  elseif ((%ps_longip >= 3432529920) && (%ps_longip <= 3432530431)) goto error | ; 204.152.64.0/23 #sun cluster arin says it's "PRIV-HADF2"
  elseif ((%ps_longip >= 3758096384) && (%ps_longip <= 4294967294)) goto error | ; 224.0.0.0/3 Multicast
  elseif (%ps_longip >= 4294967295) goto error | ; 255.255.255.255/32 #loopback, and other invalid "outside" networks

  return %ps_ip
  :error
  echo $ps_n -st --> 4ERROR Mirc has detected a non-routable IP address $+ $ps_kh %ps_ip
  echo $ps_n -st --> 13Non-Routable IP: First try to connect to a different irc server by typing $+ $ps_kh /server $network If this fails to detect your correct IP address you need to change your IP lookup method. Shutdown and restart mIRC Then choose File, Options, Local Info, Change the Lookup Method from 6Normal to Server OR 6Server to Normal. Changing this to the opposit should solve the problem. "Server" is usually the standard option which everyone should use. Reconnect to IRC and see if you can send correctly.
  halt
}




;;;;;;;;;;;; BEGIN OF THE DATAPORT STUFF


on *:DISCONNECT:{
  ;  echo -set Disconnected. Closing all PSDATA Ports for $ps_network
  ;  sockclose PSDATAPORT_*
}


alias PS_Init_Whereis_Socket {
  var %ps_a = PS_Init_Whereis_Socket
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-


  var %ps_portall = $PS_Ports
  var %ps_portfirst = $gettok(%ps_portall,1,45)
  var %ps_portlast = $gettok(%ps_portall,2,45)

  ; Get ip address
  if ($PS_ReturnIp(PS_Init_Whereis_Socket)) set %PS.whereisip $ifmatch

  ; This is for special configurations only.
  if (%PS.returnippub) set %PS.whereisip $ifmatch

  unset -s %PS.WhereisPort
  ; only close the port if the portnumber is no longer the correct one. 
  if (($sock(WhereIs_Socket)) && ($sock(WhereIs_Socket).port <= %ps_portlast) && ($sock(WhereIs_Socket).port >= %ps_portfirst)) return

  ;; we have to create a new WhereIs Port

  sockclose WhereIs_*
  sockclose PSDATAPORT_IN_*

  while (%ps_portlast >= %ps_portfirst) {
    if ($portfree(%ps_portlast)) {
      socklisten WhereIs_Socket %ps_portlast
      echo $ps_n -st --> Now listening for !WhereIs replies on Socket: $+ $ps_kh WhereIs_Socket IP: $+ $ps_kh %PS.whereisip Port: $+ $ps_kh $SOCK(WhereIs_Socket).port
      return
    }
    dec %ps_portlast
  }
}

on *:socklisten:WHEREIS_SOCKET: {
  var %ps_a = PS_OnSockListen_PS7_Whereissocket
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %count = 0
  while (%count < 1000) {
    inc %count
    var %newconn = PSDATAPORT_IN_ $+ %count
    if (!$sock(%newconn)) {
      sockaccept %newconn
      if (%ps.nodataportkeepalive)  .timershut [ $+ [ %newconn ] ] 1 60 sockclose %newconn
      return
    }
  }
}

alias -l keepdataconalive {
  var %socks = $sock(PSDATAPORT_*,0)
  while (%socks) {
    var %sockname = $sock(PSDATAPORT_*,%socks).name , %nick = $sock(PSDATAPORT_*,%socks).mark
    if (active == $sock(PSDATAPORT_*,%socks).status) sockwrite -tn %sockname @NOOP
    ; else echo -sat unknown state $sock(PSDATAPORT_*,%socks).status for %socks
    ;echo -set -> written a few bytes to %sockname
    dec %socks
  }
}

alias -l checkdataconalive {
  var %socks = $sock(PSDATAPORT_*,0)
  ; echo -set Checking Connection Status of %socks PS Data Ports
  while (%socks) {
    var %sockname = $sock(PSDATAPORT_*,%socks).name , %nick = $sock(PSDATAPORT_*,%socks).mark
    var %found = $false , %scons = $scon(0)
    while (%scons) {
      scon %scons
      ;; we try to find out in which network this connection was used
      if ( $PS_DataPortDBAccess(%nick,con) ) {
        var %con = $ifmatch
        if (%con == %sockname) {
          sockwrite -tn %sockname $ps_network $me MYIPADDR
          .timershut [ $+ [ %sockname ] ] 1 20 connectionisalive %sockname $false
          var %found = $true
          break
        }
      }
      scon -r
      dec %scons
    }
    if (!%found) {
      echo -set %sockname was not found in any of the server connections and is closed now.
      sockclose %sockname
    }
    dec %socks
  }
}


alias -l connectionisalive {
  var %sockname = $1 , %testgood = $2
  if (%testgood) {
    .timershut [ $+ [ %sockname ] ] off
  }
  else {
    var %nick = $sock(%sockname).mark
    echo -set %sockname from7 %nick failed to respond. closing connection now!
    sockclose %sockname
  }
}

on *:sockread:PSDATAPORT_*:{
  var %ps_a = PS_OnSockRead_PS7_whereisreplyin
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-
  connectionisalive $sockname $true
  var %result
  :nextread
  sockread %result
  if (%result != $null) {
    if (%ps.dpdb == on) echo 14 -set read %result from $sockname
    var %camefrom = $gettok(%result,1,32)
    if (%camefrom == @NOOP) {
      noop
    }
    elseif (%camefrom == @IDENTREPLY) {
      var %nick = $gettok(%result,3,32)
      var %ip = $sock($sockname).ip 
      var %port = $sock($sockname).port
      .timershut [ $+ [ $sockname ] ] off
      if ($RegisterNickToDataCon(%nick,$sockname))   echo 13 -set --> Data Connection established with %nick ( $gettok(%result,6-7,32) ) over $sockname ( %ip : %port )
    }
    else {
      ;; READ example: <network> <nick> <commands>
      var %connection = $PS_ResolveNetworkNametoSCon(%camefrom)
      if (%connection > 0)  {
        scon %connection
        var %id = $left($gettok(%result,3,32),8)
        var %nick = $gettok(%result,2,32)
        var %res = $RegisterNickToDataCon(%nick,$sockname)

        ; mark this as beeing used now 
        var %res = $PS_DataPortDBAccess(%nick,time,$ctime)

        ;;; COMMANDS FOR *IN
        if     (%id == @Whereis)  {
          .signal PSGotWhereisReply $deltok(%result,1,32)
          var %ip =  $sock($sockname).ip , %nick = $gettok(%result,2,32) , %chan = $gettok($gettok(%result,3-,32),26,58)
          .signal PSIPRESOLVE %nick %ip %chan
        }
        elseif (%id == IDENTIFY) {
          sockwrite -tn $sockname @IDENTREPLY $ps_network $me $iif(%ps.trigger,%ps.trigger,none) $ctime $PS.Version $PS.Version.beta
          sockwrite -tn $sockname $ps_network $me @YOURADD $sock($sockname).ip
        }
        elseif ((%id == @COMMAND) || (%id == @PNOTICE)) {
          var %crc = $gettok(%result,4,32)
          var %text = $gettok(%result,5-,32)
          var %rcrc = $crc(%text,0)
          ;echo -> got command|textnotice from %nick over $sockname > crc: %crc matching? %rcrc --> %text
          if (%id == @COMMAND)  .signal PSCOMMAND %nick %text
          else {
            .signal PSNOTICE %nick %text
            var %used = $PSL_CheckRelevantForLeech(%nick,%text)
            if ((!%used) && ($left(%text,1) != @)) echo $color(notice) -saet  - $+ %nick $+ - %text
          }
        }
        elseif (%id == MYIPADDR) {
          if (%ps.dpdb == on) echo 5 -set sent reply that ip of $sockname is $sock($sockname).ip
          sockwrite -tn $sockname $ps_network $me @YOURADD $sock($sockname).ip
        }
        elseif (%id == @YOURADD) {
          var %toldmeip =  $gettok(%result,4,32)
          var %ip =  $sock($sockname).ip
          var %ok = $true
          if (%ip == %toldmeip) echo 4 -set -> %nick told me  my ip is %toldmeip $+ , but his ip is %ip $+ , so we ignore that.
          else CheckUpdateIp %toldmeip
        }
        ;;; COMMANDS FOR *OUT
        ; elseif (%id == @xxx)  {
        ; }
      }
    }
  }
  if ($sockbr > 0) goto nextread
}


alias -l CheckUpdateIp {
  var %ip  = $1
  if ((!$ip) || ($ip !== %ip)) {
    if ((192.168.* !iswm %ip) && (10.* !iswm %ip))  {
      echo 6 -set Internal ip was updated from $ip to new %ip
      localinfo %ip %ip
      set %PS.whereisip %ip
    }
  }
}

on ^*:NOTICE:*:?: {
  var %first = $1
  if ((%first === DCC) || (%first == %ps.trigger) || (%first == !PSGET) ||  (%first == !PSserv)) {
    return
  }
  elseif (@WheReis* iswm $1-) {
    .signal PSGotWhereisReply $nick $1-
    haltdef
  }
  .signal PSNOTICE $nick $1-
  var %used = $PSL_CheckRelevantForLeech($nick,$1-)
  if ((%used) || ($left($1-,1) == @))  haltdef
}

; A function to check if a user has a direct connected DataPort @return NameOfSocket or $null 
alias PS_HasDirectCon {
  var %nick =  $1
  var %con = $PS_DataPortDBAccess(%nick,con)
  if (($sock(%con)) && ($sock(%con).mark == %nick) )   return %con
}

/**** sends a command over the dataport, if one is available.
* @return Boolean $true if send was possible $false else
* Note that this command will only send if the connection is allready properly established. 
* For commands/data to be queued a different command must be used
* @prop raw send data in raw format
*/
alias -l SendDataPortCommand {
  var %nick = $1 , %connection = $2 , %text = $3
  if (%connection == .) %connection = $PS_DataPortDBAccess(%nick,con)
  if ((%connection) && ($sock(%connection))) {
    ;; CHECK IF DATA PORT IS REALLY THE CORRECT ONE
    if ($sock(%connection).mark !== %nick) {
      ; echo -set %connection is not the correct one for %nick - > $sock(%connection).mark
      $PS_DataPortDBAccess(%nick,con,.)
      return $false
    }

    ; mark this as beeing used now 
    var %res = $PS_DataPortDBAccess(%nick,time,$ctime)

    if ($prop == raw) sockwrite -tn %connection $PS_Network $me %text 
    elseif ($left(%text,1) !== !)  sockwrite -tn %connection $PS_Network $me @PNOTICE $crc(%text,0) %text 
    else  sockwrite -tn %connection $PS_Network $me @COMMAND $crc(%text,0) %text 


    if (%ps.dpdb == on) echo 14 -set Transmitted the following data to %connection -> %text

    return $true
  }
  :error
  reseterror
  return $false
}

/* registers the nickname to be the owner of the data connection (to be later found and use this connection)
* @return Boolean
*/
alias -l RegisterNickToDataCon {
  var %nick = $1 , %connection = $2

  ; marking this connection with the nick is required and does not hurt - cause it is never wrong only futile sometimes
  if ($sock(%connection)) sockmark %connection %nick

  if ($PS_DataPortDBAccess(%nick,con)) {
    var %old = $ifmatch
    if (%old == %connection) {
      ;  echo -set Connection allready registered %old  and %connection are the same
      return $false
    }
    if ($sock(%old)) {
      if ($sock(%old).mark == %nick) {
        ; this code works but because it was just for testing purposes. it would keep remaining old connections  from the same person in the system
        ;        echo 13 -set Old connection to %nick still available: %old . Not registering new connection %connection 
        ;        return $false 
        ; better close the old one as the other side seems not to be aware of this old connection (maybe it is wrong, maybe it is dead)
        echo 13 -set Old connection to %nick was still available: %old . Closing old for new connection %connection 
        sockclose %old

      }
    }
  }

  if ($sock(%connection)) {
    var %res = $PS_DataPortDBAccess(%nick,con,%connection)
    return $true
  }

  return $false
}

ON *:SOCKOPEN:PSDATAPORT_OUT_*:{
  var %nick = $sock($sockname).mark
  echo -set Connection $sockname was $iif(($sockerr == 0),established,04not successful) to $sock($sockname).ip port $sock($sockname).port - %nick - Result: $iif($sockerr,04Error $sockerr,03NOERROR)
  if (($sockerr) && (1 == $rand(1,100))) notice %nick Sorry the connection to you $sock($sockname).ip was unable to be established. Please check that your port05 $sock($sockname).port is forwarded. This is an automated message - DO NOT REPLY!!
  if ($sockerr) return
  if (%nick) {
    if ($PS_DataPortDBAccess(%nick,id)) $QueuedDataOperation($ifmatch,send,$sockname)
    ;clear the sock mark now 
    ; sockmark $sockname
  }

  if (%ps.nodataportkeepalive) close $sockname 
  else {

    sockwrite -tn $sockname $ps_network $me IDENTIFY

    ; start a little timeout timer to close this port if no reply is sent
    .timershut [ $+ [ $sockname ] ] 1 60 sockclose $sockname

  }

}

ON *:SOCKCLOSE:PSDATAPORT_*:{
  var %nick = $sock($sockname).mark
  if (%ps.dpdb == on)  echo -set Connection $sockname was closed. Was from -> %nick
  if (%nick) {
    if ($PS_DataPortDBAccess(%nick,con)) {
      var %sockname = $ifmatch
      if (%sockname == $sockname)  $PS_DataPortDBAccess(%nick,con,.)
    }
  }

}

/* Sets and Gets required Data for the Data Connection Management
*  @param entry can be a property like dataport or con or id - can also be a command like del (if del has a data it will store the old data under the data keyword)
*
*/

alias PS_DataPortDBAccess {
  var %nick = $1 , %entry = $2 , %data = $3-
  var %HASH = PS_DATAPORTDB_ $+ $PS_Network

  var %old = $hget(%HASH,%nick)
  if (!%old) var %old = $str($chr(46) $+ $chr(9),5)

  ; if there is no ID yet give a new id - ID Is never changed until a user gets deleted
  if ($gettok(%old,4,9) == $chr(46)) {
    var %id = %nick $+ _ $+ $ctime
    %old = $puttok(%old,%id,4,9)
    ;    echo -set new ID %id for %nick created in DataPortDB
  }


  var %field = 0 
  if (%entry == dataport) %field = 1
  elseif (%entry == time) %field = 2
  elseif (%entry == con) %field = 3
  elseif (%entry == id) %field = 4
  elseif (%entry == dccport) %field = 5
  elseif (%entry == del) {
    if (!$hget(%HASH)) return
    hdel %HASH %nick
    var %connection = $gettok(%old,3,9)
    var %id = $gettok(%old,4,9)
    if (%data) {
      %nick = %data 
      if ((%connection != $chr(46)) && ($sock(%connection))) sockmark %connection %nick
    }
    else {
      if ((%connection != $chr(46)) && ($sock(%connection))) sockclose %connection
      if (%id) $QueuedDataOperation(%id,del)
      return
    }
  }

  if (%field) {
    if (%data) %old = $puttok(%old,%data,%field,9)
    else var %return = $gettok(%old,%field,9)
  }
  if (%ps.dpdb == on)  echo 7 -set  %HASH -> %nick -> %entry ( %field ) -> $iif(%data,data %data,fetch operation) -> now %old -> return %return

  if (%return == $chr(46)) return $null
  if (!%return) hadd -m %HASH %nick %old
  return %return
}


on *:QUIT:var %res = $PS_DataPortDBAccess($nick,del)
on *:NICK:var %res = $PS_DataPortDBAccess($nick,del,$newnick)


/* Function that sends a message the usual way to the user - nothing changed 
*  this function will use an existing established connection over a DataPort to a remote user @param command supports virtual command direct
*/
alias PS_Tunnel {
  var %command = $1 , %nick = $2 , %text = $3-
  var %ps_a = PS_Tunnel
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-
  /* 
  var %i = $chat(0)
  while (%i > 0) {
    ;    var %ip = $chat(%i).ip
    var %cnick = $chat(%i)
    if (%nick == %cnick) {
      .msg = $+ %cnick !PSCOMM $ps_network $me %text
      echo -tse -> - $+ %nick $+ - %text
      return
    }
    dec %i
  }
  */
  if ($SendDataPortCommand(%nick,.,%text)) {
    if ($left(%command,1) !== .) echo $color(ctcp) -set -> -- $+ %nick $+ --> %text
    return
  }
  elseif ($PSL_getWhereIsAddress) {
    var %myadr = $ifmatch
    if (!%ps.NoDirectRequest) {
      ;; try to get an incoming connection from that person for the future
      ctcp %nick !PSCallMe %myadr
      var %delay = 5
    }
  }
  :error
  if ($right(%command,6) == direct) return
  if ($error) {
    echo -set Warning: $error
    reseterror
  }
  ;; if this commands gets a reply we give the connection a chance to be established
  if (%delay) .timer 1 %delay   %command %nick %text
  else                          %command %nick %text
}


/* Function to queue up data unlimited until the connection is established. Supports 2 modes @param mode append and send and del
* @return void
*/

alias -l QueuedDataOperation {
  var %id = $1 , %mode = $2 , %data = $3
  var %HASH = PSQueuedWhereis_ $+ $PS_Network
  if (%mode == del) {
    if ($hget(%HASH)) hdel %HASH %id
  }
  else {

    var %res = $hget(%HASH,%id,&c)
    var %size = $bvar(&c,0) 

    if (%mode == append) {
      inc %size
      bset -t &c %size $PS_Network $me %data $+ $crlf
      hadd -bm %HASH %id &c
    }
    elseif (%mode == send) {
      var %nick = $sock(%data).mark
      ; mark this as beeing used now 
      var %res = $PS_DataPortDBAccess(%nick,time,$ctime)

      if (%size > 0) {
        if ($sock(%data)) {
          sockwrite %data &c
          hdel %HASH %id
          var %con = %data
          %data = $bvar(&c,1,500).text
          if (@Whereis: == $left($gettok(%data,3,32),9)) echo $ps_i -st --> Successfully sent !WhereIs Reply to IP:Port: $+ $ps_kh $sock(%con).ip $+ : $+ $sock(%con).port Nick: $+ $ps_kh $gettok($gettok(%data,27,58),1,13) Chan: $+ $ps_kh $gettok(%data,26,58) Trigger: $+ $ps_kh $gettok(%data,3,58)
          if (%ps.dpdb == on) echo 14 -set Transmitted the following data to %con -> %data
        }
      }
      ; else echo -set nothing in queue to send for %ID ... %size
    }
  }
}




;; sets the data to a hash and starts an outgoing connection. @return void
alias PS_ReplyOverSocket {
  var %nick = $1 , %address = $2 , %data = $3

  ; first check if there is allready a valid connection established

  if ($SendDataPortCommand(%nick,.,%data).raw) {
    echo $ps_i -st --> Directly sent !WhereIs Reply to existing DataPort: $+ $ps_kh %address Nick: $+ $ps_kh $gettok(%data,27,58) Chan: $+ $ps_kh $gettok(%data,26,58) Trigger: $+ $ps_kh $gettok(%data,3,58)
    return 
  }

  var %newconn = $PS_OpenDPConnection(%nick,%address)

  ; and store the data for this user in the queue
  if ($PS_DataPortDBAccess(%nick,id)) {
    var %id = $ifmatch
    var %res = $QueuedDataOperation(%id,append,%data)

  }


}

;; function to open a outgoing connection to a user at the given address (= IP:PORT)

alias PS_OpenDPConnection {
  var %nick = $1 , %address = $2

  ; open a new connection  PSDATAPORT_OUT_

  if (!%ps.maxoutDPconnections) set %ps.maxoutDPconnections 20

  var %count = 0
  var %oldc = $ctime 
  while (%count < 1000) {
    inc %count
    var %newconn = PSDATAPORT_OUT_ $+ %count
    if (!$sock(%newconn)) {

      ; check if count is over the limit of max allowed ports
      if (%oldest) {
        ; have to count the DATAPORT_IN_* connections first.. 
        ; removed for now : + $sock(PSDATAPORT_IN_*,0) -  because incoming connections use no NAT
        if ($calc(%count) > %ps.maxoutDPconnections) {
          var %onick = $sock(%oldest).mark
          sockclose %oldest
          %newconn = %oldest
          echo 13 -set too many connections ( %count )  -> closing the oldest connection %oldest of %onick
          var %res = $PS_DataPortDBAccess(%onick,con,.)
        }
      }

      ; could also get/try the address from the    $PS_DataPortDBAccess(%nick,dataport)   function 
      echo -set Opening Connection %newconn to %address to %nick
      sockopen %newconn $gettok(%address,1,58) $gettok(%address,2,58)
      sockmark %newconn %nick
      return %newconn
    }
    else {
      ;; checking last used time and name
      var %onick = $sock(%newconn).mark
      var %time = $PS_DataPortDBAccess(%onick,time)
      ;  echo -set checking %time from %onick from %newconn with current %oldc
      if (%time < %oldc) {
        %oldc = %time
        var %oldest = %newconn
      }
    }
  }


}

alias PS_Socklist {
  var %command = $1 , %nick = $2
  var %c = $sock(PSDATAPORT_*,0)
  if (%nick) var %current = $PS_DataPortDBAccess(%nick,con)
  while (%c) {
    var %sockname = $sock(PSDATAPORT_*,%c)
    if (%command == cleanup) {
      if ((%current) && (%current == %sockname)) continue
      var %owner = $sock(%sockname).mark
      if (%owner == %nick) {
        echo 13 -set closed %sockname because it was an old connection (not registered) of %nick (mark: %owner $+ )
        sockclose %sockname
      }
    }
    elseif (%command == timeout) { 
      if ($sock(%sockname).to > 10000) {
        echo 13 -set closed %sockname because connection was open for $duration($sock(%sockname).to)
        sockclose %sockname
      }
    }
    else  echo -s >> %c > %sockname - $sock(%sockname).mark - $sock(%sockname).ip - $sock(%sockname).port - $duration($sock(%sockname).to)
    dec %c
  }
}



;;;;;;;;;;;; END OF THE DATAPORT STUFF

ON *:SIGNAL:PSIPRESOLVE:PS_IpWatcher $1-


alias -l PS_IpWatcher {
  var %nick = $1 , %ip = $2 , %chan = $3
  if ((!%ps.noipwatch) &&  ($PSF_GetChanSetting(WatchIps,%chan))  && ($me isop %chan)) {
    var %port = $gettok(%ip,2,58) , %ip = $gettok(%ip,1,58)
    var %hash = PS_IpWatch_ $+ $PS_Network
    var %old = $hget(%hash,%ip)
    if ((%old) && (%old !== %nick))  {
      if (%old isop %chan) return
      ;var %stillthere = $iif(,$true,$false)
      ;echo -set checking %nick in %chan and %old in %chan
      if ((%old ison %chan) && (%nick ison %chan))  {
        kick %chan %old autoremoving old nickname of %nick
        return
      }
    }
    hadd -m %hash %ip %nick 
  }
}


on *:SIGNAL:PSGotWhereisReply: {
  var %ps_a = PS_OnSignal_PS7_PSGotWhereisReply
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  ; $1 = nick
  ; $2 = data (see below)
  ;   $1 = @Whereis
  ;   $2 = Reply Format 
  ;   $3 = Trigger
  ;   $4 = CDrom
  ;   $5 = Count Files
  ;   $6 = Count Csv
  ;   $7 = Status
  ;   $8 = File Name
  ;   $9 = File Search String
  ;   $10 = File Crc
  ;   $11 = File Size
  ;   $12 = RHC
  ;   $13 = Csv Crc
  ;   $14 = Csv File
  ;   $15 = Send Current
  ;   $16 = Send User
  ;   $17 = Send Total
  ;   $18 = Queue Current
  ;   $19 = Queue User
  ;   $20 = Queue Total
  ;   $21 = Gets
  ;   $22 = Leech
  ;   $23 = Speed
  ;   $24 = Average Cps
  ;   $25 = !trig
  ;   $26 = $chan
  ;   $27 = Requesters Nick

  var %ps_replyfrom_nick = $1
  tokenize 58 $2-

  if (($27 != $null) && ($27 != $me)) return

  var %ps_network = $ps_network(OnNotice_pserve7)

  if ($7 == ON) { var %ps_stat = $7 | var %ps_status = 03 | var %ps_aline = 3 }
  elseif ($7 == Loaded) { var %ps_stat = $7 | var %ps_status = 03 | var %ps_aline = 3 }
  elseif ($7 == BTlocked) { var %ps_stat = $7 | var %ps_status = 10 | var %ps_aline = 5 }
  elseif ($7 == BTseed) { var %ps_stat = $7 | var %ps_status = 10 | var %ps_aline = 10 }
  elseif ($7 == Not Loaded) { var %ps_stat = $7 | var %ps_status = 07 | var %ps_aline = 7 }
  elseif ($7 == OFF) { var %ps_stat = $7 | var %ps_status = 04 | var %ps_aline = 4 }
  else { var %ps_stat = off | var %ps_status = 04 | var %ps_aline = 4 }


  ; no stupid timeout for CRC checked file searches
  if (($PS_WhereIsPing == ON) && ($2 != 2)) {
    if ((%ps_wi_filter_ping == $null) && (%ps_replyfrom_nick != $me)) return
  }
  ; these are auto leeches . nothing to be opened
  if ($26 islower) return

  if ($($+(%,pson_filter_onoff_,$3),2) == 1) {
    if ((%ps_stat == OFF) || (%ps_stat == NOT Loaded)) return
  }
  if ($5 < $($+(%,pson_filter_min_count_,$3),2)) return

  if ($readini($PS_ServeSettings(OnNotice_pserve7),n,#whereis,#window) == OFF) {
    if ($2 == 1) echo $ps_n -sat - $+ $ps_ki $+ %ps_replyfrom_nick $+ - I have04 $3 with $+ $ps_ki $5 files and it is $+ %ps_status %ps_stat Config: $+ $ps_kh $12 Csv: (13 $+ $13 $+ ) $+ $ps_kh $14 Avg: $+ $ps_kh $24 Speed: $+ $ps_kh $23 S:04 $+ $15 $+ / $+ $ps_kh $+ $16 $+ / $+ $ps_ki $+ $17 Q:04 $+ $18 $+ / $+ $ps_kh $+ $19 $+ / $+ $ps_ki $+ $20 G: $+ $ps_kh $+ $21 L: $+ $ps_kh $+ $22 Trigger: $+ $ps_kh !PSget
    if ($2 == 2) echo $ps_n -sat - $+ $ps_ki $+ %ps_replyfrom_nick $+ - I have04 $8 CRC: $+ $ps_kh $10 Type: $+ $ps_ki /ctcp %ps_replyfrom_nick !PSget $3 $9 Config: $+ $ps_ki $12 Csv: (13 $+ $13 $+ ) $+ $ps_kh $14 Avg: $+ $ps_kh $24 Speed: $+ $ps_kh $23 S:04 $+ $15 $+ / $+ $ps_kh $+ $16 $+ / $+ $ps_ki $+ $17 Q:04 $+ $18 $+ / $+ $ps_kh $+ $19 $+ / $+ $ps_ki $+ $20 G: $+ $ps_kh $+ $21 L: $+ $ps_kh $+ $22 Trigger: $+ $ps_kh !PSget
    if ($2 == 3) echo $ps_n -sat - $+ $ps_ki $+ %ps_replyfrom_nick $+ - Found File:04 $8 CRC: $+ $ps_kh $10 Size: $+ $ps_kh $11 Type: $+ $ps_ki /ctcp %ps_replyfrom_nick !PSget $8 Avg: $+ $ps_kh $24 Speed: $+ $ps_kh $23 S:04 $+ $15 $+ / $+ $ps_kh $+ $16 $+ / $+ $ps_ki $+ $17 Q:04 $+ $18 $+ / $+ $ps_kh $+ $19 $+ / $+ $ps_ki $+ $20 G: $+ $ps_kh $+ $21 L: $+ $ps_kh $+ $22 Trigger: $+ $ps_kh !PSget
    if ($2 == 4) echo $ps_n -sat - $+ $ps_ki $+ %ps_replyfrom_nick $+ - I have04 $3 with $+ $ps_ki $5 files and it is $+ %ps_status %ps_stat Config: $+ $ps_kh $12 Csv: (13 $+ $13 $+ ) $+ $ps_kh $14 Avg: $+ $ps_kh $24 Speed: $+ $ps_kh $23 S:04 $+ $15 $+ / $+ $ps_kh $+ $16 $+ / $+ $ps_ki $+ $17 Q:04 $+ $18 $+ / $+ $ps_kh $+ $19 $+ / $+ $ps_ki $+ $20 G: $+ $ps_kh $+ $21 L: $+ $ps_kh $+ $22 Trigger: $+ $ps_kh !PSget
  }
  else {
    if (($2 == 1) || ($2 == 4)) {
      var %ps_whereis_window_name = $+(@WhereIs-,%ps_network,_,$26,_,$3)
      var %ps_whereis_window_title = -- Collection: $3
      if ($window(%ps_whereis_window_name) == $null) $PS_WindowMakeCollection(%ps_whereis_window_name,%ps_whereis_window_title,$upper($3),$chan)
    }
    elseif ($2 == 2) {
      var %ps_whereis_window_name = $+(@WhereIs-,%ps_network,_,$26,_,$3)
      var %ps_whereis_window_title = -- Collection: $3 -- File: $9
      if ($window(%ps_whereis_window_name) == $null) $PS_WindowMakeCollection(%ps_whereis_window_name,%ps_whereis_window_title,$upper($3),$chan)
    }
    elseif ($2 == 3) {
      var %ps_whereis_window_name = $+(@WhereIs-,%ps_network,_,$26,_,$9)
      var %ps_whereis_window_title = -- Search String: $9
      if ($window(%ps_whereis_window_name) == $null) $PS_WindowMakeFilename(%ps_whereis_window_name,%ps_whereis_window_title,$chan)
    }
    var %ps_whereis_window_trig = $25
    var %mydata = $strip($line(%ps_whereis_window_name,2))
    var %samecrc = $iif($base($remove($gettok(%mydata,10,9),$chr(32)),16,10) == $base($13,16,10),$true,$false)
    var %iscomplete = $iif($5 == $6,$true,$false)
    var %rcrc = $iif(%samecrc,03,04) $+ $13 $+ 
    var %rcount = $iif(%iscomplete,03,07) $+ $5 $+  $iif(%iscomplete,)
    if ($25 == $null) var %ps_whereis_window_trig = !PSget
    if (($2 == 1) || ($2 == 2) || ($2 == 4)) {
      ;check if %ps_whereis_window_trig is allready in window %ps_whereis_window_name and remove it
      var %max = $line(%ps_whereis_window_name,0)
      var %i = 0
      while (%i < %max) {
        inc %i
        var %linetrig = $remove($gettok($line(%ps_whereis_window_name,%i),3,9),$chr(32))
        if (%linetrig == %ps_whereis_window_trig) {
          dline %ps_whereis_window_name %i
          break
        }
      }
    }
    ; at last add the new line
    if (($2 == 1) || ($2 == 4)) aline %ps_aline %ps_whereis_window_name $iif(%ps_wi_filter_ping != $null,$calc($ctime - %ps_wi_filter_ping),??) $chr(9) %ps_replyfrom_nick $chr(9) %ps_whereis_window_trig $chr(9) %ps_stat $chr(9) 03 $+ %rcount $+ 10/12 $+ $6 $chr(9) $23 $chr(9) $24 $chr(9) 3S:04 $+ $15 $+ 3/07 $+ $16 $+ 3/12 $+ $17 3Q:04 $+ $18 $+ 3/07 $+ $19 $+ 3/12 $+ $20 3G:07 $+ $21 3L:07 $+ $22 $chr(9) $12 $chr(9) %rcrc $chr(9) $14
    elseif ($2 == 2) aline %ps_aline %ps_whereis_window_name $iif(%ps_wi_filter_ping != $null,$calc($ctime - %ps_wi_filter_ping),??) $chr(9) %ps_replyfrom_nick $chr(9) %ps_whereis_window_trig $chr(9) %ps_stat $+ 10/12 $+ $10 $chr(9) 03 $+ %rcount $+ 10/12 $+ $6 $chr(9) $23 $chr(9) $24 $chr(9) 3S:04 $+ $15 $+ 3/07 $+ $16 $+ 3/12 $+ $17 3Q:04 $+ $18 $+ 3/07 $+ $19 $+ 3/12 $+ $20 3G:07 $+ $21 3L:07 $+ $22 $chr(9) $12 $chr(9) %rcrc $chr(9) $14
    elseif ($2 == 3) aline %ps_aline %ps_whereis_window_name $iif(%ps_wi_filter_ping != $null,$calc($ctime - %ps_wi_filter_ping),??) $chr(9) %ps_replyfrom_nick $chr(9) $23 $chr(9) $24 $chr(9) 3S:04 $+ $15 $+ 3/07 $+ $16 $+ 3/12 $+ $17 3Q:04 $+ $18 $+ 3/07 $+ $19 $+ 3/12 $+ $20 3G:07 $+ $21 3L:07 $+ $22 $chr(9) $10 $chr(9) $11 $chr(9) $8
    window -b %ps_whereis_window_name
  }
}

alias PS_WindowMakeCollection {
  var %ps_a = PS_WindowMakeCollection
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)

  if ($version >= 6.2) window -lk0 $+ $PSA_GetDesktopFlag(whereis) -t3,11,19,27,35,42,47,63,67,74 $1 verdana 11
  else                 window -lk0 $+ $PSA_GetDesktopFlag(whereis) -t3,11,19,29,37,48,54,73,78,86 $1 verdana 11

  titlebar $1 $2
  aline 12 $1 Ping $chr(9) Nick $chr(9) Trig $chr(9) Status $chr(9) Count $chr(9) Speed $chr(9) Avg $chr(9) Sends $chr(9) Config $chr(9) Csv Crc $chr(9) Csv
  if ($3 != $null) {
    var %ps_temp_1 = $PS_ReadIni($3,findfile,43)
    var %ps_temp_2 = $readini(%ps_temp_1,n,$3,count)
    var %ps_temp_3 = $readini(%ps_temp_1,n,$3,csvcount)
    var %ps_temp_4 = $readini(%ps_temp_1,n,$3,status)
    var %ps_temp_5 = $readini(%ps_temp_1,n,$3,csv)
    var %ps_temp_6 = $PS_Crc(%ps_temp_5)
    aline 10 $1 0 $chr(9) $me $chr(9) %PS.trigger $chr(9) n/a $chr(9) 03 $+ %ps_temp_2 $+ 10/12 $+ %ps_temp_3 $chr(9) $PS_Ctcpinfo(%ps_a,%ps_network,@WhereIs) $chr(9) n/a $chr(9) 13 $+ %ps_temp_6 $+  $chr(9) $nopath(%ps_temp_5)
  }
  aline $1 $str(-,200)
  if ($line($1,0) >= 3) sline $1 3
}

alias PS_WindowMakeFilename {
  var %ps_a = PS_WindowMakeFilename
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($version >= 6.2) window -lk0 $+ $PSA_GetDesktopFlag(whereis) -t3,11,18,23,39,46,53 $1 verdana 11
  else                 window -lk0 $+ $PSA_GetDesktopFlag(whereis) -t3,12,21,27,46,54,62 $1 verdana 11
  titlebar $1 $2-
  aline 12 $1 Ping $chr(9) Nick $chr(9) Speed $chr(9) Avg $chr(9) Sends $chr(9) File CRC $chr(9) Size $chr(9) Filename
  aline $1 $str(-,200)
  if ($line($1,0) >= 2) sline $1 2
}

menu @WhereIs-* {
  $iif(* !isin $menu && ? !isin $menu,Fast Leech):{
    if ($gettok($menu,2,95)) { 
      var %chan = $ifmatch
      var %coll = $gettok($menu,3,95)
      echo $ps_h -t %chan >>> Leech Start of %coll in %chan
      PSL_Leech %coll %chan
    }
  }

  
  $iif(* !isin $menu && ? !isin $menu,Slow Leech): $PS_LeechOpen(WhereIsWindow,$strip($gettok($sline($menu,1),3,32)),$strip($gettok($sline($menu,1),5,32)),$PS_WhereisCtcpSend($menu,trigger))
  
  $iif(* !isin $menu && ? !isin $menu,Fserve): /ctcp $strip($gettok($sline($menu,1),3,32)) !PSget $PS_WhereisCtcpSend($menu,trigger) Fserve
  -
  $iif(-- File isin $window($menu).title,Get Single File): /ctcp $strip($gettok($sline($menu,1),3,32)) !PSget $PS_WhereisCtcpSend($menu,trigfile)
  $iif(* !isin $menu && ? !isin $menu && -- Search String isin $window($menu).title,Get Misc File): /ctcp $strip($gettok($sline($menu,1),3,32)) !PSget $PS_WhereisCtcpSend($menu,miscfile)
  $iif(* isin $menu || ? isin $menu && -- Search String isin $window($menu).title,Get * File):                                                                                                      /ctcp $strip($gettok($sline($menu,1),3,32)) !PSget [ $ $+ [ $0 ] ]
  $iif(* isin $menu || ? isin $menu && -- Search String isin $window($menu).title,Get File $lower($strip($gettok($sline($menu,1),$calc($0 - 2),32)))):    /ctcp $strip($gettok($sline($menu,1),3,32)) !PSget [ $ $+ [ $0 ] ]
  -
  $submenu($psTL_ViewListSubmenu($1,$strip($gettok($sline($menu,1),3,32)),$gettok($menu,2,95)))
  -
  Get Csv: /ctcp $3 !PSget $PS_WhereisCtcpSend($menu,trigger) CSV
  Get Have List: /ctcp $3 !PSget $PS_WhereisCtcpSend($menu,trigger) HAVE
  Get Report File: /ctcp $3 !PSget $PS_WhereisCtcpSend($menu,trigger) REPORT
  -
  Get Samples: $psS_GetSamples($strip($gettok($sline($menu,1),3,32)),$strip($gettok($sline($menu,1),5,32)),   $PS_WhereisCtcpSend($menu,trigger)   )
  -
  Refresh !WhereIs Request: { $PS_WhereIs($PS_WhereisCtcpSend($menu,trigger)) | window -c $menu }
  $iif(* !isin $menu && ? !isin $menu,Request to Load Backup):{
    if ($gettok($menu,2,95)) { 
      var %chan = $ifmatch
      var %coll = $gettok($menu,3,95)
      PS_TrigReq %coll %chan Request
    }
  }
  -
  $iif($PS_WhereisRemHaveList($menu,$1-) == OK,Delete Saved HaveList):remove $+($PS_HaveSavedDir,$remove($5,!),_HAVE_,$gettok($menu,3,95),.txt,")
  -
  $iif((%PS.whereis.send == ON),Send File)
  .Select File and Send: $PS_SendFileInit($menu,Whereis)
  .-
  .Purge ONE Queued Send List: $PS_SendFileRem
  .Purge ALL Queued Send Lists: $PS_SendFilePurge
  -
  Close: window -c $menu
}


alias PS_WhereisCtcpSend {
  var %ps_a = PS_WhereisCtcpSend
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($2 == trigger) {
    tokenize 32 $window($1).title
    return $3
  }
  if ($2 == miscfile) {
    tokenize 32 $window($1).title
    return $4
  }
  if ($2 == trigfile) {
    tokenize 32 $window($1).title
    return $3 $6-
  }
}


alias PS_WhereisRemHaveList {
  var %ps_a = PS_WhereisRemHaveList
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ((@WhereIs- isin $1) && ($isfile($+($PS_HaveSavedDir,$remove($gettok($2,5,32),!),_HAVE_,$gettok($1,2,95),.txt,")))) return OK
  else return NO
}


on *:INPUT:#: {
  var %ps_a = PS_OnInput_PS7_#
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ((!WhereIs isin $1-3) || (!wheris isin $1-3) || (!wherei isin $1-3) || ($1 == !w)) {
    if (.!Wher isin $1-3) return
    if ($PS_Channel($chan) == ON) {

      if (($me isreg $chan) && ($PS_Channel($chan,voice) == ON)) {
        echo $ps_n -sat --> Your $+ $ps_kh !WhereIs $2- request has been blocked. Please wait until you have received your +
        goto end
      }

      var %ps_network = $ps_network(OnInput_pserve7_c)
      ;$PS_Init_Whereis_Socket(update)

      ; determine location of !whereis
      if (!w == $1) var %ps_whereisnum = 1
      elseif  (!wher isin $1) var %ps_whereisnum = 1
      elseif (!wher isin $2) var %ps_whereisnum = 2
      else var %ps_whereisnum = 3

      ; ignore !whereis lines that are not !whereis requests
      if ((%ps_whereisnum > 1) && (/ != $left($1,1))) return

      ; strip ip:port
      if ($chr(58) isin $($+($,$calc(%ps_whereisnum + 1)),2)) {
        inc %ps_whereisnum
      }

      ; set   a = trigger   b = everything else
      var %ps_whereisA = $($+($,$calc(%ps_whereisnum + 1)),2)
      var %ps_whereisB = $($+($,$calc(%ps_whereisnum + 2),-),2)

      ; say !whereis for trigger only
      if ((%ps_whereisB == $null) && (. !isin %ps_whereisA) && (* !isin %ps_whereisA) && ($readini($PS_ServeSettings(OnInput_pserve7),n,#Whereis,#Filter) != OFF)) {
        var %ps_whereis_trigfile = $PS_ReadIni($upper($strip(%ps_whereisA)),findfile,44)
        if (!%ps_whereis_trigfile) return
        .window -c @WhereIs_ $+ %ps_network $+ _ $+ %ps_whereisA $+ _collection
        dialog -ma PS_WhereIsFilter PS_WhereIsFilter
        did -ra PS_WhereIsFilter 4 $upper($strip(%ps_whereisA))
        did -ra PS_WhereIsFilter 10 $chan
        var %ps_whereis_tmp = $readini(%ps_whereis_trigfile,n,$upper($strip(%ps_whereisA)),count)
        if (%ps_whereis_tmp != $null) did -ra PS_WhereIsFilter 6 $calc(%ps_whereis_tmp + 1)
        else did -ra PS_WhereIsFilter 6 1
      }

      ; say !whereis for everything else 
      else {
        unset %PSon_filter*
        if ($PS_WhereIsPing == ON) set -u $+ [ $PS_WhereIsPingtime ] %ps_wi_filter_ping $ctime
        else set %ps_wi_filter_ping $ctime

        msg $chan !WheReIs $PSL_getWhereIsAddress $upper(%ps_whereisA) $upper(%ps_whereisB)
      }
      goto end
    }
  }
  return
  :end
  halt 
}


on *:INPUT:?: {
  var %ps_a = PS_OnInput_PS7_?
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  var %ps_network = $PS_Network(%ps_a)
  var %ps_chan = $chan
  var %ps_nick = $nick

  if ((!WhereIs isin $1-3) || (!wheris isin $1-3) || (!wherei isin $1-3) || (!w == $1)) {
    if (.!Wher isin $1-3) return

    ;$PS_Init_Whereis_Socket(update)

    ; determine location of !whereis
    if (!w == $1) var %ps_whereisnum = 1
    if (!wher isin $1) var %ps_whereisnum = 1
    elseif (!wher isin $2) var %ps_whereisnum = 2
    else var %ps_whereisnum = 3

    ; strip ip:port
    if ($chr(58) isin $($+($,$calc(%ps_whereisnum + 1)),2)) {
      inc %ps_whereisnum
    }

    ; set   a = trigger   b = everything else
    var %ps_whereisA = $($+($,$calc(%ps_whereisnum + 1)),2)
    var %ps_whereisB = $($+($,$calc(%ps_whereisnum + 2),-),2)

    ; set ping time
    unset %PSon_filter*
    set %ps_wi_filter_ping $ctime
    if ($PS_WhereIsPing == ON) set -u $+ [ $PS_WhereIsPingtime ] %ps_wi_filter_ping $ctime

    ; say !whereis for everything
    msg $nick !WheReIs $PSL_getWhereIsAddress $upper(%ps_whereisA) $upper(%ps_whereisB)

    halt 
  }
}


dialog PS_WhereIsFilter {
  title "!WhereIs Filter"
  size -1 -1 128 40
  option dbu
  button "OK",1,50 25 36 10,default
  button "Cancel",2,89 25 36 10,cancel
  box "Collection",3,3 3 44 20
  edit "",4,6 10 38 10,autohs
  box "Min Count",5,50 3 36 20
  edit "",6,53 10 30 10,autohs
  check "Exclude OFF",7,5 25 45 10
  box "Max Ping",8,89 3 36 20
  edit "",9,92 10 30 10,autohs
  edit "",10,92 10 30 10,autohs
}


on *:dialog:PS_WhereIsFilter:init:*: {
  var %ps_a = PS_OnDialog_PS7_whereisfilterinit
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  did -c $dname 7
  did -ra $dname 9 $PS_WhereIsPingtime
  if ($PS_WhereIsPing != ON) did -b $dname 9
  did -h $dname 10
}


on *:dialog:PS_WhereIsFilter:sclick:1: {
  var %ps_a = PS_OnDialog_PS7_whereisfiltersclick
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  unset %PSon_filter*
  if ($did($dname,4) == $null) return
  if ($did($dname,9) == $null) return
  if ($did($dname,10) == $null) return
  ;$PS_Init_Whereis_Socket(update)
  set $+(%,pson_filter_onoff_,$did($dname,4)) $did($dname,7).state
  set $+(%,pson_filter_min_count_,$did($dname,4)) $did($dname,6)
  set %ps_wi_filter_ping $ctime
  if ($PS_WhereIsPing == ON) set -u $+ [ $PS_WhereIsPingtime ] %ps_wi_filter_ping $ctime
  .timer 1 $did($dname,9) unset %ps_wi_filter_ping
  .timer 1 $did($dname,9) unset [ $+(%,pson_filter_min_count_,$did($dname,4)) ]
  .timer 1 $did($dname,9) unset [ $+(%,pson_filter_onoff_,$did($dname,4)) ]

  msg $did($dname,10) !WheReIs $PSL_getWhereIsAddress $upper($did($dname,4))

  dialog -x PS_WhereIsFilter
}


























































alias PS_StatsSay {
  var %ps_a = PS_StatsSay
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = calling function
  ; $2 = command to send message as
  ; $3 = nick to send message to

  var %ps_statssay_place = $2
  var %ps_statssay_active = $3

  ; get stats
  var %ps_statssay_on = $PSTC_TriggerStats(AllChannels).ontrigs
  var %ps_statssay_total = $PSTC_TriggerStats(AllChannels).ontrigs + $PSTC_TriggerStats(AllChannels).offtrigs
  var %ps_statssay_fileson = $PSTC_TriggerStats(AllChannels).onfiles
  var %ps_statssay_filestotal = $PSTC_TriggerStats(AllChannels).onfiles + $PSTC_TriggerStats(AllChannels).offfiles
  var %ps_statssay_sizeon = $bytes($PSTC_TriggerStats(AllChannels).onbytes).suf
  var %ps_statssay_sizetotal = $bytes($calc($PSTC_TriggerStats(AllChannels).onbytes + $PSTC_TriggerStats(AllChannels).offbytes)).suf
  var %ps_statssay_complete = $PSTC_TriggerStats(AllChannels).complete
  var %ps_statssay_incomplete = $PSTC_TriggerStats(AllChannels).incomplete
  var %ps_statssay_overcomplete = $PSTC_TriggerStats(AllChannels).overcounts
  var %ps_statssay_cd = $PSTC_TriggerStats(AllChannels).burned
  var %ps_statssay_hdd = $PSTC_TriggerStats(AllChannels).unburned

  ; determine how to send message
  if (%ps_statssay_place == 1) var %ps_statssay_command = echo $ps_n -a
  elseif (%ps_statssay_place == 2) var %ps_statssay_command = msg %ps_statssay_active
  elseif (%ps_statssay_place == 3) var %ps_statssay_command = .notice %ps_statssay_active

  ; send message
  %ps_statssay_command 03Collection Stats: 12Total:02 $+ $chr(91) $+ 10Triggers:07 $+ %ps_statssay_total $+ 02/10 $+ Files:07 $+ %ps_statssay_filestotal $+ 02 $+ 02/10 $+ Size:07 $+ %ps_statssay_sizetotal $+ 02 $+ $chr(93) 03Online:02 $+ $chr(91) $+ 10Triggers:07 $+ %ps_statssay_on $+ 02/10 $+ Files:07 $+ %ps_statssay_fileson $+ 02 $+ 02/10 $+ Size:07 $+ %ps_statssay_sizeon $+ 02 $+ $chr(93) 03Complete: %ps_statssay_complete 13- 04Incomplete: %ps_statssay_incomplete 13- 06OverCount: %ps_statssay_overcomplete 13- 03On HDD: %ps_statssay_hdd 13- 04On CD: %ps_statssay_cd 13- 10DCC Info: $+ $PS_CtcpInfo(%ps_a,%ps_network,PS_Status) 10Speed:07 $+ $PS_Speed(%ps_a)
}














alias PS_SendStatsWindow {
  var %ps_a = PS_SendStatsWindow
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = calling function

  ; make new @triggerlist file
  var %ps_sendstats_file = $+($PS_TriggersDir(PS_SendStatsWindow),TrigList.txt,")
  if ($isfile(%ps_sendstats_file)) .remove %ps_sendstats_file
  .timerSendStatsWindow 300 1 $!PS_SendStatsWindowContinue(PS_SendStatsWindow)
  $PS_RunPserveExeAsync(MakeTriggerlist, AllChannels)
}

alias PS_SendStatsWindowContinue {
  var %ps_a = PS_SendStatsWindowContinue
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = calling function

  var %ps_sendstats_file = $+($PS_TriggersDir(PS_SendStatsWindowContinue),TrigList.txt,")
  if (!$isfile(%ps_sendstats_file)) return
  .timerSendStatsWindow off

  if ($window(@ps_stats_proc) != $null) window -c @ps_stats_proc
  window -lahrs @ps_stats_proc verdana 12
  loadbuf @ps_stats_proc %ps_sendstats_file

  ; open window for final stats display
  if ($window(@PS_Stats_sends) != $null) window -c @PS_Stats_sends
  window -l -t1,11,25 @PS_Stats_Sends
  aline 4 @PS_Stats_sends $chr(9) $+ Sends $chr(9) $+ Trigger $+ $chr(9) $+ Collection Name

  var %ps_sendstats_count = 2
  var %ps_sendstats_total = $line(@ps_stats_proc,0)
  var %ps_sendstats_window = $calc(%ps_sendstats_total - 1)
  while (%ps_sendstats_count <= %ps_sendstats_total) {

    var %ps_tokenize = $strip($line(@ps_stats_proc,%ps_sendstats_count))
    tokenize 9 %ps_tokenize

    ; get send data for trigger
    var %ps_sendstats_Sends = $readini($PS_ReadIni($2,findfile),n,$2,sends)
    if (%ps_sendstats_Sends == $null) var %ps_sendstats_Sends = 0

    ; set color for trigger
    if ($9 == ON) {
      if ($8 == $chr(32)) var %ps_sendstats_Status = 03
      else var %ps_sendstats_Status = 10
    }
    else var %ps_sendstats_Status = 05

    ; calculate line number to insert data at
    var %ps_sendstats_insertline = 2
    if ($line(@PS_Stats_sends,0) > 1) {
      var %ps_total = $line(@PS_Stats_sends,0)
      while (%ps_sendstats_insertline <= %ps_total) && (%ps_sendstats_Sends < $gettok($line(@PS_Stats_Sends,%ps_sendstats_insertline),1,9)) {
        inc %ps_sendstats_insertline
      }
    }

    ; set titlebar with information about load progress
    titlebar @PS_Stats_sends Processing Triggers... %ps_sendstats_count / %ps_sendstats_window

    ; add line to window
    iline %ps_sendstats_Status @PS_Stats_sends %ps_sendstats_insertline $chr(9) $+ %ps_sendstats_Sends $+ $chr(9) $+ $2 $+ $chr(9) $+ $1

    inc %ps_sendstats_count
  }

  ; set titlebar with final collection results
  if ($line(@PS_Stats_sends,0) > 1) titlebar @PS_Stats_sends Total: $calc($line(@PS_Stats_sends,0) - 1) Triggers

  ; close temp window
  if ($window(@ps_stats_proc) != $null) window -c @ps_stats_proc
}

menu @PS_Stats_sends {
  !WhereIs $gettok($sline(@PS_Stats_sends,1),2,9): $PS_WhereIs($lower($gettok($sline(@PS_Stats_sends,1),2,9)))
  Close: window -c @PS_Stats_sends
}







alias PS_SysInfo {
  var %ps_a = PS_SysInfo
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = calling function
  ; $2 = command to send message as
  ; $3 = nick to send message to

  var %ps_sysinfo_free = 0
  var %ps_sysinfo_total = 0

  var %ps_sysinfo_drives = CDEFGHIJKLMNOPQRSTUVWXYZ

  var %ps_sysinfo_count = 1
  while (%ps_sysinfo_count <= 24) {

    ; determine drive letter to process
    var %ps_sysinfo_data = $mid(%ps_sysinfo_drives,%ps_sysinfo_count,1)

    ; skip nonexisting drives
    if (!$disk(%ps_sysinfo_data)) goto inc

    ; get free and total values
    var %ps_sysinfo_data_free = [ $+ [ %ps_sysinfo_data ] ] $disk(%ps_sysinfo_data).free
    var %ps_sysinfo_data_size = [ $+ [ %ps_sysinfo_data ] ] $disk(%ps_sysinfo_data).size

    ; skip specific drive types
    var %ps_sysinfo_type = $disk(%ps_sysinfo_data).type
    if (%ps_sysinfo_type == cdrom) goto skip
    if (%ps_sysinfo_type == removable) goto skip

    ; skip specific excluded drives
    if (%ps_sysinfo_data isin %PS.whereis.drive) goto skip

    ; combine values for each drive
    var %ps_sysinfo_data_disk [ $+ [ %ps_sysinfo_data ] ] 07 $+ %ps_sysinfo_data $+ =03 $+ $round($bytes(%ps_sysinfo_data_free [ $+ [ %ps_sysinfo_data ] ],g),1) $+ /12 $+ $round($bytes(%ps_sysinfo_data_size [ $+ [ %ps_sysinfo_data ] ],g),1)

    ; calc free and size values
    var %ps_sysinfo_free = $calc(%ps_sysinfo_free + %ps_sysinfo_data_free [ $+ [ %ps_sysinfo_data ] ] )
    var %ps_sysinfo_total = $calc(%ps_sysinfo_total + %ps_sysinfo_data_size [ $+ [ %ps_sysinfo_data ] ] )

    goto inc
    :skip
    var %ps_sysinfo_skip = %ps_sysinfo_skip 5 $+ %ps_sysinfo_data $+ $chr(61) $+ %ps_sysinfo_type 3 $+ $chr(47) 
    :inc
    inc %ps_sysinfo_count
  }

  ; combine total values
  var %ps_sysinfo_system = 07Sumary:03 $PS_FileSize(%ps_sysinfo_free,1) (Free) $+ /04 $+ $PS_FileSize(%ps_sysinfo_total,1) (Total) (05 $+ $int($calc(%ps_sysinfo_free / %ps_sysinfo_total * 100)) $+ $chr(37) $+ )

  ; determine what command to use to send the stats message
  if ($2 == 1) var %ps_sysinfo_command = echo $ps_n -a
  elseif ($2 == 2) var %ps_sysinfo_command = msg $chan
  elseif ($2 == 3) var %ps_sysinfo_command = notice $3

  ; final text to send as message
  %ps_sysinfo_command 5Win $os Online for:03 $uptime(system, 2) Record:03 $PSST_GetUptimeRecord Disk Free Status4 (GB): %ps_sysinfo_data_diskc %ps_sysinfo_data_diskd %ps_sysinfo_data_diske %ps_sysinfo_data_diskf %ps_sysinfo_data_diskg %ps_sysinfo_data_diskh %ps_sysinfo_data_diski %ps_sysinfo_data_diskj %ps_sysinfo_data_diskk %ps_sysinfo_data_diskl %ps_sysinfo_data_diskm %ps_sysinfo_data_diskn %ps_sysinfo_data_disko %ps_sysinfo_data_diskp %ps_sysinfo_data_diskq %ps_sysinfo_data_diskr %ps_sysinfo_data_disks %ps_sysinfo_data_diskt %ps_sysinfo_data_disku %ps_sysinfo_data_diskv %ps_sysinfo_data_diskw %ps_sysinfo_data_diskx %ps_sysinfo_data_disky %ps_sysinfo_data_diskz %ps_sysinfo_system 7Skipped: %ps_sysinfo_skip
}
















alias PS_BandWidth {
  var %ps_a = PS_BandWidth
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = calling function
  ; $2 = command to send message as
  ; $3 = nick to send message to

  ; get the network
  var %ps_network = $ps_network(PS_BandWidth)

  ; get photoserve network transfers
  var %ps_bandwidth_networkget = $gettok($PS_GetTotal,2,32) + $PSL_Status_Gets( ).cps
  var %ps_bandwidth_networksend = $PSE_GetCurrentSendSpeed()
  var %ps_bandwidth_networktotal = $calc(%ps_bandwidth_networkget + %ps_bandwidth_networksend)

  ; get all network transfers
  var %ps_bandwidth_globalget = $gettok($PS_GetTotal(global),2,32)
  var %ps_bandwidth_globalsend = $gettok($PS_SendTotal(global),2,32)
  var %ps_bandwidth_globaltotal = $calc(%ps_bandwidth_globalget + %ps_bandwidth_globalsend)

  ; determine what command to use to send the stats message
  if ($2 == 1) var %ps_bandwidth_command = echo $ps_n -a
  elseif ($2 == 2) var %ps_bandwidth_command = msg $3
  elseif ($2 == 3) var %ps_bandwidth_command = .notice $3

  ; final text to send as message
  %ps_bandwidth_command Bandwidth in Use on12 %ps_network 07(03Get07/04Send07/10Total07)10/s 10PS:07(03 $+ $PS_FileSize(%ps_bandwidth_networkget,1) $+ 07/04 $+ $PS_FileSize(%ps_bandwidth_networksend,1) $+ 07/10 $+ $PS_FileSize(%ps_bandwidth_networktotal,1) $+ 07) 10Global:07(03 $+ $PS_FileSize(%ps_bandwidth_globalget,1) $+ 07/04 $+ $PS_FileSize(%ps_bandwidth_globalsend,1) $+ 07/10 $+ $PS_FileSize(%ps_bandwidth_globaltotal,1) $+ 07)
}





















alias PS_Du {
  var %ps_a = PS_Du
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if (!$isfile(%du.file)) {
    .comopen shell WScript.Shell
    if ($comerr) {
      echo 4 -a Unable to open WScript.Shell COM-object
      return
    }
    var %ps = $com(shell, ExpandEnvironmentStrings, 3, bstr, % $+ ALLUSERSPROFILE $+ % )
    var %dir = $com(shell).result
    .comclose shell
    if ($isfile(%dir $+ \Application Data\Hagel Technologies\DU Meter\log.csv)) {
      set %du.file %dir $+ \Application Data\Hagel Technologies\DU Meter\log.csv
    }
    else {
      echo 4 -a Couldn't find your log.csv file, Make sure you have DU-Meter installed.
      return
    }
  }
  var %i = 2, %lines = $lines(%du.file), %du.upload = 0, %du.download = 0
  while (%i <= %lines) {
    inc %du.upload $gettok($read(%du.file,%i),3,44)
    inc %du.download $gettok($read(%du.file,%i),2,44)
    inc %i
  }
  if ($2 == 1) var %ps_command = echo $ps_n -a
  elseif ($2 == 2) var %ps_command = msg $3

  %ps_command 12Du-Meter:10 I have downloaded03 $PS_FileSize(%du.download,2) 10and uploaded04 $PS_FileSize(%du.upload,2) 10(Total:12 $PS_FileSize($calc(%du.upload + %du.download),2) 10) Since:07 $gettok($read(%du.file,1),1,44)
}



















alias Req {
  $PS_TrigReq($1,$active,Request)
}

alias Reqseed {
  $PS_TrigReq($1,$active,Seed)
}

alias Reqreseed {
  $PS_TrigReq($1,$active,Re-Seed)
}




alias ReqLoaded {
  $PS_TrigReq($1,$active,Loaded)
}


alias PS_TrigReq {
  var %ps_a = PS_TrigReq
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = trigger
  ; $2 = destination
  ; $3 = Request / Loaded / Seed / Re-Seed


  var %ps_trigreq_trig = $1
  var %ps_trigreq_channel = $2
  var %ps_trigreq_loaded = $3

  ; if trigger = null ask for user input
  if ((%ps_trigreq_trig == $null) && ($3 = Loaded)) var %ps_trigreq_trig = $?="Trigger to request:"
  if ((%ps_trigreq_trig == $null) && ($3 = Request)) var %ps_trigreq_trig = $?="Trigger request loaded:"

  if (%ps_trigreq_trig != $null) {

    ; verify existance of trigger
    var %ps_trigreq_file = $PS_ReadIni(%ps_trigreq_trig,findfile,9a)
    if (%ps_trigreq_file = $null ) {
      echo $ps_n -sat --> 4Trigger: $+ $ps_kh %ps_trigreq_trig 4Not found or is not setup.
    }
    else {

      ; get trigger information
      var %ps_trigreq_name = $readini(%ps_trigreq_file,n,%ps_trigreq_trig,name)
      var %ps_trigreq_count = $readini(%ps_trigreq_file,n,%ps_trigreq_trig,count)
      var %ps_trigreq_csvcount = $readini(%ps_trigreq_file,n,%ps_trigreq_trig,csvcount)
      var %ps_trigreq_missing = $calc(%ps_trigreq_csvcount - %ps_trigreq_count)

      ; determine colors for trigger type
      var %ps_trigreq_type = $PSTC_GetType(%ps_trigreq_trig)
      if (%ps_trigreq_type == official) var %ps_trigreq_type = 03
      elseif (%ps_trigreq_type == custom) var %ps_trigreq_type = 12
      elseif (%ps_trigreq_type == 3rdparty) var %ps_trigreq_type = 06
      elseif (%ps_trigreq_type == private) var %ps_trigreq_type = 06

      ; determine how to send message
      if (%ps_trigreq_channel != $null) var %ps_trigreq_command = msg %ps_trigreq_channel
      else var %ps_trigreq_command = .say

      ; message to send
      if (%ps_trigreq_loaded == Loaded ) {
        if (!%ps_trigreq_count) %ps_trigreq_command 10Requested trigger $+ %ps_trigreq_type $Upper(%ps_trigreq_trig) 10( $+ %ps_trigreq_type $+ %ps_trigreq_name $+ 10) is 3loaded.
        else %ps_trigreq_command 10Requested trigger $+ %ps_trigreq_type $Upper(%ps_trigreq_trig) 10( $+ %ps_trigreq_type $+ %ps_trigreq_name $+ 10) is 3loaded10 with a count of12 %ps_trigreq_count 10files.
      }
      else {
        if (%ps_trigreq_missing < 1) echo $ps_n -sat --> 4You aren't missing any files for03 %ps_trigreq_trig
        else {
          if ( Seed isin %ps_trigreq_loaded ) %ps_trigreq_command 10I Request $+ %ps_trigreq_type $Upper(%ps_trigreq_trig) 10( $+ %ps_trigreq_type $+ %ps_trigreq_name $+ 10) to be 03 $+ %ps_trigreq_loaded $+ ed10 please (I need04 %ps_trigreq_missing 10files) TIA 1,8:)
          else %ps_trigreq_command 10I Request $+ %ps_trigreq_type $Upper(%ps_trigreq_trig) 10( $+ %ps_trigreq_type $+ %ps_trigreq_name $+ 10) to be turned 03ON10 or 03LOADED10 please (I need04 %ps_trigreq_missing 10files) TIA 1,8:)
        }
      }


    }
  }
}


alias News {
  $PS_TrigNews($1,$active,El-toro)
}


alias News2 {
  $PS_TrigNews($1,$active,Private)
}


alias PS_TrigNews {
  var %ps_a = PS_TrigNews
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = trigger
  ; $2 = destination
  ; $3 = El-toro / Private

  var %ps_trignews_trig = $1
  var %ps_trignews_channel = $2
  var %ps_trignews_source = $3

  ; if trigger = null ask for user input
  if (%ps_trignews_trig == $null) var %ps_trignews_trig = $?="Trigger to Announce:"

  if (%ps_trignews_trig != $null) {

    ; verify existance of trigger
    var %ps_trignews_file = $PS_ReadIni(%ps_trignews_trig,findfile,9a)
    if (%ps_trignews_file = $null ) {
      echo $ps_n -sat --> 4Trigger: $+ $ps_kh %ps_trignews_trig 4Not found or is not setup.
    }
    else {

      ; update count for trigger
      $PSTC_Count(%ps_trignews_trig)

      ; get trigger information
      var %ps_trignews_name = $readini(%ps_trignews_file,n,%ps_trignews_trig,name)
      var %ps_trignews_count = $readini(%ps_trignews_file,n,%ps_trignews_trig,count)
      var %ps_trignews_csvcount = $readini(%ps_trignews_file,n,%ps_trignews_trig,csvcount)
      var %ps_trignews_csvname = $nopath($readini(%ps_trignews_file,n,%ps_trignews_trig,csv))
      var %ps_trignews_csvfile = $PSTC_GetCsv(%ps_trignews_trig)

      ; determine revision of existing .csv file
      if (pre- isin %ps_trignews_csvname) var %ps_trignews_csvstate = 10Pre-Final
      elseif (final isin %ps_trignews_csvname) var %ps_trignews_csvstate = 04Final 
      elseif (reburn isin %ps_trignews_csvname) var %ps_trignews_csvstate = 14Re-Burn
      elseif (re-burn isin %ps_trignews_csvname) var %ps_trignews_csvstate = 14Re-Burn
      else var %ps_trignews_csvstate = 07Ongoing

      ; determine colors for trigger type
      var %ps_trignews_type = $PSTC_GetType(%ps_trignews_trig)
      if (%ps_trignews_type == official) var %ps_trignews_type = 03
      elseif (%ps_trignews_type == custom) var %ps_trignews_type = 12
      elseif (%ps_trignews_type == 3rdparty) var %ps_trignews_type = 06
      elseif (%ps_trignews_type == private) var %ps_trignews_type = 06

      ; determine how to send message
      if (%ps_trignews_channel != $null) var %ps_trignews_command = msg %ps_trignews_channel
      else var %ps_trignews_command = .say

      ; message to send
      if (!%ps_trignews_csvcount) echo $ps_n -sat --> 4CSV count for $+ $ps_kh %ps_trignews_trig 4is 0.
      elseif (!%ps_trignews_name) echo $ps_n -sat --> 4Your Request03 %ps_trignews_trig 4is not valid.
      else {
        if (%ps_trignews_source == Private) {
          %ps_trignews_command 06Trig News10: New %ps_trignews_CSVState 10CSV $+ %ps_trignews_type $Upper(%ps_trignews_trig) 10( $+ %ps_trignews_type $+ %ps_trignews_name $+ 10) File:07 $nopath(%ps_trignews_csvfile) 10Count:07 %ps_trignews_csvcount 10Size:07 $file(%ps_trignews_csvfile).size 10CRC:07 $crc(%ps_trignews_csvfile) 10is available for12 %ps_trignews_channel 10only  1,8:)
        }
        else {
          %ps_trignews_command 06Trig News10: New %ps_trignews_CSVState 10CSV $+ %ps_trignews_type $Upper(%ps_trignews_trig) 10( $+ %ps_trignews_type $+ %ps_trignews_name $+ 10) File:07 $nopath(%ps_trignews_csvfile) 10Count:07 %ps_trignews_csvcount 10Size:07 $file(%ps_trignews_csvfile).size 10CRC:07 $crc(%ps_trignews_csvfile) 10has been made available on the CSV Repositories. Enjoy !
        }
      }
    }
  }
}



alias vmc {
  $PS_TrigStatus($1,$active,Channel)
}



alias vms {
  $PS_TrigStatus($1,$active,Private)
}



alias vmb {
  $PS_TrigStatus($1,$active,Channel,bittorrent)
}



alias PS_TrigStatus {
  var %ps_a = PS_TrigStatus
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  ; $1 = trigger
  ; $2 = channel
  ; $3 = channel / private
  ; $4 = Type is bittorrent or regular ps trigger 

  var %PS_trigstatus_trigger = $1
  var %PS_trigstatus_channel = $2
  var %PS_trigstatus_destination = $3
  var %PS_trigstatus_msg_type = $4

  ; if trigger = null ask for user input
  if (%PS_trigstatus_trigger == $null) var %PS_trigstatus_trigger = $?="Trigger to say count for:"
  if (%PS_trigstatus_trigger != $null) {

    ; verify existance of trigger 
    var %PS_trigstatus_file = $PS_ReadIni(%PS_trigstatus_trigger,findfile,9b)
    if (%PS_trigstatus_file = $null) {
      echo $ps_n -sat --> 4Trigger: $+ $ps_kh %PS_trigstatus_trigger 4Not found or is not setup.
    }
    else {

      ; update count of trigger
      $PSTC_Count(%PS_trigstatus_trigger)

      ; get trigger values
      var %PS_trigstatus_name = $readini(%PS_trigstatus_file,n,%PS_trigstatus_trigger,name)
      var %PS_trigstatus_report = $readini(%PS_trigstatus_file,n,%PS_trigstatus_trigger,rep)
      var %PS_trigstatus_count = $readini(%PS_trigstatus_file,n,%PS_trigstatus_trigger,count)
      var %PS_trigstatus_csvcount = $readini(%PS_trigstatus_file,n,%PS_trigstatus_trigger,csvcount)
      var %PS_trigstatus_csvfile = $nopath($readini(%PS_trigstatus_file,n,%PS_trigstatus_trigger,csv))
      var %PS_trigstatus_type = $PSTC_GetType(%PS_trigstatus_trigger)

      if (!%PS_trigstatus_count) var %PS_trigstatus_count = 0
      if (!%PS_trigstatus_csvcount) var %PS_trigstatus_csvcount = 0

      ; set csv status
      if (pre- isin %PS_trigstatus_csvfile) var %PS_trigstatus_csvstate = 10Pre-Final
      elseif (final isin %PS_trigstatus_csvfile) var %PS_trigstatus_csvstate = 04Final 
      elseif (reburn isin %PS_trigstatus_csvfile) var %PS_trigstatus_csvstate = 14Re-Burn
      elseif (re-burn isin %PS_trigstatus_csvfile) var %PS_trigstatus_csvstate = 14Re-Burn
      else var %PS_trigstatus_csvstate = 07Ongoing

      ; set trigger type color
      if (%PS_trigstatus_type == official) var %PS_trigstatus_type = 03
      elseif (%PS_trigstatus_type == custom) var %PS_trigstatus_type = 12
      elseif (%PS_trigstatus_type == 3rdparty) var %PS_trigstatus_type = 06
      elseif (%PS_trigstatus_type == private) var %PS_trigstatus_type = 06

      ; set count color and count status
      var %PS_trigstatus_miss = $calc(%PS_trigstatus_csvcount - %PS_trigstatus_count)
      if (%PS_trigstatus_miss == 0) var %PS_trigstatus_msg = 10(3UpToDate10)
      if (%PS_trigstatus_miss > 0) var %PS_trigstatus_msg = 10(04 $+ $calc(%PS_trigstatus_csvcount - %PS_trigstatus_count) 10missing file(s)/04 $gettok($read(%PS_trigstatus_report,s,missing:),3,32) 10bytes)
      if (%PS_trigstatus_miss < 0) var %PS_trigstatus_msg = 10(12 $+ $calc(%PS_trigstatus_count - %PS_trigstatus_csvcount) 10file(s) 12Overcount10)

      ; determine how to send message
      if (%PS_trigstatus_destination == Channel) var %PS_trigstatus_command = msg %PS_trigstatus_channel
      else var %PS_trigstatus_command = echo %PS_trigstatus_channel

      ; message to send
      if ( %PS_trigstatus_msg_type == bittorrent) %PS_trigstatus_command 6Bittorrent News10: $+ %PS_trigstatus_type $Upper(%PS_trigstatus_trigger) 10( $+ %PS_trigstatus_type $+ %PS_trigstatus_name $+ 10) CSV:07 %PS_trigstatus_CSVState 10Count:12 %PS_trigstatus_count $+ 10/04 $+ %PS_trigstatus_csvcount %PS_trigstatus_msg  is now on the tracker 
      else %PS_trigstatus_command 6Trig Status10: $+ %PS_trigstatus_type $Upper(%PS_trigstatus_trigger) 10( $+ %PS_trigstatus_type $+ %PS_trigstatus_name $+ 10) CSV:07 %PS_trigstatus_CSVState 10Count:12 %PS_trigstatus_count $+ 10/04 $+ %PS_trigstatus_csvcount %PS_trigstatus_msg

    }
  }
}


















alias PScolors { echo 0,3 COLOR CODES  16,1[1] 16,2[2] 16,3[3] 16,4[4] 16,5[5] 16,6[6] 16,7[7] 16,8[8] 16,9[9] 16,10[10] 16,11[11] 16,12[12] 16,13[13] 16,14[14] 16,15[15] 1,0[0] }
alias PSdccignore { msg $1 File, Options, Dcc, Folders, "ignore only" <== select this, "ignore all except" is to restrictive for file trading channels. }
alias PSidentify { msg $1 If you join the channel and don't get your + then you need to ident:12 /msg bot ident YourPassWord YourOriginalNick If you get a reply for a successful IDENT leave and rejoin the channel to get your + (voice) otherwise see an @. }
alias PSident { msg $1 If you join the channel and don't get your + then you need to ident:12 /msg bot ident YourPassWord YourOriginalNick If you get a reply for a successful IDENT leave and rejoin the channel to get your + (voice) otherwise see an @. }
alias PSecsv { msg $1 If your Leech List populates with missing.jpg you need to change an option in piccheck, select 12options, checking for 07ECSV Pathnames in Output Listing make sure 07Full pathname column is 10Checked! }
alias PSdccsend { msg $1 13DCC Send Problems: First try to connect to a different irc server by typing12 /server $network If this fails to detect your correct IP address you need to change your IP lookup method. Shutdown and restart mIRC Then choose File, Options, Local Info, Change the Lookup Method from 6Normal to Server OR 6Server to Normal. Changing this to the opposit should solve the problem. "Server" is usually the standard option which everyone should use. Reconnect to IRC and see if you can send correctly. }
alias PScustom { msg $1 10IF you are unable to add or remove triggers from a custom group with Photoserve's PSCC Trig Setup (tab) you need to open up the .trg file in notepad.  The top of the file will have a 12[INFO]10 section, in that section the type= value must be set correctly 12type=custom10.  Save the .trg file after editing. }
alias psidentpass { msg $1 7PhotoServe TIP:  4Eventually you WILL need to ident to the bots.3  To simplify this you can select a bot nick now and right click on it, select 7Set Bot Password - PhotoServe12 and enter your password.  3From now on you can right click on a bot nick and select7 Ident - PhotoServe3 to easily ident to the bots. (only ident when you have not received your +) }



ctcp *:dcc send:*: {
  if ($len($nopath($filename)) >= 225) {
    echo $ps_n -sat --> 4WARNING $nick tried to crash your mIRC with an illegal dcc send of $nopath($filename)
    halt
  }
}






alias PS_CheckAllChannelsForTriggerUpdate {
  if (%ps.noAutoTriggerUpdate) return
  var %chans = $channel(0)
  while (%chans) {
    var %channel = $channel(%chans)
    dec %chans
    if ($PSC_isPSonInChannel(%channel)) {
      if ($PSF_getChanSetting(ChannelTriggersAutoUpdateChanList,%channel)) {
        var -s %list = $ifmatch
        ;; we will check if the channels Md5 value is in the list to be checked 
        var %id = $md5($lower(%channel))
        echo -set there is a list %list in %channel - checking for %id ( %channel )
        if ($istok(%list,%id,44)) {
          inc -z %ps_autoupdatetriggerpackdelay 3
          echo %channel --> Auto Update Triggerpackfile from %channel in %ps_autoupdatetriggerpackdelay seconds
          .timer 1 %ps_autoupdatetriggerpackdelay PS_AutoLoadAndUpdateTriggers %channel
          inc -z %ps_autoupdatetriggerpackdelay 200
        }
      }
    }
  }
}



alias PS_AutoLoadAndUpdateTriggers {
  var %chan = $1
  var %url = $PSF_getchansetting(Channeltriggersurl,%chan)
  if (!%url) { echo %chan Sorry, there is no triggerfile configured for the channel %chan | return }

  noop $AutoDownloadFiles_Start(%chan,%url,Trigger)
}

alias -l AutoDownloadFiles_Start {
  var %chan = $1 , %url = $2 , %mode = $3
  if (%ps_autoupdatefile) { echo -st no update started for %chan --> allready running update %ps_autoupdatefile | return }
  if (%mode == Trigger) {
    set -u1600 %ps_autoupdatefile $PS_TmpDir $+ TriggerUpdate_ $+ %chan $+ .zip"
    echo -set starting download of triggerupdate to %ps_autoupdatefile
  }
  set -u1601 %ps_autoupdatemode %mode
  if ($isfile(%ps_autoupdatefile)) .remove %ps_autoupdatefile
  http_get PS_UPDATE %url
}

on *:sockread:PS_UPDATE {
  if ($sockerr) { echo -s download failed | unset %ps_autoupdatefile | return }
  sockread &sockinput
  if (%ps_autoupdatefile) {
    bwrite %ps_autoupdatefile -1 &sockinput
    var %pc = $httpsock($sockname).percent
    if (0 == $calc(%pc % 10)) echo -st Downloading of new %ps_autoupdatefile $+ , $httpsock($sockname).percent $+ % of $bytes($httpsock($sockname).size).suf
  }
  else {
    sockclose $sockname
  }
}

on *:sockclose:PS_UPDATE {
  if ($sockerr) { echo -s download failed | unset %ps_autoupdatefile | return }
  echo 3 -set Download of %ps_autoupdatefile complete
  echo -set Decompressing file %ps_autoupdatefile to $mircdir
  var %res = $PS_Decompress(rem,%ps_autoupdatefile,$mircdir)
  if (%ps_autoupdatemode == Trigger) {
    echo -set Updating Triggers now .. please wait.
    var %file = $PSTC_UpdateTriggers
  }
  unset %ps_autoupdate*
  echo 3 -s Finished: $read(%file,1)
  ; ##### Set titlebar of mirc to show the version of PhotoServe which is loaded #####
  titlebar $version - PhotoServe $PS.Version $PS.Version.beta
  .timer 1 15 PSTC_CheckErrors $me Allchannels $true
}

on *:signal:HttpErr_PS_UPDATE: {
  echo -set download failed: $1-
  unset %ps_autoupdatefile
}

alias PS_CleanScriptDir {
  var %scriptdir = $remove($PS_ScriptDir(PS_cleanscriptdir),")
  echo -st --> Cleaning %scriptdir
  var %count = $findfile(%scriptdir,*,0,0)
  while (%count > 0) {
    var %file = $findfile(%scriptdir,*,%count,0)
    if ($right(%file,4) !== .mrc) {
      echo --> found wrong placed file %file
      remove $+(",%file,")
    }
    dec %count
  }
}
