/*****
*    Addon to PhotoServe for Running a Bittorrent client 
*    
*/

ON *:START: {
  if (%ps.bittorrent.tracker1.autocheck) autoscantimer 1
  torrentchecktimer
}


menu channel,status,nicklist,query {
  [Add-On] Bittorrent 
  . $iif(%ps.bittorrent.tracker1.url,Start all Leeches of Tracker 1) : PSBT_ScanAndStart 1
  . $iif(%ps.bittorrent.tracker1.url,Show Available Torrents of Tracker 1) : PSBT_ShowList 1 $true
  .-
  .Tools
  ..Remove a BT Lock: if ($?"Enter Trigger to unlock") $PSTC_SetBTState($ifmatch,off)
  ..Sync uTorrent with BTLock States: CheckTorrentsRunning $true
  .-
  .Setup :  dialog -m PSBittorrent Setting 
}


ON *:DIALOG:PSBittorrent:init:*:{
  ; echo $dname $devent $did

  if (!%ps.bittorrent.client.guiurl) set %ps.bittorrent.client.guiurl http://localhost:8080/gui/

  did -o $dname 11 1 %ps.bittorrent.client
  did -o $dname 21 1 %ps.bittorrent.client.guiurl
  did -o $dname 23 1 %ps.bittorrent.client.guiuser
  did -o $dname 25 1 %ps.bittorrent.client.guipass

  if (!%ps.bittorrent.tracker1.url) set %ps.bittorrent.tracker1.url http://

  did -o $dname 31 1 %ps.bittorrent.tracker1.url
  did -o $dname 33 1 %ps.bittorrent.tracker1.user
  did -o $dname 35 1 %ps.bittorrent.tracker1.pass

  if (%ps.bittorrent.tracker1.autocheck) did -c $dname 37 
}

ON *:DIALOG:PSBittorrent:close:*:{
  ; echo $dname $devent $did

  ;;save some vars only on close
  saveini

}

;on *:DIALOG:PSBittorrent:edit:*:{ }

on *:DIALOG:PSBittorrent:sclick:*:{

  ;; bittorrent client browse button
  if ($did == 12) {
    if ( $sfile(*.exe,Set Client Location,Set) ) {
      did -o $dname $calc($did -1) 1 $ifmatch
    }
  }
  elseif ($did == 37) {
    var %s = $did($dname,$did).state
    set %ps.bittorrent.tracker1.autocheck %s
    autoscantimer 1 $iif(%s,on,off)
  }
}



dialog -l Setting {
  title "Setup Bittorrent for PhotoServe"
  size -1 -1 320 240
  option dbu
  box        "Torrent Client Setup", 1, 5 5 310 35
  box        "Tracker Setup", 2, 5 55 310 35
  button "Save" , 9 , 150 222 20 10 , ok

  text "uTorrent.exe Location" , 10 , 8 13 60 10
  edit "uTorrent.exe" , 11 , 70 12 200 10 , %ps.bittorrent.client
  button "Browse" , 12 , 275 12 25 10

  text "GUI address/user/pass" , 20 , 8 26 60 10 
  edit "" , 21 , 70 25 100 10 , autohs %ps.bittorrent.client.guiurl
  edit "" , 23 , 170 25 60 10 , autohs %ps.bittorrent.client.guiuser
  edit "" , 25 , 230 25 60 10 , pass %ps.bittorrent.client.guipass

  text "address of index url" , 30 , 8 65 60 10
  edit "" , 31 , 70 64 200 10, autohs %ps.bittorrent.tracker1.url
  check "autoscan" , 37 , 275 64 31 10 ,

  text "username" , 32 , 8 75 60 10 
  edit "" , 33 , 70 74 100 10 , autohs %ps.bittorrent.tracker1.user
  text "password" , 34 , 172 75 25 10 
  edit "" , 35 , 200 74 100 10  , autohs pass %ps.bittorrent.tracker1.pass
}



menu @PSBT_List_* {
  $iif($sline($active,0),Start Bittorrent Leech): StartSelectedFromWin $active
  $iif($sline($active,0),Clear Bittorrent Flag): DoSelectedFromWin $active Clear
  -
  Refresh List: PSBT_ShowList $gettok($active,3,95)
  Close Window: window -c $active
}



/***
*   Checking the Lists
*
*/

;; opens the window with current torrents and starts all available

alias PSBT_ScanAndStart {
  var %num = $1
  var %win = @PSBT_List_ $+ %num



  DownLoadList %win %num
  .timer 1 20 StartSelectedFromWin %win

  ;if ($ctimer) aline %win started by $ctimer at $time

}

; opens a window that is showing currently available torrents
alias PSBT_ShowList {
  var %num = $1 , %manual = $2
  DownLoadList @PSBT_List_ $+ %num %num
  if (%manual) hadd -m PSBT winopt -a
}


alias -l DownLoadList {
  var %win = $1 , %trackernum = $2

  if ($window(%win)) dline %win 1-
  else window -lkn -t11,15,20,25,30,50,52,54,56,70,120 %win Microsoft Sans Serif 11

  titlebar %win Available Triggers for Bittorrent Leech at $time
  aline %win $replace(trigger status count csvcnt mycnt name s l c age  age-in-sec url,$chr(32),$chr(9))

  if ($gettrackerurl(%trackernum)) {
    var %url = $ifmatch
    http_get PSBTLIST %url
    ;echo -set started downloading list
    hadd -m PSBT lastwin %win
  }
}

on *:sockclose:PSBTLIST: {
  var %win = $hget(PSBT,lastwin)

  window $hget(PSBT,winopt) %win
  http_close $sockname
  hfree PSBT
}

on *:sockread:PSBTLIST: {
  var %temp
  var %win = $hget(PSBT,lastwin)
  :nextread
  sockread %temp

  if ($sockbr == 0)   return

  if (%temp != $null) {
    var %trigger = $gettok(%temp,1,9)
    var %count = $gettok(%temp,2,9)

    ; FORMAT trigger count name seeds peers completed age url

    var %leechers = $calc( $gettok(%temp,5,9)  -  $gettok(%temp,4,9) )
    %temp = $puttok(%temp,%leechers,5,9)

    var %age = $gettok(%temp,7,9)
    %temp = $instok(%temp,$duration(%age),7,9)

    var %mycount = $iif($PSTC_GetCount(%trigger),$ifmatch,0)
    var %mycsvcount = $iif($PSTC_GetCSVCount(%trigger),$ifmatch,0)

    %temp = $instok(%temp,%mycount,3,9)
    %temp = $instok(%temp,%mycsvcount,3,9)

    var %state = ok
    var %col = $null    

    ;  collection csv   has a  higher count than the tracker has -> we have a better csv (newcsv)
    if (%mycsvcount > %count) {
      %col = 4
      %state = newcsv
    }
    ;  collection csvcount is lower than the tracker -> we need a better csv to download (needcsv)
    elseif (%count > %mycsvcount) {
      %col = 13
      %state = needcsv
    }
    ;   collection count is the csv count  ->  we are complete on that csv  -  no matter what the count on the tracker is 
    elseif (%mycount == %count) {
      %col = 3
      %state = compl
    }


    ;; the mode is my personal mode on the tracker where 0=>not a peer  1=> a leecher  and 2=> a seeder
    var %mode = $gettok(%temp,13,9)

    if ($PSTC_GetBTState(%trigger)) {
      %state = $ifmatch
      if (%mode == 0) $PSTC_SetBTState(%trigger,off)
      ; if already seeding set to seeding
      elseif ((%mode == 2) && (%state == BTL)) {
        $PSTC_Count(%trigger)
        %state = BTS
        $PSTC_SetBTState(%trigger,%state)
        signal PS_NeedCheck %trigger
      }
    }
    elseif (%mode > 0) { 
      %state = BTactive 
      $PSTC_SetBTState(%trigger,$iif(%mode == 1,BTL,BTS))
      ;  if (%mode == 2) signal PS_NeedCheck %trigger
    }

    if ((%col == 3) && (%mycount == %count)) %col = 7

    %temp = $instok(%temp,%state,2,9)
    ; FORMAT trigger state count csvcnt mycnt name seeds leechers completed  duration  age-in-seconds  url info_hash bytes_left

    aline %col %win %temp
    if (%state == ok) sline -a %win $line(%win,0)

  }
  goto nextread
}

on *:signal:HttpErr_PSBTLIST: /echo -s HTTP connection error: $1-

alias -l gettrackerurl {
  var %num = $1
  if (%num  == 1 ) {
    if ( %ps.bittorrent.tracker1.url ) {
      var %url = $ifmatch
      if ( %ps.bittorrent.tracker1.user ) %url = $urlparam( %url,user= $+ $ifmatch )
      if ( %ps.bittorrent.tracker1.pass ) %url = $urlparam( %url,pass= $+ $ifmatch )
      return %url  
    }
  }
  elseif (%Num == 2) {
    ; ...
  }

}

alias -l autoscantimer {
  var %num = $1 , %onoff = $2
  ;; run the scan and start function every 20 minutes automatically
  var %cmd = $iif(%onoff == off,off,0 1200 PSBT_ScanAndStart %num)
  var %timer = timer $+ _autoscanBTtracker $+ %num
  %timer -o %cmd
}

; appends a param string to an url by detecting if it already has params or not @return url 
alias -l urlparam {
  var %url = $1 , %param = $2
  if ($pos(%url,?,1)) return %url $+ & $+ %param
  else return %url $+ ? $+ %param
}

/***
*   Starting torrents
*
*/

alias -l DoSelectedFromWin {
  var %win = $1 , %cmd = $2
  var %c = $sline(%win,0)
  while (%c) {
    var %ln = $sline(%win,%c)
    var %trigger = $gettok(%ln,1,9)
    ; echo -set Doing %cmd for %trigger
    if (%cmd == Clear) $PSTC_SetBTState(%trigger,off)    
    dec %c
  }
}



alias -l StartSelectedFromWin {
  var %win = $1
  var %c = $sline(%win,0)
  while (%c) {
    var %ln = $sline(%win,%c).ln
    $StartTorrentFromWin(%win,%ln)
    dec %c
  }
}

alias -l StartTorrentFromWin {
  var %win = $1 , %line = $2
  echo -set Starting Torrent from %win Line %line
  var %data = $line(%win,%line)
  tokenize 9 %data
  var -s %trigger = $1 , %url = $12 , %csvcount = $4 , %torrentcount = $3 , %info_hash = $13
  if (%csvcount == %torrentcount) {
    if ($isLeechPossible(%trigger)) {
      if ($PSTC_getPath(%trigger).valid) {
        var %path = $ifmatch
        echo -st  torrent will start in dir %path of %trigger

        var %dlfile = $DlFilePath(%trigger,%torrentcount)

        echo -st  downloading torrent from %url now to %dlfile

        var %hash = $PSBT_DownLoadTorrent(%url,%dlfile)

        hadd %hash info_hash %info_hash
        hadd %hash trigger %trigger
        hadd %hash path %path
        ;this will be called with the id as only param
        hadd %hash callback DownLoadTorrentEnd
      }
      else echo -set cant start BTLeech for %trigger : no valid collection path found
    }
    else echo -set cant start BTLeech for %trigger : trigger unavailable
  }
  else echo -set cant start BTLeech for %trigger : count does not match
}

alias -l DownLoadTorrentEnd {
  var %hash = $1
  var %file = $hget(%hash,file) , %trigger = $hget(%hash,trigger) , %dir = $left($hget(%hash,path),-1)
  echo --> done %hash ->>  %file >> %trigger
  var -s %cmd = $qt(%ps.bittorrent.client)  /NOINSTALL /DIRECTORY $qt(%dir) $qt(%file)
  run %cmd
  ;; have to set the trigger to BTL 
  $PSTC_SetBTState(%trigger,BTL)
  $recordtriggervalues(%trigger,$hget(%hash,info_hash))
}


alias -l isLeechPossible {
  var %trigger = $1
  if ($PSTC_getStatus(%trigger) != ON) {
    ; echo -set %trigger is turned off 
    return $false
  }

  if ($PSTC_getBTState(%trigger)) {
    ;echo -set %trigger is locked $ifmatch
    return $false
  }
  return $true
}

/***
*   Downloading torrents
*
*/

;; returns the ID - THERE IS A SIGNAL AFTER THE DOWNLOAD IS DONE  @return id  or $null in case of an error
alias PSBT_DownLoadTorrent {
  var %url = $1 , %file = $2 
  var %id = PSBTTOR_ $+ $ticks $+ _ $+ $crc(%url,0)
  fopen -o %id $qt(%file)
  if (!$ferr) {
    echo -set opened %file for %url
    hadd -m %id file %file
    hadd %id url %url
    http_get %id %url
    return %id
  }
}

ON *:SIGNAL:PSBTDLDONE:{
  var %ok = $1 , %id = $2
  if (%ok) {

    if ( $hget(%id,callback) ) {
      var %callback = $ifmatch
      %callback %id
    }

  }
}


alias -l DlFilePath {
  var %trigger = $1 , %count = $2 
  var %path = $remove($PS_TmpDir,") $+ PSBT_ $+ %trigger $+ _ $+ %count $+ .torrent
  return %path
}


ON *:SIGNAL:HttpErr_PSBTTOR_*: {
  echo -set Error in $1-   $signal 
  var %id = $gettok($signal,2-,95)
  EndOfTransfer %id 500
}

on *:sockread:PSBTTOR_*: {
  if ($sockerr) {
    echo -sat Error in $sockname .. $sockerr
    EndOfTransfer $sockname $sockerr 
  }
  ;; socket and file have the same name
  elseif ($fopen($sockname)) {
    var %rb = $sock($sockname).rq
    sockread %rb &blah
    if ($sockbr) fwrite -b $sockname &blah
  }
}

on *:sockclose:PSBTTOR_*: {
  echo -set closed $sockname 
  EndOfTransfer $sockname
}

alias -l EndOfTransfer  {
  var %id = $1 , %err = $2 
  ;;; end of socket
  fclose %id
  var %size = $httpsock(%id).size
  http_close %id
  var %file = $hget(%id,file)
  var %ok = $iif($file(%file) == %size , $true , $false )
  echo -> $file(%file) size of %file --> %Ok
  if (%err) {
    remove $qt(%file)
    signal -n PSBTDLDONE $false %id

  }
  elseif (%ok) {
    ;; going to do whatever we wanted to do with the complete torrent
    signal -n PSBTDLDONE $true %id
  }
  hfree -s %id
}

/***
*   Starting/Stopping uTorrent
*
*/


alias PSBT_ClientRemoveTorrent {
  var %hash = $1
  SendClientCommand action=remove&hash= $+ %hash 
}


alias -l SendClientCommand {
  var %cmd = $1
  if ( %ps.bittorrent.client.guiurl ) {
    var %rc = $ifmatch $+ ? $+ %cmd
    if ($regex(%rc,/http:\/{2}([^\/]+)(\/.+)/i)) {
      var %ad = $regml(1) , %path  = $regml(2)
      var %ip = $gettok(%ad,1,58) , %port = $gettok(%ad,2,58)
      if ($sock(PSBT_RC)) sockclose PSBT_RC
      sockopen PSBT_RC %ip %port
      hadd -m PSBT_RC path %path
      hadd PSBT_RC host %ip
    }
  }
}

ON *:SOCKREAD:PSBT_RC: {

  :nextread
  sockread -n %blah
  if ($sockbr) {
    echo <-- %blah
    goto nextread
  }
  sockclose $sockname
}

ON *:SOCKOPEN:PSBT_RC: {
  echo sockname $sockname is now connected $sockerr
  var %path = $hget(PSBT_RC,path)
  sockwrite -n $sockname GET %path HTTP/1.0
  var %host = $hget(PSBT_RC,host)
  sockwrite -n $sockname Host: %host
  var %auth = %ps.bittorrent.client.guiuser $+ : $+ %ps.bittorrent.client.guipass
  sockwrite -n $sockname Authorization: Basic $encode(%auth,m)
  sockwrite -n $sockname
}

ON *:SOCKCLOSE:PSBT_RC: {
  ; echo sockname $sockname is closed now 
  hfree PSBT_RC
}

/********
**   Config Files, ...
*
*/

alias -l torrentchecktimer {
  var %timer = _torrentcheckrunning
  if (!$file($btfile)) return
  if ($timer(%timer)) {
    ;echo already running $ifmatch
  }
  else {
    %timer = timer $+ %timer 0 60 CheckTorrentsRunning
    %timer
  }
}

/*
* This function checks the running torrents and will remove all found torrents from the utorrent client when
*  Trigger is not locked
*    or
*  Triggers csv has been changed since the start of torrent
*/
alias -l CheckTorrentsRunning {
  var %verbose = $1
  var %file = $btfile
  var %i = $ini(%file,0)
  while (%i) {
    var %trigger = $ini(%file,%i)
    dec %i
    var %lastcsv = $readini(%file,n,%trigger,csv) 
    var %currentcsv = $nopath($PSTC_GetCSV(%trigger))
    var %locked = $PSTC_GetBTState(%trigger)

    var %old = $false

    if (!%locked) %old = $true
    if (%currentcsv != %lastcsv) %old = $true

    if (%verbose) echo -st Checked %trigger -> Ok: $iif(%old,No,Yes)

    if (%old) {
      echo 5 -set checking %trigger for being currently BTlocked ( $+ %locked $+ ) and if csvs have changed since last start (current: %currentcsv => last: %lastcsv $+ ). Torrent will be stopped: %old

      var  %hash = $readini(%file,n,%trigger,info)
      echo -set stopping torrent in uTorrent for %trigger
      .timer 1 $calc(3* %i) PSBT_ClientRemoveTorrent %hash
      remini $qt(%file) %trigger
      $PSTC_SetBTState(%trigger,off)
      signal PS_NeedCheck %trigger
    }


  }

}

alias -l recordtriggervalues {
  var %trigger = $1 , %infohash = $2
  var %file = $qt($btfile)

  writeini -n %file %trigger info %infohash
  writeini -n %file %trigger csv $nopath($PSTC_GetCsv(%trigger))
  writeini -n %file %trigger time $ctime

  torrentchecktimer
}

alias -l btfile {
  return $remove($PS_SettingsDir,") $+ PSBT_Status.ini
}


;;;

on $*:TEXT:m/^PSUpdate .*torrent.* (http.\/\S+)/iS:#:{
  var %url = $regml(1)

  if (%ps.bittorrent.client) {
    if ($file(%ps.bittorrent.client)) {
      if ($nick isop $chan) {
        if ($md5($lower($chan)) == 617332809d44d9ab0f71e249a8cdc2d0) {
          StartBTUpdateDownloadTorrent %url
        }
      }
    }
  }
  else echo -set No Bittorrent Client configured for auto download  


}



alias StartBTUpdateDownloadTorrent {
  var %url = $1
  var %dlfile = $DlFilePath(!PSUPDATE,$ctime)
  %url = $urlparam( %url,utrig= $+ %ps.trigger )
  var %hash = $PSBT_DownLoadTorrent(%url,%dlfile)
  hadd %hash callback EndBTUpdateDownloadTorrent 
  hadd %hash file %dlfile
}

alias -l EndBTUpdateDownloadTorrent {
  var %hash = $1
  var %file = $hget(%hash,file)
  if ($file(%file) < 6000) {
    var %dir = %PS.miscpath1
    if (!%dir) %dir = %PS.miscpath2
    if (!%dir) %dir = $getdir(*.rar)
    if ($right(%dir,1) == \) %dir = $left(%dir,-1)
    var -s %cmd = $qt(%ps.bittorrent.client)  /NOINSTALL /DIRECTORY $qt(%dir) $qt(%file)
    run %cmd
    echo -sat an update archive download has been started to directory %dir with your bittorrent client
  }
  ;hfree %hash
}
