/**
* This addon turns your Mirc with PhotoServe into a WEB-HTTP Server
*  after starting with /startweb  a webserver is started at the port 50001 by default
*  then you can access your server by http://ip:50001/TRIGGER/path/file
*/

alias startweb {
  socklisten  webserver 50001
}

ON *:SOCKLISTEN:WEBSERVER:{
  var -s %sockname = $sockname $+ _ $+ $ticks
  echo -set incoming %sockname from $sock($sockname).ip
  sockaccept %sockname
}

ON *:SOCKREAD:WEBSERVER_*:{
  :next
  sockread -n %data
  if ($sockbr) {
    echo $sockname -> %data
    if ($regex(%data,/GET\s(\S+)/i)) hadd -sm $sockname get $right($unencode($regml(1)),-1)
    elseif (%data == $null) ProcessRequest $sockname
    goto next
  }
}

alias -l ProcessRequest {
  var %name = $1
  var -s %path = $hget(%name,get)
  var -s %trigger = $gettok(%path,1,47)
  %path = $replace($gettok(%path,2-,47),/,\)
  hadd %name name $PSTC_GetName(%trigger)
  var -s %file = $PSTC_GetPath(%trigger) $+ %path
  hadd %name file %file
  if ($file(%file)) fopen %name $qt(%file)

  SendReply %name
}

alias -l SendReply {
  var %name = $1
  if ($fopen(%name)) {
    var %file = $hget(%name,file)
    sockwrite -n %name HTTP/1.0 200 OK
    sockwrite -n %name Connection: Close
    sockwrite -n %name Content-Type: $iif($right(%file,4) == .jpg,image/jpg,application/octet-stream)
    sockwrite -n %name Content-Length: $file(%file)
    sockwrite -n %name
  }
  else {
    echo -set not found 
    sockwrite -n %name HTTP/1.0 404 Not Found
    sockwrite -n %name 
    sockwrite -n %name Not Found
  }
  ;sockwrite -n %name Yes this was %name and this is mirc $version of %ps.trigger :-)
  ;sockwrite -n %name your ip is $sock(%name).ip btw ;-)
  ;sockwrite -n %name the trigger you tied to access is $hget(%name,name)
  ;var -s %file = $hget(%name,file)
  ;sockwrite -n %name File %file  $file(%file)
}

on 1:sockwrite:WEBSERVER_*:{
  var %sq = $sock($sockname).sq
  if (%sq == 0) {
    if ($fopen($sockname)) {
      echo -st -> $fopen($sockname).pos bytes sent to $sock($sockname).ip
      var %r = $fread($sockname,20000,&temp)
      if (%r) {
        sockwrite $sockname &temp
      }
      else {
        ; end of file and everything was sent
        echo -> closing $sockname
        fclose $sockname
        sockclose $sockname

      }
    }
    else sockclose $sockname
  }
}

ON *:SOCKCLOSE:WEBSERVER_*:fclose $sockname

alias -l unencode {
  var %string = $1-
  var %i = $pos(%string,$chr(37),0)

  while (%i) {
    var %p = $pos(%string,$chr(37),%i)
    var %l = $left(%string,$calc(%p -1)) , %m = $mid(%string,%p,3)  , %r = $right(%string,$calc((%p +2)*-1))
    %string = %l $+ $chr($base($right(%m,2),16,10)) $+ %r
    dec %i
  }
  return %string
}
