
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>PSA - PhotoServe Appearance</b> - Customize look and feel of pserve
* <p>
* This is the home for options and functions that only change the way thing appear,
* without doing any/much "useful" work. Currently this includes Nick coloring, dialog
* coloring, channel filtering, on-desktop settings, logging, debugging.
* <p>
* Global variables (settings):<ul>
* <li>%ps.appearance.nickcolor.enabled  -- Is nick coloring enabled? (boolean)
* <li>%ps.appearance.nickcolor.nontrade -- Also for non-trade channels? (boolean)
* <li>%ps.appearance.nickcolor.clist    -- ":" separated list of colors
* <li>%ps.appearance.dialogs.listcolor  -- text and background colors of list/treeviews
* <li>%ps.appearance.dialogs.showgrid   -- Should MDX listvies have grids (boolean)
* <li>%ps.appearance.hide.*             -- Set of booleans to filter channel text / events
* <li>%ps.appearance.ondesktop.*        -- Set of booleans to open certain windows on desktop
* <li>%ps.appearance.offnotify          -- If $true mirc will echo to channels when ps is off
* <li>%ps.dlg.ontop                     -- Always On Top -flag for PSCC and child dialogs
* <li>%ps.whereis.sendmsg               -- Get/Send stats message for positive ratios
* <li>%ps.whereis.getmsg                -- Get/Send stats message for negative ratios
* <li>%ps.whereis.eqmsg                 -- Get/Send stats message for equal ratios
* <li>%ps.whereis.drive                 -- List of drives to be excluded from free space info
* <li>%ps.debug.gets                    -- Show debug info for gets? (boolean)
* <li>%ps.debug.gets_all                -- Show debug info for all gets? Otherwise only triggerlists (boolean)
* <li>%ps.debug.whereis                 -- Echo whereis to status windows? (boolean)
* </ul>
* Transient globals:<ul>
* <li>%ps_cc_listviews -- List MDX listview IDs in PSCC (for coloring and right click)
* <li>%ps_cc_treeviews -- List MDX treeview IDs in PSCC (for coloring and right click)
* </ul>
*/




/****************************************************************************************
* Close the color selection windows on dialog close
*/
ON *:dialog:Ps_Dlg_Ax:close:0: {
  window -c @PSA_NC_ColorSelector
  window -c @PSA_NC_ColorPalette
}


/****************************************************************************************
* Create and embed the color selection windows on dialog init @param void @return void
*/
alias PSCC_CreateTab2300 {
  var %dname = $1

  var %ps = $PS_Mdx(SetControlMDX,2304 window > [ $PS_ddll ] )
  window -lh -t100 @PSA_NC_ColorSelector 
  did -a %dname 2304 grab $window(@PSA_NC_ColorSelector).hwnd @PSA_NC_ColorSelector
  var %ps = $PS_MDX(SetBorderStyle, 2304 staticedge)

  var %ps = $PS_Mdx(SetControlMDX,2305 window > [ $PS_ddll ] )
  window -lh @PSA_NC_ColorPalette
  did -a %dname 2305 grab $window(@PSA_NC_ColorPalette).hwnd @PSA_NC_ColorPalette
  var %ps = $PS_MDX(SetBorderStyle, 2305 staticedge)

  $PSCC_MakeListview(%dname,2312, single showsel rowselect report, 174:1 0:2, +l ListView Color Scheme, +l RGB)
}


/****************************************************************************************
* Populate controls with data @param void @return void
*/
alias PSCC_PopulateTab2300 {
  var %dname = $1

  ; Channel message filters
  if (%ps.appearance.hide.voice) did -c %dname 2321 
  if (%ps.appearance.hide.whereis) did -c %dname 2322
  if (%ps.appearance.hide.trigger) did -c %dname 2323
  if (%ps.appearance.hide.botgreet) did -c %dname 2324
  if (%ps.appearance.hide.trignews) did -c %dname 2325
  if (%ps.appearance.hide.trigstatus) did -c %dname 2326
  if (%ps.appearance.hide.statsmaker) did -c %dname 2327
  if (%ps.appearance.hide.xferstats) did -c %dname 2328
  if (%ps.appearance.hide.bwstats) did -c %dname 2329
  if (%ps.appearance.hide.collstats) did -c %dname 2330
  if (%ps.appearance.hide.sysinfo) did -c %dname 2331
  if (%ps.appearance.hide.ipport) did -c %dname 2332
  if (%ps.appearance.hide.whereis) did -b %dname 2332
  if (!%ps.showwhereis) did -c %dname 2333

  ; Open-on-desktop settings
  if (%ps.appearance.ondesktop.pscc) did -c %dname 2341 
  if (%ps.appearance.ondesktop.triglist) did -c %dname 2342 
  if (%ps.appearance.ondesktop.servinfo) did -c %dname 2343 
  if (%ps.appearance.ondesktop.whereis) did -c %dname 2344 
  if (%PS.dlg.ontop == o) did -c %dname 2346

  ; Nick color settings
  if (%ps.appearance.nickcolor.enabled) { did -c %dname 2302 | did -e %dname 2303,2306 }
  if (%ps.appearance.nickcolor.nontrade)  did -c %dname 2303
  ; number after tab is the %ps.appearance.nickcolor.clist token number of this nick-type
  aline @PSA_NC_ColorSelector @bot        $+ $chr(9) $+ 2
  aline @PSA_NC_ColorSelector @chanop     $+ $chr(9) $+ 3
  aline @PSA_NC_ColorSelector % $+ halfop $+ $chr(9) $+ 4
  aline @PSA_NC_ColorSelector +voiced     $+ $chr(9) $+ 5
  aline @PSA_NC_ColorSelector +target     $+ $chr(9) $+ 9
  aline @PSA_NC_ColorSelector +blocked    $+ $chr(9) $+ 10
  aline @PSA_NC_ColorSelector +leecher    $+ $chr(9) $+ 8
  aline @PSA_NC_ColorSelector +sender     $+ $chr(9) $+ 7
  aline @PSA_NC_ColorSelector + $+ $me    $+ $chr(9) $+ 1
  aline @PSA_NC_ColorSelector unvoiced    $+ $chr(9) $+ 6
  aline @PSA_NC_ColorSelector  
  PSA_NC_RecolorSelector
  ; Init color palette
  var %i = 0
  while (%i <= 15) {
    aline %i @PSA_NC_ColorPalette $iif(%i < 10,0 $+ %i,%i)
    inc %i
  }

  ; Dialog Look options
  if (%ps.appearance.dialogs.showgrid) did -c %dname 2311
  did -a %dname 2312 Use System Default $+ $chr(9) $+ + 0 0 0 default default
  did -a %dname 2312 Match Mirc Windows $+ $chr(9) $+ + 0 0 0 $color($color(normal text)).rgb $color($color(background)).rgb
  did -a %dname 2312 Black on White $+ $chr(9)     $+ + 0 0 0 $rgb(0,0,0)       $rgb(255,255,255)
  did -a %dname 2312 Green on Black $+ $chr(9)     $+ + 0 0 0 $rgb(80,240,50)   $rgb(0,0,0)
  did -a %dname 2312 Grey on Black $+ $chr(9)      $+ + 0 0 0 $rgb(192,192,192) $rgb(0,0,0)
  did -c %dname 2312 $didwm(%dname, 2312, * $+ %ps.appearance.dialogs.listcolor, 1)

  ; System/GetSend Info
  did -a %dname 2352 %ps.whereis.drive
  did -a %dname 2354 %ps.whereis.sendmsg
  did -a %dname 2356 %ps.whereis.getmsg
  did -a %dname 2358 %ps.whereis.eqmsg

  ; Logging options (TODO: this transition is not finished)
  if (%ps.whereislog == On) did -c %dname 862 
  if (%ps.trigreq.log != $null) did -c PS_Dlg_AX 649
  if (%PS.rapidsharelog != $null) did -c PS_Dlg_AX 2379
  if (%PS.torrentlog != $null) did -c PS_Dlg_AX 2383
  if ($script(Awaylog.mrc) != $null) did -c PS_Dlg_AX 852
  if ($script(Dcclog.mrc) != $null) did -c PS_Dlg_AX 876

  ; Debug Settings
  if (%ps.debug.whereis) did -c %dname 2371
  if (%ps.debug.gets) {
    did -c %dname 2372
    did -e %dname 2373,2374
  }
  if (%ps.debug.gets_show_all) did -c %dname 2374
  else                         did -c %dname 2373

  ; Off notify 
  if (%ps.appearance.offnotify) did -c %dname 2381
}


/****************************************************************************************
* Pserve fly-over help (tooltips)
*/
on *:DIALOG:PS_Dlg_AX:mouse:*: {
  if ((%PS_help_on == on) && ($dialog($dname).tab == 2300)) {
    var %x = $calc($mouse.x / $dbuw), %y = $calc($mouse.y / $dbuh)
    if ($inrect(%x,%y,   9, 32, 70, 10))   { did -a $dname 997 Turn nick coloring on/off in pserve-using channels | return }
    if ($inrect(%x,%y,  19, 42, 77, 10))   { did -a $dname 997 This options allows you to use nick colors on regular chat channel | return }
    if ($inrect(%x,%y,  19, 53, 50,130))   { did -a $dname 997 Right click on a nicktype and select number of the desired color from context menu | return }
    if ($inrect(%x,%y,  74, 53, 20,130))   { did -a $dname 997 This is the list of available colors and their numbers | return }
    if ($inrect(%x,%y,  19,188, 75, 12))   { did -a $dname 997 Reset nick colors to pserve defaults | return }
    if ($inrect(%x,%y, 104, 32, 65,  8))   { did -a $dname 997 Hide the "Bot sets mode +v .." event in pserve-using channels | return }
    if ($inrect(%x,%y, 104, 42, 65,  8))   { did -a $dname 997 Hide manual !whereis requests made by other users | return }
    if ($inrect(%x,%y, 104, 52, 65,  8))   { did -a $dname 997 Hide IP and Port from manual !whereis requests made by other people | return }
    if ($inrect(%x,%y, 104, 62, 65,  8))   { did -a $dname 997 Hide all other !commands such as !servinfo | return }
    if ($inrect(%x,%y, 104, 72, 65,  8))   { did -a $dname 997 Hide the greeting message shown by bots when some users join | return }
    if ($inrect(%x,%y, 104, 82, 65,  8))   { did -a $dname 997 Hide news about new CSV releases | return }
    if ($inrect(%x,%y, 104, 92, 65,  8))   { did -a $dname 997 Hide trigger count news | return }
    if ($inrect(%x,%y, 104,102, 65,  8))   { did -a $dname 997 Hide StatsMaker messages from channel | return }
    if ($inrect(%x,%y, 104,112, 65,  8))   { did -a $dname 997 Hide "Bandwidth in Use on ... (Get/Send/Total)/s PS:(xB/xB/xB) Global:(xB/xB/xB)" | return }
    if ($inrect(%x,%y, 104,122, 65,  8))   { did -a $dname 997 Hide "Collection Stats: Total:[Triggers:xxx/Files:xxxx] ... Complete: xx - Incomplete: xx ..." | return }
    if ($inrect(%x,%y, 104,132, 65,  8))   { did -a $dname 997 Hide "Windows Online for: ... Disk Free Status: ..." | return }
    if ($inrect(%x,%y, 104,142, 65,  8))   { did -a $dname 997 Hide "(Get/Send) This Week/Month/Year, Files ..." | return }
    if ($inrect(%x,%y, 104,152, 65,  8))   { did -a $dname 997 Hide !WhereIs requests autoleech makes while you are leeching | return }
    if ($inrect(%x,%y, 104,173, 65,  8))   { did -a $dname 997 Show all !whereis requests made by other users in your status window | return }
    if ($inrect(%x,%y, 104,183, 90,  8))   { did -a $dname 997 Show debugging information about incomming file transfers in your status window | return }
    if ($inrect(%x,%y, 114,192, 35,  8))   { did -a $dname 997 Show the debugging information only for incomming triggerlists | return }
    if ($inrect(%x,%y, 153,192, 35,  8))   { did -a $dname 997 Show the debugging information for ALL incomming transfers | return }
    if ($inrect(%x,%y, 200, 32, 60, 10))   { did -a $dname 997 Show a grey grid in ListViews like the one right below | return }
    if ($inrect(%x,%y, 200, 43, 90, 59))   { did -a $dname 997 Select a color scheme for ListViews like this | return }
    if ($inrect(%x,%y, 299, 32, 65,  8))   { did -a $dname 997 Opening PSCC on desktop is usually good idea because else it covers other mirc-windows | return }
    if ($inrect(%x,%y, 299, 42, 65,  8))   { did -a $dname 997 Opening dialogs on desktop is usually good idea because else they cover other mirc-windows | return }
    if ($inrect(%x,%y, 299, 52, 65,  8))   { did -a $dname 997 Note that Triggerlist windows may popup on desktop unexpectedly even while mirc is minimized | return }
    if ($inrect(%x,%y, 299, 62, 65,  8))   { did -a $dname 997 Note that Servinfo windows may popup on desktop unexpectedly even while mirc is minimized | return }
    if ($inrect(%x,%y, 299, 72, 65,  8))   { did -a $dname 997 Note that WhereIs windows may popup on desktop unexpectedly even while mirc is minimized | return }
    if ($inrect(%x,%y, 299, 87, 65,  8))   { did -a $dname 997 Make PS Control Center always appear on top of all other programs | return }
    if ($inrect(%x,%y, 277,108, 40, 10))   { did -a $dname 997 Exclude drive letters from free disk space stats in "Photoserve -> Say -> System Info" | return }
    if ($inrect(%x,%y, 264,119,127, 10))   { did -a $dname 997 Message telling what a good boy you have been by sending more than leeching | return }
    if ($inrect(%x,%y, 264,130,127, 10))   { did -a $dname 997 Message explaining why you have been such a naughty leech | return }
    if ($inrect(%x,%y, 264,141,127, 10))   { did -a $dname 997 Message to show in Get/Send info when you have sent the same amount as leeched | return }
    if ($inrect(%x,%y, 200,162, 50, 10))   { did -a $dname 997 Logs private messages to a small log window | return }
    if ($inrect(%x,%y, 200,172, 80, 10))   { did -a $dname 997 Logs requests to load triggers to a small window | return }
    if ($inrect(%x,%y, 200,182, 75, 10))   { did -a $dname 997 Logs all channel !commands (including !whereis so not very useful) | return }
    if ($inrect(%x,%y, 200,192, 80, 10))   { did -a $dname 997 Logs all DCC transfers in a file named " $+ $logdir $+ DCCLog_ $+ $asctime(yyyymm) $+ .log" | return }
    if ($inrect(%x,%y, 290,162,100, 18))   { did -a $dname 997 Display a reminder so you don't so easily forget to turn pserve on | return }

    return
  }
}




; ############################################## SYSTEM & GET/SEND INFO ################################################

;; Edited "Exclude drives from free status"
on *:DIALOG:PS_Dlg_AX:edit:2352: {
  var %ps = $regsub($upper($did($dname, $did).text), /[^C-Z]/g, ,%PS.whereis.drive)
}

;; Edited get/send ratio messages
on *:DIALOG:PS_Dlg_AX:edit:2354,2356,2358: {
  set %PS.whereis.sendmsg $did($dname, 2354).text
  set %PS.whereis.getmsg $did($dname, 2356).text
  set %PS.whereis.eqmsg $did($dname, 2358).text
  if (%PS.whereis.sendmsg == $null) set %PS.whereis.sendmsg .
  if (%PS.whereis.getmsg == $null) set %PS.whereis.getmsg .
  if (%PS.whereis.eqmsg == $null) set %PS.whereis.eqmsg .
}





; ########################################## PSERVE STATUS OFF NOTIFICATION ###########################################

;; Toggled "show OFF notification" setting
on *:DIALOG:PS_Dlg_AX:sclick:2381: {
  set %ps.appearance.offnotify $iif($did($dname, $did).state == 1, $true, $false)
  PSA_InitOffNotify
}

;; Start off-notify timer after update (wonder if this is really needed?)
ON *:SIGNAL:PSUPDATEDONE:{
  PSA_InitOffNotify
}

;; Start off-notify timer on start
ON *:START: {
  PSA_InitOffNotify
}

/****************************************************************************************
* Start/Clear OFF notification timer
* @param void @return void
*/
alias -l PSA_InitOffNotify {
  .timerpsoffnotify off
  if (%ps.appearance.offnotify) {
    .timerpsoffnotify -o 0 3600 /scid -a PSA_NotifyOffStatus
    scid -a PSA_NotifyOffStatus
  }
}


/****************************************************************************************
* Echo notification to channels where pserve is turned OFF.
* @param void @return void
*/
alias PSA_NotifyOffStatus {
  var %globalstatus = $PSC_GetStatus
  var %i = $chan(0)
  while (%i > 0) {
    var %chan = $chan(%i)
    var %chanstatus = $PS_Channel(%chan)
    if ((%chanstatus == OFF) || ((%globalstatus == OFF) && (%chanstatus != $null))) {
      ; Check back 40 lines so we don't spam quiet channels with endless ps-off messages
      var %j = $line(%chan,0)
      var %stop = %j - 40
      while (%j > %stop) {
        if ($line(%chan,%j) == 10PhotoServe Status: 4OFF) goto nextchan
        dec %j
      }
      echo -g %chan 10PhotoServe Status: 4OFF
    }
    :nextchan
    dec %i
  }
}



; ################################################ DEBUGING SETTINGS ##################################################

;; Show !Whereis setting
on *:DIALOG:PS_Dlg_AX:sclick:2371: {
  set %ps.debug.whereis $iif($did($dname, 2371).state == 1, $true, $false)

  ; The actual processing of %ps.debug.whereis is in the CHANNEL FILTERS section of this file
}

;; Show Extra Get Info settings
on *:DIALOG:PS_Dlg_AX:sclick:2372,2373,2374: {
  set %ps.debug.gets          $iif($did($dname, 2372).state == 1, $true, $false)
  set %ps.debug.gets_show_all $iif($did($dname, 2374).state == 1, $true, $false)
  did $iif($did($dname, 2372).state == 1, -e, -b) $dname 2373,2374

  ; The actual processing of %ps.debug.gets* is in the NICKLIST COLORS section of this file
}





; ################################################## CHANNEL FILTERS ##################################################

;; Single event handler saves all filtering settings at once
ON *:dialog:Ps_Dlg_AX:sclick:2321,2322,2323,2324,2325,2326,2327,2328,2329,2330,2331,2332,2333: {
  set %ps.appearance.hide.voice $iif($did($dname,2321).state == 1, $true, $false)
  set %ps.appearance.hide.whereis $iif($did($dname,2322).state == 1, $true, $false)
  set %ps.appearance.hide.trigger $iif($did($dname,2323).state == 1, $true, $false)
  set %ps.appearance.hide.botgreet $iif($did($dname,2324).state == 1, $true, $false)
  set %ps.appearance.hide.trignews $iif($did($dname,2325).state == 1, $true, $false)
  set %ps.appearance.hide.trigstatus $iif($did($dname,2326).state == 1, $true, $false)
  set %ps.appearance.hide.statsmaker $iif($did($dname,2327).state == 1, $true, $false)
  set %ps.appearance.hide.xferstats $iif($did($dname,2328).state == 1, $true, $false)
  set %ps.appearance.hide.bwstats $iif($did($dname,2329).state == 1, $true, $false)
  set %ps.appearance.hide.collstats $iif($did($dname,2330).state == 1, $true, $false)
  set %ps.appearance.hide.sysinfo $iif($did($dname,2331).state == 1, $true, $false)
  set %ps.appearance.hide.ipport $iif($did($dname,2332).state == 1, $true, $false)
  did $iif(%ps.appearance.hide.whereis, -b, -e) $dname 2332
  if ($did($dname,2333).state == 1) unset %ps.showwhereis
  else set %ps.showwhereis 1

  ; The actual processing of %ps.appearance.hide.voice is in the NICKLIST COLORS section of this file
}

;; Filtering of channel messages happens here
on ^*:TEXT:*:#: {
  if ($PS_Channel($chan) == $null) return
  tokenize 32 $strip($1-)

  ; test for !whereis and !stats first so it's not filtered with the %ps.appearance.hide.trigger rule
  if ($1 === !wHEREiS) {
    haltdef
    if (%ps.debug.whereis) echo $ps_n -st $chan $chr(91) $+ $nick $+ $chr(93) $1-
  }
  elseif ($1 == !whereis) {
    if (%ps.appearance.hide.whereis) {
      haltdef
    }
    elseif (%ps.appearance.hide.ipport) {
      var %re = /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\:\d{1,5}/, %stripped
      var %ps = $regsub($1-, %re, , %stripped)
      echo -t $chan < $+ $nick $+ > %stripped
      haltdef
    }
  }
  elseif ($left($1,3) == @PS) {
    haltdef
    if (%ps.debug.broadcast) echo $ps_n -st $chan $chr(91) $+ $nick $+ $chr(93) $1-
    if (($1 == @PS@INFO) && ($me isop $chan)) {
      var %win = $1 $+ _ $+ $chan
      window %win
      echo -te %win << $+ $nick $+ >>  $3-
    }
  }
  elseif (!stats.* iswm $1) {
    if (%ps.appearance.hide.statsmaker) haltdef
  }
  elseif ((%ps.appearance.hide.statsmaker) && ($1 == StatsMaker:) && ($me !isin $1-))   haltdef
  elseif ((%ps.appearance.hide.trigger)    && (!* iswm $1))   haltdef
  elseif ((%ps.appearance.hide.botgreet)   && ([*] iswm $1) && ($istok($PSF_GetChanSetting(botsname, $chan), $nick, 44)))  haltdef
  elseif ((%ps.appearance.hide.xferstats)  && ($1 == (Get/Send)))   haltdef
  elseif ((%ps.appearance.hide.trignews)   && ($1-2 == Trig News:))   haltdef
  elseif ((%ps.appearance.hide.trigstatus) && ($1-2 == Trig Status:))   haltdef
  elseif ((%ps.appearance.hide.bwstats)    && ($1-4 == Bandwidth in Use on))   haltdef
  elseif ((%ps.appearance.hide.collstats)  && ($1-2 == Collection Stats:))   haltdef
  elseif ((%ps.appearance.hide.sysinfo)    && ($3-4 == Online for:))   haltdef
  elseif ((%ps.appearance.hide.mp3spam)    && ($regex($1-, /(now playing)|(winamp)/i)))   haltdef
}





; ################################################## OPEN ON DESKTOP ##################################################

;; Open-On-Desktop settings (need reopen windows to be effective)
ON *:dialog:Ps_Dlg_AX:sclick:2341,2342,2343,2344: {
  set %ps.appearance.ondesktop.pscc $iif($did($dname,2341).state == 1, $true, $false)
  set %ps.appearance.ondesktop.triglist $iif($did($dname,2342).state == 1, $true, $false)
  set %ps.appearance.ondesktop.servinfo $iif($did($dname,2343).state == 1, $true, $false)
  set %ps.appearance.ondesktop.whereis $iif($did($dname,2344).state == 1, $true, $false)
}

;; PSCC Always On Top setting (immediate effect) (
ON *:dialog:Ps_Dlg_AX:sclick:2346: {
  if ($did($dname,$did).state == 1) {
    set %PS.dlg.ontop o 
    dialog -o $dname 
  } 
  else {
    unset %PS.dlg.ontop
    dialog -n $dname 
  }
}

/****************************************************************************************
* Return "d" if specified type of window should be opened on desktop
* @param type 'pscc', 'dialogs', 'triglist', 'servinfo', 'whereis'
* @return char either <code>d</code> or $null
*/
alias PSA_GetDesktopFlag {
  var %type = $1
  return $iif($eval(% $+ ps.appearance.ondesktop. $+ %type,2), d)
}





; #################################################### DIALOG LOOK ####################################################

;; User toggled "Show grid in listview" checkbox
ON *:dialog:Ps_Dlg_AX:sclick:2311: {
  PSA_DL_ToggleListviewGrid
}

;; User selected another listview color scheme
ON *:dialog:Ps_Dlg_AX:sclick:2312: {
  var %action = $gettok($did($dname, $did, 1), 1, 32)  
  if ((%action == item) && ($did($dname, $did,0).sel == 1)) {
    PSA_DL_SetListviewColor $gettok($did($dname, $did,0).seltext,-2,32) $gettok($did($dname, $did,0).seltext,-1,32)
  }
}

/****************************************************************************************
* Switch color of all listviews and treeviews to Textcolor and BGcolor
* @param textcolor textcolor in mirc $rgb format
* @param bgcolor background color in mirc $rgb format
* @return void
*/
alias -l PSA_DL_SetListviewColor {
  var %textcolor = $1, %bgcolor = $2

  var %i = $numtok(%ps_cc_listviews, 32)
  while (%i > 0) {
    var %id = $gettok(%ps_cc_listviews, %i, 32)
    did -i PS_DLG_AX %id 1 setbkg color %bgcolor
    did -i PS_DLG_AX %id 1 settxt bgcolor %bgcolor
    did -i PS_DLG_AX %id 1 settxt color %textcolor
    dec %i
  }

  var %i = $numtok(%ps_cc_treeviews, 32)
  while (%i > 0) {
    var %id = $gettok(%ps_cc_treeviews, %i, 32)
    did -i PS_DLG_AX %id 1 setcolor bkg %bgcolor
    did -i PS_DLG_AX %id 1 setcolor line %textcolor
    did -i PS_DLG_AX %id 1 setcolor text %textcolor
    dec %i
  }

  set %ps.appearance.dialogs.listcolor %textcolor %bgcolor
}

/****************************************************************************************
* Turn listview grids on/off. @param void @return void
*/
alias -l PSA_DL_ToggleListviewGrid {
  set %ps.appearance.dialogs.showgrid $iif(%ps.appearance.dialogs.showgrid, $false, $true)

  var %i = $numtok(%ps_cc_listviews, 32)
  while (%i > 0) {
    var %id = $gettok(%ps_cc_listviews, %i, 32)
    var %ps = $PS_Mdx(SetMDXStyle, PS_DLG_AX %id $iif(%ps.appearance.dialogs.showgrid, +grid, -grid))
    dec %i
  }  
}


; #################################################### STATSMAKER ADDON ####################################################
ON *:INPUT:*:{
  if ($left($1,7) == !stats.) {
    if ($script(StatsMakerPlugin.mrc) != $mircdir $+ PhotoServe\PSAdd-Ons\StatsMakerPlugin.mrc) {
      if ($script(StatsMakerPlugin.mrc)) unload -rs $qt($ifmatch)
      reload -rs $qt($mircdir $+ PhotoServe\PSAdd-Ons\StatsMakerPlugin.mrc)
      if ($chan) echo 3 $chan You have now a Right-Click Menu Add-On loaded for StatsMaker
    }
  }
}


; #################################################### NICKLIST COLORS ####################################################

;; User toggled the "use nicklist colors" checkbox. 
ON *:dialog:Ps_Dlg_AX:sclick:2302: {
  if ($did($dname,$did).state == 1) {
    set %ps.appearance.nickcolor.enabled $true
    PSA_NC_RecolorAll
    did -e $dname 2303,2306
  }
  else {
    set %ps.appearance.nickcolor.enabled $false
    did -b $dname 2303,2306
    PSA_NC_UncolorAll
  }
  PSA_NC_RecolorSelector
}


;; User toggled the "for non-trade channels also" checkbox. 
ON *:dialog:Ps_Dlg_Ax:sclick:2303: {
  if ($did($dname,$did).state == 1) {
    set %ps.appearance.nickcolor.nontrade $true
    PSA_NC_RecolorAll
  }
  else {
    set %ps.appearance.nickcolor.nontrade $false
    ; First remove color from everywhere, then restore on trade channels.
    PSA_NC_UncolorAll
    PSA_NC_RecolorAll
  }
}


;; User clicked "reset to defaults" button
ON *:dialog:PS_Dlg_Ax:sclick:2306: {
  set %ps.appearance.nickcolor.clist 4:13:12:10:3:7:9:5:3:3
  sline @PSA_NC_ColorSelector $line(@PSA_NC_ColorSelector,0)
  PSA_NC_RecolorSelector
  PSA_NC_RecolorAll
}


;; Menu has number 00 - 15 from which you can choose a color code for selected line
menu @PSA_NC_ColorSelector {
  $submenu($PSA_NC_SelectorSubmenu($1, $gettok($sline($menu,1),2,9)))
}


/****************************************************************************************
* Create the color selector right click menu
* @param i $1 autoincrement
* @param token %ps.appearance.nickcolor.clist index of the color being manipulated
* @return popup
*/
alias -l PSA_NC_SelectorSubmenu {
  var %i = $1, %token = $2
  if (!%ps.appearance.nickcolor.enabled) return
  if (%token == $null) return

  if (%i isnum 1-16) {
    return $iif($gettok(%ps.appearance.nickcolor.clist,%token,58) == $calc(%i - 1),$style(1)) $calc(%i - 1) $+ : PSA_NC_SetTokenColor %token $calc(%i - 1)
  }
}


/****************************************************************************************
* Change Color of %ps.appearance.nickcolor.clist Token. The change is immediately applied
* to nicklists and the PSCC color selector. @return void
*/
alias -l PSA_NC_SetTokenColor {
  var %token = $1, %color = $2

  set %ps.appearance.nickcolor.clist $puttok(%ps.appearance.nickcolor.clist,%color,%token,58)
  sline @PSA_NC_ColorSelector $line(@PSA_NC_ColorSelector,0)
  PSA_NC_RecolorSelector
  PSA_NC_RecolorAll
}


/****************************************************************************************
* Refresh all lines in the color selector @param void @return void
*/
alias -l PSA_NC_RecolorSelector {
  var %i = 1 
  while (%i < $line(@PSA_NC_ColorSelector,0)) {
    if (%ps.appearance.nickcolor.enabled) {
      .cline $gettok(%ps.appearance.nickcolor.clist,$gettok($line(@PSA_NC_ColorSelector,%i),2,9),58) @PSA_NC_ColorSelector %i
    }
    else {
      .cline $color(listbox text) @PSA_NC_ColorSelector %i
    }
    inc %i
  }
}


/****************************************************************************************
* Remove color of all nicks in all channels on all networks. @param void @return void
*/
alias -l PSA_NC_UncolorAll {
  var %i = $scon(0) 
  while (%i > 0) {
    scon %i 
    var %j = $chan(0)
    while (%j > 0) {
      var %k = $nick($chan(%j),0)
      while (%k > 0) {
        .cline $color(listbox text) $chan(%j) $nick($chan(%j), %k)
        dec %k
      }
      dec %j
    }
    dec %i
  }
  scon -r
}


/****************************************************************************************
* Refresh color of all nicks in all channels on all networks. Slow but only needed when
* user changes some part of his nick color settings. @param void @return void
*/
alias -l PSA_NC_RecolorAll {
  var %i = $scon(0) 
  while (%i > 0) {
    scon %i 
    var %j = $chan(0)
    while (%j > 0) {
      $PSA_NC_RecolorChan($chan(%j))
      dec %j
    }
    dec %i
  }
  scon -r
}


/****************************************************************************************
* Refresh color of all nicks in Chan. @return void
*/
alias -l PSA_NC_RecolorChan {
  var %chan = $1

  if (!%ps.appearance.nickcolor.enabled) return
  if ($PS_Channel(%chan) == $null) {
    if (!%ps.appearance.nickcolor.nontrade) return
    var %i = $nick(%chan,0)
    while (%i > 0) {
      $PSA_NC_RecolorNickNonPServe($nick(%chan, %i), %chan)
      dec %i
    }
  }
  else {
    var %i = $nick(%chan,0)
    while (%i > 0) {
      $PSA_NC_RecolorNickPServe($nick(%chan, %i), %chan)
      dec %i
    }
  }
}


/****************************************************************************************
* Refresh color of Nick in Chan. If Chan is not specified finds common channels
* and refreshes them all. @optparam chan @return void
*/
alias PSA_NC_RecolorNick {
  var %nick = $1, %chan = $2

  if (!%ps.appearance.nickcolor.enabled) return
  if (%chan != $null) {
    if ($PS_Channel(%chan) != $null)           $PSA_NC_RecolorNickPServe(%nick, %chan)
    elseif (%ps.appearance.nickcolor.nontrade) $PSA_NC_RecolorNickNonPServe(%nick, %chan)
  }
  else {
    var %i = $comchan(%nick,0)
    while (%i > 0) {
      var %chan = $comchan(%nick, %i)
      if ($PS_Channel(%chan) != $null)           $PSA_NC_RecolorNickPServe(%nick, %chan)
      elseif (%ps.appearance.nickcolor.nontrade) $PSA_NC_RecolorNickNonPServe(%nick, %chan)
      dec %i
    }
  }
}


/****************************************************************************************
* Refresh color of Nick in pserve-using Chan. @return void
*/
alias -l PSA_NC_RecolorNickPServe {
  var %nick = $1, %chan = $2

  var %leechstatus = $PSL_GetNickStatus(%nick, %chan)
  var %bots = $PSF_GetChanSetting(botsname,%chan)

  if (%nick == $me) {
    .cline $gettok(%ps.appearance.nickcolor.clist,1,58) %chan %nick 
  }
  elseif (($send(%nick,0) > 0) && ($PS_NetWork_send(PS_NickListColor,%nick,1,.status) isin 'active'waiting')) {
    .cline $gettok(%ps.appearance.nickcolor.clist,8,58) %chan %nick
  }
  elseif (($get(%nick,0) > 0) && ($PS_NetWork_get(PS_NickListColor,%nick,1,.status) isin 'active'waiting')) {
    .cline $gettok(%ps.appearance.nickcolor.clist,7,58) %chan %nick
  }
  elseif ((%bots != $null) && ($istok(%bots,%nick,44))) {
    .cline $gettok(%ps.appearance.nickcolor.clist,2,58) %chan %nick
  }
  elseif (%leechstatus == LEECH) {
    .cline $gettok(%ps.appearance.nickcolor.clist,9,58) %chan %nick
  }
  elseif (%leechstatus == BLOCKED) {
    .cline $gettok(%ps.appearance.nickcolor.clist,10,58) %chan %nick
  }
  elseif (%nick isop %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,3,58) %chan %nick
  }
  elseif (%nick ishop %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,4,58) %chan %nick
  }
  elseif (%nick isvoice %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,5,58) %chan %nick
  }
  else {
    .cline $gettok(%ps.appearance.nickcolor.clist,6,58) %chan %nick
  }
}


/****************************************************************************************
* Refresh color of Nick in non-pserve-using Chan. This version is four times faster than
* the pserve-chan version, which makes a real difference in the time needed for the
* initial coloring when a user joins a huge (1000+ users) channel with a slow CPU.
* @return void
*/
alias -l PSA_NC_RecolorNickNonPServe {
  var %nick = $1, %chan = $2

  if (%nick == $me) {
    .cline $gettok(%ps.appearance.nickcolor.clist,1,58) %chan %nick 
  }
  elseif (($send(%nick,0) > 0) && ($PS_NetWork_send(PS_NickListColor,%nick,1,.status) isin 'active'waiting')) {
    .cline $gettok(%ps.appearance.nickcolor.clist,8,58) %chan %nick
  }
  elseif (($get(%nick,0) > 0) && ($PS_NetWork_get(PS_NickListColor,%nick,1,.status) isin 'active'waiting')) {
    .cline $gettok(%ps.appearance.nickcolor.clist,7,58) %chan %nick
  }
  elseif (%nick isop %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,3,58) %chan %nick
  }
  elseif (%nick ishop %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,4,58) %chan %nick
  }
  elseif (%nick isvoice %chan) {
    .cline $gettok(%ps.appearance.nickcolor.clist,5,58) %chan %nick
  }
  else {
    .cline $gettok(%ps.appearance.nickcolor.clist,6,58) %chan %nick
  }
}


on *:SIGNAL:PSE_SENDSTART: { 
  var %nick = $1
  if (!%ps.appearance.nickcolor.enabled) return
  var %i = $comchan(%nick,0)
  while (%i > 0) {
    var %chan = $comchan(%nick, %i)
    if ((%ps.appearance.nickcolor.nontrade) || ($PS_Channel(%chan) != $null)) {
      .cline $gettok(%ps.appearance.nickcolor.clist,8,58) %chan %nick
    }
    dec %i
  }
}


on *:SIGNAL:PSE_SENDEND: { 
  var %nick = $1
  if (!%ps.appearance.nickcolor.enabled) return
  PSA_NC_RecolorNick %nick
}


on ^*:VOICE:#: {
  $PSA_NC_RecolorNick($vnick, $chan)
  if ((%ps.appearance.hide.voice) && ($PS_Channel($chan) != $null)) haltdef
}


ctcp *:DCC SEND*:?:{
  ; $get(...).status will return $null if called in the ctcp-handler, must use a timer
  .timer -m 1 10 PSA_NC_RecolorNick $nick

  if (%ps.debug.gets) {
    if ((%ps.debug.gets_show_all) || (TriggerList* iswm $3))  {
      if ($0 == 6) {
        echo 2 -st $chr(91) $+ $nick $+ $chr(93) $1-3 12 $+ $longip($4) $+ : $+ $5  $+ $6- 7(Normal DCC)
      }
      elseif (($0 == 7) && ($4 == 4294967295) && ($5 == 0)) {
        ; Passive DCCs seem to always use IP 255.255.255.255
        echo 3 -st $chr(91) $+ $nick $+ $chr(93) $1-3 12 $+ $longip($4) $+ : $+ $5  $+ $6- 07(Passive DCC)
      }
      elseif (($0 == 7) && ($5 == 0)) {
        ; Proxy DCCs seem to use IP 127.0.0.1 OR whatever mirc thinks is your $ip
        echo 3 -st $chr(91) $+ $nick $+ $chr(93) $1-3 12 $+ $longip($4) $+ : $+ $5  $+ $6- 07(Socks5 DCC)
      }
      elseif ($0 == 7) {
        ; The other user is accepting _your_ passive/proxy dcc - no message
      }
      else {
        echo 4 -st $chr(91) $+ $nick $+ $chr(93) $1- 07(Invalid. Usually faulty proxy)
      }
    }
  }
  ;  echo -s .. $1-
}


on *:DCCSERVER:Send:{
  ; The DCC server event can trigger in any random network context so /scid -a
  .timer -m 1 10 scid -a PSA_NC_RecolorNick $nick 

  if (%ps.debug.gets) {
    if ((%ps.debug.gets_show_all) || (TriggerList* iswm $3))  {
      echo 2 -st $chr(91) $+ $nick $+ $chr(93) $address Sending $nopath($filename) 7(DCC Server) $1-
    }
  }
}


; Get/Send dialog cannot track nick changes correctly when DCC Server connection is used. This solution means
; the nick will lose its color even while the send is still ongoing, but alternative would be to not lose it at all:
on *:NICK: { PSA_NC_RecolorNick $newnick }

on *:SIGNAL:psFilterChanged:{ PSA_NC_RecolorChan $1       }
on *:SENDFAIL:*:{     scid -a PSA_NC_RecolorNick $nick    }
on *:GETFAIL:*:{      scid -a PSA_NC_RecolorNick $nick    }
on *:FILESENT:*:{     scid -a PSA_NC_RecolorNick $nick    }
on *:FILERCVD:*:{     scid -a PSA_NC_RecolorNick $nick    }
on *:OP:#:{           $PSA_NC_RecolorNick($opnick, $chan) }
on *:SERVEROP:#:{     $PSA_NC_RecolorNick($opnick, $chan) }
on *:DEOP:#:{         $PSA_NC_RecolorNick($opnick, $chan) }
on *:DEVOICE:#:{      $PSA_NC_RecolorNick($vnick, $chan)  }
on *:HELP:#:{         $PSA_NC_RecolorNick($hnick, $chan)  }
on *:DEHELP:#:{       $PSA_NC_RecolorNick($hnick, $chan)  }
on !*:JOIN:*: {       $PSA_NC_RecolorNick($nick, $chan)   }
; Full coloring is done twice because sometimes it can take 15+ seconds before the server has sent full userlist:
on me:*:JOIN:#: {     .timer 1 2 PSA_NC_RecolorChan $chan | .timer 1 $rand(30,60) PSA_NC_RecolorChan $chan }


on ^$*:NOTICE:/\B(\#\S+)/S:*:{
  var %chan = $regml(1)
  if ($chan) %chan = $chan
  if (%chan ischan) {
    echo $color(notice) -t %chan - $+ $nick $+ - $1-
    haltdef
  }
}
