
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>PSBO - PhotoServe Batch Operations</b>
* <p>
* Operations that perform some task for a large amount of triggers and display the
* results in a window. The GUI is same for these two task that it makes sense to
* combine them in single PSCC tab. More similar tasks can also be added.
* <p>
* <b>CSV-Check</b> downloads complete list CSVs from selected CSV-repository and
* validates CSVs of all configured triggers against that list.
* <p>
* <b>Collection Advisor</b> lists all configured triggers and their StatsMaker ratings
* to help users decide what to turn on/off. 
*/




/****************************************************************************************
* Init MDX components @param void @return void
*/
alias PSCC_CreateTab1800 {
  var %dname = $1  
  did -r %dname 1804

  var %ps = $PS_MDX(SetControlMDX, 1807 window > [ $PS_ddll ] )
  window -lh @PSBO_PlaceHolder Tahoma 12
  did -a %dname 1807 grab $window(@PSBO_PlaceHolder).hwnd @PSBO_PlaceHolder
  var %ps = $PS_MDX(SetBorderStyle,1807 staticedge)

  var %ps = $PS_Mdx(SetControlMDX, 1805 progressbar smooth > [ $PS_gdll ] )
  did -a %dname 1805 0 0 200
}

/****************************************************************************************
* Populate the function combobox @param void @return void
*/
alias PSCC_PopulateTab1800 {
  var %dname = $1

  var %i = $hget(0)
  while (%i > 0) {
    var %hname = $hget(%i)
    if (PsFilters_* iswm %hname) {
      var %chan = $right(%hname, -10)
      if ($PSF_GetChanSetting(StatsUrl, %chan) != $null) { 
        did -a %dname 1802 Adv: $lower(%chan)
      }
    }
    dec %i
  }

  var %repositories = $PSCSV_GetActiveRepositories
  while (%repositories != $null) {
    var %repository = $gettok(%repositories, 1, 32)
    %repositories = $deltok(%repositories, 1, 32)
    did -a %dname 1802 Csv: $PSCSV_GetRepositryInfo(%repository, name)
    dec %i
  }
}


/****************************************************************************************
* Dialog resize
*/
alias PSCC_ResizeTab1800 {
  var %w = $1, %h = $2, %dname = $3
  PS_Mdx MoveControl %dname 1801 * * $calc(%w - 19) $calc(%h - 50)
  PS_Mdx MoveControl %dname 1805 * * $calc(%w - 335) *
  PS_Mdx MoveControl %dname 1806 $calc(%w - 101) * * *
  if ($did(%dname,1806).text == Show Help) {
    PS_Mdx MoveControl %dname 1807 * 94 $calc(%w - 40) $calc(%h - 110)
  }
  else {
    PS_Mdx MoveControl %dname 1807 * 244 $calc(%w - 40) $calc(%h - 260)
  }
}



;; Free all resources on dialog close.
on *:DIALOG:PS_Dlg_AX:close:*:{
  PSBO_CC_Kill
  PSBO_CA_Kill
  window -c @PSBO_PlaceHolder
}











;; Combobox selection
on *:DIALOG:PS_Dlg_AX:sclick:1802:{
  did -e $dname 1803
}


;; Start/Clear button
on *:DIALOG:PS_Dlg_AX:sclick:1803:{
  if ($did($did).text == Start) {
    did -b $dname 1802
    did -ra $dname $did Clear
    did -va $dname 1805 0 0 100
    window -c @PSBO_PlaceHolder

    var %action = $gettok($did($dname,1802).text, 1, 32)
    if (%action == Csv:) {
      set %ps_batch_cc_repname $gettok($did($dname,1802).text, 2-, 32))
      set %ps_batch_cc_repid $PSCSV_GetRepositoryByName(%ps_batch_cc_repname)
      set %ps_batch_cc_repurl $PSCSV_GetRepositryInfo(%ps_batch_cc_repid, csvlisturl)
      PSBO_CC_Start
    }
    elseif (%action == Adv:) {
      set %ps_batch_ca_chan $gettok($did($dname,1802).text, 2, 32)
      PSBO_CA_Start 
    }
  }
  else {
    PSBO_CC_Kill
    PSBO_CA_Kill
    did -ra $dname $did Start
    did -h $dname 1805
    did -r $dname 1804
    did -e $dname 1802
    window -lh @PSBO_PlaceHolder Tahoma 12
    did -a $dname 1807 grab $window(@PSBO_PlaceHolder).hwnd @PSBO_PlaceHolder
    var %ps = $PS_MDX(SetBorderStyle, 1807 staticedge)
  }
}


;; Show/Hide Help button.
on *:DIALOG:PS_Dlg_AX:sclick:1806:{
  if ($did($dname,$did).text == Show Help) {
    did -ra $dname $did Hide Help
    did -v $dname 1811,1812,1813,1814,1815,1816
  }
  else {
    did -ra $dname $did Show Help
    did -h $dname 1811,1812,1813,1814,1815,1816
  }
  $PSCC_ResizeTab1800($dialog($dname).cw, $dialog($dname).ch, $dname)
}








; ############################################ CSV CHECK ############################################


/****************************************************************************************
* Stops all activity and frees all resources used by CsvCheck. After calling this alias
* it is guaranteed that no events fire and no aliases are called via timer. @param void
* @return void
*/
alias -l PSBO_CC_Kill {
  window -c @PSBOCC
  http_close PSBOCC
  hfree -w PSBOCC
  .disable #PSBOCC_psCollectionChanged
  $PSTC_Iteration(PSBO).stop
  .timerPSBO_CC_WaitProgress off
}


/****************************************************************************************
* Starts the Csv Check process. @param void @return void
*/
alias -l PSBO_CC_Start {
  if ($eval(% $+ ps.batch.cc.files. $+ %ps_batch_cc_repid, 2) == $null) set % [ $+ ps.batch.cc.files. $+ [ %ps_batch_cc_repid ] ] 10000

  window -lhs -t20,27,34,55 @PSBOCC Tahoma 12
  did -a PS_Dlg_AX 1807 grab $window(@PSBOCC).hwnd @PSBOCC
  var %ps = $PS_MDX(SetBorderStyle, 1807 staticedge)

  did -ra PS_Dlg_AX 1804 (Step 1 / 3) Contacting server...
  did -a PS_Dlg_AX 1805 1 0 200

  hmake PSBOCC 5000
  http_get PSBOCC %ps_batch_cc_repurl
  PSBO_CC_WaitServerReply 1
}


/****************************************************************************************
* Updates the progressbar while waiting for response from server. This is needed to give
* users feedback that something is happening, that the system didn't freeze.
* @param step number 1..120, determines progressbar length @return void
*/
alias -l PSBO_CC_WaitServerReply {
  var %step = $1
  if ($window(@PSBOCC) == $null) return
  did -a PS_Dlg_AX 1805 %step 0 120
  .timerPSBO_CC_WaitProgress -m 1 500 PSBO_CC_WaitServerReply $calc(%step + 1)
}


/****************************************************************************************
* LibHTTP signaled an error
*/
on *:signal:HttpErr_PSBOCC: {
  var %errormsg = $1-

  did -ra PS_Dlg_AX 1804 ERROR: Unable to download CSV list, try again later
  echo $ps_n -st --> CSV List download failed: $ps_kh $+ %errormsg
  .timerPSBO_CC_WaitProgress off
}


/****************************************************************************************
* Read list from socket and add the data to hash table
*/
on *:sockread:PSBOCC: {
  if ($sockerr) { did -ra PS_Dlg_AX 1804 ERROR: Unable to download CSV list, try again later | return }
  did -ra PS_Dlg_AX 1804 (Step 2 / 3) Downloading CSV list...
  .timerPSBO_CC_WaitProgress off

  :nextread
  var %sockinput
  sockread %sockinput
  if (%sockinput == $null) return
  hadd -m PSBOCC $gettok(%sockinput,1,44) %sockinput
  did -a PS_Dlg_AX 1805 $hget(PSBOCC,0).item 1 $eval(% $+ ps.batch.cc.files. $+ %ps_batch_cc_repid, 2)
  goto nextread
}



/****************************************************************************************
* Begin validation after the list has finished downloading.
*/
on *:sockclose:PSBOCC: {
  if ($sockerr) { did -ra PS_Dlg_AX 1804 ERROR: Unable to download CSV list, try again later | return }
  .timerPSBO_CC_WaitProgress off

  set % [ $+ ps.batch.cc.files. $+ [ %ps_batch_cc_repid ] ] $hget(PSBOCC,0).item

  did -a PS_Dlg_AX 1805 1 0 200
  did -ra PS_Dlg_AX 1804 (Step 3 / 3) Validating CSVs...
  aline @PSBOCC $+(!Name,$chr(9),Trig,$chr(9),Result,$chr(9),Local CSV,$chr(9),Site CSV)
  .enable #PSBOCC_psCollectionChanged
  PSTC_IterateAllTrigs PSBO async PSBO_CC_ProcessTrig
}


/****************************************************************************************
* Generate and add line for Trig in the result window. @return void
*/
alias PSBO_CC_ProcessTrig {
  var %trig = $1

  if (($PSTC_GetPath(%trig) != $null) && ($PSTC_GetType(%trig) != custom)) {
    aline @PSBOCC $PSBO_CC_MakeLine(%trig)
  }

  var %percent = $PSTC_Iteration(PSBO).pc
  did -a ps_dlg_ax 1805 %percent 1 100
  if (%percent == 100) {
    did -h PS_Dlg_AX 1805
    did -ra PS_Dlg_AX 1804 Validation complete. Double click / Right click on a line to update.
    window -b @PSBOCC
  }
}


/****************************************************************************************
* Returns result window line for Trig.
* @return string result line
*/
alias -l PSBO_CC_MakeLine {
  var %trig = $1 

  var %name = $PSTC_GetName(%trig)
  var %csv = $PSTC_GetCSV(%trig)
  var %csvfile = $nopath(%csv)
  var %etfile = $gettok($hget(PSBOCC,%trig),3-,44)
  var %etcrc = $gettok($hget(PSBOCC,%trig),2,44)
  %etcrc = $str(0,$calc(8 - $len(%etcrc))) $+ %etcrc

  if (%csv == $null) {
    if (%etfile == $null)             return $+(%name, $chr(9), %trig, $chr(9), 04CSV Missing  , $chr(9), 04, -       , $chr(9), 07, CSV Not on site)
    else                              return $+(%name, $chr(9), %trig, $chr(9), 04CSV Missing  , $chr(9), 04, -       , $chr(9), 03, %etfile)
  }
  else {
    if (%etfile == $null)             return $+(%name, $chr(9), %trig, $chr(9), 03Inconclusive , $chr(9), 03, %csvfile, $chr(9), 07, CSV Not on site)
    elseif (%etcrc != $PS_Crc(%csv))  return $+(%name, $chr(9), %trig, $chr(9), 04CRC Mismatch , $chr(9), 04, %csvfile, $chr(9), 03, %etfile)
    elseif (%etfile != $nopath(%csv)) return $+(%name, $chr(9), %trig, $chr(9), 04Name Mismatch, $chr(9), 04, %csvfile, $chr(9), 03, %etfile)
    else                              return $+(%name, $chr(9), %trig, $chr(9), 03OK           , $chr(9), 03, %csvfile, $chr(9), 03, %etfile)
  }
}



/****************************************************************************************
* Update line in result window when trigger's CSV changes.
*/
#PSBOCC_psCollectionChanged off
on *:SIGNAL:psCollectionChanged: {
  var %trig = $1, %setting = $2

  if ($window(@PSBOCC) == $null) {
    .disable #PSBOCC_psCollectionChanged
  } 
  elseif (%setting == csv) {
    var %lineindex = $line(@PSBOCC,0)
    while (%lineindex > 1) {
      if ($gettok($line(@PSBOCC,%lineindex),2,9) == %trig) {
        rline @PSBOCC %lineindex $PSBO_CC_MakeLine(%trig)
        return
      }
      dec %lineindex
    }
  }
}
#PSBOCC_psCollectionChanged end




menu @PSBOCC {
  lbclick: {
    if ($sline($menu,1).ln == 1) return
    var %newline = $PSBO_CC_MakeLine($gettok($sline($menu,1),2,9))
    var %oldline = $sline($menu,1)
    if (%newline != %oldline) rline $menu $1 %newline
  }
  dclick: {
    if ($sline($menu,1).ln == 1) return
    PSCSV_LookupTrig $gettok($sline($menu,1),2,9) %ps_batch_cc_repid
  }
  $iif($sline($menu,1).ln == 1,$style(2)) Online Lookup: {
    PSCSV_LookupTrig $gettok($sline($menu,1),2,9) %ps_batch_cc_repid
  }
  $iif($sline($menu,1).ln == 1,$style(2)) Configure: {
    PSTC_ConfigureAll $gettok($sline($menu,1),2,9) 
  }
  -
  Hide "OK" results {
    var %lineindex = $line($menu,0)
    while (%lineindex > 1) {
      if (03OK $+ $chr(9) isin $line($menu,%lineindex)) .dline $menu %lineindex
      dec %lineindex
    }
  }
  -
  Fix ALL name mismatches: {
    var %lineindex = $line($menu,0)
    while (%lineindex > 1) {
      if ($gettok($line($menu,%lineindex),3,9) == 04Name Mismatch) {
        var %trig = $gettok($line($menu,%lineindex),2,9)
        var %old_csv = $PSTC_GetCSV(%trig)
        var %new_csv = $nofile(%old_csv) $+ $gettok($hget(PSBOCC,%trig),3-,44)
        if (!$isfile(%new_csv)) .rename " $+ %old_csv $+ " " $+ %new_csv $+ "
        $PSTC_SetCSV(%trig, %new_csv)
      }
      dec %lineindex
    }
  }
}




; ####################################### COLLECTION ADVISOR ######################################


/****************************************************************************************
* Starts the Advice process. @param void @return void
*/
alias -l PSBO_CA_Start {
  var %url = $PSF_GetChanSetting(StatsUrl,%ps_batch_ca_chan )

  window -lh -t20,27,33,38,100 @PSBOCA Tahoma 12
  did -a PS_Dlg_AX 1807 grab $window(@PSBOCA).hwnd @PSBOCA
  var %ps = $PS_MDX(SetBorderStyle, 1807 staticedge)

  if ($regex(%url,/^.+\/([^\/\\]+)$/)) {
    set %ps_batch_ca_tempfile $PS_TmpDir $+ $regml(1) $+ "
    if ($isfile(%ps_batch_ca_tempfile)) .remove %ps_batch_ca_tempfile
  }
  else {
    did -rav PS_Dlg_AX 1804 ERROR: Unable extract filename from StatsUrl
    return
  }

  http_get PSBOCA %url
  did -ra PS_Dlg_AX 1804 (Step 1 / 3) Downloading latest StatsMaker file...
  did -a PS_Dlg_AX 1805 1 0 200
}

/****************************************************************************************
* Stops all activity and frees all resources used by Advisor. After calling this alias
* it is guaranteed that no events fire and no aliases are called via timer. @param void
* @return void
*/
alias -l PSBO_CA_Kill {
  window -c @PSBOCA
  hfree -w PSBOCA
  if ($fopen(PSBOCA)) .fclose PSBOCA
  if ($isfile(%ps_batch_ca_tempfile)) .remove %ps_batch_ca_tempfile
  unset %ps_batch_ca_tempfile
  http_close PSBOCA
  .disable #PSBOCA_psCollectionChanged
  $PSTC_Iteration(PSBO).stop
  .timerPSBOCA off
}


/****************************************************************************************
* LibHTTP signaled error, most likely Unable to connect.
*/
on *:signal:HttpErr_PSBOCA {
  did -ra PS_Dlg_AX 1804 ERROR: Unable to download StatsMaker file, try again later
  echo $ps_n -st --> StatsMaker file download failed: $ps_kh $+ $1-
}


/****************************************************************************************
* Read StatsMaker ratings file from socket
*/
on 1:sockread:PSBOCA: {
  if ($sockerr) { did -ra PS_Dlg_AX 1804 ERROR: Unable to download StatsMaker file, try again later | return }

  sockread -f &sockinput
  bwrite %ps_batch_ca_tempfile -1 -1 &sockinput
  did -a PS_Dlg_AX 1805 $httpsock($sockname).percent 1 100
}


/****************************************************************************************
* Done downloading ratings file, start processing.
*/
on 1:sockclose:PSBOCA: {
  if ($sockerr) { did -ra PS_Dlg_AX 1804 ERROR: Unable to download StatsMaker file, try again later | return }

  did -ra PS_Dlg_AX 1804 (Step 2 / 3) Reading file...
  .timerPSBOCA -m 1 100 PSBO_CA_LoadFile
}


/****************************************************************************************
* Decompress (if needed) and load received ratings file. @param void @return void
*/
alias -l PSBO_CA_LoadFile {
  var %rfile = $PS_Decompress(keep,%ps_batch_ca_tempfile)
  hmake PSBOCA
  .fopen PSBOCA %rfile
  while (!$feof && !$ferr) {
    var %line = $fread(PSBOCA)
    hadd PSBOCA $gettok(%line,1,9) $int($calc($gettok(%line,2,9) * 100000))
  }
  .fclose PSBOCA

  if ($isfile(%ps_batch_ca_tempfile)) .remove %ps_batch_ca_tempfile
  if ($isfile(%rfile)) .remove %rfile

  did -ra PS_Dlg_AX 1804 (Step 3 / 3) Processing triggers...
  aline @PSBOCA $+(Group,$chr(9),Trig,$chr(9),Backup ID,$chr(9),Value,$chr(9),Path,$chr(9))
  window -b @PSBOCA
  .timerPSBOCA -m 1 100 PSBO_CA_ProcessTrigs
}


/****************************************************************************************
* Call pserve.exe to process triggers and display results. Pserve.exe expects to find the
* trigger valuation file in \Photoserve\Temp\Advice.hsh, and it writes the results in
* \Photoserve\Temp\Advice.on/off. @param void @return void
*/
alias -l PSBO_CA_ProcessTrigs {
  hsave -o PSBOCA $PS_TmpDir $+ Advice.hsh"
  var %result = $PS_RunPserveExeSync(GetAdvice, %ps_batch_ca_chan )
  loadbuf -c5 @PSBOCA $PS_TmpDir $+ Advice.off"
  loadbuf -c3 @PSBOCA $PS_TmpDir $+ Advice.on"
  did -h Ps_Dlg_Ax 1805
  did -ra Ps_dlg_Ax 1804 All done. Right click on a line to modify trigger setup.
  .timerPSBOCA -m 1 100 PSBO_CA_SortWindow 4

  .enable #PSBOCA_psCollectionChanged
  if ($isfile($PS_TmpDir $+ Advice.hsh")) .remove $PS_TmpDir $+ Advice.hsh"
  if ($isfile($PS_TmpDir $+ Advice.off")) .remove $PS_TmpDir $+ Advice.off"
  if ($isfile($PS_TmpDir $+ Advice.on")) .remove $PS_TmpDir $+ Advice.on"
  unset %ps_batch_ca_*
}


/****************************************************************************************
* Mircscript version of PSBO_CA_ProcessTrigs (not used). @param void @return void
*/
alias -l PSBO_CA_ProcessTrigs_mircscript {
  did -ra PS_Dlg_AX 1804 Processing triggers (the list will sort after processing completes)...
  PSTC_IterateAllTrigs PSBO async PSBO_CA_ProcessTrig_mircscript
  .enable #psAdvice_psCollectionChanged
}


/****************************************************************************************
* Generate and add line for Trig in the result window. Part of the mircscript-only
* codepath for advisor. @return void
*/
alias PSBO_CA_ProcessTrig_mircscript {
  var %trig = $1

  if ($PSF_TrigIsAllowed(%trig, %ps_batch_ca_chan )) {
    var %line = $PSBO_CA_MakeLine(%trig)
    if (%line != $null) {  
      aline $iif($PSTC_GetStatus(%trig) == OFF,5,3) @PSBOCA %line
    }
  }

  var %percent = $PSTC_Iteration(PSBO).pc
  did -a Ps_dlg_Ax 1805 %percent 1 100
  if (%percent == 100) {
    did -h Ps_Dlg_Ax 1805
    did -ra Ps_dlg_Ax 1804 All done. Right click on a line to modify trigger setup.
    PSBO_CA_SortWindow 4
    unset %ps_batch_ca_*
  }
}


/****************************************************************************************
* Generate and return result line for Trig. @return string result line or $null if Trig
* in not configured/final
*/
alias -l PSBO_CA_MakeLine {
  var %trig = $1

  var %path = $lower($PSTC_GetPath(%trig))
  if (%path == $null) return

  var %count = $PSTC_GetCount(%trig)
  var %csvcount = $PSTC_GetCSVCount(%trig)
  if (%count != %csvcount) return

  if ($PSTC_GetCSVType(%trig) !isin FR) return
  if ($PSTC_GetMandatoryOnlineTime(%trig) > 0) return

  var %groupname = $PSTC_GetGroupName($PSTC_GetGroup(%trig))
  var %cd = $PSTC_GetCD(%trig)
  var %status = $PSTC_GetStatus(%trig)

  if ($hget(PSBOCA,%trig) == $null) hadd PSBOCA %trig -

  return $+(%groupname,$chr(9),%trig,$chr(9),%cd $+ $chr(32),$chr(9),$hget(PSBOCA,%trig),$chr(9),%path,$chr(9),%status)
}


/****************************************************************************************
* Update line in result window when trigger's state changes.
*/
#PSBOCA_psCollectionChanged off
on *:SIGNAL:psCollectionChanged: {
  var %trig = $1, %setting = $2

  if ($window(@PSBOCA) == $null) {
    .disable #PSBOCA_psCollectionChanged
  } 
  elseif ($istok(path status cd, %setting, 32)) {
    var %lineindex = $line(@PSBOCA,0)
    while (%lineindex > 1) {
      if ($gettok($line(@PSBOCA,%lineindex),2,9) == %trig) {
        rline $iif($PSTC_GetStatus(%trig) == OFF,5,3) @PSBOCA %lineindex $PSBO_CA_MakeLine(%trig)
        return
      }
      dec %lineindex
    }
  }
}
#PSBOCA_psCollectionChanged end


/****************************************************************************************
* Sort results window based on ColNum.
* @param colnum Column number (beginning at 1) @return void
*/ 
alias -l PSBO_CA_SortWindow {
  var %colnum = $1

  window -lh -t20,27,33,38,100 @PSBOCA_Sort Tahoma 12
  aline @PSBOCA_Sort $+(Group,$chr(9),Trig,$chr(9),Backup ID,$chr(9),Value,$chr(9),Path,$chr(9))

  if (%colnum == 4) {
    filter -zeutr 2-99999 %colnum 9 @PSBOCA @PSBOCA_Sort
  }
  else {
    filter -ztr 2-99999 %colnum 9 @PSBOCA @PSBOCA_Sort
  }

  window -c @PSBOCA
  renwin @PSBOCA_Sort @PSBOCA
  window -b @PSBOCA
  did -a PS_Dlg_AX 1807 grab $window(@PSBOCA).hwnd @PSBOCA
  ; SetBorderStyle fails if the dialog isn't active (sounds like bug in MDX)
  dialog -v PS_DLG_AX
  var %ps = $PS_MDX(SetBorderStyle, 1807 staticedge)
}



menu @PSBOCA {
  lbclick: {
    if ($sline($menu,1).ln == 1) return
    var %newline = $PSBO_CA_MakeLine($gettok($sline($menu,1),2,9))
    var %oldline = $sline($menu,1)
    if (%newline != %oldline) rline $iif($PSTC_GetStatus($gettok($sline($menu,1),2,9)) == OFF,5,3) $menu $1 %newline
  }
  dclick: {
    if ($sline($menu,1).ln == 1) return
    PSTC_ConfigureAll $gettok($sline($menu,1),2,9)
  }

  Sort List By
  .Group: PSBO_CA_SortWindow 1
  .Trig: PSBO_CA_SortWindow 2
  .Backup ID: PSBO_CA_SortWindow 3
  .Value: PSBO_CA_SortWindow 4
  .Path: PSBO_CA_SortWindow 5
  .Status: PSBO_CA_SortWindow 6
  -
  Show Info
  .$style(2) These are not commands, they only display data: noop
  .Name -- $PSTC_GetName($gettok($1-,2,9)): noop
  .Count -- $PSTC_GetCount($gettok($1-,2,9)): noop
  .Sends -- $PSTC_GetSendCount($gettok($1-,2,9)): noop
  -
  Turn $iif($gettok($1-,6,9) == OFF,ON,OFF) : $PSTC_SetStatus($gettok($1-,2,9), $iif($gettok($1-,6,9) == OFF,ON,OFF))
  Configure: $PSTC_ConfigureAll($gettok($1-,2,9))
  Explore: run explorer.exe /n, /e,  " $+ $gettok($1-,5,9) $+ "
}







; ########################## Misc crap I needed to dump somewhere ###################################

;; Generates HTML documentation for pserve. @param void @return void
alias mdoc {
  $PS_RunPserveExeAsync(mdoc)
}
