
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####




; ##### This part handles the configured GLOBAL/NETWORK-SPECIFIC settings, like sends, queues ... 

;; Returns wheater Random Ports are enabled in Mirc Config
;; @return Boolean  
alias PSC_GetPortSetting {
  return $iif($readini(mirc.ini,n,Ports,Random) == on,$true,$false)
}

;; returns the speed factor of the system 
alias PSC_SF {
  if (%ps.speedfactor) if (%ps.speedfactor isnum 0.1-10) return %ps.speedfactor
  return 2
}

;; return the currently configured user trigger @return String
alias PSC_GetMyTrigger {
  return %PS.trigger
}

;; return the current status of PhotoServe @return String is either ON or OFF 
alias PSC_GetStatus {
  return $iif($PS_SetStatus(PSC_GetStatus,Get) != ON,OFF,ON)
}

;; returns $true if PhotoServe is turned on for Channel, $false if not
alias PSC_isPSonInChannel {
  var %channel = $1
  var %ps_channelfile = $PS_ChannelsFile(PS_Channel)
  if (!$file(%ps_channelfile)) return $false
  var %s = $readini(%ps_channelfile,n,%channel,#status)
  if (%s == ON) return $true
  return $false
}

;; returns $true if the Channel is configured regardless of on/off state, $false if not
alias PSC_ValidChannel {
  var %channel = $1
  var %ps_channelfile = $PS_ChannelsFile(PS_Channel)
  if (!$file(%ps_channelfile)) return $false
  return $true
}

;; set the status of global PhotoServe in this Network @param onoff is either the string ON or OFF (defaults to ON) @param reason the reason to be shown 
alias PSC_SetStatus {
  var %onoff = $1 , %reason = $2 
  if (%onoff !== OFF) %onoff = ON
  noop $PS_SetStatus(PSC_SetStatus,%onoff,Auto,%reason)
}

;; returns the currently configured maximum possible sends configured @return Int
alias PSC_GetMaxSends {
  return $PS_SetSendTotal(PSC*)
}

;; returns the currently configured maximum possible queues configured @return Int
alias PSC_GetMaxQueues {
  return $PS_SetQueueTotal(PSC*)
}
;; returns the currently configured maximum per user setting of configured queues @return Int
alias PSC_GetMaxQueuesPerUser {
  return $ps_setqueuelimit(PSC*)
}

;; returns the currently configured maximum per user setting of configured sends @return Int
alias PSC_GetMaxSendsPerUser {
  return $PS_SetSendLimit(PSC*)
}

;; the currently configured Speed Setting @return String
alias PSC_GetSpeed {
  return $PS_Speed(PSC*)
}

;; check if exclusive serving a collection atm, returns if collection is free @return Boolean if collection is free to leech
alias PSC_isFreeOfExclusiveServe {
  var %trigger = $1
  if ((%ps_servonlytime != $null) && (%ps_servonlytrig != $null)) {
    if ($ctime >= $calc(%ps_servonlytime + 86400)) {
      ; turn off the leech only thing now
      unset %ps_servonly*
    }
    else return $istok(%ps_servonlytrig,%trigger,44)
  }
  return $true
}

;; Returns if the daily send limit reached or not @return Boolean @param void
alias PSC_GetSendGigLimitOk {
  var %ps_giglimit = $PS_DialogGigCurrentCount(PS_OnTextPart2,send,return)
  if ($gettok(%ps_giglimit,1,32) == off) return $false
  return $true
}

; old function
alias PS_SetSendTotal {
  var %ps_a = PS_SetSendTotal
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)

  var %ps_settingsfile = $PS_ServeSettings(%ps_a)
  var %ps_temp
  if ($2 == $null) {
    if ($($+(%,ps.sendtotal_,%ps_network),2) == $null) {
      set $+(%,ps.sendtotal_,%ps_network) $readini(%ps_settingsfile,n,#send,#SendTotal)
    }
    var %ps_temp = $($+(%,ps.sendtotal_,%ps_network),2)
  }
  if (%ps_temp == $null) {
    if ($2 != $null) var %ps_temp = $2
    else var %ps_temp = 4
    $PS_WriteIni(%ps_a,%ps_settingsfile,#send,#SendTotal,%ps_temp)
    set $+(%,ps.sendtotal_,%ps_network) %ps_temp
  }
  if ($2 == $null) return %ps_temp
}


; old function
alias PS_SetSendLimit {
  var %ps_a = PS_SetSendLimit
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)

  var %ps_settingsfile = $PS_ServeSettings(%ps_a)
  var %ps_temp
  if ($2 == $null) {
    if ($($+(%,ps.sendlimit_,%ps_network),2) == $null) set $+(%,ps.sendlimit_,%ps_network) $readini(%ps_settingsfile,n,#send,#SendLimit)
    var %ps_temp = $($+(%,ps.sendlimit_,%ps_network),2)
  }
  if (%ps_temp == $null) {
    if ($2 != $null) var %ps_temp = $2
    else var %ps_temp = 2
    $PS_WriteIni(%ps_a,%ps_settingsfile,#send,#SendLimit,%ps_temp)
    set $+(%,ps.sendlimit_,%ps_network) %ps_temp
  }
  if ($2 == $null) return %ps_temp
}


; old function
alias PS_SetQueueTotal {
  var %ps_a = PS_SetQueueTotal
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  var %ps_settingsfile = $PS_ServeSettings(%ps_a)
  var %ps_temp
  if ($2 == $null) {
    if ($($+(%,ps.queuetotal_,%ps_network),2) == $null) set $+(%,ps.queuetotal_,%ps_network) $readini(%ps_settingsfile,n,#send,#QueueTotal)
    var %ps_temp = $($+(%,ps.queuetotal_,%ps_network),2)
  }
  if (%ps_temp == $null) {
    if ($2 != $null) var %ps_temp = $2
    else var %ps_temp = 10
    $PS_WriteIni(%ps_a,%ps_settingsfile,#send,#QueueTotal,%ps_temp)
    set $+(%,ps.queuetotal_,%ps_network) %ps_temp
  }
  if ($2 == $null) return %ps_temp
}


; old function
alias PS_SetQueueLimit {
  var %ps_a = PS_SetQueueLimit
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %ps_network = $ps_network(%ps_a)
  var %ps_settingsfile = $PS_ServeSettings(%ps_a)
  var %ps_temp
  if ($2 == $null) {
    if ($($+(%,ps.queuelimit_,%ps_network),2) == $null) set $+(%,ps.queuelimit_,%ps_network) $readini(%ps_settingsfile,n,#send,#QueueLimit)
    var %ps_temp = $($+(%,ps.queuelimit_,%ps_network),2)
  }
  if (%ps_temp == $null) {
    if ($2 != $null) var %ps_temp = $2
    else var %ps_temp = 2
    $PS_WriteIni(%ps_a,%ps_settingsfile,#send,#QueueLimit,%ps_temp)
    set $+(%,ps.queuelimit_,%ps_network) %ps_temp
  }
  if ($2 == $null) return %ps_temp
}
