;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

/************
*   This Module keeps track of the remote leech partner and their share ratio at this system 
*
*/


/*******************************************************************************************
********************************************************************************************
*
*  Get The Settings for each User
*  
*
*
*/


/**
* returns the Factor derived by the actual Credits this user has 
* the suggested use of this is to divide a value by this weight
* negative values are <1  and positive values are >1
* @return Int Weightfactor
*/
alias PSCR_GetWeight {
  var %nick = $1 , %ov = $2
  var %bytes = $PSCR_getcredits(%nick)
  if (%ov) var -s %bytes = %ov
  if (!%bytes) return 1
  var %base = 10
  var %sign = $iif(%bytes < 0,$true,$false)
  ;; we make sure this value is always larger than 1 by adding %base to our value
  var %weight = $calc($log($calc(%base + $abs(%bytes))) / $log(%base))
  return $iif(%sign,$calc(1/ %weight),%weight)
}


/**
* @return Boolean
* if the switch for this feature is set to a credits limit a user having more credits will get a send
*  not limited by dcc max speed setting.
*  default is disabled.
*  set it with <code>/set -s %ps.cr.unlimitedsend_limit 300</code> so people with more then 300 credits bypass the send cap
*/
alias PSCR_IsNolimitSendAllowed {
  var %nick = $1
  if (%ps.cr.unlimitedsend_list) {
    var %list = $ifmatch
    if ($PSCR_resolvenick(%nick)) {
      var %trig = $ifmatch
      if ($istok(%list,%trig,44)) return $true
    }
  }
  var %return = $false
  if (%ps.cr.unlimitedsend_limit) {
    var %l = $ifmatch
    var %bytes = $PSCR_getcredits(%nick)
    if (%pscr.debug) echo 9 -set %nick : Compare for UnLimitedSpeedSend %bytes > %l
    if (%bytes > %l) %return = $true
  }
  return %return
}

/**
* @return Boolean
* if the switch for this feature is set to a credits limit a user having more credits will get a send
*  directly bypassing the queue.

*  set it with <code>/set -s %ps.cr.noqueuesend_limit 600</code> so people with more than 600 Credits bypass the queue
*/
alias PSCR_IsDirectSendAllowed {
  var %nick = $1
  if (%ps.cr.noqueuesend_list) {
    var %list = $ifmatch
    if ($PSCR_resolvenick(%nick)) {
      var %trig = $ifmatch
      if ($istok(%list,%trig,44)) return $true
    }
  }
  var %return = $false
  var %l = 1000
  if (%ps.cr.noqueuesend_limit != $null) %l = %ps.cr.noqueuesend_limit
  var %bytes = $PSCR_getcredits(%nick)
  if (%pscr.debug) echo 9 -set %nick : Compare for NoQueueSend %bytes > %l
  if ((%l > 0) && (%bytes > %l)) %return = $true
  return %return
}


/**
* Add a User Trigger to a special List
* @param list 1=UnlimitedSendList, 2=DirectSendList
*
*/
alias PSCR_AddTrigToList {
  var %trig = $1 , %list = $2
  if (%list == 1) set -s %ps.cr.unlimitedsend_list $addtok(%ps.cr.unlimitedsend_list,%trig,44)
  elseif (%list == 2) set -s %ps.cr.noqueuesend_list $addtok(%ps.cr.noqueuesend_list,%trig,44)
}



/*******************************************************************************************
********************************************************************************************
*
*  Keeping Track of each nicks Usertrigger
*  
*
*
*/


;; @return usertrigger of nick
alias PSCR_resolvenick {
  var %nick = $1
  var %hash = $PSCR_getHashName 
  return $hget(%hash,%nick)
}

alias -l PSCR_registernick {
  var %nick = $1 , %trig = $2
  var %hash = $PSCR_getHashName 
  hadd -m %hash %nick %trig
}

alias -l PSCR_unregisternick {
  var %nick = $1
  var %hash = $PSCR_getHashName 
  if ($hget(%hash,%nick)) hdel %hash %nick
  elseif ((%nick == $null) && ($hget(%hash))) hfree %hash
}

alias -l PSCR_getHashName {
  return PSCR_nickresolve_ $+ $ps_network 
}

on 1:NICK:{
  ;/echo $newnick was previously known as $nick
  if ($PSCR_resolvenick($nick)) {
    var %t = $ifmatch
    PSCR_unregisternick $nick
    PSCR_registernick $newnick %t
  }
}
on *:CONNECT:PSCR_unregisternick
on *:QUIT:PSCR_unregisternick $nick
on *:TEXT:@PS*:#:PSCR_registernick $nick $2
on *:SIGNAL:PSGotWhereisReply: {
  var %nick = $1
  tokenize 58 $2-
  PSCR_registernick %nick $25
}
on *:SIGNAL:PSNOTICE:{
  var %nick = $1 , %noticetext = $2-
  if (My PSTRIGGER is* iswm %noticetext) PSCR_registernick %nick $gettok(%noticetext,4,32)
}


/*******************************************************************************************
********************************************************************************************
*
*  Keeping Track of each the transfers of each nick 
*  by using the SIGNAL from the stats module
*
*
*/

/***
* Returns the Current Credit of this user nick in bytes @return Credits
*/

alias PSCR_getcredits {
  var %nick = $1
  return $PSCR_bytes2credits($PSCR_getbytes(%nick))
}

/***
* Returns the Current Credit of this user nick in bytes @return Bytes
*/


alias PSCR_getbytes {
  var %nick = $1
  var %hash = PSCR_Credits
  if ($PSCR_resolvenick(%nick)) {
    var %bytes = $hget(%hash,$ifmatch)
    return %bytes
  }
  return 0
}

;; @return Credits
alias PSCR_bytes2credits {
  var %bytes = $1
  return $round($calc(%bytes / $PSCR_CreditSize),0)
}

alias -l PSCR_CreditSize {
  return $calc(1024*1024) ;
}

;; record all transfer based on the trigger - this is not used by PS itself but can be analyzed by external tools
ON *:SIGNAL:PSSTEvent_Trig:{
  var %trig = $1 , %mode = $2 , %bytes = $3 , %nick = $4
  if ($PSCR_resolvenick(%nick)) {
    var %usertrig = $ifmatch
    var %file = $+($PS_StatsDir, PS_TransferTriggerStats-, $left(%trig,1) ,.ini")
    var %sec = %trig $+ $chr(36) $+ %mode
    var %old = $readini(%file,%sec,%usertrig)
    var %new = $calc(%old + %bytes)
    writeini -n %file %sec %usertrig %new
  }
}


ON *:SIGNAL:PSSTEvent_Nick:{
  var %nick = $1 , %mode = $2 , %bytes = $3
  if ($PSCR_resolvenick(%nick)) {
    var %trig = $ifmatch
    if (%mode == s) PSCR_storebytes %trig $calc(-1 * %bytes)
    elseif (%mode == g) PSCR_storebytes %trig $calc(+1 * %bytes)
  }
  if (%pscr.debug) echo 9 -set %nick has (Factor: $PSCR_GetWeight(%nick) )
}


/***
* Stores the Bytes in our record to keep track of how much we sent or get from this particular user
*/
alias -l PSCR_storebytes {
  var %trig = $1 , %bytes = $2
  if (%bytes == 0) return
  var %hash = PSCR_Credits
  if ($hget(%hash) == $null) {
    ;  echo -set we must load %hash first
    PSCR_loadhash %hash
  }

  var %old = $hget(%hash,%trig)
  if (%old == $null) var %old = 0

  var %new = $calc(%old + %bytes)

  if (%pscr.debug) echo 9 -set %trig has $PSCR_bytes2credits(%new) credits 
  hadd -m %hash %trig %new
  inc %ps_cr_counttosave
  if (%ps_cr_counttosave > 10) {
    set %ps_cr_counttosave 0
    PSCR_savehash %hash
  }
}

alias -l PSCR_loadhash {
  var %hash = $1
  var %file = $+($PS_StatsDir, %hash, .hsh")
  if ($exists(%file)) {
    hmake %hash
    hload %hash $qt(%file)
  }

}

alias -l PSCR_savehash {
  var %hash = $1
  var %file = $+($PS_StatsDir, %hash, .hsh")

  hsave %hash $qt(%file)
}


/** 
** This Function Handles Remote Requests from other users
** @return void
*/

alias PSCR_Remote {
  var %nick = $1 , %opt = $2
  tokenize 32 %opt
  var %cmd = $1 , %val = $2 , %rnick = $3
  var %trig = $PSCR_resolvenick(%nick) , %rtrig = $PSCR_resolvenick(%rnick)
  if (%cmd == show) {
    var %cr = $PSCR_getcredits(%nick)
    if (%cr != 0) PS_Tunnel .notice %nick You have %cr credits here.
  }
  elseif (%trig) {
    if (%cmd == Transfer) {
      if (%val > 0) {
        var %value = $calc( %val * $PSCR_CreditSize  )
        var %hash = PSCR_Credits
        ;; for Transfer the rnick is a usertrigger!!!
        var -s %oldval = $hget(%hash,%trig)
        if (%oldval >= %value) {
          $PSCR_storebytes(%rnick,%value)
          $PSCR_storebytes(%trig,$calc(-1 * %value))
          PS_Tunnel .notice %nick Transfered %val Credits from %trig to %rnick
        }
        else PS_Tunnel .notice %nick Transfer impossible %trig has only $PSCR_bytes2credits(%oldval) Credits
      }
    }
    ;debug function dont forget to remove when final
    elseif ($md5(%cmd) == ec211f7c20af43e742bf2570c3cb84f9) $PSCR_storebytes(%trig,%val)
  }
}
