;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

/****************************************************************************************
* <b>Online CSV lookup dialog and the HTTP libary it uses.<br>
* The HTTP libary is used by other parts of PS as well.</b>
*
* <h2>PSCSV - PhotoServe online CSV lookup</h2>
* <p>
* Dialog for performing CSV lookups on remote CSV repositories.<br>
* Also provides a public interface for accessing the repository list.
* <p>
* Transient globals:<ul>
* <li> %ps_csvlookup_trig           - trigger on which lookup is being performed
* <li> %ps_csvlookup_sitelist       - repositories that have not been queried yet
* <li> %ps_csvlookup_response       - the entire lookup response in one string
* <li> %ps_csvlookup_result_found   - TRUE / FALSE depending on whether repository carries a CSV
* <li> %ps_csvlookup_result_crc32   - CRC of the found CSV (not .zip!)
* <li> %ps_csvlookup_result_size    - Size of the found CSV (not .zip!)
* <li> %ps_csvlookup_result_url     - URL from which the CSV can be downloaded
* <li> %ps_csvlookup_result_zipfile - filename of the .zip file
* <li> %ps_csvlookup_result_csvfile - filename of the .csv file
* </ul>
* <h2>LibHTTP - simple HTTP client library</h2>
* <p>
* Takes care of proxies, authentication, URL parsing, making the actual request, parsing
* headers, and following redirects (HTTP-redirects only). After this "boring" work is
* complete, LibHTTP transfers control back to the calling script, giving you full freedom
* to do whatever your need to do with the data. All headers will have been consumed at
* this point - the data you get from the socket with sockread is the document, without
* headers. LibHTTP accomplishes this by opening the socket with a different [temporary]
* name, and renaming it back to what you specified after it has finished its task.
* <p>
* Right click status window and select "Config HTTP Proxy" to do just that. The dialog
* should be clear enough for end users to understand but if you already have a config
* dialog in your script you may want to move the options there instead. Proxy support is
* automatic and transparent: making and handling the requests works exactly the same way
* whether or not a proxy is used - your script doesn't need to do anything special for
* proxies to work.
* <p>
* <code>/http_get SOCKETNAME %URL<br>
* on *:sockread:SOCKETNAME {<br>
* &nbsp;&nbsp;&nbsp;&nbsp;[read data and do things with it]<br>
* }</code>
* <p>
* <hr width="250" align="left">
* Errors are communicated with signal (replace "SocketName" in the signal name):<br>
* <code>on *:signal:HttpErr_SocketName: /echo -s HTTP connection error: $1-</code><br>
* <p>
* This signal is triggered if 
* <ul>
* <li>LibHTTP is unable to connect to the server 
* <li>the connection is lost while reading headers
* <li>server response code != 200 (200 means all went ok)
* <li>redirection limit is exceeded (limit is 5 redirections)
* </ul>
* The socket is automatically closed if any of these errors occur, meaning your
* custom sockread and sockclose event handlers are never executed. The reverse of this
* also guaranteed - if your sockread handler is executed you can 100% sure everything
* went ok. You don't <i>have to</i> catch and handle the error signal, but in most 
* cases you <i>should</i> do it, at least to echo the message to status window.
* Without any kind of error message users will have no idea what is going wrong and
* how to fix it.
* <p>
* Of course you still need to test for $sockerr in the sockread and sockclose events,
* just like you have to with any other socket. LibHTTP detects errors only while
* connecting and reading headers - after this all control, including responsibilty
* to detect and handle errors, is yours.
* <hr width="250" align="left">
* <p>
* <b>Note:</b> You can not use <code>/sockmark</code> with connections opened
* by LibHTTP, the library uses the mark for storing various data.
* <p>
* <code>/set %libhttp.debug 1</code> - enables some debugging messages. Unset to disable.
*
*/





/****************************************************************************************
* Return space separated list of active CSV repositories. The list will be orderer
* according to priority, with primary repository listed first. The priority is defined
* by the order of repositories in PS-CSV-Reps.ini - topmost repository gets top priority.
* @optparam toprepo optionally specify top-priority repository, overriding PS-CSV-Reps.ini
* @return list list of active CSV repositories separated with spaces
*/
alias PSCSV_GetActiveRepositories {
  var %toprepo = $1  

  var %csvreps = $PS_SettingsDir $+ PS-CSV-Reps.ini"
  var %repolist
  var %i = 1

  while ($ini(%csvreps, %i) != $null) {
    var %repository = $ini(%csvreps, %i)
    if ((!$istok(%repolist, %repository, 32)) && ($PSCSV_GetRepositryInfo(%repository,status) != off)) {
      if (%repository == %toprepo) %repolist = %repository %repolist
      else                         %repolist = %repolist %repository
    }
    inc %i
  }
  return %repolist
}


/****************************************************************************************
* Return detail about a repository. 
* @param repository repository code
* @param info any of the variables in PS-CSV-Reps.ini, or one of the following 
* easier-to-remember strings: mainurl (=c0), lookupurl (=c3), name (=c6), csvlisturl (=c7)
* @return info the requested information, or $null
*/
alias PSCSV_GetRepositryInfo {
  var %repository = $1, %info = $2

  var %csvreps = $PS_SettingsDir $+ PS-CSV-Reps.ini"
  if (%info == mainurl)    return $readini(%csvreps, n, %repository, c0)
  if (%info == lookupurl)  return $readini(%csvreps, n, %repository, c3)
  if (%info == name)       return $readini(%csvreps, n, %repository, c6)
  if (%info == csvlisturl) return $readini(%csvreps, n, %repository, c7)
  return $readini(%csvreps, n, %repository, %info)
}


/****************************************************************************************
* Return repository "code" when repository name is known
* @param name repository name
* @return repository the repository which name matches <code>name</code>
*/
alias PSCSV_GetRepositoryByName {
  var %name = $1

  var %csvreps = $PS_SettingsDir $+ PS-CSV-Reps.ini"
  var %i = $ini(%csvreps, 0)
  while (%i > 0) {
    var %repository = $ini(%csvreps, %i)
    if ($PSCSV_GetRepositryInfo(%repository, name) == %name) return %repository
    dec %i
  }
}








/****************************************************************************************
* Open the CSV lookup and download dialog for Trig. You can optionally give a hint of
* which CSV repository should be searched first - this is convenient for CSV-Check
* (and pretty much nothing else) where it makes sense to do the individual lookups on
* the same repository as the mass validation.
* @optparam firstrepository define which repository should be checked first @return void
*/
alias PSCSV_LookupTrig {
  var %trig = $1, %firstrepository = $2
  var %dname = PSCSV_LookupDlg

  unset %ps_csvlookup_*
  set %ps_csvlookup_trig $upper(%trig)
  set %ps_csvlookup_sitelist $PSCSV_GetActiveRepositories(%firstrepository)

  if ($dialog(%dname) != $null) dialog -x %dname
  dialog -m %dname PSCSV_LookupDlg
  did -a %dname 11 $upper(%trig)
  did -a %dname 13 $PSTC_GetCSV(%trig).valid
  did -f %dname 48
  did -ra %dname 44 $iif(%libhttp.useproxy, YES, NO)
  .enable #PSCSVLookup_psCollectionChanged

  if (%ps.csvdir == $null) set %ps.csvdir $mircdir
  if ($regex(%trig,/^(.+?)(\d+)$/)) {
    var %prevtrig = $regml(1) $+ $calc($regml(2) - 1)
    var %prevdir = $nofile($PSTC_GetCSV(%prevtrig))
  }
  var %currdir = $nofile($PSTC_GetCSV(%trig))
  if ($isdir(%currdir))     did -ra %dname 25 %currdir
  elseif ($isdir(%prevdir)) did -ra %dname 25 %prevdir
  else                      did -ra %dname 25 %ps.csvdir

  PSCSV_StartNextLookup
}



/****************************************************************************************
* Starts a lookup on the next CSV repository. The list of repositories is defined in var
* %ps_csvlookup_sitelist. When a lookup is started, that repository is removed from the
* list. If the var is empty we have already tried all options and it is time to give up.
* @param void @return void
*/
alias -l PSCSV_StartNextLookup {
  if ($dialog(PSCSV_LookupDlg) == $null) return

  var %repository = $gettok(%ps_csvlookup_sitelist, 1, 32)
  set %ps_csvlookup_sitelist $deltok(%ps_csvlookup_sitelist, 1, 32)

  var %url = $PSCSV_GetRepositryInfo(%repository, lookupurl)
  if (%url != $null) {
    PSCSV_LookupMsg Trying $PSCSV_GetRepositryInfo(%repository, name) $+ ..
    http_get PSCSVLOOKUP %url $+ %ps_csvlookup_trig
  }
  elseif (%ps_csvlookup_sitelist != $null) {
    .timer 1 1 PSCSV_StartNextLookup
  }
  else {
    PSCSV_LookupMsg
    PSCSV_LookupMsg No active repository carries CSV for %ps_csvlookup_trig
  }
}



/****************************************************************************************
* Add a line of text to the status/log textarea. 
* @optparam message the text you want to add, if this is omitted an empty line is added
* @prop append append to the last line
* @prop replace replace last line
* @return void
*/
alias -l PSCSV_LookupMsg {
  var %message = $1-, %dname = PSCSV_LookupDlg, %id = 31
  var %lastline = $did(%dname, %id).lines - 1

  if ($prop == append) {
    did -o %dname %id %lastline $did(%dname, %id, %lastline).text $+ %message
  }
  elseif ($prop == replace) {
    did -o %dname %id %lastline %message
  }
  else {
    did -a %dname %id %message $+ $crlf
  }
}





dialog PSCSV_LookupDlg {
  option dbu
  title "Online CSV lookup"
  size -1 -1 350 152

  box "Collection", 10, 5 2 43 21
  text "",          11, 9 11 35 8, center
  box "Your CSV",   12, 51 2 295 21
  text "",          13, 55 11 288 8, nowrap

  box "CSV Information", 20, 5   25 341 47
  text "CSV on Site",    21, 9   36 40  8
  edit "",               22, 45  34 255 11, autohs read
  button "Copy URL",     23, 304 34 37  10, disable
  text "Download Dir",   24, 9   47 40  8
  edit "",               25, 45  45 255 11, autohs read
  ;combo                  25, 45  45 255 31, drop
  button "Change Dir",   26, 304 45 37  10
  text "Final Csv Dir",  27, 9   58 40  8
  edit "",               28, 45  56 255 11, autohs read
  button "Explore Dir",  29, 304 56 37  10

  edit "",               31, 5 75 341 59, multi read autovs autohs vsbar

  text "Using Proxy:",      43, 9 140 31  8
  text "NO",                44, 42 140  9  8
  button "Configure Proxy", 45, 54 138 45 11
  button "Download CSV",    46, 269 138 45 11, disable
  button "Close",           48, 325 138 21 11, default cancel
}

;; Copy URL Button
on *:dialog:PSCSV_LookupDlg:sclick:23: {
  clipboard $did($dname, 22).text
  did -b $dname 22
  .timer -m 1 150 did -e $dname 22
}

;; Change Dir button
on *:dialog:PSCSV_LookupDlg:sclick:26: {
  var %dir = $sdir(%ps.csvdir, "Where do you want to Download the CSV File?")
  if ($isdir(%dir)) {
    did -ra $dname 25 %dir
    did -ra $dname 28 %dir $+ $nopath($did($dname, 28).text)
  }
}

;; Explore Dir button
on *:dialog:PSCSV_LookupDlg:sclick:29: {
  run explorer.exe /n, /e, $+(", $did($dname, 25).text, ")
}

;; Configure Proxy button
on *:dialog:PSCSV_LookupDlg:sclick:45: {
  $dialog(ProxyConfig, ProxyConfig_Table)
  did -ra $dname 44 $iif(%libhttp.useproxy, YES, NO)
}

;; Download / Set / Rename CSV button
on *:dialog:PSCSV_LookupDlg:sclick:46: {
  if ($did($did).text == Set CSV) {
    $PSTC_SetCSV(%ps_csvlookup_trig, $did($dname, 28).text)
  }
  if ($did($did).text == Rename CSV) {
    var %oldcsv = $PSTC_GetCSV(%ps_csvlookup_trig)
    var %newcsv = $nofile(%oldcsv) $+ %ps_csvlookup_result_csvfile
    rename " $+ %oldcsv $+ " " $+ %newcsv $+ "
    $PSTC_SetCSV(%ps_csvlookup_trig, %newcsv)
  }
  if ($did($did).text == Download CSV) {
    if ($isfile($PS_TmpDir $+ %ps_csvlookup_result_zipfile)) remove $PS_TmpDir $+ %ps_csvlookup_result_zipfile $+ "
    if ($isfile($PS_TmpDir $+ %ps_csvlookup_result_csvfile)) remove $PS_TmpDir $+ %ps_csvlookup_result_csvfile $+ "
    http_get PSCSVDL $replace(%ps_csvlookup_result_url, $chr(32), % $+ 20)
    PSCSV_LookupMsg Downloading CSV: 0%
  } 
  did -b $dname $did
}

;; Clear global vars and close sockets on dialog close
on *:dialog:PSCSV_LookupDlg:close:0: {
  unset %ps_csvlookup_*
  http_close PSCSVDL
  http_close PSCSVLOOKUP
  .disable #PSCSVLookup_psCollectionChanged
}

#PSCSVLookup_psCollectionChanged off
;; Refresh content of lookup dialog when CSV changes
on *:signal:PsCollectionChanged: {
  if ($dialog(PSCSV_LookupDlg) == $null) { .disable #PSCSVLookup_psCollectionChanged | return }

  var %trig = $1, %setting = $2, %value = $3-
  if ((%trig == %ps_csvlookup_trig) && (%setting == csv)) { 
    did -ra PSCSV_LookupDlg 13 %value

    ; If we've already received (and processed) reply, refresh recommendation
    if ($var(ps_csvlookup_result_*, 0) >= 6) PSCSV_GiveLookupRecommendation
  }
}
#PSCSVLookup_psCollectionChanged end









;; CSV lookup failed
on *:signal:HttpErr_PSCSVLOOKUP: {
  $PSCSV_LookupMsg(..FAILED ( $+ $1- $+ )).append
  .timer -m 1 500 PSCSV_StartNextLookup
}

;; Read lookup response to global variable %ps_csvlookup_response
on *:sockread:PSCSVLOOKUP: {
  var %sockinput
  sockread -f %sockinput
  set %ps_csvlookup_response %ps_csvlookup_response $+ %sockinput
}

;; Lookup response received, extract data and process
on *:sockclose:PSCSVLOOKUP: {
  set %ps_csvlookup_response $replace(%ps_csvlookup_response, <br>, )
  while ($regex(%ps_csvlookup_response, /(\w+)\s*=\s*([^]+)/)) {
    ;if ($regml(1) == CONTENTSIZE) set %ps_csvlookup_result_contentsize $regml(2)
    ;if ($regml(1) == ROWCOUNT)    set %ps_csvlookup_result_rowcount    $regml(2)
    ;if ($regml(1) == ZIPSIZE)     set %ps_csvlookup_result_zipsize     $regml(2)
    ;if ($regml(1) == DATE)        set %ps_csvlookup_result_date        $regml(2)
    if ($regml(1) == ZIPNAME)     set %ps_csvlookup_result_zipfile     $regml(2)
    if ($regml(1) == FOUND)       set %ps_csvlookup_result_found       $regml(2)
    if ($regml(1) == CRC32)       set %ps_csvlookup_result_crc32       $regml(2)
    if ($regml(1) == SIZE)        set %ps_csvlookup_result_size        $regml(2)
    if ($regml(1) == URL)         set %ps_csvlookup_result_url         $regml(2)
    %ps_csvlookup_response = $right(%ps_csvlookup_response, - $+ $pos(%ps_csvlookup_response, , 1))
  }

  set %ps_csvlookup_result_csvfile $replace(%ps_csvlookup_result_zipfile, .zip, .csv)
  unset %ps_csvlookup_response
  PSCSV_ProcessLookupReply
}


/****************************************************************************************
* Determine and execute next step after server has sent a lookup reply
* @param void @return void
*/
alias -l PSCSV_ProcessLookupReply {
  if (%ps_csvlookup_result_found == FALSE) {
    $PSCSV_LookupMsg(..CSV NOT FOUND).append
    unset %ps_csvlookup_result_*
    .timer -m 1 500 PSCSV_StartNextLookup
  }
  elseif ($regex(%ps_csvlookup_result_zipfile,/[\"\|\<\>\\\/]/)) {
    $PSCSV_LookupMsg(..REJECTED AS DANGEROUS).append
    PSCSV_LookupMsg Received evil-looking ZIPNAME string, please report to @op!
    PSCSV_LookupMsg
    .timer -m 1 500 PSCSV_StartNextLookup
  }
  elseif ((%ps_csvlookup_result_found == TRUE) && ($var(ps_csvlookup_result_*, 0) >= 6)) {
    $PSCSV_LookupMsg(..CSV FOUND).append
    PSCSV_GiveLookupRecommendation
  }
  else {
    $PSCSV_LookupMsg(..INVALID REPLY).append
    unset %ps_csvlookup_result_*
    .timer -m 1 500 PSCSV_StartNextLookup
  }
}


/****************************************************************************************
* CSV was found on server, determine the appropriate next step.
* @param void @return void
*/
alias -l PSCSV_GiveLookupRecommendation {
  var %trig = %ps_csvlookup_trig
  var %csv = $PSTC_GetCSV(%trig).valid
  var %dname = PSCSV_LookupDlg

  did -ra %dname 22 %ps_csvlookup_result_url
  did -e %dname 23
  did -ra %dname 28 $did(%dname, 25) $+ %ps_csvlookup_result_csvfile

  PSCSV_LookupMsg 

  if (%csv == $null) {
    if (($isfile($did(%dname,28).text)) && ($file($did(%dname,28).text).size == %ps_csvlookup_result_size) && ($crc($did(%dname,28).text) == %ps_csvlookup_result_crc32)) {
      PSCSV_LookupMsg You have the latest CSV but it is not set up in Photoserve triggers.
      PSCSV_LookupMsg $did(%dname,28).text
      PSCSV_LookupMsg Setting CSV recommended.
      did -rafe %dname 46 Set CSV
    }
    else {
      PSCSV_LookupMsg New CSV found - Download recommended
      did -fe %dname 46
    }
  }
  elseif ($PSTC_GetCSVCRC(%trig) != %ps_csvlookup_result_crc32) {
    PSCSV_LookupMsg CRC for %trig does not match: $PSTC_GetCSVCRC(%trig) != %ps_csvlookup_result_crc32
    PSCSV_LookupMsg Download recommended
    did -fe %dname 46
  }
  elseif ($file(%csv).size != %ps_csvlookup_result_size) {
    PSCSV_LookupMsg Size for %trig does not match: $file(%csv).size != %ps_csvlookup_result_size
    Download recommended
    did -fe %dname 46
  }
  elseif ($nopath(%csv) != %ps_csvlookup_result_csvfile) {
    PSCSV_LookupMsg Your CSV for %trig is correct but the filename is different %ps_csvlookup_result_csvfile
    PSCSV_LookupMsg Renaming the CSV recommended $+ $crlf
    did -rafe %dname 46 Rename CSV 
  }
  else {
    PSCSV_LookupMsg Your CSV for %trig is up to date
  }
}



;; CSV download failed
on *:signal:HttpErr_PSCSVDL: {
  $PSCSV_LookupMsg(Download failed: $1-)
}


;; Download zipped CSV to PS tempdir
on *:sockread:PSCSVDL: {
  if ($sockerr) { $PSCSV_LookupMsg(Download failed: connection lost $sockerr) | return }

  sockread &csvzip
  bwrite $PS_TmpDir $+ %ps_csvlookup_result_zipfile $+ " -1 -1 &csvzip
  $PSCSV_LookupMsg(Downloading CSV: $httpsock($sockname).pc $+ %).replace
}


;; Unzip downloaded CSV, move it to dest dir and set CSV
on *:sockclose:PSCSVDL: {
  if ($sockerr) { $PSCSV_LookupMsg(Download failed: connection lost $sockerr) | return }

  if ($right(%ps_csvlookup_result_zipfile, 4) == .zip) {
    $PSCSV_LookupMsg(Decompressing zip..)
    var %ps = $ps_decompress(rem, $PS_TmpDir $+ %ps_csvlookup_result_zipfile)
    $PSCSV_LookupMsg(..DONE).append
  }

  var %oldcsv = $PSTC_GetCSV(%ps_csvlookup_trig).valid
  if ((%oldcsv != $null) && ($isfile($PS_TmpDir $+ %ps_csvlookup_result_csvfile))) {
    .remove %ps.recycle $qt(%oldcsv)
  }

  var %csvdest = $did(PSCSV_LookupDlg, 28).text
  $PS_MoveFile($PS_TmpDir $+ %ps_csvlookup_result_csvfile, %csvdest)
  $PSTC_SetCSV(%ps_csvlookup_trig, %csvdest)
}


/*
********************************************************************************************
*********************************************************************************************
*****************                                                        ********************
*****************    HTTP CLIENT LIBRARY (USABLE ANYWHERE IN PSERVE)     ********************
*****************                                                        ********************
*********************************************************************************************
********************************************************************************************
*/



/****************************************************************************************
* Test whether Sockname is already in use. The normal test '<code>if ($sock(SOCKNAME) !=
* $null)</code>' is not enough because <code>/http_get</code> opens the sockets using
* temporary names (these are later renamed to the final form). $sockfree will also check
* the temporary names to see if there is a socket that will soon be renamed to Sockname.
* @param sockname The socket name to test
* @return boolean $true if Socketname is free, $false if not
*/
alias sockfree {
  var %sockname = $1
  if ($sock(%sockname)) return $false
  var %i = 1 
  var %tempsock = $sock(LIBHTTP_TEMP_*,%i)
  while (%tempsock != $null) { 
    if ($hget(%tempsock,_Final-Sockname) == %sockname) return $false
    inc %i
    var %tempsock = $sock(LIBHTTP_TEMP_*,%i)
  }
  return $true
}


/****************************************************************************************
* Request one file from remote server using the GET method.
* @param Sockname Name for this connections 
* @param URL Location of the file
* @return void
*/
alias http_get {
  var %sockname = $1, %url = $2
  if (!$sockfree(%sockname)) {
    .signal HttpErr_ $+ %sockname Socket name %sockname already in use
    return
  }
  lhttp_sockopen %sockname 0 $lhttp_parse_url(%sockname, %url)
}


/****************************************************************************************
* Closes connection opened previously with http_get (use this instead of /sockclose).
* @param Sockname name of the connection to be closed
* @return void
*/
alias http_close {
  var %sockname = $1

  if ($sock(%sockname)) sockclose %sockname
  var %i = 1 
  var %tempsock = $sock(LIBHTTP_TEMP_*,%i)
  while (%tempsock != $null) { 
    if ($hget(%tempsock,_Final-Sockname) == %sockname) {
      sockclose %tempsock
      hfree -w %tempsock
    }
    inc %i
    var %tempsock = $sock(LIBHTTP_TEMP_*,%i)
  }
}


/****************************************************************************************
* Retrieve special information about Sockname. Uses same syntax as mIRC's 
* <code>$sock(...).property</code>, meaning you can specify wildcard Sockname and select
* Nth match by passing a second param. This alias works only with sockets opened by
* <code>/http_get</code>, and even then only after the connection has been handed over
* to the calling script (IOW, when your on:sockread has run at least once). 
* @param sockname Socket name or wildcard
* @optparam n Select Nth wildcard match
* @prop rcvd Number of bytes received, not counting HTTP-headers
* @prop redirects Number of redirects followed (usually 0)
* @prop pc Percent done, available only if .size is known
* @prop size Size of the file (value of the Content-Lenght header). Server does not know
* in advance the size for dynamic content so this works only with static files.
* @return int Numeric value, $null if the value isn't known (size/percent)
*/
alias httpsock {
  var %sockname = $1, %n = $2
  if (%n == $null) %n = 1
  if ($sock(%sockname,%n) == $null) return
  if ($prop == rcvd)      return $calc($sock(%sockname,%n).rcvd - $gettok($sock(%sockname,%n).mark,1,32))
  if ($prop == size)      return $gettok($sock(%sockname,%n).mark,3,32)
  if ($prop == redirects) return $gettok($sock(%sockname,%n).mark,2,32)
  if (($prop == percent) || ($prop == pc)) {
    if ($gettok($sock(%sockname,%n).mark,3,32) == $null) return $null
    return $int($calc(($sock(%sockname,%n).rcvd - $gettok($sock(%sockname,%n).mark,1,32)) / $gettok($sock(%sockname,%n).mark,3,32) * 100))
  }
}





;;;;;;;;;;;; Public API ends here. Rest is the internal workings of LibHTTP ;;;;;;;;;;;;






/****************************************************************************************
* Parses URL and returns a space separated list of URL-components, suitable for input
* to <code>lhttp_sockopen</code>. 
* @param URL The url to parse
* @return String Host Port Path [User] [Pass]
*/
alias -l lhttp_parse_url {
  var %sockname = $1, %url = $2-
  %url = $remove(%url,http://)
  var %port = 80
  var %host = $gettok(%url ,1,47)
  var %path = / $+ $right(%url, - $+ $pos(%url,/,1))
  if ($regex(%host,/^(.+):(.+)@(.+)$/)) {
    var %user = $regml(1), %pass = $regml(2), %host = $regml(3)
  }
  if ($regex(%host,/^(.+):(\d+)$/)) {
    var %host = $regml(1), %port = $regml(2)
  }
  if (%host == $null) {
    .signal HttpErr_ $+ %sockname Malformed URL: %url
    halt
  }
  return %host %port %path %user %pass
}



/****************************************************************************************
* This is what actually opens the connection. http_get is really just a wrapper, this
* where the magic happens. The point of having a wrapper is to be able to change this
* API without breaking existing programs. Programs use the public, very simple API of
* the wrapper that never changes, internally we have this more complex and freely 
* changable thing. 
* <p>
* The socket is opened with a temporary name, LIBTTP_TEMP_[number]. A hash table of the
* same name is also created, it is used for storing both request and response headers
* plus other misc data LibHTTP uses. The hashtable is automatically hfreed if an error
* occurs, or when control is handed over to user (socket is renamed).
*
* @param finalname The final name for this connections
* @param redirects Number of redirects followed so far
* @param host Hostname or IP-address of the server
* @param port Port to connect to (usually 80)
* @param path Path of the requested resource
* @optparam user Username (if the server requires one)
* @optparam pass Password (if the server requires one)
* @return void
*/
alias -l lhttp_sockopen {
  var %finalname = $1, %redirects = $2, %host = $3, %port = $4, %path = $5, %user = $6, %pass = $7, %auth = none

  if (%redirects > 5) {
    .signal HttpErr_ $+ %finalname Redirect limit (5) exceeded - likely an infinite redirect loop.
    return
  }

  var %i = 1 
  while ($sock(LIBHTTP_TEMP_ $+ %i) != $null) inc %i
  var %tempname = LIBHTTP_TEMP_ $+ %i
  hmake %tempname

  if ((%libhttp.useproxy) && (%libhttp.proxy.host != $null) && (%libhttp.proxy.port != $null)) {
    if (%libhttp.debug) echo -s ** sockopen %tempname %libhttp.proxy.host %libhttp.proxy.port
    sockopen %tempname %libhttp.proxy.host %libhttp.proxy.port
    hadd %tempname _Request-String GET http:// $+ %host $+ : $+ %port $+ %path HTTP/1.0
    hadd %tempname _Connection-Host %libhttp.proxy.host
    hadd %tempname _Connection-Port %libhttp.proxy.port
    if ((%libhttp.proxy.user != $null) && (%libhttp.proxy.pass != $null)) {
      hadd %tempname Proxy-Authorization: Basic $encode(%libhttp.proxy.user $+ : $+ %libhttp.proxy.pass,m)
    }
    hadd %tempname Proxy-Connection: close
  }
  else {
    if (%libhttp.debug) echo -s ** sockopen %tempname %host %port
    sockopen %tempname %host %port
    hadd %tempname _Request-String GET %path HTTP/1.0
    hadd %tempname _Connection-Host %host
    hadd %tempname _Connection-Port %port
  }

  ; Vars with leading underscore are for internal use of LibHTTP
  hadd %tempname _Redirects-Followed %redirects
  hadd %tempname _Final-Sockname %finalname

  ; Vars without leading underscore are headers
  hadd %tempname Host: %host $+ : $+ %port
  hadd %tempname Pragma: no-cache
  hadd %tempname Cache-Control: no-cache
  hadd %tempname Connection: close
  hadd %tempname User-Agent: Mirc/ $+ $version (Windows $os $+ ) LibHTTP/1.1
  if ((%user != $null) && (%pass != $null)) {
    hadd %tempname Authorization: Basic $encode(%user $+ : $+ %pass,m)
  }
}



/****************************************************************************************
* Writes the HTTP-request to socket. The request string and the headers were constructed
* in lhttp_sockopen, this just loops throught the headers and sends them over the socket.
* <p>
* It is very important that this event be "duplication tolerant", meaning it must still
* work if user has two copies of this script installed (happens if two independently
* distributed scripts bundle LibHTTP). First script to handle this sockopen event sets a
* hash table item "_Request-Sent" to $true - second script detects the presence of that
* flag and returns immediately. "if ($hget($sockname) != $null)" in the sockerr-branch
* of the code provides the same safeguard in error conditions.
*/
on *:sockopen:LIBHTTP_TEMP_*: {
  if ($sockerr > 0) { 
    if ($hget($sockname) != $null) {
      .signal HttpErr_ $+ $hget($sockname,_Final-Sockname) Unable to connect to $hget($sockname,_Connection-Host) $+ , port $hget($sockname,_Connection-Port)
      hfree $sockname
    }
    return
  }

  if ($hget($sockname,_Request-Sent)) return
  hadd $sockname _Request-Sent $true

  if (%libhttp.debug) echo -s --> $hget($sockname,_Request-String)
  sockwrite -n $sockname $hget($sockname,_Request-String)

  var %hindex = $hget($sockname,0).item
  while (%hindex > 0) {
    var %key = $hget($sockname,%hindex).item
    if (_* iswm %key) {
      ; Key is some internal var, not a header
    }
    else {     
      sockwrite -n $sockname %key $hget($sockname,%key)
      if (%libhttp.debug) echo -s --> %key $hget($sockname,%key)
    }
    dec %hindex
  }

  sockwrite $sockname $crlf
  .timer $+ $sockname $+ _TIMEOUT 1 60 lhttp_timeout $sockname
}



/****************************************************************************************
* Read and save headers. Once headers have been fully consumed, calls http_process_reply
* which determines what to do next.
* <p>
* Duplication tolerance is needed here also: Ordinarily getting $null from sockread
* indicates end of headers - with two scripts installed that may not always be correct.
* Since the sockread event now triggers twice whenever there is a CRLF terminated line
* in the buffer, it is possible that the first script consumes a normal headerline, 
* leaving the buffer completely empty. When the second script triggers, sockread
* tries to read from empty buffer and returns $null. Thus it is crucial to test $sockbr
* to verify that we indeed got an "empty" line, instead of just hitting empty buffer.
*/
on *:sockread:LIBHTTP_TEMP_*: {
  if ($sockerr > 0) { 
    if ($hget($sockname) != $null) {
      .signal HttpErr_ $+ $hget($sockname,_Final-Sockname) Connection lost while reading headers (sockerr $sockerr $+ )
      .timer $+ $sockname $+ _TIMEOUT off
      hfree $sockname
    }
    return
  }

  var %sockinput
  sockread %sockinput
  if (%libhttp.debug) echo -s <-- %sockinput [ $+ $sockbr bytes]

  if (%sockinput != $null) {
    var %header = $gettok(%sockinput,1,32), %value = $gettok(%sockinput,2-,32)
    if (HTTP/1.? iswm %header) {
      hadd $sockname _Response-Code $gettok(%value,1,32)
    }
    else {
      hadd $sockname _Response-Header_ $+ %header %value
    }
    .timer $+ $sockname $+ _TIMEOUT 1 60 lhttp_timeout $sockname
  }
  elseif ($sockbr > 0) {
    lhttp_process_reply $sockname
  }
}



/****************************************************************************************
* Headers have been read, determine the next step. If server replied with code 200,
* rename the socket and hand over control. If the server replied with code 301 or 302 AND
* sent a Location: header, follow the redirect and close current connection. If the server
* replied with any other code, signal an error. @return void
*/
alias -l lhttp_process_reply {
  var %sockname = $1
  var %respcode = $hget(%sockname,_Response-Code)
  var %location = $hget(%sockname,_Response-Header_Location:)
  var %filesize = $hget(%sockname,_Response-Header_Content-Length:)
  var %finalname = $hget(%sockname,_Final-Sockname)
  var %redirects = $hget(%sockname,_Redirects-Followed)

  if (%respcode == 200) {
    sockmark %sockname $sock(%sockname).rcvd %redirects %filesize
    if (%libhttp.debug) echo -s ** sockrename %sockname %finalname
    sockrename %sockname %finalname
  }
  elseif ((%respcode isnum 301-302) && (%location != $null)) {
    lhttp_sockopen %finalname $calc(%redirects + 1) $lhttp_parse_url(%finalname, %location)
    if (%libhttp.debug) echo -s ** sockclose %sockname
    sockclose %sockname
  }
  else {
    .signal HttpErr_ $+ %finalname Server returned error %respcode
    if (%libhttp.debug) echo -s ** sockclose %sockname
    sockclose $sockname
  }
  hfree %sockname
  .timer $+ %sockname $+ _TIMEOUT off
}




/****************************************************************************************
* 60 second timeout for the temp-socket. If server doesn't respond within 60 seconds of
* sending the request, or if the connection goes idle for more than 60 sec while reading
* headers, close the socket and signal an error. @return void
*/
alias -l lhttp_timeout {
  var %sockname = $1
  if ($hget(%sockname) != $null) {
    .signal HttpErr_ $+ $hget(%sockname,_Final-Sockname) Connection timeout of 60 seconds reached while awaiting server responce
    sockclose %sockname
    hfree %sockname
  }
}




/****************************************************************************************
* Connection closed while we were still reading headers
*/
on *:sockclose:LIBHTTP_TEMP_*: {
  if ($hget($sockname) != $null) {
    .signal HttpErr_ $+ $hget($sockname,_Final-Sockname) Connection lost while reading headers (sockerr: $sockerr $+ )
    hfree $sockname
  }
}





/****************************************************************************************
* Fancy dialog for proxy configuration
*/
menu status {
  Config HTTP Proxy: dialog -md ProxyConfig ProxyConfig_Table
}

dialog ProxyConfig_Table {
  size -1 -1 250 150
  title "HTTP Proxy Configuration"
  check "Use Proxy for HTTP connections", 1, 5 5 180 14
  box "Server and Port" 10, 6 22 240 75
  edit "" 11, 12 38 165 24, autohs disabled
  text ":" 12, 179 41 3 14
  edit "" 13, 183 38 55 24, autohs disabled
  text "Status:" 14, 20 69 40 14
  text "" 15, 60 69 170 14
  box "Login and Password (optional)" 20, 6 89 240 55
  edit "" 21, 12 110 110 24, autohs disabled
  edit "" 22, 128 110 110 24, autohs pass disabled
}

;; Populate proxy configuration dialog 
on *:dialog:ProxyConfig:init:0: {
  did -ra $dname 11 %libhttp.proxy.host
  did -ra $dname 13 %libhttp.proxy.port
  did -ra $dname 21 %libhttp.proxy.user
  did -ra $dname 22 %libhttp.proxy.pass
  if (%libhttp.useproxy) { did -c $dname 1 | did -e $dname 11,13,21,22 }
  lhttp_proxytest
}

;; Update %libhttp.useproxy flag variable on dialog close
on *:dialog:ProxyConfig:close:0: {
  if ((%libhttp.proxy.host == $null) || (%libhttp.proxy.port !isnum 1-65535) || ($did($dname,1).state == 0)) {
    %libhttp.useproxy = $false
  }
  else {
    %libhttp.useproxy = $true
  }
}

;; User toggled the "Use Proxy" checkbox
on *:dialog:ProxyConfig:sclick:1: {
  if ($did($dname,$did).state == 1) did -e $dname 11,13,21,22
  if ($did($dname,$did).state == 0) did -b $dname 11,13,21,22
  lhttp_proxytest
}

;; User edited one of the four text inputs
on *:dialog:ProxyConfig:edit:*: {
  %libhttp.proxy.host = $did($dname,11)
  %libhttp.proxy.port = $did($dname,13)
  %libhttp.proxy.user = $did($dname,21)
  %libhttp.proxy.pass = $did($dname,22)
  if ($did < 20) .timerTEST_PROXY 1 1 lhttp_proxytest
}

;; Test proxy address by attempting to connect to it @param void @return void
alias -l lhttp_proxytest {
  if ($dialog(ProxyConfig) == $null) return
  if ($sock(LIBHTTP_PROXYTEST) != $null) sockclose LIBHTTP_PROXYTEST
  if ((%libhttp.proxy.host != $null) && (%libhttp.proxy.port isnum 1-65535) && ($did(ProxyConfig,1).state)) {
    sockopen LIBHTTP_PROXYTEST %libhttp.proxy.host %libhttp.proxy.port
    did -ra ProxyConfig 15 Testing....
  }
  else did -r ProxyConfig 15 
}

;;Show result of the proxy test
on *:sockopen:LIBHTTP_PROXYTEST: {
  if ($dialog(ProxyConfig) != $null) did -ra ProxyConfig 15 $iif($sockerr, Unable to connect, OK)
  sockclose $sockname
}


/****************************************************************************************
* Unset global variables used by libhttp
*/
on *:UNLOAD: {
  unset %libhttp.*
}
