
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####


/****************************************************************************************
* <b>PSF - PhotoServe Filters & ChanSettings module.</b>
* <p>
* This started as purely a filters module, but has since been extended to all kinds of
* channel settings. To retain compatibilty the aliases are still prefixed with PSF_,
* the files are stored in \photoserve\Filters\, etc. The files are also referred as
* filterfiles in both documentation and user-visible messages.
* <p>
* The filterfiles are stored in \Photoserve\Filters\#Chan.flt. Pserve.exe parses the
* files and creates from them a set of hashtables that can be imported to mirc with
* <code>/hload</code>. The resulting *.hsh are not deleted, they are left in the filters
* dir so external programs can access the same filtering information (for example when
* pserve.exe generates a triggerlist). Certain optimisations and wildcard expansion is
* also performed by pserve.exe at this point. Pserve.exe function
* <code>RebuildHashes</code> always generates filterhashes for all *.flt files it finds,
* and generates a fresh PSTriggerMap and PsTriggerArr. There is a set of mircscript
* functions that perform the same task as RebuildHashes, but they are slow and thus
* provided as backup only. 
* <p>
* Channel settings are queried with the PSF_GetChanSetting alias. New settings
* can be added as needed, without changing the code here in any way. Just add a
* "setting:value" -pair in the &lt;settings&gt;...&lt;/settings&gt; section.
* <p>
* The primary filterfile distribution mechanism is HTTP, as explained in 
* <b>\PhotoServe\ReadMe\Filters-Help.txt</b>
*/






/****************************************************************************************
* DCC sends your current filterfile of Chan to Nick. The file will be autoloaded on the
* receiving end, regardless of version number. Op-command. @return void
*/
alias PSF_SendFilterFile {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_SendFilterFile * $1-
  var %nick = $1, %chan = $2

  if ($me !isop %chan) {
    echo $ps_n -at --> You must be a channel operator to send filterfiles
  }
  elseif ($me == %nick) {
    echo $ps_n -at --> Cannot send filterfile to self
  }
  elseif (!$isfile($PS_FiltersDir $+ %chan $+ .flt")) {
    echo $ps_n -at --> You have no filterfile to send!
  }
  else {
    echo $ps_n -at --> Sending filterfile of %chan to %nick
    $PS_DccSendFile(%nick,!psget,$PS_FiltersDir $+ %chan $+ .flt")
  }
}




/****************************************************************************************
* Loads filterfile received from an op. Files from non-ops are silently ignored.<p>
* Note: You cannot test this by sending to yourself, the update will fail (tries to
* overwrite the file which is still in use because the DCC send window hasn't had time
* to close). Could get around that with couple of timers but not worth the hassle.
*/
on *:FILERCVD:#*.flt: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnFilercvd_#*.flt * $1-

  var %chan = $left($nopath($filename),-4)
  if (($nick isop %chan) && ($PS_Channel(%chan) == ON)) {
    .notice $nick 07Old filter:10 $iif($hget(PsFilters_ $+ %chan),PsFilters_ $+ %chan,n/a) 07Version:10 $PSF_GetChanSetting(FILTER_VERSION,%chan)
    $PSF_UpdateFiltersFromFile(%chan, $filename)
    .notice $nick 07New filter:10 $iif($hget(PsFilters_ $+ %chan),PsFilters_ $+ %chan,n/a) 07Version:10 $PSF_GetChanSetting(FILTER_VERSION,%chan)
  }
}




/****************************************************************************************
* Query one variable of the &lt;settings&gt;  &lt;/settings&gt; section. I don't know 
* what braindamage led me to switch the order of the parameters vs. the alias name,
* but what's done is done... @return string variable value, or $null
*/
alias PSF_GetChanSetting {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_GetChanSetting * $1-
  var %setting = $1, %chan = $2

  return $hget(PsFilters_ $+ %chan,GENERIC_SETTING_ $+ %setting)
}








/****************************************************************************************
* Test whether group should be shown in PS main dialog.
* @return bool $true if group should be shown, $false if not.
*/
alias PSF_GroupIsVisible {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_GroupIsVisible * $1-
  var %group = $1, %chan = $2

  if (%chan == AllChannels) return $true

  var %filterhash = PsFilters_ $+ %chan
  if ($hget(%filterhash) == $null) {
    var %type = $PSTC_GetGroupType(%group)
    if ((%type == 3rdparty) || (%type == private)) return $false
    return $true
  }

  if ($hget(%filterhash,%group) == EXCLUDE) return $false
  return $true
}



/****************************************************************************************
* Test whether Trig is allowed on Chan
* @return bool $true if Trig is allowed, $false if not
*/
alias PSF_TrigIsAllowed {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_TrigIsAllowed * $1-
  var %trig = $1, %chan = $2,

  if (%chan == AllChannels) return $true

  var %filterhash = PsFilters_ $+ %chan
  if ($hget(%filterhash) == $null) {
    var %type = $PSTC_GetType(%trig)
    if ((%type == 3rdparty) || (%type == private)) return $false
    return $true
  }

  if ($hget(%filterhash,%trig) == EXCLUDE) return $false
  return $true
}



/****************************************************************************************
* Compares current and URL filterfile versions, initiates download if new file is found
* @return void
*/ 
alias -l PSF_UpdateFiltersFromURL {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_UpdateFiltersFromURL * $1-
  var %url = $1, %chan = $2 

  if (!$regex(%url,/.+?(\d+)\.\w+$/)) {
    echo $ps_n -st --> 4Photoserve Error: Can't update filters for $ps_kh $+ %chan $+ , URL does not contain version info: $ps_ki $+ %url
  }
  elseif ($PSF_GetChanSetting(FILTER_VERSION,%chan) >= $regml(1)) {
    ; echo $ps_n -st --> Already using latest filterfile for %chan $+ , not updating
  }
  else {
    echo $ps_n -st --> Downloading new filterfile for $ps_kh $+ %chan from $ps_ki $+ %url

    var %bind = &
    if (? !isin %url) var %bind = ?
    var %id = $right(%chan,-1)
    var %url = $+(%url,%bind,chan=,%id,&net=,$PS_Network)
    var %keykey = keys_ $+ %id
    if ($chan(%chan).key) var %url = $+(%url,&ckey=,$ifmatch)
    if ($PSF_GetChanSetting(%keykey,%chan)) var %url = $+(%url,&keys=,$ifmatch)

    write -c $PS_FiltersDir $+ %chan $+ .tmp" $+(<version>,$regml(1),</version>)
    http_get PSFILTER_ $+ %chan %url
  }
}



/****************************************************************************************
* LibHTTP signals an error - most likely "unable to connect"
*/
on *:SIGNAL:HttpErr_PSFILTER_*: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnSignal_HttpErr_PSFILTER_ * $1-
  var %errormsg = $1-

  var %chan = $right($signal,-17)
  echo $ps_n -st --> Filter update for $ps_kh $+ %chan failed: $ps_kh $+ %errormsg
}


/****************************************************************************************
* Receives and saves the remote filterfile
*/
on *:SOCKREAD:PSFILTER_*: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnSockread_PSFILTER_ * $1-

  var %chan = $right($sockname,-9)
  if ($sockerr) { echo $ps_n -st --> Filter update for $ps_kh $+ %chan failed: $ps_ki $+ connection lost (sockerr $sockerr $+ ) | return }

  :nextread
  sockread &sockinput
  if ($sockbr == 0) return
  ; I wonder why this line was added.. let's see if removing it breaks anything...
  ; breplace &sockinput 13 10 
  bwrite $PS_FiltersDir $+ %chan $+ .tmp" -1 -1 &sockinput
  goto nextread  
}



/****************************************************************************************
* Finished downloading the file, call PSF_UpdateFiltersFromFile to validate and load it
*/
on *:SOCKCLOSE:PSFILTER_*: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnSockclose_PSFILTER_ * $1-

  var %chan = $right($sockname,-9)
  if ($sockerr) { echo $ps_n -st --> Filter update for $ps_kh $+ %chan failed: $ps_ki $+ connection lost (sockerr $sockerr $+ ) | return }
  $PSF_UpdateFiltersFromFile(%chan, $PS_FiltersDir $+ %chan $+ .tmp")
}



/****************************************************************************************
* Validates a filterfile and, if valid, moves it to \Filters\#channel.flt and loads it.
* @param file filename of the filterfile, with path
* @return void
*/
alias -l PSF_UpdateFiltersFromFile {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_UpdateFiltersFromFile * $1-
  var %chan = $1, %fltfile = $2-

  var %fltfile = " $+ $remove(%fltfile,") $+ "

  var %lines = $lines(%fltfile)
  var %i = 1, %state = comments, 
  while (%i <= %lines) {
    var %line = $read(%fltfile,n,%i)
    if     ((%state == filters) && ($regex(%line,/^\s*([^\s\:\;\?\*\#]+)\s*:\s*(allow|exclude)\s*$/i))) {
      ; Valid non-wildcard filtering directive
    }
    elseif ((%state == filters) && ($regex(%line,/^\s*([^\s\:\;\?\*\.]+)\s*:\s*(allow|exclude)\s*$/i))) {
      ; Valid wildcard filtering directive
    }
    elseif ((%state == settings) && ($regex(%line,/^\s*([\w\.\-]+?)\s*:\s*(.+?)\s*$/))) {
      ; Valid settings directive
    }
    elseif ((%state == comments) && (%line == <filters>))   { %state = filters    }
    elseif ((%state == comments) && (%line == <settings>))  { %state = settings   }
    elseif ((%state == filters) && (%line == </filters>))   { %state = comments   }
    elseif ((%state == settings) && (%line == </settings>)) { %state = comments   }
    elseif (%state == comments)   { }
    elseif ($regex(%line,/^\s*;)) { }
    elseif ($regex(%line,/^\s*$)) { }
    else {
      echo $ps_n -st --> 4Photoserve Error: Filters update aborted, new filterfile for $ps_kh $+ %chan contains garbled data on line %i $+ : $ps_ki $+ %line
      remove %fltfile
      return
    }
    inc %i
  }
  if (%state != comments) {
    echo $ps_n -st --> 4Photoserve Error: Filters update aborted, new filterfile for $ps_kh $+ %chan missing closing $ps_ki $+ </ $+ %state $+ > marker
    remove %fltfile
    return
  }

  ; move to \Filters\#channel.flt (unless processing that exact file)
  if ($shortfn(%fltfile) != $shortfn($PS_FiltersDir $+ %chan $+ .flt")) {
    .copy -o %fltfile $PS_FiltersDir $+ %chan $+ .flt"
    .remove %fltfile
    ; We can do these things even though the new file has not actually been loaded yet:
    echo $ps_n -st --> New filterfile for $ps_kh $+ %chan downloaded successfully
    .signal psFilterChanged %chan
  }

  ; Now that the file has been validated and moved, let PSTC_ReloadTriggers load it. That will
  ; of course rebuild and reload ALL filters and the PsTriggerMap - an overkill if all we did
  ; was download one new filterfile for one channel. But since the pserve.exe has long loadtime
  ; and is fast in the actual processing, it doesn't make much of a practical difference.
  PSTC_ReloadTriggers
}


/***************************
* If banned from a channel the old filterfile is cleaned up, there is no need to keep it since we
* are no longer wanted there. Note this is not being triggered by a kick out of a channel
* only being banned from a channel (and trying to enter) triggers this event
*/
raw 474:*:{
  var %chan = $2
  var %fltfile = $PS_FiltersDir $+ %chan $+ .flt"
  if ($exists(%fltfile)) {
    .remove %fltfile
    PSTC_ReloadTriggers
  }
}




/****************************************************************************************
* Loads all hsh files in \Photoserve\filters\. PSF_ReloadFilters is only called by
* <code>PSTC_ReloadTriggers</code>. Prior to calling ReloadFilters, ReloadTrigges
* used pserve.exe's <code>RebuildHashes</code>-function for generating fresh triggermap
* and filter .hsh files. So when you want refresh/rebuild filters, don't call this alias,
* call PSTC_ReloadTriggers. It will in turn call this alias.
* @param void @return void
*/ 
alias PSF_ReloadFilters {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_ReloadFilters * $1-

  hfree -w PsFilters_*
  var %i = $findfile($PS_FiltersDir,#*.hsh,0,1)
  while (%i > 0) {
    var %hshfile = " $+ $findfile($PS_FiltersDir,#*.hsh,%i,1) $+ "
    var %chan = $left($nopath(%hshfile),-4)
    hmake PsFilters_ $+ %chan 5000
    hload PsFilters_ $+ %chan %hshfile
    dec %i
  }
}



/****************************************************************************************
* Checks Chan topic for filter URL and calls PSF_UpdateFiltersFromURL if one is found
* @return void
*/
alias PSF_CheckTopic {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_CheckTopic * $1-
  var %chan = $1

  if ($regex($chan(%chan).topic,/<psfilter\|([^\>]+?)>/i)) $PSF_UpdateFiltersFromURL($regml(1),%chan)
  elseif ($regex($chan(%chan).topic,/<PsTurnOff>/i)) PS_RemoveChannelFromPS %chan
}



/****************************************************************************************
* Runs PSF_CheckTopic when joining a photoserve using channel.
*/
on *:JOIN:*: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnJoin * $1-
  if ($nick == $me) {
    if (($PS_Channel($chan) == ON)) .timer 1 $rand(10,60) PSF_CheckTopic $chan
    else .timer 1 15 PSF_CheckAndAddNewChannel $chan
  }

}

/****************************************************************************************
* Runs A Check if the Channel is PS aware and turns it ON (only if no setting is stored for this channel at all. So 
* it will not turn on a turned off channel. PS_AddChannelToPS ensures this)
*/

alias -l PSF_CheckAndAddNewChannel {
  var %chan = $1
  if ($chan(%chan).topic) {
    var -s %topic = $ifmatch
    if ($regex(%topic,/<psfilter\|/i)) {
      echo -t %chan This channel is a PhotoServe Channel. PS will be turned on.
      PS_AddAChannelToPS %chan
    }
  }
}

/****************************************************************************************
* Runs PSF_CheckTopic when the topic of a photoserve using channel is changed.
*/ 
on *:TOPIC:*: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnTopic * $1-

  if ($PS_Channel($chan) == ON) .timer 1 $rand(10,90) PSF_CheckTopic $chan
}


/****************************************************************************************
* Channel msg by an op for filter URL.
*/
on ^*:TEXT:<psfilter|*>:#: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnText_# * $1-
  var %filtermsg = $1-

  if (($PS_Channel($chan) == ON) && ($nick isop $chan)) {
    if ($regex(%filtermsg,/<psfilter\|([^\>]+)>/i)) $PSF_UpdateFiltersFromURL($regml(1),$chan)
    haltdef
  }
}

/****************************************************************************************
* Channel notice by an op for filter URL.
*/
on ^*:NOTICE:<psfilter|*>:#: {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSF_OnNotice_# * $1-
  var %filtermsg = $1-

  if (($PS_Channel($chan) == ON) && ($nick isop $chan)) {
    if ($regex(%filtermsg,/<psfilter\|([^\>]+)>/i)) $PSF_UpdateFiltersFromURL($regml(1),$chan)
    haltdef
  }
}


/****************************************************************************************
* Private notice by an op or chanserve for filter URL.
*/
on ^*:NOTICE:*#* <psfilter|*>:?: {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSF_OnNotice_# * $1-
  var %chan = $1, %filtermsg = $2-

  %chan = $remove(%chan,$chr(91),$chr(93))
  if (($PS_Channel(%chan) == ON) && (($nick == chanserv) || ($nick isop %chan)) ) {
    if ($regex(%filtermsg,/^<psfilter\|([^\>]+)>/i)) $PSF_UpdateFiltersFromURL($regml(1),%chan)
    haltdef
  }
}


/****************************************************************************************
* Op command to regenerate triggermap and all filterhashes. 
*/ 
on ^*:NOTICE:!PSFilterUp #*:?: {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSF_OnNotice_!PSFilterUp * $1-
  var %psfilterup = $1, %chan = $2

  if ($nick isop %chan) {
    PSTC_ReloadTriggers
    .notice $nick 10PhotoServe Filters Regenerated.
  }
  else {
    .notice $nick 10This trigger rebuilds a users trigger filters memory table.
  }
  haltdef
}
