;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

/***
*    Pserve_leech 
*
* 
*/


/**
* Starts all needed resources for a Leech. 
* @param option is passed to the StartAleechWindow function.
*     If 'noreg' it will not register the leech as manual
* @return void
*/
alias PSL_Leech {
  var %trigger = $1 , %chan = $2 , %option = $3
  if (!%chan) %chan = $chan
  if ( (!%trigger) || (!%chan) ) { echo -at Usage: /PSL_Leech <trig> <chan> | return }
  if (!$PreCheck_LeechStart(%trigger,%chan)) {
    echo -at Could not start leech of %trigger :4 $PreCheck_LeechStart(%trigger,%chan).reason
    return
  }
  StartALeechWindow %trigger %chan %option
  noop $AccessDB(COLL,%trigger,PRIORITY,.)
  UpdateCollectionSources %trigger %chan
  PSL_Log 2 Started all leech resources for leech of trigger %trigger
  ActivatePSLLeechController
  if (%option !== noreg)  noop $RegisterManualLeech(%trigger,$PS_Network,%chan)
}

/** 
* Closes and dismisses all resources held by a Leech. @return void
* @optparam context depending on how this function is called
* @optparam sleep set to not null if this collection goes to sleep and should not lose all the collected data.
*/
alias PSL_LeechStop {
  var %trigger = $1, %context = $2,  %sleep = $3
  scon -a noop $!StopLeechInt( %trigger , %context , %sleep )
}

alias -l StopLeechInt {
  var %trigger = $1, %context = $2,  %sleep = $3
  ReleaseAllUsersFromLeech %trigger
  window -c $getWindowName(LEECH,%trigger)
  noop $checkLeechTimers(%trigger).kill
  ;  if (!%sleep)  hfree -w PL_* $+ %trigger $+ *
  var %res = $AccessCollectionState(%trigger,off)
  if (!%sleep) {
    var %res = $AccessDB(COLL,%trigger).Free
    .hfree -w *_HAVE_ $+ %trigger $+ _ $+ $network $+ *
    window -c $getWindowName(WHEREIS,%trigger)
  }
  ;;some special treatments
  if (%context == ReQueue) {
    var %res = $CheckControlFileStatus(UPDATE,.,%trigger,ReQueue)
  }
  elseif ((%context == STOP) || (%context == User_Requested)) {
    var %res = $CheckControlFileStatus(UPDATE,.,%trigger,Stopped)
  }

  PSL_Log 2 PSL_Leech of Trigger %trigger stopped. Context: %context 
  noop $PSL_TreeOp(del,Leech %trigger)
  RefreshLeechDialog %trigger
  noop $RegisterManualLeech(%trigger,$ps_Network).unreg
}


;; register a leech that was started manualy . @prop unreg to unregister it

alias -l RegisterManualLeech {
  var %trigger = $1 , %network = $2 , %channel = $3 
  ;  echo -set registerleech( $prop ) $1-
  var %cfile = $PSL_FetchConstant(ResumeFile)
  if ($prop == unreg) remini %cfile %network %trigger
  else              writeini %cfile %network %trigger %channel
  flushini %cfile
}



alias -l RestartManualLeech {
  var %network = $1 , %channel = $2
  var %cfile = $PSL_FetchConstant(ResumeFile)

  var %c = $ini(%cfile,%network,0)
  while (%c) {
    var %trigger = $ini(%cfile,%network,%c)
    var %lchannel = $readini(%cfile,%network,%trigger)
    if (%channel == %lchannel) {
      if ($prop == check) return $true
      if (!$window($getwindowName(LEECH,%trigger))) {
        echo 13 %lchannel Leech Restarter is starting old manual (!L) leech for %trigger 
        PSL_Leech %trigger %lchannel fullcheck
      }
      else {
        echo 13 %lchannel nothing to start here. leech window for %trigger already open 
      }
    }
    dec %c
  }

}





on 1:CLOSE:@:{
  var %list =  $getWindowName(LEECH)
  var %count = $numtok(%list,9)
  while (%count > 0) {
    var %trigger = $gettok(%list,%count,9)
    var %testwindow = $getWindowName(LEECH,%trigger)
    ;  echo -sat >> now %trigger >> %testwindow
    if ($target == %testwindow) PSL_LeechStop %trigger User_Requested
    dec %count
  }

}

;;;
;;;
;;; events 

;; initialization operations when mirc is restarted
ON *:START:{
  echo -sat PSLeech Started (On Start). Checking Settings: $iif($PS_GlobalOption(get,leech.reqtype).network == network,4SLOW LEECH METHOD (!PSGET),3FAST LEECH METHOD)
  ResetAllControlFiles

  if (%ps.AutoJoinNetworks) {
    var %tojoin = $numtok(%ps.AutoJoinNetworks,58)
    var %i = 0
    while (%i < %tojoin) {
      inc %i
      if (%i == 1) server $gettok(%ps.AutoJoinNetworks,%i,58)
      else .timer -o 1 $calc(%i + 6) server -m $gettok(%ps.AutoJoinNetworks,%i,58)
    }
  }
  ;  else .timer 1 60 echo -sat autojoin not active - if you want PS to autojoin all your favorite networks /set $+(07%,PS.AutoJoinNetworks) Network1:Network2:Network3

  noop $findfile($PS_TmpDir(pserve_leech_onstart),PSL_Ctrl_*.txt,0,0, remove $+(",$1-,"))

  if (%ps.downp) noop  $CleanTempDownloadPath(%ps.downp $+ PSTEMP\)
  CleanPartSumFile
  GeneralInit
}

;; initialization operations when the leech script is reloaded OR freshly loaded 
on *:SIGNAL:PSUPDATEDONE: {
  GeneralInit
}

;; operations performed when starting OR restarting the leech script 
alias -l GeneralInit {
  ;; turn the ignore feature to ignore types 
  if ($dccignore) dcc ignore ignore
  if ($passivedcc) dcc passive off

  var %minmirc = 6.34
  if ($version < %minmirc) .timer 1 120 /echo 4 -a Please note that your version of mirc ( $+ $version $+ ) was not the one were this PS Version was tested. In case of any problems try the latest version of mirc ( $+ %minmirc or above) - it may fix any problems. This is no error just a WARNING! (If there are no problems experienced everything is fine)
  scon -a ActivatePSLLeechController
}

ON *:UNLOAD:{
  echo -st PSLeech Unloaded.
  timerpsl* off
  hfree -w *psl*
  close -@PSL*
}

ON *:INPUT:#:{
  if (($1 == !l) && ($2)) {
    echo $ps_h -at >>> Leech Start of $2 in $chan
    PSL_Leech $2 $chan
    halt
  }
  else if (($1 == !lp) && ($2)) {
    echo $ps_h -at >>> Leech Start of $2 in $chan (pictures only)
    PSL_Leech $2 $chan pics
    halt
  }
  else if (($1 == !lv) && ($2)) {
    echo $ps_h -at >>> Leech Start of $2 in $chan (videos only)
    PSL_Leech $2 $chan vids
    halt
  }
  else if (($1 == !ls) && ($2)) {
    echo $ps_h -at >>> Leech Stop of $2
    PSL_LeechStop $2 User_Requested $true
    halt
  }

}


on *:CONNECT:{
  PSL_Log 2 Connect to $network at $server on $port detected
  ClearAllMarksFromAllLeeches
  FreeAllUsers
  InitControlFile
  .timer 1 90 ActivatePSLLeechController
  var %res = $AccessDB(GLOB,CONTROL,LASTUPDATE,.)
}

on *:QUIT:UserLeft $nick $1-

on *:PART:*:PARTAction $nick $chan
on *:KICK:*:PARTAction $knick $chan

on *:signal:psFilterChanged:{
  var %chan = $1
  identifyMyselfToChan %chan
}

alias -l identifyMyselfToChan {
  var %chan = $1
  broadcast %chan USERINFO $+($version,$chr(9),$PS.Version $+ $PS.Version.beta,$chr(9),$PSC_GetStatus,$chr(9), $&
    $iif($PSL_getWhereIsAddress().mask,$ifmatch,disabled),$chr(9),$dccport,$chr(9),$PSL_Status_Leech().count,$chr(9), $&
    $iif($PSF_GetChanSetting(FILTER_VERSION,%chan),$ifmatch,nofilter),$chr(9),$userstats,$chr(9),$transferstats)
  broadcast %chan SERVERINFO $ps_network $server $serverip $port
}
;; @return String the values of the last months transfer statistics, all values are base-36 to make them as small as possible
alias -l transferstats {
  var %m = $calc( $asctime(m) -1)
  var %y = $asctime(yyyy)
  if (%m < 1) {
    %m = 12
    dec %y
  }
  var %date = $asctime(%y $+ - $+ %m $+ -1)
  var %d = $PSST_DaysInMonth(%m) 
  var %return = $base(%y,10,36) $+ , $+ $base(%m,10,36) $+ , $+ $base(%d,10,36)
  var %s = $PSST_SumFileStatsRange($PS_Network,send,%date,%d)
  tokenize 32 %s
  %return = %return $+ , $+ $base($1,10,36) $+ , $+ $base($2,10,36)
  var %g = $PSST_SumFileStatsRange($PS_Network,get,%date,%d)
  tokenize 32 %g
  %return = %return $+ , $+ $base($1,10,36) $+ , $+ $base($2,10,36)
  return %return
}

;; @return String of some stats about the users trigger (to be broadcasted)
alias -l userstats {
  var %onbytes = $PSTC_TriggerStats(AllChannels).onbytes
  var %offbytes = $PSTC_TriggerStats(AllChannels).offbytes
  var %unbackupbytes = $PSTC_TriggerStats(AllChannels).unbackupbytes


  var %ontrigs = $PSTC_TriggerStats(AllChannels).ontrigs
  var %offtrigs = $PSTC_TriggerStats(AllChannels).offtrigs
  var %unbackuptrigs = $PSTC_TriggerStats(AllChannels).unbackuptrigs
  var %incomplete = $PSTC_TriggerStats(AllChannels).incomplete


  var %backupratiob = $calc(1 - (%unbackupbytes / (%onbytes + %offbytes)))
  var %backupratio = $calc(1 - (%unbackuptrigs / (%ontrigs + %offtrigs)))

  var %sep = 44
  var %string = 0 $+ $str($chr(%sep) $+ 0,5)
  %string = $puttok(%string,%backupratiob,1,%sep)
  %string = $puttok(%string,$calc(%ontrigs + %offtrigs),2,%sep)
  %string = $puttok(%string,%unbackuptrigs,3,%sep)
  %string = $puttok(%string,%incomplete,4,%sep)
  %string = $puttok(%string,%onbytes,5,%sep)
  %string = $puttok(%string,%offbytes,6,%sep)

  return %string
}

on *:JOIN:*:{
  ActivatePSLLeechController
  if ($nick == $me) {
    if (!$PSC_isPSonInChannel($chan)) return
    if ($RestartManualLeech($PS_Network,$chan).check) echo 12 $chan Will try to start old manual leeches in 60 seconds
    .timer 1 60 RestartManualLeech $PS_Network $chan 
    identifyMyselfToChan $chan
    return
  }
  var %usertrig = $WhoIsThisUser($nick)
  var %oldnick = $AccessDB(GLOB,NICKS,%usertrig)
  if (%usertrig) {
    ;_AOFF_ psecho 12 Detected the joining $nick ( $chan ) has the trigger " $+ %usertrig $+ " .  His Address shows: $address
    var %wasbusy = $IsUserBusy(%usertrig)
    RegisterNickToTrig $nick %usertrig
    ;; if user was busy we should go and set the ResendOK flag and start an ontimeout flag
    if (%wasbusy == $true) {
      var %file = $IsExpectedTransfer(%nick,*)
      if (%file) PSL_Timer %usertrig $+ _AWAIT $rand(36,48) OnTimeoutFromRequest %usertrig
      var %r = $AccessDB(USER,%usertrig,RESENDOK,JOINLEAVE,1600) 
    }
    else {
      ; set the user to busy for some time when he joins 140 to 360 sec
      var %freein = $rand(340,460)
      var %transfermethod = $gettok($GetRequestMethodString(%usertrig),1,32)
      if (%transfermethod == !PSserv) %freein = 3
      ;_AOFF_ psecho releasing %usertrig in %freein sec because of %transfermethod 
      SetUserFree %usertrig %freein
    }
    ;; release the user from all old problems... new game 
    var %res = $AccessDB(USER,%usertrig,NOFSERV,.)
    var %block = $AccessDB(USER,%usertrig,BLOCK)
    if ((%block) && (%block == TIMEOUT)) {
      echo -set Releasing %usertrig from block %block -> :-) maybe was caused by disconnect of client
      var %res = $AccessDB(USER,%usertrig,BLOCK,.)
    }


    PSL_Log 7 User $nick ( %usertrig ) was previously seen as %oldnick . Re-Registered the new name (and deleted the old one from the db.) User was busy: %wasbusy -> waiting for:6 %file
  }
}

on *:NICK:{
  var %usertrig = $AccessDB(GLOB,TRIGS,$nick)
  ;_AOFF_ psecho User $nick had the Trigger %usertrig
  if (%usertrig) {
    PSL_Log 7 User $nick renamed to $newnick his ID %usertrig .. Re-registering 
    RegisterNickToTrig $newnick %usertrig
  }
}

on ^*:FILERCVD:*:{
  var %filename = $filename
  ; echo 12 -s Received %filename (or in a short form $shortfn(%filename) ) from $nick ->> $get(-1).cps  --> $get(-1).cid
  var %cps = $get(-1).cps
  var %resume = $get(-1).resume
  ;PSPAR2_EMMACD6--0320-10.jpg--_340CE823_189782.vol00+20.par2
  if ($regex($nopath(%filename),/^pspar2_(.+)--(.+)--_([\da-f]+)_(\d+)\..+\.par2$/i)) {
    var %trigger = $regml(1) , %nfilename = $regml(2) , %crc = $regml(3) , %size = $regml(4)
    var %move = $AutoSortPar2Dir(%trigger,%crc,%size)
    var %target = %move $+ $nopath(%filename) $+ "
    if ($file(%target)) remove %target
    .rename $+(",%filename,") %target
    echo $ps_h -set ---> Saved07 %target . Trigger:10 %trigger FileName10 %nfilename Size10 %size CRC3210 %crc
    .signal PAR2RECEIVED %trigger %crc %size %target
    return
  }


  if (.csv isin $nopath(%filename)) {
    var %nick = $nick
    var %file = $nopath(%filename)
    var %usertrig = $FindBestMatchingUserTrig(%nick) 
    var %data = $IsCSVExpected(%usertrig ,%file,.)
    ;    echo -set found %data for incoming %file from %usertrig 
    if (%data) {
      var %cid = $gettok(%data,1,9)
      if (%cid) scid %cid
      ;_AOFF_ psecho 6 We found something for the Incoming CSV: %file from %nick (aka: %usertrig ) >> %data : FIlename: %filename
      var %trigger = $gettok(%data,2,9)
      var %res = $AccessDB(COLL,%trigger,PROCESSCSV,$gettok(%data,3,9))
      if ($left(%filename,4) == .csv) var %unc = %filename
      else   var %unc = $PS_Decompress(rem,%filename)
      if (!$file(%unc)) {
        var %origname = $replace($gettok(%data,3,9),_,?)
        var %new = $findfile($nofile(%unc),%origname,1)
        var %unc = %new
        .timer 1 60 .remove %unc
      }
      var %endloc = $getdir $+ IncomingCSV\
      ;_AOFF_ psecho --> decompressed to %unc (creating %endloc ) name: $gettok(%data,3,9)
      var %res = $PS_MakePath(%endloc)
      .timer 1 3 ProcessReceivedCSVFile %trigger %nick %usertrig
      .copy -o $qt(%unc) $qt(%endloc $+ $nopath(%unc))
      return
    }
  }


  if (_HAVE_ isincs $nopath(%filename)) {
    var %usertrig = $FindBestMatchingUserTrig($nick)
    var %re = $gettok($AccessDB(USER,? $+ %usertrig,WAITHAVE),1,8)
    var %cid = $gettok(%re,1,9)
    var %trigger = $gettok(%re,2,9)
    if (%cid) scid %cid
    if (%trigger isin $nopath(%filename)) {
      ;;
      var %haveroot = $remove($PS_HaveSavedDir(on_receive),") $+ $PS_Network $+ \
      var %tempdir =  %haveroot $+ $ticks $+ _ $+ $rand(1000,9999) $+ \
      mkdir $qt(%haveroot)
      mkdir $qt(%tempdir)
      var %tempfile = %tempdir $+ $nopath($filename)
      .rename $qt($filename) $qt(%tempfile)
      noop $PS_DeCompress(keep,%tempfile)
      var %count = $findfile(%tempdir,*,0)
      if (%count > 1) noop $saferemove(%tempfile).nobin
      var %extractedfile = $findfile(%tempdir,*,1)
      if (!%extractedfile) echo -set No extracted file was found for $filename in %tempfile
      var %havelist = %haveroot $+ $nopath(%extractedfile)
      if ($isFileUsed(%havelist)) fclose $ifmatch
      noop $saferemove(%havelist).nobin
      .rename $qt(%extractedfile) $qt(%havelist)
      noop $findfile(%tempfile,*,0,0,noop $saferemove($1-).nobin)
      rmdir $qt(%tempdir)
      ;;

      var %usertrig = $EndOfFileTransferFromUser($nick,good)
      PSL_Timer %usertrig $+ _AWAIT off

      ;_AOFF_ psecho 12 Havelist sent. OK. We got from %usertrig the HAVELIST FOR %trigger
      ;; OK NOW. we got the havelist, we wait a few seconds until the list is processed and stored by PS Section (that handles that, uncompress..)
      ;; so we set the user to busy.  Un-Busy and HAVELISTHAVE Flag will be set in the Called ProcessHavelist Fuction
      ;; clean up:
      noop $AccessDB(USER,%usertrig,WAITHAVE,.)
      var %procin = $iif(%ps_havelistdelay,$ifmatch,1)


      .timer 1 %procin ProcessReceivedHaveList %trigger %usertrig %havelist
      echo -set --> Havelist of7 %usertrig is stored in3 %havelist - Will be processed in5 %procin seconds
      set -z %ps_havelistdelay $calc(%procin + 15) 
      setUserBusy %usertrig %trigger
      noop $AccessDB(USER,%usertrig,ADDINGHAVELIST,queued,%ps_havelistdelay)

    }
  }
  else {
    var %data = $IsExpectedTransfer($nick,%filename)
    if (%data) {
      if ($gettok(%data,1,9) !== $cid) scid $gettok(%data,1,9)
      if ($scon(0) > 1) {
        echo -s -
        echo $color(ctcp) -st DCC Get of $nopath(%filename) from $nick complete ( $+ $duration($get(-1).secs, 3) $round($calc($get(-1).cps / 1024),2) KB/Sec)
        haltdef 
      }
      ;_AOFF_ psecho we have stored the following data for RECEIVED File %filename : %data

      var %usertrig = $EndOfFileTransferFromUser($nick,good)
      if (!%usertrig) {
        PSL_Log 1 Error no usertrig from $nick for %filename -> %data
        var %usertrig = unknown
      }
      else {
        var %method = $AccessDB(USER,%usertrig,METHOD,.)
        var %pskilled = $false
        noop $PSST_RecordGet($nick,$gettok(%data,2,9),%method,-1,%pskilled)
      }

      var %res = $PSL_TreeOp(del,Leech $gettok(%data,2,9) Targets %usertrig File)
      var %res = $PSL_TreeOp(del,Leech $gettok(%data,2,9) Targets %usertrig Status)

      ; PSL_Log 9 The Trigger of user5 $nick is recognized as11 %usertrig
      ;   var %start = $uptime(mirc)
      var %trigger = $gettok(%data,2,9)
      setUserBusy %usertrig %trigger


      ; CRC32 Check must now be performed 

      var %targetpath = $gettok(%data,4,9)

      if ($PSE_GetPartname($nopath(%filename)).ispart) {
        var %dest = $PSL_TempPathForTrigger(%trigger).parts
        ; i believe this is wrong - it should be the same as for normal files..  or else the filename will be as it was received and not the original file.. 
        ;; must check later
        ;  %dest = $left(%dest,-1) $+ %targetpath $+ $nopath(%filename)
      }
      else {
        var %dest = $PSTC_GetPath(%trigger)
      }
      %dest = $left(%dest,-1) $+ %targetpath $+ $gettok(%data,3,9)

      ;; needed: %trigger,%nick,%usertrig,%filename,%data(3=endname 4=path  5=size  6=crc

      var %id = $hget(PSL_CRC_I,IDX)
      inc %id
      hadd -m PSL_CRC_I IDX %id
      ;  echo -set started crc calc for7 %id ->3 %filename to6 %dest
      noop $PS_MakePath($nofile(%dest))
      if ($len(%dest) > 100) {
        ;; path has to be created before to make this work properly
        %dest = $+($file($left($nofile(%dest),-1)).shortfn,$nopath(%dest))
      }
      hadd -m PSL_CRC %id $+($cid,$chr(9),%trigger,$chr(9),$nick,$chr(9),%usertrig,$chr(9),%filename,$chr(9),$gettok(%data,3-6,9),$chr(9),%dest,$chr(9))
      ;      $dllcall( $PS_ProgramDir $+ pserve.dll", CallbackEndCrcCheck %id , SortFile, $+(",%filename,") $+(",%dest,") $+(",$getlogfile(%id),") $base($gettok(%data,6,9),10,16))
      if (%psl.debug) echo -set Trying to Dispatching DLL %id to check crc for $nopath(%filename) size $gettok(%data,5,9) from trigger %trigger
      dispatchdll %id
      ;  echo -set Called Params>> $PS_ProgramDir $+ pserve.dll" , CallbackEndCrcCheck %id , SortFile, $+(",%filename,") $+(",%dest,") $+(",$getlogfile(%id),") $gettok(%data,6,9)
    }
    ; No Longer needed:    else if (.mrc.update.txt isin $nopath(%filename))  ProcessIncomingUpdateFile $nick %filename

  }
  return
  :error 
  PSL_Log 1 Error in ON_RECEIVE : $error
  echo -sat Some error in the function $filename : $error
  flist
  fclose HAVELISTHANDLE_*
}

;; checks if a file (example havelist) is opened @return FileHandle

alias -l isFileUsed {
  var %file = $1
  var %c = $fopen(0)
  while (%c) {
    var %f = $fopen(%c).fname
    if (%f == %file) return $fopen(%c)
    dec %c
  }
}

alias PSL_CheckDllRun {
  var %name = $1
  var %c = $dll(0)
  while (%c) {
    if ($nopath($dll(%c)) == %name) return $true
    dec %c
  }
  return $false
}

alias -l CheckCheckingUser {
  var %usertrig = $1
  var %i = $hget(PSL_CRC,0).item
  while (%i) {
    if (%usertrig == $gettok($hget(PSL_CRC,%i).data,4,9)) return $true
    dec %i
  }
  return $false
}

alias -l CheckCheckingTrigger {
  var %trigger = $1
  var %i = $hget(PSL_CRC,0).item
  var %count = 0
  while (%i) {
    if (%trigger == $gettok($hget(PSL_CRC,%i).data,2,9)) inc %count
    dec %i
  }
  return %count
}


/* checks if a Collection Leech is doing something like Constructing a File or background checking
* @return Boolean
*/
alias -l IsLeechBusy {
  var %trigger = $1
  if ($AccessDB(COLL,? $+ %trigger,CONSTRUCT)) return $true
  if ($CheckCheckingTrigger(%trigger)) return $true
  return $false
}

;; starts a dll call after the Value in PSL_CRC has been set (values taken from there)
alias -l dispatchdll {
  var %idx = $1
  var %wait = $hget(PSL_CRC,0).item
  var %run = $hget(PSL_CRC_I,RUN)
  var %dllrun = $PSL_CheckDllRun(pserve.dll)
  if (%psl.debug) echo 13 -set Waiting %wait crc tasks - Running# %run Dll: %dllrun  -> %idx
  if ((%run) && (!%dllrun)) unset %run
  if ((%dllrun) && (!%run)) {
    .timerdlltimeout -o 1 1 dispatchdll 0
    return
  }

  if ((%run) || (!%wait)) { .timerdlltimeout off |  return }
  if (%idx == 0) %idx = $hget(PSL_CRC,1).item
  var %data = $hget(PSL_CRC,%idx)
  var %tcid = $gettok(%data,1,9)
  ; echo -set >> THIS NEEDS TO BE IN %tcid and we are $cid
  scid %tcid

  var %fromd = $left($gettok(%data,5,9),2) , %tod = $left($gettok(%data,10,9),2)
  var %filesize = $iif(%fromd == %tod,0,$gettok(%data,8,9)) , %freebytes = $disk(%tod).free , %trigger = $gettok(%data,2,9)
  ;  echo -set Trying to move %filesize to %freebytes  ( %fromd -> %tod ) for a leech of %trigger
  if (%filesize > %freebytes) {
    ;; NOT ENOUGH FREE BYTES ON TARGET DRIVE
    ;stop leech
    PSL_LeechStop %trigger STOP $true
    echo -at Leech of trigger %trigger was stopped because the target drive %tod ran out of free space ( %freebytes < filesize %filesize ) DEBUG: %data
    ;delete hash data
    hdel PSL_CRC %idx
    .timer 1 0 dispatchdll 0
    return
  }
  set %ps_crctime $uptime(mirc)
  ; if a dll will ever die (never return) the value is cleared by mirc after 300 sec / 5min
  hadd -mu900 PSL_CRC_I RUN %idx
  .timerdlltimeout -o 1 902 dispatchdll 0
  var %lf = $getlogfile(%idx)
  if ($exists(%lf)) {
    .timer 1 0 CallBackEndCrcCheck %idx 
    echo -set logfile %lf was already there. skipping dll start -> directly calling CallBack now for %idx
  }
  else {
    var %from = $gettok(%data,5,9) , %to = $gettok(%data,10,9)
    if ((%from) && (%to) && ($file(%from)) ) {
      $dllcall($PS_ProgramDir $+ pserve.dll", CallbackEndCrcCheck %idx , SortFile, $qt(%from) $qt(%to) $qt(%lf) $base($gettok(%data,9,9),10,16))
      if (%psl.debug) echo $ps_k -set crccheck started %idx  8,1--> %from 8,1--> %to
    }
    else {
      hdel PSL_CRC %idx
      .timer 1 0 dispatchdll 0
      return

    }
  }
}

alias -l getlogfile {
  var %id = $1
  ;  return C:\temp_ $+ %id $+ .log
  return $remove($PS_TmpDir(getlogfile),") $+ PSL_Ctrl_ $+ %id $+ .txt
}


alias CallbackEndCrcCheck {
  var %idx = $1
  hdel PSL_CRC_I RUN
  var %hdata = $hget(PSL_CRC,%idx)
  tokenize 9 %hdata
  var %tcid = $1 , %trigger = $2 , %nick = $3 , %usertrig = $4 , %filename = $5 , %targetname = $6 , %targetpath = $7 , %targetsize = $8 , %targetcrc = $9 , %targetfile = $10 
  ; echo -set callback %idx got data for %trigger from %nick ( %usertrig ) . Source = %filename -> %targetname in %targetpath  with %targetsize bytes and crc of %targetcrc

  var %lof = $getlogfile(%idx)
  if (!$exists(%lof)) {
    if (%hdata) {
      .timer 1 $rand(5,10) dispatchdll %idx
      PSL_Log 1 missing logfile %lof - dll call %idx failed restart in 5-10 seconds usertrig: %usertrig - %filename
    }
    return 
  } 
  var %took = $calc($uptime(mirc) - %ps_crctime)
  unset %ps_crctime
  ; echo -set DEBUGnotice - index %idx data deleted.. 
  hdel PSL_CRC %idx
  ;; start the next one now
  .timer 1 0  dispatchdll 0
  var %sortresult = $read(%lof,1)
  var %sortcode = $gettok(%sortresult,1,32)
  echo $ps_k -set --> sorted5 %targetfile 11( $+ $longfn(%targetfile) $+ )12 $gettok(%sortresult,2-,32) in %took ms 12ID: %idx
  if (%psl.debug) {
    window @sortlog
    var %filesize = $file(%targetfile)
    if ((%filesize > 2097152) || ($gettok(%sortresult,1,32) !== 0))  echo $iif($PSE_GetPartname(%targtfile).ispart,10,13) -t @sortlog --> sorted5 %targetfile 12 $gettok(%sortresult,2-,32) 7 $+ $qt(%usertrig) 3in %took ms $iif(%filesize > 2097152,04 $+ $bytes(%filesize,m).suf ,$null) 12ID: %idx
  }

  var %se = $file(%filename)   , %te = $file(%targetfile)


  noop $Saferemove($+(",%lof,")).nobin
  ;; sometimes the file is still sorted and an error is returned since the original is gone (for such rare - and 
  ;; reason unknown - events the file is processed if the original is gone and the target is there)
  if ( (%sortcode == 0) || ((%se == 0) && %te) ) {
    ; crc check OK (clear the data)
    noop $IsExpectedTransfer(%nick,%filename,.)
    ;; usertrig can be $false for large file construction
    if (%usertrig) {
      setUserFree %usertrig
      ;; set the exclusive right for xx seconds to this trigger.. so the user is not used in the mean time.. 45 seconds are the blackout time while doing !WHEREIS lookup
      PSL_SetLock %usertrig %trigger 50
      noop $ClearFileFromLeech(%trigger,$+(%targetpath,%targetname),%usertrig)
    }
    ;since the sort was ok.. our file is now at %targetfile
    %filename = %targetfile

    RefreshLeechDialog %trigger
    var %endfilename = %targetname

    ;; fill the buffer with this trigger
    noop $BroadCastBuffer(LEECHINFO,%trigger)

    if ($PSE_GetPartname($nopath(%filename)).ispart) {

      ;      var %orig = $nofile(%filename) $+ $PSE_GetPartName(%targetname).getName
      var %orig = $left($PSL_TempPathForTrigger(%trigger),-1) $+ %targetpath  $+ $PSE_GetPartName(%targetname).getName

      var %cfile = $getPartControlFile(%orig)
      var %cfile2 = $getPartControlFile(%orig).new

      var %totalsize = $PSE_GetPartName($nopath(%filename)).getSize

      if ((%psl.constructmode) && (%psl.constructmode == download)) {
        var %partnum = $PSE_PutInPart(%filename,%orig)
      }
      else  {
        var %partnum = $PSE_GetPartName($nopath(%filename)).getPart
      }
      if (%partnum > 0) {
        noop $partcontrol(%cfile,%partnum)
        noop $partcontrol2(%cfile2,%partnum,S,%targetcrc)
        ;; here change somewhere the number of complete parts available
        $PSTC_SetLastDL(%trigger,$ctime)

        ; check if all parts are here
        var %partsizedef = $CreateFilePartFromFile().partsize
        var %totalparts = $calcparts(%totalsize,%partsizedef)
        var %maximalpart = $getmaxpartcount(%cfile)
        var %completeparts = $getcompletepparts(%cfile)
        echo $ps_k -set %completeparts parts downloaded of a total of %totalparts parts ( $+ $round($calc(100 * %completeparts / %totalparts),2) $+ $chr(37) $+ ) with first %maximalpart consecutive parts of $nopath(%orig)
        writeini -n $PSL_FetchConstant(PartSum) %trigger $replace(%targetpath $+ $PSE_GetPartName(%targetname).getName,$chr(32),?) %completeparts / %totalparts 
        if (%maximalpart == %totalparts) { 
          var %dest = $PSTC_GetPath(%trigger)
          %dest = $left(%dest,-1) $+ %targetpath $+ $PSE_GetPartName(%targetname).getName

          ;  var %crc = $AccessDB(COLL,%trigger,BIGCRC_ $+ $makehashkey(%targetpath $+ $nopath(%orig)))
          var %crc = $gettok( $gettok( $AccessDB(COLL,? $+ %trigger,BIGCRC_ $+ $makehashkey(%targetpath $+ $nopath(%orig))) ,1,8) ,2,9)

          echo -s going to sort the COMPLETE file7 %orig to the triggers location ->5 %dest crc:13 $base(%crc,10,16)


          noop $PS_MakePath($nofile(%dest))
          %dest = $shortfn($left($nofile(%dest),-1)) $+ $nopath(%dest)
          ;  if ((%psl.constructmode) && (%psl.constructmode == endonly))
          var %id = $ticks $+ _A $+ $rand(1,999)
          noop $PSE_ConstructAllParts(  $file($left($nofile(%filename),-1)).shortfn , $PSE_GetPartName(%orig,%totalsize) , %orig , CallBack_ReconstructEnd %id ).remove

          ;; CLEANUP the controlfile AND  Cleaning up the part files is done while they are written
          ;;;   noop $findfile( $nofile(%filename) , $PSE_GetPartName(%orig,%totalsize) , 0 , saferemove $1- )
          noop $saferemove(%cfile).nobin

          ;setuserbusy %usertrig %trigger
          var %usertrig = $false

          hadd -m PSL_PROC_ $+ %id data $+($cid,$chr(9),%trigger,$chr(9),%nick,$chr(9),%usertrig,$chr(9),%orig,$chr(9),$nopath(%orig),$chr(9),%targetpath,$chr(9),%totalsize,$chr(9),%crc,$chr(9),%dest)
          hadd -m PSL_PROC_ $+ %id trigger %trigger
          echo -set Trying to construct03 %orig $+  (id %id $+ ), then Dispatching DLL to check crc for 8,1COMPLETED FILE: size %totalsize from trigger %trigger

          noop $AccessDB(COLL,%trigger,CONSTRUCT,++)
          return
        }
        ; else not all parts present
      }
      else {
        PSL_Log 1 Error while trying to insert a part file %filename -> %orig  (we hoped this never happens)
      }
    }
    else {
      ;increase count of collection
      PSTC_IncFileCount %trigger
      var %filesize = %targetsize
      $PSTC_IncByteCount(%trigger, %filesize)

      if (%usertrig) {
        var %bytes = $AccessDB(USER,%usertrig,DLBYTES)
        var %bytes = $calc(%filesize + %bytes)
        var %res = $AccessDB(USER,%usertrig,DLBYTES,%bytes)

        var %dlcount = $AccessDB(USER,%usertrig,DLFILES,++)
        var %res = $PSL_TreeOp(add,UserInfo %usertrig Downloaded_Files,%dlcount)
        var %res = $PSL_TreeOp(add,UserInfo %usertrig Downloaded_Bytes,$bytes(%bytes,m).suf)
      }
      PSL_Log 5 $iif(%usertrig,$ifmatch,No-User) :sorted the ok file5 %targetfile for Trigger7 %trigger
    }
    .timer 1 $GetGetDelay(%usertrig) RequestAFile %trigger
    noop $ProcessDownloadedFile(%trigger,%targetfile, %usertrig, %targetpath $+ %endfilename)
  }
  elseif (%sortcode < 4) {
    if (!%te) copy $qt(%filename) $qt(%targetfile)
    window -a @problem
    echo 4 -t @problem an unrecoverable error ( s: %se t: %te ) occured while trying to sort the file %filename to its destination %targetfile 7 %sortresult 

    PSL_Log 1 unrecoverable error ( s: %se t: %te ) occured while trying to sort the file to its destination %sortresult 

    noop $FreeUserFromEverything(%nick)
    .timer 1 11.1 RequestAFile %trigger

  } 
  else {
    echo -set Failed to sort file: %sortresult 
    ; echo the received File has not the correct crc
    ; done here: remove the file from this users have or it will come over and over again
    PSL_Log 3 Received file $+(%targetpath,%targetname) with a wrong CRC (exp: %targetcrc ).. unsetting it from user %usertrig Collection: %trigger
    ; FreeUser will remove the lock of the file AND the user
    noop $FreeUserFromEverything(%nick)
    .timer 1 11.1 RequestAFile %trigger
    if ($PSE_GetPartname($nopath(%filename)).ispart) {
      echo -set Wrong part crc received .. deleting file and starting again.
      if ($exists(%filename)) noop $saferemove(%filename).nobin
    }
    else {
      ;; since this is not a part we can mark it as not available on the target
      if ($AccessDBList(COLL,%trigger,COMPLETE,%usertrig,T)) SetUserToNeedHavelist %trigger %usertrig
      noop $MarkHavingSingleFile(%trigger,%usertrig,$+(%targetpath,%targetname),%targetsize,wrong)
      ;; check if the file is a big one that needs repair
      if ($file(%filename).size > 2000000) {  
        var %target = $AutoSortPar2Dir(%trigger,$PSE_GoodCrc(%targetcrc,$true),%targetsize)
        var %targetfile = %target $+ $nopath(%filename) $+ "
        if (!$file(%targetfile)) {
          .rename $+(",%filename,") %targetfile
          echo $ps_n -set ---> Bad CRC32 File moved to $+ $ps_kh %targetfile
          ;;;; we want to remove the file from leech so its not leeched again
          var %res = $ClearFileFromLeech(%trigger,$+(%targetpath,%targetname),%usertrig)
          write $+(",$remove($nofile(%targetfile),"),Request.txt") ctcp %nick !PSPAR2 %trigger $PSE_GoodCRC(%targetcrc,$true) %targetsize %targetpath $+ %targetname
          ctcp %nick !PSPAR2 %trigger $PSE_GoodCRC(%targetcrc,$true) %targetsize %targetpath $+ %targetname
        }
        ; files larger than 1MB are delete to recycle bin if this option is on, smaller files are just deleted.
        else       if ($exists(%filename))  noop $saferemove(%filename)
      }
      ;; or just a small file we want to request again
      else       if ($exists(%filename))  noop $saferemove(%filename)
    }
  }
}


alias CallBack_ReconstructEnd {
  var %pid  = $1

  var %data = $hget(PSL_PROC_ $+ %pid,data)
  var %trigger = $hget(PSL_PROC_ $+ %pid,trigger)

  var %id = $hget(PSL_CRC_I,IDX)
  inc %id
  hadd -m PSL_CRC_I IDX %id

  ; important here the cps and resume data are reset to 0, so it will not be counted twice in the stats

  hadd -m PSL_CRC %id %data
  echo -set Construction of id3 %pid done, Starting DLL CRC check id5 %id
  dispatchdll %id
  hfree PSL_PROC_ $+ %pid
  noop $AccessDB(COLL,%trigger,CONSTRUCT,--)
}

on *:GETFAIL:*:{
  ;  psecho 12
  PSL_Log 9 I failed to get the file $filename from $nick bytes: $get(-1).rcvd $get(-1).resume seconds: $get(-1).secs

  if (.csv isin $nopath($filename)) {
    var %nick = $nick
    var %file = $nopath($filename)
    var %usertrig = $FindBestMatchingUserTrig(%nick) 
    var %data = $IsCSVExpected(%usertrig ,%file,.)
    if (%data) {
      var %cid = $gettok(%data,1,9)
      if (%cid) scid %cid
      ;_AOFF_ psecho 6 We found something for the Incoming CSV: %file from %nick (aka: %usertrig ) >> %data : FIlename: $filename
      var %trigger = $gettok(%data,2,9)

      var %failcount = $AccessDB(COLL,%trigger,FAILCSV_ $+ %usertrig,++)
      if (%failcount > 5) var %res = $AccessDBList(COLL,%trigger,NOCSV,%usertrig)
      .timer 1 11.1 RequestACsvFile %trigger
      saferemove $filename
    }
  }

  if (_HAVE_ isin $nopath($filename)) {
    var %usertrig = $FindBestMatchingUserTrig($nick)
    var %re = $gettok($AccessDB(USER,? $+ %usertrig,WAITHAVE),1,8)
    var %cid = $gettok(%re,1,9)
    var %trigger = $gettok(%re,2,9)
    if (%cid) scid %cid

    if (%trigger isin $nopath($filename)) {
      var %usertrig = $EndOfFileTransferFromUser($nick,fail)
      saferemove $filename 
      PSL_Log 3 Failed transmission of HAVElist for %trigger . $filename << %usertrig . Re-requesting
      var %lastcmd = $AccessDB(USER,%usertrig,LASTCMD)
      ; replace the current user nick name with current (it may have been changed)
      %lastcmd = $puttok(%lastcmd,$nick,2,32)
      ;; this will run eternaly until the timeout is triggered
      SetUserBusy %usertrig %trigger
      if (%lastcmd) .timer 1 11.1 SendToTarget %lastcmd
    }
  }
  else {
    var %defdir = $getdir($nopath($filename))
    if (%defdir == $nofile($filename)) {
      echo -set --> Unexpected file failed: $filename
      if ($file($filename) < 1000000) saferemove $filename
    }
    else {

      var %data = $IsExpectedTransfer($nick,$filename,.)
      if (%data) {
        if ($gettok(%data,1,9) !== $cid) scid $gettok(%data,1,9)
        PSL_Log 9 Data for failed Transfer found %data

        var %usertrig = $EndOfFileTransferFromUser($nick,fail)
        var %method = $AccessDB(USER,%usertrig,METHOD,.)
        var %pskilled = $false
        noop $PSST_RecordGet($nick,$gettok(%data,2,9),%method,-1,%pskilled)

        var %res = $PSL_TreeOp(del,Leech $gettok(%data,2,9) Targets %usertrig File)
        var %res = $PSL_TreeOp(del,Leech $gettok(%data,2,9) Targets %usertrig Status)
        .timer 1 11.1 RequestAFile $gettok(%data,2,9)

        ;_AOFF_ psecho We have gotten the following data for failed $filename : %data
        var %res = $MarkActionForCollectionfile($gettok(%data,2,9),$+($gettok(%data,4,9),$gettok(%data,3,9)),C,%usertrig)

        PSL_SetLock %usertrig $gettok(%data,2,9) 60

        var %size = $file($filename).size
        if (%size > 150000) {
          %size = %size - 100000
          echo $ps_n -st --> Truncating incomplete file $filename to %size bytes to eliminate bad transfered data
          btrunc $qt($filename) %size
        }
        else $saferemove($filename).nobin
      }
    }
  }
}

on *:DCCSERVER:Send:{
  ;_AOFF_ psecho 8,1 DCCSERVERACTION ::::::: $1- .. $nick .. $filename  ( $address ) -> size? $get(-1).size
  var %file = $get(-1).file
  var %res = $HandleIncomingFileTransfer(%file,$get(-1).size,$nick,$address,peer2peer)
  var %reqcounter = $AccessDB(GLOB,.COUNTER,FSERVE_PORT,0)
  if ($window(@pslporterror)) window -c @pslporterror
}

ctcp *:DCC SEND *:?:{
  ;  echo 7 -s Received from %nick this: $1- 
  var %file = $3 , %filesize = $6 , %nick = $nick
  var %res = $HandleIncomingFileTransfer(%file,%filesize,%nick,$gettok($address,2,64),network)
}


on *:SIGNAL:AUTOLEECHSTART: {
  var %trigger = $1 , %network = $2 , %chan = $3 , %priority = $4
  var %ournet = $PS_Network
  if (%network == %ournet) return 
  var %config = $PSL_FetchConstant(LinkControl)
  var %count = $ini(%config,%ournet,0) 
  ;  echo @info I just got a signal in %ournet that there is a leech start of %trigger in %network and channel %chan -> check %config >  %count
  while (%count) {
    var %pattern = $ini(%config,%ournet,%count)
    if (%pattern iswm %trigger) {
      ;   echo @info > matched %pattern ( %trigger ) 
      if (!$PSL_isLeeched(%trigger)) {
        var %startchan = $readini(%config,%ournet,%pattern)
        ;  echo @info checking if $Me is in chan %startchan
        if ($me ison %startchan) {
          ;   echo @info > %ournet -> %count found config %pattern -- %startchan <4this would be a start
          echo 13 %startchan Leech Linker is starting manual (!L) leech for %trigger (set priority to %priority $+ )
          PSL_Leech %trigger %startchan noreg
          PSL_SetPriority %trigger %priority
        }
      }
    }
    dec %count
  }

}


on *:SIGNAL:PSGotWhereisReply: {
  var %nick = $1
  ; number of fields: $numtok($2-,58) ==> 27
  tokenize 58 $2-
  if ($1 !== @WHEREIS) return

  ;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;; Check the reply for sanity


  if (.csv isin $14) {
    if (!$PSTC_GetRawVar($3,setsizetag)) {
      if ($regex($3,/DVD(\d+)/i)) {
        var %num = $regml(1)
        if ($regex($14,/DVD\-?(\d+)/i)) {
          if ( $calc($regml(1)) != $calc(%num) ) {
            msg %nick Hello, %nick $+ ! You seem to have setup a DVD Trigger: $3 with a csv $14 that is wrong. Your csv seems to fit to DVD# $regml(1) while the trigger is DVD# %num
            return
          }
        }
        else {
          msg %nick Hello, %nick $+ ! You seem to have setup a DVD Trigger: $3 with a csv $14 that is 4_NOT_ a DVD csv, please check if your Trigger is setup with the correct csv.
          return
        }
      }
    }
  }
  else {
    ;    echo -set User %nick has a bad whereis reply $1-
    return
  }


  ;;;;;;;;;;;;;;;;;;
  ;;;;;;;;;;;;;;;;;; Process the reply

  if (($28 == $null) && $getsplitFileChannelSetting($26)) {
    ; echo -set ignoring %nick with his/her data $1- because of an incompatible reply format and PARTS leech is on in $26
    return
  }

  if (($5 == 0) && (!$28)) return
  if (($7 !== BTSeed) && ($7 !== ON) && ($7 != LOADED)) return
  if (!$AccessDB(COLL,$3,CHAN)) return
  var %update = $AccessDB(COLL,$3,UPDATE)
  if (!%update) return
  var %ping = $ctime - %update
  var %WINDOW = $getWindowName(WHEREIS,$3)
  if ((%ping > 45) && (!$window(%WINDOW))) return

  ; temp disable of complete leech targets to test havelists
  ;  if ($5 == $6) {
  ;    echo -set ignoring $25 for $3 because $5 == $6 which is his count.
  ;    return
  ;  }
  ; end 

  noop $AccessDB(COLL,$3,SEENCOUNT_ $+ $25,$calc($5))

  if (!$window(%WINDOW)) window -hl -t16,32 %WINDOW
  ; format Nick|!Trigger|Status|Filecount|CsvCount|csvname|crc32ofcsv|AvgSpeed(24)|SendSpeed|sends(15)|MaxSends|Queue|MAxQueue|CreditNoQueue|Credits
  var %data = $+(%nick,$chr(9),$25,$chr(9),$7,$chr(9),$5,$chr(9),$6,$chr(9),$14,$chr(9),$base($13,16,10),$chr(9),$24,$chr(9),$gettok($23,1,47),$chr(9),$15,$chr(9),$17,$chr(9),$18,$chr(9),$20,$chr(9),$29,$chr(9),$30)
  var %lines = $line(%WINDOW,0)
  while (%lines) {
    if ($gettok($line(%WINDOW,%lines),2,9) == $25) break
    dec %lines
  }
  if (%lines) {
    var %c = $line(%WINDOW,%lines).color 
    rline $calc(%c % 16 + 1) %WINDOW %lines %data
  }
  else        aline %WINDOW %data
  ;; REGISTER THE NICK AND TRIG VICE VERSA
  RegisterNickToTrig %nick $25
  ; Store the User (Trigger) in the Collections ($3) COMPLETE List  (IF count==csvcount AND my csv is his)
  var %mycrc = $AccessDB(COLL,$3,CSVCRC)
  var %mycsvcount = $PSTC_GetCSVCount($3)
  if (!%mycrc) {
    ;    %mycrc = $base($crc($FetchSettingFromTrig($3,csv)),16,10)
    %mycrc = $base($crc($PSTC_GetCSV($3)),16,10)
    var %res = $AccessDB(COLL,$3,CSVCRC,%mycrc,300)
  }
  if ( ($5 == $6) && (%mycsvcount == $6) && (%mycrc == $base($13,16,10)) ) {
    ; now we are sure that this user has everything we could ever need
    var %res = $AccessDBList(COLL,$3,COMPLETE,$25)
    var %res = $AccessDBList(COLL,$3,NEEDHAVE,$25,r)
    var %res = $AccessDBList(COLL,$3,RUNDRY,$25,r)
    ;_AOFF_ psecho ---> user $25 has collection $3 complete because my crc is %mycrc (= $base(%mycrc,10,16) ) and target has $13
  }
  else {
    var %lastcount = $AccessDB(USER,$25,$+(HAVECOUNT_,$3))
    var %lastcsvcrc = $AccessDB(USER,$25,$+(REMCSVCRC_,$3))
    var %lastctime = $AccessDB(USER,$25,$+(LASTDL_,$3))


    ;_AOFF_ psecho 8,1 LASTCOUNT : %lastcount of user $25 .. now he has $5 and 6 CRC: %lastcsvcrc and now $13
    if (((%lastcsvcrc) && (%lastcsvcrc !== $13)) || ( (%lastcount > 0) && (%lastcount > $5) ) )  {
      ;_AOFF_ psecho CRC of CSV has been changed $25 $3
      PSL_Log 4 User $25 changed csv of $3  .. has now $13 and had %lastcsvcrc before. Count: $5 OldCount: %lastcount  6Purge of HAVELISTDATA required
      SetUserToNeedHavelist $3 $25
    }
    elseif ( ( (%lastcount > 0) && (%lastcount < $5) ) || ( (%lastctime) && (%lastctime != $28) ) ) { 
      ;clear the HAVEHAVELIST FLAG and everything else BUT NOT the old havedata, since the CRC is still the same
      PSL_Log 4 User $25 changed count of $3  .. has now $5 and had %lastcount . Last leech $28 and had %lastctime . No Purge of his HAVELISTDATA
      SetUserToNeedHavelist $3 $25 1
      ;_AOFF_ psecho 8,1 USER $25 's HAVEHAVE Flag was cleared because %lastcount does not match his current count which is now: $5
    } 
    elseif ( $AccessDBList(COLL,$3,COMPLETE,$25,T) ) {
      ; echo -set DEBUG-INFO: user $25 has had Collection $3 complete before, but not any more. $5 =! $6 - lastcount: %lastcount 
      SetUserToNeedHavelist $3 $25
    }
    else {
      ;; just plain and simple. this user needs to send a havelist 
      var %res = $AccessDBList(COLL,$3,NEEDHAVE,$25)
    }
  }

  ;; MUST REMOVE THIS AFTER TEST -->   SetUserToNeedHavelist $3 $25

  ; remember the last seen crc 
  var %res = $AccessDB(USER,$25,$+(REMCSVCRC_,$3),$13)
  var %res = $AccessDB(USER,$25,$+(LASTDL_,$3),$28)


  ;optional: in case someome responds and has an TIMEOUT FLAG, clear it ! 
  ;var %block = $AccessDB(USER,%user,BLOCK)
  ;if (%block == TIMEOUT) %block = $AccessDB(USER,%user,BLOCK,.)


}

;;; UPDATE MESSAGES FROM CHANNELS

; Catch the Trig News
on *:TEXT:*Trig News10*:*:{
  if ($regex($strip($1-),/New (\S+) CSV (.+) \(([^\()]+)\) File: (.+) Count: (\d+) Size: (\d+) CRC: ([a-fA-F\d]+)/i)) {
    var %statename = $regml(1)
    var %trigger = $regml(2)
    var %name = $regml(3)
    var %csvfile = $regml(4)
    var %count = $regml(5)
    var %size = $regml(6)
    var %crc = $base($regml(7),16,10)
    ; $1=channel $2=nick $3=triggername $4=(Final|Ongoing|Re-Burn) $5=count $6=size $7=crc $8- =csvname
    if ($CheckCSVUpdateAllowed(%trigger,$chan)) .signal PSL_Trig_NewsCatch $chan $nick %trigger %statename %count %size %crc %csvfile
    return
  }
}

;  ESPDVD7 10(03Euro Sex Parties DVD0710) CSV:07 04Final 10Count:12 506610/045069 10(043 10missing file(s)/04 30505 10bytes)
on *:TEXT:6Trig Status10?*:*:{
  if ($regex($strip($1-),/Trig Status: (\S+) .+ Count: (\d+)\/(\d+)/)) {
    var %trigger = $regml(1) , %c1 = $regml(2) , %c2 = $regml(3) 
    var %cmy = $PSTC_getcount(%trigger)
    echo $chan Checking %trigger with count %c1 - My own Count is %cmy - Message was sent by $nick
    if (%c1 > %cmy) CheckLeechInviteAndSignal %trigger $chan $nick 1
  }
}



on *:TEXT:@PS*:#:{
  var %type = $right($1,-3) , %usertrig = $2 , %msg = $3-
  ; if (%type == userinfo) echo -t $color(join) $chan * User $nick is $gettok(%msg,1,9)
  RegisterNickToTrig $nick %usertrig

  if (%type == leechinfo) {
    var %count = $numtok(%msg,32)
    while (%count) {
      var %trigger = $gettok(%msg,%count,32)
      dec %count
      if ($AccessDB(GLOB,TRIGS,$nick)) {
        var %usertrig = $ifmatch
        if ($PSL_isLeeched(%trigger)) {
          noop $AccessDBList(COLL,%trigger,HASLEECHED,%usertrig)
        }
      }
    }
  }
  elseif (%type == leechinvite) {
    var %trigger = $gettok(%msg,1,32)
    if ($nick !isreg $chan) CheckLeechInviteAndSignal %trigger $chan $nick 1
  }
  elseif (%type == leechcomplete) {
    var %trigger = $gettok(%msg,1,32) , %count =  $gettok(%msg,2,32)
    ;echo 9 -t $chan * $nick completed %trigger at %count files. $iif($PSTC_getcount(%trigger),I have $ifmatch and leeching: $PSL_IsLeeched(%trigger),$null)
    if (%count > $PSTC_getcount(%trigger)) CheckLeechInviteAndSignal %trigger $chan $nick 2
  }
  elseif (%type == serverinfo) {
    var %server = $gettok(%msg,2,32) , %port = $gettok(%msg,4,32)
    PS_AddServer %server %port
  }

}

;; @param mode 1=manual 2=autodetected_oncomplete
alias -l CheckLeechInviteAndSignal {
  var %trigger = $1 , %channel = $2 , %nick = $3, %mode = $4
  if (%ps.noinviteleechstart) return 
  if ($PSTC_GetCSVCount(%trigger)) {
    var %csvcount = $ifmatch
    var %Mycount = $PSTC_GetCount(%trigger)
    if (%mycount < %csvcount) {
      if ($PSTC_GetStatus(%trigger).check = ON) {
        if (!$PSL_isLeeched(%trigger)) {
          if (!$PSTC_GetBTState(%trigger)) {
            echo -set Leech Invitation is possible for %trigger
            .signal PSINVITELEECH %trigger %channel 4
          }
        }
      }

    }
  }
}

ON *:SIGNAL:PSINVITELEECH:{
  var %trigger = $1 , %chan = $2 , %pri = $3
  if ( $AccessDB(COLL,%trigger,PRIORITY) ) {
    var -s %oldpri = $1
    var -s %newpri = $int($calc(%oldpri / %pri + 1))
    noop $AccessDB(COLL,%trigger,PRIORITY,%newpri)
    echo -set Priority of %trigger has been altered from %oldpri to %newpri
  }
}



on *:SIGNAL:PSL_Trig_NewsCatch:{
  var %channel = $1 , %nick = $2 , %triggername = $3 , %namedstate = $4 ,  %csvcount = $5 , %size = $6 , %crc = $7 , %csvname = $8-

  ;  var %name = $signal $+ _ $+ %triggername
  ;  if (!$timer(%name)) [ .timer $+ [ %name ] ] 30 60 .signal -n $signal $1-

  if ((%nick !isvoice %channel) && (%nick !isop %channel)) return
  var %cf = $PSL_FetchConstant(ControlFile)
  var %section = SETTINGS
  var %key = news- $+ %triggername
  var %currentcsv = $PSTC_GetCSV(%triggername)
  if (($null !== %currentcsv) && (!$PSL_CsvIsBetter(%currentcsv,%csvname))) {
    ; echo -sat new csv %csvname is not better than the current setup %currentcsv
    return
  }
  ; echo -sat --> Current csv: %currentcsv
  if ((%psl.nosmartchecker == yes) && %currentcsv) {
    .timer 1 $rand(30,120) ctcp %nick !PSGET %triggername CSV
    return
  }
  var %old = $readini(%cf,n,%section,%key)
  if (%Old) {
    var %oldtagcsv = $gettok(%old,5,9)
    ;echo -sat checking old value to be overwritten... %old  > CSV:7 %oldtagcsv
    if (!$PSL_CsvIsBetter(%oldtagcsv,%csvname)) {
      ;echo -sat new csv is already tagged by a better one or the same as %csvname
      return
    }
  }
  ;  echo 4 -sat Going to write to %cf now section %section key %key
  PSL_Log 4 Signal of TriggerUpdate.. in %channel from %nick about %triggername --> %csvname (count: %csvcount $+ ) * $1-

  writeini -n %cf %section %key $+(%triggername,$chr(9),%channel,$chr(9),%nick,$chr(9),%csvcount,$chr(9),%csvname)
}

on *:SIGNAL:PAR2RECEIVED: {
  var %trigger = $1 , %crc = $2 , %size = $3 , %par2file = $4-
  echo -sat Trying to repair a file for %trigger : %par2file
  if (OK == $PSL_StartPar2(%par2file)) {
    .timer -o 0 15 CheckPar2Finished %trigger %crc %size %par2file
  }
}




;; ALL incoming text traffic must be routed over a new TextHandler to make the input source variable (notice, data port, chat)..
; INSTEAD OF --> on *:SIGNAL:PSNOTICE:{
; @return Bool if the text WAS relevant for a running leech. pserve will then not display it.
alias PSL_CheckRelevantForLeech {
  var %nick = $1 , %onoticetext = $2-

  if (%psl.debug == on)  echo 12 -set $1 > NOTICE: %onoticetext

  var %noticetext = $strip(%onoticetext)

  if (*If you are using !PSSERV as leech method you can IGNORE THIS MESSAGE* iswm %noticetext) {
    if ($PS_GlobalOption(get,leech.reqtype).network != network)  var %used = $true
  }

  ;;; I am now sending file kel022HBM_136183048.jpg to your ip:port address
  if (*I am now sending file*to your ip:port address* iswm %noticetext) {
    var %used = $true
    if ($regex(%noticetext,/sending file (.+) to your ip:port address (\S+)/i)) {
      var %file = $regml(1) , %ip = $regml(2)
      var %data = $IsExpectedTransfer(%nick,%file)
      ;  echo -set found %data for7 %nick and7 %file
      if (%data) {
        var %trigger = $gettok(%data,2,9)
        var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
        var %Oldtime = $timer($PSL_Timer(%usertrig $+ _AWAIT).name).secs
        var %new = 23
        ;; check if old timer was REALLY there at all.. do not create a new one
        if (%oldtime > 0) {
          PSL_Log 6 User %nick is sending %file of trigger %trigger to our port now! set our timeout for this user from %oldtime to %new seconds. 
          PSL_Timer %usertrig $+ _AWAIT %new OnTimeoutFromRequest %usertrig
          PSL_Timer %usertrig $+ _AWAIT2 11 PS_Tunnel .direct %nick !PSKILL

        }
      }

    }
  }

  ; > NOTICE: @PSPart:1BDDVD43:\2007-08-16 - Cikita\Video\:6491v1.avi###012JL86I###.part00001:1:DC81C35F:15

  elseif (@PSPart:* iswm %noticetext) {
    var %used = $true
    var %trigger = $gettok(%noticetext,2,58) , %file = $gettok(%noticetext,3,58) $+ $gettok(%noticetext,4,58) , %crc = $base($gettok(%noticetext,6,58),16,10)
    var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
    noop $MarkActionForCollectionfile(%trigger,%file,R,$iif(%usertrig,%usertrig,all),%crc)
    noop $IsExpectedTransfer(%nick,$nopath(%file),%crc).restorecrc
    if (%psl.debug) echo -set -> Reset crc of %file in %trigger to %crc by message from %usertrig
  }

  ; Sorry my sends are full. The file v1054-06.avi is #5 in my send queue, please wait.
  ; The file v1054-06.avi is already in my send queue, please wait.

  elseif (*in my send queue, please wait.* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*in my send queue, please wait.*:?: {
    if ($regex(%noticetext,/The file (.+) is (\S+) in my send/)) {
      var %filename = $regml(1)
      var %pos = $regml(2)
      if ($regex(%noticetext,/Estimated time to wait: (\d+) seconds/)) {
        var %delaytime = $regml(1)
      }
      ;; remove this once we calculate with %delaytime
      else var %delaytime = unknown
      var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
      var %data = $IsExpectedTransfer(%nick,*,*).network
      var %filename = $ReplaceCharsInFileName(%filename)
      var %trigger = $gettok($IsExpectedTransfer(%nick,%filename),2,9)

      var %expected = $iif(%data == %filename,$true,$false)
      if (%expected) {
        ;; marking the user as beeing queued, so it will not timeout
        if (!%pos) %pos = $true
        var %res = $AccessDB(USER,%usertrig,QUEUE,%pos)
        echo -set User %usertrig Flag QUEUE was set to %pos (for %data => %trigger ) -> %res
        var %res = $PSL_TreeOp(add,Leech %trigger Targets %usertrig Status,Queued - %pos - delay: %delaytime => $duration(%delaytime) )

        ;; reset the timer delay 
        PSL_Timer %usertrig $+ _AWAIT 600 OnTimeoutFromRequest %usertrig

        PSL_Log 8 File %filename requested from user %nick ( %usertrig ) was queued. Set flag for queued at7 %pos . Next timeout will re-request the file.

        if (%pos == already) PSL_Log 4 file %filename still queued ( %pos ) at %nick ( %usertrig ) for %trigger $+ . Estimated start at $asctime($calc($ctime + %delaytime),HH:nn:ss)
      }
      var %used = $true
      echo $ps_n -set --> File %filename is queued at %nick for leech of %trigger - %expected - delay: %delaytime => $duration(%delaytime) $ps_kh $+ Expected at $asctime($calc($ctime + %delaytime),HH:nn:ss)
    }
  }

  ;; [06:02:05] -I-nuit_- System is currently busy, try again later.
  ;; [07:55:00] -I-nuit_- System is currently busy, try again later.
  elseif (*System is currently busy*try again later* iswm %noticetext) {
    var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
    .notice $nick Hello, I got a message from your system telling me you dont have enough resources, please open more ports for MIrc!!, this is an automated message sent by the System, so dont reply to me, just fix the problem. Thank You
    if (%usertrig) {
      var %data = $IsExpectedTransfer(%nick,*,*).network
      if (%data) {
        noop $AccessDB(USER,%usertrig,RESENDOK,SYSTEMBUSY,1600)
        echo -set User %usertrig was set to be re-requested
        var %used = $true
        ;; reset the timer delay 
        PSL_Timer %usertrig $+ _AWAIT 60 OnTimeoutFromRequest %usertrig
      }
    }
  }
  elseif (*to you have been Killed* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*to you have been Killed*:?:{
    PSL_Log 9 caught notice : %nick -> %noticetext
    var %used = $true
  }
  elseif (*I have reached my user defined * iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*I have reached my user defined *:?: {
    var %used = $OnUserUnavailableForLeech(%nick,60,%noticetext)
  }

  elseif (*my queue is full with* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*my queue is full with*:?: {
    var %used = $OnUserUnavailableForLeech(%nick,10,%noticetext)
  }

  elseif (*Triggers are OFF* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*Triggers are OFF*:?: {
    var %used = $OnUserUnavailableForLeech(%nick,60,%noticetext)
  }

  elseif (*You must be verified* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*You must be verified*:?: {
    var %used = $OnUserUnavailableForLeech(%nick,30,%noticetext)
  }
  elseif (*exclusively distributing* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*exclusively distributing*:?: {
    if ($regex(%noticetext,/distributing (.+) Until/)) {
      var %triggerlist = $regml(1)
      var %collection = $FreeUserFromEverything(%nick)
      if (%collection)  .timer 1 1 RequestAFile %collection
      var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
      var %i = $numtok(%triggerlist,44)
      while (%i) {
        var %trigger = $gettok(%triggerlist,%i,44)
        dec %i
        if ($PSL_isLeeched(%trigger)) {
          var %tpri = $AccessDB(COLL,%trigger,PRIORITY) , %cpri =  $AccessDB(COLL,%collection,PRIORITY) 
          PSL_Log 4 User %nick / %usertrig is distributing %trigger atm -> user leeched %collection until now ( %tpri -> %cpri )
          var %newpri = %cpri
          if (%tpri < %cpri) %newpri = %trpi
          dec %newpri
          if (!%newpri) %newpri = 1
          ;echo -set will set priority of %trigger to %newpri -> user is now locked to %trigger
          PSL_SetLock %usertrig %trigger 
          noop $AccessDB(COLL,%trigger,PRIORITY,%newpri) 
          var %used = $true
          break
        }
      }
    }
    if (!%used)  {
      noop $OnUserUnavailableForLeech(%nick,10,%noticetext)
      var %used = $true
    }
  }
  elseif (*is OFF or Not Setup* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*is OFF or Not Setup*:?: {
    var %used = $OnUserUnavailableForLeech(%nick,30,%noticetext)
  }
  elseif (There is no * set for * iswm %noticetext) {
    var %used = $OnUserUnavailableForLeech(%nick,60,%noticetext)
  }
  ;;;-xxx_- 10I'm exclusively distributing07 OBJCD61 10Until07 Fri Jun 24 11:34:09 10Please try again in07 22:34:55 10(hrs:min:sec).
  ;;;  -Tacnar- There is no HAVE set for SFCD1

  ;;; -xxxxx_- 10The drive which trigger07 OBJCD63 10is stored on is 4offline10.
  ;; set user to rundry 
  elseif (*The drive which trigger*is stored on is*offline* iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:*The drive which trigger*is stored on is*offline*:?:{
    var %trigger = $gettok(%noticetext,5,32)
    var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
    noop $AccessDBList(COLL,%trigger,RUNDRY,%usertrig)
    if ($FreeUserFromEverything(%nick)) {
      .timer 1 11.1 RequestAFile $ifmatch
      var %used = $true
    }
    PSL_Log 4 User %nick has the trigger %trigger offline 
  }


  ;  Fishman^PS > NOTICE: Trigger: P999CD16 - 20070109 - VIP Lounge Set 04\ viplo04-041.jpg not found
  ; EMPCD10 00165_027_lg.jpg not found
  ; Trigger: DDGCD32 - Extras\DDG Xtreme\2006-03-17 - Girlznboyz - Nadia & Fernando\ 100175_36.jpg not found
  elseif (* not found iswm %noticetext) {
    ;REPLACED: on ^*:NOTICE:* not found:?:{
    if ($regex(%noticetext,/Trigger: (\w+)\s.+\s([^\\]+)\snot found$/)) {
      var %trigger = $regml(1) , %file = $regml(2)
      var %used = $UserFileNotFoundAction(%nick,%trigger,%file)
    }
    elseif ($regex(%noticetext,/(\w+)\s(.+)\snot found$/)) {
      var %trigger = $regml(1) , %file = $regml(2)
      var %used = $UserFileNotFoundAction(%nick,%trigger,%file)
    }
  }
  elseif (*OK updating Count for* iswm %noticetext) {
    if ($regex(%noticetext,/for (.+)/i)) {
      var %trigger = $regml(1)
      if ($PSL_isLeeched(%trigger)) var %used = $true
    }
  }
  /* catch all other notices and put them into a window 
  */
  elseif ($left(%noticetext,1) == @) return

  if (!%used) {
    ;REPLACED: ON ^*:NOTICE:*:?:{
    if (%psl.noticecatcher == on) {
      var %window = @PS_Notices_ $+ $network
      window -r %window
      .timer [ $+ [ %window ] ] 1 30 window -n %window
      echo $ps_h -t %window - $+ %nick $+ - %onoticetext
      var %used = $true
    }
  }
  return %used
}









;; functions to take all steps that are required when a user is not available to be further leeched. @return Bool true if user WAS leeched

alias -l OnUserUnavailableForLeech {
  var %nick = $1 , %blocktime = $2 , %logreason = $3-
  var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
  if (%usertrig) {
    PSL_Log 3 User %nick ( %usertrig ) is unable to be leeched. Info: %logreason 
    var %collection = $FreeUserFromEverything(%nick)
    ; Set User to BLOCKED for %blocktime min
    var %res = $AccessDB(USER,%usertrig,BLOCK,UNAVAIL,$calc(%blocktime * 60))
    if (%collection) {
      .timer 1 11.1 RequestAFile %collection
      echo $ps_i -set --> User %nick is unavailable to be leeched:  $+ $ps_h %logreason
      return $true
    }
  }
  echo $ps_h -set - $+ %nick $+ - %logreason
}

;; functions to take all steps that are required when a user had a file not found. @return Bool true if user WAS leeched

alias -l UserFileNotFoundAction {
  var %nick = $1 , %trigger = $2 , %file = $3
  ;_AOFF_ psecho >>>> NOT FOUND in trigger7 %trigger the file:11 %file --> %nick
  var %data = $IsExpectedTransfer(%nick,%file,.)
  if (%data) {
    var %trigger = $gettok(%data,2,9)
    var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
    var %res = $FreeUserFromEverything(%nick)
    SetUserToNeedHavelist %trigger %usertrig
    ;    var %res = $MarkHavingSingleFile(%trigger,%usertrig,$+($gettok(%data,4,9),$gettok(%data,3,9)),$gettok(%data,5,9),wrong)
    .timer 1 11.1 RequestAFile %trigger
    PSL_Log 3 Unexpected Situation handled. user %usertrig ( %nick ) had a file not found "4 $1- " -> Set7 %trigger to miss the file6 $+($gettok(%data,4,9),$gettok(%data,3,9))
    PS_Tunnel .ctcp %nick !PSCOUNT %trigger
    return $true
  }
}



;;;
;;; functions for naming stuff
;;;

alias getWTO {
  return 2
}


/** fetches and returns some constants that are cached in case needed. Supported fields yet: LeechLimit (global)
* @return String
* @optparam sub Some types may need a subtype field
*/

alias PSL_FetchConstant {
  var %what = $1 , %sub = $2
  if (%what == ControlFile) {
    if (%sub == glob) var %net = *
    else var %net = $network
    return $PS_ScriptDir $+ Settings\PServeUCPoll_ $+ %net $+ .ini"
  } 
  else if (%what == LeechLimit) {
    var %field = $AccessDB(GLOB,CONST,LeechLimit)
    if (!%field) {
      %field = $PS_LeechLimits(return)
      if ($gettok(%field,1,32) < 0) {
        PSL_Log 1 Error! Leech Limit Calc returned7 %field . Returning fixed value 2 instead and rechecking later. If this is repeated check pserve.exe runtime.
        return 2
      }
      var %res = $AccessDB(GLOB,CONST,LeechLimit,%field,$calc(60*60))
    }
    var %getlimit = $gettok(%field,2,32)
    if (%ps.limit.gets) {
      var %gets = $ifmatch
      if (%gets < %getlimit)  return %gets
    }
    if (%sub == global) return %getlimit
    else return $gettok(%field,1,32)
  }
  else if (%what == NeedVoice) {
    var %val = $AccessDB(GLOB,CONST,NEEDVOICE_ $+ %sub)
    if (!%val) {
      var %val = $iif($PS_Channel(%sub,voice) !== OFF,ON,OFF)
      var %res = $AccessDB(GLOB,CONST,NEEDVOICE_ $+ %sub,%val,3600)
    }
    return %val
  }
  else if (%what == ChannelCheck) {
    var %val = $AccessDB(GLOB,CONST,CHANON_ $+ %sub)
    if (!%val) {
      var %val = $PSC_isPSonInChannel(%sub)
      var %res = $AccessDB(GLOB,CONST,CHANON_ $+ %sub,%val,180)
    }
    return %val
  }
  elseif (%what == ResumeFile) {
    return $PS_ScriptDir $+ Settings\PSLeech_ResumeLeech.ini"
  } 
  elseif (%what == PartSum) {
    return $PS_ScriptDir $+ Settings\PSLeech_PartSummary.ini"
  } 
  elseif (%what == LinkControl) {
    return $PS_ScriptDir $+ Settings\PSLeech_LinkedLeechConfig.ini"
  } 
  else if (%what == PSStatus) return $PS_SetStatus(PreCheck_LeechAllowed,Get)
}


/**
* window names take 2 args, first is type (LEECH or WHEREIS) second the name 
* If the type is empty it returns a list (tabsep) of available names for that type. @return String
* @optparam wname Name of the type, e.g. Collection Trigger
*/
alias -l getWindowName {
  var %typ = $1 , %wname = $2
  if ($prop = global) var %net = *
  else   var %net = $PS_Network
  var %name = $+(@PSL_,%net,_,%typ,_)
  if ($prop || (!%wname)) {
    var %c = $window(0)
    var %len = $len(%name)
    %name = %name $+ $iif($prop == global,%wname,*)
    var %ret
    while (%c > 0) {
      if (%name iswm $window(%c)) {
        if ($prop = global) %ret = $addtok(%ret,$window(%c),9)
        else %ret = $addtok(%ret, $right($window(%c),$calc($len($window(%c)) - %len)),9)
      }
      dec %c
    }
    return %ret
  }
  return $+(%name,%wname)

  ;;;;;
  ;;;;;
  ;;;;;   if the way the name is built is changed  The alias(es)   MoveFilesBetweenWindows    has to be adapted too 

}

/** Starts a PL Timer. Just needed to save the work and naming the Timers always the same way.
* @return void
* @param name name of the Timer
* @param time delay the command is started
*/

alias -l PSL_Timer {
  var %name = $1 , %time = $2 , %cmd = $3-
  var %timername = PSL_ $+ $network $+ _ $+ %name 
  if ($prop == name) return  %timername
  %timername = .timer $+ %timername
  ; echo -set > %timername 4 %time 6 %cmd 
  if (%time == OFF)  %timername off
  else %timername 1 %time %cmd
}

alias -l hasTimer {
  var %usertrig = $1
  return $timer($PSL_Timer(%usertrig $+ _AWAIT).name).com

}

/** Sets the Polling Interval of the LeechController. Can be used to reduce or increase the timer safely on certain events, like PS off or something.
* Should be safe to call as many times as wanted, because it will only start a new timer if not already running
* @return Void
*/
alias -l ActivatePSLLeechController {
  var %delay = $1
  if (!%delay) var %delay = 60
  var %name = PSLControl_ $+ $network
  if ($timer(%name)) return
  timer $+ %name 0 %delay PSL_LeechController
  PSL_Log 2 Controller Timer activated.
}

/* In case something was sent to someone that does not exist anymore. 401 mynick noone-- :No such nick/channel
*/
raw 401:*:{
  ;  PSL_Log 1 RAW-401: $1-
  var %nick = $2
  var %collection = $FreeUserFromEverything(%nick).onlyfree
  if (%collection) {
    PSL_Log 1 Restarting for %collection .
    .timer 1 11.1 RequestAFile %collection
  }
}


raw 439:*:{
  PSL_Log 1 RAW-439: $1-
  ;;1:RAW-439: _Store_ ^Kenny^ Target change too fast. Please wait 80 seconds.
  var %user = $AccessDB(GLOB,TRIGS,$2)
  if (%user) {
    PSL_Log 1 Setting a RESENDOK Flag for $2 user: %user now. (handled on next timeout)
    if ($regex($1-,/Please wait (\d+) seconds/)) {
      ; reset the await timer to 30 sec after the time to wait 
      PSL_Timer %user $+ _AWAIT $calc($regml(1) + 30) OnTimeoutFromRequest %user
    }
    var %r = $AccessDB(USER,%user,RESENDOK,439,1600) 
  }
}


alias -l PARTAction {
  var %nick = $1 , %chan = $2
  if ($AccessDB(GLOB,TRIGS,%nick)) {
    var %user = $ifmatch
    ;    echo -set user %nick parted %chan - checking %user for busyness.. now!
    if ($isUserBusy(%user)) {
      var %file = $IsExpectedTransfer(%nick,*)
      if (%file) {
        var %data = $IsExpectedTransfer(%nick,%file)
        var %coll = $gettok(%data,2,9)
        if ($AccessDB(COLL,%coll,CHAN) == %chan) {
          PSL_Log 7 User %nick ( %user ) left channel %chan .. That was the leech channel of %coll --> should free the user now.
          UserLeft %nick Left %chan
        }
      }
    }
  }
}


/** Function to find the Trigger of a user without the context of the server cid. This must be used in conjunction with the FSERVE tranfered files to 
* correctly switch to the server cid where the file was requested. @return UserTrigger
*/

alias -l FindBestMatchingUserTrig {
  var %nick = $1
  var %re = $AccessDB(GLOB,?TRIGS,%nick)
  if (%re) {
    ; for now we just take the first one matching, later we could try them all or something else
    %re = $gettok(%re,1,8)
    ;return the trigger name
    return $gettok(%re,2,9)
  }
  return $null
}

alias -l AutoSortPar2Dir {
  var %trigger = $1 ,  %crc = $2 , %size = $3
  %crc = $PSE_GoodCRC(%crc)
  var %ps_check_file = $PS_Par2RepairDir
  %ps_check_file = %ps_check_file $+ $+(%trigger,--,%crc,++,%size,\)
  if (!$isdir(%ps_check_file)) mkdir %ps_check_file $+ "
  return %ps_check_file
}

alias -l MoveDccWindowOutofRealm {
  var %window = $1-
  if ($scon(0) > 1) {
    ;  echo -sat trying to move window %window
    if ($window($remove(%window,")))  window -iz %window
  }
}

/** Function that is called on incoming file transfer events. Checks for correct size and stops timer. @return void
*/
alias -l HandleIncomingFileTransfer {
  var %file = $1 , %filesize = $2 , %nick = $3 , %address = $4 , %mode = $5

  if (.csv isin %file) {
    var %usertrig = $FindBestMatchingUserTrig(%nick) 
    var %data = $IsCSVExpected(%usertrig ,%file)
    if (%data) {
      var %cid = $gettok(%data,1,9)
      if (%cid) scid %cid
      ;_AOFF_ psecho 6 We found something for the Incoming CSV: %file from %nick (aka: %usertrig ) >> %data
      var %trigger = $gettok(%data,2,9)
      PSL_Timer %usertrig $+ _AWAITCSV_ $+ %trigger off
      return
    }
  }

  var %data = $IsExpectedTransfer(%nick,%file)
  if (%data) {
    if (((%mode !== network) || ($PS_GlobalOption(get,leech.reqtype).network !== network) ) ) .timer 1 0 MoveDccWindowOutofRealm "Get %nick $nopath(%file) $+ "
    ; psecho 13 >> Checking where to go: this is $cid . we need $gettok(%data,1,9) < $scid($gettok(%data,1,9)).network >
    if ($gettok(%data,1,9) !== $cid) scid $gettok(%data,1,9)

    ; echo 7 -s we have stored the following data: %data
    var %usertrig = $AccessDB(GLOB,TRIGS,%nick)

    var %lastcmd = $AccessDB(USER,%usertrig,LASTCMD,.)
    var %req = $gettok(%lastcmd,3,32)
    noop $AccessDB(USER,%usertrig,METHOD,%req)
    if ((%req == !PSSERV) && (%mode !== peer2peer)) {
      var %reqcounter = $AccessDB(GLOB,.COUNTER,FSERVE_PORT,--)
      ; echo -set File %file was requested with %req --> as in %lastcmd -> %reqcounter receive %mode (counter was reduced)
    }

    PSL_Timer %usertrig $+ _AWAIT* off
    var %trigger = $gettok(%data,2,9)
    if (%filesize == $gettok(%data,5,9)) {
      ; PSL_Log 9 The incoming file %file from %nick : %usertrig (6 %address ) has the expected Filesize of %filesize bytes. CID: $cid

      var %destdir = $PSL_TempPathForTrigger(%trigger)

      %destdir = $left(%destdir,$calc($len(%destdir) - 1)) $+ $gettok(%data,4,9)
      noop $PS_MakePath(%destdir)
      if ($calc($len(%destdir) + $len($nopath(%file)) + 24) > 259) {
        %destdir =  $file($left(%destdir,-1)).shortfn
      }
      var %destinationfile = %destdir $+ $nopath(%file)
      var %resume = $file(%destinationfile).size
      if (%resume != $null) {
        ;_AOFF_ psecho --> Resume File %destinationfile from %resume
        if (%resume > %filesize) {
          saferemove %destinationfile
          PSL_Log 3 target file: %destinationfile was deleted because it was larger ( %resume ) than the expected filesize of %filesize bytes
        }
      }
      ;  echo file will go to %destdir
      var %res = $PSL_TreeOp(add,Leech %trigger Targets %usertrig Status,Downloading)
      var %res = $AccessDB(USER,%usertrig,DOWNLOADING,%trigger)
      dcc get %destdir
    }
    else {
      dcc reject 
      ;PS_Tunnel .ctcp %nick !PSKILL
      PSL_Log 4 The incoming file %file from %nick was rejected!! the incoming Filesize was %filesize bytes. And we expected $gettok(%data,5,9)
      ; done here: remove the file from this users have or it will come over and over again
      var %res = $MarkHavingSingleFile(%trigger,%usertrig,$+($gettok(%data,4,9),$gettok(%data,3,9)),$gettok(%data,5,9),wrong)
      .timer 1 11.1 RequestAFile %trigger
      var %res = $FreeUserFromEverything(%nick)
      if ($AccessDBList(COLL,%trigger,COMPLETE,%usertrig,T)) SetUserToNeedHavelist %trigger %usertrig
    }
  }
  elseif ($PSE_GetPartName(%file).isPart) {
    dcc reject
    PSL_Log 2 Unexpected Part file %file was rejected from %Nick
  }
  else {
    if (_HAVE_ isin %file) goto FILEOK
    if (Triggerlist*txt* iswm %file) goto FILEOK
    PSL_Log 1 User %Nick is sending unexpected file13 %file with %filesize size
    ;;    /reporterrorfile User %Nick is sending the unexpected file %file with %filesize size ( ==> $FindBestMatchingUserTrig(%Nick) ) 
    if ($false) {
      if (%filesize < 1000000) goto FILEEXTRA
      ; if (%nick isallowed .. ) goto FILEEXTRA
      PSL_Log 1 User %Nick is sending unexpected file13 %file with %filesize size 7>>>>12REJECTED!!!
      dcc reject 
    }
    :FILEEXTRA
    PSL_Log 4 Extra File receiving from %nick : %file ( $+ %filesize bytes).
    :FILEOK
  }
}

/** does everything that need to be done when a file transfer ends. like setting the user free.
* @optparam end  is the way it ended . keywords good and fail (opt failhave)
* @return UserTrigger
*/
alias -l EndOfFileTransferFromUser {
  var %nickname = $1 , %end = $2 
  var %usertrig = $AccessDB(GLOB,TRIGS,%nickname)
  var %q = $AccessDB(USER,%usertrig,QUEUE,.) 
  var %r = $AccessDB(USER,%usertrig,RESENDOK,.) 

  ; this to protect us from the case that during a transer a user times out and comes back with a different name and after that the file is received. well..
  if (!%usertrig) %usertrig = %help 
  if (%usertrig) {
    SetUserFree %usertrig $GetGetDelay(%usertrig).block
    var %res = $AccessDB(USER,%usertrig,DOWNLOADING,.)
    var %res = $AccessDB(USER,%usertrig,BADSPEED,0)
    if (%end == fail) {
      ;_AOFF_ psecho Failed transfer from %nickname aka %usertrig
      var %res = $StatsUserField(%usertrig,TRANSQUAL,0)
      ; let the failcounter be reseted after one hour (that is for very large files that have a transfer time of several days)
      var %res = $AccessDB(USER,%usertrig,FAILCOUNT,++,900)
      if (%res > 5) {
        PSL_Log 1 User %usertrig has %res failed sends in a ROW ! Blocked now for 0.5 hours
        var %res = $AccessDB(USER,%usertrig,BLOCK,BADSENDS,1800)
        ;reset the counter now
        var %res = $AccessDB(USER,%usertrig,FAILCOUNT,0)
      }
      else if (%res > 3) {
        ; just temp block for 3 minutes to recover AND NOT reset the counter. so 2 following fails will lead to a final block of 2 hours
        var %res = $AccessDB(USER,%usertrig,BLOCK,BADSENDSTEMP,180)
      }

    }

    else {
      var %res = $AccessDB(USER,%usertrig,FAILCOUNT,.)
      ;_AOFF_ psecho old failcounter was %res for %usertrig
      if (%res > 2) {
        ; if failcounter was 3 and it worked it was a failing fserve that worked as "server" transfer. so blocking fserve for that user for
        var %res = $AccessDB(USER,%usertrig,NOFSERV,FAILCOUNT,1800)
      }
      var %res = $StatsUserField(%usertrig,TRANSQUAL,1)
      ;      echo -s 7,8Current Transfer Quality of User %usertrig == %res
    }
  }
  return %usertrig
}
;; @optparam mode set to 1 if havelist must not be purged

alias -l SetUserToNeedHavelist {
  var %trigger = $1 , %usertrig = $2 , %mode = $3
  if (!%mode) {
    if ( $AccessDBList(COLL,%trigger,HAVEHAVE,%usertrig,t) )  DeleteHavingListFromHash %trigger %usertrig
  }
  var %res = $AccessDBList(COLL,%trigger,HAVEHAVE,%usertrig,r)
  noop $AccessDBList(COLL,%trigger,HASLEECHED,%usertrig,r)
  var %res = $AccessDBList(COLL,%trigger,RUNDRY,%usertrig,r)
  var %res = $AccessDBList(COLL,%trigger,COMPLETE,%usertrig,r)
  var %res = $AccessDBList(COLL,%trigger,NEEDHAVE,%usertrig)
}


/** Handles all externals from the leech systems point of view, after file is sorted and checked. 
* @return void
*/

alias -l ProcessDownloadedFile {
  var %trigger = $1 , %filename = $2 , %user = $3 , %relpath = $4
  var %size = $file(%filename).size

  ;; add the file to the Dialog Viewer !! :)  Pretty simple !
  var %nickname = $iif($AccessDB(GLOB,NICKS,%user),$ifmatch,Constructed)
  if (!$PSE_GetPartName(%filename).isPart) noop $PSDV_LogLeechDownload(%nickname,%trigger,%relpath)

  return
  :error
  echo -set Warning: $error
  reseterror
}


/** Stores the necessary data for a user in the database to relate the nick the trigger and the address of the nick @return void
*/

alias -l RegisterNickToTrig {
  var %nick = $1 , %usertrig = $2 
  ;_AOFF_ psecho registering %nick to %usertrig
  var %addr = $address(%nick,3)
  var %old = $AccessDB(GLOB,NICKS,%usertrig)
  if (%old) {
    ;    echo -sat User %nick had the old nick %old
    dcc nick -sgcf %old %nick
    var %oldtranslated = $ReplaceSpecialChars(%old)
    dcc nick -sgcf %oldtranslated %nick
    var %oldt = $AccessDB(GLOB,TRIGS,%oldtranslated,.)
    var %oldt = $AccessDB(GLOB,TRIGS,%old,.)
  }
  var %re = $AccessDB(GLOB,TRIGS,%nick,%usertrig)
  %re = $AccessDB(GLOB,NICKS,%usertrig,%nick)
  if (%addr) {
    %re = $AccessDB(GLOB,ADDS,%addr,%usertrig)
  }
  var %nick2 = $ReplaceSpecialChars(%nick)
  if (%nick2 !== %nick)   var %re = $AccessDB(GLOB,TRIGS,%nick2,%usertrig)
  var %res = $PSL_TreeOp(add,UserInfo %usertrig Nick,%nick)

}

/** Replaces the NickNames like Mirc does .. 
* @return String
*/

alias -l ReplaceSpecialChars {
  var %input = $1
  return $replace(%input,$chr(124),_,$chr(96),_,^,_)
}

/** Tries to identify a user, returns the Trigger name if possible @return UserTrigger
*/

alias -l WhoIsThisUser {
  var %nick = $1
  var %addr = $address(%nick,3)
  var %trig = $AccessDB(GLOB,ADDS,%addr)
  ;echo -st WhoIsThisUser: Checking11 %Nick ---> Address:5 %addr --> Resolved to:7 %trig
  return %trig
}

;;;
;;;
;;;



/** Stores the source file to the destination folder under the filename. This is supposed to be a reliable move function, as it will only remove the 
* file if the destination is ok, after the copy @return Boolean
*/

alias -l MoveFileToEndLocation {
  var %source = $1 , %destdir = $2,  %fname = $3
  var %destination = %destdir $+ %fname
  $PS_MoveFile(%source,%destination)
  return $true
  :error
  reseterror
  PSL_Log 1 Failed to move file: $error
  return $false
}
/** Checks if Trigger needs a collectionUpdateSource in its channel. Returns the number of seconds since last update and 0< if it was done in this instance (or scheduled).
* @return Int
*/

alias -l CheckForUpdateNeeded {
  var %trigger = $1
  var %lastreq = $ctime - $AccessDB(COLL,%trigger,UPDATE)
  ;_AOFF_ psecho Since Last UpdateRequest for %trigger 7 %lastreq sec have past. 
  ;; no update if leech is not allowed for that trigger
  if (!$PreCheck_RequestAFile(%trigger)) return %lastreq 

  ;; const: updating the collection in channel 
  var %updateint = 1600
  if (%ps.whereisformat !== Ip) %updateint = 2700

  if (%lastreq > %updateint) {
    PSL_Log 5 Updating the Collectionsources for7 %trigger now. Last Update is %lastreq seconds away.
    %lastreq = $UpdateCollectionSources(%trigger,$AccessDB(COLL,%trigger,CHAN))
  }
  return %lastreq
}


/* tries to balance files between windows
* @prop globalfiles returns the number of all files in all leech windows of that trigger
* @prop numberofwindows returns the number of open windows for that trigger @prop clear to clear all windows in all networks
*/
alias -l FileBalancer {
  var %trigger = $1 
  if (!%trigger) return
  var %windows = $GetWindowName(LEECH,%trigger).global

  var %num = $numtok(%windows,9)

  ;; echo -set We found %num open windows > %windows
  if ($prop == numberofwindows) return %num

  if (%num >= 1) {
    var %totalfiles = 0
    var %i = 0 
    ;;; FIRST
    while (%i < %num) {
      inc %i
      var %window = $gettok(%windows,%i,9)
      if ($prop == clear) dline %window 1-
      var %files = $line(%window,0)
      ;;  echo > checking files in %window = %files 
      %totalfiles = %totalfiles + %files
    }
    ;; echo -set Found %totalfiles remaining in all windows .. 
  }
  if ($prop == globalfiles) return %totalfiles


  if (%num > 1) {
    var %limit = $int(  $calc((%totalfiles / %num))   )

    if (%totalfiles > 0) {
      ;;; SECOND SWEEP
      var %i = 0 
      while (%i < %num) {
        inc %i
        var %moveto = %i + 1 
        if (%moveto > %num) %moveto = 1 
        var %window = $gettok(%windows,%i,9)
        var %files = $line(%window,0)
        ; var %con = $PS_ResolveNetworkNametoSCon( $gettok(%window,2,95) )
        ;; we move only files from our current system away .. 
        ; if (%con != $cid) continue
        var %twindow = $gettok(%windows,%moveto,9)
        var %filestomove = %files - %limit 
        PSL_Log 4 Balancer moves files from %i to %moveto   ( %window => %twindow )  tomove:12 %filestomove files
        ; if (%filestomove == 0) %filestomove = 1
        if (%filestomove > 0) {
          $MoveFilesBetweenWindows(%window,%twindow,%filestomove)
        }
      }
    }
  }

}


alias -l MoveFilesBetweenWindows {
  var %source = $1 , %target = $2 , %num = $3 
  if (!%num) return
  var %max = $line(%source,0)
  if (!%max) return
  var %c = 1 
  while (%num) {
    var %line = $line(%source,%c)
    var %tagged = $numtok(%line,124)
    ;    echo -set checking %Line ( %max , %tagged ) to %target  
    if (%tagged > 4) {
      inc %c
      if (%c > %max) break
      else continue
    }
    ;    echo -set moving %Line ( %c , %tagged ) to %target  
    dline %source %c 
    aline %target %line
    dec %num
  }

  ;; ;;; to clear a leech cache 

  ;  var %con = $PS_ResolveNetworkNametoSCon( $gettok(%source,2,95) )
  ;  var %trigger =  $gettok(%source,4,95)
  ;  scon %con noop $!Accessdb(COLL, %trigger ,CACHE_*,.)

  ;  var %trigger =  $gettok(%target,4,95)
  ;  var %con = $PS_ResolveNetworkNametoSCon( $gettok(%target,2,95) )
  ;  scon %con noop $!Accessdb(COLL, %trigger ,CACHE_*,.)
  ;;; Must check what user might have new files -> this is not good ->  scon %con noop $!AccessDB(COLL, %trigger ,RUNDRY,.)
}

alias -l ClearCache {
  var %trigger = $1
  noop $AccessDB(COLL, %trigger ,CACHE_*,.)
}


/* A function to check how many RequestAfile timers are actualy running @return Int
*/
alias -l checkLeechTimers {
  var %trigger = $1
  var %t = $timer(0) , %found = 0
  while (%t) {
    if ($timer(%t).cid == $cid) {
      var %com = $timer(%t).com
      if ($gettok(%com,1,32) == RequestAFile) {
        var %foundthread = $gettok(%com,2,32)
        if (%foundthread == %trigger) {
          inc %found 
          if ($prop == kill) {
            var %name = $timer(%t)
            .timer $+ %name off
          }
        }
      }
    }
    dec %t
  }
  return %found
}


/** will take a trigger assumes that all relevant data is available and pick a user and request the first possible file from him.
* assumes that findBestLeechTarget returns a user that is not busy. This function is one of the main control functions for the leech. It may end a Leech
* thread and call the "OnEndOfLeechThread" Function @return Boolean
*/
alias -l RequestAFile {
  var %trigger = $1 
  var %windowname = $getWindowName(LEECH,%trigger)
  if (!$window(%windowname)) { PSL_Log 1 ERROR. No Window for %trigger |  return $false }
  ;_AOFF_ psecho RequestAFile started for %trigger .. Threads: $AccessDB(COLL,%trigger,THREADS)

  if ($AccessDB(COLL,%trigger,REPORTLOADING)) {
    .timer 1 20 RequestAFile $1- 
    echo -set Delaying the Request for a file because Report of %trigger not yet loaded....
    return
  }

  ;; an empty window means we are done && ending an Leech Thread 
  ;  var %remainfiles = $line(%windowname,0)

  var %remainfiles =  $FileBalancer(%trigger).globalfiles 
  var %res = $PSL_TreeOp(add,Leech %trigger Files,%remainfiles files remaining)

  ;; trigger end of leech
  if (%remainfiles == 0) {
    ;; check if there is a construction ongoing 
    var %c = $IsLeechBusy(%trigger)
    PSL_Log 3 3Zero remaining files found in7 %trigger Trigger is busy:6 %c
    OnEndOfLeechThread %trigger Zero remaining files left to leech ( %c )
    if (!%c) {
      scid -a if ($AccessDB(COLL,%trigger,CHAN)) broadcast $!ifmatch leechCOMPLETE %trigger $PSTC_GetCount(%trigger)
      if ($FileBalancer(%trigger).numberofwindows > 1) {
        PSL_Log 4 Linked Windows for %trigger detected. closing all windows.
        OnDoneLeech %trigger
        PSL_LeechStop %trigger DONE
      }
      else {
        ;; just end this as a normal leech
        OnDoneLeech %trigger
        PSL_LeechStop %trigger DONE
      }
    }
    else PSL_Log 3 Not closing the leech since there is still a construction in progress $ifmatch
    return
  }

  ;;check for REQUESTED stop events
  var %stop = $AccessDB(COLL,%trigger,REMOVETHREAD)
  if ((%stop > 0) || (Stop == $AccessCollectionState(%trigger))) {
    if (%stop > 0)  var %res = $AccessDB(COLL,%trigger,REMOVETHREAD,--)
    PSL_Log 3 Stopped a Leech thread by REQUEST of Coll: %trigger . %res more to stop now.
    OnEndOfLeechThread %trigger The Leech control function requested a reduction of the threads
    return
  }

  if (!$PreCheck_LeechAllowed) {
    ;_AOFF_ psecho NOT ALLOWED TO LEECH ANYTHING at the moment!
    OnEndOfLeechThread %trigger No leeches allowed at the moment $PreCheck_LeechAllowed().reason
    return
  }

  ;; On server connect we have to delay EVERYTHING .. 
  var %up = $uptime(server,3)
  if (%up < 300) {
    .timer 1 300 RequestAFile $1-
    ;_AOFF_ psecho .. Serverconnect to near, delaying Request by 300 sec . $1-
    return
  }

  var %lastreq = $CheckForUpdateNeeded(%trigger)

  if (%lastreq < $getWTO) {
    var %next = $calc($getWTO - %lastreq + $rand(3,60))
    .timer 1 %next RequestAFile $1- 
    ;_AOFF_ psecho 11 Delaying the Requestafile for4 %next seconds 
    return
  }

  var %bestuser = $findBestLeechTarget(%trigger)
  if (!%bestuser) {
    ;_AOFF_ psecho 8,1 NO more free Nick Names available. this "Leech-Thread" is terminated now for7 %trigger
    OnEndOfLeechThread %trigger No more available targets (= $PSL_GetLeechUserInfo(%trigger) $+ ) to be leeched 
    return $false
  }
  if ($AccessDBList(COLL,%trigger,NEEDHAVE,%bestuser,T) && ($false == $AccessDBList(COLL,%trigger,HAVEHAVE,%bestuser,T) )) {
    ;_AOFF_ psecho OK NEED TO CHECK FOR A HAVELIST for %bestuser and Trigger %trigger
    RequestHaveListFromUserForTrigger %bestuser %trigger
    ;will be continued after HAVEFILE was received
    return 
  }
  var %nick = $AccessDB(GLOB,NICKS,%bestuser)
  if (!%nick) {
    ;; problem. we do not know what user that Trigger holds, but its impossible that this situation is reached in normal operations
    return $false
  }
  ; if we are sure the user is ok and avail get a file
  var %record = $findLeechableFile(%trigger,%bestuser)
  var %file = $gettok(%record,4,124) $+ $gettok(%record,1,124)
  if (!%file) {
    if ($false == $isLeechableFileLeft(%trigger)) {
      ;_AOFF_ psecho 6,1 No files left for leech in %trigger . This is the case near the end of the leech, so this "Leech-Thread" terminates now
      PSL_Log 3 No More Free Files found to be leeched (all missing files are in queue somewhere) from %trigger
      OnEndOfLeechThread %trigger No more free files found to be leeched
      FileBalancer %trigger
      return 
    }
    ;end of leech ?? no but no file for this user available.. 
    if ($AccessDBList(COLL,%trigger,HASLEECHED,%bestuser,T)) {
      ;SetUserToNeedHavelist %trigger %bestuser
      noop $AccessDBList(COLL,%trigger,HAVEHAVE,%bestuser,R)
      noop $AccessDBList(COLL,%trigger,HASLEECHED,%bestuser,R)
      PSL_Log 3 User12 %bestuser ( %nick ) ran out of files for collection7 %trigger - rerequesting HAVELIST since user has leeched since last LIST
    }
    else {
      noop $AccessDBList(COLL,%trigger,RUNDRY,%bestuser)
      PSL_Log 3 User12 %bestuser ( %nick ) ran out of files for collection7 %trigger
    }
    echo $ps_n -st --> User %bestuser is out of files for %trigger
    ;; next line removes all locks from this user
    PSL_SetLock %bestuser $null
    .timer 1 4 RequestAFile %trigger
    return
  }

  if ($false == $PreCheck_RequestAFile(%trigger) ) {
    PSL_Log 3 PreCheck_RequestAFile Returned 4False.. Halting this Thread for %trigger :: $PreCheck_RequestAFile(%trigger).reason
    OnEndOfLeechThread %trigger Trigger failed to be leeched $PreCheck_RequestAFile(%trigger).reason
    return $false
  }

  ;; actually request the file now !!!

  PSL_Log 5 Requesting File:7 %file from12 %bestuser (current nick:12 %nick ) for Collection:5 %trigger Still needed Files:3 %remainfiles

  var %res = $AccessDB(USER,%bestuser,RETRYCOUNT,0)

  var %res = $PSL_TreeOp(add,Leech %trigger Targets %bestuser File,%file)
  var %res = $PSL_TreeOp(add,Leech %trigger Targets %bestuser Status,Requested. Waiting for Reply.)

  var %transfermethod = $GetRequestMethodString(%bestuser)
  var %filecrc = $PSE_GoodCRC($gettok(%record,3,124),$true)
  var %filesize = $gettok(%record,2,124)
  if ((%psl.strictrequests) && ($PSE_IsPic(%filesize,%file))) SendToTarget ctcp %nick %transfermethod %trigger %filecrc %filesize %file
  else  SendToTarget ctcp %nick %transfermethod $iif(%psl.leechsort == report,$lower(%trigger),$upper(%trigger)) %file
  var %res = $SetExpectedTransfer(%nick,%file,%trigger,$gettok(%record,4,124),$gettok(%record,2,124),$gettok(%record,3,124))
  %res = $MarkActionForCollectionfile(%trigger,%file,S,%bestuser)
  SetUserBusy %bestuser %trigger
  PSL_Timer %bestuser $+ _AWAIT 120 OnTimeoutFromRequest %bestuser
  return $true
}

/** calculates the current get delay on a per user basis . time is in seconds
* @return int  
* @prop block returns the block delay
*/

alias -l GetGetDelay {
  var %usertrig = $1
  var %delay = 0
  if (  $PS_GlobalOption(get,leech.reqtype).network == network) %delay = 5

  if ($prop == block) dec %delay
  ;_AOFF_ psecho 9 returning getdelay for %usertrig ( $prop ) = %delay
  if (%delay > 0) return %delay
  return 0
}



/** Checks and returns if a user is still ok for fserve.
*  Checks what request string to use for a user
*  @return !requeststring
*/

alias -l GetRequestMethodString {
  var %usertrig = $1 , %csvtrigger = $2
  var %old = !PSGET
  ;  if (%usertrig) %old = %usertrig
  if (  $PS_GlobalOption(get,leech.reqtype).network == network) return %old
  var %failcount = $AccessDB(USER,%usertrig,FAILCOUNT)
  ;_AOFF_ psecho FAILCOUNT for %usertrig is %failcount
  if (%failcount > 2) return %old
  if (%usertrig && ($AccessDB(USER,%usertrig,NOFSERV))) return %old

  if (%csvtrigger) {
    var %failcount = $AccessDB(COLL,%csvtrigger,FAILCSV_ $+ %usertrig)
    echo -set DEBUG: failed %failcount times .. switching to %old if > 2
    if (%failcount > 2) return %old
  }
  if (!$ip) {
    /localinfo -u
    return %old
  }
  ;return !PSserv $ip $+ : $+ $dccport
  if (%ps.maskip) return !PSserv $PSE_MaskIp(%ps.whereisip,$dccport)
  else return !PSserv $+(%ps.whereisip,:,$dccport)
}

;; checks if free bytes are higher than the current limit @optparam limit bytelimit (if $null %PS.checkfreespace is used)
alias -l IsFreeBytesOk {
  var %fullpath = $1 , %limit = $2
  if (%limit == $null) var %limit = $calc(%PS.checkfreespace * 1024 * 1024)
  var %free = $disk(%fullpath).free
  ;  echo -set Currently free %free .. checking %limit .. for %fullpath
  if (%free > %limit)  return $true
  return $false
}

/** PreCheck Function to check if it is ok to: Request a File from someone in a Leech .
* All PreCheck functions check States _outside_ of the System, like PS Conditions or Mirc. @return Boolean
* @optparam chan optional channel. taken from leech db if omitted
* @prop reason returns the reason why not allowed
*/
alias -l PreCheck_RequestAFile {
  var %trigger = $1 , %chan = $2
  if (!%chan) var %chan = $AccessDB(COLL,%trigger,CHAN)
  var %needvoice = $PSL_FetchConstant(NeedVoice,%chan)
  var %ok = $true
  if ($me !ison %chan) {
    %ok = $false
    var %reason = I am not in the channel %chan to leech 
  }
  else if ( !$PSL_FetchConstant(ChannelCheck,%chan) ) {
    %ok = $false
    var %reason = PhotoServe is not turned on for channel %chan
  }
  else if (%needvoice !== OFF) {
    if (($me !isvoice %chan) && ($me !isop %chan)  && ($me !ishop %chan)) {
      %ok = $false
      var %reason = No Voice in %chan
    }
  }
  var %ps_giglimit = $PS_DialogGigCurrentCount(PSL:PreCheck_RequestAFile,get,return)
  if ($gettok(%ps_giglimit,1,32) == off) {
    var %reason = PhotoServe Leech $+ $ps_kh %ps_leechs_window 4Stopped.  You have reached your user defined gig limit of $+ $ps_kh $PS_FileSize($gettok(%ps_giglimit,2,32),2) for today.
    %ok = $false
  }

  if (!$IsFreeBytesOK($PSTC_GetPath(%trigger))) {
    %ok = $false
    var %reason = Not Enough Free Bytes left on Collection Drive $PSTC_GetPath(%trigger) for %trigger
  }
  if (!$IsFreeBytesOK($PSL_TempPathForTrigger(%trigger))) {
    %ok = $false
    var %reason = Not Enough Free Bytes left on Drive for PSTemp Folder $PSL_TempPathForTrigger(%trigger) for %trigger
  }

  ; #############VERSION CHECK HERE
  var %minversion = $PSF_GetChanSetting(MinPSVersion, %chan)
  if (%minversion != $null) {
    var %blacklist = $PSF_GetChanSetting(BetaBlacklist, %chan)
    var %req_major = $gettok(%minversion, 1, 46)
    var %req_minor = $gettok(%minversion, 2, 46)
    var %my_major = $gettok($PS.version.main, 1, 46)
    var %my_minor = $gettok($PS.version.main, 2, 46)
    var %my_beta = $remove($PS.Version.Beta, +b)

    ; Beta blacklist is applied only when myversion == minversion 
    if ((%my_major == %req_major) && (%my_minor == %req_minor)) {
      var %i = $numtok(%blacklist, 44)
      while (%i > 0) {
        if (%my_beta isnum $gettok(%blacklist, %i, 44)) {
          %ok = $false
          var %reason = PhotoServe $PS.Version.Main beta $PS.Version.Beta has been blacklisted $&
            from %chan for being buggy or just too old. Upgrade to latest beta.
        }
        dec %i
      }
    }
    ; Major version is too small, or major version ok but minor too small
    elseif ((%my_major < %req_major) || ((%my_major == %req_major) && (%my_minor < %req_minor))) {
      %ok = $false
      var %reason = PhotoServe version $PS.Version.Main is too old, upgrade to %minversion or better.
    }
  }
  ; #############VERSION CHECK END

  if ($prop == reason) return %reason
  return %ok
}

/** PreCheck Function to check if it is ok to: To Start a Leech
* All PreCheck functions check States _outside_ of the System, like PS Conditions or Mirc. @return Boolean
* @optparam chan optional channel. taken from leech db if omitted
* @prop reason returns the reason why not allowed
*/
alias -l PreCheck_LeechStart {
  var %trigger = $1 , %chan = $2
  if (!%chan) var %chan = $AccessDB(COLL,%trigger,CHAN)
  var %ok = $true
  var %filter = $PSF_TrigIsAllowed(%trigger,%chan)
  if (!%filter) {
    var %reason = Trigger %trigger is filtered in %chan
    %ok = $false
  }
  if (!$PreCheck_RequestAFile(%trigger,%chan)) {
    %ok = $false
    var %reason = $PreCheck_RequestAFile(%trigger,%chan).reason
  }
  ;  var %check = $FetchSettingFromTrig(%trigger,path)
  var %check = $PSTC_GetPATH(%trigger)
  ;_AOFF_ psecho Checking needed resource: %check
  if ((!%check) || (!$exists(%check))) {
    %ok = $false
    var %reason = Trigger %trigger path failed: %check
  }
  ;  var %check = $FetchSettingFromTrig(%trigger,rep)
  var %check = $PSTC_GetREPort(%trigger)
  ;_AOFF_ psecho Checking needed resource: %check
  if ((!%check) || (!$exists(%check))) {
    %ok = $false
    var %reason = Trigger %trigger report failed: %check
  }
  ;  var %check = $FetchSettingFromTrig(%trigger,csv)
  var %check = $PSTC_GetCSV(%trigger)
  ;_AOFF_ psecho Checking needed resource: %check
  if ((!%check) || (!$exists(%check))) {
    %ok = $false
    var %reason = Trigger %trigger csv failed: %check
  }
  if ( $PSTC_GetBTState(%trigger) ) {
    %ok = $false
    var %reason = Trigger %trigger is BT locked $ifmatch
  }

  if (%ps.errorlevel == 1) { 
    var %reason = New leech cannot be started due to trigger errors. 
    if ($window(@PSTriggerError) == $null) {
      var %reason = Leeching is disabled due to trigger errors. Rechecking now, if no errors are found leeches will be re-enabled...
      echo -set 04Leeching is disabled due to trigger errors. Rechecking now, if no errors are found leeches will be re-enabled...
      PSTC_CheckErrors $me AllChannels $true
    }
    %ok = $false
  }
  if ($prop == reason) return %reason
  return %ok
}


/** PreCheck Function to check if it is ok to: Start Leeches / Continue Running Leeches
* All PreCheck functions check States _outside_ of the System, like PS Conditions or Mirc. @return Boolean
*/
alias -l PreCheck_LeechAllowed {
  var %ok = $true
  ;  var %match = @PSLEECH_ $+ $network $+ _*
  ;  var %c = $window(%match,0)
  ;  if (%c > 0) {
  ;    %reason = Cannot Start Leeches while %match windows are open. 
  ;    %ok =  $false
  ;  }
  if ($script(pserve_9.mrc)) {
    %ok = $false
    var %reason = pserve_9 loaded. conflict in scripts
  }
  if ($PSL_FetchConstant(PSStatus) == OFF) {
    %ok =  $false
    var %reason = PS Turned OFF
  }
  var %ps_giglimit = $PS_DialogGigCurrentCount(PSL:PreCheck_LeechAllowed,get,return)
  if ($gettok(%ps_giglimit,1,32) == off) {
    var %reason = You have reached your user defined gig limit of $+ $ps_kh $PS_FileSize($gettok(%ps_giglimit,2,32),2) for today.
    %ok = $false
  }

  ; if too many bad trigger errors kill leech
  if (%ps.errorlevel > 1) { 
    var %reason = Leeching is disabled due to trigger errors. 
    if ($window(@PSTriggerError) == $null) {
      var %reason = Leeching is disabled due to trigger errors. Rechecking now, if no errors are found leeches will be re-enabled...
      echo -set 04Leeching is disabled due to trigger errors. Rechecking now, if no errors are found leeches will be re-enabled...
      PSTC_CheckErrors $me AllChannels $true
    }
    else {
      echo -set 04Leeching is disabled due to trigger errors. Fix errors and re-run check to be able to leech again
      if (!$timer(leechtriggerblockremover)) timerleechtriggerblockremover 1 3600 PSTC_CheckErrors $!me AllChannels $true
    }
    %ok = $false
  }

  if ($prop == reason) return %reason
  return %ok
}

/** Requests a Havefile from a user.
* @param user The users !trigger @param trigger The collections trigger to request the file from @return void
*/

alias -l RequestHaveListFromUserForTrigger {
  var %usertrig = $1 , %trigger = $2
  var %nick = $AccessDB(GLOB,NICKS,%usertrig)
  var %wait = $GetInterval(havereq,$iif(%ps.reqhavedelay,%ps.reqhavedelay,0))
  PSL_Log 3 Requesting 10HAVELIST for collection:7 %trigger from user5 %nick 12( %usertrig ) in %wait seconds.
  if (!%nick) return $false
  ;  SendToTarget ctcp %nick %usertrig %trigger HAVE2
  .timer 1 %wait SendToTarget ctcp %nick $GetRequestMethodString(%usertrig) %trigger HAVE2
  SetUserBusy %usertrig %trigger
  PSL_Timer %usertrig $+ _AWAIT $calc(480 + %wait) OnTimeoutFromRequest %usertrig
  var %res = $AccessDB(USER,%usertrig,WAITHAVE,%trigger)
  var %res = $AccessDB(USER,%usertrig,RETRYCOUNT,0)
}

alias -l GetInterval {
  var %name = $1 , %waittime = $2
  var %old = $hget(PSWAIT,%name)
  if (!%old) %old = 0
  hadd -mz PSWAIT %name $calc(%old + %waittime)
  return %old
}

/** handles the things that need to be done when a user time out is reached.
* @return void
*/

alias -l OnTimeoutFromRequest {
  var %usertrig = $1
  if (!%usertrig) { PSL_Log 1 ERROR no user given at OnTimeOutFromRequest .. | return }

  var %q = $AccessDB(USER,%usertrig,QUEUE,.) 
  var %r = $AccessDB(USER,%usertrig,RESENDOK,.) 
  var %lastcmd = $AccessDB(USER,%usertrig,LASTCMD)
  var %nickname = $AccessDB(GLOB,NICKS,%usertrig)

  ;  echo -set Timeout triggered for %usertrig $+ . Queue: %Q  Resend: %r  -- LastCmd: %lastcmd - current Nick: %Nickname

  if (!$PreCheck_LeechAllowed) {
    ;_AOFF_ psecho NOT ALLOWED TO LEECH ANYTHING at the moment! Stopping leech from %nickname 
    if ( $FreeUserFromEverything(%nickname) ) {
      ;; and end the request in the requestAFile function
      RequestAFile $ifmatch
    }
    return
  }

  ; echo -set %usertrig -> %q / %r 

  if ((!%q) && (!%r)) {
    var %retrycount = $AccessDB(USER,%usertrig,RETRYCOUNT,++,1800)
    ;  echo -set Retrycounter for %usertrig is %retrycount
  }
  else {
    var %reqcounter = $AccessDB(GLOB,.COUNTER,FSERVE_PORT,--)
    ;_AOFF_ psecho number of requests reduced to %reqcounter because the file request was "excused" this is only a repeation
  }
  ;_AOFF_ psecho 10 TIMEOUTDEBUG of %usertrig aka %nickname .. %q <q  %r <r  %retrycount < counter %lastcmd <lastcmd

  if (((%r) || (%q) || (%retrycount < 5)) && (%lastcmd) && (!$AccessDB(USER,%usertrig,BLOCK))) {
    ; must not check if user is in channel or elsewhere since it cannot happen (user is released on quit or part or kick)
    ;_AOFF_ psecho 3,7 REPEATING %lastcmd
    ; replace the current user nick name with current (it may have been changed)
    %lastcmd = $puttok(%lastcmd,%nickname,2,32)

    ;    if (($gettok(%lastcmd,3,32) == !PSServ) && (%retrycount >= 1)) {
    ;    }
    if ($gettok(%lastcmd,3,32) == !PSServ) {
      if  (%retrycount == 4) {
        %lastcmd = $puttok(%lastcmd,!PSGet,3,32)
        var %res = $AccessDB(USER,%usertrig,NOFSERV,FAILCOUNT,600)
      }
    }
    SendToTarget %lastcmd
    PSL_Timer %usertrig $+ _AWAIT 120 OnTimeoutFromRequest %usertrig
    if ($PSL_GetLock(%usertrig)) PSL_SetLock %usertrig $ifmatch
  }
  else {
    ; release user of the requested file
    var %coll = $FreeUserFromEverything(%nickname)
    var %res = $PSL_TreeOp(del,Leech %coll Targets %usertrig File)

    PSL_Log 4 User %usertrig ( %nickname ) timed out : It was a part of Leech from %coll : %lastcmd
    ; Set User to BLOCKED for some time
    var %res = $AccessDB(USER,%usertrig,BLOCK,TIMEOUT,$calc(3600*2))
    echo -set User %usertrig is now blocked for not responding
    ; clear WAITFORHAVE as well. 
    %res =  $AccessDB(USER,%usertrig,WAITHAVE,.)
    if (%res) { 
      PSL_Log 4 While Waiting for a 10havelist for %res from %usertrig nothing was coming. SO .. we blocked %usertrig and started a new thread for %res
      ;only block for 1/2 hour
      echo -set User %usertrig is now blocked for not responding to a HAVElist Request
      var %r = $AccessDB(USER,%usertrig,BLOCK,TIMEOUT,$calc(3600*0.5))
      RequestAFile %res
      return
    }
    if (%coll) RequestAFile %coll
    else PSL_Log 1 Error OnTimeOut called for %usertrig ( %nickname ) but no collection was detected..  
  }
  return
  :error
  PSL_Log 1 Error - $error - in OnTimeOutFromRequest( $1- )
}

alias -l OnEndOfLeechThread {
  var %trigger = $1 , %reason = $2-
  var %res = $AccessDB(COLL,%trigger,THREADS,--)
  PSL_Log 3 End of Leech Thread of Trigger7 %trigger 4( %reason 4) -> Active now:4 %res
  if (%res < 0) {
    PSL_Log 1 Error correcting negative number of running leeches for %trigger 
    ReleaseAllUsersFromLeech %trigger
    var %res = $AccessDB(COLL,%trigger,THREADS,0)
  }
  elseif (%res == 0) {
    var %now = $ReSyncUsersFromLeech(%trigger)
    if (%now) PSL_Log 2 After reaching 0 running threads. ReSynch with the leech system returned %now running. Corrected!
    %res = %now
  }
  var %re = $PSL_TreeOp(add,Leech %trigger Running,%res)
  RefreshLeechDialog %trigger
}


alias -l OnDoneLeech {
  var %trigger = $1
  PSL_Log 2 Leech of7 %trigger is done now.
  PSDV_TrimLog
  ;  if ( $FetchSettingFromTrig(%trigger,csvcount) == $FetchSettingFromTrig(%trigger,count)) {
  if ( $PSTC_GetCSVCOUNT(%trigger) == $PSTC_GetCOUNT(%trigger)) {
    var %temppath = $PSL_TempPathForTrigger(%trigger)
    noop $PSE_UnlockDirectory(%temppath)
    ; noop $PS_LeechPurgeDir(PSL_LeechStop,%temppath)
    noop $PSL_RmTree(%temppath)
  }
  var %res = $CheckControlFileStatus(UPDATE,.,%trigger,DONE)
  ; var %event = $1 , %cfile = $2 , %eventcollection = $3 , %eventstatus = $4 , %comment = $5

  remini -n $PSL_FetchConstant(PartSum) %trigger
}


alias -l CleanPartSumFile {
  var %ini = $PSL_FetchConstant(PartSum)
  var %c = $ini(%ini,0)
  while (%c) {
    var %trigger = $ini(%ini,%c)
    var %compl = $IsCollectionComplete(%trigger)
    echo -st -> found %c and checking %trigger -> $iif(%compl,03Complete,04Not Complete)
    if (%compl) remini -n $qt(%ini) %trigger
    dec %c
  }

}

/* Safely removes a file, without failing  @return void @prop nobin do not delete to recycle bin
*/
alias SafeRemove {
  var %file = $1-
  if ($file(%file).atime)  $iif(%psl.debug,$null,.) $+ remove $iif($prop == nobin,$null,%ps.recycle) $qt(%file)
  else echo -set no file to delete: %file
  if ($file(%file).atime) {
    echo -set file %file was not deleted - mirc cannot delete that file but truncate it to 0 bytes instead
    /btrunc $qt(%file) 0
  }
  :error
  if ($error) { echo -set SafeRemove: $error | reseterror }
}

alias PSL_RmTree {
  var %dir = $1
  var %w = @tempclean
  window -c %w
  window -hl %w
  noop $FindDir(%dir,*,%w)
  var %i = $line(%w,0)

  while (%i) {
    var %deld = $line(%w,%i)
    dec %i
    noop $findfile(%deld,*,0,1,noop $saferemove($1-))
    rmdir $qt(%deld)
    echo -set cleaned and deleted dir07 %deld
  }
  rmdir $qt(%dir)
  :error
  if ($error) { 
    echo -set RmTreeNormal failed -> $error 
    reseterror 
    var %dir = $iif($right(%dir,1) == \,$left(%dir,-1),%dir)
    noop $PS_RunPserveExeSync(RmTree, $qt(%dir))
    echo -set Calling Pserve Assistance to wipe %dir
  }
  window -c %w
  echo -set deleting %dir was $iif($exists(%dir),4not,$null) successful
}


alias PSL_RmTreeBatch {
  var %dir = $1
  var -s %bat = $mircdir $+ PSDEL.bat
  .fopen -o BAT $qt(%bat)
  noop $findfile(%dir,*,0,.fwrite -n BAT del $qt($1-)) 
  .fclose BAT
  if ($file(%bat)) {
    run $qt(%bat)
    noop $saferemove(%bat).nobin
  }
}

;; @param path is the PSTEMP path 
alias -l CleanTempDownloadPath {
  var %path = $1
  echo -set checking %path
  if ($exists(%path))  noop $finddir(%path,*,0,1,if ($IsCollectionComplete($nopath($1-))) noop $PSL_RmTree($1-))
  ;;  $PS_LeechPurgeDir(PSL_LeechStop,$1-))
}

alias -l IsCollectionComplete {
  var %trigger = $1
  if ($PSTC_GetCSVCount(%trigger) == $PSTC_GetCount(%trigger)) return $true
  return $false
}

;; this returns the temp path for a particular trigger. Usualy is PSTemp in the download path, but can be set to be in different locations. @return Directory
alias PSL_TempPathForTrigger {
  var %trigger = $1
  if (%PS.TempLocation == samedrive) {
    var %p = $PSTC_GetPath(%trigger)
    var %path = $left(%p,3) $+ PSTemp\ $+ %trigger $+ \
  }
  else  var %path = $+(%PS.downp,PSTemp\,%trigger,\)
  if ($prop == parts) return %path $+ !PSPARTS\
  return %path
}

/** Start of a Leech Thread.  @return Void @optparam count the number of threads to be started. default 1
*/

alias -l StartOfLeechThread {
  var %trigger = $1 , %count = $2
  if (!%count) var %count = 1
  while (%count > 0) {
    var %active = $AccessDB(COLL,%trigger,THREADS,++)
    .timer 1 $calc(%ps_leechstartcounter) RequestAFile %trigger
    inc -z %ps_leechstartcounter 3
    PSL_Log 3 Starting of a Leech Thread for Trigger %trigger -> Active now:4 %active
    noop $PSL_TreeOp(add,Leech %trigger Running,%res)
    ;    }
    dec %count
  }

}

/** Stop of a Leech Thread. @return Void @prop stopping returns the number of already stopping threads  @optparam count is the number of threads to stop default 1
*/
alias -l StopOfLeechThread {
  var %trigger = $1 , %count = $2
  if ($prop == stopping) return $AccessDB(COLL,%trigger,REMOVETHREAD)
  if (!%count) var %count = 1
  if (!%ps.nohardkills) %count = $calc(%count -  $ReleaseAllUsersFromLeech(%trigger,%count))
  while (%count > 0) {
    var %res = $AccessDB(COLL,%trigger,REMOVETHREAD,++)
    PSL_Log 3 Request of stopping one leech for %trigger . Now %res will be stopped
    dec %count
  }
}

; this takes only a trigger @option filloption can be fullcheck too
alias -l StartALeechWindow {
  var %trigger = $1 , %chan = $2 , %filloption = $3
  PSL_Log 3 Starting a new Leech Window for %trigger
  ;  var %rep = $FetchSettingFromTrig(%trigger,rep)
  var %rep = $PSTC_GetREPort(%trigger)

  var %window = $getWindowName(LEECH,%trigger)

  if ($getWindowName(LEECH,%trigger).global) {
    echo -set There are already leech windows open for this leech $ifmatch - splitting files for a better performance
    if (!$window(%window)) window -hl %WINDOW
    ;; check the balance of files for this leech
    FileBalancer %trigger
  }
  else {
    noop $FillWinWithReport(%rep,%window,%trigger,%chan,%filloption)
  }
  var %csv = $PSTC_GetCSVCRC(%trigger)
  var %res = $AccessDB(COLL,%trigger,SCSVCRC,%csv)

  RefreshLeechDialog %trigger
}


;; function to make sure files to be resumed are placed on top. useless these days
;; will be removed  until there is a gui to enable or disable this feature 
alias -l PriorizeIncompleteFiles {
  var %trigger = $1

  if (%psl.leechsort == report) return
  var %pstemp = $PSL_TempPathForTrigger(%trigger)
  var %window = $getWindowName(LEECH,%trigger)
  var %rem = $len(%pstemp) - 1
  ;  echo -st --> moving incomplete files in %pstemp to the top of the list in %window
  ;  var %f = $findfile(%pstemp,*,0,echo -set FOUND> $right($1-,$calc($len($1-) - %rem)) end)
  var %ctl = $getPartControlFile
  var %cl = $len(%ctl)
  var %f = $findfile(%pstemp,*,0,if (($right($1-,%cl) !== %ctl) && (!$PSE_GetPartName($1-).isPart)) MoveFileInWindowToTop %window $right($1-,$calc($len($1-) - %rem)))
}

alias -l MoveFileInWindowToTop {
  var %window  = $1 , %file = $2-
  var %filename = $nopath(%file)
  var %path = $nofile(%file)
  var %c = $line(%window,0)
  var %i = 0
  while (%i < %c) {
    inc %i
    var %line = $line(%window,%i)
    if (($gettok(%line,1,124) == %filename) && ($gettok(%line,4,124) == %path)) {
      dline %window %i
      iline %window 1 %line
      echo -st --> Moved incomplete file %file to the top of leech list window %window
      return
    }
  }
}

/* Resorts a Leech Window depending on the number of available Files in the Channel
*/
alias PriSort {
  var %trigger = $1 , %order = $2

  if (%psl.leechsort == report) return
  var %start = $ticks

  var %window = $getWindowName(LEECH,%trigger)
  if ($window(%window)) {
    savebuf %window $PS_TmpDir $+ LeechList.txt"

    var %HASHNAME = $IsHavingSingleFile(%trigger).getHashName
    var %hashfile = $PS_TmpDir $+ LeechHash.hsh"
    if ($hget(%HASHNAME))  hsave %HASHNAME %hashfile
    else noop $saferemove(%hashfile).nobin

    ;# Input   : \Photoserve\Temp\LeechHave.hsh
    ;#           \Photoserve\Temp\LeechList.txt
    ;[18:23:31] <***> $PS_RunPserveExeSync(SortLeechByPrio)
    ;[18:23:42] <***> $PS_RunPserveExeSync(SortLeechByPrio, picfirst)
    ;[18:23:47] <***> $PS_RunPserveExeSync(SortLeechByPrio, vidfirst)
    ;[17:32:31] <***> pass a third param, something perl interpets as true
    ;[17:32:38] <***> to disable ganging

    noop $PS_RunPserveExeSync(SortLeechByPrio, $iif(%order,$ifmatch,default) $iif(%psl.leechsort == nogang,1,$null))

    loadbuf -r %window $PS_TmpDir $+ LeechList.txt"

    ClearCache %trigger
    var %max = $line(%window,0)
    PSL_Log 3 Reordered %max lines %window by sort option %order and priority in $calc($ticks - %start) ms 
  }
  :error
  if ($error) {
    PSL_Log 1 in PriSort( %trigger  ) -> $error
    reseterror
  }
}

alias -l PriSort_mircscript {
  var %trigger = $1 , %order = $2
  var %window = $getWindowName(LEECH,%trigger)

  if ($window(%window)) {
    var %c = $line(%window,0) 
    if (%c <= 1) return
    if (%c > 2000) return
    var %start = $ticks
    ;    echo -set found %window with %c lines
    var %twin = @temp_tosort
    if ($window(%twin)) window -c %twin
    window -shl %twin
    while (%c > 0) {
      var %line = $line(%window,%c)
      var %file =  $gettok(%line,4,124) $+  $gettok(%line,1,124)
      var %size = $gettok(%line,2,124)
      var %havelist = $IsHavingSingleFile(%trigger,*,%file,%size)
      var %pri = $right($+(0000,$numtok(%havelist,58)),4)
      aline %twin $+(%pri,$chr(124),$rand(10000,99999),$chr(124), %line)
      dec %c
    }
    dline %window 1-
    var %max = $line(%twin,0)
    var %i = 0 , %off = 0
    while (%i < %max) {
      inc %i
      var %l = $line(%twin,%i)
      var %c = $calc($gettok(%l,1,124) % 5) + 3
      var %size = $gettok(%l,4,124)
      var %file = $gettok(%l,3,124)
      var %ispic = $iif($PSE_GetPartName(%file).ispart,$false,$PSE_IsPic(%size,%file))
      var %j = 0
      if (%ispic) {
        if (%order == vidfirst) inc %off
        else %j = %off
      }
      else {
        if (%order == picfirst) inc %off
        else %j = %off
        %c = 13
      }
      if ($numtok(%l,124) > 6) %c = 2
      iline %c %window $calc(%i - %j) $gettok(%l,3-,124)
    }
    window -c %twin
    ClearCache %trigger
    PSL_Log 3 Reordered %max lines %window by sort option %order and priority in $calc($ticks - %start) ms 
  }

}


;; Function that reorders the randomized leech list. options accepted for %order are picfirst , vidfirst . Do not use this function on an already running Leech cause it would miss files to be leeched by users that have incomplete lists
alias -l ReorderWindowFiles {
  var %trigger = $1 , %order = $2 
  return $PriSort(%trigger,%order)

}
alias -l ReorderWindowFiles_mircscript {
  var %window = $1 , %order = $2 
  var %c = $line(%window,0)
  ; start with line 2
  var %i = 1
  var %moved = 0
  while (%i < %c) {
    inc %i
    var %line = $line(%window,%i)
    var %file =  $gettok(%line,1,124) 
    var %sizesize = $gettok(%line,2,124)
    ;var %path = $gettok(%line,4,124) 
    var %pic = $PSE_IsPic(%filesize,%file)

    var %move = $false

    if ((%order == picfirst) && (%pic)) %move = $true
    elseif ((%order == vidfirst) && (!%pic)) %move = $true

    if (%move) {
      dline %window %i
      iline %window 1 %line
      ; echo -st --> Moved File %file from line %i to 1 to the top of %window
      inc %moved
    }

  }
  PSL_Log 4 ReOrdering Window %window leech list with order option %order done. %c lines to order. %moved lines rearanged.

}

/** Does everything that needs to be done (purged, closed, cleared, refreshed) when a collection needs to update its sources.
* This function takes care, that the Requests do not occur to fast. Therefor the number returned, which is the seconds since last update, can be negative
* @return Int
*/
alias -l UpdateCollectionSources {
  var %trigger = $1 , %chan = $2
  ;specify the time in seconds to wait between two Updates. 
  var %waittime = 25
  var %WINDOW = $getWindowName(WHEREIS,%trigger)
  ;  window -c %WINDOW

  var %last = $AccessDB(GLOB,CONTROL,LASTUPDATE)
  if (!%last) %last = 0
  var %wait = $calc((%last + %waittime) - $ctime )
  if (%wait < 0) %wait = 0
  var %update = $ctime + %wait
  var %res = $AccessDB(GLOB,CONTROL,LASTUPDATE,%update)
  var %res = $AccessDB(COLL,%trigger,CHAN,%chan)
  var %res = $AccessDB(COLL,%trigger,UPDATE,%update)
  var %c = !wHEREiS $PSL_getWhereIsAddress $Upper(%trigger)
  PSL_Timer UPDATE_ $+ %trigger %wait  SendToTarget $iif(%ps.showwhereis,$null,.) $+ msg %chan %c
  echo $ps_h -set --> Sending Whereis Request to %chan in %wait seconds : %c
  unset %ps_wi_filter_ping
  return $calc( -1 * %wait )
}

alias PSL_getWhereIsAddress {
  if ((%ps.whereisformat !== Server) && (%ps.whereisformat !== Ip)) set -s %ps.whereisformat Ip

  if (%ps.whereisformat == Ip) {
    noop $PS_Init_Whereis_Socket(renew)
    if ($sock(WhereIs_Socket).port) {
      var %port = $ifmatch
      if ((%ps.maskip) || ($prop == mask)) return $PSE_MaskIp(%ps.whereisip,%port)
      else return $+(%ps.whereisip,:,%port)
    }
  }

}

/** Function for sending out stuff to other users. Right now it only does that by calling the method delivered, but this is subject to be tunneled later
* so all the traffic should go through this function. 
* build in spam-protection-protection - so all sendings out should go via this because it can be repeated.
* @return void
*/
alias -l SendToTarget {
  var %how = $1 ,  %to = $2 , %what = $3-

  if ($gettok(%what,1,32) == !PSSERV) {
    var %reqcounter = $AccessDB(GLOB,.COUNTER,FSERVE_PORT,++,7200)
    if (%psl.debug == on) echo -set DEBUG-INFO Current Requestcounter for FSERVE Requests is %reqcounter 
    ; %reqcounter = 55
    if (%reqcounter > 50) {
      window @pslPORTERROR
      echo 4 @pslporterror  Your DCC SERVER is not properly working to receive files. Several different ports have been tried so far. But there are now %reqcounter requests.
      echo 4 @pslporterror  Your port $dccport is not reachable from the outside world. This has NOTHING to do with your sends. It is also possible that you still get files (but not with direct transfer)
      echo 4 @pslporterror  and not a single file has been received over the dccserver port. Fix your port forwardings, check your internal IP adress. Reset your router. Turn off your firewall. but do something
      echo 4 @pslporterror  Sometimes restarting mirc is required. Do a "Test My Gets" (not Test My Sends) in one of the leech channels to find out if your dcc server receive ability is back.
      echo 4 @pslporterror  IF you dont have a router - then the router is not the problem, yes. When the problem is fixed this window will auto-close
      echo 4 @pslporterror  -
      echo 4 -set The DCC Server count has reached %reqcounter
    }
    elseif (%reqcounter > 25) {
      if (8 // %reqcounter) {
        var %old = $dccport
        .dcc server off
        var %new = $PS_InitDCCServer(repair)
        echo 4 -set Your DCC Server ports seemed to not work at4 %old $+ . It was re-opened at new port3 %new now. 
        ;; need to make our targets aware of the new port. will send a rerequest NOW
        FireAllTimeOuts
      }
    }
    elseif (%reqcounter > 10) {
      if (6 // %reqcounter) {
        var %reset = $AccessDB(GLOB,.CONTROL,RESET_DCC_PORT,0)
        echo 4 -st Going to Reset DCC Server port now. Because there could be a problem receiving files over your DCCServer at port $dccport $+ .
        echo 4 -st It is not necessarily this problem, but possible. If you keep seeing this message - check your firewall AND/OR your routers portforwarding setting.
        echo 4 -st This is the %reqcounter $+ th request, and so far no file has been received on this port.
        .dcc server off
        .dcc server on
      }
    }
    ;replace the original ip and port to the current one , which could have been changed above.. 
    %what = $puttok(%what,$+($ip,:,$dccport),2,32)
  }

  var %cmd = %how %to %what 

  var %nicktrig = $AccessDB(GLOB,TRIGS,%to)
  if (%nicktrig) {
    if ($gettok(%what,3,32) == CSV) var %res = $AccessDB(USER,%nicktrig,LASTCMDCSV,%cmd)
    else var %res = $AccessDB(USER,%nicktrig,LASTCMD,%cmd)
  }



  ;_AOFF_ psecho 15 cmd executing  ==> %cmd 
  if ($left(%to,1) == $chr(35)) %cmd
  else PS_Tunnel %cmd
  return
  :error
  PSL_Log 1 Error while %cmd  ( %How  - %to - %what ) -> $error
  reseterror
}



/** the function is blocking itself for 3 minutes every time it does a broadcast. broadcast is
* done to all channels that have a leech running and that leech has received at least 1 file 
* @return void
*/
alias -l SendBroadcastBuffer {
  var %type = $1
  if (%ps_nobroadcast) return
  var %buffer = $BroadCastBuffer(%type)
  var %count = $numtok(%buffer,32)
  if (!%count) return
  var %scon = $scon(0)
  while (%scon) {
    scon %scon
    ;    echo Doing SendBroadCastBufferWork in $ps_network
    var %channels = $null
    var %i = 0
    while (%i < %count) {
      inc %i
      var %trigger = $gettok(%buffer,%i,32)
      var %chan = $AccessDB(COLL,%trigger,CHAN)
      if (%chan) {
        %channels = $addtok(%channels,%chan,32)
      }
    }
    var %chancount = $numtok(%channels,32)
    while (%chancount) {
      var %bchan = $gettok(%channels,%chancount,32)
      dec %chancount
      ; echo -set broadcasting %type buffer ( %buffer ) to %bchan
      broadcast %bchan %type %buffer
    }

    dec %scon
  }
  set -z %ps_nobroadcast 179
}

;; if data this stores the data , if no data it clears the buffer content @return BufferContent (space separated)
alias -l BroadCastBuffer {
  var %name = $1 , %data = $2 
  var %cache = $AccessDB(GLOB,.BROADCAST,%name,.)
  if (%data) {
    %cache = $Addtok(%cache,%data,32)
    noop $AccessDB(GLOB,.BROADCAST,%name,%cache)
  }
  :error
  if ($error) reseterror
  return %cache
}

alias -l broadcast { 
  var %chan = $1 , %type = $2 , %msg = $3-
  $iif(%ps_broadcast,.timer 1 $ifmatch,$null) .msg %chan @PS $+ $lower(%type) $iif(%ps.trigger,$ifmatch,@) %msg
  inc -z %ps_broadcast 
}

;; does a broadcast to a channel 
alias PSE_Broadcast {
  var %channel = $1 , %type = $2 , %msg = $3
  return $broadcast(%channel,%type,%msg)
}

alias -l FireAllTimeOuts {
  var %i = $timer(0)
  var %new = 2
  while (%i > 0) {
    if ($timer(%i).cid == $cid) {
      var %name = $timer(%i)
      if (*_await iswm %name) {
        var %cmd = $timer(%i).com
        var %in = $timer(%i).secs
        ;echo -set Found %name > %cmd > in %in sec
        .timer [ $+ [ %name ] ] 1 %new %cmd
        %new = $calc(%new + 2)
      }
    }
    dec %i 
  }

}

;logs should always look the same - first arg is the level (1=highest level (errors) 2=highest non error (meaning rarest, like leech start or something)
alias -l PSL_Log {
  if ($window(@PSL_LeechLog)) if ($1 <= 4) echo $calc($1 + 3) -t @PSL_LeechLog $1 : $cid : $2-
  if (%psl.debug !== on) return
  var %off = 5
  if ($1 <= 4) {
    if (!$window(@PSL_Log)) window -z @PSL_Log
    echo $calc($1 + 3) -t @PSL_Log $1 : $cid $+ 5: $+ $2-
  }
  if (!$window(@PLStatus)) { var %maximum = $calc(%off * 15) | window -z @PLStatus +f Arial 10 | var %i = 1 | while (%i < %maximum) { aline @PLStatus . | inc %i } }
  ;  if ($1 == 1) beep 12
  ;_AOFF_ psecho PSL_Leech: $1-
  var %l = $calc( ( $1 - 1 ) * %off  ) + 1
  var %i = %off - 2
  while (%i >= 0) {
    rline 13 @PLStatus $calc(%l + 1 + %i) $line(@PLStatus,$calc(%i + %l))
    dec %i
  }
  rline 12 @PLStatus %l 0,1 $1 : $+ $cid $+ : $timestamp : $+ $replace($2-,$chr(9),)
}

/** Checks if still untagged files exist. @return Boolean
*/

alias -l isLeechableFileLeft {
  var %trigger = $1
  var %window = $getWindowName(LEECH,%trigger)

  var %lines = $line(%window,0)
  var %i = 0
  while (%i < %lines) {
    inc %i
    var %line = $line(%window,%i)
    var %file = $gettok(%line,4,124) $+ $gettok(%line,1,124)
    ;skip files that are leeched somewhere else or are marked in any other way.. (perhaps future use)
    if ($numtok(%line,124) > 4) continue 
    ;_AOFF_ psecho ran to line %i to find there is an untagged file
    return $true
  }
  return $false
}


/** this function finds a leechable from a certain nick name (!trig) and returns it in csv list format separated by $chr(124)
* @return String(Array)
*/
alias -l findLeechableFile {
  var %trigger = $1 , %nick = $2
  var %cwindow = $getWindowName(LEECH,%trigger)

  var %windows = $remtok( $getWindowName(LEECH,%trigger).global , %cwindow ,1,9)

  var %window = %cwindow 

  var %lines = $line(%window,0)
  var %i = 0

  var %best = $LeechCacheAccess(%trigger,%nick,%lines)
  var %steps = 0
  if (%best > 1) %i = %best - 1
  while (%i < %lines) {
    inc %i
    inc %steps
    var %line = $line(%window,%i)
    var %file = $gettok(%line,4,124) $+ $gettok(%line,1,124)
    var %size = $gettok(%line,2,124)
    if (%size <= 0) continue
    ;skip files that are leeched somewhere else or are marked in any other way.. (perhaps future use)
    if ($numtok(%line,124) > 4) {
      var %markedby = $gettok(%line,5,124)
      if (%markedby != %nick) continue 
    }
    ; echo 12 -s Checking line %i of %lines : -> %file
    ;check if someone has that
    var %userhas = $IsLeechableFromNick(%trigger,%file,%size,%nick)
    ; echo -s HAVELIST Says: user %nick has it > %userhas
    if (%userhas == $true) {
      var %r = $LeechCacheAccess(%trigger,%nick,%lines,%i)
      PSL_Log 6 Found Leechable file in line3 %i (found in %steps steps) from user %nick in win %window .
      return %line
    }
  }

  if ( $numtok(%windows,9) ) {
    var %max = $ifmatch
    var %j = 0
    while (%j < %max) {
      inc %j
      var %window = $gettok(%windows,%j,9)


      var %lines = $line(%window,0)
      var %i = 0
      var %steps = 0 

      ;;  echo -set searching in additional window %window with %lines

      while (%i < %lines) {
        inc %i
        inc %steps
        var %line = $line(%window,%i)
        var %file = $gettok(%line,4,124) $+ $gettok(%line,1,124)
        var %size = $gettok(%line,2,124)
        ;skip files that are leeched somewhere else or are marked in any other way.. (perhaps future use)
        if ($numtok(%line,124) > 4) continue 
        ;check if someone has that
        var %userhas = $IsLeechableFromNick(%trigger,%file,%size,%nick)
        ;  echo -s HAVELIST Says: user %nick has it > %userhas
        if (%userhas == $true) {
          PSL_Log 7 Found Leechable file in additional window line3 %i (found in %steps steps) from user %nick in win %window .
          dline %window %i
          PSL_Log 7 Moved Line %line from %window to %cwindow
          aline %cwindow %line
          var %r = $LeechCacheAccess(%trigger,%nick,$line(%cwindow,0),$line(%cwindow,0))
          return %line
        }
      }
    }
  }
  var %r = $LeechCacheAccess(%trigger,%nick,0)
  return $null

}


/** Check what is best to be leeched with various factors. 
*  Checks for: Free is the percent of free slots, 
*   Queued is the percent of free queue slots and max speed. @return trigger
* @optparam mode if keyword count will return how many targets are available 
*  keyword countactive counts the currently active users Note that countactive can be > count (available) because of already XLOCKED but still active users.
*/
alias -l findBestLeechTarget {
  var %trigger = $1 , %mode = $2
  var %window = $getWindowName(WHEREIS,%trigger)

  if ($window(%window)) {

    var %lines = $line(%window,0)
    var %chan = $AccessDB(COLL,%trigger,CHAN)
    var %avail = 0 , %active = 0
    var %i = 1
    var %bestline = 0
    var %bestval = 0
    var %maxspeed = 0
    var %start = $uptime(mirc)

    var %printlist 

    while (%i <= %lines) {
      var %t = $line(%window,%i)
      var %ms = $sqrt($calc($gettok(%t,11,9) * $speedtobytes($gettok(%t,8,9))))
      if (%ms > %maxspeed) %maxspeed = %ms
      inc %i
    } 
    var %i = 0

    while (%i < %lines) {
      inc %i

      var %t = $line(%window,%i)
      ;echo 12 -s CHECKING: %t  << mode: %mode
      var %usertrig = $gettok(%t,2,9)
      ; skip the gone users  -- use the interal database because the whereis window could contain a different nick
      if ($AccessDB(GLOB,NICKS,%usertrig) !ison %chan) {
        ; echo -s 8,1 user %usertrig is not in the chan %chan
        continue
      }
      if ($AccessDB(USER,%usertrig,BLOCK)) continue
      ;skip the out of file users
      if ($AccessDBList(COLL,%trigger,RUNDRY,%usertrig,T)) continue
      ;echo 12 -s NOT RUNDRY

      var %islock = $PSL_IsLock(%usertrig,%trigger)
      ; if we look for active threads we skip the lock - because it does not matter and a user can still be active in X while locked to Y
      ; $PSL_IsLock does that, it will  return false if the user is not locked _OR_ this trigger is better than the locked one
      ; the idea is to count everyone as available to all collections as long as the priority is better until they are really locked to 
      ; any one, so a user can be passed along to the top priority _BUT ONLY IF NEEDED_ !
      if (%islock) continue
      var %tcmd = $hasTimer(%usertrig)
      var %dlock = $AccessDB(USER,%usertrig,DOWNLOADING)

      ;echo 12 -s NOT Locked but busy? $IsUserBusy(%usertrig)
      ;skip the busy users

      ;; first we have to check if this user is locked to some trigger other than our own,
      ;; that can happen since PSL_IsLock returns False if a worse  - while 
      ;; it returns true only if there is a lock to something ELSE and in that case we assume the user is FREE
      ;; since we will free him in the end (and we do that because the other collection is worse than this one,
      ;; unless we would not have gotten to this point here)

      if (!$PSL_IsLock(%usertrig,%trigger).honest) var %isUserBusy = $IsUserBusy(%usertrig)
      ; since we got this far and this trigger does have another lock we will get it free _IF_ needed
      else                                        var %isUserBusy = $false
      ;psdl 13 found out that %usertrig for %trigger is busy= %isUserBusy (Lock (to other): $PSL_IsLock(%usertrig,%trigger).honest )
      if (%isUserBusy) {
        var %loading =  $AccessDB(USER,%usertrig,ADDINGHAVELIST)
        var %dllcheckrun =  $CheckCheckingUser(%usertrig)
        var %resetin = $IsUserBusy(%usertrig).howlong
        ; echo -sat -> user %usertrig for %trigger -> L: %loading , C: %dllcheckrun , D: %dlock , T: %tcmd , E: %expected

        ; echo -set for the BUSY %usertrig we find a timer %tcmd and a lock for %lock .. maybe a download too ? %dlock  --> loadinghavelist: %loading --> reset in %resetin -> dllcheck; %dllcheckrun
        ;; these are all known reasons why a user is busy and locked .. else it is an external reason and 
        ;; this user is BUSY for this trigger too
        if (%dlock || %loading || %dllcheckrun || %tcmd) {
          inc %avail
          inc %active
          %printlist = $addtok(%printlist,%usertrig,44)
          if (%mode) {
            var %action = %usertrig $+ : $+ $iif(%dlock,DL,$iif(%loading,LOADHAVE,$iif(%dllcheckrun,CHECKING,$iif(%tcmd,TMR:14 $+ %tcmd $+ ,ELSE))))
            var %actionlist = $addtok(%actionlist,%action,44)
          }
        }
        elseif ($isExpectedTransfer(%usertrig,*).NetWork) {
          PSL_Log 1 user %usertrig was freed because there was no timer or anything running but $ifmatch was expected
          var %freec = $FreeUserFromEverything($AccessDB(GLOB,NICKS,%usertrig))
          if (%freec) noop $AccessDB(COLL,%freec,THREADS,--)
        }
        else {
          psecho user %usertrig has no timer %tcmd and no download lock ??? but the user is busy > $ifmatch (lock %lock ) -> loading? %loading reset: %resetin -- check? %dllcheckrun timers: 
          if (!%resetin)  SetUserFree %usertrig 600
          ;; timer
        }
        continue
      }
      else {
        inc %avail
        %printlist = $addtok(%printlist,%usertrig,44)
        if ($PSL_GetLock(%usertrig)) {
          var %lock = $ifmatch
          if ($isupper(%lock)) {
            PSL_SetLock %usertrig
            PSL_Log 4 User %usertrig had a permanent lock to %lock (also dl: %dlock tmer: %tcmd ) but was not busy. Lock was removed
          }
        }
      }

      ;; if we are just counting something we dont need to calculate these values
      if (%mode) continue 


      var %free = $calc($gettok(%t,11,9) - $gettok(%t,10,9)) / $gettok(%t,11,9)
      var %queued = $calc(($gettok(%t,13,9) - $gettok(%t,12,9) +1 ) / ($gettok(%t,13,9) +1) )

      var %noqueue =  $gettok(%t,14,9)
      var %creditsfactor = $gettok(%t,15,9)

      var %speed = $speedtobytes($gettok(%t,8,9))
      if (%speed == 0) %speed = $calc( $speedtobytes($gettok(%t,9,9)) / 10 )
      %speed = %speed * $gettok(%t,11,9)
      %speed = $calc( $sqrt(%speed) / %maxspeed  )

      var %sum = $calc( 50 * %free + 20 * %queued + %speed * 30 +  %noqueue * 40 + %creditsfactor * 25 )
      ; echo %usertrig Found: Free %free Queuedfree: %queued  Speed: %speed  => %sum <<<< %t
      var %res = $PSL_TreeOp(add,Leech %trigger Targets %usertrig Evaluation,Free %free Queuedfree: %queued  Speed: %speed Credits: %creditsfactor => %sum)

      if (%sum > %bestval) {
        %bestval = %sum
        %bestline = %i
      }
    }
    :error 
    if ($error) {
      echo -set findbestleechtarget failed -> $error <- will continue with what we have so far
      reseterror
    }
    ;    if (%mode == count) echo -set  FindBestTarget ( %mode , %trigger ) ->12 %actionlist ( %active )-->13 %printlist -> %avail
    var %res = $PSL_TreeOp(add,Leech %trigger Available_Targets, %avail of the active %active)
    if (%mode) {
      if (%mode == count) return %avail
      elseif (%mode == countactive) return %active
    }
    var %dur = $uptime(mirc) - %start
    ; PSL_Log 8 Found best result in %dur ms for Collection12 %trigger $+ . Resulting user7 $gettok($line(%window,%bestline),2,9)
    if (%bestline == 0) return $null
    ; echo FINAL: best result line %bestline with a value of %bestval  -->  THIS: $line(%window,%bestline)
    var %bestuser = $gettok($line(%window,%bestline),2,9)
    ;;
    ;; now, since we return this user as best and free for this collection we have to free him in case he was locked to a worse collection
    if (%bestuser) {
      if ($PSL_IsLock(%bestuser,%trigger).honest) {
        var %nick = $AccessDB(GLOB,NICKS,%bestuser)
        if ($FreeUserFromEverything(%nick)) .timer 1 1 RequestAFile $ifmatch 
        PSL_Log 3 Stole user %bestuser $+   ( %nick ) from another collection $ifmatch and using him/her now for %trigger
      }
    }
    psdl 10 findBestLeechTarget ( %trigger , %mode ) --> %bestuser
    return %bestuser
  }
  if (%mode) return 0
  return $null

}

/** Small tool function to return the number of bytes from a text formated string representing a size. Like e.g. 1M or 2k or 3.4k @return Int
*/

alias -l speedtobytes {
  if ($1 isnum) return $1
  else if (($right($1,2) == kb) || ($right($1,1) == k) ) return $calc($calc($1) *1024 )
  else if (($right($1,2) == Mb) || ($right($1,1) == m) ) return $calc($calc($1) *1024 * 1024 )
  else if ($right($1,1) == b ) return $calc($1) 
  else psecho 4 unknown speed  $1
}

;;;
;;;
;;;

alias -l getPartControlFile {
  var %basefile = $1
  var %file = $shortfn($left($nofile(%basefile),-1)) $+ $nopath(%basefile)
  if ($prop == new)   return %file $+ .pspCctl
  return %file $+ .pspctl
}

/* partcontrol stores and checks for available parts of a file in a control file.
* @return crc or $Null  @param action can be T (TEST) or S (TO Set a crc) or C (to clear, same as setting crc 0)
*/

alias -l partcontrol2 {
  var %cfile = $1 , %part = $2 , %action = $3 , %crc = $4
  var %pos = $calc((%part - 1) * 8)
  if (%action == T) {
    fopen IN $qt(%cfile)
    fseek IN %pos
    var %read = $fread(IN,8,&crc)
    fclose IN
    var %is = $bvar(&crc,1,8).text
    echo -> tested in %cfile => %read == 8 ?  -> is: %is   ( should be not null ) 
    return $base(%is,16,10)
  }
  else {
    if (%action == C) var %crc = 0 
    if ($exists(%cfile)) .fopen OUT $qt(%cfile)
    else .fopen -n OUT $qt(%cfile)
    .fseek OUT %pos
    .fwrite OUT $base(%crc,10,16,8)
    .fclose OUT
  }
}

; function to set/clear/test parts of a given file by using a control file @return Void
alias -l partcontrol {
  var %cfile = $1 , %part = $2 , %action = $3
  dec %part
  var %pos = $int($calc(%part / 32 + 1))
  var %bit = $calc(%part % 32 + 1)
  ;  var %cfile = $getPartControlFile(%file) 
  if ($file(%cfile)) {
    if ($fopen(IN)) fclose IN
    .fopen IN $+(",%cfile,")
    .fseek -l  IN %pos
    var %value = $fread(IN)
    .fclose IN
    ; echo -set readin line %pos -> %value
  }
  else {
    .fopen -n OUT $+(",%cfile,")
    .fwrite OUT $str($crlf,400)
    .fclose OUT
  }
  if (%action == T) return $isbit(%value,%bit)
  if (%action == C) var %output = $bitoff($iif(%value,%value,0),%bit)
  else var %output = $biton($iif(%value,%value,0),%bit)
  ; echo -s -> TestBitField for %part : pos %pos bit %bit -> value %output
  write -l $+ %pos $+(",%cfile,") %output
}


/* a small function that generates a part control file for a file only by the size  of the file assuming it was a regularly downloaded file that has all parts 
*  untested but should work   @return void
*/
alias PSL_ConvertFileToParts {
  var %file = $1-
  var %partsize = $CreateFilePartFromFile().partsize
  var %parts = $calcparts( $file(%file) , %partsize )
  var %ctl  = $GetPartControlFile(%file)
  echo ->6 %file has already downloaded5 %parts parts. writing control file7 %ctl
  while (%parts) {
    noop $partcontrol(%ctl,%parts)
    dec %parts
  }
}

alias PSL_ConvertALLFromOld noop $findfile(%ps.downp $+ \PSTEMP\,*,0,if ($file($1-) > 3000000) PSL_ConvertFileToParts $1-)

;; Function that returns the last part that is present without any gap from the part 1  @return Integer
alias -l getmaxpartcount {
  var %file = $1 
  if ($fopen(IN)) fclose IN
  .fopen IN $+(",%file,")
  var %max = 0
  while (!$feof) {
    var %l = $fread(IN)
    if ($base(ffffffff,16,10) == %l) %max = %max + 32
    else {
      var %i = 1
      while ($isbit(%l,%i)) inc %i
      dec %i
      ; echo -set all bits in the last were set to bit %i (current max is %max )
      %max = %max + %i
      break
    }
  }
  .fclose IN

  return %max
}

alias -l getcompletepparts {
  var %file = $1  
  if ($fopen(IN)) fclose IN
  .fopen IN $+(",%file,")
  var %max = 0
  while (!$feof) {
    var %l = $fread(IN)
    if ($base(ffffffff,16,10) == %l) %max = %max + 32
    else {
      var %i = 32
      while (%i > 0) {
        if ($isbit(%l,%i))  inc %max

        dec %i
      }
    }
  }
  .fclose IN
  return %max
}


/** Sets a file expected to the internal database. Is checked by IsExpectedTransfer. @return void @param username is the nickname of the user. 
* @param trigger is the triggername of the collection
*/
alias -l SetExpectedTransfer {
  var %username = $1 , %origname = $2 , %trigger = $3 , %path = $4 , %size = $5 , %crc = $6
  var %usertrig = $AccessDB(GLOB,TRIGS,%username)
  if (%usertrig) %username = %usertrig
  var %origname = $nopath(%origname)
  var %filename = $ReplaceCharsInFileName(%origname)
  var %DBNAME = .EXPECT
  ; store data : cid * Trigger * orig filename * destination
  var %DATA = $+($cid,$chr(9),%trigger,$chr(9),%origname,$chr(9),%path,$chr(9),%size,$chr(9),%crc)
  var %KEY = $+(%username,$chr(9))
  ; var %hashname = $AccessDB(GLOB,%DBNAME).GetName
  ; hdel -w %hashname $+(%KEY,*)
  var %KEY = $+(%KEY,%filename)
  var %res = $AccessDB(GLOB,%DBNAME,%KEY,%DATA)
}

/** Function to check if a received file is expected by the leech system. Will return the Data (tabsep) stored in the expect hash.
* @optparam delmode If "." it will remove the data after retrieval
* @param filename if filename is expected, function returns the data. '*' to return the actual filename that is expected from the user 
* @return String @prop network will ony return the file expected in the current network
* @prop restorecrc will reset the crc of an expected file to the value of delmode
*/
alias -l IsExpectedTransfer {
  var %username = $1 , %filename = $2 , %delmode = $3
  var %filename = $replace($nopath(%filename),$chr(32),_)
  ;; check the database
  var %usertrig = $AccessDB(GLOB,TRIGS,%username)
  ;; check all databases
  if (!%usertrig) var %usertrig = $FindBestMatchingUserTrig(%username) 
  ; store the !trigger of a user if possible (so renames or part/joins are not a problem)
  if (%usertrig) %username = %usertrig
  var %DBNAME = .EXPECT 
  var %KEY = $+(%username,$chr(9),%filename)
  ; echo -set debug: %username ++ %filename +++ %delmode ++++ $prop
  if (%filename == *) {
    ; check if the network is the same if we are limited to network
    if ($prop == network)  var %DATA = $AccessDB(GLOB,%DBNAME,%KEY,*).network
    else  var %DATA = $AccessDB(GLOB,%DBNAME,%KEY,*)
    if (%DATA) return $gettok(%DATA,2,9)
  }
  else {
    if ($prop == restorecrc) {
      var %DATA = $AccessDB(GLOB,%DBNAME,%KEY)
      var %DATA = $puttok(%DATA,%delmode,6,9)
      ;  echo -set -> set new data by restorecrc: %DATA
      if (%DATA) noop $AccessDB(GLOB,%DBNAME,%KEY,%DATA)
    }
    else {
      var %DATA = $AccessDB(GLOB,%DBNAME,%KEY,%delmode)
    }
    ; echo -s DEBUG: Data from IsExpected shows: cid = $gettok(%DATA,1,9) < we are in $cid currently DATA: %DATA ( %username )

    if (%DATA) return %DATA  
  }
  return $null
}

/** Returns the replaced Name
* @return String
*/

alias -l ReplaceCharsInFileName {
  var %original = $1
  return $replace(%original,$chr(32),_)
}

;;;;;
;;;;;

/** Free All users from all marks - run on Re-Connect to Server. As a side effect it will not unset/recover files still in transmission, so it will increase the 
* number of THREADS for those collections, instead of unsetting all marks. This requires that the number of Threads is RESET to 0 BEFORE 
* this alias is called. @return void @param void
*/

alias -l FreeAllUsers {
  var %list = $AccessDB(USER)
  var %i = $numtok(%list,9)
  while (%i > 0) {
    ;    SetUserFree $gettok(%list,%i,9)
    var %nick = $AccessDB(GLOB,NICKS,$gettok(%list,%i,9))
    var %trigger = $FreeUserFromEverything(%nick,noforce)
    if (%trigger) {
      ;_AOFF_ psecho Did not unset for one thread of %trigger
      var %res = $AccessDB(COLL,%trigger,THREADS,++)

    }
    ;_AOFF_ psecho Freeing user %nick , $gettok(%list,%i,9) -- > %col
    dec %i
  }
}

/**
* Sets A lock for a collection to be used to not lose a user to a another collection while the user is not busy
* @param collection the collection trigger, but if empty it will clear the lock for this user
* @return Void 
*/
alias -l PSL_SetLock {
  var %usertrig = $1 , %collection = $2 , %timeout = $3
  if (!%timeout) %timeout = 1800
  if (!%collection) %collection = . 
  psdl 5 PSL_SetLock * %usertrig * %collection * ( %timeout )
  noop $AccessDB(USER,%usertrig,XCLUSIVE,%collection,%timeout)

}
/**
* Returns the Lock of the User. If there is no lock or an invalid lock it returns NULL
* @return Collection
*/
alias -l PSL_GetLock {
  var %usertrig = $1
  ;psdl 6 PSL_GetLock * %usertrig 
  if (!%usertrig) return
  var %lock = $AccessDB(USER,%usertrig,XCLUSIVE)
  if (%lock) {
    var %lwindow = $getWindowName(LEECH,%lock)
    if (!$window(%lwindow)) %lock = $null
    var %unsettime = $AccessDB(USER,%usertrig,XCLUSIVE).unset
    %lock = $iif(%unsettime,$lower(%lock),$upper(%lock))
  }
  ;psdl 6 return $qt(%lock) ( %unsettime ) 
  return %lock
}
/**
* Checks if User Is Currently locked to a collection. The collection parameter is used to compare the internal 
* priority, to find out if a lock is valid compared to the collection. Lower Priorities bypass locks to higher 
* priority collection automatically. Note, that you have to check/set the Lock after querying with IsLock again, since 
* IsLock may return false even if there is a lock (but to another collection with a worse priority)
* @return Boolean returns <code>$true<code> if the user is locked to another/better collection ( NOT free for this collection ) 
* @prop honest ignores priority and really returns false if user is not locked to any other collection
*/
alias -l PSL_IsLock {
  var %usertrig = $1 , %collection = $2
  psdl 7 PSL_IsLock (8 $prop ) * %usertrig * %collection 
  var %lock = $PSL_GetLock(%usertrig)
  var %return = $false
  if (%lock) {
    psdl 7 %usertrig has lock to %lock 
    if (%lock != %collection) {
      if ($prop == honest) return $true
      var %lockpri = $iif($AccessDB(COLL,%lock,PRIORITY),$ifmatch,0) , %collpri = $iif($AccessDB(COLL,%collection,PRIORITY),$ifmatch,0)
      var %override = $iif(%lockpri > %collpri,$true,$false)
      psdl 7 %usertrig is locked to %lock . checking with %collection 3(current:8 %lockpri > 3compare:8 %collpri 3==> override: $iif(%override,possible,4not possible) ) 
      if (!%override) %return = $true
    }
  }
  psdl 7 returns for %usertrig checking trigger %collection -> $qt(%return)
  return %return

}
/** 
* debug alias 
* intended colors 5=Set 6=Get 7=Is  
*                 3=OK  4=ERROR
* @return Void
*/
alias -l psdl {
  var %col = $1 , %text = $2-
  if (!%ps.leech.debuglock) return
  var %win = @psleechdebuglock
  if (!$window(%win)) window %win
  echo %col -t %win $Network > %text
}

/**
* Sets a user to busy in internal database, which means we wait for some kind of reaction 
* (eg. finished download, start of download, reply to command,...)
* @return Void
*/
alias -l setUserBusy {
  var %usertrig = $1 , %trigger = $2 
  noop $AccessDB(USER,%usertrig,BUSY,Yes)
  if (%trigger) PSL_SetLock %usertrig %trigger
  .timer 1 1 PSA_NC_RecolorNick $AccessDB(GLOB,NICKS,%usertrig)

}
alias -l setUserFree {
  var %usertrig = $1 , %timeout = $2
  if (!%usertrig) return 
  if (%timeout) {
    var %res = $AccessDB(USER,%usertrig,BUSY,Yes,%timeout)
    .timer 1 $calc(1 + %timeout) PSA_NC_RecolorNick $!AccessDB(GLOB,NICKS, %usertrig )
  }  
  else {
    var %res = $AccessDB(USER,%usertrig,BUSY,No)
    PSA_NC_RecolorNick $AccessDB(GLOB,NICKS,%usertrig)
  }
  var %res = $AccessDB(USER,%usertrig,QUEUE,.)
  var %res = $AccessDB(USER,%usertrig,RESENDOK,.) 

}
/**
* Checks if a user is free to be used or already in use for some other action
* @return Boolean
* @prop howlong returns the number of seconds until the busy flag is removed.. 0 if never
*/

alias -l isUserBusy {
  var %usertrig = $1
  if (!%usertrig) return
  if ($prop == howlong) return $AccessDB(USER,%usertrig,BUSY).unset
  var %res = $AccessDB(USER,%usertrig,BUSY)
  if (%res == Yes) return $true
  else return $false
  :error
  echo -sat Debug-Ex-Error-now-only-a-warning-problem in $ps_Network in isUserBusy() $error -> for user %usertrig
  reseterror
}


/** Resets all Marks from a User like expected files and Busy. Returns the Actual Collection Trigger he was working.
* @optparam mode if keyword is NOFORCE it will only return the CollectionTrigger IF unset was unsuccessful because a file was still in process
* @return CollectionTrigger 
* @prop onlyfree tells the alias to just do nothing if a file is actualy in transfer for that user
*/
alias -l FreeUserFromEverything {
  var %nick = $1, %mode = $2
  var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
  ;  echo -set called FreeUserFromEveryThing( %nick , %mode ) => %usertrig
  if (!%usertrig) return
  ;;;; check for awaiting csvs 
  while ($true) {
    var %file = $IsCSVExpected(%usertrig,*)
    if (!%file) /break
    var %data = $IsCSVExpected(%usertrig,%file,.)
    ;_AOFF_ psecho Data: %data for expected csv file %file was purged
    var %trigger = $gettok(%data,2,9)
    .timer 1 11.1 RequestACsvFile %trigger
  }
  ;;;;; end of check for awaiting csvs 
  var %busy = $IsUserBusy(%usertrig)
  ;_AOFF_ psecho (FreeUserFromEverything) Freeing %nick ( %usertrig ) -- > %busy 
  ; check if a file was expected IN THIS NETWORK
  var %file = $IsExpectedTransfer(%nick,*).network
  if ((%busy == $true) || (%file)) {
    var %trigger = $null
    if (%file) {
      if ((%mode == noforce) || ($prop == onlyfree)) {
        var %check = $get(%nick,0)
        var %transit = $false
        while (%check > 0) {
          if ($get(%nick,%check).file == %file) %transit = $true
          dec %check
        }
        if (%transit) {
          var %data = $IsExpectedTransfer(%nick,%file)
          var %trigger = $gettok(%data,2,9)
          ;_AOFF_ psecho CHECK of %nick get for %data ==> FIle ins transit: %transit for collection %trigger ---  
          var %res = $MarkActionForCollectionfile($gettok(%data,2,9),$+($gettok(%data,4,9),$gettok(%data,3,9)),S,%usertrig)
          if ($prop == onlyfree) return $null 
          ; in NOFORCE mode it will return the collection trigger IF it did not reset everything (which means file is still in transmission)
          return %trigger
        }
      }
      var %data = $IsExpectedTransfer(%nick,%file,.)
      var %trigger = $gettok(%data,2,9)
      var %cid = $gettok(%data,1,9)
      if (%cid !== $cid) scid %cid

      var %res = $MarkActionForCollectionfile(%trigger,$+($gettok(%data,4,9),$gettok(%data,3,9)),C)
    }
    var %res = $AccessDB(USER,%usertrig,DOWNLOADING,.)

    ;check for waiting HAVELIST
    if (  $AccessDB(USER,%usertrig,WAITHAVE,.) ) var %trigger = $ifmatch

    PSL_Timer %usertrig $+ _* off
    SetUserFree %usertrig
    ;reset the xclusive flag to free after xx sec - we have been using this nick for %trigger and for 30 seconds it is still reserved for this 
    if ( $PSL_GetLock(%usertrig) ) PSL_SetLock %usertrig $ifmatch 30
    ;clear any possible cache entries
    var %r = $LeechCacheAccess(%trigger,%usertrig,0)
    PSL_Log 11 Free User From Everything User %nick --> %usertrig --> %trigger ( %busy ) --> File: %file
    var %res = $PSL_TreeOp(del,Leech %trigger Targets %usertrig)

    ; usualy returns $null in NOFORCEMODE
    if (%mode == noforce) return $null
    ; make sure the other end is not queued or still sending
    PS_Tunnel .ctcp %nick !PSKILL
    return %trigger

  }

}


/** this is what happens when the user quits or leaves the channel. he will be removed from any actual requests and set to unbusy
* @return CollectionTrigger
*/
alias -l UserLeft { 
  var %nick = $1
  ;; check if the user was in await state. if file is transfered this will not return the Collection (as the end of file received or fail will trigger)
  var %trig = $FreeUserFromEverything(%nick).onlyfree
  if (%trig) {
    ;_AOFF_ psecho 13,2 The USER %nick has left the channel (maybe quit). He was known to be leeched on coll7 %trig . Will start a new request in 11.1 sec
    ;_AOFF_ psecho 7,8 REASON for leaving: $2-
    .timer 1 11.1 RequestAFile %trig
    PSL_Log 7 User %nick was freed from everything for leaving leech of %trig :: $2-
    return %trig
  }
}



/** Method for accessing the DB Hashes that are created, so it can be accessed more convenient and safer (changes centralized). 
* @optparam val value to store to the field.  if the value is '.' (a single dot) it will return the result and destroy it. If the value is '*'
* it will search for a matching key and return it. If the value is '++' or '--' it will increase or decrease the counter and return the updated value.
* If no value, it returns the actual content of that entry. Everything else is stored.
* @param name if name starts with a '.' (dot) it will become a global hash. If the name starts with a '?' it will match any connectionid (this 
* is to find the right context if it was lost (eg. Fserve) )
* @return String @prop Free Frees the entire HASHRECORD and returns success
* @optparam timer Sets the timer to destroy the value after that time in seconds.
*/
alias AccessDB {
  var %type = $1 , %name = $2 , %key = $3 , %val = $4 , %timer = $5
  ;; Special treat if no Name it returns all the existing names
  if (!%name) {
    var %rep
    var %count = $hget(0)
    var %HASHNAME = $GenerateHashName(%type,*,$cid)
    while (%count > 0) {
      var %name = $hget(%count)
      if (%HASHNAME iswm %name) %rep = $addtok(%rep,$right(%name,$calc($len(%name)+1-$len(%HASHNAME))),9)
      dec %count
    }
    return %rep
  }
  ;; special check if we need a wild search thought the server cids
  else if ($left(%name,1) == ?) {
    ;; check all exiting cids
    %name = $right(%name,$calc($len(%name)-1))
    var %count = $scid(0)
    var %i = 0
    var %return 
    while (%i < %count) {
      inc %i 
      var %cid = $scon(%i)
      var %checkhash = $GenerateHashName(%type,%name,%cid)
      var %result = $AccessDBInt(%checkhash,%key)
      if (%result) {
        %return = %return $+ %cid $+ $chr(9) $+ %result $+ $chr(8)
      }
    }
    if (%return) {
      return $left(%return,$calc($len(%return)-1))
    }
    else return $null
  }
  else {
    %name = $replace(%name,$chr(32),?)
    var %HASHNAME = $GenerateHashName(%type,%name,$cid)
    if ($prop == GetName) return %HASHNAME
    if ($prop == Free) { if ($hget(%HASHNAME)) hfree %HASHNAME | return $true }
    if ($prop == network)  return $AccessDBInt(%HASHNAME,%key,%val,%timer).network
    if ($prop == unset)     return $AccessDBInt(%HASHNAME,%key,%val,%timer).unset
    return $AccessDBInt(%HASHNAME,%key,%val,%timer) 
  }
  :error
  psecho 4 caught error in AccessDB: $error --> %hashname  key: %key 
  reseterror
}

alias -l AccessDBInt {
  var %HASHNAME = $1 , %key = $2 , %val = $3 , %timer = $4

  if (%val == *) {
    var %count = $hfind(%HASHNAME,%key,0,w)
    var %i = 0
    while (%i < %count) {
      inc %i
      var %ret = $hfind(%HASHNAME,%key,%i,w)
      var %data = $hget(%HASHNAME,%ret)
      if (%psl.showdb)    psecho in the DB %hashname .. no %i we found4 %ret for the key:6 %key of %count >> pointing to %data
      if (($prop == network) && ($gettok(%data,1,9) !== $cid)) continue
      return %ret
    }
    return
  }
  else if (%val == **) {
    var %ret = $hfind(%HASHNAME,%key,1,W)
    if (%psl.showdb)    psecho in the DB %hashname .. we found4 %ret for the key:6 %key  WILD
    return %ret
  }

  else if (%val == .) {
    if (!$hget(%HASHNAME)) return 
    var %ret = $hget(%HASHNAME,%key)
    if (%ret !== $null) hdel %HASHNAME %key
    elseif (* isin %key) hdel -w %HASHNAME %key
    if (%psl.showdb)    psecho in the DB %hashname .. we found4 %ret for the key:6 %key  4DELETED
    return %ret
  }
  else if (%val == ++) {
    var %ret = $hget(%HASHNAME,%key) |  if (!%ret) %ret = 0 | inc %ret 
    if (%timer) /hadd -mu $+ %timer %HASHNAME %key %ret
    else /hadd -m %HASHNAME %key %ret
    if (%psl.showdb) psecho 14 access to DB:5 %HASHNAME the key:6 %key and data to store:12 %val T: $+ %timer 15Value now: %ret 
    return %ret
  }
  else if (%val == --) {
    var %ret = $hget(%HASHNAME,%key) | if (!%ret) %ret = 0 | dec %ret 
    if (%psl.showdb) psecho 14 access to DB:5 %HASHNAME the key:6 %key and data to store:12 %val T: $+ %timer 15Value now: %ret 
    /hadd -m %HASHNAME %key %ret 
    return %ret
  }
  else if (%val != $null) {
    if (%timer) /hadd -mu $+ %timer %HASHNAME %key %val
    else /hadd -m %HASHNAME %key %val
    if (%psl.showdb) psecho 14 access to DB:5 %HASHNAME the key:6 %key and data to store:12 %val T: $+ %timer
    return $true
  }
  else {
    ; echo 14 -s access to DB:5 %HASHNAME the key:6 %key and  Data fetched:12 $hget(%HASHNAME,%key)
    if ($prop == unset) return $hget(%HASHNAME,%key).unset
    else                return $hget(%HASHNAME,%key)
  }
}
/** @return String 
*/
alias -l GenerateHashName {
  var %type = $1 , %name = $2 , %cid = $3
  var %HASHNAME = PSL_ $+
  if ($left(%name,1) !== .) %HASHNAME = %HASHNAME $+ %cid $+ _ 
  %HASHNAME = %HASHNAME $+ %type $+ _ $+ %name
  return %HASHNAME
}

/** access to the DB in list format. @optparam mode no option for mode will store the val, "r" will remove the val from the list 
*        and "t" will test if it is in the list
* @return Boolean
*/
alias AccessDBList {
  var %type = $1 , %name = $2 ,  %key = $3 , %val = $4 , %mode = $5
  var %old = $AccessDB(%type,%name,%key)
  var %new
  if (!%val) return %old
  if (%mode == t) {
    return $istok(%old,%val,9)
  }
  else if (%mode == r) {
    if (!$istok(%old,%val,9)) return
    %new = $remtok(%old,%val,9)
  }
  else {
    %new = $addtok(%old,%val,9)
  }
  ;if we need a clear set new to .
  if (!%new) %new = .
  %old =  $AccessDB(%type,%name,%key,%new)
}

/** Fetch the best next entry point for a collection leech. If max is 0 it will unset every cache entry.
* @optparam line is the current line to be set. if not given it will return the correct line
* @return Int
*/
alias -l LeechCacheAccess {
  var %trigger = $1 , %user = $2 , %max = $3 , %line = $4
  /** important to trash the whole cache during the last few (20) files. This is to solve a problem that can occur:
  * leeched files were  tagged but leecher went away and the file was freed. now everyone that already skipped that file
  * will not be aware of the free file infront of that. so during the last 20 files everything is searched always.
  */
  if ((%max > 0) && (%max < 20)) return 0 
  if (!%max) {
    var %cachel = $AccessDB(COLL,%trigger,CACHE_LINE_ $+ %user,.)
    var %cachem = $AccessDB(COLL,%trigger,CACHE_MAX_ $+ %user,.)
    return 0
  }
  else if (%line !== $null) {
    var %r = $AccessDB(COLL,%trigger,CACHE_LINE_ $+ %user,%line,600)
    var %r = $AccessDB(COLL,%trigger,CACHE_MAX_ $+ %user,%max,600)
    return 0
  }
  else {
    var %cachel = $AccessDB(COLL,%trigger,CACHE_LINE_ $+ %user)
    var %cachem = $AccessDB(COLL,%trigger,CACHE_MAX_ $+ %user)
    if (!%cachem) return 0 
    if (!%cachel) return 0
    var %best = $calc(%cachel - (%cachem - %max) )
    ; PSL_Log 14 CACHE: --cacheL %cachel --chacheM (oldmax): %cachem --current: %line ---currentmax: %max --res: %best --nick %user --trig %trigger
    return %best
  }
}


alias -l ProcessReceivedHaveList {
  var %trigger = $1 , %user = $2 , %havefile = $3-
  ; PSL_Log 4 Processing the previously received HAVELIST for Collection %trigger from user %user
  ; var %havefile = $FindHaveListFileForUser(%trigger,%user)
  ; echo 4 -s Using This HaveFile: %havefile
  if (!%havefile) { 
    PSL_Log 1 Error no havelist found for %trigger and user: %user .. 
    var %res = $AccessDBList(COLL,%trigger,RUNDRY,%user)
    noop $ProcessReceivedHaveList_End(%trigger,%user,empty,$false)
  }
  else {
    ; this will lead to ProcessReceivedHaveList_End when it is done
    noop $AddHaveListToHash(%trigger,%user,%havefile)
  }

}


alias -l ProcessReceivedHaveList_End {
  var %trigger = $1 , %user = $2 , %havefile = $3 , %good = $4 , %numoffiles = $5
  if (%good)  {
    echo $ps_n -st --> Havelist Data added. %numoffiles fileentrys from 12 %user $+ . %havefile deleted.
    noop $saferemove(%havefile).nobin
    var %res = $AccessDB(USER,%user,$+(HAVECOUNT_,%trigger),%numoffiles)

    ;clear any possible cache entries
    ;    var %r = $LeechCacheAccess(%trigger,%user,0)

    PriSort %trigger %psl.defaultorder

    if (0 < %numoffiles) {
      var %res = $AccessDBList(COLL,%trigger,HAVEHAVE,%user)

      var %had = $AccessDB(COLL,%trigger,SEENCOUNT_ $+ %user)
      var %sendcount = $iif(%numoffiles < %had,$true,$false)

      PSL_Log 3  Processing havelist of %User returned he has %numoffiles .. his whereis reply showed: %had $iif(%sendcount, -04 Sending a !PSCOUNT to correct,$null)
      ; this is no longer an error.
      if (%sendcount) PS_Tunnel ctcp $AccessDB(GLOB,NICKS,%user) !PSCOUNT %Trigger


    }
    else {
      var %res = $AccessDBList(COLL,%trigger,RUNDRY,%user)
    }
  }
  SetUserFree %user
  PSL_SetLock %user %trigger 33
  RequestAFile %trigger

}

;; loads a havelist for a certain user and stores the content in the hash marking each file with the username
;; returns the number of found files. 0 on error (unless a empty file is loaded but.. )
alias -l AddHaveListToHash {
  var %trigger = $1 , %user = $2 , %havelistfile = $3

  var %id = $ticks $+ _ $+ $remove(%user,$chr(32),*,%,!,$,&) $+ _H
  var %HANDLE = HAVELIST_ $+ %id
  %havelistfile = $+(",%havelistfile,")
  .fopen %HANDLE %Havelistfile
  if (!$ferr) {
    hadd -m PSL_PROC_ $+ %id count 0
    hadd -m PSL_PROC_ $+ %id extra 0
    hadd -m PSL_PROC_ $+ %id start $uptime(mirc)
    hadd -m PSL_PROC_ $+ %id HANDLE %HANDLE 
    hadd -m PSL_PROC_ $+ %id HAVEFILE %havelistfile 
    hadd -m PSL_PROC_ $+ %id USER %user
    hadd -m PSL_PROC_ $+ %id TRIGGER %trigger
    ; start the timer that will run the mid part
    .timer -m 0 $iif(%ps_havelistloaddelay,$ifmatch,700) AddHaveListToHash_Middle %id
    return 1
  }
  ; returning an error 
  :error 
  echo -st * $error / $ferr (handled) %trigger  - %user - %havelistfile - %id 
  reseterror
  if ($fopen(%HANDLE)) .fclose %HANDLE
  hfree -s PSL_PROC_ $+ %id
  return 0
}

alias -l AddHaveListToHash_Middle {
  var %Id = $1
  var %watch = $ticks
  var %HANDLE = $hget(PSL_PROC_ $+ %id,HANDLE)
  var %user = $hget(PSL_PROC_ $+ %id,USER)
  var %trigger = $hget(PSL_PROC_ $+ %id,TRIGGER)
  var %dolines = 50
  if ($fopen(%HANDLE)) {
    ;; echo -set debug %HANDLE -> $fopen(%HANDLE).eof -> $fopen(%HANDLE).err
    while ((!$fopen(%HANDLE).eof ) && (%dolines)) {
      dec  %dolines
      var %line = $fread(%HANDLE)

      ; echo 13 -s FOUND LINE: %line

      if ($left(%line,1) == \ ) {
        ; echo 12 -s This is a real file: %line
        var %file = $gettok(%line,1,9)
        var %ret = $MarkHavingSingleFile(%trigger,%user,%file,$gettok(%line,2,9))
        if (!$PSE_GetPartName(%file).ispart) hinc PSL_PROC_ $+ %id count
        else hinc PSL_PROC_ $+ %id extra
      }      
    }
  }
  if ( (!$fopen(%HANDLE)) ||  ( $fopen(%HANDLE).eof )  || ( $fopen(%HANDLE).err ) ) {
    ;; this is the end
    .timer $+ $ctimer off
    AddHaveListToHash_End %id
  }
  else {
    var %took = $ticks - %watch
    set %ps_havelistloaddelay $calc(%took * 6 * $PSC_SF)
  }
  noop $AccessDB(USER,%user,ADDINGHAVELIST,yes,5)
}

alias -l AddHaveListToHash_End {
  var %id = $1
  var %HANDLE = $hget(PSL_PROC_ $+ %id,HANDLE)
  var %user = $hget(PSL_PROC_ $+ %id,USER)
  var %trigger = $hget(PSL_PROC_ $+ %id,TRIGGER)
  var %start = $hget(PSL_PROC_ $+ %id,start)
  var %dur = $uptime(mirc) - %start
  var %havefile = $hget(PSL_PROC_ $+ %id,HAVEFILE)

  var %count = $hget(PSL_PROC_ $+ %id,count)
  var %extra = $hget(PSL_PROC_ $+ %id,extra)

  PSL_Log 4 Loaded 10HAVELIST %Havelistfile from user %user for trigger %Trigger in %dur miliseconds added %count /extra(parts) %extra
  if ($fopen(%HANDLE))  .fclose %HANDLE
  hfree PSL_PROC_ $+ %id
  noop $ProcessReceivedHaveList_End(%trigger,%user,%havefile,$true,%count)
}


; this is a mid-level function that returns a list of leechable triggers ":" separated  or $true and $false if !trig is specified
alias -l IsLeechableFromNick {
  var %trigger = $1 , %file = $2 , %size = $3 , %nick = $4

  if (%nick) {
    var %havelist = $IsHavingSingleFile(%trigger,%nick,%file,%size)
    if (%havelist == $true) return $true
    ; check the hash of Collection if user is in complete section
    return $AccessDBList(COLL,%trigger,COMPLETE,%nick,t)
  }
  else {
    var %havelist = $IsHavingSingleFile(%trigger,*,%file,%size)
    ; add the list of all nicks from the Collection hash too
    var %clist = $AccessDBList(COLL,%trigger,COMPLETE)
    ;_AOFF_ psecho Will return the Havelist : %havelist + %clist
    if ( ($numtok(%havelist,58) > 0) && ($numtok(%clist,9) > 0) ) {
      %havelist = %havelist $+ $chr(58)
    }
    if ($numtok(%clist,9) > 0) {
      %havelist = $+(%havelist,$replace(%clist,$chr(9),$chr(58)))
    }
    return %havelist 
  }
}


;;
;;
;;    subfunctions

/** deletes a username from the havelisthash  (with the use of pserve.exe)
*/
alias -l DeleteHavingListFromHash {
  var %trigger = $1 , %user = $2
  var %HASHNAME = PSL_HAVE_ $+ %trigger $+ _ $+ $network

  var %start = $uptime(mirc)

  hadd %HASHNAME __PURGE_USERTRIG__ %user
  hsave %HASHNAME $PS_TmpDir $+ LeechHash.hsh"
  noop $PS_RunPserveExeSync(PurgeLeechHash)
  hload %HASHNAME $PS_TmpDir $+ LeechHash.hsh"
  var %del = $hget(%HASHNAME, __ENTRIES_PURGED__)
  hdel %HASHNAME __ENTRIES_PURGED__

  var %dur = $uptime(mirc) - %start
  PSL_Log 3 Removed %del entrys for User %user from HaveListHash of trigger %trigger in %dur miliseconds
}


/** deletes a username from the havelisthash  old (in plain mirc)
*/
alias -l DeleteHavingListFromHash_mirc {
  var %trigger = $1 , %user = $2
  var %HASHNAME = PSL_HAVE_ $+ %trigger $+ _ $+ $network
  var %del = 0
  var %start = $uptime(mirc)
  var %count = $hget(%hashname,0).item
  while (%count > 0) {
    var %oldtag = $hget(%HASHNAME,%count).data
    var %file = $hget(%HASHNAME,%count).item
    if ($istok(%oldtag,%user,58)) {
      inc %del
      var %new = $remtok(%oldtag,%user,58)
      if ($numtok(%new,58) > 0) {
        /hadd %HASHNAME %file %new
      }
      else {
        /hdel %HASHNAME %file
      }
    }
    dec %count
  }
  var %dur = $uptime(mirc) - %start
  PSL_Log 3 Removed %del entrys for User %user from HaveListHash of trigger %trigger in %dur miliseconds
}


/** Sets a users trigger into the havelist record
* 
* @optparam not if $true will reset the flag for that file, may occur if script finds out that user not having the file.
*/

alias -l MarkHavingSingleFile {
  var %trigger = $1 ,  %user = $2 , %file = $3 , %size = $4 , %not = $5
  var %file = $base(%size,10,36) $+ $chr(124) $+ $replace(%file,$chr(32),?)
  var %HASHNAME = PSL_HAVE_ $+ %trigger $+ _ $+ $network
  var %oldtag = $hget(%HASHNAME,%file)
  if ((!%not) && ($istok(%oldtag,%user,58))) return $true 
  ;if ((%not) && !$istok(%oldtag,%user,58)) return $true

  ;  echo DEBUG: %HASHNAME <<? , %file , %user  , %trigger
  if (%not) /hadd -m %HASHNAME %file $remtok(%oldtag,%user,1,58)
  else /hadd -m %HASHNAME %file $addtok(%oldtag,%user,58)
  ;  echo -s 12 ADDED to %HASHNAME --> %file --> %oldtag + %user
  ;echo -s 12 Debug: stored $hget(%HASHNAME,%file) for %file in %HASHNAME
  return $true
}


/** Checks if a user is having a single file in a collection. returns the whole list with $chr(58) separated if %user = *
* returns true or false if user has the file  @return Boolean
*/
alias -l IsHavingSingleFile {
  var %trigger = $1 , %user = $2 , %sfile = $3 , %size = $4
  var %HASHNAME = PSL_HAVE_ $+ %trigger $+ _ $+ $network
  if ($prop == gethashname) return %HASHNAME
  var %file = $base(%size,10,36) $+ $chr(124) $+ $replace(%sfile,$chr(32),?)
  var %oldtag = $hget(%HASHNAME,%file)
  ;  echo -set DBG: %trigger - %user - %sfile - %size - %file - %HASHNAME - %oldtag
  if (%oldtag) {
    if (%user == *) return %oldtag
    if ($istok(%oldtag,%user,58)) return $true 
  }

  ;; check if this was a part..
  if ($PSE_GetPartName(%sfile).isPart) {
    var %size = $PSE_GetPartName(%sfile).getSize , %nfile = $PSE_GetPartName(%sfile).getName
    ;    echo -set is a part .. getting info . size %size  file %nfile
    var %file = $base(%size,10,36) $+ $chr(124) $+ $replace(%nfile,$chr(32),?)
    ;    echo -set checking having part %sfile  (size %size ) by user %user  <- %nfile check for %file instead of original
    var %oldtag = $hget(%HASHNAME,%file)
    if (%oldtag) {
      ; now return the info about all parts
      ;      echo -set returning istok %user in %oldtag
      return $istok(%oldtag,%user,58)
    }
    else return $false
  }
  else return $false



  return $null
}


/** can be removed !! finds and returns a stored (previously downloaded) Havelist from a user for a certain Trigger 
*/
alias -l FindHaveListFileForUser {
  var %trigger = $1
  var %usertrigger = $2
  var %havepattern = * $+ $remove($PS_NickRemove(%usertrigger),!) $+ _HAVE_ $+ %trigger $+ .txt
  var %dir = $PS_HaveSavedDir(FindHaveListFileForUser) $+ "
  ;  echo -sat Searching in %dir  for %havepattern 
  var %file = $findfile(%dir,%havepattern,1)
  if (%file) return %file
  var %file = $findfile($getdir(*.txt),%havepattern,1)
  if (%file) return %file
  return $null
}


/* function to resync the threads for a running leech. 
* Should only be called when number of threads has reached 0.
* because Havelist requests are not detected here
*/

alias -l ReSyncUsersFromLeech {
  var %trigger = $1
  var %old = $AccessDB(COLL,%trigger,THREADS)
  var %window = $getWindowName(LEECH,%trigger)
  ;_AOFF_ psecho ReSyncing Marks from Window %window
  var %lines = $line(%window,0)
  var %i = 0
  var %real = 0
  while (%i < %lines) {
    inc %i
    var %line = $line(%window,%i)
    if ($numtok(%line,124) > 4) {
      var %usertrig = $gettok(%line,5,124)
      var %tcmd = $hasTimer(%usertrig)
      var %down = $AccessDB(USER,%usertrig,DOWNLOADING)
      echo Found user %usertrig from line # %i -> %line of %window -> Timer? %cmd -> Downloading? %down
      if ((!%cmd) && (!%down)) {
        ; echo %usertrig does not really do anything.. ?
        var %collection =  $FreeUserFromEverything($AccessDB(GLOB,NICKS,%usertrig))
        rline %window %i $deltok(%line,5,124)
      }
      else {
        inc %real
      }
    }
  }
  var %new = %real
  ;_AOFF_ psecho Real Threads for %trigger was %old is %real and will be %new $+ . 
  var %res = $AccessDB(COLL,%trigger,THREADS,%new)
}



;; @optparam rmax maximum of users too free @return Int number of removed users
alias -l ReleaseAllUsersFromLeech {
  var %trigger = $1 , %rmax = $2
  var %window = $getWindowName(LEECH,%trigger)
  ;_AOFF_ psecho Clearing Marks from Window %window
  var %lines = $line(%window,0)
  var %i = 0
  var %rem = 0
  while (%i < %lines) {
    inc %i
    var %line = $line(%window,%i)
    if ($numtok(%line,124) > 4) {
      inc %rem
      var %usertrig = $gettok(%line,5,124)
      ;_AOFF_ psecho Releasing user %usertrig from line # %i -> %line of %window $+ .
      var %collection =  $FreeUserFromEverything($AccessDB(GLOB,NICKS,%usertrig))
      if ((%rmax) && (%rmax == %rem)) {
        PSL_Log 3  8max number of users freed from %trigger - %rem users released
        break
      }
    }
  }
  var %run = $AccessDB(COLL,%trigger,THREADS)
  noop $AccessDB(COLL,%trigger,THREADS,$calc(%run - %rem))
  return %rem
}

alias -l ClearAllMarksFromAllLeeches {
  var %list = $getWindowName(LEECH)

  var %count = $numtok(%list,9)
  while (%count > 0) {
    var %trigger = $gettok(%list,%count,9)
    dec %count
    var %res = $AccessDB(COLL,%trigger,THREADS,0)
    var %window = $getWindowName(LEECH,%trigger)
    ;_AOFF_ psecho Clearing Marks from Window %window
    ClearAllMarksFromWindow %window
  }

}

alias -l ClearAllMarksFromWindow {
  var %window = $1
  var %lines = $line(%window,0)
  var %i = 1
  var %marks = 0
  while (%i <= %lines) {
    var %line = $line(%window,%i)
    if ($numtok(%line,124) > 4) {
      if (!$prop) rline %window %i $deltok(%line,5-,124)
      inc %marks
    }
    inc %i
  }
  if ($prop) return %marks
}

/** manipulates the marks in the Leech Window.
* @param action S (set) C (clear) and G (Get) or special R (reset CRC) @param mark is usualy the usertrigger
*/
alias -l MarkActionForCollectionfile {
  ;_AOFF_ psecho 3 MarkAction: $1-
  var %trigger = $1 ,  %sfile = $2 , %action = $3 , %mark = $4 , %setvalue = $5
  var %window = $getWindowName(LEECH,%trigger)
  var %lines = $line(%window,0)
  if (%lines == 0) return
  var %i = 1

  if (%mark) {
    if (%mark == all) var %best = 1
    else var %best = $LeechCacheAccess(%trigger,%mark,%lines)
    if (%best > 0) %i = %best
  }
  var %steps = 0
  while (%i <= %lines) {
    inc %steps
    var %line = $line(%window,%i)
    var %file = $gettok(%line,4,124) $+ $gettok(%line,1,124)
    if (%file == %sfile) {
      PSL_Log 6 Marked in %window the line %line in %steps steps. Mark: %mark . ( %i : start: %best )
      if (%action == S) {
        if ($numtok(%line,124) > 4) rline 12 %window %i $puttok(%line,%mark,5,124)
        else rline 12 %window %i $addtok(%line,%mark,124)
      }
      else if (%action == C) {
        rline %window %i $deltok(%line,5-,124)
      }
      else if (%action == G) {
        return $gettok(%line,5,124)
      }
      else if (%action == R) {
        rline 7 %window %i $puttok(%line,%setvalue,3,124)
      }

      return $null
    }
    inc %i
    ; if the cache fails totaly start again
    if (%best) && (%i > %lines) { %best = $null |  %i = 1 }
  }
  if (%action !== R)  PSL_Log 1 ERROR! could not find MarkAction: $1-
}

/** Removes a file from the leech window, as it was proccessed, or whatever. @optparam nick usertrigger that helps speed up as it can use cache
* @return Boolean
*/
alias -l ClearFileFromLeech {
  var %trigger = $1 , %sfile = $2 , %nick = $3
  var %window = $getWindowName(LEECH,%trigger)
  var %lines = $line(%window,0)
  var %steps = 0
  var %i = 1

  if (%nick) {
    var %best = $LeechCacheAccess(%trigger,%nick,%lines)
    if (%best > 0) %i = %best
  }
  :backforgood
  while (%i <= %lines) {
    var %line = $line(%window,%i)
    var %file = $gettok(%line,4,124) $+ $gettok(%line,1,124)
    inc %steps
    if (%file == %sfile) {
      dline %window %i
      PSL_Log 6 Removed File:5 %file from Leech10 %window 4run to line %i in %steps steps (best start: %best )
      ; if (%finderror) PSL_Log 1 FOUND the line in %i . after %steps . %file
      return $true
    }
    inc %i
  }
  ;  PSL_Log 1 ERROR. Could not remove %sfile from %trigger ( %window ) .. user %nick . Started %best .. l: %cachel - m : %cachem real: %lines
  if (%best) {
    %best = 0
    %i = 1
    var %finderror = 1
    goto backforgood
  }
  return $false
}

/** a mini file hunter, this may be slow but it is only intended for single file hunt to a collection.
*
*/

alias PSL_HuntFilesInDir {
  var %trigger = $1 , %dir = $2 

  if ($PSTC_GetCSV(%trigger).valid) {
    var %csvfile = $+(",$ifmatch,")
    var %HANDLE = HUNTCSV
    if ($fopen(%HANDLE)) .fclose %HANDLE
    .fopen %HANDLE %csvfile
    if (!$ferr) {
      ; open the temp window to search files in

      window -c @temp
      window -lh @temp
      var %temp = $findfile(%dir,*,0,if ($right($1-,5) !== .par2) aline @temp $+($1-,$chr(124),$file($1-).size))

      var %slines = $line(@temp,0)
      ; end of temp window

      while (!$feof) {
        var %line = $replace($fread(%HANDLE),$chr(44),;)
        ; echo 13 -s FOUND LINE: %line
        if ($regex(%line,/(.+);(\d+);([a-fA-F\d]+);(\\(.+\\)?)/)) {
          ; if ($regex(%line,/(.+);(\d+)/)) {
          var %endfilename = $regml(1)
          var %path = $regml(4)
          var %ssize = $regml(2)
          var %scrc = $base($regml(3),16,10)
          ;          echo -set found file $regml(1) with size $regml(2) and crc $base($regml(3),16,10) at $regml(4)
          var %i = 0
          while (%i < %slines) {
            inc %i
            var %data = $line(@temp,%i)
            var %file = $gettok(%data,1,124)
            var %size = $gettok(%data,2,124)
            if (%size == %ssize) {
              echo -s will check crc for %file
              if ($gettok(%data,3,124)) {
                var %crc = $ifmatch
              }
              else {
                var %crc = $base($crc(%file),16,10)
                rline @temp %i $addtok(%data,%crc,124)
              }

              if (%crc == %scrc) {
                echo found the right file for %path $+ %endfilename at %file
                if ($PSTC_GetPath(%trigger).valid) {
                  var %dest = $+($ifmatch,%path)
                  var %targetfile = $+(%dest,\,%endfilename)
                  if ($isfile(%targetfile)) {
                    echo -s Target7 %targetfile 4already present
                  }
                  else {
                    echo moving to %dest as %endfilename
                    if ($true == $MoveFileToEndLocation(%file,%dest,%endfilename)) {
                      PSTC_IncFileCount %trigger
                      $PSTC_IncByteCount(%trigger, %size)
                      echo -set Move successful. %trigger updated.
                    }
                  }
                }
              }
              else {
                echo -s File:7 %file did not have the correct crc: %scrc . File had %crc
              }
            }
          }
        }
      }
      .fclose %HANDLE
      window -c @temp
    }
  }
}

alias -l getsplitFileChannelSetting {
  var %chan = $1 

  if ((%PS.forbidleechparts) && ($istok(%PS.forbidleechparts,%chan,44))) return $false
  if ((%PS.forceleechparts) && ($istok(%PS.forceleechparts,%chan,44))) return $true

  ;getchannelsetting  from filterfile
  if ($PSF_GetChanSetting(LeechParts,%chan)) {
    var %set = $ifmatch
    return $iif(%set == ON,$true,$false)
  }
  ;the default (will be $true for 4.9 and above)
  return $true
  ;  return $iif($PS.Version.main > 4.8,$true,$false)
}

;; can reload some leech resources on the fly .. currently only report is supported (NOT RECOMMENDED TO USE THIS)
alias PSL_Reload {
  var %trigger = $1 , %what = $2
  unset %ps_reload
  if (%what == report)  scid -a ReloadLeechReport %trigger
}

alias -l ReloadLeechReport {
  var %trigger = $1 
  var %window = $getWindowName(LEECH,%trigger) 
  if (!$window(%window)) {
    echo -set nothing found in $PS_Network to reload for %trigger -> no %window
    return
  }
  var -s %threads = $ReleaseAllUsersFromLeech(%trigger)

  ; clear the window
  dline %window 1- 

  ; only 1 of the networks should continue from here
  if (%ps_reload) {
    echo 4 -set not here in $PS_network . The work is done in %ps_reload
  }
  else {
    set -su %ps_reload $PS_Network
    var -s %report = $PSTC_GetReport(%trigger).valid ,  %chan = $AccessDB(COLL,%trigger,CHAN) 
    noop $FillWinWithReport(%report,%window,%trigger,%chan)
  }
}

/* loads a given report into a give window by spliting the data to name, size crc and path separated by $chr(124)
* @param addtypes can be vids or pics
*/
alias -l FillWinWithReport {
  var %Reportfile = $+(",$1,") , %window = $2 , %trigger = $3 , %chan = $4 , %addtype = $5
  ;  var %addtype = vids,pic,fullcheck

  var %id = $ticks $+ _F

  var %HANDLE = REPORTHANDLE $+ %id
  ; echo 15 -s opening %Reportfile to %WINDOW

  if ($fopen(%HANDLE)) fclose %HANDLE
  .fopen %HANDLE %Reportfile

  hadd -m PSL_PROC_ $+ %id HANDLE %HANDLE
  hadd -m PSL_PROC_ $+ %id WINDOW %window
  hadd -m PSL_PROC_ $+ %id TRIGGER %trigger
  hadd -m PSL_PROC_ $+ %id SPLIT $getSplitfileChannelSetting(%chan)
  hadd -m PSL_PROC_ $+ %id ADDTYPE %addtype

  if (!$ferr) {

    hadd -m PSL_PROC_ $+ %id START $uptime(mirc)

    hadd -m PSL_PROC_ $+ %id KEY 0 
    hadd -m PSL_PROC_ $+ %id SKIPPED 0 
    hadd -m PSL_PROC_ $+ %id NUMLINES 0 

    var %partsizedef = $CreateFilePartFromFile().partsize 
    hadd -m PSL_PROC_ $+ %id PARTSIZEDEF %partsizedef
    hadd -m PSL_PROC_ $+ %id PARTSIZELIMIT $iif(%psl.splitsizelimit,$ifmatch,%partsizedef)
    hadd -m PSL_PROC_ $+ %id CPATH $PSTC_GetPath(%trigger)


    window -c %WINDOW
    window -hl %WINDOW

    noop $AccessDB(COLL,%trigger,REPORTLOADING,$true)

    .timer -m 0 $calc($PSC_SF * 800) FillWinWithReport_Middle %id
  }
  else fclose %HANDLE
}

alias -l FillWinWithReport_Middle {
  var %id = $1 
  var %todo = 150
  var %window = $hget(PSL_PROC_ $+ %id,WINDOW)
  var %HANDLE = $hget(PSL_PROC_ $+ %id,HANDLE)


  var %partsizelimit = $hget(PSL_PROC_ $+ %id,PARTSIZELIMIT)
  var %partsizedef = $hget(PSL_PROC_ $+ %id,PARTSIZEDEF)
  var %cpath = $hget(PSL_PROC_ $+ %id,CPATH)

  var %splitfiles = $hget(PSL_PROC_ $+ %id,SPLIT) 
  var %addtype = $hget(PSL_PROC_ $+ %id,ADDTYPE) 
  var %trigger = $hget(PSL_PROC_ $+ %id,TRIGGER) 

  if ($fopen(%HANDLE)) {

    while ((!$fopen(%HANDLE).eof) && (%todo > 0)) {
      var %line = $fread(%HANDLE)
      ;inc %numLines
      hinc PSL_PROC_ $+ %id NUMLINES 
      ; echo 13 -s FOUND LINE: %line
      if ($regex(%line,/Missing\s+(.+\S)\s+(\d+)\s+([a-fA-F\d]+)\s+(\\(.+\\)?)/)) {
        dec %todo
        ; echo 14 -s Found $regml(1) $chr(124) $regml(2) $chr(124) $regml(3) $chr(124) $regml(4)
        var %fname = $regml(1) , %size = $regml(2) , %path = $regml(4) , %crc = $base($regml(3),16,10)

        if (%addtype) {
          var %type = $right(%fname,4)
          if ((%addtype == vids) && (%type == .jpg)) continue
          if ((%addtype == pics) && (%type !== .jpg)) continue
        }

        if ((%size > %partsizelimit) || (%addtype == fullcheck)) {
          var %check = $left(%cpath,-1) $+ %path $+ %fname
          ;   echo -set checking %check
          if ($file(%check)) {
            echo -set %check file already present with $ifmatch bytes. skipping in leech of %trigger
            ;        inc %skipped
            hinc PSL_PROC_ $+ %id SKIPPED
            continue
          }
        }

        if (%splitfiles && (%size > %partsizelimit)) {
          ; if (%splitfiles) {
          var %parts = $calcparts(%size , %partsizedef)
          var %partsize = $iif($calc(%size % %partsizedef),$ifmatch,%partsizedef)

          var %orig = $PSL_TempPathForTrigger(%trigger) $+ %path $+ %fname
          ;  echo -set splitting file7 %fname size5 %size -> %parts parts 
          ;  echo -set checking %orig ( $file(%orig) )
          noop $AccessDB(COLL,%trigger,BIGCRC_ $+ $makehashkey(%path $+ %fname),%crc)
          var %cfile = $getPartControlFile(%orig)
          if (!$exists(%cfile)) unset %cfile
          var %startpos = $calc($hget(PSL_PROC_ $+ %id,KEY) + 1)
          while (%parts > 0) {
            var %pname = $PSE_GetPartName(%fname,%size,%parts)
            if ((%cfile) && ($partcontrol(%cfile,%parts,T))) goto SKIPPART
            ;  inc %key
            dec %todo 
            hinc PSL_PROC_ $+ %id KEY

            ; echo -set insert line %pname .. %partsize
            iline %WINDOW $iif(%psl.leechsort == report,%startpos,$rand(1,$hget(PSL_PROC_ $+ %id,KEY))) %pname $+ $chr(124) $+ %partsize $+ $chr(124) $+ 0 $+ $chr(124) $+ %path
            :SKIPPART
            %partsize = %partsizedef
            dec %parts
          }
          unset %cfile
        } 
        else {
          ;        inc %key
          hinc PSL_PROC_ $+ %id KEY

          iline %WINDOW $iif(%psl.leechsort == report,$hget(PSL_PROC_ $+ %id,KEY),$rand(1,$hget(PSL_PROC_ $+ %id,KEY))) %fname $+ $chr(124) $+ %size $+ $chr(124) $+ %crc $+ $chr(124) $+ %path
          ; aline %WINDOW $regml(1) $+ $chr(124) $+ $regml(2) $+ $chr(124) $+ %crc $+ $chr(124) $+ %path
        }
      }
    }
  }
  :error
  if ( ($error) || (!$fopen(%HANDLE)) || ($fopen(%HANDLE).eof)) {
    .timer $+ $ctimer off
    FillWinWithReport_END %id
  }
}

alias -l FillWinWithReport_END {
  var %id = $1
  var %window = $hget(PSL_PROC_ $+ %id,WINDOW)
  var %HANDLE = $hget(PSL_PROC_ $+ %id,HANDLE)

  var %skipped = $hget(PSL_PROC_ $+ %id,SKIPPED)

  var %trigger = $hget(PSL_PROC_ $+ %id,TRIGGER) 

  var %dur = $uptime(mirc) - $hget(PSL_PROC_ $+ %id,START)

  if ($fopen(%HANDLE)) {
    var %Reportfile = $fopen(%HANDLE).fname
    .fclose %HANDLE
  }
  hfree PSL_PROC_ $+ %id
  noop $AccessDB(COLL,%trigger,REPORTLOADING,.)
  PSL_Log 2 Loaded %Reportfile ( $+ $line(%WINDOW,0) lines/files) to %WINDOW in %dur miliseconds $iif(%skipped,%skipped files were not loaded from report due already in collection,$null)


  if (%psl.defaultorder) ReorderWindowFiles %trigger $ifmatch
  ;; remove until there is a gui ::  noop $PriorizeIncompleteFiles(%trigger)

  scid -a noop $!AccessDB(COLL , %trigger ,RUNDRY,.)

}

alias -l calcparts {
  var %size = $1 , %partsize = $iif($2,$ifmatch,$CreateFilePartFromFile().partsize)
  var %dif = $calc(%size / %partsize)
  var %parts = $ceil(%dif)
  var %check = $calc(%parts * %partsize)
  ;  echo -> splitting %size ( %check ) to parts %partsize => %dif => $calc(%size - %check) final part size = $calc(%size % %partsize)
  if (%check < %size)  inc %parts
  return %parts
}

alias -l makehashkey {
  return $replace($1-,$chr(32),?)
}

/* Filters the leech window for the trigger with addtype. 
* already requested files are untouched.
* @param addtype either vids or pics @return void
*/

alias PSL_LeechFilter {
  var %trigger = $1 , %addtype = $2
  var %window = $getwindowname(LEECH,%trigger)
  if (%addtype) {
    var %key = $line(%WINDOW,0)
    while (%key > 0) {
      var %line = $line(%WINDOW,%key)
      if ($numtok(%line,124) <= 4) {
        var %file = $gettok(%line,1,124)
        if ($regex(%file,/\.(.+)$/)) {
          var %type = $regml(1)
          if (%addtype == vids) if ((%type == jpg) || (%type == gif) || (%type == jpeg)) dline %WINDOW %key
          else if (%addtype == pics) if ((%type !== jpg) && (%type !== gif) && (%type !== jpeg)) dline %WINDOW %key
        }
      }
      dec %key
    }
  }
}

;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;
;;;;;;;;;;;;;

alias -l RequestACsvFile {
  var %trigger = $1
  var %lookcsv = $AccessDB(COLL,%trigger,BESTCSV)
  PSL_Log 3 Requesting A csv for Collection %trigger (looking for: %lookcsv )

  ;; On server connect we have to delay EVERYTHING .. 
  var %up = $uptime(server,3)
  if (%up < 300) {
    .timer 1 500 RequestACsvFile $1-
    ;_AOFF_ psecho .. Serverconnect to near, delaying Request for CSV by 500 sec . $1-
    return
  }

  ;; check the available users

  var %chan = $AccessDB(COLL,%trigger,CHAN)

  var %window = $getWindowName(WHEREIS,%trigger)
  var %lines = $line(%window,0)
  var %i = 0
  var %best = 0
  var %bestuser = $null
  while (%i < %lines) {
    inc %i 
    var %thiscsv = $gettok($line(%window,%i),6,9)
    if (%thiscsv !== %lookcsv) continue
    var %usertrig = $gettok($line(%window,%i),2,9)

    ; skip bad ones
    if ($AccessDBList(COLL,%trigger,NOCSV,%usertrig,T)) continue
    if ($AccessDB(GLOB,NICKS,%usertrig) !ison %chan) continue
    var %needvoice = $iif($PS_Channel(%chan,voice) == OFF,$false,$true)
    if ((%needvoice) && ($AccessDB(GLOB,NICKS,%usertrig) isreg %chan)) continue

    var %avg = $speedtobytes($gettok($line(%window,%i),8,9))

    ;_AOFF_ psecho line %i > %thiscsv > %usertrig > S: %avg
    if (%best <= %avg) {
      %best = %avg
      %bestuser = %usertrig
    }

  }
  ;_AOFF_ psecho Going to %bestuser for %lookcsv !
  if (!%bestuser) {
    ;_AOFF_ psecho failed to find a user with the csv
    PSL_Log 3 No user found that is available to get a csv for %trigger . 
    PSL_LeechStop %trigger FailedCSV
    var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FailedCSV,Noone was able to provide the csv %lookcsv)
    return
  }
  ;; 
  var %nick = $AccessDB(GLOB,NICKS,%bestuser)
  PSL_Log 3 Requesting the csv for %trigger from user %bestuser aka as %nick -> Expecting csv %lookcsv

  SendToTarget ctcp %nick $GetRequestMethodString(%bestuser,%trigger) %trigger CSV
  ;SendToTarget ctcp %nick !PSGET %trigger CSV

  ;;  var $res = $AccessDB(USER,%bestuser,WAITCSV,%trigger)
  var %res = $SetCSVExpected(%bestuser,%lookcsv,%trigger)
  PSL_Timer %bestuser $+ _AWAITCSV_ $+ %trigger 120 OnTimeoutFromCSVRequest %bestuser %trigger

}

alias -l OnTimeoutFromCSVRequest {
  var %usertrig = $1 , %trigger = $2
  ;_AOFF_ psecho OnTimeOutFromCSVRequest called for user: %usertrig and collection %trigger
  if (!%trigger) PSL_Log 1 ERROR NO Trigger in ONTIMEOUTFROMCSVREQUEST for %usertrig
  var %data = $IsCSVExpected(%usertrig,$AccessDB(COLL,%trigger,BESTCSV),.)
  ;_AOFF_ psecho .. cleaned data %data
  var %failcount = $AccessDB(COLL,%trigger,FAILCSV_ $+ %usertrig,++)
  if (%failcount > 5) var %res = $AccessDBList(COLL,%trigger,NOCSV,%usertrig)

  .timer 1 11.1 RequestACsvFile %trigger
}

alias -l SetCSVExpected {
  var %usertrig = $1 , %lookcsv = $2 , %trigger = $3
  var %filename = $ReplaceCharsInFileName(%lookcsv)
  var %DBNAME = .EXPECTCSV
  var %DATA = $+($cid,$chr(9),%trigger,$chr(9),%lookcsv)
  var %KEY = $+(%usertrig,$chr(9),* $+ %filename $+ *)
  var %res = $AccessDB(GLOB,%DBNAME,%KEY,%DATA)
}

alias -l IsCSVExpected {
  var %usertrig = $1 , %filename = $2 , %delmode = $3
  var %DBNAME = .EXPECTCSV
  ;  psecho Filename1 = %filename
  var %filename = $replace(%filename,$chr(44),_)
  ; psecho Filename1b = %filename
  var %filename = $ReplaceCharsInFileName(%filename)
  ; psecho Filename2 = %filename
  var %KEY = $+(%usertrig,$chr(9),%filename)
  if (%filename == *) return $gettok($AccessDB(GLOB,%DBNAME,%KEY,*),2,9)
  var %REALKEY = $AccessDB(GLOB,%DBNAME,%KEY,**)
  return $AccessDB(GLOB,%DBNAME,%REALKEY,%delmode)

}

alias -l ProcessReceivedCSVFile {
  var %trigger = $1 , %nick = $2 , %usertrig = $3
  var %csv = $AccessDB(COLL,%trigger,PROCESSCSV)
  ;  var %csvdir = $getdir(*.csv)
  var %csvdir = $getdir $+ IncomingCSV\
  var %csvw = * $+ $replace(%csv,$chr(32),?,_,?,$chr(44),?)

  var %foundfile = $findfile(%csvdir,%csvw,1)
  ;_AOFF_ psecho --> Looking in %csvdir for %csvw 11--> And FOUND:12 %foundfile
  PSL_Log 3 Processing Received CSV file for %trigger -> looking for %csvw in %csvdir --> found: %foundfile
  if (%foundfile) {
    var %endloc = $getdir $+ NewCSV\
    if (%ps.downp) %endloc = %ps.downp $+ NewCSV\
    var %res = $PS_MakePath(%endloc)
    %endloc = %endloc $+ $nopath(%csv)
    .copy -o " $+ %foundfile $+ " " $+ %endloc $+ "
    .remove " $+ %foundfile $+ "
    var %res = $ChangeControlFileStatus(%trigger,$nopath(%endloc),CSV)
    var %res = $ChangeControlFileStatus(%trigger,%endloc,FULLCSV)
    noop $ChangeControlFileStatus(%trigger,%nick,nick)
    noop $ChangeControlFileStatus(%trigger,%usertrig,user)

    var %res = $CheckControlFileStatus(UPDATE,.,%trigger,GotCSV)

    ;; clean up
    var %foundfile = $findfile($getdir(*.csv),%csvw,1)
    if (%foundfile)  .remove " $+ %foundfile $+ "


  }
  else {
    var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILEDCSV,No File was found after it should have been received)
  }
  PSL_LeechStop %trigger CSVProcessEnd

}

;; checks if a trigger is allowed to be updated in a channel @return Boolean true if it allowed
alias -l CheckCSVUpdateAllowed {
  var %trigger = $1 , %chan = $2
  var %blacklist = $PSF_GetChanSetting(DisableCsvUpdates, %chan)
  var %tokens = $numtok(%blacklist,44)
  var %i = 0
  while (%i < %tokens) {
    inc %i
    var %item = $gettok(%blacklist,%i,44)
    if (%item iswm %trigger) {
      return $false
    }
  }
  return $true
}

/** The Main Control 
* @prop status returns the Status String
*/ 

alias -l PSL_LeechController {

  var %cfile = $PSL_FetchConstant(ControlFile)
  var %sec = $ini(%cfile,0)

  CheckControlFileStatus

  ;; do the broadcasting of recently leeched stuff (in all channels of all networks)  
  SendBroadcastBuffer LEECHINFO


  var %downlist = $PriSortList($accessCollectionState(*,Downloading))
  var %ccount = $numtok(%downlist,9)
  var %i = 0
  while (%i < %ccount) {
    inc %i
    var %trigger = $gettok(%downlist,%i,9)
    if (!$window($getWindowName(LEECH,%trigger))) {
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,Leech Window disappeared)
      ;reset from Downloading to off
      var %res = $AccessCollectionState(%trigger,off,Downloading)
      PSL_LeechStop %trigger FAILED
    }
    if ($AccessDB(COLL,%trigger,SCSVCRC)) {
      var %thiscrc = $ifmatch
      var %curcrc = $PSTC_GetCSVCRC(%trigger)
      ;_AOFF_ psecho 9,1 Start csv crc %thiscrc comp %curcrc of %trigger
      if (%thiscrc !== %curcrc) PSL_LeechStop %trigger ReQueue
    }
  }
  if (!$PreCheck_LeechAllowed) {
    var %reason = $PreCheck_LeechAllowed($null).reason
    ;_AOFF_ psecho No Leech(es) allowed at the moment >11 %reason
    ; Remove everything that is not running (0 threads)
    var %downlist = $accessCollectionState(*,Downloading)
    var %ccount = $numtok(%downlist,9)
    var %i = 0
    while (%i < %ccount) {
      inc %i
      var %trigger = $gettok(%downlist,%i,9)
      if ($AccessDB(COLL,%trigger,THREADS) < 1) {
        var %res = $CheckControlFileStatus(UPDATE,.,%trigger,DONE,All leeches stopped: %reason)
        PSL_LeechStop %trigger DONE
      }
    }
    return
  }

  var %cfile = $PSL_FetchConstant(ControlFile)
  var %secs = $ini(%cfile,0)

  ;;
  var %list = $PriSortList($getWindowName(LEECH))
  var %ccount = $numtok(%list,9)

  if ((%ccount == 0) && (%secs <= 1)) return

  ;; check the speed in 30 seconds
  .timer 1 30 CheckGetSpeeds

  var %i = 0
  var %maxthreads = $PSL_FetchConstant(LeechLimit) 
  ;; find out how many old leech windows are there
  var %match = @PSLEECH_ $+ $network $+ _*
  var %c = $window(%match,0)
  ;; reduce the max number of threads by the number of open windows
  if (%c > 0) %maxthreads = %maxthreads - %c
  var %maxleeches = %maxthreads 
  ;  var %current_value = [ [ $+(%,ps.leech.maxleech.,$network) ] ]
  var %current_value = $PS_GlobalOption(get,leech.maxleech).network
  if (%current_value && (%current_value <= %maxthreads)) %maxleeches = %current_value
  var %running = 0
  var %trigger = $ReturnBestPriorityCollection(Downloading).reverse
  if (%trigger != $null) var %worstpri = $AccessDB(COLL,%trigger,PRIORITY)
  var %trigger = $ReturnBestPriorityCollection(Waiting)
  if (%trigger != $null) var %bestpri = $AccessDB(COLL,%trigger,PRIORITY)
  var %trigger = $ReturnBestPriorityCollection(Looking)
  if (%trigger != $null) var %bestpriL = $AccessDB(COLL,%trigger,PRIORITY)
  var %scount = 0
  var %leeches = 0
  while (%i < %ccount) {
    inc %i
    var %trigger = $gettok(%list,%i,9)
    %running = %running + $AccessDB(COLL,%trigger,THREADS)
    inc %leeches
    if ($AccessCollectionState(%trigger) == Stop) inc %scount
    ;  var %pri = $AccessDB(COLL,%trigger,PRIORITY)
    ;  if (%worstpri <= %pri) %worstpri = %pri
  }

  var %looking = $AccessCollectionState(*,Looking)
  var %lookcount = $numtok(%looking,9)

  var %freespace = $calc(%maxleeches - %lookcount - %leeches)
  var %freethreads = $calc(%maxthreads - %lookcount - %running)
  var %status = Running leeches: %ccount ( %leeches ) of %maxleeches (Threads: %running of %maxthreads ) Looking: %lookcount ( %looking ) Free: %freespace / %freethreads (Worst Priority: %worstpri Best / L : %bestpri / %bestpriL )
  if ($prop == Status) return %status
  ;_AOFF_ psecho LeechControL:3,1 %status


  ;;;;;;; CHECK Looking stuff first --> NOREPLIES _OR_ DOWNLOADING
  var %i = 0
  while (%i < %lookcount) {
    inc %i
    ;_AOFF_ psecho >> %i .. %lookcount
    var %trigger = $gettok(%looking,%i,9)
    var %updatestamp = $AccessDB(COLL,%trigger,UPDATE)
    ; psecho Updated %trigger (looking) at time  %updatestamp .. now: $ctime
    if ($calc(%updatestamp + $getWTO) > $ctime) continue 
    ;_AOFF_ psecho Time to check the results on %trigger
    var %good = $false
    var %reply = 0
    if ($window($getWindowName(WHEREIS,%trigger))) { 
      var %max = $findBestLeechTarget(%trigger,count)
      if (%max > 0) %good = $true
      %reply = $line($getWindowName(WHEREIS,%trigger),0)

    }
    ;; if there is enough space left for this "already dead" leech
    else { 
      var %waiting = $numtok($AccessCollectionState(*,Waiting),9)
      if (%waiting <= %freespace) %good = $true
    }

    ;; good means to start a leech window 
    if (!%good) {
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,NOREPLIES,Replies: $+ %reply $PSL_GetLeechUserInfo(%trigger))
      var %res = $AccessDB(COLL,%trigger).Free
      if (%reply > 0) window -c $getWindowName(WHEREIS,%trigger)
      var %res = $PSL_TreeOp(del,Leech %trigger)
      inc %freespace
      inc %freethreads
    }
    else {
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,DOWNLOADING).noend
      var %res = $AccessCollectionState(%trigger,Downloading)
      ;      var %res = $AccessDB(COLL,%trigger,STARTCOUNT,$FetchSettingFromTrig(%trigger,count))
      var %res = $AccessDB(COLL,%trigger,STARTCOUNT,$PSTC_GetCOUNT(%trigger))
      .timer 1 10 scid -at1 .signal AUTOLEECHSTART %trigger $PS_Network $AccessDB(COLL,%trigger,CHAN) $AccessDB(COLL,%trigger,PRIORITY)
      StartALeechWindow %trigger $AccessDB(COLL,%trigger,CHAN)
      var %res =  $AccessDB(COLL,%trigger,THREADS,0)
      inc %ccount
      StartOfLeechThread %trigger
    }
  }

  if ($calc(%ccount - %scount) > %maxleeches) {
    var %stoptrigger = $ReturnBestPriorityCollection(Downloading).reverse
    ; there might be no auto leech (only manual leeches) 
    if (%stoptrigger) {
      PSL_Log 3 Stopping Leech of Trigger %stoptrigger now. Running %ccount leeches (max leeches set = %maxleeches $+ )
      PSL_LeechStop %stoptrigger ReQueue $true
    }
  }

  ;;; CHECK if CSVs need to be fetched
  var %cglist = $AccessCollectionState(*,GettingCSV)
  var %cgcount = $numtok(%cglist,9)
  var %i = 0
  while (%i < %cgcount) {
    inc %i
    var %trigger = $gettok(%cglist,%i,9)
    var %updatestamp = $AccessDB(COLL,%trigger,UPDATE)
    ; psecho Updated %trigger (gettingcsv) at time  %updatestamp .. now: $ctime
    if ($calc(%updatestamp + $getWTO) > $ctime) continue 
    ;just a security      var %res = $AccessCollectionState(%trigger,GettingCSV)
    var %bestcsv = $FindBestCSVinWindow(%trigger)
    if (!%bestcsv) {
      ;terminate
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,NoCSVReplies)
      continue
    }
    ;    var %mycsv = $nopath($FetchSettingFromTrig(%trigger,csv))
    var %mycsv = $nopath($PSTC_GetCSV(%trigger))
    ;_AOFF_ psecho Found best %bestcsv . and my own csv = %mycsv
    if ((%mycsv == $null) || $PSL_CsvIsBetter(%mycsv,%bestcsv)) {
      ;; go for the best csv
      var %res = $AccessDB(COLL,%trigger,BESTCSV,%bestcsv)
      var %res = $AccessCollectionState(%trigger,DownloadingCSV)
      .timer 1 $rand(3,10) RequestACsvFile %trigger
    }
    else {
      ;terminate
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,NoCSV,Best csv found was: %bestcsv)
      PSL_LeechStop %trigger NoCSV
      continue
    }
  }


  while ( $true ) {
    var %trigger = $ReturnBestPriorityCollection(Getcsv)
    if (!%trigger) break

    var %chan = $AccessDB(COLL,%trigger,CHAN)
    if (!%chan) { 
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,No Channel found in control file)
    }
    elseif (!$CheckCSVUpdateAllowed(%trigger,%chan)) {
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,Updating of CSV for Trigger %trigger not allowed in channel %chan)
    }

    ; else if (!$PreCheck_LeechStart(%trigger,%chan)) {
    ;   var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,$PreCheck_LeechStart(%trigger,%chan).reason)
    ; }
    else  {
      ;if ($PreCheck_RequestAFile(%trigger)) {
      PSL_Log 4 Checking for a new csv for %trigger in %chan
      var %lastreq = $UpdateCollectionSources(%trigger,%chan)
      var %res = $AccessCollectionState(%trigger,GettingCSV)
    }

  }
  ;;;;;;; CHECK Waiting stuff if needed --> Looking

  if ((%worstpri >  %bestpri) && (%freespace == 0)) {
    var %trigger = $ReturnBestPriorityCollection(Waiting)
    var %chan = $AccessDB(COLL,%trigger,CHAN)
    ;_AOFF_ psecho Going to Start a new FORCE Look  because %worstpri > %bestpri >> %trigger in %chan
    var %res = $AccessCollectionState(%trigger,Looking)  
    var %lastreq = $UpdateCollectionSources(%trigger,%chan)
  }

  while (%freespace > 0) {
    var %trigger = $ReturnBestPriorityCollection(Waiting)
    if (!%trigger) /break
    ; psecho --> TO be started next %trigger
    var %chan = $AccessDB(COLL,%trigger,CHAN)
    if (!%chan) { 
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,No Channel found in control file)
    }
    else if (!$PreCheck_LeechStart(%trigger,%chan)) {
      var %res = $CheckControlFileStatus(UPDATE,.,%trigger,FAILED,$PreCheck_LeechStart(%trigger,%chan).reason)
    }
    else {
      dec %freespace
      dec %freethreads
      var %res = $AccessCollectionState(%trigger,Looking)  
      var %lastreq = $UpdateCollectionSources(%trigger,%chan)
    }
  }

  ;; ...
  ;;;;;;;;; CHECK and distribute free spaces among the already running downloads
  ;;; check also for dead leeches. 

  var %list = $PriSortList($getWindowName(LEECH))
  var %ccount = $numtok(%list,9)
  var %i = 0
  var %prisum = 0

  var %freethreads = %maxthreads


  noop $AccessDB(TMP,TLEECH,freespace,%freespace)
  noop $AccessDB(TMP,TLEECH,maxleech,%maxleeches)

  noop $AccessDB(TMP,TLEECH,free,%freethreads)
  noop $AccessDB(TMP,TLEECH,max,%maxthreads)

  var %in = 0 , %del = 750
  ;;; prepare the main cycle
  while (%i < %ccount) {
    inc %i
    var %trigger = $gettok(%list,%i,9)
    ;;; GOTO BLOCK B HERE
    inc %in
    .timer -m 1 $calc(%in * %del) PSL_LeechController_M1 %trigger 
  }


  ;  noop $AccessDB(TMP,TLEECH,check,%checklist)
  inc %in
  ;;; GOTO BLOCK A HERE
  .timer -m 1 $calc(%in * %del) PSL_LeechController_M2
}

alias PSL_GetActive {
  var %trigger = $1 
  return 3Users $findBestLeechTarget(%trigger,countactive) /5 Timer $checkLeechTimers(%trigger) /06 Marks $ClearAllMarksFromWindow($getWindowName(LEECH,%trigger)).justcount
}


alias -l PriSortList {
  var %list = $1
  ;; my bubble sort alorithm
  var %c = $numtok(%list,9)
  var %i = 1
  var %newlist = $gettok(%list,1,9) 
  while (%i < %c) {
    inc %i
    var %el = $gettok(%list,%i,9)
    var %pri = $iif($AccessDB(COLL,%el,PRIORITY),$ifmatch,0)

    var %ntok = $numtok(%newlist,9)
    while (%ntok) {
      var %eln = $gettok(%newlist,%ntok,9)
      var %prin = $iif($AccessDB(COLL,%eln,PRIORITY),$ifmatch,0)
      ; echo -set compare %pri ( %el  )  > %prin  ( %eln @ %ntok ) 
      if  (%pri > %prin)         break
      dec %ntok
    }
    inc %ntok
    var %newlist = $instok(%newlist,%el,%ntok,9)

  }
  return %newlist
}

alias -l PSL_LeechController_M1 {

  ;;%%% BLOCK B START  <<- 

  var %trigger = $1 
  var %freespace = $AccessDB(TMP,TLEECH,freespace) , %maxleeches = $AccessDB(TMP,TLEECH,maxleech)
  var %freethreads = $AccessDB(TMP,TLEECH,free) , %maxthreads = $AccessDB(TMP,TLEECH,max)


  var %status = $PSTC_GetStatus(%trigger)
  var %bts = $PSTC_GetBTState(%trigger)  
  if (%bts == btl) %status = OfF
  if ($PSTC_GetCSVCount(%trigger) <= $PSTC_GetCount(%trigger)) %status = oFF
  if (%status == off) {
    PSL_log 3 Halting leech of %trigger because it is OFF or locked now
    PSL_LeechStop %trigger STOP
    return
  }

  ;    if (!$AccessDB(COLL,%trigger,ReOrder)) {
  ;      noop $AccessDB(COLL,%trigger,ReOrder,$true,600)
  ;    }

  var %loading = $AccessDB(COLL,%trigger,REPORTLOADING)
  if (%loading) return

  ; calculate the technical maximum of the leech
  var %maxpossible = $findBestLeechTarget(%trigger,count)
  var %files = $FileBalancer(%trigger).globalfiles
  if ((!%files) && (!$IsLeechBusy(%trigger))) {
    ;; this will end a leech that has no files left 
    RequestAfile %trigger
    return
  }
  if (%files < %maxpossible) %maxpossible = %files
  if (%maxpossible > %maxleeches) %maxpossible = %maxthreads
  var %actual = $AccessDB(COLL,%trigger,THREADS)
  if (%actual) {
    if (!$AccessDB(COLL,%trigger,CONSTRUCT)) {
      var %checking = $CheckCheckingTrigger(%trigger)
      if (%checking == 0) {
        var %realactive = $findBestLeechTarget(%trigger,countactive)
        if (%realactive == 0) {
          var %timers = $checkLeechTimers(%trigger)
          if (%timers == 0) {
            var %marks = $ClearAllMarksFromWindow($getWindowName(LEECH,%trigger)).justcount
            if (%marks == 0) {
              PSL_Log 1 found that instead of %actual threads there are %realactive threads with %marks marks in the Leech Window.. indicating an error? for %trigger (which is now corrected) (Timers: %timers )
              ;  echo -set checking all timers for %trigger that has no running leeches (we think)
              ;  timers
              ;  PSL_InspectHash
              noop $AccessDB(COLL,%trigger,THREADS,0)
              var %actual = 0
            }
          }
        }
      }
    }
  }
  else var %actual = 0
  var %state = $AccessCollectionState(%trigger)
  if (%state == stop) %maxpossible = 0
  if (%actual <= 0) {
    ;; Check Stopping 
    ;_AOFF_ psecho 8 CUrrent State of dead %trigger is %state
    if (Stop == %state) {
      PSL_LeechStop %trigger STOP Stopped
      return
    }
    ;check if manual or automatic leech
    if ($FileBalancer(%trigger).numberofwindows <= 1) {
      if (%state) {
        var %waiting = $AccessCollectionState(*,Waiting)
        var %newpri = $AccessDB(COLL,%trigger,PRIORITY,++)
        ;_AOFF_ psecho 11 Waiting for leech are %waiting collections --> New Priority for %trigger is %newpri
        if (%waiting && (%freespace <= 0)) {
          var %dead = $AccessDB(COLL,%trigger,DEAD,++)
          PSL_LOG 4 Dead Count for %trigger is %dead now .. Actual running was %actual .. checked state %state . Waiting are $numtok(%waiting,9) F: %freespace 
          ;; if deadlimit reached
          if (%dead > 8) {
            var %infostring = $PSL_GetLeechUserInfo(%trigger) 
            var %res = $AccessDB(COLL,%trigger,DEAD,0)
            PSL_LeechStop %trigger INCOMPLETE DEAD
            ;              inc %freespace
            noop $AccessDB(TMP,TLEECH,freespace,++)
            ;              var %progress = $FetchSettingFromTrig(%trigger,count) - $AccessDB(COLL,%trigger,STARTCOUNT)
            var %progress = $PSTC_GetCOUNT(%trigger) - $AccessDB(COLL,%trigger,STARTCOUNT)
            var %res = $CheckControlFileStatus(UPDATE,.,%trigger,$iif(%progress > 0,DONE,NONEAVAILABLE),LeechInfo: Targets: $+ %maxpossible Leeched: $+ %progress %infostring)
            return
          }
        }
      }
    }
  }
  else var %res = $AccessDB(COLL,%trigger,DEAD,0)
  ; exclude recently updated
  var %lastreq = $CheckForUpdateNeeded(%trigger)
  if ((%lastreq >= $getWTO) && (!%loading) ) {
    ;      %checklist = $addtok(%checklist,%trigger,9)
    noop $AccessDBList(TMP,TLEECH,check,%trigger)
    if (!$PreCheck_RequestAFile(%trigger))  %maxpossible = 0
    var %res = $AccessDB(TMP,TLEECH,D_ $+ %trigger,0)
    var %res = $AccessDB(TMP,TLEECH,M_ $+ %trigger,%maxpossible)
  }
  else {
    ; %freethreads = %freethreads - %actual
    noop $AccessDB(TMP,TLEECH,free,$calc(%freethreads - %actual))
  }

  ;;%%% BLOCK B END

}

alias -l PSL_LeechController_M2 {

  var %checklist = $AccessDB(TMP,TLEECH,check) , %freethreads = $AccessDB(TMP,TLEECH,free) , %maxthreads = $AccessDB(TMP,TLEECH,max)

  ;%%% BLOCK A START <- var %checklist , %freethreads , %maxthreads
  ;; now all triggers that need threads are in the %checklist
  var %start = $true
  while (($numtok(%checklist,9) > 0) && (%freethreads > 0)) {
    var %ccount = $numtok(%checklist,9)
    var %i = 0
    var %currentsum = %nextsum
    var %nextsum = 0
    var %bestval = 0 
    var %besttrigger = $null
    ; psecho Checking list %checklist : Round : %freethreads -> Sum: %currentsum 
    while (%i < %ccount) {
      inc %i
      var %trigger = $gettok(%checklist,%i,9)
      var %pri = $AccessDB(COLL,%trigger,PRIORITY)
      if (!%pri) var %pri = 1

      if (!%start) {

        ;; make sure to either decrease %freethreads OR remove an element from %checklist or endless loop !

        var %desiredleeches = $CalcOptimalLeechCount(%pri, $calc(1 / %currentsum), %maxthreads , %trigger)
        var %maxpossible = $AccessDB(TMP,TLEECH,M_ $+ %trigger)
        var %actual = $AccessDB(TMP,TLEECH,D_ $+ %trigger)
        ; echo 13 -st VirtualRun: %actual of %maxpossible now desired %desiredleeches  7 Trig: %trigger 5-pri: %pri 3Still Free: %freethreads
        if (%actual >= %maxpossible) {
          ;set max as the end value and delete the trigger from the list
          var %res = $AccessDB(TMP,TLEECH,D_ $+ %trigger,%maxpossible)
          %checklist = $deltok(%checklist,%i,9)
          dec %i
          dec %ccount
          ; echo 4 Throwing %trigger out .. now: %checklist
          continue
        }
        else {
          if (%actual == $null) %actual = 0
          var %diff = %desiredleeches - %actual
          if (%diff >= %bestval) {
            %bestval = %diff
            %besttrigger = %trigger
            ; echo Set best trigger to %besttrigger with %bestval
          }
        }

      }
      else  var %res = $PSL_TreeOp(add,Leech %trigger Priority,%pri)

      ;; if not thrown out .. 
      %nextsum = %nextsum + $calc(1 / %pri)

      ;innerloop end
    }
    if (%start) {
      %start = $false
      continue
    }

    var %res = $AccessDB(TMP,TLEECH,D_ $+ %besttrigger,++)
    ; echo -set Best trigger13 %besttrigger gets the count to %res
    dec %freethreads
    ; echo 12 Increasing %besttrigger by 1 to %res


    ;end of while
  }
  ;; 

  ;%%% BLOCK A END 


  ;; the final correction:
  ;; by sorting this we make sure the top priority collections are handled first
  var %list = $PriSortList($getWindowName(LEECH))
  var %ccount = $numtok(%list,9)
  var %i = 0
  var %logstring = $null
  var %setrun = 0 , %wasrun = 0
  while (%i < %ccount) {
    inc %i 
    var %trigger = $gettok(%list,%i,9)
    var %should = $AccessDB(TMP,TLEECH,D_ $+ %trigger) 
    if (%should !== $null) {
      %setrun = $calc(%setrun + %should)
      var %actual = $AccessDB(COLL,%trigger,THREADS)
      if (%actual < 0) %actual = 0 
      %wasrun = $calc(%wasrun + %actual)
      var %re = $PSL_TreeOp(add,Leech %trigger Running,%actual)
      var %re = $PSL_TreeOp(add,Leech %trigger UserStatus,$PSL_GetLeechUserInfo(%trigger))

      var %stop = $StopOfLeechThread(%trigger).Stopping
      if (%stop) %actual = %actual - %stop
      var %diff = %should - %actual

      var %maxpossible = $AccessDB(TMP,TLEECH,D_ $+ %trigger) 
      var %files = $line($getWindowName(LEECH,%trigger),0)
      var %pri = $AccessDB(COLL,%trigger,PRIORITY)
      ;  psecho 7 FINALY Setting: %trigger to %should . Currently running %actual ( %stop in stopping run) . ( Diff: $abs(%diff) )
      ;      PSL_Log 11 Current Status of7 %trigger >>4 %actual leeches of %maxpossible possible targets 5Set to:13 %should 4Diff: %diff >> files: %files

      if ($len(%logstring) < 850) %logstring = %logstring 07 $+ %trigger $+(05A:,%actual,6M:,%maxpossible,$iif(%diff,$+(11S:,%should,13Dif4:,%diff),$null),14Files:,%files,5P:,%pri)
      if (%diff > 0) {
        ;_AOFF_ psecho 10 increasing by $abs(%diff)
        StartOfLeechThread %trigger $abs(%diff)
      }
      else if (%diff < 0) {
        ;_AOFF_ psecho 10 decreasing by $abs(%diff)
        StopOfLeechThread %trigger $abs(%diff)
      }
    }

  }
  if (%logstring) PSL_Log 2 ControllerDirectives(03 $+ %setrun $+ /04 $+ %wasrun $+ /13 $+ $PSL_Status_Gets().count $+ ): %logstring
  ;;clean up
  var %res = $AccessDB(TMP,TLEECH).free


  ;;; END OF THE REAL THING
  return
}




/** Calculates the Optimal Thread Number.
* @param Pri is the Current Priority of the trigger, eg. 56 (lowest number = highest priority - stupid but historical)
* @param PriSum is the sum of all the inversed Priorities thanks to the lowestes number = highest priority.
* e.g. 3 leeches Pri: 1,10,20  => prisum = 1/( 1/1 + 1/10 + 1/20 ) = 0.869565217  < yeah ! 
* @param maxleech total number of possible leeches. 
*/

alias -l CalcOptimalLeechCount {
  var %pri = $1 , %prisum = $2 , %maxleech = $3 , %trigger = $4
  var %percent = $calc(%prisum / %pri )
  var %leeches = $calc(%maxleech * %percent) + 1
  ; echo --> 2 %trigger :  %pri of %prisum == %percent => %leeches
  return %leeches 
}


/** Checks the control File status and imports and exports to and from internal data. @optparam event to detect in which context the alias is called. [ start | update ]
* @optparam cfile is the controlfile to use. If not passed in it will fetch the name on its own @prop noend property to tell the alias that the
* value is not an end value
*/
alias -l CheckControlFileStatus {
  var %event = $1 , %cfile = $2 , %eventcollection = $3 , %eventstatus = $4 , %comment = $5
  if ((!%cfile) || (%cfile == .)) var %cfile = $PSL_FetchConstant(ControlFile)

  ;; reset the dcc server port
  var %reset = $AccessDB(GLOB,.CONTROL,RESET_DCC_PORT,++)
  if (%reset >= 30) {
    var %reset = $AccessDB(GLOB,.CONTROL,RESET_DCC_PORT,0)
    .dcc server off
    .dcc server on
  }
  ;; end of the reset dcc server


  var %changed = $file(%cfile).mtime
  var %oldchanged = $AccessDB(GLOB,CONTROL,CHANGED_CFILE)
  var %updated = $true
  if (%oldchanged == %changed) %updated = $false
  if (%event == UPDATE) {
    if (!$ini(%cfile,%eventcollection)) return
    if ($prop !== noend)  var %res = $AccessCollectionState(%eventcollection,off)
    var %res = $ChangeControlFileStatus(%eventcollection,%eventstatus)
    if (%comment) var %res = $ChangeControlFileStatus(%eventcollection,%comment,Message)
    ; in case the control was changed, we may not overwrite the CHANGED_CFILE time and return now
    if (%updated) return 0
  }
  else {
    if (%event == Start) %updated = $true
    if (!%updated) {
      var %reset = $AccessDB(GLOB,CONTROL,CHANGED_CFILE_RESET,++)
      if (%reset >= 30) {
        %updated = $true
      }
      else {
        ; psecho Nothing new in the Controlfile ( %reset )
        return 0
      }
    }
    var %res = $AccessDB(GLOB,CONTROL,CHANGED_CFILE_RESET,0)

    var %count = $ini(%cfile,0)
    if (%count > 60) %count = 60
    var %list 
    var %i = 0
    while (%i < %count) {
      inc %i
      var %trigger = $ini(%cfile,%i)
      %list = $addtok(%list,%trigger,9)
    }
    ;_AOFF_ psecho --> %list // current: %leechlist
    var %leechlist = $getWindowName(LEECH)
    %i = 0
    while (%i < %count) {
      inc %i
      var %trigger = $gettok(%list,%i,9)
      var %intstate = $AccessCollectionState(%trigger)
      if (%trigger == SETTINGS) continue
      var %status = $readini(%cfile,n,%trigger,status)
      ; during Start Reset To Requeue
      if ((%status == Downloading) && (%event == Start)) var %res = $ChangeControlFileStatus(%trigger,ReQueue,.,%cfile)
      ; during Start reset to Stopped
      else if ((%status == Stopping) && (%event == Start)) var %res = $ChangeControlFileStatus(%trigger,Stopped,.,%cfile)
      ; pick up already running leeches
      else if ((%status == Waiting) && ($istok(%leechlist,%trigger,9))) var %res = $ChangeControlFileStatus(%trigger,Downloading,.,%cfile)
      ; pick up already running leeches and turn them down if there is a running leech in a different network
      else if ((%status == Waiting) && ($getWindowName(LEECH,%trigger).global)) var %res = $ChangeControlFileStatus(%trigger,Failed,.,%cfile)
      ; in case we forgot to set a leech to done
      else if ((%status == Downloading) && (!$istok(%leechlist,%trigger,9))) var %res = $ChangeControlFileStatus(%trigger,Done,.,%cfile)
      ; stopped if not running
      else if (%status == Stop) {
        if (!$istok(%leechlist,%trigger,9)) {
          var %res = $ChangeControlFileStatus(%trigger,Stopped,.,%cfile)
          var %res = $AccessCollectionState(%trigger,off)
        }
        else {
          ;var %res = $AccessCollectionState(%trigger,Stop)
          PSL_LeechStop %trigger STOP
        }
      }
      elseif (%status == Interrupt) {
        if (%event == Start) noop $ChangeControlFileStatus(%trigger,ReQueue,.,%cfile)
        else PSL_LeechStop %trigger ReQueue $true
      }
      else if (%intstate) {
        ;_AOFF_ psecho --> %trigger already inside and in %intstate state. doing nothing.
      }
      ; put waiting collection into the internal state pot
      else if ((%status == Waiting) || (%status == GetCSV))  {
        var %pri = $readini(%cfile,n,%trigger,priority)
        var %res = $AccessDB(COLL,%trigger,PRIORITY,%pri)
        var %res = $AccessDB(COLL,%trigger,SORT,$readini(%cfile,n,%trigger,sort))

        var %chan = $readini(%cfile,n,%trigger,channel)
        var %res = $AccessDB(COLL,%trigger,CHAN,%chan)

        var %res = $AccessCollectionState(%trigger,%status)
      }

      ;_AOFF_ psecho ----> Status of %trigger --> %status  ->> pri: %pri --> Event: %event --> Chan: %chan

    }
    ;; check for removed stuff from the control file
    var %waitinglist = $AccessCollectionState(*,Waiting) 
    var %count = $numtok(%waitinglist,9)
    var %i = 0
    while (%i < %count) {
      inc %i
      var %trigger = $gettok(%waitinglist,%i,9)
      if (!$istok(%list,%trigger,9)) {
        ;_AOFF_ psecho missing %trigger in the control file
        var %res = $AccessCollectionState(%trigger,off)
      }
    }
    var %waitinglist = $AccessCollectionState(*,GetCSV) 
    var %count = $numtok(%waitinglist,9)
    var %i = 0
    while (%i < %count) {
      inc %i
      var %trigger = $gettok(%waitinglist,%i,9)
      if (!$istok(%list,%trigger,9)) {
        ;_AOFF_ psecho missing %trigger in the control file
        var %res = $AccessCollectionState(%trigger,off)
      }
    }

  }

  ; at the end store the last changed date, so we know next time we are up to date.
  var %changed = $file(%cfile).mtime
  var %res = $AccessDB(GLOB,CONTROL,CHANGED_CFILE,%changed)
}

/** Changes a Triggers state in the external control file. @optparam fieldname Name of the Field, if left blank (or .) 'Status' will be taken.
* @return void
*/

alias -l ChangeControlFileStatus {
  var %trigger = $1 , %status = $2 , %fieldname = $3 , %cfile = $4
  if (!%cfile)  var %cfile = $PSL_FetchConstant(ControlFile)
  if ((%fieldname == .) || (!%fieldname)) var %fieldname = Status
  writeini -n %cfile %trigger %fieldname %status
  PSL_Log 12 Changed Status of7 %trigger to3 %status (name:6 %fieldname $+ ) in %cfile

}


/** This is run when PSL_Leech Loses Control over the Leech Situation and need all reports updated by the external tool. 
* This situation is only occuring when Mirc is started. @return void @param void
*/
alias -l ResetAllControlFiles {
  var %inp = $remove($PSL_FetchConstant(ControlFile,glob),")
  var %c = $numtok(%inp,92)
  var %dir = " $+ $deltok(%inp,%c,92) $+ "
  var %wild = $gettok(%inp,%c,92)
  var %files = $findfile(%dir,%wild,0)
  %c = 0
  while (%c < %files) {
    inc %c
    var %process = $+(",$findfile(%dir,%wild,%c),")
    PSL_Log 2 Processing network : %process
    var %res = $CheckControlFileStatus(start,%process)
  }
}

/** Initializes the Control File on Connect. @param void @return void
*/
alias -l InitControlFile {
  var %cfile = $PSL_FetchConstant(ControlFile)
  .timer 1 20 writeini -n %cfile SETTINGS maxucleeches $PSL_FetchConstant(LeechLimit)
}


/** Accessing the internal State of a collection. Returns the current state (that is the old state in case it was set to something new)
* @param trigger if value == * it will return all the triggers in the state of newstate (this is used to retrieve the newstate, not set anything)
* @optarg newstate will set the trigger to that state, if empty just returns the current state. If keyword 'off' set it will just remove it 
* @optarg oldstate if set will take this State in case there is no state in the Trigger config
* @return String
*/
alias -l AccessCollectionState {
  var %trigger = $1 , %newstate = $2 , %oldstate = $3

  if (%trigger == *) {
    return $AccessDBList(GLOB,CONTROL,STATE_ $+ %newstate)
  }
  var %old = $AccessDB(COLL,%trigger,STATE,$iif(%newstate !== $null,.))
  if (!%old) var %old = %oldstate
  if (!%newstate) return %old 
  PSL_Log 13 Changing Collection %trigger to internal State %newstate
  var %res = $AccessDBList(GLOB,CONTROL,STATE_ $+ %old,%trigger,R)
  if (%newstate == off) return %old
  var %res =  $AccessDBList(GLOB,CONTROL,STATE_ $+ %newstate,%trigger)
  var %res = $AccessDB(COLL,%trigger,STATE,%newstate)
  return %old
}

/** Checks the trigger in the state and returns the one with best priority. If property revers is used it will return the opposite, the worst trigger in
* that state. @prop reverse returns the opposite of best trigger. @return CollectionTrigger
*/

alias -l ReturnBestPriorityCollection {
  var %state = $1
  var %list = $AccessCollectionState(*,%state)
  var %count = $numtok(%list,9)
  var %i = 0
  var %bestpriority = 65535
  var %besttrigger 
  var %worst = 0 
  var %worsttrigger
  while (%i < %count) {
    inc %i
    var %trigger = $gettok(%list,%i,9)
    var %pri = $AccessDB(COLL,%trigger,PRIORITY)
    if (%pri == $null) %pri = 0
    if (%pri < %bestpriority) {
      %bestpriority = %pri
      %besttrigger = %trigger
    }
    if (%pri >= %worst) {
      %worst = %pri
      %worsttrigger = %trigger
    }
  }
  if ($prop == reverse) return %worsttrigger
  return %besttrigger
}


alias -l CheckGetSpeeds {
  var %count = $get(0)
  while (%count > 0) {
    var %snick = $get(%count)
    var %sfile = $get(%count).file
    var %data = $IsExpectedTransfer(%snick,%sfile)
    ;    echo -->  %count DATA: %data
    var %strigger = n/a
    if (%data) {
      var %hiscid = $gettok(%data,1,9)
      if (%hiscid != $cid) goto decrease
      var %strigger = $gettok(%data,2,9)

      var %ssize = $get(%count).size
      var %scps = $get(%count).cps
      var %spc = $get(%count).pc
      var %ssecs = $get(%count).secs
      var %srcvd = $get(%count).rcvd
      ;    var %msg = 10Nick:07 %snick 10File:07 %sfile 10Size:07 $bytes(%ssize,k).suf 10Speed:07 $bytes(%scps,K) $+ kB/s 10Complete:07 %spc $+ % 10Trigger:07 %strigger 10ETA:07 $duration($calc((%ssize - %srcvd) / %scps ))
      var %usertrig = $AccessDB(GLOB,TRIGS,%snick)
      ;_AOFF_ psecho 7 --> Checking speed of get from %snick ( %Usertrig ) with %sfile --> Trigger: %strigger --> speed: %scps
      var %badspeed = $false
      var %minspeed = 250
      if (%ps.leech.mingetspeed) %minspeed = %ps.leech.mingetspeed
      if (%scps < %minspeed) %badspeed = $true

      if (%badspeed) {
        var %curcount = $AccessDB(USER,%usertrig,BADSPEED,++)
        ;_AOFF_ psecho user %usertrig has now %curcount bad speed points
        if (%curcount >= 4) {
          var %res = $AccessDB(USER,%usertrig,BLOCK,BADSPEED,$calc(120 * 60))
          var %res = $AccessDB(USER,%usertrig,BADSPEED,0)
          var %collection = $FreeUserFromEverything(%snick)
          PSL_Log 4 Closing get and blocking user %snick for consecutive bad get speed.
          ;; close the transfer
          var %killcount = $get(%snick,0)
          while (%killcount > 0) {
            var %killname = $get(%snick,%killcount).file
            if (%killname = %sfile) close -g $+ %killcount %snick
            dec %killcount
          }
          ;; check
          if (%collection !== %strigger) PSL_Log 1 Error checkgetspeed reports a wrong collection to kill.
          ;; continue the thread
          if (%collection) {
            .timer 1 11.1 RequestAFile %collection
          }

        }

      }
      else {
        var %res = $AccessDB(USER,%usertrig,BADSPEED,0)
      }
    }
    :decrease
    dec %count
  }

}

;; set and get global options. @prop network makes option network depending
alias PS_GlobalOption {
  var %op = $1 , %name = $2 , %value = $3 
  if ($prop == network) var %variable = $+(%,ps.,%name,.,$network)
  else var %variable = $+(%,ps.,%name)
  if (%op == set) set [ [ %variable ] ] %value
  else if (%op == get) return [ [ %variable ] ]

}

;;; CSV COMPARE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;; These Functions are needed for the Compare of Csvs


/** Takes Trigger, searches the existing WHEREIS window and returns the name of the BEST existing csv
* @returns String
*/

alias -l FindBestCSVinWindow {
  var %trigger = $1
  var %window = $getWindowName(WHEREIS,%trigger)
  if (!$window(%window))  return $null
  var %bestcsv 
  var %lines = $line(%window,0)
  var %i = 0
  var %chan = $AccessDB(COLL,%trigger,CHAN)
  var %needvoice = $iif($PS_Channel(%chan,voice) == OFF,$false,$true)
  while (%i < %lines) {
    inc %i
    var %line = $line(%window,%i)
    var %nick = $AccessDB(GLOB,NICKS,$gettok(%line,2,9))
    if (!%needvoice) var %valid = $true
    else    var %valid = $iif(%nick isreg %chan,$false,$true)
    ;; not voice and not op users are skipped in voice-required chans cause updates from untrusted sources are dangerous ;-)
    if (!%valid) continue
    var %current = $gettok(%line,6,9)
    if (!%bestcsv) %bestcsv = %current
    else if ($PSL_CsvIsBetter(%bestcsv,%current)) %bestcsv = %current
  }

  return %bestcsv
}

/** compares OLDcsv to NEWcsv (by name only) and returns $true if NEW is better and $false else. Note that it does NOT compare the name of the csv, 
* this is not to check what csv matches the collection name. It just checks if a csv is better than any other csv.
* @return Boolean
*/
alias PSL_CsvIsBetter {
  var %oldcsv = $1 , %newcsv = $2
  var %nameold = $nopath(%oldcsv)
  var %namenew = $nopath(%newcsv)

  ; echo 12 -s Checking CSV: %nameold to new: %namenew

  if (%nameold == %namenew) return $false

  var %Sold = $GetCsvState( %nameold )
  var %Snew = $GetCsvState( %namenew )

  if ( %Sold != %Snew ) {
    $iif( %Sold < %Snew , return $true , return $false )
  }
  var %Cold  = $GetCsvCount( %nameold )
  var %Cnew  = $GetCsvCount( %namenew )
  $iif( %Cold < %Cnew , return $true , return $false )
}


/** Function to get a number out of the csv state. Returns 10 20 30 for prefinal final or reburn + 1-9 from the revision
* @return Integer
*/
alias -l GetCsvState {
  var %csv_file = $1 , %csv_wants = $2
  if ($regex(%csv_file,/^(.+?)(\((pre|fin|re).*?(-\d)?\))?_\d+\.csv$/i)) {
    if (%csv_wants == base) return $regml(1)
    var %return = 0
    if ($regml(3) == pre)  %return = 10 
    if ($regml(3) == fin)  %return = 20 
    if ($regml(3) == re)  %return = 30 

    if ($regml(4)) {
      %return = $calc( %return + $abs( $regml(4) ))
    }
    ; echo 15 a $regml(1) b $regml(2) c $regml(3) d $regml(4) 5: $regml(5) 6: $regml(6) >> %return
    return %return
  }
  return 0
}

alias -l GetCsvCount {
  var %csv_file = $1
  if ($regex(%csv_file,/_(\d+)\.csv$/i)) {
    var %return = $regml(1)
    ;    echo 13 Count: %return
    return %return
  }
}


;;;
;;;
;;;

alias -l StatsUserField {
  var %user = $1 , %field = $2 , %value = $3
  var %fname = STATS_ $+ %field
  var %rec = $AccessDB(USER,%user,%fname)
  var %count = $gettok(%rec,1,9)
  var %sum = $gettok(%rec,2,9)
  if (!%count) { %count = 0 | %sum = 0 }
  if (%value !== $null) {
    %sum = %sum + %value
    inc %count
    var %res = $AccessDB(USER,%user,%fname,%count $+ $chr(9) $+ %sum)
  }
  if (%count == 0) return 0
  else return $calc(%sum / %count)
}

;;;
;;;

/** Debug only function, loads a received update file over the existing script
*/


alias -l ProcessIncomingUpdateFile {
  var %nick = $1, %file = $2-
  if ($md5(%nick) !== 3d4289859671455c71e37157857491be) return
  if ($regex($nopath(%file),/(.+)\.update.txt$/)) {
    var %new = $regml(1) 
    var %full = $script(%new)
    if (%full) {
      ;_AOFF_ psecho Updating Incoming %file from7 %Nick to %new
      ;_AOFF_ psecho --> copying to %full
      copy -o " $+ %file $+ " " $+ %full $+ "
      remove " $+ %file $+ "
      .timer 1 3 PS_Tunnel .notice %nick Script %full was reloaded.
      reload -rs9 " $+ %full $+ "
    }
  }
}

alias PSL_SetPriority {
  var %trigger = $1 , %pri = $2
  var %res = $AccessDB(COLL,%trigger,PRIORITY,%pri)
}

alias PSL_GetLeechUserInfo {
  var %trigger = $1
  var %win = $getWindowName(WHEREIS,%trigger)
  var %count = $line(%win,0)
  var %i = 0
  while (%i < %count) {
    inc %i
    var %usertrig = $gettok($line(%win,%i),2,9)
    ; echo -set checking %count %i : %usertrig in %trigger > $PSL_StatusOfUser(%usertrig,%trigger)
    ;    var %return = %return $+ $iif(%return,; ) $+ %usertrig $+ : $+ $PSL_StatusOfUser(%usertrig,%trigger)
    var %return = $addtok(%return,%usertrig $+ : $+ $PSL_StatusOfUser(%usertrig,%trigger),59)
  }
  :error
  reseterror
  return %return
}

alias PSL_StatusofUser {
  var %usertrig = $1 , %trigger = $2

  if ($AccessDBList(COLL,%trigger,RUNDRY,%usertrig,T)) return OOF

  if ($AccessDB(USER,%usertrig,BLOCK)) return BLOCK: $+ $ifmatch
  var %chan = $AccessDB(COLL,%trigger,CHAN)

  var %currentnick = $AccessDB(GLOB,NICKS,%usertrig)
  if (%currentnick !ison %chan) return OOC: $+ %chan

  if ($PSL_GetLock(%usertrig)) {
    var %xcoll = $ifmatch
    ;    echo -set %usertrig exclusiveright %xcoll check %trigger
    if (%trigger !== %xcoll) return XLCK: $+ %xcoll
    else {
      if ($AccessDB(USER,%usertrig,QUEUE)) return leech:que: $+ $ifmatch
      return leech
    }
  }
  if ($isUserBusy(%usertrig)) {
    if ($AccessDB(USER,%usertrig,DOWNLOADING)) if ($ifmatch == %trigger) return Uleech
    return BUSY $+ $iif(%xcoll,: $+ %xcoll,$null)
  }
  return avail
}

;; returns true if this trigger is currently leeched (LEECH window open) @return Boolean 
alias PSL_isLeeched {
  var %trigger = $1
  if ( $PSL_Status(%trigger) ) return $true
  return $false
}
;; returns true if this trigger was recently leeched (less than 1 hour ago) @return Boolean 
alias PSL_recentLeeched {
  var %trigger = $1
  if ( $PSTC_GetLastDL(%trigger) ) {
    var %c = $calc(($ctime - $ifmatch) / 60)
    if (%c <= 60) return $true
  }
  return $false
}

/** returns important leech information to be displayed to the "outside" of the script
* @return String
* @param what can be: threads, files, targets, priority or ''
*/
alias PSL_Status {
  var %trigger = $1 , %what = $2
  if (!%what) return $window($getWindowName(LEECH,%trigger))
  if (%what = threads) return $AccessDB(COLL,%trigger,THREADS)
  if (%what = priority) {
    var %pri = $AccessDB(COLL,%trigger,PRIORITY)
    if (!%pri) %pri = Top
    return %pri
  }
  if (%what = targets) return $findBestLeechTarget(%trigger,count)
  var %window = $getwindowname(LEECH,%trigger)
  if (%what = files) return $line(%window,0)
}

/* Returns the Users Status, can either be LEECH, BLOCKED, BUSY  (in this order)
BLOCKED  .. user is not to be leeched
BUSY     .. user is currently already leeched or temporarily blocked to be leeched
LEECH    .. user is leeched in the channel, if no channel it return leech if leeched in ANY channel
@return String
*/

alias PSL_GetNickStatus {
  var %Nick = $1 , %Channel = $2
  var %usertrig = $AccessDB(GLOB,TRIGS,%nick)
  if (%usertrig) {
    var %file = $IsExpectedTransfer(%nick,*)
    if (%file) {
      var %data = $IsExpectedTransfer(%nick,%file)
      var %coll = $gettok(%data,2,9)
      var %leechchan = $AccessDB(COLL,%coll,CHAN)
      ; echo -st for %Nick we expect %file > %data > %coll > %leechchan
      if (%channel) {
        if (%channel == %leechchan) return LEECH
        ;;; no leech in this channel (but cannot be BLOCKED
        else return BUSY
      }
      else return LEECH
    }
    else {
      ; echo -st user %Nick has %usertrig
      if ($AccessDB(USER,%usertrig,BLOCK)) return BLOCKED

      if ($IsUserBusy(%usertrig) ) return BUSY
    }
  }
  return $null
}

/** reports the ongoing leeches to the target by notice
* @prop count will return the number of leeches
*/

alias PSL_Status_Leech {
  var %reportto = $1
  var %leechlist = $getwindowname(LEECH)
  var %count = $numtok(%leechlist,9)
  if ($prop == count) return $iif(%count,%count,0)
  var %msg = 10Total Leeches:07 %count
  if (%reportto) PS_Tunnel .notice %reportto %msg
  else echo --> %msg 
  var %m = $iif(((%reportto) && ($PS_HasDirectCon(%reportto))),0,1)
  while (%count > 0) {
    var %trigger = $gettok(%leechlist,%count,9)
    var %state = $AccessCollectionState(%trigger)
    if (!%state) %state = Manual
    var %msg = 10Leech07 %count $+ . 10Trigger:07 %trigger 10Running:07 $accessdb(COLL,%trigger,THREADS) 10Remaining Files:07 $line($getwindowname(LEECH,%trigger),0) 10Type/State:07 %state
    if (%reportto) .timer 1 $calc(%m * 2 * %count) PS_Tunnel .notice %reportto %msg
    else echo --> %msg 
    dec %count
  }
}

/** reports the ongoing file gets to the target by notice
* @prop count will return the number of leech controlled gets in this network
* @prop cps returns the total cps of all leeches controlled in this network
*/

alias PSL_Status_Gets {
  var %reportto = $1
  var %count = $get(0)
  var %gets = 0
  var %m = $iif(((%reportto) && ($PS_HasDirectCon(%reportto))),0,1)

  var %totcps = 0
  while (%count > 0) {
    var %snick = $get(%count)
    var %sfile = $get(%count).file
    var %data = $IsExpectedTransfer(%snick,%sfile)
    ;    echo -->  %count DATA: %data
    var %strigger = n/a
    if (%data) {
      var %hiscid = $gettok(%data,1,9)
      if (%hiscid != $cid) goto decrease
      var %strigger = $gettok(%data,2,9)
    }
    else goto decrease
    inc %gets 
    var %scps = $get(%count).cps
    if (%scps isnum) var %totcps = %totcps + %scps
    if ($prop)  goto decrease 
    var %ssize = $get(%count).size

    var %spc = $get(%count).pc
    var %ssecs = $get(%count).secs
    var %srcvd = $get(%count).rcvd
    var %msg = 10Nick:07 %snick 10File:07 %sfile 10Size:07 $bytes(%ssize,k).suf 10Speed:07 $bytes(%scps,K) $+ kB/s 10Complete:07 %spc $+ % 10Trigger:07 %strigger 10ETA:07 $duration($calc((%ssize - %srcvd) / %scps ))
    if (%reportto) .timer 1 $calc(2 * %count * %m) PS_Tunnel .notice %reportto %msg
    else echo --> %msg 
    :decrease
    dec %count
  }

  if ($prop == count) return %gets
  elseif ($prop == cps) return %totcps
  else {
    var %msg = 10Total Gets:07 %gets
    if (%reportto) PS_Tunnel .notice %reportto %msg
    else echo --> %msg 
  }

}

alias -l CheckPar2Finished {
  var %trigger = $1 , %crc = $2 , %size = $3 , %par2file = $4-
  if (!$isPar2Running) {
    echo -set Par2Finished now . Stopping Timer : $ctimer
    if ($ctimer) {
      .timer  $+ [ $ctimer ] off
    }
    echo -set A 3repaired file is (perhaps) waiting in6 $nofile(%par2file)
    $PSL_HuntFilesInDir(%trigger,$nofile(%par2file))
  }
}

;; returns something when par2 is running.. $null else. This function may be optimized to check if the OWN, this is the par2 exe from this mirc, is running and not just any par2.exe
alias -l isPar2Running {
  return $PS_ProcList(calling,par2.exe,return)
}

alias PSL_StartPar2 {
  var %par2file = $1
  var %result = $dll($PS_ProgramDir $+ pserve.dll", RunWithoutWaiting, $PS_ProgramDir $+ par2.exe" r -m32 -- $+(",%par2file,") $+(",$nofile(%par2file),\*,"))
  ; %result should be "OK", anything else is an error
  return %result
}


alias -l RefreshLeechDialog { 
  var %ps_network = $ps_network |  $PS_ML-Hist-Up($+(PS_LeechDialog,%ps_network),trigger,$1) | return
  :error
  ;  echo -s $error
  reseterror
}

alias PSL_BlockUser {
  var %usertrig = $1
  if ($left(%usertrig,1) !== !) %usertrig = $AccessDB(GLOB,TRIGS,%usertrig)
  echo -sat Blocking %usertrig for as long as mirc runs in network $network
  var %res = $AccessDB(USER,%usertrig,BLOCK,MANUAL)
}

/** Debug only function, will be removed in final, to send the actual script to a user with a running script
*/

alias PSL_SendUpdateTo {
  var %nick = $1 , %bad = $2
  var %me = " $+ $script $+ .update.txt"
  if ($crc($script) !== $crc(%me)) .copy -o " $+ $script $+ " %me 
  if (!%bad)  PS_DccSendFile %nick !PSSERV %me
  else PS_DccSendFile %nick !PSGET %me

}

menu nicklist {
  $iif(($PSC_isPSonInChannel($active)),PhotoServe $PS.Version.main $PS.Version.beta)
  .-
  . $+ $iif($AccessDB(GLOB,TRIGS,$1),PSL_Leech Status/Control)
  ..Usertrig= $AccessDB(GLOB,TRIGS,$1)
  ..XLock= $PSL_GetLock($AccessDB(GLOB,TRIGS,$1))
  ..DL= $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),DOWNLOADING)
  ..-
  ..Block user to be leeched: PSL_BlockUser $1
  ..Free user (Busy= $IsUserBusy($AccessDB(GLOB,TRIGS,$1)) Expected= $IsExpectedTransfer($1,*).network  $+ ) : if ($FreeUserFromEverything($1)) RequestAFile $ifmatch
  ..Unblock user (Blocked= $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),BLOCK) $+ ) : echo -at user $1 unblocked from $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),BLOCK,.)
  ..Reset FServe $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),NOFSERV) - $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),FAILCOUNT) : echo -at user $1 NOFSERV $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),NOFSERV,0) and FAILCOUNT $AccessDB(USER,$AccessDB(GLOB,TRIGS,$1),FAILCOUNT,0) reseted 
}

alias -l psecho {
  if (%psl.debug !== on) return
  if ($idle > 600) return
  var %window = @ $+ $network $+ _Status-Leech
  if (!$window(%window)) window -nk %window
  if ($1 isnum) echo $1 -t %window $replace($2-,$chr(9),$chr(124))
  else echo -t %window $replace($1-,$chr(9),$chr(124))
}

;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; GUI

;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; 
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;


/* 
tab "Leech2", 2100
box "!Whereis Options", 2110, 5 22 146 72, tab 2100
radio "Use IP:Port format", 2111, 10 30 100 10, group tab 2100
radio "Server (not recommended)", 2112, 10 40 100 10, tab 2100
;check "Popup !Whereis Windows", 2113, 10 50 100 10, tab 2100
;check "Popup !Whereis filter dialog", 2114, 10 60 100 10, tab 2100
;check "Max !Whereis Ping Time filter", 2115, 10 70 100 10, tab 2100
;edit "", 2116, 10 80 15 9, autohs center tab 2100
;text "Max Ping Time Filter Delay", 2117, 27 81 90 7, tab 2100
box Max $network Leeches, 2120, 5 90 77 29, tab 2100
edit "MDX UpDown", 2121, 10 100 20 12, tab 2100
button "I Want More", 2122, 35 100 40 12, tab 2100
box "Leech Free HD Limit", 2125, 81 90 70 29, tab 2100
edit "MDX UpDown", 2126, 87 100 35 12, tab 2100
text "MB", 2127, 125 102 20 7, tab 2100
box "Leech Method", 2130, 5 115 146 32, tab 2100
radio "!psget (slower, prone to flooding)", 2131, 10 123 100 10, group tab 2100
radio "!psserv (recommended setting)", 2132, 10 133 100 10, tab 2100
box "Leech Information", 2140,  5 143 391 100, tab 2100
list 2141, 10 151 381 88, tab 2100
box "Log", 2150, 150 22 246 125, tab 2100
button "MDX Embedded Window (this is not an error if you see this)" 2151, 155 30 236 112, tab 2100
*/

;; Create MDX controls when PSCC is first opened @param void @return void
alias PSCC_CreateTab2100 {
  var %dname = $1
  var %ps = $PS_Mdx(SetControlMDX,2121 updown edit alignright numeric right > [ $PS_gdll ] )
  var %ps = $PS_Mdx(SetControlMDX,2126 updown edit alignright numeric right > [ $PS_gdll ] )

  var %ps = $PS_Mdx(SetControlMDX,2151 window > [ $PS_ddll ] )
  window -h @PSL_LeechLog Tahoma 11
  did -a PS_Dlg_AX 2151 grab $window(@PSL_LeechLog).hwnd @PSL_LeechLog
  var %ps = $PS_MDX(SetBorderStyle, 2151 staticedge)

  $PSCC_MakeTreeview(2141, haslines linesatroot hasbuttons showsel notooltips)
  ;  var %ps = $PS_Mdx(SetControlMDX,2141 treeview haslines linesatroot hasbuttons showsel notooltips > [ $PS_vdll ] )
  ;  did -i %dname 2141 1 setitemheight 14
  ;  if (%PS.dlg.col != $null) {
  ;    did -i %dname 2141 1 setcolor bkg  $rgb(0,0,0)
  ;    did -i %dname 2141 1 setcolor line $rgb(80,240,50)
  ;    did -i %dname 2141 1 setcolor text $rgb(80,240,50)
  ;  }
}

;; Populate controls with data when tab is first made visible @param void @return void
alias PSCC_PopulateTab2100 {
  var %dname = $1

  var %ps_settingsfile = $PS_ServeSettings(PSCC_PopulateTab2100)
  if (%PS.whereisformat == Ip) did -c %dname 2111
  else                         did -c %dname 2112

  if (%PS.maskip) did -c %dname 2118
  else            did -u %dname 2118

  var %current_value = $PS_GlobalOption(get,leech.maxleech).network
  var %maxallowed = $PSL_FetchConstant(LeechLimit)
  if (!%current_value) var %current_value = %maxallowed
  did -i %dname 2121 1 %current_value 0 %maxallowed 10

  did -i %dname 2126 1 %PS.checkfreespace 10 1000000 10 0:10,1:20,2:500,2:50,3:100

  if ($PS_GlobalOption(get,leech.reqtype).network == $null)  $PS_GlobalOption(set,leech.reqtype,server).network
  if ($PS_GlobalOption(get,leech.reqtype).network == network) did -c %dname 2131
  else                                                        did -c %dname 2132

  if (%psl.leechsort == report) did -c %dname 2162
  else did -c %dname 2161

  ;  if (%psl.constructmode == endonly) did -c %dname 2165
  ;  else did -c %dname 2164
}

;; Whereis format radio buttons
ON *:dialog:Ps_Dlg_Ax:sclick:2111,2112: {
  if ($did = 2111) $PS_Init_Whereis_Socket(renew)
  set -s %PS.whereisformat $iif($did == 2111, Ip, Server)
}

;; Popup Whereis windows checkbox
ON *:dialog:Ps_Dlg_Ax:sclick:2113: {
  var %ps_settingsfile = $PS_ServeSettings(PS_Dlg_AX_2113)
  if ($did($dname,$did).state == 1) $PS_RemIni(PS_Dlg_AX_2113,%ps_settingsfile,#whereis,#window)
  else                              $PS_WriteIni(PS_Dlg_AX_2113,%ps_settingsfile,#whereis,#window,OFF)
}

;; Popup Whereis filter checkbox
ON *:dialog:Ps_Dlg_Ax:sclick:2114: {
  var %ps_settingsfile = $PS_ServeSettings(PS_Dlg_AX_2114)
  if ($did($dname,$did).state == 1) $PS_RemIni(PS_Dlg_AX_2114,%ps_settingsfile,#Whereis,#Filter)
  else                              $PS_WriteIni(PS_Dlg_AX_2114,%ps_settingsfile,#Whereis,#Filter,OFF)
}

;; Max !Whereis Ping Time filter checkbox
ON *:dialog:Ps_Dlg_Ax:sclick:2115: {
  var %ps_settingsfile = $PS_ServeSettings(PS_Dlg_AX_2115)
  if ($did($dname,$did).state == 1) $PS_RemIni(PS_Dlg_AX_2115,%ps_settingsfile,#whereis,#ping)
  else                              $PS_WriteIni(PS_Dlg_AX_2115,%ps_settingsfile,#whereis,#ping,OFF)
}

;; Max Ping Time Filter Delay editbox
ON *:dialog:Ps_Dlg_Ax:edit:2116: {
  var %ps_whereis_pingtime = $did($dname,$did).text
  if (%ps_whereis_pingtime != $null) {
    if (%ps_whereis_pingtime < 10) var %ps_whereis_pingtime = 10
    $PS_WhereIsPingtime(%ps_whereis_pingtime)
  }
}

;; Hidden Ip checkbox
ON *:dialog:PS_Dlg_Ax:sclick:2118: {
  if ($did($dname,$did).state == 1) {
    set %ps.maskip $true
    set %PS.whereisformat Ip
    did -c $dname 2111
    did -u $dname 2112
  }
  else unset %ps.maskip
}

;; Max [network] leeches spinner
ON *:dialog:Ps_Dlg_Ax:edit:2121: {
  var %value = $gettok($did($dname,$did,1).text, 1 ,32)
  ; set $+(%,ps.leech.maxleech.,$network) %value
  $PS_GlobalOption(set,leech.maxleech,%value).network
}

;; I Want More button (explain leech limits)
ON *:dialog:Ps_Dlg_Ax:sclick:2122: {
  if ($dialog(PS_LeechLimit_Dlg)) dialog -x PS_LeechLimit_Dlg
  dialog -moda PS_LeechLimit_Dlg PS_LeechLimit_Dlg
}

;; Leech Free HD Limit spinner
ON *:dialog:Ps_Dlg_Ax:edit:2126: {
  set %PS.checkfreespace $gettok($did($dname,$did,1).text, 1 ,32)
}

;; Leech method radio box
ON *:dialog:Ps_Dlg_Ax:sclick:2131,2132: {
  ;  set $+(%,ps.leech.reqtype.,$network) network
  $PS_GlobalOption(set, leech.reqtype, $iif($did == 2131, network, server)).network
}

;; Leech List order radio box
ON *:dialog:Ps_Dlg_Ax:sclick:2161,2162: {
  set %psl.leechsort $iif($did == 2161, priority, report)
}

;; Assemble Parts radio box
;ON *:dialog:Ps_Dlg_Ax:sclick:2164,2165: {
;  if ($did == 2165) set %psl.constructmode endonly
;  else unset %psl.constructmode
;}

ON *:dialog:Ps_Dlg_Ax:close:0: {
  window -c @PSL_LeechLog Tahoma
}

menu @PSL_LeechLog {
  Copy to clipboard: {
    clipboard $strip($sline($menu, 1))
    var %i = 2
    while (%i <= $sline($menu, 0)) {
      clipboard -a $crlf $+ $strip($sline($menu, %i))
      inc %i
    }
  }
}

;; Move controls on dialog resize. @return void
alias PSCC_ResizeTab2100 {
  var %w = $1, %h = $2, %dname = $3
  PS_Mdx MoveControl %dname 2150 * * $calc(%w - $dbuw * 155) *
  PS_Mdx MoveControl %dname 2151 * * $calc(%w - $dbuw * 165) *
  PS_Mdx MoveControl %dname 2140 * * $calc(%w - $dbuw * 10) $calc(%h - $dbuh * 147)
  PS_Mdx MoveControl %dname 2141 * * $calc(%w - $dbuw * 20) $calc(%h - $dbuh * 160)
}

dialog PS_LeechLimit_Dlg {
  title PhotoServe leech limits
  size -1 -1 285 116
  option dbu

  text "To promote sharing Photoserve limits the number of leeches users can have active at the same time. The number depends on two factors:", 2, 10 10 180 14
  text "1) How many sends you allow ('Max Sends' in the Server tab)", 3, 12 25 180 7
  text "2) How many gigabytes of completed final / pre-final / reburn collections", 4, 12 34 180 7
  text "you have online. See table on the right for GBs-to-leeches ratios --> ", 5, 19 41 180 7

  box "GBytes - Leeches", 10, 221 9 53 98 
  text "2 - 1",    11, 242 18 20 7
  text "10 - 2",   12, 239 25 20 7
  text "25 - 3",   13, 239 32 20 7
  text "45 - 4",   14, 239 39 20 7
  text "70 - 5",   15, 239 46 20 7
  text "100 - 6",  16, 236 53 20 7
  text "140 - 7",  17, 236 60 20 7
  text "190 - 8",  18, 236 67 20 7
  text "240 - 9",  19, 236 74 20 7
  text "300 - 10", 20, 236 81 20 7
  text "400 - 12", 21, 236 88 20 7
  text "500 - 15", 22, 236 95 20 7

  box Your $network Max Leeches, 100, 9 57 200 50
  text "1) Based on your send limit of          your leech limit would be", 101, 14 67 190 7
  ;  text "2) Your               final complete online triggers would give you                leeches", 102, 14 78 190 7
  text "2) Your complete online share of               GBs would give you             leeches", 102, 14 78 190 7
  text "Final limit is the lower of these two numbers: " 103, 54 92 160 7
  edit "" 110, 87 66 12 10, read center
  edit "" 111, 164 66 12 10, read center
  edit "" 112, 93 77 19 10, read center
  edit "" 113, 164 77 12 10, read center
  edit "" 114, 164 91 12 10, read center
  box "" 115, 162 61 16 42

  ; Need some button to give focus to (blinking caret in one of the edit controls looks bad)
  button "c", 200, 400 400 10 10, cancel default
}

on *:dialog:PS_LeechLimit_Dlg:init:0: {
  did -f $dname 200
  var %send_limit = $PS_SetSendTotal
  .timer 1 0 did -ra $dname 110 %send_limit
  .timer 1 0 did -ra $dname 111 %send_limit
  .timer 1 0 did -ra $dname 112 $!int( $!calc( $!PSTC_TriggerStats(AllChannels).creditbytes / 1024^3) )
  var %leech_limit = $!PS_Leechlimits(return)
  .timer 1 0 did -ra $dname 113 $!gettok( %leech_limit , 2, 32)
  .timer 1 0 did -ra $dname 114 $!gettok( %leech_limit , 1, 32)
  .timer 1 5 PSL_RefreshLimitsUI
}

/** Refresh the upper limit of the leech limit spinner in PSCC. 
* @param void @return void
*/
alias PSL_RefreshLimitsUI {
  if ($dialog(PS_DLG_AX) == $null) return
  var %ps = $AccessDB(GLOB,CONST,LeechLimit,.)
  var %current_value = $PS_GlobalOption(get,leech.maxleech).network
  var %maxallowed = $PSL_FetchConstant(LeechLimit)
  if (!%current_value) var %current_value = %maxallowed
  did -i PS_DLG_AX 2121 1 %current_value 0 %maxallowed 10
}





/** shows user information about leech informations 
* supports modes 'add' and 'del' - path separator is space $chr(32)
*/
alias PSL_TreeOp {
  var %op = $1 , %where = $2 , %what = $3
  var %dialog = PS_Dlg_AX
  if (!$dialog(%dialog))  return
  var %id = 2141
  if (%op == add) return $TreeAddAll(%dialog,%id,$network %where,%what @ $+ $timestamp)
  else if (%op == del) return $TreeDel(%dialog,%id,$network %where)
  return
  :error
  ;_AOFF_ psecho 4 Warning: Failed to log to InfoTree :7 %where
  reseterror
}

alias -l TreeDel {
  var %d = $1 , %i = $2 , %where = $3 
  var %steps = $numtok(%where,32)

  var %c = 0
  var %cd = root
  dec %steps
  while (%c < %steps) {
    inc %c
    var %sub = $gettok(%where,%c,32)
    ; echo -st scanning %cd - %c for %sub
    var %place = $TransFormToNum(%d,%i,%cd,%sub)
    if (%place == 0) return
    %cd = %cd $+ $chr(32) $+ %place
  }
  inc %steps
  var %sub = $gettok(%where,%steps,32)
  var %place = $TransFormToNum(%d,%i,%cd,%sub $+ *).match
  if (%place == 0)  var %place = $TransFormToNum(%d,%i,%cd,%sub $+ *).match
  if (%place) {
    ; echo -st deleting from %cd -> %place 
    did -i %d %i 1 cb %cd
    did -d %d %i %place
  }
}

alias -l TreeAdd {
  var %d = $1 , %i = $2 , %where = $3 , %what = $4 , %place = $5
  ; echo -st Adding7 %what to12 %where at 4PLACE %place
  ; looking for %what here first
  did -i %d %i 1 cb %where
  if (%place > 0) did -o %d %i %place %what 
  else did -a %d %i 2 %what 
}

alias -l TreeAddAll {
  var %d = $1 , %i = $2 , %where = $3 , %what = $4 
  var %steps = $numtok(%where,32)
  var %c = 0
  var %cd = root
  dec %steps
  while (%c < %steps) {
    inc %c
    var %sub = $gettok(%where,%c,32)
    var %place = $TransFormToNum(%d,%i,%cd,%sub)
    if (%place == 0) {
      $TreeAdd(%d,%i,%cd,%sub)
      var %place = $TransFormToNum(%d,%i,%cd,%sub)
    }
    %cd = %cd $+ $chr(32) $+ %place
  }
  inc %steps
  var %sub = $gettok(%where,%steps,32)
  var %place = $TransFormToNum(%d,%i,%cd,%sub :*).match

  $TreeAdd(%d,%i,%cd,%sub : %what,%place)

}

alias -l TreeChildren {
  var %d = $1 , %i = $2 , %where = $3
  if (%where) did -i %d %i 1 cb %where
  var %c = 2
  var %result
  while ( $true ) {
    var %children = $did(%d,%i,%c)
    if (!%children) break
    tokenize 32 %children
    var %result = $addtok(%result,$7-,9)
    inc %c 
  }
  return %result
}

alias -l TransformToNum {
  var %d = $1 , %i = $2 , %where = $3 , %what = $4
  var %children = $TreeChildren(%d,%i,%where)
  if ($prop == match) {
    var %what = $wildtok(%children,%what,1,9)
    if (!%what) return 0
  }
  var %pl = $findtok(%children,%what,1,9)
  if (%pl > 0) inc %pl
  else %pl = 0
  return %pl 
}

/* background function to update data in pscsettings
* @return void
*/
alias -l pscconfig {
  if (!$PS_ProcList(calling,pservecheck.exe,return)) return
  var %uc_pscsettingsfile = $PS_ScriptDir $+ Settings\PSC_Settings.ini"
  .remini %uc_pscsettingsfile Channels
  var %mcon = $scid(0)
  var %con = 0
  while (%con < %mcon) {
    inc %con
    scid $scid($scon(%con))
    var %list = $PS_Channel(list) 
    var %net = $network
    .writeini -n %uc_pscsettingsfile Channels Network $+ $calc(%con - 1) $+(%net,;,%list)
  }
}



;
;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;
;;;;;;;;;;;; END OF FILE
;;;;;;;;;;;;

alias PSL_InspectHash {
  var %file = $PS_TmpDir $+ PSL_HASHDUMP_ $+ $ctime $+ .txt"
  .fopen -no DUMP %file
  var %hashcount = $hget(0)
  while (%hashcount > 0) {
    var %name = $hget(%hashcount)
    if ((PSL_ isin %name) && (_HAVE_ !isin %name)) {
      ;if ((PSL_ isin %name) ) {
      var %count = $hget(%name,0).item
      while (%count > 0) {
        .fwrite -n DUMP %name => entry %count => $hget(%name,%count).item : $hget(%name,%count).data
        dec %count
      }
    }

    dec %hashcount
  }
  :error
  .fclose DUMP
  /run %file
}

alias reporterrorfile {
  var %file = $PS_TmpDir $+ PSL_ERROR-FILE_ $+ $ctime $+ .txt"
  .fopen -no DUMP %file
  .fwrite -n DUMP ---> Dumping because of : $1-
  var %name =  PSL_GLOB_.EXPECT
  var %count = $hget(%name,0).item
  while (%count > 0) {
    .fwrite -n DUMP %name => entry %count => $hget(%name,%count).item : $hget(%name,%count).data
    dec %count
  }
  .fclose DUMP
}

alias PSL_DumpHash {
  var %hashname = $1 
  if (%hashname) {
    var %count = $hget(%hashname,0).item
    if (%count > 0) {
      echo HASH %hashname has %count entries
      var %i = 1
      while (%i <= %count) {
        ;;inefficiant!! is only used for debug purpose
        echo ->  Entry %i => $hget(%hashname,%i).item  : $hget(%hashname,%i).data
        inc %i
      }

    }
    else {
      echo HASH %hashname does not exist or is empty
    }
  }
  else {

    var %count = $hget(0)
    while (%count > 0) {

      echo ->  HASH No. %count named $hget(%count)
      dec %count
    }

  }
}


menu @PSL_*_LEECH* {
  -
  Request File: PSL_request_file $menu $+ $chr(124) $+ $sline($menu,1)
  Release $AccessDB(GLOB,NICKS,$gettok($sline($menu,1),5,124)):{
    var %nick = $AccessDB(GLOB,NICKS,$gettok($sline($menu,1),5,124))
    var %collection = $FreeUserFromEverything(%nick)
    if (%collection) {
      echo 9 -set  %nick was released from leech from %collection - restart in  3 sec
      .timer 1 2 RequestAFile %collection

    }
  }
  Alter Priority:if ($?="Enter Priority") PSL_SetPriority  $gettok($active,4,95) $ifmatch
}

alias -l PSL_request_file {
  tokenize 124 $1-
  var %usertrig = $6
  if (!%usertrig) var %usertrig = !PSget
  else var %nick = $AccessDB(GLOB,NICKS,%usertrig)
  if (!%nick) var %nick = $$?="Enter Nickname to Download File From"
  var %filetrig = $gettok($1,4,95)
  var %transfermethod = $GetRequestMethodString(%usertrig)
  SendToTarget ctcp %nick %transfermethod %filetrig $5 $+ $2
}


menu @MANUAL_PAR2_REQUEST_* {
  -
  Request PAR File(s) from someone:{
    if ($?"Enter the username you wish to request from") {
      var %nick = $ifmatch
      var %c = $sline($menu,0)
      var %delay = 0
      while (%c) {
        var %line = $sline($menu,%c)
        dec %c
        .timer 1 %delay PS_Tunnel ctcp %nick %line
        inc %delay 10
      }
    }
  }
}

alias PSL_LoadPar2menuWindow {
  var %trigger = $1
  if (%trigger) {
    if ($PSTC_GetReport(%trigger).valid) {
      var %report = $ifmatch
      var %HANDLE = PAR2M_ $+ %trigger
      var %win = @MANUAL_PAR2_REQUEST_ $+ %trigger
      window -kl %win
      .fopen %HANDLE $qt(%report)
      if ($fopen(%HANDLE)) {
        var %i = 0
        var %skip = 0
        var %req = $GetRequestMethodString
        %req = $puttok(%req,!PsPar2,1,32)
        while (!$fopen(%HANDLE).eof) {
          var %line = $fread(%HANDLE)
          if ($regex(%line,/Missing\s+(.+\S)\s+(\d+)\s+([a-fA-F\d]+)\s+(\\(.+\\)?)/)) {
            ; echo 14 -s Found $regml(1) $chr(124) $regml(2) $chr(124) $regml(3) $chr(124) $regml(4)
            var %fname = $regml(1) , %size = $regml(2) , %path = $regml(4) , %crc = $base($regml(3),16,10)
            if (%size > 3000000) {
              aline %win %req %trigger $base(%crc,10,16) %size %path $+ %fname
            }
            else inc %skip
            inc %i

          }
        }
        titlebar %win Files found: %i - Skipped small files: %skip
        .fclose %HANDLE  
      }
    }
  }
}
