
; PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>Pserve &lt;-&gt; PSC Classic IPC</b>
* <p>
* Handles some of the communication between Photoserve and PServeCheck Classic.
*/




/****************************************************************************************
* Tells PSC to reload triggers after triggerupdate or other similar change.
* Call this whenever triggers are added or removed. @param void @return void
*/
alias PS2PSC_ReloadTriggers {
  var %pscsettingsfile = $PS_SettingsDir $+ PSC_Settings.ini"
  .writeini -n %pscsettingsfile PSERVE2PSC TriggerReload 1
}
ON *:SIGNAL:PS2PSC_ReloadTriggers:PS2PSC_ReloadTriggers

ON *:SIGNAL:PS_NeedCheck:{
  var %trigger = $1
  var %pscsettingsfile = $PS_SettingsDir $+ PSC_Settings.ini"
  var %old = $readini(%pscsettingsfile,n,PSERVE2PSC,check)
  .writeini -n %pscsettingsfile PSERVE2PSC check $addtok(%old,%trigger,44)
}




;; Unload old ps9temp script
on *:LOAD: {
  if ($script(ps9temp.mrc)) unload ps9temp.mrc
}

;; Update PSC channels list
on *:START: {
  .timerPSC_ChanList -o 1 3 PS2PSC_UpdateChannelList
}

;; Update PSC channels list
on *:DISCONNECT: {
  .timerPSC_ChanList -o 1 3 PS2PSC_UpdateChannelList
}

;; Update PSC channels list
on me:*:JOIN:#: {
  .timerPSC_ChanList -o 1 3 PS2PSC_UpdateChannelList
}

;; Update PSC channels list
on me:*:PART:#: {
  .timerPSC_ChanList -o 1 3 PS2PSC_UpdateChannelList
}


/****************************************************************************************
* Updates PSC's channels list for all networks. To be able to leech PSC needs to know
* which networks and channels the user is on. Called automatically on relevant network
* events, but also needs be called manually when pserve's channel list is modified.
* @param void @return void
*/
alias PS2PSC_UpdateChannelList {
  var %pscsettingsfile = $PS_SettingsDir $+ PSC_Settings.ini"
  .remini %pscsettingsfile Channels

  set %ps_pscclassic_channel_list_index 0
  scid -a PS2PSC_UpdateNetworkChannelList 
  unset %ps_pscclassic_channel_list_index
}
ON *:SIGNAL:PS2PSC_UpdateChannelList:PS2PSC_UpdateChannelList

/****************************************************************************************
* Updates channel list of current network. This alias is executed in all network
* contexes via /scid -a. @param void @return void
*/
alias -l PS2PSC_UpdateNetworkChannelList {
  var %channels = $PS_Channel(list)
  var %i = $numtok(%channels, 59)
  while (%i > 0) {
    if ($me !ison $gettok(%channels, %i, 59)) {
      %channels = $deltok(%channels, %i, 59)
    }
    dec %i
  }

  if (($status == connected) && (%channels != $null)) {
    var %pscsettingsfile = $PS_SettingsDir $+ PSC_Settings.ini"
    .writeini -n %pscsettingsfile Channels Network $+ %ps_pscclassic_channel_list_index $PS_Network $+ ; $+ %channels
    inc %ps_pscclassic_channel_list_index
  }
}


ON *:SIGNAL:PSINVITELEECH:{
  var %trigger = $1 , %chan = $2 , %pri = $3
  if ( $PS_ProcList(calling,pservecheck.exe,return) ) {
    echo -set Invitation to leech %trigger received in %chan

    var %ini = $PS_SettingsDir $+ PSC_Ghost\PSC_Ghost_ $+ $left(%trigger,1) $+ .ini"
    var %ini2 = $PS_SettingsDir $+ PSC_Settings.ini"
    var %autoup = $readini(%ini,n,%trigger,AutoUpdate)
    if (%autoup == $null) var %autoup = $readini(%ini2,n,Default,AutoUpdate)
    if (%autoup) {
      var %ini = $PSL_FetchConstant(ControlFile)
      var %status = $readini(%ini,n,%trigger,status)
      if (%status == $null) {
        writeini -n %ini %trigger CHANNEL %chan
        writeini -n %ini %trigger STATUS REQUEUE
        echo -ste %chan Invitation to leech %trigger has been accepted by $nopath($script)
      }
      else echo -set Already in Controlfile with status $qt(%status)
    }
    else echo -set No Autoupdate set in Config of PSPVerify for %trigger
  }
}
