
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>PhotoServe disaster recovery</b>
* 
* <h2>PSCG - PhotoServe Crash Guard</h2>
* <p>
* Script and helper program to restart mirc after a crash. The script kicks off a helper
* program crashguard.exe, which finds out its parent process (=mirc) and waits for it to
* exit. When the exe detects mirc exit, it checks to see if a special signal file is
* present in photoserve tempdir. During a normal shutdown mirc will delete that file,
* crash will leave the file intact. If the file is present, crashguard.exe knows that
* mirc crashed and immediately restarts it.
* <p>
* Global variables (settings):<ul>
* <li>%ps.crashguard.enabled  -- Is crash detection and recovery enabled
* <li>%ps.crashguard.crashed  -- Left $true on crash, allows us to know when we are recovering from a crash
* <li>%ps.crashguard.debug    -- Set $true to enable debug window for crashguard.exe (req. mirc restart to take effect) 
* </ul>
* Transient globals:<ul>
* <li>%ps_crashguard_signalfile -- Double quoted filename of the signal file
* </ul>
*
*
* <h2>PSBU - Photoserve BackUp</h2>
* <p>
* Creates backups of user's scripts, triggers, settings and stats. Backups are retained for two
* weeks (used to be one week but it seemed a bit short). Also possible to create backup of user's
* triggers and scripts, and send it to a remote user (would be good to limit it to ops..)
* <p>
* Global variables (settings):<ul>
* <li>%ps.backup.path -- Backup path explicitly set by user
* </ul>
* Transient globals:<ul>
* <li>%ps_trigupdate_disable -- If this is set pserve will not send remote backups
* </ul>
*/

/****************************************************************************************
* Do startup actions if last mirc exit was a crash, and enable protection if requested.
*/
on *:start:{
  if (%ps.crashguard.crashed) {
    PSCG_RecoverFromCrash    
  }

  if (%ps.crashguard.enabled) {
    PSCG_EnableCrashGuard
  }
}


/****************************************************************************************
* Removes the signal file, causing crashguard to consider this a clean close.
* Also %ps.crashguard.crashed 
*/ 
on *:exit:{
  if ((%ps_crashguard_signalfile != $null) && ($isfile(%ps_crashguard_signalfile))) {
    remove %ps_crashguard_signalfile
  }
  unset %ps.crashguard.crashed
}



/****************************************************************************************
* Enables crashguard protection. If the guard exe not yet running this function will
* create the signal file and start the exe. If the exe is running (see explanation of
* PSCG_DisableCrashGuard) we simply recreate the signal file.
* @param void @return void
*/
alias PSCG_EnableCrashGuard {
  set %ps.crashguard.enabled $true
  set %ps.crashguard.crashed $true

  ; if %ps_crashguard_signalfile is set, the guard program is already running
  if (%ps_crashguard_signalfile != $null) {
    write %ps_crashguard_signalfile Crashguard
  }
  else {
    set %ps_crashguard_signalfile $PS_TmpDir $+ crashguard_ $+ $ticks $+ "
    write %ps_crashguard_signalfile Crashguard
    var %command = $PS_ProgramDir $+ crashguard.exe" %ps_crashguard_signalfile " $+ $mircexe $+ "
    if (%ps.crashguard.debug) {
      run %command
    }
    else {
      var %res = $dll($PS_ProgramDir $+ pserve.dll",RunWithoutWaiting,%command)
    }
  }
  saveini

  ; Disable error dialogs so mirc will exit immediately upon crash, without waiting user acknowledgement
  dll $PS_ProgramDir $+ pserve.dll" DisableCrashDialog
}


/****************************************************************************************
* Disables crashguard protection. This cannot kill the guard exe if it is already
* running, so instead we just remove the signal file, which causes the guard to
* consider any mirc-exit as clean. We can also later re-enable the protection by
* simply recreating the signal file, without starting another exe instance.
* The guard exe will not run the next time mirc is started.
* @param void @return void
*/
alias PSCG_DisableCrashGuard {
  set %ps.crashguard.enabled $false
  set %ps.crashguard.crashed $false
  if ((%ps_crashguard_signalfile != $null) && ($isfile(%ps_crashguard_signalfile))) {
    remove %ps_crashguard_signalfile
  }
  saveini
  dll $PS_ProgramDir $+ pserve.dll" EnableCrashDialog
}



/****************************************************************************************
* Runs after a crash. @param void @return void
*/
alias -l PSCG_RecoverFromCrash {
  window -ak0 @CrashGuard 100 100 570 69 Tahoma 12
  aline $color(background) @CrashGuard .
  aline @CrashGuard  $asctime $+ : 04Abnormal mirc termination detected (OS or Mirc crashed)
  aline $color(background) @CrashGuard .
}














/****************************************************************************************
* Create a triggers & script backup archive and send it to op specified in %nick. The
* archive is sent via DCC server if ip:port is given, regular DCC if not. 
* @optparam ip ip:port @return void
*/
alias PSBU_SendOpBackup {
  var %nick = $1, %ipport = $2

  if (%ps_trigupdate_disable != $null) {
    .timer 1 300 unset %ps_trigupdate_disable
    .notice %nick 10PhotoServe Trigger Update in progress. Try again in 5 minutes.
  }
  elseif ($PS_ChannelOP(list, check, %nick) == Yes) {
    .notice %nick 10Generating PhotoServe Backup! Send will start in a few seconds.
    $PSBU_SendBackup(%nick, %ipport)
  }
  else {
    .notice %nick 10This trigger sends .trg files to an @op as an offline backup. This trigger is for @ops ONLY.
  }
}



/****************************************************************************************
* Create a triggers & script backup archive and send it to %nick. This alias does the
* actual backup and sending. @optparam ip ip:port @return void
*/
alias -l PSBU_SendBackup {
  var %nick = $1, %ipport = $2
  if (%ipport == $null) %ipport = na:na

  var %rar = $PS_ProgramDir $+ rar.exe"
  var %dll = $PS_ProgramDir $+ pserve.dll"

  var %timestamp = $PSBU_CreateBackup
  var %backupdir = $PSBU_GetBackupDir $+ Backup_ $+ %timestamp $+ \

  var %rarsuffix = %ps.trigger $+ _ $+ %timestamp $+ .rar
  var %dest    = $PS_TmpDir $+ Backup_ $+ $PS_NickRemove($me) $+ _ $+ %rarsuffix
  var %source1 = %backupdir $+ Backup_Triggers_ $+ %rarsuffix
  var %source2 = %backupdir $+ Backup_Script_ $+ %rarsuffix
  var %source3 = %backupdir $+ Backup_Stats_ $+ %rarsuffix
  var %result  = $dll(%dll, Run, %rar a -ep -m5 $qt(%dest) $qt(%source1) $qt(%source2) $qt(%source3))

  notice %nick 10Sending PhotoServe Backup!07 $nopath(%file)
  noop $PSE_SimpleSendFile(%nick, %ipport, $noqt(%dest))
}



/****************************************************************************************
* Creates backup archives to whatever is user's current backup dir. The backup process
* is synchronous.
* @param void @return ctime the backup timestamp (used by PSBU_SendBackup)
*/
alias PSBU_CreateBackup {
  PSBU_PurgeOldBackups

  var %timestamp = $ctime
  var %backupdir = $PSBU_GetBackupDir $+ Backup_ $+ %timestamp $+ \
  var %rarsuffix = %ps.trigger $+ _ $+ %timestamp $+ .rar
  var %rar = $PS_ProgramDir $+ rar.exe"
  var %dll = $PS_ProgramDir $+ pserve.dll"

  mkdir $qt(%backupdir)
  echo $ps_n -st --> Creating PhotoServe backup in $+ $ps_kh $noqt(%backupdir)

  var %dest   = %backupdir $+ Backup_Triggers_ $+ %rarsuffix
  ;  echo Cleaned TriggersDir >  $findfile($PS_TriggersDir,*,0,1,if ((*.trg !iswm $1-) && (*.txt !iswm $1-)) remove $qt( $1- ))  files checked
  var %result = $dll(%dll, Run, %rar a -ep -m5 $qt(%dest) $qt($PS_TriggersDir $+ *.trg) $qt($PS_TriggersDir $+ *.txt))

  var %dest   = %backupdir $+ Backup_Script_ $+ %rarsuffix
  var %result = $dll(%dll, Run, %rar a -ep -m5 $qt(%dest) $qt($PS_ScriptDir $+ *.mrc))

  var %dest   = %backupdir $+ Backup_Stats_ $+ %rarsuffix
  var %result = $dll(%dll, Run, %rar a -ep -m5 $qt(%dest) $qt($PS_StatsDir $+ *.hsh))

  PSBU_BackupGlobalVars
  var %dest   = %backupdir $+ Backup_Settings_ $+ %rarsuffix
  var %result = $dll(%dll, Run, %rar a -ep -m5 $qt(%dest) $qt($PS_SettingsDir $+ *.*))
  .remove $PS_SettingsDir $+ \RestoreGlobals.mrc"

  echo $ps_n -st --> PhotoServe Triggers and Settings backup 3Done
  echo -s -
  return %timestamp
}



/****************************************************************************************
* Creates a .mrc file that when loaded will restore all %ps* global variables. The
* file is placed in pserve settings dir and included in the Settings backup.
* @param void @return void
*/
alias -l PSBU_BackupGlobalVars {
  var %message = This script is designed to restore lost PhotoServe settings. Running this script will overwrite all global photoserve variables. Are you sure you want to continue?

  var %backupfile = $PS_SettingsDir $+ \RestoreGlobals.mrc"
  write -c %backupfile on *:load: $chr(123)
  write %backupfile if ($input( %message , yaui, Restore PS Settings?)) $chr(123)
  var %i = $var(%ps.*,0)
  while (%i > 0) {
    var %varname = $var(%ps.*, %i)
    var %varvalue = $var(%ps.*, %i).value
    write %backupfile set %varname %varvalue
    dec %i
  }
  write %backupfile $chr(125)
  write %backupfile echo -s 03 Photoserve settings restored.
  write %backupfile unload -rs RestoreGlobals.mrc
  write %backupfile $chr(125)
}



/****************************************************************************************
* Return the backup basedir, ie the place where the timestamped backup-subdirs are
* created. This alias will also create the backuppath if it does not exist.
* @param void @return backuppath
*/
alias -l PSBU_GetBackupDir {
  var %backuppath = $null

  ; Use set backup path if one exists
  if (%ps.backup.path != $null) {
    %backuppath = $noqt(%ps.backup.path)
  }

  ; No set backup path, find last HDD and place backup there
  else {
    var %i = 0
    while (%i < $disk(0)) {
      inc %i
      if ($disk(%i).type != fixed)   continue
      if ($disk(%i).free < 20000000) continue
      if ($disk(%i).path = A:\)      continue
      if ($disk(%i).path = B:\)      continue

      ; Prefer disks other than the one your mircdir is in, but if user only has one disk that is ok too
      if (($disk(%i).path !isin $mircdir) || (%backuppath == $null)) {
        %backuppath = $disk(%i).path $+ PhotoServe\
      }
    }
  }

  ; Create backup path if the dir didn't exist
  if (!$isdir(%backuppath)) {
    PS_MakePath %backuppath
  }

  return " $+ $noqt(%backuppath)
}



/****************************************************************************************
* Purge backups older than two weeks. @param void @return void
*/
alias -l PSBU_PurgeOldBackups {
  echo -s -
  echo $ps_n -st --> Purging backup files and folders older than two weeks

  var %removeolder = $calc($ctime - 604800*2)
  var %backuppath = $PSBU_GetBackupDir
  var %removedfiles = 0
  var %removeddirs = 0

  var %i = $finddir(%backuppath, Backup_*, 0, 1)
  while (%i > 0) {
    var %backup = $finddir(%backuppath, Backup_*, %i, 1)
    var %createtime = $gettok(%backup, -1, $asc(_))
    if (%createtime < %removeolder) {
      echo $ps_n -st --> Removing backup folder $ps_kh $+ %backup
      inc %removedfiles $findfile(%backup, Backup_*_*_*.rar, 0, 1, .remove $qt($1-))
      inc %removeddirs
      .rmdir $qt(%backup)
      :error
      reseterror
    }
    dec %i
  }

  echo $ps_n -st --> Backup purge done, removed $ps_kh $+ %removedfiles backup RARs in $ps_kh $+ %removeddirs folders
  echo -s -
}
