
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>PSS - PhotoServe Samples Module.</b>
* <p>
* Dialog and code for getting and viewing samples. Downloads target user's havelist
* and populates MDX-TreeView with the contents. Selecting a file causes that file to
* be downloaded and viewed.
* <p>
* Samples are limited to max of 40 per trig to avoid abuse. The number of downloaded
* samples is stored in the .trg files, or if the user doesn't have a trg file for the
* trig in question, in \Settings\PserveSamples.ini. The counter resets 3 months after
* the last sample download, allowing users to "refresh their memory", and ops to test
* send ability.
* <p>
* Fullscreen image viewer can display .bmp .png and .jpg images in a borderless
* fullscreen window. It supports zooming, panning, and directory navigation.
*/






/****************************************************************************************
* Starts the samples process. Opens the samples dialog, requests havelist if
* needed, calls PSS_WaitForHavelist. @return void 
*/
Alias PSS_GetSamples {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSS_GetSamples * $1-
  var %nick = $1, %leechtrig = $2, %trig = $3

  var %dname = PS_SampleDlg
  if ($dialog(%dname) != $null) dialog -c %dname
  dialog -m $+ $PSA_GetDesktopFlag(dialogs) %dname %dname
  dialog -t %dname View samples of %trig from %nick (Got $PSTC_GetSampleCount(%trig) so far, max allowed is 40)
  did -ra %dname 301 Waiting for havelist to arrive...

  set %ps_samples_havelist $PS_HaveSavedDir $+ $remove($PS_NickRemove(%leechtrig),!,$,%,|) $+ _HAVE_ $+ $remove(%trig,$,%,|) $+ .txt"
  if ($isfile(%ps_samples_havelist)) {
    .remove %ps_samples_havelist
  }
  ctcp %nick %leechtrig %trig HAVE
  PSS_WaitForHavelist %havefile
}



/****************************************************************************************
* Waits for havelist to arrive, then starts the TreeView building process.
* Name of the expected havelist is taken from <code>%ps_samples_havelist</code>
* @param void @return void
*/
Alias -l PSS_WaitForHavelist {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSS_WaitForHavelist * $1-

  var %dname = PS_SampleDlg
  if (!$dialog(%dname)) return

  if (!$isfile(%ps_samples_havelist)) {
    .timerSampleHave 1 1 PSS_WaitForHavelist
  }
  else {
    .fopen PSSAMPLE %ps_samples_havelist
    .fseek -l PSSAMPLE 4
    if ($ferr) {
      if ($fopen(PSSAMPLE)) .fclose PSSAMPLE      
      did -ra %dname 301 Unable to read havelist %ps_samples_havelist, aborting
    }
    elseif ($feof) {
      if ($fopen(PSSAMPLE)) .fclose PSSAMPLE      
      did -ra %dname 301 Havelist is empty, aborting
    }
    else {
      did -ra %dname 301 Adding files..
      set %PS_samples_prevdir -
      $PSS_PopulateTreeView(PSSAMPLE)
    }
  }
}



/****************************************************************************************
* Reads open filehandle Fhandle and adds files and dirs to the treeview. 
* To avoid noticeable freezes the process is divided to "75msec work + 
* 25msec sleep" fragments. @return void
*/
Alias -l PSS_PopulateTreeView {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSS_PopulateTreeView * $1-
  var %fhandle = $1

  var %dname = PS_SampleDlg
  var %sleeptime = $calc(($ticks + 75) % 2^32)
  if (!$dialog(%dname)) { if ($fopen(%fhandle)) .fclose %fhandle | return }

  while ((!$fopen(%fhandle).eof) && (!$fopen(%fhandle).err)) {
    var %line = $fread(%fhandle)
    var %pathlev = 1, %pathelem, %path = \
    while (%pathlev <= $numtok(%line,92)) {
      set -n %pathelem $gettok(%line,%pathlev,92)
      %path = %path $+ %pathelem $+ \

      if (%path $+ * !iswm %PS_samples_prevdir) { 
        did -i %dname 101 1 cb root $str(last $+ $chr(32),%pathlev)
        if (%pathlev < $numtok(%line,92))             did -a %dname 101 1 1 0 0 0 %pathelem
        elseif ($regex(%line,/(jpg|jpeg|bmp|png)$/i)) did -a %dname 101 2 2 0 0 0 %pathelem
        else                                          did -a %dname 101 +c 2 2 0 0 0 %pathelem
      }
      inc %pathlev
    }
    set %PS_samples_prevdir $nofile(%line)
    if ($ticks > %sleeptime) {
      .timer -m 1 25 PSS_PopulateTreeView %fhandle
      return
    }
  }
  did -ra %dname 301 All files added. Select any .jpg, .png or .bmp file to view it
  .fclose %fhandle
  .remove %ps_samples_havelist
  unset %PS_samples_prevdir %ps_samples_havelist
}



/****************************************************************************************
* Makes sure there are no outstanding requests/downloads and then asks for the
* file. Requests expire if the file transfer doesn't start within 2 minutes.
* Is also responsible for limiting samples to 40 pics/trig. @return void
*/
Alias -l PSS_RequestSample {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSS_RequestSample * $1-
  var %nick = $1, %trig = $2, %fullpath = $3-

  var %dname = PS_SampleDlg
  if (%PS_sample_nick != $null) {
    did -ra %dname 301 Already requested %ps_sample_file $+ , give at least 2 minutes for the file to arrive
    return
  }

  set -u120 %PS_sample_nick %nick
  set -u120 %PS_sample_trig %trig
  set -u120 %PS_sample_dir  $right($replace($nofile(%fullpath),\,_,$chr(32),_),-1)
  set -u120 %PS_sample_file $replace($nopath(%fullpath),$chr(32),_)

  if ($isfile(%ps.downp $+ PSSamples\ $+ %ps_sample_trig $+ \ $+ %PS_sample_dir $+ %PS_sample_file)) {
    did -ra %dname 301 Already downloaded %fullpath $+ , showing existing file
    did -g %dname 201 " $+ %ps.downp $+ PSSamples\ $+ %PS_sample_trig $+ \ $+ %PS_sample_dir $+ %PS_sample_file $+ "
    unset %PS_sample_*
  }
  elseif ($PSTC_GetSampleCount(%trig) >= 40) {
    did -ra %dname 301 You have already downloaded 40 samples for %trig (maximum allowed)
    unset %PS_sample_*
  }
  else {
    did -ra %dname 301 Requesting %fullpath $+ ...
    ctcp %nick !pssample %trig %fullpath
    .enable #PSS_filercvd
    .timerSamplePoll 30 4 /PSS_PollGets
  }
}



/****************************************************************************************
* Displays incomming sample pic. Poll ongoing gets to see if requested sample pic is
* being transfered and show what has be received so far (incomplete pic). Filename
* and Nick of the expected DCC are retrieved from global temp variables set by
* RequestSample. @param void @return void
*/
Alias -l PSS_PollGets {
  if (%PS_debug_alias != $null) echo $ps_h -st * PSS_PollGets * $1-

  var %dname = PS_SampleDlg
  if (%PS_sample_nick == $null) {
    .timerSamplePoll off
    .disable #PSS_filercvd
    if ($dialog(%dname)) did -ra %dname 301 File transfer failed.
  }

  var %i = $get(0)
  while (%i > 0) {
    if (($get(%i) == %PS_sample_nick) && ($get(%i).file == %PS_sample_file)) {
      ; Refresh vars so they dont get unset during long transfers
      set -u20 %PS_sample_nick %PS_sample_nick
      set -u20 %PS_sample_trig %PS_sample_trig
      set -u20 %PS_sample_dir %PS_sample_dir
      set -u20 %PS_sample_file %PS_sample_file
      .timerSamplePoll 1 4 /PSS_PollGets
      if ($dialog(%dname)) {
        var %percent = $int($calc($get(%i).rcvd / $get(%i).size * 100))
        did -ra %dname 301 Downloading %PS_sample_file .... %percent $+ % of $int($calc($get(%i).size /1024)) KB
        if ($get(%i).rcvd > 5120) {
          did -g %dname 201 " $+ $get(%i).path $+ $get(%i).file $+ "
          if ($window(@PSS_FS_Display)) {
            if (%ps_samples_fullscreen_file == " $+ $get(%i).path $+ $get(%i).file $+ ") {
              drawpic -c 
              PSS_RepaintFullscreen 
            }
            else {
              PSS_DisplayFullscreen " $+ $get(%i).path $+ $get(%i).file $+ "
            }
          }
        }
      }
      return
    }
    dec %i
  }
  return
  :error
  reseterror
}



#PSS_filercvd off
/****************************************************************************************
* Moves received sample pic to sampledir and displays it.
* Code is enabled only when samples are requested.
*/
on *:FILERCVD:*.*: {
  var %dname = PS_SampleDlg

  if (($nick == %PS_sample_nick) && ($nopath($filename) == %PS_sample_file)) {
    if (!$isdir(%ps.downp $+ PSSamples)) .mkdir " $+ %ps.downp $+ PSSamples $+ "
    if (!$isdir(%ps.downp $+ PSSamples\ $+ %PS_sample_trig)) .mkdir " $+ %ps.downp $+ PSSamples\ $+ %PS_sample_trig $+ "
    var %destination = " $+ %ps.downp $+ PSSamples\ $+ %PS_sample_trig $+ \ $+ %PS_sample_dir $+ %PS_sample_file $+ "
    echo $ps_n -st --> Moving received sample $+ $ps_kh $nopath($filename) to $+ $ps_kh %destination
    if ($isfile(%destination)) .remove %destination
    .rename " $+ $filename $+ " %destination

    $PSTC_IncSampleCount(%PS_sample_trig)
    var %gets = $PSTC_GetSampleCount(%PS_sample_trig)
    if ($dialog(%dname)) {
      did -ra %dname 301 File received and saved as %destination -- Ready for next file
      did -g %dname 201 %destination
      dialog -t %dname View samples of %PS_sample_trig from %PS_sample_nick (Got %gets so far, max allowed is 40)
    }
    if ($window(@PSS_FS_Display)) {
      $PSS_DisplayFullscreen(%destination)
    }
    $PSDV_LogSampleDownload($nick, %PS_sample_trig, $nopath(%destination))

    unset %PS_sample_*
  }
  if (%PS_sample_nick == $null) {
    .disable #PSS_filercvd
    .timerSamplePoll off
  }
}


/****************************************************************************************
* Unset %ps_sample_* and do other cleanups when sample-get fails. Needed so that
* new request can be made immediately instead of waiting two minuyes.
*/
on *:GETFAIL:*.*: {
  var %dname = PS_SampleDlg

  if (($nick == %PS_sample_nick) && ($nopath($filename) == %PS_sample_file)) {
    unset %PS_sample_*
    .disable #PSS_filercvd
    .timerSamplePoll off
    if ($dialog(%dname)) did -ra %dname 301 File transfer failed -- Ready for next file
  }
}
#PSS_filercvd end



/****************************************************************************************
* Resizable dialog with MDX-TreeView
*/
dialog PS_SampleDlg {
  size -1 -1 780 545
  button "MDX-positioner",1,1 1 1 1,hide
  box "File List", 100, 5 5 240 515
  list 101, 10 20 228 502, extsel
  button "MDX-divider", 102, 238 15 5 500
  box "Image Viewer (click image for fullscreen mode)", 200, 243 5 530 515
  icon 201,246 14 524 504
  text "Statusbar" 301,5 525 1270 14
}



/****************************************************************************************
* Init for the MDX stuff
*/
on *:DIALOG:PS_SampleDlg:init:0: {
  var %PS = $PS_Mdx(SetMircVersion,$version)
  var %PS = $PS_Mdx(MarkDialog,$dname)
  var %PS = $PS_Mdx(SetControlMDX,1 positioner size minbox maxbox > [ $PS_ddll ] )
  var %PS = $PS_Mdx(SetControlMDX,101 treeview haslines hasbuttons > [ $PS_vdll ] )
  var %PS = $PS_Mdx(SetControlMDX,102 divider vertical > [ $PS_gdll ] )
  did -i $dname 101 1 iconsize normal small
  did -i $dname 101 1 seticon normal $shortfn($+($PS_IconDir,folder.ico"))
  did -i $dname 101 1 seticon normal $shortfn($+($PS_IconDir,file.ico"))
  did -a $dname 101 +be 1 1 0 0 0 \
}



/****************************************************************************************
* Initiate a sample request when user clicks on a picture's filename. 
*/
on *:DIALOG:PS_SampleDlg:sclick:101: {
  did -i $dname $did 1 page select
  tokenize 32 $gettok($did($dname, $did, 1), 4-, 32)

  var %i = 2, %treepath = root $1, %branch, %branchtext, %filepath

  while (%i <= $0) {
    %branch = $eval($ $+ %i,2)
    %treepath = %treepath %branch 
    did -i $dname $did 1 cb %treepath up
    set -n %branchtext $gettok($did($dname,$did,%branch),7-,32)
    %filepath = %filepath $+ \ $+ %branchtext 
    inc %i
  }
  if ($regex(%filepath,/(jpg|jpeg|bmp|png)$/i)) {
    $PSS_RequestSample($gettok($dialog($dname).title,6,32),$gettok($dialog($dname).title,4,32),%filepath)
  }
}



/****************************************************************************************
* User resized dialog or moved divider
*/
on *:DIALOG:PS_SampleDlg:sclick:1,102: {
  if (($gettok($did($did),1,32) != size) && ($gettok($did($did),1,32) != move)) return

  var %h = $dialog($dname).ch
  var %w = $dialog($dname).cw
  var %divl = $gettok($did(102),3,32)
  var %divr = $gettok($did(102),4,32)
  if (%divl !isnum) return

  PS_Mdx MoveControl $dname 100 * * $calc(%divr - 3) $calc(%h - 30)
  PS_Mdx MoveControl $dname 101 * * $calc(%divl - 10) $calc(%h - 50)
  PS_Mdx MoveControl $dname 102 * * * $calc(%h - 45)
  PS_Mdx MoveControl $dname 200 $calc(%divr) * $calc(%w - %divr - 5) $calc(%h - 30)
  PS_Mdx MoveControl $dname 201 $calc(%divr + 3) * $calc(%w - %divr - 11) $calc(%h - 41)
  PS_Mdx MoveControl $dname 301 * $calc(%h - 18) * *
}


/****************************************************************************************
* Cleanup in case there is some error and the havelist is left open.
*/
on *:DIALOG:PS_SampleDlg:close:0: {
  .timerSampleHave off
  if ($fopen(PSSAMPLE)) .fclose PSSAMPLE
}


/****************************************************************************************
* Display current picture in a fullscreen window when user clicks on the picture
*/
on *:DIALOG:PS_SampleDlg:sclick:201: {
  if ($version >= 6.3) {
    var %file = $did($dname,$did).text
  }
  else {
    var %file = $right($did($dname,$did).text, -2)
  }
  if ($isfile(%file)) $PSS_DisplayFullscreen(%file)
}
















/****************************************************************************************
* Display File in a borderless fullscreen window. Large images are scaled to fit window.
* @param file full filename of the picture to be displayed
* @return void
*/
alias PSS_DisplayFullscreen {
  var %file = $1-
  var %wname = @PSS_FS_Display

  window -adoxpB +d %wname

  drawrect -fr %wname $rgb(0,0,0) 0 0 0 $window(%wname).w $window(%wname).h
  drawpic -c

  set %ps_samples_fullscreen_file " $+ $remove(%file,") $+ "
  set %ps_samples_fullscreen_pic_w $pic(%file).width
  set %ps_samples_fullscreen_pic_h $pic(%file).height
  PSS_ZoomFullscreen init
  PSS_RepaintFullscreen
}


/****************************************************************************************
* Zoom image (both axis) by Zoomfactor amount. Don't use too steep zoom range, zoom-in
* should be sqrt(2) or less, zoom-out 1/sqrt(2) or more. Remember to call repaint
* PSS_RepaintFullscreen to make the change visible. <p>
* The zoom has two "snap" values. 1.0 (or 100%) shows the image without any scaling,
* and fill zoom which makes the image fill the entire screen.
* @param zoomfactor Number to change the scale, 'Fill' to fill screen, 'Init' the first time
* @return void
*/
alias -l PSS_ZoomFullscreen {
  var %zoomfactor = $1

  var %fillscale = %ps_samples_fullscreen_fillscale, %file = %ps_samples_fullscreen_file
  var %currscale = %ps_samples_fullscreen_currscale, %wname = @PSS_FS_Display
  var %pic_w = %ps_samples_fullscreen_pic_w,         %win_w = $window(%wname).w
  var %pic_h = %ps_samples_fullscreen_pic_h,         %win_h = $window(%wname).h
  var %newscale = $calc(%currscale * %zoomfactor)

  if (%zoomfactor == init) {
    var %fillscale_w = $calc(%win_w / %pic_w)
    var %fillscale_h = $calc(%win_h / %pic_h)
    set %ps_samples_fullscreen_currscale $min(%fillscale_w, %fillscale_h, 1)
    set %ps_samples_fullscreen_fillscale $min(%fillscale_w, %fillscale_h)
  }
  elseif (%zoomfactor == fill) {
    set %ps_samples_fullscreen_currscale %fillscale
  }
  ; Zoom in, pic is smaller than screen
  elseif ((%fillscale > 1) && (%zoomfactor > 1)) {
    if ((%currscale < 1) && (%newscale > 1)) { 
      set %ps_samples_fullscreen_currscale 1
    }
    elseif ((%currscale < %fillscale) && (%newscale > %fillscale)) { 
      set %ps_samples_fullscreen_currscale %fillscale
    }
    else {
      set %ps_samples_fullscreen_currscale %newscale
    }
  }
  ; Zoom in, pic is bigger than screen
  elseif ((%fillscale < 1) && (%zoomfactor > 1)) {
    if ((%currscale < %fillscale) && (%newscale > %fillscale)) { 
      set %ps_samples_fullscreen_currscale %fillscale
    }
    elseif ((%currscale < 1) && (%newscale > 1)) { 
      set %ps_samples_fullscreen_currscale 1
    }
    else {
      set %ps_samples_fullscreen_currscale %newscale
    }
  }
  ; Zoom out, pic is smaller than screen
  elseif ((%fillscale > 1) && (%zoomfactor < 1)) {
    if ((%currscale > 1) && (%newscale < 1)) { 
      set %ps_samples_fullscreen_currscale 1
    }
    elseif ((%currscale > %fillscale) && (%newscale < %fillscale)) { 
      set %ps_samples_fullscreen_currscale %fillscale
    }
    else {
      set %ps_samples_fullscreen_currscale %newscale
    }
  }
  ; Zoom out, pic is bigger than screen
  elseif ((%fillscale < 1) && (%zoomfactor < 1)) {
    if ((%currscale > %fillscale) && (%newscale < %fillscale)) { 
      set %ps_samples_fullscreen_currscale %fillscale
    }
    elseif ((%currscale > 1) && (%newscale < 1)) { 
      set %ps_samples_fullscreen_currscale 1
    }
    else {
      set %ps_samples_fullscreen_currscale %newscale
    }
  }

  ; Zoomout changes the proper bounds of the input rectangle, calling
  ; PSS_PanFullscreen with (0,0) params refreshes the rectangle
  $PSS_PanFullscreen(0,0)
}



/****************************************************************************************
* Move zoomed-in input rectangle by x pixles horizontally and/or vertically. Positive
* values move right and down, negative values move left and up. These changes are
* meaningful only when the image has been zoomed in so that the entire image does not
* fit inside the window. Moving unzoomed image simply does nothing.
* @param horizontal left-right displacement in pixels
* @param vertical up-down displacement in pixels
* @return void
*/
alias -l PSS_PanFullscreen {
  var %horizontal = $1, %vertical = $2

  var %scale = %ps_samples_fullscreen_currscale, %wname = @PSS_FS_Display
  var %pic_w = %ps_samples_fullscreen_pic_w,     %win_w = $window(%wname).w
  var %pic_h = %ps_samples_fullscreen_pic_h,     %win_h = $window(%wname).h

  ; These vars define the top left corner of the visible part of the image
  ; Usually it is top = 0 and left = 0, combined with scale that allows the
  ; whole pic to be displayd. But zoom in once or twice and we have to start 
  ; cutting parts of the pic out.
  var %top = %ps_samples_fullscreen_picarea_top
  var %left = %ps_samples_fullscreen_picarea_left

  %left = $calc(%left + %horizontal)
  if ($calc(%scale * (%pic_w - %left)) < %win_w) %left = $calc(%pic_w - (%win_w / %scale))
  if (%left < 0) %left = 0

  %top = $calc(%top + %vertical)
  if ($calc(%scale * (%pic_h - %top)) < %win_h) %top = $calc(%pic_h - (%win_h / %scale))
  if (%top < 0) %top = 0

  set %ps_samples_fullscreen_picarea_top %top
  set %ps_samples_fullscreen_picarea_left %left
}



/****************************************************************************************
* Make the picture visible / reload it, show info if required. @param void @return void
*/
alias -l PSS_RepaintFullscreen {
  var %wname = @PSS_FS_Display
  if ($window(%wname) == $null) return

  var %scale = %ps_samples_fullscreen_currscale

  var %in_x = $int(%ps_samples_fullscreen_picarea_left)
  var %in_y = $int(%ps_samples_fullscreen_picarea_top)
  var %in_w = $int($min($calc($window(%wname).w / %scale), %ps_samples_fullscreen_pic_w))
  var %in_h = $int($min($calc($window(%wname).h / %scale), %ps_samples_fullscreen_pic_h))

  var %out_w = $int($calc(%ps_samples_fullscreen_pic_w * %ps_samples_fullscreen_currscale))
  var %out_h = $int($calc(%ps_samples_fullscreen_pic_h * %ps_samples_fullscreen_currscale))
  if (%out_w > $window(%wname).w) %out_w = $window(%wname).w
  if (%out_h > $window(%wname).h) %out_h = $window(%wname).h
  var %out_x = $int($calc(($window(%wname).w - %out_w) / 2))
  var %out_y = $int($calc(($window(%wname).h - %out_h) / 2))
  if (%out_x < 0) %out_x = 0
  if (%out_y < 0) %out_y = 0

  drawrect -fr %wname $rgb(0,0,0) 0 0 0 $window(%wname).w $window(%wname).h
  drawpic -smc %wname %out_x %out_y %out_w %out_h %in_x %in_y %in_w %in_h %ps_samples_fullscreen_file

  ; This help instruction is displayed the first time user invokes fullscreen mode. Then never eagain.
  if (%ps.samples.fullscreen.showinfo == $null) {
    drawtext -rb %wname $rgb(16,222,16) $rgb(0,0,0) Tahoma 12 5 01 Press H for help
    set %ps.samples.fullscreen.showinfo 0
  }  
  elseif (%ps.samples.fullscreen.showinfo == 1) {
    drawtext -rb %wname $rgb(16,222,16) $rgb(0,0,0) Tahoma 12 5 01 $remove(%ps_samples_fullscreen_file,") ( $+ $round($calc(%ps_samples_fullscreen_currscale * 100),0) % $+ )
  }
  elseif (%ps.samples.fullscreen.showinfo == 2) {
    if ($window(@PSS_FS_Filelist) == $null) {
      window -lhs @PSS_FS_Filelist
      var %total = $findfile($nofile(%ps_samples_fullscreen_file), *.jpg, 0, 0, @PSS_FS_Filelist)
      %total = %total + $findfile($nofile(%ps_samples_fullscreen_file), *.png, 0, 0, @PSS_FS_Filelist)
      %total = %total + $findfile($nofile(%ps_samples_fullscreen_file), *.bmp, 0, 0, @PSS_FS_Filelist)
    }
    else {
      var %total = $line(@PSS_FS_Filelist,0)
    }
    var %showing = $fline(@PSS_FS_Filelist, $remove(%ps_samples_fullscreen_file,"), 1)
    window -c @PSS_FS_Filelist

    var %name = $remove(%ps_samples_fullscreen_file,") ( $+ %showing / %total $+ )
    drawrect -fr %wname $rgb(0,0,0) 0 0 0 $calc($width(%name,Tahoma,12) + 10) 70
    drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 01 %name
    drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 18 Created: $asctime($file(%ps_samples_fullscreen_file).ctime,yyyy-mm-dd HH:nn)
    drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 35 Size: %ps_samples_fullscreen_pic_w $+ x $+ %ps_samples_fullscreen_pic_h ( $+  $bytes($pic(%ps_samples_fullscreen_file).size).suf $+ )
    drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 52 Scale: $round($calc(%ps_samples_fullscreen_currscale * 100),0) %
  }
}



; TODO: Really needed? Oh and make a feature requeqst on mirc.co.uk
/****************************************************************************************
* Return the smallest value. @return Num smallest value
*/
alias -l min {
  var %i = 2, %smallest = $1
  while (%i <= $0) {
    if ($eval($ $+ %i,2) < %smallest) %smallest = $eval($ $+ %i,2)
    inc %i
  }
  return %smallest
}



/****************************************************************************************
* Display the supported keyboard commands.
* @param void @return void
*/
alias -l PSS_ShowFullscreenHelp {
  var %wname = @PSS_FS_Display
  drawrect -fr %wname $rgb(0,0,0) 0 0 0 300 145
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 01 Key            | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 01 Action
  drawline -r %wname $rgb(16,222,16) 1 5 15 240 15
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 015 H             | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 015 Show this help screen
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 6 029 I             | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 029 Toggle image information
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 043 +             | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 043 Zoom in 
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 6 057 -             | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 057 Zoom out
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 071 F             | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 071 Zoom to fill screen
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 085 Space / Enter | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 085 Next file in dir
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 099 Backspace     | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 099 Previous file in dir
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 113 Arrows        | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 113 Pan (move) zoomed image
  ;drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 127 Mouse drag    | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 127 Pan (move) image
  drawtext -r %wname $rgb(16,222,16) Tahoma 12 5 127 Other         | drawtext -r %wname $rgb(16,222,16) Tahoma 12 100 127 Exit fullscreen viewer
}



/****************************************************************************************
* Free resources and exit the fullscreen viewer. 
* @param void @return void
*/
alias -l PSS_ExitFullscreen {
  var %dname = PS_Dlg_AX
  drawpic -c
  unset %ps_samples_fullscreen_*   
  window -c @PSS_FS_Filelist
  if ($window(@PSS_FS_Display) != $null) window -c @PSS_FS_Display

  ; This is so the wrong place but oh well.. Updates to viewer are deferred while fullscreen mode is active, 
  ; when fullscreen mode is closed the viewer must be refreshed to show the latest picture
  if (($dialog(%dname) != $null) && ($dialog(%dname).tab == 2200)) .timer 1 0 PSDV_DisplaySelected %dname
}



/****************************************************************************************
* Alt-F4 does not trigger the keydown event but resources still need to be freed.
* (And closing a window with /window -c does not trigger any on-close events, so
* PSS_ExitFullscreen will always get called exactly once)
*/
ON *:CLOSE:@PSS_FS_Display: {
  PSS_ExitFullscreen  
}



/****************************************************************************************
* Mouse actions for fullscreen images.
*/
menu @PSS_FS_Display {
  sclick: { 
    PSS_ExitFullscreen
  }
  ; These commented lines contain mouse panning support. I like close on click better.
  ;sclick: { 
  ;set %ps_samples_fullscreen_mclick_x $mouse.x
  ;set %ps_samples_fullscreen_mclick_y $mouse.y
  ;}
  ;mouse: {
  ;if (($mouse.key & 1) && (%ps_samples_fullscreen_mclick_x != $null)) {
  ;$PSS_PanFullscreen($calc((%ps_samples_fullscreen_mclick_x - $mouse.x) / %ps_samples_fullscreen_currscale), $calc((%ps_samples_fullscreen_mclick_y - $mouse.y) / %ps_samples_fullscreen_currscale))
  ;set %ps_samples_fullscreen_mclick_x $mouse.x
  ;set %ps_samples_fullscreen_mclick_y $mouse.y
  ;if ($timer(PSSFS_MOUSEREPAINT) == $null) .timerPSSFS_MOUSEREPAINT -m 1 400 PSS_RepaintFullscreen
  ;}
  ;}
  Help: {
    PSS_ShowFullscreenHelp
  }
  Exit: {
    PSS_ExitFullscreen
  }
}



/****************************************************************************************
* Keyboard actions for fullscreen images. + and - zoom in and out, arrows pan the image,
* space/backspace/enter move to next/prev file.
* All other keys close the window.
*/
on *:KEYDOWN:@PSS_FS_Display:*: {
  var %wname = @PSS_FS_Display

  ; Panning step is 2/5ths of visible screen.
  var %pan_w = $calc($window(%wname).w * 2 / 5 / %ps_samples_fullscreen_currscale)
  var %pan_h = $calc($window(%wname).h * 2 / 5 / %ps_samples_fullscreen_currscale)

  if ($keychar == H) {
    PSS_ShowFullscreenHelp
  }
  elseif ($keychar == I) {
    ; Tri-mode info: 0 = No info, 1 = Filename and zoom scale, 2 = Full info
    set %ps.samples.fullscreen.showinfo $calc((%ps.samples.fullscreen.showinfo + 1) % 3)
    PSS_RepaintFullscreen
  }

  ; Zoom factor is cubic root of 2, meaning scale is doubled in three zoom steps.
  elseif ($keychar == +) {
    $PSS_ZoomFullscreen(1.25992105)
    PSS_RepaintFullscreen
  }
  elseif ($keychar == -) {
    $PSS_ZoomFullscreen(0.793700526)
    PSS_RepaintFullscreen
  }
  elseif ($keychar == +) {
    $PSS_ZoomFullscreen(1.25)
    PSS_RepaintFullscreen
  }
  elseif ($keychar == -) {
    $PSS_ZoomFullscreen(0.8)
    PSS_RepaintFullscreen
  }
  elseif ($keychar == f) {
    $PSS_ZoomFullscreen(fill)
    PSS_RepaintFullscreen
  }

  ; Left (37), Up (38), Right (39), Down (40) arrows
  elseif ($keyval == 37) {
    $PSS_PanFullscreen(- $+ %pan_w,0)
    PSS_RepaintFullscreen
  }
  elseif ($keyval == 38) {
    $PSS_PanFullscreen(0,- $+ %pan_h)
    PSS_RepaintFullscreen
  }
  elseif ($keyval == 39) {
    $PSS_PanFullscreen(%pan_w,0)
    PSS_RepaintFullscreen
  }
  elseif ($keyval == 40) {
    $PSS_PanFullscreen(0,%pan_h)
    PSS_RepaintFullscreen
  }

  ; Enter (13) and space (32) move forward in dir, backspace (8) moves back
  elseif (($keyval == 32) || ($keyval == 8) || ($keyval == 13)) {
    window -c @PSS_FS_Filelist
    window -lhs @PSS_FS_Filelist
    var %total = $findfile($nofile(%ps_samples_fullscreen_file), *.jpg, 0, 0, @PSS_FS_Filelist)
    %total = %total + $findfile($nofile(%ps_samples_fullscreen_file), *.png, 0, 0, @PSS_FS_Filelist)
    %total = %total + $findfile($nofile(%ps_samples_fullscreen_file), *.bmp, 0, 0, @PSS_FS_Filelist)
    var %showing = $fline(@PSS_FS_Filelist, $remove(%ps_samples_fullscreen_file,"), 1)
    if ($keyval == 8) PSS_DisplayFullscreen $line(@PSS_FS_Filelist, $iif($calc(%showing - 1) == 0, %total, $calc(%showing - 1)))
    else              PSS_DisplayFullscreen $line(@PSS_FS_Filelist, $calc((%showing % %total) + 1))
  }
  else {
    PSS_ExitFullscreen
  }
}
