
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

/***
* This Part handles the requests:  !PSaddChan  !PSFilterUp  !PSSendsPorts !PSTempPurge !ServInfo !PSStatus
*
*                           !whereis !psget/psserv/usertrig 
*  recognizes :  reply for  *        *     {trigger} {crc} {size} \{path\file.ext}
*                           *        *     {trigger} {crc} \{path\file.ext}
*
*                           *              {trigger}
*                                    *     {trigger} HAVE|REP|CSV
*                           *        *     {pattern, including * or . or \}
* SIGNALS: PSE_SENDSTART {nick} {ip}  
*          PSE_SENDEND {nick} {sendok} {server-send}
*/

;; on connect clean the queue - else we send old unexpected stuff to people no longer wanting the stuff
on *:CONNECT:{
  PSE_ClearQueue
  ; if (!%ps.noindirectsends)  set -z %ps.noindirectsends 500
  ; restart the timer every now and then...
  CheckAndRunCheckTimer
  noop $findfile($+($PSE_TmpDir(pserve_server_onconnect),$PS_Network,\),*,0,0,if ($PSE_GetPartName($1-).isPart) remove $+(",$1-,"))
  RunKeepAliveTimer 
}

alias  RunKeepAliveTimer .timer_keep_Server_alive_ [ $+ [ $ps_network ] ] 0 120  raw -q PING :KEEPALIVE
ON ^*:PONG:if ($2 == KEEPALIVE) haltdef

alias -l CheckAndRunCheckTimer {
  if (!$timer(CheckSendings)) .timerCheckSendings -o 0 5 scid -at1 PSE_CheckForActionsNeeded
}

alias -l GeneralInit {
  unset -s %ps.dccserver
  if (%pse.fairqueue == $null) set %pse.fairqueue $true
  if (%ps.trigger) {
    var %new = $remove(%ps.trigger,|,?,*,^,~,_#,$chr(32))
    ;; convert overlong triggers to something short (and hopefully unique)
    if ($len(%new) > 20) %new = $left(%new,15)
    ;;
    if (%new !== %ps.trigger) {
      echo -sat Your PS Trigger has been changed from07 %ps.trigger to06 %new Triggers should only have letters and digits and they should be as short as possible
      set -s %ps.trigger %new
    }
  }
  if ($len(%ps.trigger) < 3) {
    set %ps.trigger ! $+ $me ______
    PS_ShortenTrigger
  }
  CheckAndRunCheckTimer
}

alias PS_ShortenTrigger {
  if ($len(%ps.trigger) > 5) {
    var %new = ! $+ $right($base($crc($right(%ps.trigger,-1),0),16,36),4)
    set -s %ps.trigger %new
    echo -t Your Trigger has been changed to %ps.trigger (this can be changed in PSCC)
  }
}

ON *:SIGNAL:PSUPDATEDONE:{
  GeneralInit
}
ON *:START: {
  GeneralInit
  echo >cleaned old parts: $findfile($PSE_TmpDir(pserve_server_onstart),*,0,2,if ($PSE_GetPartName($1-).isPart) remove $+(",$1-,"))
  echo >cleaned old PAR2 files: $findfile($PS_Par2Dir(pserve_server_onstart),*,0,2,remove $+(",$1-,"))

}


on ^*:TEXT:!*:#: PreCheckRequest $chan $nick $1-
on ^*:TEXT:!*:?: PreCheckRequest priv $nick $1-
on ^*:NOTICE:!*:?: PreCheckRequest priv $nick $1-
ctcp ^*:!*:*: PreCheckRequest $iif($chan,$chan,ctcp) $nick $1-
;; special accept !PSCOMM <network> <nick> <command>
on ^*:CHAT:!PSCOMM *:{
  haltdef
  var %scon = $PS_ResolveNetworkNametoSCon($2)
  if (%scon == 0) return 
  scon %scon PreCheckRequest priv $3 $4-
}
on *:SIGNAL:PSCOMMAND:PreCheckRequest priv $1-
on ^*:TEXT:@PSCOMMAND*:#: if ($me == $3) PreCheckRequest $chan $nick $4-

alias PSE_debuglog {
  if (%psedebug !== on) return
  var %file = $PSE_TmpDir $+ PSE_DEBUGLOG_ $+ $ctime $+ .txt"
  if (!$fopen(PSEDEB)) .fopen -no PSEDEB %file
  var %log = $asctime * $PS_network * $1-
  ; echo -set logged: %log
  .fwrite -n PSEDEB %log
}

;; Handler for pre-decision if ip:port is included or not @return void
alias -l PreCheckRequest {
  if ($chr(58) isin $4) CheckRequest $1-3 $PSE_UnMaskIP($4) $5-
  else CheckRequest $1-3 na:na $4-
}

alias PSE_UnmaskIp {
  var %data = $1
  if ($left(%data,1) == $chr(58)) {
    var %data = $right($left(%data,-1),-1)
    var %data = $+($longip($base($right(%data,-4),36,10)),:,$base($left(%data,4),16,10))
  }
  return %data
}

alias PSE_MaskIp {
  var %ip = $1 , %port = $2
  var %d = $base(%port,10,16,4) $+ $base($longip(%ip) ,10,36)
  return $+($chr(58),%d,$chr(58))
}

alias PSE_TmpDir {
  if (%ps.TmpDir) return $ifmatch
  else   return $PS_TmpDir
}

;; check what function to call for the request @return void
alias -l CheckRequest {
  var %mode = $1 , %nick = $2 , %req = $3 , %ip = $4 , %opt = $5-
  PSE_debuglog CheckRequest * mode: %mode ! nick %nick ! req %req ! ip %ip ! opt %opt
  if (\..\ isin $replace(%opt, /, \)) {
    echo $ps_n -sat --> 4WARNING %nick is trying to hack into your system by downloading files outside of your triggers path notify an @ * %opt
    return
  }

  unset %proc

  var %ischannel = $iif($left(%mode,1) == $chr(35),$true,$false)

  ;; by default the echo to status window is faked 
  var %fakereply = $true

  if ((%ischannel) && (%ip != na:na)) .signal PSIPRESOLVE %nick %ip %mode


  ;; (channel) commands that work without any permission required

  if (%req == !PSKILL) var %proc = kill
  elseif (%req == !PSaddChan)  var %proc = addchan 
  ;; check a ":" separated list of commands that dont need to be access checked. 
  elseif ($istok(!PSCallMe,%req,58)) var %proc = skipcheck


  ;;; request in a channel
  if ((%ischannel) && (!%proc)) {
    %fakereply = $false
    ;;; CHECK IF this channel is a PS Channel and IF this channel needs a voice+ to be used.
    if (!$PSC_isPSonInChannel(%mode)) return
    if ($PS_Channel(%mode,voice) !== OFF) {
      if (%nick isreg %mode) return
    } 
  }

  ; skip channel check for certain commands. (in case %proc is already set)
  if (!%proc) {
    var %channelcheck = $PS_Channel(list,check,%nick)
    if (%channelcheck !== Yes) {
      sendReplyNumber %nick 1
      return
    }
  }

  ;; commands that need permission (which is already checked here)

  ;; react to these triggers 
  var %tokens_get = !PSPar2 !PSGet !PSServ !PSSample $iif(%ps.nooldleech,$null,$PSC_GetMyTrigger)

  if (%req == !wHEREiS) {
    ;;; return if whereis not in a channel
    if (!%ischannel) return 
    ;; whereis handles the haltdef on its own
    %fakereply = $false 
    var %proc = whereis
    ;    echo -set detected dataport for %nick at %ip
    var %res = $PS_DataPortDBAccess(%nick,dataport,$iif((%ip != na:na),%ip,.))

  }
  elseif (%req == !PSRequestCSV) {
    var %proc = requestcsv
  }
  elseif ($istok(%tokens_get,%req,32)) {
    var %proc = get
    ;    echo -set detected dccport for %nick at %ip
    noop $PS_DataPortDBAccess(%nick,dccport,$iif((%ip != na:na),%ip,.))

  }
  elseif (%req == !ServInfo) {
    if (%ischannel && $PSF_GetChanSetting(DisableServInfo,%mode) && (%nick !isop %mode)  ) {
      PS_Tunnel .notice %nick The command6 %req is disabled for non-ops by7 a channel setting of %mode $+ 
    }
    else   PS_Tunnel .notice %nick @Photoserve_!ServInfo, $+ $PS_ServInfo($iif(%ischannel,%mode))
  }
  elseif (%req = !PSStatus) {
    haltdef
    PS_StatusInfo %nick %req %opt
    return
  }
  ;  elseif (%req == !PSFilterUp) $PS_FilterUp(CheckRequest,%opt)
  elseif (%req == !PSlastDL) $PS_LastDL(%nick,%opt)
  elseif (%req == !PSlastSEND) $PS_LastSEND(%nick,%opt)
  elseif (%req == !PSCount) $PS_Count(%nick,%opt)
  elseif (%req == !PSFserve) noop $PSE_MiscFserve(%nick,%opt)
  elseif (%req == !PSCredit) {
    %fakereply = $false
    haltdef
    $PSCR_Remote(%nick,%opt)
  }
  elseif (%req == !PSCheckFriend) {
    %fakereply = $false
    haltdef
    PS_Tunnel .notice %nick you are $iif($IsNickAFriend(%nick),a,no) friend of mine
  }
  elseif (%req == !PSCallMe) if (%ip != na:na) noop $PS_OpenDPConnection(%nick,%ip)
  elseif ((%req == !PSRedirect) && (%ischannel)) {
    PS_Redirect %mode %nick %opt
    haltdef
  }


  if (%fakereply) {
    if (%ip !== na:na) echo $color(ctcp) -se $timestamp [ $+ %nick %req %ip $+ ] %opt
    else echo $color(ctcp) -se $timestamp [ $+ %nick %req $+ ] %opt
    haltdef
  }
  ; echo 9 -st  Detected a possible request: Checking -> mode: %mode , %nick ( %ip ) , > Request: %req -> options %opt >> HIDE: %fakereply

  if (%proc == whereis)  ProcessWhereisRequest %mode %nick %req %ip %opt
  elseif (%proc == get)  ProcessGetrequest %mode %nick %req %ip %opt
  elseif (%proc == kill) PSE_KillAll %nick
  elseif (%proc == addchan) PS_NewChanAdd %nick %opt
  elseif (%proc == requestcsv) PSE_RequestMultipleCSV %nick %ip %opt

}

alias PSE_RequestMultipleCSV {
  var %nick = $1 , %ip = $2 , %pattern = $3
  if ((%pattern) && ($len(%pattern) > 4) ) {
    if ($SearchTriggerPatternToWindow(%pattern)) {
      ; this window has been opened
      var %window = $ifmatch
      var %count = $line(%window,0)
      var %file = $+($PSE_TmpDir(PS_Compress),$PS_NickRemove($me),_MultiCSVRequestPackage_,%count,_,$remove(%pattern,*,?),s__,$ctime,_,.rar,")
      var %file = $CompressWindowAsList(%window,%file)
      ; now window can be closed
      window -c %window
      ;; send when rar is done PSE_Check_Proc will turn the timer off!
      .timer 0 10 PSE_Check_Proc_Running rar.exe PSE_SimpleSendFile %nick %ip %file
      PS_Tunnel notice %nick Creating a rar $nopath(%file) with %count files inside - sending starts when its ready.
    }
    else PS_Tunnel notice %nick Too much (>200) or nothing (==0) has been found for7 %pattern
  }
  else echo -set %pattern from request of %nick was too short (<=4) -> ignored.
}

alias SearchTriggerPatternToWindow {
  var %pattern = $1
  var %hash = PsTriggerMap
  var %found = $hfind(%hash,%pattern,0,w)
  ;  echo > found %found triggers (NOT CSV)
  if ((%found > 0) && (%found <= 500)) {
    if ($window(@compress)) window -c @compress
    window -h @compress
    var %i = 0
    var %foundcsv = 0
    while (%i < %found) {
      inc %i
      var %trigger = $hfind(%hash,%pattern,%i,w)
      if ($PSTC_GetRawVar(%trigger,csv)) {
        aline @compress $ifmatch
        inc %foundcsv
        if (%foundcsv > 200) break
      }
    }
    echo -set --> found %foundcsv csvs while looking for %pattern 
    if (%foundcsv > 0)  return @compress
    window -c @compress
  }
  else echo -set ---> Nothing OR too much found for %pattern - change it
  return


}


;; compresses a list of files in a window to a file . @optparam file Can be omited then something is taken as default

alias CompressWindowAsList {
  var %window = $1 , %file = $2
  if (%file) %file = $+(",$remove(%file,"),")
  else var %file = $+($PSE_TmpDir(PS_Compress),CompressedList_,$ctime,_,$PS_NickRemove($me),.rar,")
  var %temp = $+($PSE_TmpDir(PS_Compress),CompressWindowList,$ctime,_,$rand(100000,9999999),.txt,")

  savebuf %window %temp

  var %program = $PS_ProgramDir $+ rar.exe"
  var %result = $dll($PS_ProgramDir $+ pserve.dll",RunWithoutWaiting,%program a -ep -m5 -rr %file $+("@,$remove(%temp,"),"))
  return %file
}






/**************
* processes and decides what kind of reply is needed. builds the reply of all possible whereis replys. @return void
; 00  $1 = @Whereis  (added later)
; 00  $2 = Reply Format (added later)  ( 1= Trigger Only ,  2 = Trigger with (searched) File , 3= File only )
; 01  $3 = Trigger
; 02  $4 = CDrom
; 03  $5 = Count Files
; 04  $6 = Count Csv
; 05  $7 = Status
; 06  $8 = File Name
; 07  $9 = File Search String
; 08  $10 = File Crc
; 09  $11 = File Size
; 10  $12 = RHC
; 11  $13 = Csv Crc
; 12  $14 = Csv File
; 13  $15 = Send Current
; 14  $16 = Send User
; 15  $17 = Send Total
; 16  $18 = Queue Current
; 17  $19 = Queue User
; 18  $20 = Queue Total
; 19  $21 = Gets
; 20  $22 = Leech
; 21  $23 = Speed
; 22  $24 = Average Cps
; 23  $25 = !trig
; 24  $26 = $chan
; 25  $27 = Requesters Nick
; 26  $28 = last leeched file ctime of trigger

; 27  $29 = (boolean) user get to bypass the queue
; 28  $30 = the credit factor of the remote user
*/
alias -l ProcessWhereisRequest {
  var %chan = $1 , %nick = $2 , %kind = $3 , %ip = $4 , %trigger = $5 , %opt = $6-
  ; echo -st >> ProcessWhereis * $1-
  ; check for type of whereis
  var %wild = $false
  if ((* isin %trigger) || (\ isin %trigger) || (. isin %trigger) )  %wild = $true 
  ; case sensitive check for the whereis
  var %autoreq = $iif(%kind === !wHEREiS,$true,$false)
  var %type = 0

  var %reply = $BuildWhereIsReply(0)
  %reply = $BuildWhereIsReply(24,%reply,$iif((%autoreq),$lower(%chan),$upper(%chan)))
  %reply = $BuildWhereIsReply(25,%reply,%nick)
  %reply = $BuildWhereIsReply(23,%reply,$PSC_GetMyTrigger)
  %reply = $BuildWhereIsReply(21,%reply,$PSC_GetSpeed)

  %reply = $AddCTCPDataToWhereIsReply(%reply)
  ; default status
  var %status = $lower($PSC_GetStatus)
  if (!$PSC_GetSendGigLimitOk) %status = oFf

  if (%wild) {
    %reply = $BuildWhereIsReply(22,%reply,$PSST_GetAvgUpSpeed($ps_network, 50) $+ KB)
    var %search = %trigger
    var %max = $iif(%ip == na:na,1,6) 
    var %c = 1
    while (%c <= %max) {
      ;;  echo -st >> Searching for %search (# %c of %max $+ )
      var %file = $PSE_SearchForMiscFile(%search,%c,%opt)
      if (!%file) return
      %reply = $AddSearchFileToWhereIsReply(%file,%search,%reply)
      %type = 3

      ;; for all replies set the status now
      %reply = $BuildWhereIsReply(5,%reply,%status)

      if (%type > 0) var %res = $SendWhereIsReply(%nick,%ip,%type,%reply) 
      inc %c
    }
    return
  }
  else {
    var %status = $PSTC_GetStatus(%trigger)
    if (%status) {

      if (off == $PSC_GetStatus) %status = off
      if (!$PSC_GetSendGigLimitOk) %status = oFf
      ;var %xclusive = $PSC_ExclusiveServe(%trigger)
      ;if ((%xclusive) && (%trigger !== %xclusive)) %status = oFF
      if (!$PSC_isFreeOfExclusiveServe(%trigger)) %status = oFF
      ;check filter
      if ($false == $PSF_TrigIsAllowed(%trigger,%chan)) {
        echo $ps_n -st --> 4WARNING %nick is trying to download a filtered trigger %trigger from channel %chan
        return
      }
      var %count = $PSTC_GetCount(%trigger) , %ldl = $PSTC_GetLastDL(%trigger)
      ; 'BTS' if Trig is being seeded, 'BTL' if leeched, $null if neither
      var %bts = $PSTC_GetBTState(%trigger)  
      if (%bts == btl) %status = OfF
      if (%autoreq) {
        if ((%bts == btl) || (%status == OFF)) var %useless = $true
        if ((!%ldl) && (%count == 0)) var %useless = $true
        if ( (%opt !== CSV) && (%useless) ) return
      }
      %reply = $BuildWhereIsReply(22,%reply,$PSST_GetAvgUpSpeed($ps_network, 50) $+ KB)
      if (%status == on) {
        var %path = $PSTC_GetPath(%trigger)
        if (!$exists(%path)) {
          if ($disk(%path)) PSE_FoundFatalError
          ; returnErrorReplyNumber 4 %trigger
          %status = oFf
        }
      }

      ; credits
      var %weight = $round($PSCR_GetWeight(%Nick),3)
      %reply = $BuildWhereIsReply(28,%reply,%weight)
      var %noq = $iif($PSCR_IsDirectSendAllowed(%Nick),1,0)
      %reply = $BuildWhereIsReply(27,%reply,%noq)

      %type = 1
      var %cd = $PSTC_GetCD(%trigger)
      ; H(avelist) is always available...
      var %ctype = $PSTC_GetCSVType(%trigger)
      var %RHC = $iif($PSTC_GetReport(%trigger).valid,R,$null) $+ $iif(%status !== off,H,$null) $+ $iif($PSTC_GetCSV(%trigger).valid,C,$null) $+ $iif(%ctype !== O,%ctype,$null)
      %reply = $BuildWhereIsReply(10,%reply,%RHC)

      %reply = $BuildWhereIsReply(1,%reply,%trigger)
      %reply = $BuildWhereIsReply(2,%reply,%cd)

      %reply = $BuildWhereIsReply(3,%reply,%count)
      %reply = $BuildWhereIsReply(4,%reply,$PSTC_GetCSVCount(%trigger))
      %reply = $BuildWhereIsReply(26,%reply,$iif($PSTC_GetLastDL(%trigger),$ifmatch,0))

      ; modify status before adding it
      if ((%status == ON) || (%status == off)) {
        if (%cd) %status = $iif(%status == ON,LOADED,NOT LOADED)
      }
      %reply = $BuildWhereIsReply(11,%reply,$PSTC_GetCSVCRC(%trigger))
      %reply = $BuildWhereIsReply(12,%reply,$nopath($PSTC_GetCSV(%trigger)))

      ; if there is a file search added to the trigger 
      if ((%opt) && (%opt !== CSV)) {
        var %parsedtokens = $TransformStringToCrcSizeFile(%opt)
        if (%parsedtokens) {
          %type = 2
          var %file = $gettok(%parsedtokens,3,9)
          var %path = $PSTC_GetPath(%trigger).valid
          ; no reply if looking for a file and path does not exist
          if (!%path) return
          var %len = $len(%path)
          %path = %path $+ $nofile(%file)
          var %pattern = $nopath(%file)
          var %foundfile = $PSE_SearchForFile(%pattern,1,%path,$gettok(%parsedtokens,1,9),$gettok(%parsedtokens,2,9))
          if (%foundfile) {
            %reply = $AddSearchFileToWhereIsReply(%foundfile,$right(%foundfile,$calc($len(%foundfile) - %len + 1)),%reply)
          }
          ; nothing found
          else return 
        }
      }
    }
    ; else not configured

  }

  ;; for all replies set the status now
  %reply = $BuildWhereIsReply(5,%reply,%status)

  if (%type > 0) var %res = $SendWhereIsReply(%nick,%ip,%type,%reply) 

}

/******
*  function to automatically place the content into the right position slot, internaly tabs are used as separators,
*  must be replaced to ":" during the last steps. @return TokenizedList
*/
alias -l BuildWhereisReply {
  var %token = $1 , %old = $2 , %content = $3
  if (%token == 0) return $str($chr(58) $+ $chr(9),28)
  elseif (%content == $null) return %old
  else return $puttok(%old,%content,%token,9)
}
/*****
* adds a single file to a reply, returns the original olddata if the file does not exist
* @param olddata is the list of tokens to be filled
* @return TokenizedList @param dirs a tab separated list of dirs to search in @optparam filecrc only matches if the found file has this crc32
*/
alias -l AddSearchFileToWhereIsReply {
  var %file = $1 , %search = $2 , %olddata = $3
  var %size = $file(%file).size
  if (%size) {
    var %reply = $BuildWhereIsReply(9,%olddata,%size)
    var %reply = $BuildWhereIsReply(8,%reply,$crc(%file))
    var %reply = $BuildWhereIsReply(6,%reply,$nopath(%file))
    var %reply = $BuildWhereIsReply(7,%reply,$upper(%search))
    return %reply
  }
  return %olddata
}
;; adds all necessary CTCP (leech/queue/gets/sends/.. ) data to the whereis reply @return TokenizedList
alias -l AddCTCPDataToWhereIsReply {
  var %original = $1 
  var %reply = $BuildWhereIsReply(13,%original,$PSE_CurrentSends)
  var %reply = $BuildWhereIsReply(16,%reply,$PSE_CurrentQueues)

  var %reply = $BuildWhereIsReply(15,%reply,$PSC_GetMaxSends)
  var %reply = $BuildWhereIsReply(14,%reply,$PSC_GetMaxSendsPerUser)

  var %reply = $BuildWhereIsReply(18,%reply,$PSC_GetMaxQueues)
  var %reply = $BuildWhereIsReply(17,%reply,$PSC_GetMaxQueuesPerUser)

  var %reply = $BuildWhereIsReply(20,%reply,$PSL_Status_Leech( ).count)
  var %reply = $BuildWhereIsReply(19,%reply,$PSL_Status_Gets( ).count)

  return %reply
}

;; @return File The full filepath of the first matching file @optparam crc only matching this crc (hex value) will be returned @optparam size
alias PSE_SearchForMiscFile {
  var %pattern = $1 , %num = $2 , %crc = $3 , %size = $4
  var %dirs = $iif(%PS.miscpath1,%PS.miscpath1) $+ $iif(%PS.miscpath1 && %PS.miscpath2,$chr(9)) $+ %PS.miscpath2
  echo $ps_n -st --> Searching For: $+ $ps_kh %pattern Misc Path: $+ $ps_kh $replace(%dirs,$chr(9),$chr(59))
  return $PSE_SearchForFile(%pattern,%num,%dirs,%crc,%size,$iif(%ps.miscdepth,%ps.miscdepth,0))
}

;; @return File The full filepath of the first matching file @param number this number of file matching the file @optparam crc only matching this crc (hex value) will be returned @optparam size @param dirs tab separated list of dirs
alias PSE_SearchForFile {
  ; echo -st >> PSE_SearchForFile * $1-
  var %pattern = $1 , %number = $2 , %dirs = $3 , %crc = $4 , %size = $5 , %depth = $6

  if (!%depth) %depth = 0

  var %max = $numtok(%dirs,9)
  var %num = 0
  if ((%crc) || (%size)) {
    var %fcount = %number
    %number = 1 
  }
  :loop
  while (%num < %max) {
    inc %num
    var %dir = $gettok(%dirs,%num,9)
    var %maxcrc = 0
    var %wrongsize = 0
    :nextfile
    while ((%maxcrc < 10) && (%wrongsize < 200)) {
      ; echo -st >> Searching %dir for %pattern ( %maxcrc , %wrongsize , %number )
      var %file = $findfile($file($left(%dir,-1)).shortfn,%pattern,$calc(%wrongsize + %maxcrc + %number),%depth)
      ; echo -st >> FoundFile: %file
      if (%file) {
        if ((%size) && (%size > 0)) {
          ; echo -st >> checking for size %size %file
          if (%size !== $file(%file).size) {
            inc %wrongsize
            goto nextfile
          }
        }
        if ((%crc) && (%crc !== 0)) {
          var %itscrc = $crc(%file)
          echo -st >> checking for %crc filecrc %itscrc %file
          if (%crc == %itscrc) return %file
          else {
            inc %maxcrc
            goto nextfile
          }
        }
        else return %file
      }
      else goto loop
    }
  }
}

;; @return tokenizedlist separated by tabs it holds 3 fields, CRC, SIZE, FILE even if those were not specified. $null if no FILE field was found (starting with a \ )
alias -l TransformStringToCrcSizeFile {
  ; echo 11 -st >> TransformStringToCrcSizeFile * $1-
  var %string = $1
  var %crc = 0
  var %size = 0
  var %file = 0
  if ($regex(%string,/([\da-f]+)\s+(\d+)\s+\\(.+)/i)) {
    %crc = $regml(1)
    %size = $regml(2)
    %file = $regml(3)
  }
  elseif ($regex(%string,/([\da-f]+)\s+\\(.+)/i)) {
    %crc = $regml(1)
    %file = $regml(2)
  }
  elseif ($regex(%string,/\\(.+)/i)) {
    %file = $regml(1)
  }
  if (!%file) return
  %crc = $PSE_GoodCRC(%crc)
  ; echo -st >> TransformStringToCrcSizeFile * return 7crc: %crc 11size: %size 5file: %file
  return $+(%crc,$chr(9),%size,$chr(9),%file)
}

;; @return crc recalculated to 8 digits crc. @optparam dec if $true the %crc is assumed as decimal
alias PSE_GoodCRC {
  var %crc = $1 , %dec = $2
  if (%dec) var %deci = %crc
  else var %deci = $base(%crc,16,10)
  return $base(%deci,10,16,8)
}

;; assembles the final parts of the whereis and sends it according to presence of the ip:port @return void
alias -l SendWhereIsReply {
  var %nick = $1 , %ip = $2 , %format = $3 , %data = $4

  ; retransform the format and add the pre-data
  %data = @Whereis $+ $chr(58) $+ %format $+ $chr(58) $+ $replace(%data,$chr(58),$chr(32),$chr(9),$chr(58))

  var %ps_replyblocked = $isServerBlocked
  if ((%ps_replyblocked > 0) && (%ip == na:na)) {
    echo $ps_n -st --> All !whereis replies blocked for %ps_replyblocked more seconds $+ $ps_kh !WhereIs reply to $+ $ps_kh %nick Found: $+ $ps_kh $gettok(%data,3,58) $gettok(%data,8,58) Status: $+ $ps_kh $gettok(%data,7,58)
    return
  }
  echo $ps_n -st --> Sent $+ $ps_kh !WhereIs reply to $+ $ps_kh %nick Found: $+ $ps_kh $gettok(%data,3,58) $gettok(%data,8,58) Status: $+ $ps_kh $gettok(%data,7,58) Ip: $+ $ps_kh %ip
  ; echo -st >> Sending %data
  ;; here is a chance that a user not using ip:port format has an connection made TO OURSELF 
  if ($PS_HasDirectCon(%nick)) $PS_ReplyOverSocket(%nick,%ip,%data)
  elseif (%ip != na:na) .timer 1 $rand(0,2) $!PS_ReplyOverSocket( [ %nick ] , [ %ip ] , [ %data ] )
  else .notice %nick %data
}

alias -l isServerBlocked {
  return [ [ $+(%,PS_ServerReplyIgnore_,$ps_network) ] ]
}

alias -l sendReplyNumber {
  var %nick = $1 , %errornum = $2 , %opt1 = $3 , %opt2 = $4 , %opt3 = $5
  if (%errornum == 1) var %msg = You must be verified (+v) and on a valid channel to receive files.
  elseif (%errornum == 3) var %msg = 10Sorry my sends are full. The file07 %opt1 10is07 %opt2 10in my send queue, please wait. Estimated time to wait: $round(%opt3,0) seconds (= $duration(%opt3) $+ )
  elseif (%errornum == 5) var %msg = The file %opt1 is %opt2 in my send queue, please wait. Estimated time to wait: $round(%opt3,0) seconds (= $duration(%opt3) $+ )
  elseif (%errornum == 6) var %msg = 10Sorry you have reached your download limit. The file07 %opt1 10is07 %opt2 10in my send queue, please wait.
  elseif (%errornum == 9) var %msg = Sorry my queue is full with $PSC_GetMaxQueues file(s)
  elseif (%errornum == 17) var %msg = The file07 %opt1 is now in the PAR2 System Queue and will be processed and sent as soon as possible. TargetName:07 %opt2

  $PSE_HaltErrorReply(%nick,%msg).cont
}


;; transforms a error number to a standard error message and halts. @return void
alias -l HaltErrorReplyNumber {
  var %nick = $1 , %errornum = $2 , %opt1 = $3 , %opt2 = $4 
  if (%errornum == 1) var %msg = You must be verified (+v) and on a valid channel to receive files.
  elseif (%errornum == 2 ) var %msg = 10I have reached my user defined gig limit of07 $PS_FileSize($gettok($PS_DialogGigCurrentCount(HaltErrorReplyNumber,send),2,32),2) 10for today, 3Try again tomorrow10.  Current time07 $asctime(HH:nn)
  elseif (%errornum == 4) var %msg = 10The drive which trigger07 %opt1 10is stored on is 4offline10.
  elseif (%errornum == 5) var %msg = The file %opt1 is %opt2 in my send queue, please wait.
  elseif (%errornum == 7) var %msg = All my $PSC_GetMaxSends Sends are full and I don't offer a Queue, Please try again later...
  elseif (%errornum == 8) var %msg = 10I'm exclusively distributing07 %ps_servonlytrig 10Until07 $asctime($calc(%ps_servonlytime + 86400),ddd mmm dd HH:nn:ss) 10Please try again in07 $asctime($calc($calc(%ps_servonlytime + 86400) - $ctime),HH:nn:ss) 10(hrs:min:sec).
  elseif (%errornum == 9) var %msg = Sorry my queue is full with $PSC_GetMaxQueues file(s)
  elseif (%errornum == 10) var %msg = Sorry you have reached my max user queue of $PSC_GetMaxQueuesPerUser file(s).
  elseif (%errornum == 11) var %msg = $PS_Off_Reason
  elseif (%errornum == 12) var %msg = 10There is no %opt1 set for07 %opt2
  elseif (%errornum == 13) var %msg = Trigger: %opt1 - $nofile(%opt2) $nopath(%opt2) not found
  elseif (%errornum == 14) var %msg = Trigger: %opt1 is OFF or Not Setup - $nofile(%opt2) $nopath(%opt2) not found
  elseif (%errornum == 15) var %msg = The file %opt1 is Already Sending.
  elseif (%errornum == 16) var %msg = Par2 will only work if you supply crc and size in front of the \path\file.ext

  $PSE_HaltErrorReply(%nick,%msg)
}

;; reply a standard error message to a nick. This will halt the script @return void @prop cont does not halt
alias PSE_HaltErrorReply {
  var %nick = $1 , %error = $2-
  PS_Tunnel notice %nick %error
  ;  echo -set -> - $+ %nick $+ - %error
  if ($prop !== cont)  halt
}

;;; called when found a fatal error like missing path and report, whenever a user is needed to fix the problem @return void
alias -l PSE_FoundFatalError {
  if ($window(@PSTriggerError) == $null) PSTC_CheckErrors $me AllChannels $true
  halt
}

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;  some Info Functions for the Outside World

;; the current number of outgoing PS Sends @return Int
alias PSE_CurrentSends {
  return $line($PSE_getWindowName(send),0)
}

alias PSE_GetCurrentSendSpeed {
  var %c = $line($PSE_getWindowName(send),0)
  var %speed = 0
  while (%c) {
    var %info = $PSE_GetSendInfo(%c)
    var %s = $gettok(%info,8,9)
    if (%s isnum) %speed = %speed + %s
    dec %c
  }
  return %speed
}

;; the current number of files in the queue @return Int
alias PSE_CurrentQueues {
  return $line($PSE_getWindowName(queue),0)
}

;; returns the full tab separated list of infos for send "number". Use PSE_CurrentSends to get the max number of Sends @return TokenizedList Nick,ip,port,request string,file,filesize,trigger,cps,realip from dcc,transferedbytes,resumedfrombytes,seconds running,mirc send number
alias PSE_GetSendInfo {
  var %number = $1
  var %line = $line($PSE_getWindowName(send),%number)
  if (!%line) return 
  return $gettok(%line,1-7,9) $+ $chr(9) $+ $IsSending($gettok(%line,5,9),$gettok(%line,2,9),$gettok(%line,1,9)).info
}

;; returns the full tab separated list of infos for send "number".  Use PSE_CurrentQueues to get the max number of Queues @return TokenizedList Nick,ip,port,request string,file,filesize,trigger
alias PSE_GetQueueInfo {
  var %number = $1
  return $line($PSE_getWindowName(queue),%number)
}


;; checks if one or more registered sends are running to a nick name @return Int number of currently running sends (in this network)
alias PSE_IsSendingTo {
  var %nick = $1
  return $CountNickName(send,%nick)
}


;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

;; get the estimated seconds before a transfer is started. @optparam nick returns the waittime for the first queued file of nickname
alias -l GetWaitTime {
  var %file = $1 , %filesize = $2 , %searchnick = $3
  var %pic = $PSE_IsPic(%filesize,%file)
  var %win = @temp
  if ($window(%win)) window -c %win
  window -lh %win
  var %max = $PSE_CurrentSends 
  var %pos = 0
  var %avgcps = 0
  while (%pos < %max) {
    inc %pos
    var %data = $PSE_GetSendInfo(%pos)
    var %size = $gettok(%data,6,9)
    var %tran = $gettok(%data,10,9)
    var %cps = $gettok(%data,8,9)
    if (%cps == 0) %cps = %avgcps / %pos
    var %file = $gettok(%data,5,9)
    %avgcps =  $calc( %avgcps + %cps )
    if (%pic !== $PSE_IsPic(%size,%file)) continue
    var %nick = $gettok(%data,1,9)
    var %remain = $calc((%size - %tran) / %cps)
    var %spos = $SortLineToWindow(%win,$+(%remain,$chr(9),%nick,$chr(9),%file))
  }
  %avgcps = %avgcps / %max
  var %max = $PSE_CurrentQueues
  var %pos = 0
  var %total = 0
  while (%pos < %max) {
    inc %pos
    var %data = $PSE_GetQueueInfo(%pos)
    var %size = $gettok(%data,6,9)
    var %file = $gettok(%data,5,9)
    var %nick = $gettok(%data,1,9)
    %total = %total + $FetchNextTransferStart(%win)
    if ((%searchnick !== $null) && (%nick == %searchnick)) goto end
    var %remain = $calc(%size / %avgcps)
    if (%pic !== $PSE_IsPic(%size,%file)) continue
    var %spos = $SortLineToWindow(%win,$+(%remain,$chr(9),%nick,$chr(9),%file))
  }
  :error
  reseterror
  :end
  window -c %win
  if (%total < 10) {
    return 10
  }
  return %total
}

;; returns the very next transfer start from the temp window and reduces the other values by this time @return Int seconds till next start
alias -l FetchNextTransferStart {
  var %win = $1
  var %max = $line(%win,0)
  if (%max == 0) return 0
  var %val = $gettok($line(%win,1),1,9)
  ;  .fwrite -n WDEB Fetching Next Transfer with %val --> $line(%win,1)
  ;;  echo >> reducing by %val now $line(%win,1)
  dline %win 1
  dec %max
  var %i = 0
  while (%i < %max) {
    inc %i
    var %l = $line(%win,%i)
    var %v = $gettok(%l,1,9) - %val
    ;    .fwrite -n WDEB + + +  Reducing %l to %v at %i 
    rline %win %i $puttok(%l,%v,1,9)
  }
  return %val
}

/**********
* Function to sort a line of tab separated tokens to a (temp) window, using token 1 as sort key. Sorting is done numerical and ascending
* @return Int the postion it was sorted to
*/
alias -l SortLineToWindow {
  var %win = $1 , %line = $2
  var %max = $line(%win,0)
  var %pos = 0
  var %key = $gettok(%line,1,9)
  ;  .fwrite -n WDEB Adding Line to %win -> %line 
  while (%pos < %max) {
    inc %pos
    var %this = $line(%win,%pos)
    if ($gettok(%this,1,9) > %key) {
      ;      .fwrite -n WDEB Added at %pos
      iline %win %pos %line
      return %pos
    }
  }
  ;  .fwrite -n WDEB Added at END after reaching %pos
  aline %win %line
  inc %pos
  return %pos
}


;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

;; handles a get Request, decides how to process the request by calling sub-process aliases @return void @param req request string, !PSGET, !PSSERV, ...
alias -l ProcessGetrequest {
  var %mode = $1 , %nick = $2 , %req = $3 , %ip = $4 , %trigger = $5 , %opt = $6-
  ; echo -st >> ProcessGETRequest * $1-

  if (OFF == $PSC_GetStatus) {
    if (%opt !== csv)  HaltErrorReplyNumber %nick 11
  }
  else {
    var %tempdrive = $left($remove($PSE_TmpDir(ProcessGetrequest),"),2)
    var %freeondrive = $disk(%tempdrive).free
    if (%freeondrive < 5000000) {
      noop $PSC_SetStatus(OFF,My System ran out of free bytes on the temp path %tempdrive - only $bytes(%freeondrive,m).suf bytes left)
      echo 4 -at Sorry - Your TempDir drive ( $+ %tempdrive $+ ) ran out of free space (~5Mb).  PhotoServe has been switched off.  You may restart it once you have cleaned your drive.
      ; this is the last request that is processed... after this we are closed
    }
  }
  ;;; Special triggers 
  if (%trigger = TriggerList) {
    $PSTL_StartList(%nick,%req,%ip,$gettok(%opt,1,32),$gettok(%opt,2-,32))
    halt
  }

  if (%trigger == PhotoServeBackup) {
    var %up = $uptime(server,3)
    if (%up > 600) $PSBU_SendOpBackup(%nick, %ip)
    halt
  } 

  ;;; misc file sends
  var %wild = $false
  if ((* isin %trigger) || (\ isin %trigger) || (. isin %trigger) )  %wild = $true 
  ;; just a single word cannot be a trigger either
  if (!%opt) %wild = $true

  if (%wild) {
    if (%req = !PSPar2) halt
    if (!$PSC_GetSendGigLimitOk) $HaltErrorReplyNumber(%nick,2)
    var %search = %trigger
    ; echo -st >> Searching for %search (for %req )
    var %foundfile = $PSE_SearchForMiscFile(%search,1,%opt)
    if (!%foundfile) halt
    if (PhotoServe_v*.rar iswm $nopath(%foundfile))  {
      $PSE_RegisterAndSend(%nick,%ip,%req,%foundfile,$file(%foundfile),PSUPDATE)
      halt
    }
    $PSE_FileTransferStart(%foundfile,%nick,%req,%ip,%trigger)
    halt
  }
  ;;; regular trigger sends
  if (%opt) {
    if ((%opt == Report) || (%opt == Csv) || (%opt == samp)) {
      noop $ProcessGetSpecialFileRequest(%trigger,%nick,%req,%ip,%opt)
      halt
    }
    var %status = $PSTC_GetStatus(%trigger) 
    var %bts = $PSTC_GetBTState(%trigger)  
    if (%bts == btl) %status = OfF
    if (%status == ON) {
      if (($left(%opt,4) == Have) || ($gettok(%opt,1,32) == crclist)) {
        noop $ProcessGetSpecialFileRequest(%trigger,%nick,%req,%ip,$gettok(%opt,1,32),$gettok(%opt,2-,32))
        halt
      }
      if (!$PSC_GetSendGigLimitOk) $HaltErrorReplyNumber(%nick,2)
      ;var %xclusive = $PSC_ExclusiveServe
      ;if ((%xclusive) && (%trigger !== %xclusive)) $HaltErrorReplyNumber(%nick,8)
      if (!$PSC_isFreeOfExclusiveServe(%trigger))  $HaltErrorReplyNumber(%nick,8)

      var %path = $PSTC_GetPath(%trigger)
      if (!$exists(%path)) {
        if ($disk(%path)) PSE_FoundFatalError
        else HaltErrorReplyNumber 4 %trigger
      }
      var %parsedtokens = $TransformStringToCrcSizeFile(%opt)
      if (!%parsedtokens) return
      ; echo -st Request $1- transformed to7 %parsedtokens
      var %file = $gettok(%parsedtokens,3,9)
      ;; if next line is enabled PSPar2 works ONLY if the size && crc is supplied... no need to use it like that atm.
      ;; if ((%req == !PSPar2) && ((0 == $gettok(%parsedtokens,1,9)) || (0 == $gettok(%parsedtokens,2,9)))) HaltErrorReplyNumber %nick 16

      ;; here is the new part for the split file transfer
      ; try to check if this is a part of something - get the name and replace it
      if ($PSE_GetPartName(%file).getpart) {
        var %part = $ifmatch
        var %partorigsize = $PSE_GetPartName(%file).getsize
        %file = $PSE_GetPartName(%file).getname
        ; echo -set this is a request for part6 %part of file13 %file in dir5 %path
        ; echo -set putting size %partorigsize to search pattern replacing original %parsedtokens
        %parsedtokens = $puttok(%parsedtokens,%partorigsize,2,9)
      }
      ;; here is the new part for the split file transfer

      %path = %path $+ $nofile(%file)
      var %pattern = $nopath(%file)
      var %foundfile = $PSE_SearchForFile(%pattern,1,%path,$gettok(%parsedtokens,1,9),$gettok(%parsedtokens,2,9))
      if (%part) {
        if (%foundfile) {
          ; we have the file, we need to build a part file now
          %foundfile = $CreateFilePartFromFile(%part,%foundfile)
          ; echo -set New file to be sent = %foundfile
        } 
        else {
          ; we need to check HERE (SINCE we have not found the file yet)  -- if the request is a part of file -  if the file is inside PSTEMP
          ; search in
          var %temppath = $PSL_TempPathForTrigger(%trigger).parts $+ $nofile(%file)
          ; %temppath = $file($left(%temppath,-1)).shortfn
          var %pattern = $PSE_GetPartName(%file,%partorigsize,%part)
          var %foundfile = $PSE_SearchForFile(%pattern,1,%temppath)
          ; echo -set searching in temp path6 %temppath for7 %pattern -> returns5 %foundfile
          if (!%foundfile) %file = %pattern
        }
      }
      if (%foundfile) {
        var %star = $ticks
        if (%part) {
          var %msg = $+(@PSPart:,%trigger,:,\,$nofile(%file),:,$nopath(%foundfile),:,%part,:,$crc(%foundfile),:,$calc($ticks - %star))
          .timer 2 2 PS_Tunnel .notice %nick %msg
          PS_Tunnel .direct %nick %msg
        }
        if (%req == !PsPar2) {
          $StartPar2Build(%trigger,%foundfile,$gettok(%parsedtokens,1,9),$gettok(%parsedtokens,2,9),%nick,%ip)
        } 
        elseif ( ($PSE_IsPic(0,%foundfile)) && (%req == !PSSample)) $PSE_RegisterAndSend(%nick,%ip,!PSServ,%foundfile,$file(%foundfile).size,%trigger)
        elseif ((%ip == na:na) && (($isServerBlocked) || (%ps.noindirectsends))) {
          echo -set Ignoring Request from %nick ( %ip ) because set to only send directly to ip. (SPAM Protection)
          PS_Tunnel .direct %nick Sorry %nick $+ , your request ( $+ %req $+ ) for $nopath(%foundfile) had to be discarded. The IRC server is blocking my sends. You have to request the file using !PSSERV <yourip:port>. (this is an auto message, do not reply) If you are using !PSSERV as leech method you can IGNORE THIS MESSAGE!
          return
        }
        else  $PSE_FileTransferStart(%foundfile,%nick,%req,%ip,%trigger)
      }
      else $HaltErrorReplyNumber(%nick,13,%trigger,%file)
    }
    elseif (!$PSTC_IsTrig(%trigger)) halt
    else $HaltErrorReplyNumber(%nick,14,%trigger,%file)
  }
}

;; Checks if a Nick/Ip/File is in the send list and removes it. Increases the Count for sent files. @return String realnickname or $null
alias -l TryUnRegisterSend {
  PSE_debuglog TryUnregisterSend * $1-
  var %searchnick = $1 , %searchip = $2 , %searchfile = $3 , %sendid = $4 , %killed = $5 
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %nick = $gettok(%line,1,9)
    var %ip = $gettok(%line,2,9)
    if ( (%ip == %searchip)  || ((%ip == NA) && (%searchnick == %nick))) {
      var %file = $gettok(%line,5,9)
      if (%file == %searchfile) {
        var %trigger = $gettok(%line,7,9)
        ;var %filesize = $gettok(%line,6,9)
        var %sendbytes = $calc($send(%sendid).sent - $send(%sendid).resume)
        ;if ((%trigger !== $null) && ($PSTC_IsTrig(%trigger))) {
        if (%trigger) {
          PSTC_IncSendCount %trigger %sendbytes
          ;void PSST_RecordSend(nick, trig, method, sendnum, pskilled)
          var %method = $gettok(%line,4,9)
          noop $PSST_RecordSend(%nick,%trigger,%method,%sendid,%killed)
        }
        dline %swin %sendcur
        return %nick
      }
    }
    dec %sendcur
  }
  return $null
}


;; adds a file to the queue @return Int position in the Queue
alias -l PSE_AddToQueue {
  var %nick = $1 , %ip = $2 , %req = $3 , %file = $4 , %size = $5 , %trigger = $6 , %pos = $7
  var %qwin = $PSE_getWindowName(queue)

  var %partsize = $CreateFilePartFromFile().partsize
  if ((%pse.fairqueue) && (%size > %partsize))   %size = %partsize

  var %svalue = $round($calc(%size / $PSCR_GetWeight(%nick)),0)
  var %data = $+(%nick,$chr(9),$gettok(%ip,1,58),$chr(9),$gettok(%ip,2,58),$chr(9),%req,$chr(9),%file,$chr(9),%size,$chr(9),%svalue,$chr(9),%trigger)




  if ((%pos) && (%size <= %partsize)) {
    iline 3 %qwin %pos %data
  }
  else {
    var %pos = $line(%qwin,0)
    while (%pos) {
      var %line = $line(%qwin,%pos)
      var %val = $gettok(%line,7,9)
      ;; if this file has a smaller value than we have we just put the file in this pos
      if ($calc(%val - %svalue) < %svalue) {
        ; echo -st not jumping over %val at %pos because we have %svalue ( $calc(%val - %svalue) )
        inc %pos
        if (%val > %svalue) %data = $puttok(%data,%val,7,9)
        break  
      }
      ;; else we reduce this lines value by our value and replace it
      else {
        rline 4 %qwin %pos $puttok(%line,$calc(%val - %svalue),7,9)
        ;echo -st replaced for %svalue -> %pos -> old %val -> $calc(%val - %svalue)
      }
      dec %pos 
    }
    if (%pos == 0) inc %pos
    iline %qwin %pos %data
    titlebar %qwin last inserted %nick file $nopath(%file) at pos %pos
    ;echo -st inserted at %pos 
  }
  return %pos
}

alias PSE_KillAll {
  var %nick = $1
  var %killed = $PSE_Kill(%nick)
  if (%killed)  PS_Tunnel .notice %nick All sends and queues to you have been Killed for a total of %killed
  else echo -set Received !PSKILL from %nick - absolutly nothing to kill or close, command was harmlessly ignored.
  return %killed
}

;; clears all sends and all queue entries for a user, even stops the sends that were registered. @return Int number of killed/dequeued entries
alias PSE_Kill {
  var %nick = $1
  var %count = $PSE_ClearQueue(%nick)
  var %killed = $PSE_KillSendsForNick(%nick)
  if (%killed) {
    SendQueuedFiles
  }
  return $calc(%count + %killed)
}

;; clear the queue, if no nick clears the whole queue @optparam nick name to clear from queue @return Int number of cleared entries
alias PSE_ClearQueue {
  var %nick = $1
  var %qwin = $PSE_getWindowName(queue)
  var %count = 0
  if (%nick) {
    var %cur = $line(%qwin,0)
    while (%cur > 0) {
      var %line = $line(%qwin,%cur)
      var %thisnick = $gettok(%line,1,9)
      if (%thisnick == %nick) {
        inc %count
        dline %qwin %cur
      }
      dec %cur
    }
  }
  else {
    %count = $line(%qwin,0)
    window -c %qwin
  }
  if ((%count) && (%nick)) echo -set PS SendQueue entry cleared for nick %nick - No of items removed %count
  return %count
}

;; kills all sends to a nick, no matter what the real name in the dccsendwindow is showing. @return Int number of killed sends
alias -l PSE_KillSendsForNick {
  var %searchnick = $1
  var %del = 0
  var %count = 0
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %nick = $gettok(%line,1,9)
    if (%searchnick == %nick) {
      var %file = $gettok(%line,5,9)
      var %ip = $gettok(%line,2,9)
      if ($IsSending(%file,%ip,%nick).kill) {
        .signal PSE_SENDEND %nick $false $true
        inc %del
      }
      ; DONT KILL the line. IsSending().kill takes care of this also.
      ;      kill the line in every case (if send was there or not)
      ;      dline %swin %sendcur
    }
    dec %sendcur
  }
  if ((%del) && (%searchnick)) echo -set PS Sends removed for nick %searchnick - No of items removed %del
  return %del
}




;; checks if a new entry in the queue may be added @return Boolean
alias -l IsNewQueueOk {
  var %file = $1 , %filesize = $2 , %nick = $3 , %trigger = $4

  if ( ($PSL_IsLeeched(%trigger)) || ($PSL_RecentLeeched(%trigger)) ) return $true

  var %qwin = $PSE_getWindowName(queue)
  var %curqueue = $line(%qwin,0)
  var %maxqueue = $PSC_GetMaxQueues
  var %ispic = $PSE_IsPic(%filesize,%file)
  if (%ispic) %maxqueue = $calc(%maxqueue * 2)
  ; queue is full
  if (%maxqueue <= %curqueue) return $false
  ; users queue limit reached
  var %userqueues = $CountNickName(queue,%nick)
  if (%userqueues >= $PSC_GetMaxQueuesPerUser) return $false
  return $true
}


;; small function to set a list of hostmasks to grant "special send" privileges, mainly for testing purpose only.
;; this is and will stay undocumented although it is considered as a harmless feature
alias -l IsNickAFriend {
  var %nick = $1
  if ($address(%nick,5)) {
    var %add = $ifmatch
    if (%ps.friendslist) {
      var %list = $ifmatch
      var %c = $numtok(%list,44)
      while (%c) {
        if ($gettok(%list,%c,44) iswm %add) return $true
        dec %c
      }
    }
  }
  return $false
}


;; checks if a new send is allowed @return Boolean
alias -l IsNewSendOk {
  var %file = $1 , %filesize = $2 , %nick = $3 , %requeststring = $4
  if ($IsNickAFriend(%nick)) return $true
  var %usersends = $CountNickName(send,%nick)
  if (%usersends >= $PSC_GetMaxSendsPerUser) return $false
  var %sendmax = $PSC_GetMaxSends
  ;; removed (  (%requeststring == !PSSERV) || (%requeststring == !PSGET)   ) && 
  if (  (%sendmax > 4) && ($PSCR_IsDirectSendAllowed(%nick))) return $true
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  ; echo -st >> Current status in sends %swin => current %sendcur / %sendmax
  if (%sendcur >= %sendmax) return $false
  ; check for how many sends the user already has
  if (%pse.fairqueue) return $true
  var %ispic = $PSE_IsPic(%filesize,%file)
  if (%ispic) return $true
  var %sendres = $ReservedPicSends
  var %nopicsends = $NonPicSends
  ; echo -st >> Check max %sendmax <= current nopic-sends %nopicsends  + reserved %sendres
  if (%sendmax <= $calc(%nopicsends + %sendres)) return $false
  return $true
}

;; checks how many files can be sent and sends them @return Int how many files have been sent out
alias -l SendQueuedFiles {
  var %swin = $PSE_getWindowName(send)
  var %qwin = $PSE_getWindowName(queue)
  var %queuemax = $line(%qwin,0)
  var %queuepos = 0
  if (%queuemax == 0) return 0

  var %sendsmax = $PSC_GetMaxSends
  var %current = $line(%swin,0)
  var %currentnonpics = $NonPicSends
  var %reserved = $ReservedPicSends
  var %totfree = %sendsmax - %current
  var %nopfree = $calc(%sendsmax - %currentnonpics - %reserved)
  ; echo -st >> nonpics %currentnonpics  >> %nopfree  > totfree %totfree
  var %newfiles = 0
  while (%totfree > 0) {
    inc %queuepos
    if (%queuepos > %queuemax) return %newfiles
    var %line = $line(%qwin,%queuepos)
    var %ispic = $PSE_IsPic($gettok(%line,6,9),$gettok(%line,5,9))
    ;; check if the type (pic or nopic) is allowed at the current time
    if ((!%pse.fairqueue) && (!%ispic) && (%nopfree <= 0)) continue
    ;; need to check that nick has not exeeded the max number of sends per user
    var %nick = $gettok(%line,1,9) 
    var %sendstonick = $CountNickName(send,%nick)
    if (%sendstonick >= $PSC_GetMaxSendsPerUser) continue
    echo -st --> Sending Queue File $+ $ps_kh $gettok(%line,5,9) to $ps_kn %nick $ps_kh ( $+($gettok(%line,2,9),:,$gettok(%line,3,9)) )
    PSE_debuglog Sending Queued File now from line %queuepos -> %line 
    ; RegisterAndSendThisFile...
    $PSE_RegisterAndSend(%nick,$+($gettok(%line,2,9),:,$gettok(%line,3,9)),$gettok(%line,4,9),$gettok(%line,5,9),$gettok(%line,6,9),$gettok(%line,8,9))
    dec %totfree
    inc %newfiles
    if (!%ispic) dec %nopfree
    ; remove this line from the queue
    dline %qwin %queuepos
    dec %queuepos
    dec %queuemax
  }
  return %newfiles
}

;; returns the number of current ongoing non pic sends @return Int
alias -l NonPicSends {
  var %count = 0
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %file = $gettok(%line,5,9)
    var %size = $gettok(%line,6,9)

    if (!$PSE_IsPic(%size,%file)) inc %count
    dec %sendcur
  }
  return %count
}

;; returns the correct name of a window, that is created if not already existing @return String full window name @param type type of window like SEND QUEUE
alias PSE_getWindowName {
  var %type = $1
  var %window = @PSE_ $+ %type
  if ($prop == getallpattern) return %window $+ *
  %window = %window $+ _ $+ $PS_network
  if (!$window(%window)) window -lh -t5,12,15,19,85,90,95 %window Tahoma 9
  return %window
}

;; checks a file if its a small pic (either by size or by name) @return Boolean
alias PSE_IsPic {
  var %size = $1 , %name = $2
  var %ps_fname = $nopath(%name)
  var %ext = $right(%ps_fname,4)
  if (%ext == par2) return $true
  if ( %size > 0 ) {
    if (%size <= 2097152) return $true
    return $false
  }
  var %ext = $right(%ps_fname,3)
  if ((%ext == jpg) || (%ext == txt) || (%ext == gif)) return $true
  return $false
}


; this functions returns the number of reserved send slots for PICTUREs @return Int
alias -l ReservedPicSends {
  var %ps_a = PS_ReservedPicsSends
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %totalsends = $PSC_GetMaxSends
  if (%totalsends < 2) return 0
  ; if ($PS.Version.main > 4.8)
  return $calc(%totalsends - $iif((%totalsends > 13),2,1))
  ; remove after 4.9 is out
  if (%totalsends < 4) return 1
  if (%totalsends < 6) return 2 
  return 3
}


alias PSE_CheckForActionsNeeded if ($FullCheckSending) SendQueuedFiles

;; Checks the List of Sends for no longer existing sends and removes these entries @return Int the number of removed entries
alias -l FullCheckSending {
  if (%ps_senddelay) return 0
  var %del = 0
  var %count = 0
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    PSE_debuglog FullCheckSending * %sendcur - line: %line
    var %file = $gettok(%line,5,9)
    var %ip = $gettok(%line,2,9)
    var %nick = $gettok(%line,1,9)
    if ($IsSending(%file,%ip,%nick)) {
      var %num = $ifmatch
      if ((%pse.fairqueue) && ($PSE_CurrentQueues)) {
        var %sent = $calc($send(%num).sent - $send(%num).resume)
        if (%sent) {
          var %ispic = $PSE_IsPic(%sent)
          ; echo -set -> check %num %file -> %sent -> %ispic
          if (!%ispic) {
            var %ext = $right(%file,4)
            if (%ext != par2)   noop $IsSending(%file,%ip,%nick).kill
          }
        }
      }
    }
    else {
      PSE_debuglog in fullchecksending deleting from %swin %sendcur (because issending %file , %ip , %nick ) was not there
      dline %swin %sendcur
      inc %del
      .signal PSE_SENDEND %nick $false $true
    }
    dec %sendcur
  }
  return %del
}

; Checks if a file, requested from a nick, is already in the window "where" @return Boolean
alias -l IsPresentIn {
  var %where = $1 , %searchfile = $2 , %searchnick = $3 , %searchip = $4
  var %swin = $PSE_getWindowName(%where)
  var %cur = $line(%swin,0)
  while (%cur > 0) {
    var %line = $line(%swin,%cur)
    var %nick = $gettok(%line,1,9)
    if (%nick == %searchnick) {
      var %file = $gettok(%line,5,9)
      if (%searchfile == %file) {
        rline %swin %cur $puttok($puttok(%line,$gettok(%searchip,2,58),3,9),$gettok(%searchip,1,58),2,9)
        return $true
      }
    }
    dec %cur
  }
  return $false
}

; Changes the nickname from old to new in the window "where" @param swin searchwindowname send|queue @return void 
alias -l ChangeNickName {
  var %swin = $1 , %old = $2 , %new = $3
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %nick = $gettok(%line,1,9)
    if (%nick == %old) rline %swin %sendcur $puttok(%line,%new,1,9)
    dec %sendcur
  }
}

;; counts the number of entrys that searchnick has in the list @return Int 
alias -l CountNickName {
  var %where = $1 , %searchnick = $2
  var %swin = $PSE_getWindowName(%where)
  var %sendcur = $line(%swin,0)
  var %count = 0
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %nick = $gettok(%line,1,9)
    if (%nick == %searchnick) inc %count
    dec %sendcur
  }
  return %count
}


;; identifies a send by ip and file only. @return String nickname
alias -l FindRealNickName {
  var %searchfile = $1 , %searchip = $2 
  var %swin = $PSE_getWindowName(send)
  var %sendcur = $line(%swin,0)
  while (%sendcur > 0) {
    var %line = $line(%swin,%sendcur)
    var %ip = $gettok(%line,2,9)
    if (%ip == %searchip) {
      var %file = $gettok(%line,5,9)
      if (%file == %searchfile) {
        var %nick = $gettok(%line,1,9)
        return %nick
      }
    }
    dec %sendcur
  }
  return $null
}

/******
* checks if full file is still beeing sent to user/ip. if ip == NA only the user name is checked. else the name is ignored. only path/filname/ip are compared. 
* @return Boolean 
* @prop kill will also kill this found send
* @prop info returns a tab separated list of cps,realip from dcc,transferedbytes,resumedfrombytes,seconds running,mirc send numer (to be used as in $send(number))
*/
alias -l IsSending {
  var %file = $1 , %ip  = $2 , %nick = $3
  PSE_debuglog IsSending() * i: %ip n: %nick prop $prop f: %file
  var %max = $send(0)
  var %count = 0
  while (%count < %max) {
    inc %count
    PSE_debuglog -checking %count ( $cid ) -> CID: $send(%count).cid IP: $send(%count).ip N: $send(%count) PC: $send(%count).pc SEC: $send(%count).secs  F: $send(%count).file
    if ($send(%count).cid !== $cid) continue
    if ((%ip !== NA) && ($send(%count).ip !== n/a)) {
      if (%ip !== $send(%count).ip) continue
    }
    else {
      if (%nick !== $send(%count)) continue
    }
    if ($+($send(%count).path,$send(%count).file) == %file) {
      if ($prop == info) {
        return $+($send(%count).cps,$chr(9),$send(%count).ip,$chr(9),$send(%count).sent,$chr(9),$send(%count).resume,$chr(9),$send(%count).secs,$chr(9),%count)
      } 
      elseif ($prop == kill) {
        PSE_debuglog killing send %count  * to %addr  nick : %nick 
        ;; incomplete but registered end of transfer - this will also remove the line from sends window

        var %ip = $send(%count).ip , %file =  $send(%count).path $+ $send(%count).file , %status = $send(%count).status

        noop $OnSentFile(%count,$false,%file,%nick,%addr,$true)

        if ((%ip !== n/a) && (%status !== active)) .timer -m 0 100 WatchAndKillSend %ip %file
        else close -s $+ %count 


      }
      PSE_debuglog -returning TRUE ( %count ) 
      return %count
    }
  }
  PSE_debuglog -returning FALSE
  return $false
}


alias -l watchandkillsend {
  var %ip = $1 , %filepath = $2-
  var %max = $send(0)
  var %found = $false
  ;echo -set checking for ip: %ip and file %filepath --going trough %max sends
  while (%max) {
    ;    echo -set compare6 %filepath to4 $send(%max).path $+ $send(%max).file
    if ($send(%max).ip = %ip) {
      if ($send(%max).path $+ $send(%max).file == %filepath) {
        %found = $true
        var %status = $send(%max).status
        ; echo -set found still open send %max that has to be killed - checking $send(%max).file - %status
        if (%status !== waiting) {
          echo -set Watched Send ready. Will kill send %Max now .. %status 
          close -s $+ %max
        }
      }
    }
    dec %max
  }
  if (!%found) .timer $+ $ctimer off
}


;; processes a request for a special file that belongs to a collection, like csv, havelist, report. @return void @optparam sendfile used when what == readytosend
alias -l ProcessGetSpecialFileRequest {
  var %trigger = $1 , %nick = $2 , %req = $3 , %ip = $4 , %what = $5 , %sendfile = $6
  if ((%ip == na:na) &&  (($isServerBlocked) || (%ps.noindirectsends))) {
    echo -set Ignoring Request from %nick ( %ip ) because set to only send directly to ip. (SPAM Protection)
    return
  }
  if (%what == csv) var %file = $PSTC_GetCSV(%trigger).valid
  elseif (%what == report) var %file = $PSTC_GetReport(%trigger).valid
  elseif (%what == samp) {
    var %file = $FindSample(%trigger)
    if (%file) {
      var %base = $PSTC_GetPath(%trigger)
      PS_Tunnel .notice %nick Sending A Sample of: $+ %trigger $+ : $+ $nopath(%file) $+ : $+ $file(%file) $+ : $+ $crc(%file) $+ : $+ $&
        $right(%file,$calc(-1 * $len(%base) +1))
    }
    else halt
  }
  elseif (%what == have) {
    var %file = $PSE_MakeHavelist(%trigger,1,%nick,%req,%ip)
  }
  elseif (%what == have2) {
    var %file = $PSE_MakeHavelist(%trigger,2,%nick,%req,%ip)
  }
  elseif (%what == readytosend) {
    ;; this will be called when the dll finished its work AGAIN. dll called by PSE_MakeHavelist in the first place. only used to send the file in the same manner as every other file
    var %file = %sendfile
    if (!%file) halt 
  }
  elseif (%what == crclist) {
    var %tempfile =   $remove($PSE_TmpDir(filesent) $+ $ps_nickRemove($me),") $+ _CRCLIST_ $+ $ctime $+ _ $+ %trigger $+ .txt
    var %source = $+($PSTC_GetPath(%trigger),%sendfile)
    ; echo -set creating from %source > %tempfile
    noop $PSE_ListAllCRC(%source,%tempfile,$+(%trigger,:,%sendfile,:,$file(%sendfile)))
    if ($file(%tempfile)) var %file = %tempfile
  } 
  else var %file = $null

  if  ((%file == $null) || (!$isfile(%file)) ) HaltErrorReplyNumber %nick 12 %what %trigger

  var %out = $+($ps_nickRemove($me),_,$nopath(%file))
  if (%PS.compress != No) %file = $ps_compress(keep,%file,%out)

  ;; no ,%trigger because it would be registered as a sent file else
  %file = $remove(%file,")
  noop $PSE_RegisterAndSend(%nick,%ip,%req,%file,$file(%file).size)

}


alias -l FindSample {
  var %trigger = $1
  var %path = $PSTC_GetPath(%trigger).valid
  if (%path) {
    var %pat = *.jpg;*.gif;*.bmp
    var %files = $findfile(%path,%pat,0)
    var %sample = $findfile(%path,%pat,$rand(1,%files))
    return %sample
  }
}

/****************************************************************************************
* Generates havelist for Trig, using specified Format version (1 or 2)
* @return havelist path and filename of generated list, $null if Trig has not been set up
*/
alias PSE_MakeHavelist {
  var %trig = $1, %version = $2 , %nick = $3 , %req = $4 , %ip = $5
  if (%version == $null) var %version = 1
  if ($PSL_CheckDllRun(pserve.dll)) {
    echo -set Delaying MakeHaveList of %trig to %nick for 3 seconds
    .timer 1 3 PSE_MakeHaveList %trig %version %nick %req %ip
    halt
  }

  var %path = $file($left($PSTC_GetPath(%trig).valid,-1)).shortfn
  if (%path == $null) return
  var %DATA = PSE_MAKEHAVEDATA
  var %id = $hget(%data,I)
  if (!%id) %id = 0
  %id = %id % 25
  inc %id 
  hadd -m %DATA I %id

  var %havelist = $+($PS_HaveDir, $remove($PS_NickRemove(%PS.trigger),!), _HAVE_, %trig, .txt, ")

  var %path2 =  $file($left($PSL_TempPathForTrigger(%trig).parts,-1)).shortfn
  if (!$exists(%path2)) unset %path2

  echo $ps_n -st --> Building HaveList for: $+ $ps_kh %trig Path: $+ $ps_kh $file($left(%path,-1)).longfn / $+ $ps_kh %path2 File: $+ $ps_kh %havelist 6ID: %id
  hadd %DATA %id %trig %nick %req %ip %version %havelist

  noop $dllcall($PS_ProgramDir $+ pserve.dll",PSE_SendOutHaveList %id, MakeHavelist, %version %havelist $qt(%path) $qt(%path2))
  halt
}

;; this must not be a local alias. else the dll callback cannot find it
alias PSE_SendOutHaveList {
  var %id = $1
  if (!%id) return
  var %DATA = PSE_MAKEHAVEDATA
  var %data = $hget(%data,%id)
  if (!%data) return
  ;  echo found %data to send
  tokenize 32 %data
  var %trigger = $1 , %nick = $2 , %req = $3 , %ip = $4 , %version = $5 , %file = $6-
  echo -set ---> Sending the created havelist %file to %nick ( $+ %ip $+ )
  $ProcessGetSpecialFileRequest(%trigger,%nick,%req,%ip,readytosend,%file)
}

alias PSE_MakeHavelist_sync {
  var %trig = $1, %version = $2 
  if (%version == $null) var %version = 1
  var %path = $PSTC_GetPath(%trig).valid
  if (%path == $null) return
  var %havelist = $+($PS_HaveDir, $remove($PS_NickRemove(%PS.trigger),!), _HAVE_, %trig, .txt, ")
  echo $ps_n -st --> Building HaveList for: $+ $ps_kh %trig Path: $+ $ps_kh %path File: $+ $ps_kh %havelist

  var %result = $dll($PS_ProgramDir $+ pserve.dll", MakeHavelist, %version " $+ %path $+ " %havelist)
  if (found * files iswm %result) return %havelist
  else echo -s 4ERROR: %result
}



;; Generate havelist for Trig @return havelist path and filename of generated list, $null if Trig has not been set up
alias PSE_MakeHaveList_mircscript {
  var %trig = $1
  var %ps_a = PS_AddHave
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  var %path = $PSTC_GetPath(%trig).valid
  if (%path == $null) return
  var %havelist = $+($PS_HaveDir, $remove($PS_NickRemove(%PS.trigger),!), _HAVE_, %trig, .txt, ")
  echo $ps_n -st --> Building HaveList for: $+ $ps_kh %trig Path: $+ $ps_kh %path File: $+ $ps_kh %havelist

  if ($fopen(HAVELIST) != $null) .fclose HAVELIST
  .fopen -o HAVELIST %havelist
  .fwrite -n HAVELIST Made by PhotoServe v $+ $PS.Version $PS.Version.beta
  .fwrite -n HAVELIST Total Files: xxx
  .fwrite -n HAVELIST -
  var %cutlen = $calc(-1 * ($len(%path) - 1))
  var %t = $findfile(%path, *, 0, .fwrite -n HAVELIST $right($1-, %cutlen))
  .fclose HAVELIST

  return %havelist
}



;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;

/***
* old function. use PSE_SendFile instead 
* for compatibility reasons the req param can have a special format !whereis:ip:port 
* @param req requestmethod (!PSGET, !PSSERV, !trigger) @return void
*/
alias PS_DccSendFile {
  var %nick = $1 , %req = $2 , %file = $3-
  if (%ps_debug_alias != $null)  echo $ps_h -st * PS_DccSendFile * $1-
  ; $1 = nick
  ; $2 = !psget
  ; $3- = file
  var %ip = na:na
  if ($numtok(%req,58) == 3) {
    %ip = $gettok(%req,2-,58) 
    %req = $gettok(%req,1,58)
  }
  return $PSE_SendFile(%nick,%req,%ip,%file)
}

/**
* sends a file to a nick or an ip (dccserver)
* @optparam ip is the ip address:port of the remote dccserver, if not available set to na:na 
* @param req requestmethod either <code>!PSSERV</code> or something else
* @return Void
*/
alias PSE_SendFile {
  var %nick = $1 , %req = $2 , %ip = $3 , %sendfile = $4 , %nolimit = $5
  if (%nolimit == $null) var %nolimit = $PSCR_IsNolimitSendAllowed(%Nick)

  PSE_debuglog PSE_sendfile * nick %nick ! req %req ! ip %ip ! sendfile %sendfile
  var %ps_file = $qt($remove(%sendfile,"))
  ;  if (!$ip) localinfo -u
  if ((%req !== !PSserv) || (%ps.dccserver == fubar) || (%ip == na:na)) {
    .timer -m 1 $calc(%ps_senddelay * 300) .signal PSE_SENDNOW %nolimit %nick %ps_file
  }
  elseif ((%ps.dccserver == off) && ( $file(%ps_file).size < 2000000 )) {
    .timer -m 1 $calc(%ps_senddelay * 300) .signal PSE_SENDNOW %nolimit %nick %ps_file
  }
  else {
    ; echo -st >> Sending %ps_file to %ip ( %nick )  ( %req )
    PS_Tunnel .direct %nick I am now sending file $nopath(%sendfile) to your ip:port address %ip
    var %waspassive = $passivedcc
    if (%waspassive)  .dcc passive off
    .timer -m 1 $calc(%ps_senddelay * 300) .signal PSE_SENDNOW %nolimit %ip %ps_file
    if (%waspassive) .timer -m 1 $calc(%ps_senddelay * 300 +1) .dcc passive on
  }
  inc -z %ps_senddelay
  inc -z %ps_senddelay

}

;; dont ask why this has to be like this, its not working otherwise, when the timer is sending queued files out.. 
on *:SIGNAL:PSE_SENDNOW: {
  var %nolimit = $1 , %target = $2 , %file = $3-
  .dcc maxcps $PS_MaxDcc(speed)
  var %opt = -cm $+ $iif(%nolimit,n,l)
  dcc send %opt %target %file
}


/***
* Prepares a single file to be sent. If sends are not full (including the reserved pic-only-slots) the file is started to send, if not it will be queued.
* Use this alias to process a file in the regular way. Its also possible that the queue is full and the file is never sent at all.
* @return void @optparam trigger
*/
alias PSE_FileTransferStart {
  var %file = $1 , %nick = $2 , %req = $3 , %ip = $4 , %trigger = $5 
  ; echo -st >> PSE_FileTransferStart * $1-
  PSE_debuglog PSE_FileTransferStart * $1-
  var %size = $file(%file).size
  if (!%size) return

  if ($IsPresentIn(send,%file,%nick,%ip)) {
    ;  $HaltErrorReplyNumber(%nick,15,$nopath(%file))
    return
  }
  if ($IsPresentIn(queue,%file,%nick,%ip)) {
    var %waittime = $GetWaitTime($nopath(%file),%size,%nick)
    $sendReplyNumber(%nick,5,$nopath(%file),Already,%waittime)
    return
  }

  if ($IsNewSendOk(%file,%size,%nick,%req)) {
    $PSE_RegisterAndSend(%nick,%ip,%req,%file,%size,%trigger)
  }
  elseif ($IsNewQueueOk(%file,%size,%nick,%trigger)) {
    ;    var %newpos = $iif($SecondTransferChance(%nick,check),1,0)
    var %newpos = 0
    if ($SecondTransferChance(%nick,check)) %newpos = 1 
    elseif ( ($PSL_IsLeeched(%trigger)) || ($PSL_RecentLeeched(%trigger)) ) %newpos = $getPriPosition

    ; echo -set adding %file for %trigger to %newpos
    var %pos = $PSE_AddToQueue(%nick,%ip,%req,%file,%size,%trigger,%newpos)
    var %waittime = $GetWaitTime($nopath(%file),%size,%nick)
    $sendReplyNumber(%nick,3,$nopath(%file),%pos,%waittime)
  }
  else $sendReplyNumber(%nick,9)

}

;; returns the first position in the queue that is not a "leeched trigger" @returns Int
alias -l getPriPosition {
  var %qwin = $PSE_getWindowName(queue)

  var %m = $line(%qwin,0)
  var %i = 0
  while (%i < %m) {
    inc %i
    var %line = $line(%qwin,%i)
    var %trigger = $gettok(%line,8,9)
    ;    echo -set checking %trigger -> %i -> %line
    if ((%trigger) && ($PSTC_IsTrig(%trigger))) {
      var %ok = $iif($PSL_IsLeeched(%trigger) || $PSL_RecentLeeched(%trigger),$true,$false)
      ;     echo -set --> checking leech of %trigger : $PSL_IsLeeched(%trigger) || $PSL_RecentLeeched(%trigger) => %ok
      if (!%ok) return %i
    }
  }
  return 0
}


/***
* sends a file and registers the file in the systems sendlist. Use this alias to <b>immediatly</b> send a file, that needs to be accounted e.g. no other sends until done.
* @return void @optparam trigger no current use
*/

alias PSE_SimpleSendFile {
  var %nick = $1 , %ip = $2 , %file = $3-
  var %res = $PSE_RegisterAndSend(%nick,%ip,!PSServ,$remove(%file,"),$file(%file).size,SPECIAL)
}


;; the same as PSE_SimpleSendFile  but with more details possible
alias PSE_RegisterAndSend {
  var %nick = $1 , %ip = $2 , %req = $3 , %file = $4 , %size = $5 , %trigger = $6
  PSE_debuglog PSE_RegisterAndSend * n: %nick i: %ip r: %req f: %file s: %size t: %trigger
  if (!$exists(%file)) return
  var %swin = $PSE_getWindowName(send)
  aline $iif($PSE_IsPic(%size,%file),$ps_n,$ps_h) %swin $+(%nick,$chr(9),$gettok(%ip,1,58),$chr(9),$gettok(%ip,2,58),$chr(9),%req,$chr(9),%file,$chr(9),%size,$chr(9),%trigger)
  .signal PSE_SENDSTART %nick %ip
  $PSE_SendFile(%nick,%req,%ip,%file)
}


alias -l PSE_MiscFserve {
  var %nick = $1 , %type = $2
  var %ps_a = PS_MiscFserve
  if (%ps_debug_alias != $null) echo $ps_h -st * %ps_a * $1-

  if ($lock(fserve) == $true) {
    notice %nick 10Fserve 4Disabled 10in mIRC.
    return
  }
  if ($readini($qt($mircdir\mirc.ini),Warn,Fserve) == on) {
    notice %nick 10Fserve 4User Authorization Required Session Terminated.
    return
  }
  if ($ps_netWork_Fserv(PS_OnTextPart2,0) == 00) {
    if (%type == Misc1) var %ps_fserve_path = %ps.miscpath1
    elseif (%type == Misc2) var %ps_fserve_path = %ps.miscpath2
    elseif ((%type == PS_TriggersDir) || (%type == PS_BackupDir) || (%type == PS_HaveSavedDir)) var %ps_fserve_path = $($+($chr(36),%type),2)
    else return

    if ($isdir(%ps_fserve_path)) {
      fserve %nick 1 $qt(%ps_fserve_path)
      .notice %nick 10Starting fileserve in07 $qt(%ps_fserve_path)
    }
    else .notice %nick 10Fserve 4Canceled10, Path07 %ps_miscpath 10does not exist.
  }
  else .notice %nick 10Max Fserve sessions in progress, Fserve Canceled.
}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


ON *:QUIT: {
  var %res = $PSE_ClearQueue($nick)
}

on *:PART:#: .timer 1 10 CheckUserPermissionAndReact $nick $chan
on *:DEOP:#: .timer 1 3 CheckUserPermissionAndReact $opnick $chan
on *:DEVOICE:#: .timer 1 3 CheckUserPermissionAndReact $nick $chan
on *:KICK:#: .timer 1 3 CheckUserPermissionAndReact $knick $chan

;; checks if user is either on a PS channel voiced when voice is required, or on a PS channel @return Boolean $true if user IS allowed @optparam channel
alias CheckUserPermissionAndReact {
  var %nick = $1 , %channel = $2
  var %channelcheck = $PS_Channel(list,check,%nick)
  if (%channelcheck !== Yes) { 
    ;; shut down all sends and clear the queue
    PSE_Kill %nick
    return $false
  }
  return $true
}


on *:NICK: {
  dcc nick -s $nick $newnick
  ChangeNickName $PSE_getWindowName(send) $nick $newnick
  ChangeNickName $PSE_getWindowName(queue) $nick $newnick
  ChangeNickName $getParWindowName $nick $newnick
}

on *:FILESENT:*: $OnSentFile(-1,$true,$filename,$nick,$address,$false)
on *:SENDFAIL:*: $OnSentFile(-1,$false,$filename,$nick,$address,$false)
;; noop $OnSentFile(%count,$false,%file,%nick,%addr,$true)

alias -l OnSentFile {
  var %sendid = $1 , %success = $2 , %file = $3 , %nick = $4 , %addr = $5 , %killed = $6
  var %ip = $send(%sendid).ip
  var %registered = $TryUnRegisterSend(%nick,%ip,%file,%sendid,%killed)
  if (%registered)  SecondTransferChance %nick $iif(%success,clear,set)

  ;; SIGNAL PSE_SendEnd (NickName=>RealNickName) ($true|$false=>SuccessFullTransfer) ($true|$false=>ServerSend)   
  .signal PSE_SENDEND $iif(%registered,%registered,%nick) %success $iif(%registered,$true,$false)
  SendQueuedFiles

  .timer 1 0 OnSentFile_End %nick %success %file
}

alias -l OnSentFile_End {
  var %nick = $1 , %success = $2 , %file = $3-
  var %filename = $nopath(%file)
  var %tempdir = $remove($PSE_TmpDir(filesent) $+ $ps_nickRemove($me),")

  if (TriggerList_ $+ $ps_nickRemove($me) $+ _ isin %filename) {
    .timer 1 3 .remove $+(",%file,")
    if (%ps_testmysend) {
      window @PSTestResult 
      if (%success) echo 3 -t @PSTestResult File Send Test to %nick was successfull
      else  echo 4 -t @PSTestResult File Send Test to %nick was NOT successfull
    }
  }
  elseif (($remove($PS_NickRemove(%PS.trigger),!) $+ _HAVE_ isin %filename) && (.txt. isin %filename)) {
    .timer 1 3 .remove $+(",%file,")
  }
  elseif ($+(Backup_,$ps_nickRemove($me),_,%PS.trigger,_) isin %filename) {
    .timer 1 3 .remove $+(",%file,")
  }
  elseif (%tempdir == $left(%file,$len(%tempdir)) ) {
    .timer 1 3 .remove $+(",%file,")
  }
  elseif ($PSE_GetPartName($nopath(%file)).ispart) {
    var %tmp = $remove($PSE_TmpDir(filesent),")
    if ($left(%file,$len(%tmp)) == %tmp) {
      ; should check if the file is queued for someone else here too ...
      if (!$IsQueuedFile(%file)) .timer -m 1 201 .remove $+(",%file,")
    }
  }
}

;; adds transfer info to the stats system @return Void
alias -l AddDataToStats {
  var %success = $1 , %transferedbytes = $2 , %cps = $3 , %nick = $4 , %resume = $5 , %ip = $6
  if (%success) $PS_FileStatsHash(AddDataToStats1,Send,%transferedbytes,%cps,%nick,%resume,%ip)
  else $PS_FileStatsHash(AddDataToStats2,Send,%transferedbytes,%cps,%nick,%resume,%ip).fail
}

;; function to set a 45 second timer for a user to allow a second transfer chance within 45 seconds after an incomplete file transfer

alias -l SecondTransferChance {
  var %nick = $1 , %what = $2
  var %hash = PSE_FailedTransferMemory_ $+ $PS_Network

  if (%what == set) {
    hadd -mz %hash %nick 45
  }
  elseif (%what == clear) {
    if ($hget(%hash)) hdel %hash %nick
  }
  elseif (%what == check) {
    return $iif($hget(%hash,%nick),$true,$false)
  }
}
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

alias -l StartPar2Build {
  var %trigger = $1 , %file = $2 , %crc = $3 , %size = $4 , %nick = $5 , %ip = $6
  ; echo -st >> StartPar2Build * $1-
  if (%size == 0) %size = $file(%file).size
  if (%crc == 0) %crc = $crc(%file)
  var %targetfile = $remove($+($PS_Par2Dir,PSPAR2_,$upper(%trigger),--,$replace($nopath(%file),$chr(32),_),--,_,%crc,_,%size,.par2),")
  ; echo >> creating %targetfile from %file sooner or later.
  var %win = $getParWindowName
  aline %win $+(%nick,$chr(9),%ip,$chr(9),$cid,$chr(9),%targetfile,$chr(9),%file,$chr(9),%crc,$chr(9),%size,$chr(9),%trigger)
  RunPar2Timer
  $sendReplyNumber(%nick,17,$+(%trigger,:,$nopath(%file)),$nopath(%targetfile))
}

alias -l RunPar2Timer {
  if (!$timer(par2runner)) .timerpar2runner 0 8 ProcessPar2Queue
}

alias -l ProcessPar2Queue {
  var %win = $getParWindowName
  var %max = $line(%win,0)
  var %i = 0
  while (%i < %max) {
    inc %i
    var %line = $line(%win,%i)
    var %file = $gettok(%line,4,9)
    if ($isPar2Running) {
      ; echo -st >> already/still running Par2 $ifmatch
      return
    } 
    elseif ($file(%file)) {
      scid $gettok(%line,3,9)
      echo $ps_h -st ---> file10 %file already created. Starting Transfer now.
      var %sendfile 
      if ($regsub(%file,/\.par2$/,.*.par2,%sendfile)) {
        %file = $findfile($nofile(%sendfile),$nopath(%sendfile),1,1)
        if (%file) {
          echo $ps_h -st ---> Sending %file
          ;  var %file = $1 , %nick = $2 , %req = $3 , %ip = $4 , %trigger = $5 
          $PSE_FileTransferStart(%file,$gettok(%line,1,9),!PSSERV,$gettok(%line,2,9),$gettok(%line,8,9))
        }
        else echo -set Problem finding the correct file for %sendfile . Report this problem.
      }
      dline %win %i
      dec %i
      dec %max
    }
    else {
      var %source = $gettok(%line,5,9)
      var %size = $file(%source)
      ;      if (%size > 2147483648) {
      ;        echo $ps_h -set --> Par2 not possible for %file because its too large with %size bytes
      ;        dline %win %i
      ;      }
      ;      else {
      echo $ps_h -set --> Starting Creation of PAR207 %file from10 %source ( $bytes(%size).suf )
      var %res = $PSE_StartPar2(%file,%source)
      ;      }
      return
    }
  }
  ; echo -st >> nothing to do any more $ctimer
  if ($ctimer) {
    .timer  $+ [ $ctimer ] off
  }
}

;; returns something when par2 is running.. $null else. This function may be optimized to check if the OWN, this is the par2 exe from this mirc, is running and not just any par2.exe
alias -l isPar2Running {
  return $PS_ProcList(calling,par2.exe,return)
}

;; checks a command running and executed the command if "all" running processes of this name are gone param check eg: rar.exe
alias PSE_Check_Proc_Running {
  var %check = $1 , %command = $2-
  if (!$PS_ProcList(calling,%check,return)) {
    .timer  $+ [ $ctimer ] off
    %command 
  }
}


alias PSE_StartPar2 {
  var %targetfile = $1 , %sourcefile = $2
  var %blocksize = $CreateFilePartFromFile().partsize
  ; remember to double quote filenames in the params
  var %result = $dll($PS_ProgramDir $+ pserve.dll", RunWithoutWaiting, $&
    $PS_ProgramDir $+ par2.exe" c -n1 -s $+ %blocksize -r3 -- $qt(%targetfile) $qt(%sourcefile))
  ; %result should be "OK", anything else is an error
  return %result
}
; 
;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

alias -l getParWindowName {
  var %window = @PSE_PAR2Q
  ; %window = %window $+ _ $+ $PS_network
  if (!$window(%window)) window -lh -t10,22,24,81,145,160,175,190 %window Tahoma 8
  return %window
}




;; on server flood protection set the flag to ignore requests over the server.
raw 439:*:{
  var %ps_a = PS_raw439_PS3
  if (%ps_debug_alias != $null) echo $ps_k -st * %ps_a * $1-

  $PS_IgnoreServerReplies(439,Server Flood Enabled)
}


/*******************
* sets a flag to ignore server (not ip:port) whereis reply. during a server flood protection, trying to send whereis replys over the server causes
* more protection @return void
*/
alias PS_IgnoreServerReplies {
  var %calling = $1 , %message = $2-
  if (%calling == 439) var %ps_t = 300
  else var %ps_t = 600
  set -z $+(%,PS_ServerReplyIgnore_,$ps_network) %ps_t
  echo $ps_n -st --> Turning off Reply to server !Whereis for %ps_t seconds. Reason: $+ $ps_kh %message
}



;; unlocks all files inside a given directory. 
alias PSE_UnlockDirectory {
  var %dir = $1-
  var %dl = $len(%dir)
  var %sends = $send(0)
  while (%sends > 0) {
    var %d = $send(%sends).path
    if ($left(%d,%dl) == %dir) {
      ;  echo -set matching %dir to $left(%d,%dl) 
      close -s $+ %sends
    }
    dec %sends
  }
  scon -a PSE_ClearQueueFromCollectionfolder %dir
}


;; clear the queue from collections with a certain folder - this is used to completly unlock the dir
alias -l PSE_ClearQueueFromCollectionfolder {
  var %dir = $1-
  var %qwin = $PSE_getWindowName(queue)
  var %dl = $len(%dir)
  var %count = 0
  var %cur = $line(%qwin,0)
  while (%cur > 0) {
    var %line = $line(%qwin,%cur)
    var %d = $gettok(%line,5,9)
    if ($left(%d,%dl) == %dir) {
      inc %count
      dline %qwin %cur
    }
    dec %cur
  }
  return %count
}


;; checks if a give searchfile is queued in *ANY* network - useful for temp files @return Boolean
alias -l IsQueuedFile {
  var %sfile = $1 
  var %wpattern = $PSE_getWindowName(queue).getallpattern
  var %c = $window(%wpattern,0)
  ; echo -> searching all windows %wpattern now for %sfile -> %c windows
  while (%c > 0) {
    var %win = $window(%wpattern,%c) 
    dec %c
    ;   echo -> inspecting %win
    var %lines = $line(%win,0)
    while (%lines > 0) {
      var %line = $line(%win,%lines)
      var %file = $gettok(%line,5,9)
      ;      echo -> found %file in line %lines 
      if (%file == %sfile) return $true
      dec %lines
    }
  }
  return $false
}

;; creates a file that is the part of a big file
;; @prop partsize  @return FileName of the created (already existing part)
alias CreateFilePartFromFile {
  var %part = $1 , %file = $2
  var %partsize = 2048 * 1024
  if ($prop == partsize) return %partsize
  if ($file(%file).size) {
    var %filesize = $ifmatch
    var %totalparts = $ceil($calc(%filesize / %partsize))
    var %tempdir = $remove($PSE_TmpDir(filesent),") $+ $PS_Network $+ \
    if (!$exists(%tempdir)) mkdir $qt(%tempdir)
    var %partfile = $+(%tempdir,$PSE_GetPartName(%file,%filesize,%part))
    if (!$file(%partfile).size) {
      ; echo -set reading part %part from file
      bread $+(",%file,") $calc((%part - 1) * %partsize) %partsize &tempvar
      ; echo -set creating now %partfile
      bwrite $+(",%partfile,") 0 &tempvar
      bunset &tempvar
      ; echo -set done. file created
    }
    var %mysize = $file(%partfile)
    echo -set Created part5 %part in7 %partfile from file13 %file which has a total filesize of10 %filesize parts estimated:12 %totalparts -> partfilesize = %mysize
    if (%mysize)  return %partfile
  }
}

;; this functions puts all "part files" inside indir to the file. there is no check that all parts are there.
alias FindAndPutAllParts  {
  var %indir = $1 , %file = $2 
  var %pat = $PSE_GetPartName(%file)
  var %numoffiles = $findfile(%indir,%pat,0,0,noop $PSE_PutInPart($1-,%file))
  echo -set found6 %numoffiles in %indir for7 %pat
  return %numoffiles
}

alias PSE_ListAllCRC {
  var %file = $1 , %crcfile = $2 , %Meta = $3
  var %partsize = $CreateFilePartFromFile().partsize
  if ($file(%file)) {
    .fopen IN $+(",%file,")
    if (%crcfile) {
      .fopen -o OUT $+(",%crcfile,")
      .fwrite -n OUT metainfo: $+ %meta
    }
    while (!$feof) {
      if ( $fread(IN,%partsize,&temp) ) {
        var %read = $ifmatch
        if ($fopen(OUT)) .fwrite -n OUT $crc(&temp,1)
        else          echo size %read > crc = $crc(&temp,1)
      }
    }
    .fclose IN
    if ($fopen(OUT)) .fclose OUT
  }
}

/** This function constructs a file out of parts. It can be used to create the resulting large file only in the end to safe
* harddisk space @prop remove removes the parts after using them
*/

alias PSE_ConstructAllParts {
  var %path =  $1 , %pattern = $2 , %target = $3 , %endcommand = $4
  var %id = $ticks $+ _C
  var %window = $+(@allparts_,%id)
  window -c %window
  window -slh %window
  noop $findfile($file($left(%path,-1)).shortfn,%pattern,0,%window)

  %target = $file($left($nofile(%target),-1)).shortfn $+ $nopath(%target)

  var %max = $line(%window,0)
  var %i = 0

  var %handle = $+(OUT_,%id)


  if ($exists(%target))  fopen  %handle $qt(%target)
  else                   fopen -o %handle $qt(%target)

  hadd -m PSL_PROC_ $+ %id max %max 
  hadd -m PSL_PROC_ $+ %id i 0
  hadd -m PSL_PROC_ $+ %id window %window
  hadd -m PSL_PROC_ $+ %id handle %handle
  hadd -m PSL_PROC_ $+ %id cmd %endcommand
  if ($prop == remove) hadd -m PSL_PROC_ $+ %id remove $true


  .timer -om 0 $calc($PSC_SF * 400) PSE_ConstructAllParts_Middle %id

}

alias -l PSE_ConstructAllParts_Middle {
  var %id = $1
  var %handle = $hget(PSL_PROC_ $+ %id,handle) , %window = $hget(PSL_PROC_ $+ %id,window) 

  var %i = $hget(PSL_PROC_ $+ %id,i) , %max = $hget(PSL_PROC_ $+ %id,max) , %remove = $hget(PSL_PROC_ $+ %id,remove)
  if  (%i < %max  ) {
    inc %i
    hinc PSL_PROC_ $+ %id i 
    var %file = $line(%window,%i)
    var %part = $PSE_GetPartName(%file).getPart
    var %fsize = $file(%file)
    var %partsize = $CreateFilePartFromFile().partsize
    var %start = $calc((%part - 1) * %partsize)

    bunset &tempvar
    if ((%psl.constructmode == download) && (%psl.constructmode.skipreconstruct)) {
      echo -st Skipped writing data of part %part of $nopath(%file) into constructed file. $iif(%remove,I will only remove the File)
    }
    else {
      ;    echo -set inputting file %file as part %part to %target >> offset %start
      bread $+(",%file,") 0 %fsize &tempvar
      .fseek %handle %start
      .fwrite -b %handle &tempvar
      echo -st Part06 %part /07 %max from $nopath(%file) has been written to3 $longfn($fopen(%handle).fname)
      bunset &tempvar
    }
    if ((%remove) && (!$ferr)) saferemove %file
  }
  else {
    .timer $+ $ctimer off
    PSE_ConstructAllParts_End %id
  }

}

alias -l PSE_ConstructAllParts_End {
  var %id = $1
  var %handle = $hget(PSL_PROC_ $+ %id,handle) , %window = $hget(PSL_PROC_ $+ %id,window) , %endcommand =  $hget(PSL_PROC_ $+ %id,cmd) 

  fclose %handle
  window -c %window
  hfree PSL_PROC_ $+ %id

  if (%endcommand) %endcommand
}




;; this function detects the part number and places the data inside the correct position of the target @return OffsetofPart 
alias PSE_PutInPart {
  var %partfile = $1 , %target = $2
  var %num = $PSE_GetPartName(%partfile).getpart
  var %partsize = $CreateFilePartFromFile().partsize
  var %totalsize = $PSE_GetPartName(%partfile).getsize

  var %start = $calc((%num - 1) * %partsize)
  var %fsize = $file(%partfile).size
  bread $+(",%partfile,") 0 %fsize &tempvar
  echo -set Putting part7 %num of6 %partfile to5 %target now. Offset:3 %start
  noop $PS_MakePath($nofile(%target))
  ;;; same like -->  bwrite $+(",%target,") %start %fsize &tempvar  <-- but with error checking (drive might be full)
  %target = $shortfn($left($nofile(%target),-1)) $+ $nopath(%target)
  if ($fopen(OUT)) fclose OUT
  if ($exists(%target)) {
    if ($file(%target) > %totalsize) {
      btrunc $+(",%target,") %totalsize
    }
    .fopen OUT $+(",%target,")
  }
  else .fopen -o OUT $+(",%target,")
  .fseek OUT %start
  .fwrite -b OUT &tempvar
  if ($ferr) { fclose OUT | return 0 }
  .fclose OUT
  bunset &tempvar
  return %num

  :error
  reseterror
  return 0
}

;; creates the standard partname for a split file, filename can be a full path name
;; if part is not numeric it will be replaced with an * (asterix)
;; @prop getpart returns the part out of a filename @return Name 
;; @prop ispart tests if the filename is in part format returns Boolean
alias PSE_GetPartName {
  var %filename = $1 , %size = $2 , %part = $3
  if ($prop == ispart) {
    if ($mid(%filename,-13,8) == ###.part) return $true
    else return $false
  }
  if ($left($prop,3) == get) {
    if ($regex(%filename,/(.+)###(.{8})###.part(\d+)$/i)) {
      if ($prop == getpart) return $calc($regml(3)) 
      if ($prop == getname) return $regml(1)
      if ($prop == getsize) return $base($regml(2),26,10)
    }
    else return 0
  }
  else return $+($nopath($remove(%filename,")),###,$iif(%size isnum,$base(%size,10,26,8),$str(?,8)),###.part,$iif(%part isnum,$base(%part,10,10,5),*))
}


; create all parts of a file .. just for testing
alias testonly_create {
  var %file = $1
  var %i = 1 
  while ($CreateFilePartFromFile(%i,%file)) {
    inc %i
    echo -> created $ifmatch
  }
}
