
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####


/****************************************************************************************
* <b>PSTL - PhotoServe TriggerList module.</b>
* <p>
* Pserve.exe builds prefiltered, presorted triggerlists with mirc color codes and other
* formatting embedded inside the lists. Using hard coded colors has the obvious drawbacks,
* but it gives excellent speed when displaying large lists. Generating the list is
* asynchronous process, the script launches pserve.exe with <code>run</code> and resumes
* normal operation. Triggers directory is then polled once per second to see if the file
* TrigList.txt has appeared; appearance of TrigList.txt indicates that pserve.exe has
* completed its task and the file is ready for sending/viewing.
* <p>
* The very first line of a list is special, containing several header fields in XML-like
* markup. Some headers are inserted by photoserve, some by pserve.exe. New header fields
* can be introduced at any time, limited only by the mirc 900 char line limit. One of the
* headers is version number, telling the file format version. This makes it possible to
* alter the list format without invalidating current triggerlist archive.
* <p>
* Triggerlist archive is the big-brother feature that allows ops to monitor people's
* lists for unset triggers. When archiving is enabled a copy of a received list is placed
* in a subdirectory of \SavedTrigs\. There is also a special dialog for speedy
* analysis of the lists. RAR compression of the archive saves substantial amounts of
* disk space, the compression ratio stands at about 90%.
* <p>
* Global variables (settings):<ul>
* <li> %ps.triggerlist.archive       -- Space separated list of channels for which triggerarchiving is enables
* <li> %ps.triggerlist.sortorder     -- Sorting order, see documentation of PSTL_GetSort for details
* </ul>
* Transient globals:<ul>
* <li> %ps_triggerlist_filter      -- Number 1-6 selects filtering mode. $null == no filtering 
* <li> %ps_triggerlist_busy        -- Lock variable to prevent conflicts from simultanious triggerlist requests
* <li> %ps_triggerlist_view_nick   -- View next triggerlist received from this nick
* <li> %ps_triggerlist_analyze_paused         -- While $true analyzis will not process any lists
* <li> %ps_triggerlist_analyze_nick           -- Nick of the person whose history is being analyzed
* <li> %ps_triggerlist_analyze_chan           -- Chan which triggerlists are being analyzed
* <li> %ps_triggerlist_analyze_leechtrig      -- Nick's !trigger
* <li> %ps_triggerlist_analyze_linestotal     -- Total number of triggerlist lines that will be processed
* <li> %ps_triggerlist_analyze_linesprocessed -- Number of triggerlist lines processed so far
* </ul>
*/






/****************************************************************************************
* Channel command to mass get triglists
*/
on ^*:TEXT:!PSTrigs*:#: {
  haltdef
  if (($PS_SetStatus(!PsTrigs,Get) == ON) && ($PSC_isPSonInChannel($chan))) {
    if ($nick isop $chan) var %PS_time = $rand(0,240)
    elseif ($nick isvoice $chan) var %PS_time = $rand(0,600)
    else return
    .timer 1 %PS_time PSTL_Startlist $nick !psget na:na $chan $iif($regex($2-,/^[\+\-\w ]+$/i),$2-,+name)
  }
}



/****************************************************************************************
* Displays Message in active & status window and halts script. Is in no way specific to
* this module, could be usefull allover PS. It could be extended with a logfile, add a
* command to make the script send the logfile to an op and debugging other people's 
* problems could become a little easier. Could also add another alias that doesn't do
* /halt for non-fatal errors (ps_warning(...)?) etc. @return void
*/
Alias PS_FatalError {
  if (%ps_debug_alias != $null) echo $ps_h -st * PS_FatalError * $1-
  var %message = $1
  echo $ps_n -sat --> 04Photoserve Error: $1-
  halt
}



/****************************************************************************************
* Run pserve exe with specified Params and wait for it to exit. Adds the PsScriptDir
* param that all pserve.exe functions expect to receive.  Returns 'OK' to indicate
* pserve.exe started successfully, or an error message detailing the problem. 'OK' does
* <u>not</u> guarantee pserve.exe ran to completion without problems, it just means
* pserve.dll was able to run the exe.
* @param function the pserve.exe function to execute
* @param params all params for the function
* @return status either 'OK' or an error message
*/
alias PS_RunPserveExeSync {
  var %function = $1, %params = $2
  var %progdir = $PS_ProgramDir
  var %scriptdir = $left($PS_ScriptDir ,-1) $+ "   

  return $dll(%progdir $+ pserve.dll", RunWithoutTimeout, %progdir $+ pserve.exe" %function %scriptdir %params)
}


/****************************************************************************************
* Run pserve exe asyncronously with optional callback. Launches pserve.exe just like
* PS_RunPserveExeSync, but without waiting it to exit. Instead the call returns 
* immediately. You may specify an callback alias (and params) that will be called when
* pserve.exe has finished processing. 
* @param function the pserve.exe function to execute
* @param params all params for the function
* @optparam callback callback alias
* @return void
*/
alias PS_RunPserveExeAsync {
  var %function = $1, %params = $2, %callback = $3
  var %progdir = $PS_ProgramDir
  var %scriptdir = $left($PS_ScriptDir ,-1) $+ "   

  if (%callback != $null) {
    noop $dllcall(%progdir $+ pserve.dll", %callback, RunWithoutTimeout, %progdir $+ pserve.exe" %function %scriptdir %params)
  }
  else {
    run %progdir $+ pserve.exe" %function %scriptdir %params
  }
}


/****************************************************************************************
* Submenu for creating the "Triggerlist View Existing, etc" menu items.<p>
* eg in nicklist: .$submenu($PSTL_ViewListSubmenu($1, [ $1 ] ,$chan))<br>
* @param n the $1 autoincrement variable used for submenus
* @param nick the person whose list can be requested/viewed with this menu
* @optparam chan channel context for the triggerlist request
* @return popup menu items
*/
Alias PSTL_ViewListSubmenu {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_ViewListSubmenu * $1-
  var %n = $1, %nick = $2, %chan = $3

  if (%chan != $null) set $+(%,ps.active.,$ps_netWork(PSTL_ViewListSubmenu),.chan) %chan

  if ((%n == begin) || (%n == end)) return -
  if ((%nick == $me) && (%n == 1)) return Triggerlist View My List: PSTL_RequestAndView $me AllChannels
  if ((%nick == $me) && (%n == 2)) return

  if ((%chan != $null) && ($left(%chan,1) == $chr(35))) {
    if (%n == 1) return Triggerlist Get New: PSTL_RequestAndView %nick %chan 
    if ((%n == 2) && ($isfile($PS_TrigDir $+ %chan $+ _ $+ $ps_nickRemove(%nick) $+ .txt"))) return Triggerlist View Existing: PSTL_LoadCurrent %nick %chan
    if ((%n == 3) && ($isfile($PS_TrigDir $+ %chan $+ _ $+ $ps_nickRemove(%nick) $+ .txt")) && ($me isop %chan)) return Triggerlist Analyze History: PSTL_Analyze %nick %chan
    return
  }

  ; No chan defined, find common active channels
  var %channels = $ps_channel(list,active)
  var %i = $numtok(%channels,59)
  while (%i > 0) {
    if (%nick !ison $gettok(%channels,%i,59)) %channels = $deltok(%channels,%i,59)
    dec %i
  }

  ; The "View existing" and "Find unset" options wont be available when the channel has not been specified
  if (%n <= $numtok(%channels,59)) return Triggerlist Get New ( $+ $gettok(%channels,$1,59) $+ ): PSTL_RequestAndView %nick $gettok(%channels,$1,59)
}



/****************************************************************************************
* Requests and upon receiving views Triggerlist from Nick
* @return void
*/
Alias PSTL_RequestAndView {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_RequestAndView * $1-
  var %nick = $1, %chan = $2

  set -u600 %ps_triggerlist_view_nick $PS_NickRemove(%nick)
  if ($1 == $me) $PSTL_StartList(%nick,!psget,na:na,%chan,$PSTL_GetSort(0))
  else           ctcp %nick !PSget TriggerList %chan $PSTL_GetSort(0)
}



/****************************************************************************************
* Starts the process of generating a new triggerlist. Only one process can be in flight
* at a time (otherwise they would all try to write to the same file). %ps_triggerlist_busy
* variable works as lock here, the first request claims the lock, and when the process is
* completed releases it again in PSTL_PollList. Who's request is processed next
* depends on luck - it's not FIFO queueing.
* @param nick the nick that requested your list
* @param method !psget, !psserv, !mytrig etc
* @param ip ip:port if using !psserv
* @param chan channel for which the list is for (filter)
* @optparam sortorder +custom -status +name ...
* @return void
*/
Alias PSTL_StartList {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_StartList * $1-
  var %nick = $1, %method = $2, %ip = $3 , %chan = $4, %sortorder = $5-

  if ((%nick != $me) && (%nick !ison %chan)) return
  if ($regex(%chan,/([\<\>\|\%\&\" \\])/)) ps_FatalError PSTL_StartList - Channel name contains unsafe special characters - ' $+ $regml(1) $+ ' in %chan
  var %sortorder = $iif($regex(%sortorder,/^[\+\-\w ]+$/i),%sortorder,+name)

  if (%ps_triggerlist_busy) {
    .timer 1 5 PSTL_StartList %nick %method %ip %chan %sortorder
    return
  }
  set -u300 %ps_triggerlist_busy $true
  if ($isfile($PS_TriggersDir(PSTL_StartList) $+ TrigList.txt")) .remove $PS_TriggersDir(PSTL_StartList) $+ TrigList.txt"
  $PS_RunPserveExeAsync(MakeTriggerList, %chan %sortorder)
  .timer 1 1 PSTL_PollList %nick %method %ip
}



/****************************************************************************************
* Poll to see if triggerlist has been generated. Once the triggerlist is done,
* send to Nick (compress first if needed). If Nick == $me skip the compression
* and send part and instead move the file directly to \SavedTrigs\. @return void
*/
Alias -l PSTL_PollList {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_PollList * $1-
  var %nick = $1, %method = $2, %ip = $3

  if (!$isfile($PS_TriggersDir(PSTL_PollList) $+ TrigList.txt")) {
    if (%ps_triggerlist_busy) .timer 1 1 PSTL_PollList %nick %method %ip
    return
  }
  unset %ps_triggerlist_busy

  write -al1 $PS_TriggersDir(PSTL_PollList) $+ TrigList.txt" $+(<leechtrig>,%PS.trigger,</leechtrig><nick>,$me,</nick><hostmask>,$address($me,5),</hostmask>)

  if (%nick == $me) {
    .enable #PSTL_psCollectionChanged
    $PSTL_MoveToSavedTrigsDir($PS_TriggersDir(PSTL_PollList) $+ TrigList.txt")
  }
  else {
    var %listname = $+($PS_TmpDir(PSTL_PollList),TriggerList_,$ps_nickRemove($me),_,$ticks,.txt,")
    .copy -o $PS_TriggersDir(PSTL_PollList) $+ TrigList.txt" %listname
    .remove  $PS_TriggersDir(PSTL_PollList) $+ TrigList.txt"
    if (%PS.compress != No) %listname = $ps_compress(rem,%listname)
    $PSE_RegisterAndSend(%nick, %ip, %method, $remove(%listname, "), $file(%listname).size)
  }
}



/****************************************************************************************
* Determines the weeknumber of Date and returns the target archivedir for a triggerlist
* of that Date. Also creates the directory if it doesn't already exist. Note that our
* "weeks" begin on the first day of the year - be it sunday, monday, or thursday - it's
* just a seven day period. 
* @param date YYYY-MM-DD formatted date
* @return dir "X:\...\SavedTrigs\YYYY-WW\
*/
Alias -l PSTL_ArchiveDir {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_ArchiveDir * $1-
  var %date = $1
  var %yearbegin = $left(%date,4) $+ -01-01
  var %duration = $calc($ctime(%date) - $ctime(%yearbegin))
  var %period = $int($calc(%duration / (86400 * 7) + 1))
  var %dir = $PS_TrigDir $+ $left(%date,4) $+ -w $+ $iif($len(%period) == 1,0 $+ %period,%period) $+ \
  if (!$isdir(%dir)) .mkdir %dir $+ "
  return %dir
}



/****************************************************************************************
* Adds necessary timestamps to File and moves it to \Photoserve\SavedTrigs\. The source
* filename can be anything, the destination will be named #channel_NICK.txt. Also takes
* care of archiving by moving files to \Photoserve\SavedTrigs\YYYY-Week\. Finally, loads
* the TriggerList if the file was requested with PSTL_RequestAndView.<p>The reason why
* timestamps are inserted here instead of when the list is actually generated, is that 
* the other user's clock may be wildly out of date. This way only your own clock
* matters. @return void
*/
Alias PSTL_MoveToSavedTrigsDir {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_MoveToSavedTrigsDir * $1-
  var %file = $1-
  var %source = " $+ $remove(%file,") $+ "
  var %nick = $PS_NickRemove($PSTL_GetHeader(%source,nick))
  var %chan = $lower($PSTL_GetHeader(%source,chan))
  var %dest = $PS_TrigDir $+ %chan $+ _ $+ %nick $+ .txt"
  write -al1 %source <generated> $+ $asctime($ctime,yyyy-mm-dd) $+ </generated><ctime> $+ $ctime $+ </ctime>
  if ($istok(%PS.triggerlist.archive,%chan,32)) {
    var %archivedir = $PSTL_ArchiveDir($PSTL_GetHeader(%source,generated))
    var %archivedest = %archivedir $+ %chan $+ _ $+ $remove($PSTL_GetHeader(%source,leechtrig),|,<,>,/,\,$,") $+ .txt"
    .copy -o %source %archivedest
    var %rar = %archivedir $+ %chan $+ .rar"
    var %t = $dll($PS_ProgramDir $+ pserve.dll",Run,$PS_ProgramDir $+ rar.exe" m -o+ -ep -m5 %rar %archivedest)
  }
  .copy -o %source %dest
  .remove %source
  if (%ps_triggerlist_view_nick == %nick) {
    unset %ps_triggerlist_view_nick
    $PSTL_LoadCurrent(%nick,%chan)
  }
}



/****************************************************************************************
* Loads Nick's current triggerlist for Chan. @return void
*/
Alias PSTL_LoadCurrent {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_LoadCurrent * $1-
  var %nick = $1, %chan = $2
  $PSTL_LoadList($PS_TrigDir $+ $2 $+ _ $+ $ps_nickRemove($1) $+ .txt", @Triggerlist_ $+ $ps_network)
}



/****************************************************************************************
* Load !Leechtrig's archived triggerlist for Channel from Date. @return void
*/
Alias -l PSTL_LoadArchived {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_LoadArchived * $1-
  var %leechtrig = $1, %chan = $2, %date = $3
  $PSTL_LoadList($PSTL_ArchiveDir($3) $+ $2 $+ _ $+ $remove($1,|,<,>,/,\,$,") $+ .txt", @Triggerlist_Archived_ $+ $ps_netWork)
}



/****************************************************************************************
* Modifies sorting order and reloads Window. 
* @param window name of the window 
* @param level which level of sorting is modified (1 = primary, 2 = secondary, etc)
* @param order new sorting order ('-status', '+count', etc), or 'reverse' to maintain
* the current sorting field but reverse its direction.
* @return void
*/
Alias -l PSTL_SortWindow {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_SortWindow * $1-
  var %window = $1, %level = $2, %order = $3
  $PSTL_SetSort(%level, %order)
  $PSTL_ReloadWindow(%window)
}



/****************************************************************************************
* Modifies filtering setting and reloads Window. The new setting is kept for 30 minutes
* after which it is reset to "Display Everything" - it used to be a problem that people
* set filtering on and then forgot to turn it off, causing them to not see all trigs.
* @param num number of the new filter setting, $null to disable filtering. See code
* of PSTL_FilterSubmenu for the meaning of the numbers.
* @return void
*/
Alias -l PSTL_FilterWindow {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_FilterWindow * $1-
  var %window = $1, %num = $2
  set -u1800 %ps_triggerlist_filter %num
  $PSTL_ReloadWindow(%window)
}



/****************************************************************************************
* Reloads Window. Used to refresh the window after changing sort/filter. @return void
*/
Alias -l PSTL_ReloadWindow {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_ReloadWindow * $1-
  var %window = $1
  if (_Archived_ isin %window) {
    PSTL_LoadArchived $PSTL_GetTitle(%window,leechtrig) $PSTL_GetTitle(%window,chan) $PSTL_GetTitle(%window,generated)
  }
  elseif ($PSTL_GetTitle(%window ,nick) == $me) {
    PSTL_RequestAndView $PSTL_GetTitle(%window,nick) $PSTL_GetTitle(%window,chan)
  }
  else {
    PSTL_LoadCurrent $PSTL_GetTitle(%window,nick) $PSTL_GetTitle(%window,chan)
  }
}



/****************************************************************************************
*/
menu @*Triggerlist_* {
  lbclick: {
    if ($PSTL_GetTitle($menu,nick) == $me) PSTL_UpdateLine $menu $PSTL_GetField($menu,$1,trig)
    sline $menu $1
  }
  dclick: {
    if (_Archived_ isin $menu) return
    if ($PSTL_GetTitle($menu,nick) == $me) PSTC_ConfigureAll $PSTL_GetField($menu,sline,trig)
    if ($PSTL_GetTitle($menu,nick) != $me) PS_LeechOpen $menu $PSTL_GetTitle($menu,nick) $PSTL_GetTitle($menu,leechtrig) $PSTL_GetField($menu,sline,trig)
  }
  Primary Sorting Order
  .Secondary Sorting Order
  ..Tertiary Sorting Order
  ...What, you want MORE?
  ...-
  ...$submenu($PSTL_SortSubmenu($1,3))
  ..-
  ..$submenu($PSTL_SortSubmenu($1,2))
  .-
  .$submenu($PSTL_SortSubmenu($1,1))
  Display $iif(%ps_triggerlist_filter,*,$null)
  .$submenu($PSTL_FilterSubmenu($1))
  -
  $iif(($PSTL_GetTitle($menu,nick) == $me) && (_Archived_ !isin $menu), Say in $eval($+(%,ps.active.,$ps_netWork(triglistmenu),.chan),2))
  .$submenu($PSTL_LocalSaySubmenu($1))
  -
  $submenu($PSTL_LocalConfigSubmenu($1))
  $submenu($PSTL_RemoteSubmenu($1))
  -
  !WhereIs: $PS_WhereIs($PSTL_GetField($menu,sline,trig))
  -
  Save Window Size/Position: { %PS.wintrigwin = $PS_Location($menu) |  %PS.wintrigwinfont = $PS_Font($menu) }
}


/****************************************************************************************
* Triggerlist "Display" submenu. This menu is displayed for all triggerlists.
* @param n the $1 autoincrement variable @return popup menu items
*/
Alias -l PSTL_FilterSubmenu {
  var %n = $1
  if (%n == 1) return $iif(%ps_triggerlist_filter == $null,$style(1)) Everything:     PSTL_FilterWindow $menu
  if (%n == 2) return $iif(%ps_triggerlist_filter == 1,$style(1)) Final:              PSTL_FilterWindow $menu 1
  if (%n == 3) return $iif(%ps_triggerlist_filter == 2,$style(1)) Final Incomplete:   PSTL_FilterWindow $menu 2
  if (%n == 4) return $iif(%ps_triggerlist_filter == 3,$style(1)) Final Complete:     PSTL_FilterWindow $menu 3
  if (%n == 5) return $iif(%ps_triggerlist_filter == 4,$style(1)) Ongoing:            PSTL_FilterWindow $menu 4
  if (%n == 6) return $iif(%ps_triggerlist_filter == 5,$style(1)) Ongoing Complete:   PSTL_FilterWindow $menu 5
  if (%n == 7) return $iif(%ps_triggerlist_filter == 6,$style(1)) Ongoing Incomplete: PSTL_FilterWindow $menu 6
  if (%n == 8) return -
  if (($PSTL_GetTitle($menu,nick) != $me) || (%n !isnum)) return
  if (%n == 9) return $iif($PSTL_GetTitle($menu,chan) == AllChannels,$style(1)) AllChannels: PSTL_RequestAndView $me AllChannels
  var %chan = $gettok($ps_channel(list,active),$calc(%n - 9),59)  
  if (%chan != $null) return $iif($PSTL_GetTitle($menu,chan) == %chan,$style(1)) %chan $+ : PSTL_RequestAndView $me %chan
}


/****************************************************************************************
* Triggerlist Sorting submenu. This menu is displayed for all triggerlists.
* @param n the $1 autoincrement variable
* @param level which level of sorting this submenu modifies
* @return popup menu items
*/
Alias -l PSTL_SortSubmenu {
  var %n = $1, %level = $2
  if (%n == 1) return $iif($PSTL_GetSort(%level).nosign == name,    $style(1)) Name:       PSTL_SortWindow $menu %level +name
  if (%n == 2) return $iif($PSTL_GetSort(%level).nosign == trig,    $style(1)) Trig:       PSTL_SortWindow $menu %level +trig
  if (%n == 3) return $iif($PSTL_GetSort(%level).nosign == count,   $style(1)) Count:      PSTL_SortWindow $menu %level +count
  if (%n == 4) return $iif($PSTL_GetSort(%level).nosign == csvcount,$style(1)) CSV Count:  PSTL_SortWindow $menu %level +csvcount
  if (%n == 5) return $iif($PSTL_GetSort(%level).nosign == size,    $style(1)) Size:       PSTL_SortWindow $menu %level +size
  if (%n == 6) return $iif($PSTL_GetSort(%level).nosign == flagrep, $style(1)) Has Report: PSTL_SortWindow $menu %level +flagrep
  if (%n == 7) return $iif($PSTL_GetSort(%level).nosign == flagcsv, $style(1)) Has CSV:    PSTL_SortWindow $menu %level +flagcsv
  if (%n == 8) return $iif($PSTL_GetSort(%level).nosign == flagfin, $style(1)) CSV Type:   PSTL_SortWindow $menu %level +flagfin
  if (%n == 9) return $iif($PSTL_GetSort(%level).nosign == cd,      $style(1)) Backup ID:  PSTL_SortWindow $menu %level +cd
  if (%n == 10) return $iif($PSTL_GetSort(%level).nosign == status,  $style(1)) Status:     PSTL_SortWindow $menu %level -status
  if (%n == 11) return $iif($PSTL_GetSort(%level).nosign == path,   $style(1)) Path:       PSTL_SortWindow $menu %level +path
  if (%n == 12) return $iif($PSTL_GetSort(%level).nosign == csvfile,$style(1)) CSV Filename:          PSTL_SortWindow $menu %level +csvfile
  if (%n == 13) return $iif($PSTL_GetSort(%level).nosign == custom, $style(1)) Custom/Official:       PSTL_SortWindow $menu %level +custom
  if (%n == 14) return $iif($PSTL_GetSort(%level).nosign == complete, $style(1)) Complete/Incomplete: PSTL_SortWindow $menu %level +complete
  if (%n == 15) return -
  if (%n == 16) return $iif($PSTL_GetSort(%level).sign == -,        $style(1)) Reverse:    PSTL_SortWindow $menu %level reverse
  return
}


/****************************************************************************************
* Triggerlist Remote commands submenu. This menu is displayed when you are viewing
* somebody else's triggerlist. Holds remote commands (get samples, leech, get CSV, etc).
* @param n the $1 autoincrement variable @return popup menu items
*/
Alias -l PSTL_RemoteSubmenu {
  var %n = $1
  var %nick = $PSTL_GetTitle($menu,nick)
  var %leechtrig = $PSTL_GetTitle($menu,leechtrig)
  var %trig = $PSTL_GetField($menu,sline,trig)
  if (($PSTL_GetTitle($menu,nick) == $me) || (_Archived_ isin $menu)) return
  if (%n == 1) return $iif($PSTL_GetField($menu,sline,status) != ON,$style(2)) -----:          // PS_LeechOpen $menu %nick %leechtrig %trig
  if (%n == 2) return $iif($PSTL_GetField($menu,sline,status) != ON,$style(2)) Get Samples:    PSS_GetSamples %nick %leechtrig %trig
  if (%n == 3) return $iif($PSTL_GetField($menu,sline,status) != ON,$style(2)) Get Havelist:   ctcp %nick %leechtrig %trig have
  if (%n == 4) return $iif($PSTL_GetField($menu,sline,flagrep) != R,$style(2)) Get Report:     ctcp %nick %leechtrig %trig report
  if (%n == 5) return $iif($PSTL_GetField($menu,sline,flagcsv) != C,$style(2)) Get CSV:        ctcp %nick %leechtrig %trig csv
  if (%n == 6) return $iif($PSTC_IsTrig($PSTL_GetField($menu,sline,trig)) || ($PSTL_GetField($menu, sline, type) != <custom>), $style(2)) Add To Custom Group: PSTC_AddCustomTrig CUST.TRG %trig $PSTL_GetField($menu,sline,name)
  if (%n == 7) return -
}


/****************************************************************************************
* Triggerlist Local commands submenu 1. This menu is displayed when you are viewing your
* own triggerlist. Holds the trigger "say" commands (request to load, trig news, etc)
* @param n the $1 autoincrement variable @return popup menu items
*/
Alias -l PSTL_LocalSaySubmenu {
  var %n = $1
  if (($PSTL_GetTitle($menu,nick) != $me) || (_Archived_ isin $menu)) return
  if (%n == 1) return Request Trigger: $ $+ PS_TrigReq($PSTL_getField($menu,sline,trig),$eval($+(%,ps.active.,$ps_netWork,.chan),2),Request)
  if (%n == 2) return Requested Trigger (CD Loaded): $ $+ PS_TrigReq($PSTL_getField($menu,sline,trig),$eval($+(%,ps.active.,$ps_netWork,.chan),2),Loaded)
  if (%n == 3) return -
  if (%n == 4) return Trigger Update Channel News: $ $+ PS_TrigNews($PSTL_getField($menu,sline,trig),$eval($+(%,ps.active.,$ps_netWork,.chan),2),El-toro)
  if (%n == 5) return Trigger Update Private News: $ $+ PS_TrigNews($PSTL_getField($menu,sline,trig),$eval($+(%,ps.active.,$ps_netWork,.chan),2),Private)
  if (%n == 6) return -
  if (%n == 7) return Trigger Count: $ $+ PS_TrigStatus($PSTL_getField($menu,sline,trig),$eval($+(%,ps.active.,$ps_netWork,.chan),2),Channel)
}


/****************************************************************************************
* Triggerlist Local commands submenu 2. This menu is displayed when you are viewing your
* own triggerlist. Holds the trigger configuration commands (Count, Configure, etc).
* @param n the $1 autoincrement variable @return popup menu items
*/
Alias -l PSTL_LocalConfigSubmenu {
  var %n = $1
  var %trig = $PSTL_GetField($menu,sline,trig)
  if (($PSTL_GetTitle($menu,nick) != $me) || (_Archived_ isin $menu)) return
  if (%n == 1) return Explore:                                                        run explorer.exe /n, /e,  " $+ $PSTC_GetPath(%trig) $+ "
  if (%n == 2) return Turn $iif($PSTL_GetField($menu,sline,status) == OFF,ON,OFF) :   PSTC_SetStatus %trig $iif($PSTL_GetField($menu,sline,status) == OFF,ON,OFF)
  if (%n == 3) return Count:                                                          PSTC_Count %trig
  if (%n == 4) return Configure:                                                      PSTC_ConfigureAll %trig
  if (%n == 5) return CSV Lookup:                                                     PSCSV_LookupTrig %trig
}



/****************************************************************************************
* Gets HeaderField value from File. Current fields are: <code>leechtrig, generated,
* hostmask, nick, tabs, sortorder, ctime, chan.</code> Missing header field is
* considered fatal error and will halt the script. @return string field value
*/ 
Alias -l PSTL_GetHeader {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_GetHeader * $1-
  var %file = $1, %headerfield = $2
  if ($regex($read(%file,n,1),$+(/<,%headerfield,>(.+)<\/,%headerfield,>/i))) return $regml(1)
  ps_FatalError Unable to extract '12 $+ %headerfield $+ ' from '12 $+ %file $+ ' header '12 $+ $read(%file,n,1) $+ '
}



/****************************************************************************************
* Gets TitleField value from Window's Title. Current fields are: <code>nick, leechtrig,
* online, offline, total, generated, chan.</code> Missing title field is considered
* fatal error and will halt the script. <p><strong>Note:</strong> GetTitle(..., generated)
* returns only the date, not the "(n days ago)" part. @return string field value
*/
Alias -l PSTL_GetTitle {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_GetTitle * $1-
  var %window = $1, %titlefield = $2
  if ($regex($window(%window).title,/ $+ %titlefield $+ : (\S+)/i)) return $regml(1)
  ps_FatalError Unable to extract ' $+ %titlefield $+ ' from ' $+ %window $+ ' window title " $+ $window(%window).title $+ "
}



/****************************************************************************************
* Creates (if not already exist) Window and populates it with the contents of File.
* @return void
*/
Alias PSTL_LoadList {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_LoadList * $1-
  var %file = $1, %window = $2
  var %listfile = " $+ $remove(%file,") $+ ", %nick = $PSTL_GetHeader(%file,nick)

  if (!$regex(%ps_triggerlist_filter,/^[1-6]$/)) %ps_triggerlist_filter = $null

  if ($PSTL_GetHeader(%listfile,version) > 2) {
    PS_FatalError Unable to view %nick $+ 's TriggerList, Incompatible versions - upgrade Photoserve to view the list
  }
  if ($PSTL_GetHeader(%listfile,version) < 2) {
    var %result = $PS_RunPserveExeSync(SortTriggerList, %listfile $PSTL_GetSort(0))
  }
  if ($PSTL_GetHeader(%listfile,sortorder) != $PSTL_GetSort(0)) {
    var %result = $PS_RunPserveExeSync(SortTriggerList, %listfile $PSTL_GetSort(0))
  }

  if (!%PS.wintrigwin) set %PS.wintrigwin 8 24 745 340
  if (!%PS.wintrigwinfont) set %PS.wintrigwinfont Verdana 12
  if (!%ps.trigwinoffset) set %ps.trigwinoffset 2.5

  if ($window(%window) == $null) {
    ; Open window, add tabplaces, add a scrollbar
    var %tabs = $PSTL_GetHeader(%listfile,tabs)

    if ($version >= 7) {
      var %i = $gettok(%tabs,0,44)
      while (%i > 1) {
        var %tabs = $reptok(%tabs,$gettok(%tabs,%i,44),$calc( $gettok(%tabs,%i,44) * %ps.trigwinoffset ),44)
        dec %i
      }
      var %tabs = $reptok(%tabs,$gettok(%tabs,1,44),-t $+ $calc( $gettok($gettok(%tabs,1,44),2,116) * %ps.trigwinoffset ),44)
    }

    window -lark $+ $PSA_GetDesktopFlag(triglist) %tabs %window %PS.wintrigwin %PS.wintrigwinfont
    aline %window Name $chr(9) Trig $chr(9) Count $chr(9) CSVCount $chr(9) Size $chr(9) R $chr(9) C $chr(9) F $chr(9) CD $chr(9) OFF $chr(9) C:\Path\ $chr(9) CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV-CSV
    window -b %window
  }
  window -a %window

  if (%ps_triggerlist_filter != $null) {
    ; The %ps_triggerlist_filter setting is only kept for 30 minutes. Keeping it
    ; forever is no good, people enable filtering and then forget to turn it off.
    set -u1800 %ps_triggerlist_filter %ps_triggerlist_filter
    var %filterRE = ( $+ $gettok(<ongoing>'<ongoing>|<complete>'<ongoing>|<incomplete>'<final>'<final>|<incomplete>'<final>|<complete>,%ps_triggerlist_filter,39) $+ )
    filter -xcrg 2-100000 %listfile %window %filterRE
  }
  else {
    loadbuf 2-100000 -r %window %listfile
  }


  var %generated = $PSTL_GetHeader(%listfile,generated)
  var %fileage = $ctime - $PSTL_GetHeader(%listfile,ctime)
  var %fileage = ( $+ $gettok($duration(%fileage),1,32) ago $+ )
  var %chan = $PSTL_GetHeader(%listfile,chan)

  titlebar %window --- Nick: %nick --- LeechTrig: $PSTL_GetHeader(%listfile,leechtrig) --- Online: $fline(%window,*??ON $+ $chr(9) $+ *,0) --- Offline: $fline(%window,*??OFF $+ $chr(9) $+ *,0) --- Total: $line(%window,0) --- Generated: %generated %fileage --- Chan: %chan
}




/****************************************************************************************
* Returns Nth level sorting order, $null if not set. If N = 0, returns all orders
* separated by spaces. If no sortorer has been set, defaults to +name (which also
* means N=0 and N=1 never return $null).
* <p>The sorting order is defined in %PS.triggerlist.sortorder. It is a space separated
* list if fieldnames preceded by sign indicating sorting direction (±Field ±Field ±Field).
* Possible field values are: name, trig, count, csvcount, flagrep, flagcsv, flagfin, cd,
* status, path, csvfile, custom, complete, type (type and custom are same). Count and
* csvcount field sort numerically, rest alphabetically. All sorting is done in pserve.exe
* @prop sign get only the sign part  (does not work with N=0)
* @prop nosign get only the Field part (does not work with N=0)
* @return string Nth level sort order
*/
Alias PSTL_GetSort {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_GetSort * $1-
  var %n = $1
  if (!$regex(%PS.triggerlist.sortorder,/^[\+\-\w ]+$/i)) %PS.triggerlist.sortorder = +name
  if ($1 == 0) return %PS.triggerlist.sortorder
  if ($prop == nosign) return $right($gettok(%PS.triggerlist.sortorder,%n,32),-1)
  if ($prop == sign)   return $left($gettok(%PS.triggerlist.sortorder,%n,32),1)
  return $gettok(%PS.triggerlist.sortorder,%n,32)
}




/****************************************************************************************
* Sets Nth level sorting to ±Field or reverses current order. Pass literal 'reverse'
* in place of field to reverse current Nth level sorting.
* @param field sign followed by field name (+status), or word 'reverse'
* @return void
*/
Alias -l PSTL_SetSort {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_SetSort * $1-
  var %n = $1, %field = $2
  if ($2 == reverse) {
    var %current = $gettok(%PS.triggerlist.sortorder,$1,32)
    if (%current == $null) return
    var %reversed = $iif($left(%current,1) == -,+,-) $+ $right(%current,-1)
    %PS.triggerlist.sortorder = $puttok(%PS.triggerlist.sortorder,%reversed,$1,32)
  }
  else {
    if ($numtok(%PS.triggerlist.sortorder,32) < $1) {
      %PS.triggerlist.sortorder = $addtok(%PS.triggerlist.sortorder,$2,32)
    }
    else {
      %PS.triggerlist.sortorder = $puttok(%PS.triggerlist.sortorder,$2,$1,32)
    }
  }
}





/****************************************************************************************
* Update your own open triggerlist window. This signal handler runs whenever the state of
* a collection is changed. If the user has his own Triggerlist(s) open it will update the
* line for that collection. If the user does not have his own list open, turns off the
* signal listener so as not to waste cpu-time.
*/
#PSTL_psCollectionChanged off
on *:SIGNAL:psCollectionChanged: {
  .disable #PSTL_psCollectionChanged

  var %winindex = $window(@Triggerlist*,0)
  while (%winindex > 0) {
    var %windowname = $window(@Triggerlist*,%winindex)
    dec %winindex
    if ($PSTL_GetTitle(%windowname,nick) == $scid($window(%windowname).cid).me) {
      .enable #PSTL_psCollectionChanged
      if ($istok(count csvcount path status cd csv,$2,32)) {
        ; Workaround for the jumping scroll position problem. Only update for count when
        ; the line is selected (= manual count, a leech incerementing the count is ignored)
        if (($2 == count) && ($PSTL_GetField(%windowname,sline,trig) != $1)) continue
        .timerPSTL_UPDATE_ $+ $1 $+ _ $+ %windowname 1 0 PSTL_UpdateLine %windowname $1
        .timerPSTL_UPDATE_TITLE_ $+ %windowname -m 1 50 titlebar %windowname --- Nick: $PSTL_GetTitle(%windowname,nick) --- LeechTrig: $PSTL_GetTitle(%windowname,leechtrig) --- Online: $!fline( %windowname ,*??ON $+ $chr(9) $+ *,0) --- Offline: $!fline( %windowname ,*??OFF $+ $chr(9) $+ *,0) --- Total: $!line( %windowname ,0) --- Generated: $PSTL_GetTitle(%windowname,generated) --- Chan: $PSTL_GetTitle(%windowname,chan)
      }
    }
  }
}
#PSTL_psCollectionChanged end




/****************************************************************************************
* Update the line for Trig in Window. @return void
*/
Alias -l PSTL_UpdateLine {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_UpdateLine * $1-
  var %window = $1, %trig = $2
  if (!$window(%window)) return
  var %newline = $PSTL_MakeLine(%trig)
  if (%newline == $null) return
  var %linenum = $PSTL_FindLine(%window,trig,%trig,$sline(%window,1).ln)
  if ((%linenum != $null) && ($line(%window,%linenum) != %newline)) rline %window %linenum %newline
}



/****************************************************************************************
* Generate a triggerlist line for Trig. The invisible filtering / sorting columns are
* included for completeness, so in theory you could construct fully qualified
* triggerlists by calling this alias for every configured trigger (slooow).
* @return line newly generated line, or $null for unconfigured trigger
*/
Alias -l PSTL_MakeLine {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_MakeLine * $1-
  var %trig = $1
  var %trgfile = $PSTC_GetTRG(%trig)
  if (%trgfile == $null) return

  var %path = $lower($readini(%trgfile,n,%trig,path))
  if (%path == $null) return

  var %name = $readini(%trgfile,n,%trig,name)
  if (%name == $null) return

  var %csv = $readini(%trgfile,n,%trig,csv)
  var %count = $readini(%trgfile,n,%trig,count)
  var %csvcount = $readini(%trgfile,n,%trig,csvcount)
  var %size = $readini(%trgfile,n,%trig,size)
  var %rep = $readini(%trgfile,n,%trig,rep)
  var %btstate = $readini(%trgfile,n,%trig,btstate)
  var %status = $iif($readini(%trgfile,n,%trig,status) == OFF,OFF,$iif($isdir(%path),ON,FAIL))
  var %type = $readini(%trgfile,n,info,type)
  var %cd = $upper($readini(%trgfile,n,%trig,cd))
  var %csvfile = $iif(%csv != $null,$nopath(%csv),~Error: No CSV configured~)
  var %flagcsv = $iif($isfile(%csv),C,$chr(32))
  var %flagrep = $iif(%rep != $null,R,$chr(32))

  if ($regex(%csvfile,/\(pre-?final.*\)/i))             var %flagfin = P
  elseif ($regex(%csvfile,/[-_(]fin(al|ished)[-_)]?/i)) var %flagfin = F
  elseif ($regex(%csvfile,/\((re-?burn|revised).*\)/i)) var %flagfin = R
  else                                                  var %flagfin = $chr(32)

  ; Now that we have all the variables retrieved, it's time to add formatting. 
  ; Variables starting with an _underscore are formatted versions, meaning they
  ; have proper color codes and tab separators in them.

  ; %bc = Base Color
  if     (%status == FAIL)    var %bc = 4
  elseif (%status == OFF)     var %bc = 05
  elseif (%btstate == Seed)   var %bc = 09
  elseif (%btstate == Locked) var %bc = 07
  elseif (%status == ON)      var %bc = 03


  if (%type == custom)       var %_name = 12 $+ %name $+ $chr(9)
  elseif (%type == 3rdparty) var %_name = 06 $+ %name $+ $chr(9)
  elseif (%type == private)  var %_name = 06 $+ %name $+ $chr(9)
  elseif (%type == official) var %_name = %bc $+ %name $+ $chr(9)
  else                       var %_name = 07 $+ %name $+ $chr(9)

  var %_trig = %bc $+ $upper(%trig) $+ $chr(9)

  if ((%count == $null) || (%csvcount == $null)) {
    if (%count == $null)    var %_count = 4??? $+ $chr(9)
    else                    var %_count = %bc $+ %count $+ $chr(9)
    if (%csvcount == $null) var %_csvcount = 4??? $+ $chr(9)
    else                    var %_csvcount = %bc $+ %csvcount $+ $chr(9)
  }
  elseif (%count > %csvcount) {
    var %_count = 4 $+ %count $+ $chr(9)
    var %_csvcount = %bc $+ %csvcount $+ $chr(9)
  }
  elseif (%count == %csvcount) {
    var %_count = 10 $+ %count $+ $chr(9)
    var %_csvcount = 10 $+ %csvcount $+ $chr(9)
  }
  else {
    var %_count = %bc $+ %count $+ $chr(9)
    var %_csvcount = %bc $+ %csvcount $+ $chr(9)
  }

  if ((%size == $null) && (%status == ON)) {
    $PSTC_Count(%trig)
    %size = $int($calc($readini(%trgfile,n,%trig,size) / 1024 / 1024))
    var %_size = %bc $+ %size MB $+ $chr(9)
  }
  elseif (%size == $null) {
    var %_size = 4? $+ $chr(9)
  }
  else {
    %size = $int($calc(%size / 1024 / 1024))
    var %_size = %bc $+ %size MB $+ $chr(9)
  }

  if ((%flagrep != R) && (%status == ON) && (%cd == $null)) var %_flagrep = 4? $+ $chr(9)
  else                                                      var %_flagrep = %bc $+ %flagrep $+ $chr(9)
  if (%flagcsv != C)                                        var %_flagcsv = 4? $+ $chr(9)
  else                                                      var %_flagcsv = %bc $+ %flagcsv $+ $chr(9)
  var %_flagfin = %bc $+ %flagfin $+ $chr(9)

  var %_cd = %bc $+ $iif(%cd != $null,%cd,$chr(32)) $+ $chr(9)

  if ((%status == ON) && (%btstate == Locked))   %status = BTL
  elseif ((%status == ON) && (%btstate == Seed)) %status = BTS

  if ($readini(%trgfile,n,%trig,lastdl) > $calc($ctime - 864000)) {
    if (%status == FAIL)     var %_status = 4 $+ %status $+ $chr(9)
    elseif (%status == OFF)  var %_status = 4 $+ %status $+ $chr(9)
    else                     var %_status = 10 $+ %status $+ $chr(9)
  }
  else {
    var %_status = %bc $+ %status $+ $chr(9)
  }



  var %_path = %bc $+ %path $+ $chr(9)
  var %_csvfile = $chr(32) $+ $iif(%flagcsv == C,03,4) %csvfile $+ $chr(9)

  ; Invisible fields for sorting and filtering. Not really needed since @Triggerlist
  ; windows are sorted and filtered only on load, but included here for completeness.
  var %_inv_final = $iif((%flagfin == F) || (%flagfin == R),01<final>,01<ongoing>) $+ $chr(9)
  var %_inv_complete = $iif(%count == %csvcount,01<complete>,01<incomplete>) $+ $chr(9)
  var %_inv_type = 01< $+ $lower(%type) $+ >

  return $+(%_name,%_trig,%_count,%_csvcount,%_size,%_flagrep,%_flagcsv,%_flagfin,%_cd,%_status,%_path,%_csvfile,%_inv_final,%_inv_complete,%_inv_type)
}





/****************************************************************************************
* Find and select the next line starting with $keychar. The mirc built-in function that
* usually does this fails because of color codes.
*/
on *:KEYDOWN:@Triggerlist*:*: {
  if (!$regex($keychar,/\w/)) return 
  var %dummy = $PSTL_FindLine($active,name,$keychar $+ *,$calc($sline($active,1).ln + 1)).select
}



/****************************************************************************************
* Return line number that matches specified search criteria. Searches Window for the
* next line where Field matches Pattern. Wildcards *? are allowed in Pattern. You may
* also specify starting position for the search, the search will wrap at end of window
* so the entire range is evaluated.
* @prop select select the matching line
* @optparam startpos number of the line from where to start the search.
* @return int the matching line number ($null if no matches).
*/
Alias -l PSTL_FindLine {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_FindLine * $1-
  var %window = $1, %field = $2, %pattern = $3, %startpos = $4
  if (%startpos == $null) %startpos = 1
  var %i = 0
  while (%i < $line($1,0)) {
    var %cur_pos = $calc((%startpos + %i) % ($line($1,0) + 1))
    if (%cur_pos == 0) %cur_pos = 1
    if ($3 iswm $PSTL_GetField(%window,%cur_pos,$2)) {
      if ($prop == select) sline $1 %cur_pos    
      return %cur_pos
    }
    inc %i
  }
}


/****************************************************************************************
* Return value of Field on line Num in open Window. You can also specify 'sline' in
* place of line number, to read currently selected line. Strips color and formatting.
* Triggerlists have a single space char in place of missing values (eg cdname for
* unburned collection), $null is returned only if there is some type of error.
* @param num line number or word 'sline'
* @param field fieldname (name, trig, count, csvcount, ...)
* @return string field value, space, or $null
*/
Alias -l PSTL_GetField {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_GetField * $1-
  var %window = $1, %num = $2, %field = $3
  if (%num == sline) {
    var %line = $sline(%window,1)
  }
  else {
    var %line = $line(%window,%num)
  }
  return $PSTL_ExtractField(%line, %field)
}



/****************************************************************************************
* Return value of Field in line of triggerlist text. See above alias for details.
* @param linetext complete line of triggerlist text.
* @param field fieldname (name, trig, count, csvcount, ...)
* @return string field value, space, or $null
*/
Alias -l PSTL_ExtractField {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_ExtractField * $1-
  var %linetext = $1, %field = $2
  if (%field == name)     return $right($gettok(%linetext,1,9), -3)
  if (%field == trig)     return $right($gettok(%linetext,2,9), -3)
  if (%field == count)    return $right($gettok(%linetext,3,9), -3)
  if (%field == csvcount) return $right($gettok(%linetext,4,9), -3)
  if (%field == size)     return $right($gettok(%linetext,5,9), -3)
  if (%field == flagrep)  return $right($gettok(%linetext,6,9), -3)
  if (%field == flagcsv)  return $right($gettok(%linetext,7,9), -3)
  if (%field == flagfin)  return $right($gettok(%linetext,8,9), -3)
  if (%field == cd)       return $right($gettok(%linetext,9,9), -3)
  if (%field == status)   return $right($gettok(%linetext,10,9), -3)
  if (%field == path)     return $right($gettok(%linetext,11,9), -3)
  if (%field == csvfile)  return $right($gettok(%linetext,12,9), -5)
  if (%field == type)     return $right($gettok(%linetext,15,9), -3)
  ; (csvfile is preceded by 2x chr(160), therefore $right is done at -5}
}
























/****************************************************************************************
* Dialog for monitoring unset triggers. Possibly some day other problems too.
*/
dialog PSdlg_TrigAnalysis_Table {
  size 200 200 833 515
  title "Trigger Analysis"
  text "nick" 1, 1 1 1 1, hidden
  box "Archived Lists" 10, 8 5 120 500
  list 11, 19 25 96 450, sort vsbar
  button "Stop Analysis" 12, 19 470 95 24
  box "Results (double click / right click to view the triggers)" 20, 126 5 700 500
  button "MDX Embedded Window" 21, 139 25 675 435
  text "Analysis Complete" 23, 140 476 573 14
  text "MDX Progress Bar" 22, 139 470 675 23
}


/****************************************************************************************
* Dialog init, MDX stuff for progressbar and the embedded result window.
*/
on *:DIALOG:PSdlg_TrigAnalysis:init:*: {
  var %PS = $PS_Mdx(SetMircVersion,$version)
  var %PS = $PS_Mdx(MarkDialog,$dname)
  var %PS = $PS_Mdx(SetControlMDX,22 progressbar smooth > [ $PS_gdll ] )

  window -hl -t7,27,32,37,44 @PS_TrigAnalysis_Results Tahoma 12  
  var %PS = $PS_Mdx(SetControlMDX,21 window > [ $PS_ddll ] )
  aline @PS_TrigAnalysis_Results $+(Trigger,$chr(9),Name,$chr(9),Count,$chr(9),CSV,$chr(9),Last Seen,$chr(9),Status)
  did -a $dname 21 grab $window(@PS_TrigAnalysis_Results).hwnd @PS_TrigAnalysis_Results
  var %PS = $PS_MDX(SetBorderStyle, 21 staticedge)
}


/****************************************************************************************
* Clicked Stop/Resume Analysis button.
*/
on *:DIALOG:PSdlg_TrigAnalysis:sclick:12: {
  %ps_triggerlist_analyze_paused = $iif(%ps_triggerlist_analyze_paused,$false,$true)
  did -ra $dname 12 $iif(%ps_triggerlist_analyze_paused,Resume Analysis,Stop Analysis)
}


/****************************************************************************************
* Double click on date to view list.
*/
on *:DIALOG:PSdlg_TrigAnalysis:dclick:11: {
  if ($did($dname,$did,1).seltext == [Current]) /PSTL_LoadCurrent %ps_triggerlist_analyze_nick %ps_triggerlist_analyze_chan
  else /PSTL_LoadArchived %ps_triggerlist_analyze_leechtrig %ps_triggerlist_analyze_chan $did($dname,$did,1).seltext 
}


/****************************************************************************************
* Exit cleanup on dialog close.
*/
on *:DIALOG:PSdlg_TrigAnalysis:close:*: {
  unset %ps_triggerlist_analyze_*
  hfree -w PSTrigAnalysis
  window -c @PS_TrigAnalysis_Results
  .timerPSTL_Analyze off
  PSTL_CompressArchive
  if ($fopen(PSTLARCHLIST) != $null) .fclose PSTLARCHLIST
}



/****************************************************************************************
* Start the process of analysing Nick's triggerlists from Chan. Opens the dialog, sets
* some global temp variables and starts the RAR-extraction. @return void
*/
Alias PSTL_Analyze {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_Analyze * $1-
  var %nick = $1, %chan = $2

  .timerPSTL_Compress off
  var %dname = PSdlg_TrigAnalysis
  if ($dialog(PSdlg_TrigAnalysis)) dialog -x PSdlg_TrigAnalysis
  dialog -m $+ $PSA_GetDesktopFlag(dialogs) %dname PSdlg_TrigAnalysis_Table
  dialog -t %dname Trigger Analysis for %nick @ %chan
  dialog -r %dname

  var %currfile = $PS_TrigDir(PSTL_Analyze) $+ %chan $+ _ $+ $ps_nickRemove(%nick) $+ .txt"
  if (!$isfile(%currfile)) return

  %ps_triggerlist_analyze_nick = $1
  %ps_triggerlist_analyze_chan = %chan
  %ps_triggerlist_analyze_leechtrig = $remove($PSTL_GetHeader(%currfile,leechtrig),|,<,>,/,\,$,")
  %ps_triggerlist_analyze_linestotal = $lines(%currfile)
  %ps_triggerlist_analyze_linesprocessed = 0

  did -a %dname 11 [CURRENT]
  .timerPSTL_Analyze -m 1 100 /PSTL_ExtractArchived 1
}



/****************************************************************************************
* Spider all archivedirs and extract lists of the target user. Add dates to dialog
* listbox in new -&gt; old order. Count lines for progress bar. Very short (10ms) sleep
* between extractions. Schedule analysis of the [current] list. @return void
*/
Alias -l PSTL_ExtractArchived {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_ExtractArchived * $1-
  var %dirindex = $1
  var %dname = PSdlg_TrigAnalysis
  var %chan = %ps_triggerlist_analyze_chan
  var %dir = $finddir($PS_TrigDir $+ ",????-w??,%dirindex,1)

  if (%dir != $null) {
    .timerPSTL_Analyze -m 1 10 /PSTL_ExtractArchived $calc(%dirindex + 1)
    var %file = %chan $+ _ $+ %ps_triggerlist_analyze_leechtrig $+ .txt
    var %rar = " $+ %dir $+ \ $+ %chan $+ .rar $+ "
    if ($isfile(%rar)) var %ps = $dll($PS_ProgramDir $+ pserve.dll",Run,$PS_ProgramDir $+ rar.exe" e -o+ %rar %file " $+ %dir $+ ")
    if ($isfile(%dir $+ \ $+ %file)) {
      var %fullfile = " $+ %dir $+ \ $+ %file $+ "
      %ps_triggerlist_analyze_linestotal = $calc(%ps_triggerlist_analyze_linestotal + $lines(%fullfile) - 1)
      var %generated = $PSTL_GetHeader(%fullfile,generated)
      var %i = 1
      while ($did(%dname,11,%i) > %generated) inc %i
      did -i %dname 11 %i %generated 
      if ($PSTL_GetHeader(%fullfile,version) < 2) {
        var %result = $PS_RunPserveExeSync(SortTriggerList, %fullfile $PSTL_GetSort(0))
      }
    }
  }
  else .timerPSTL_Analyze -m 1 100 /PSTL_AnalyzeCurrent
}



/****************************************************************************************
* Analyze [current] triggerlist, schedule the first history file to be analyzed.
* @param void @return void
*/
Alias -l PSTL_AnalyzeCurrent {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_AnalyzeCurrent * $1-

  ; The hash table uses TRIG as key, count as value. First step is to process [current] list
  ; and set hash entries for all trigs in it. Then while searching through archived files
  ; simple test "if ($hget(hash,TRIG) != $null)" tells wheater TRIG was in [current] list also.

  var %dname = PSdlg_TrigAnalysis
  var %nick = $ps_nickRemove(%ps_triggerlist_analyze_nick)
  var %chan = %ps_triggerlist_analyze_chan
  if (%ps_triggerlist_analyze_paused) {
    .timerPSTL_Analyze -m 1 500 /PSTL_AnalyzeCurrent
    return
  }

  did -c %dname 11 1

  hfree -w PSTrigAnalysis 
  hmake PSTrigAnalysis 5000
  hadd PSTrigAnalysis *removed* 0
  .fopen PSTLCURRLIST $PS_TrigDir $+ %chan $+ _ $+ %nick $+ .txt"
  .fseek -l PSTLCURRLIST 2
  while (!$feof && !$ferr) {
    var %line = $fread(PSTLCURRLIST) 
    hadd PSTrigAnalysis $PSTL_ExtractField(%line,trig) $PSTL_ExtractField(%line,count)
    inc %ps_triggerlist_analyze_linesprocessed
    did -o %dname 22 1 %ps_triggerlist_analyze_linesprocessed 1 %ps_triggerlist_analyze_linestotal
  }
  .fclose PSTLCURRLIST

  .fopen PSTLARCHLIST $PSTL_ArchiveDir($did(%dname,11,2)) $+ %chan $+ _ $+ %ps_triggerlist_analyze_leechtrig $+ .txt"
  .fseek -l PSTLARCHLIST 2
  .timerPSTL_Analyze -m 1 50 /PSTL_AnalyzeArchive PSTLARCHLIST 2
}







/****************************************************************************************
* Read and analyse 100 lines from Fhandle, starts a timer to analyze the next 100. 
* Closes fhandle at end of file, then opens next file and schedules analysis of it.
* Pauses processing if %ps_triggerlist_analyze_paused is $true.
* @param fhandle open filehandle
* @param listnum number of the open list in the date sidebar
* @return void
*/
Alias -l PSTL_AnalyzeArchive {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_AnalyzeArchive * $1-
  var %fhandle = $1, %listnum = $2, %dname = PSdlg_TrigAnalysis

  if (%ps_triggerlist_analyze_paused) {
    .timerPSTL_Analyze -m 1 500 /PSTL_AnalyzeArchive %fhandle %listnum
    return
  }

  did -c %dname 11 %listnum
  var %date = $did(%dname,11,%listnum)

  var %line = $fread(%fhandle)
  while (!$feof && !$ferr) {
    ; Save massive amounts of time by checking PSTrigAnalysis table before calling PSTL_AnalyzeTriglistLine
    if ($hget(PSTrigAnalysis, $right($gettok(%line,2,9), -3)) == $null) {
      PSTL_AnalyzeTriglistLine %date %line
    }

    inc %ps_triggerlist_analyze_linesprocessed
    if ($calc(%ps_triggerlist_analyze_linesprocessed % 400) == 0) {
      did -o %dname 22 1 %ps_triggerlist_analyze_linesprocessed 1 %ps_triggerlist_analyze_linestotal
      .timerPSTL_Analyze -m 1 20 /PSTL_AnalyzeArchive %fhandle %listnum
      return
    }
    var %line = $fread(%fhandle)
  }
  .fclose %fhandle

  if (%listnum >= $did(%dname,11).lines) {
    did -h %dname 22
    did -v %dname 23
    did -b %dname 12
    did -ra %dname 23 Analysis complete, found $calc($line(@PS_TrigAnalysis_Results,0) - 1) unset trigs
  }
  else {
    var %nextdate = $did(%dname,11,$calc(%listnum + 1))
    .fopen PSTLARCHLIST $PSTL_ArchiveDir(%nextdate) $+ %ps_triggerlist_analyze_chan $+ _ $+ %ps_triggerlist_analyze_leechtrig $+ .txt"
    .fseek -l PSTLARCHLIST 2
    .timerPSTL_Analyze -m 1 25 /PSTL_AnalyzeArchive PSTLARCHLIST $calc(%listnum + 1)
  }
}



/****************************************************************************************
* Analyse archived triggerlist Line and put note in the result window if unset trig is 
* detected. Has some logic to deal with renamed trigs (xxxCD1 &lt;-&gt;> xxxCD01) and
* old filtering errors, but user should still use his own head when interpreting the
* results. @return void
*/
alias -l PSTL_AnalyzeTriglistLine {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_AnalyzeTriglistLine * $1-
  var %date = $1, %line = $2- 

  var %trig = $PSTL_ExtractField(%line,trig), %count = $PSTL_ExtractField(%line,count)
  var %name = $PSTL_ExtractField(%line,name), %csvcount = $PSTL_ExtractField(%line,csvcount)
  var %fin = $PSTL_ExtractField(%line,flagfin), %status = $PSTL_ExtractField(%line,status)
  var %type = $PSTL_ExtractField(%line,type)

  if (%type == <custom>) return
  if (%count < 10) return
  if ((%count < 300) && (csvcount > 1000)) return
  if ($hget(PSTrigAnalysis,%trig) != $null) return

  var %origtrig = %trig
  ; Try adding/removing leading zero(s) from CD-number
  if ($regex(%trig,/^(.+CD)0+(\d+)$/i)) {
    var %zerotrig = $regml(1) $+ $regml(2)
  }
  elseif ($regex(%trig,/^(.+CD)(\d+)$/i)) {
    var %zerotrig = $regml(1) $+ 0 $+ $regml(2)
  }

  while (%trig != $null) { 
    if ($hget(PSTrigAnalysis,%trig) != $null) return
    if (!$psF_TrigIsAllowed(%trig,%ps_triggerlist_analyze_chan)) return
    var %trig = $read($PS_TriggersDir $+ RenHist.txt",ns,%trig)
    if ((%trig == $null) && (%zerotrig != $null)) { %trig = %zerotrig | unset %zerotrig }
  }

  aline @PS_TrigAnalysis_Results $+(%origtrig,$chr(9),%name,$chr(9),%count,$chr(9),%csvcount %fin,$chr(9),%date,$chr(9),%status)
  hadd PSTrigAnalysis %origtrig %count
}



/****************************************************************************************
* Recursive alias moves extracted triggerlists back to the RAR-files. Call without any
* params to start the process. Sleeps 0.5 sec after each compression.
* @optparam dirindex  @optparam fileindex  @return void
*/
Alias -l PSTL_CompressArchive {
  if (%ps_debug_alias != $null) echo $ps_h -st * PSTL_CompressArchive * $1-
  var %dirindex = $1, %fileindex = $2

  if (%dirindex == $null) %dirindex = $finddir($PS_TrigDir $+ ",????-w??,0,1)
  if (%fileindex == $null) %fileindex = 1

  while (%dirindex > 0) {
    var %dir = $finddir($PS_TrigDir $+ ",????-w??,%dirindex,1)
    var %file = $findfile(%dir,#*_!*.txt,%fileindex,1)
    if (%file != $null) {
      .timerPSTL_Compress -m 1 500 /PSTL_CompressArchive %dirindex $calc(%fileindex + 1)
      var %chan = $lower($PSTL_GetHeader(%file,chan))
      var %t = $dll($PS_ProgramDir $+ pserve.dll",Run,$PS_ProgramDir $+ rar.exe" m -o+ -ep -m5 " $+ %dir $+ \ $+ %chan $+ .rar" " $+ %file $+ ")
      .timerPSTL_Compress -m 1 500 /PSTL_CompressArchive %dirindex %fileindex
      return
    }
    dec %dirindex
    var %fileindex = 1
  }
}


menu @PS_TrigAnalysis_Results {
  lbclick: {
    if ($sline($menu,1).ln == 1) return
    var %i = $did(PSdlg_TrigAnalysis,11).lines
    while (%i > 0) {
      if ($gettok($sline($menu,1),5,9) == $did(PSdlg_TrigAnalysis,11,%i).text) did -c PSdlg_TrigAnalysis 11 %i
      dec %i
    }
  }
  dclick: {
    if ($sline($menu,1).ln == 1) return
    PSTL_LoadArchived %ps_triggerlist_analyze_leechtrig %ps_triggerlist_analyze_chan $gettok($sline($menu,1),5,9)
    var %dummy = $PSTL_FindLine(@Triggerlist_Archived_ $+ $ps_netWork,trig,$gettok($sline($menu,1),1,9)).select
  }
  $iif(($sline($menu,0) == 0) || (($sline($menu,1).ln == 1) && ($sline($menu,0) == 1)),$style(2)) Copy To Clipboard: {
    clipboard 
    var %i = 1
    if ($sline($menu,1).ln == 1) inc %i
    while (%i <= $sline($menu,0)) {
      clipboard -a $iif(%i == 1,$null,$crlf) $+ $gettok($sline($menu,%i),1,9) ( $+ $gettok($sline($menu,%i),2,9) $+ ) with count $gettok($sline($menu,%i),3,9) of $gettok($sline($menu,%i),4,9)  $+ , last record $gettok($sline($menu,%i),5,9) $+ , status: $gettok($sline($menu,%i),6,9)
      inc %i
    }
  }
  $iif($sline($menu,0) != 1 || $sline($menu,1).ln == 1,$style(2)) View This Trigger: {
    PSTL_LoadArchived %ps_triggerlist_analyze_leechtrig %ps_triggerlist_analyze_chan $gettok($sline($menu,1),5,9)
    var %dummy = $PSTL_FindLine(@Triggerlist_Archived_ $+ $ps_netWork,trig,$gettok($sline($menu,1),1,9)).select
  }
}
