
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####


/****************************************************************************************
* <b>PSTS - PhotoServe Trigger Setup</b>. PSCC tab for trigger visualisation and manipulation.
* <p>
* <b>Right Click Menu:</b> Overcome the lack of context menus in ListViews by using
* <a href="http://mircscripts.org/comments.php?cid=1768">right click you f***er</a>
* DLL. Menus can only popup for windows, even RCYF needs a host-window for the menu.
* MDX has support for embedded windows, we make one that covers the entire dialog area
* and hide it - hidden embedded window <i>can</i> have popup menus. Possible to have 
* multiple different menus using $submenu, select the one to show based on coordinates
* of the rclick event.
* <p>
* <b>Pserve.exe interface:</b> Load time for pserve.exe exe is annoyingly high, making
* it poorly suited for interactive work. Still, it's the only way to search fast and do 
* complex sorting. To hide the overhead pserve.exe is started when the PSCC is opened
* (dialog init event) and it stays in memory until PSCC is closed. Communication between
* pserve and the exe happens via TCP socket. Pserve opens a listening socket and starts
* the exe, giving the port of the socket in a command line param. Exe then connects to
* that port, and waits for commands. The socket is closed with PSCC (dialog close event), 
* pserve.exe detects this and terminates gracefully.
* <p>
* If pserve.exe is unable to connect to mirc (or the connection is lost for any reason),
* we use the more traditional command line approach. That is, run pserve.exe via pserve.dll
* and the results are ready when the call returns. This is noticeably slower (esp bad when
* searching), but that is something the "unlucky few" are just going to have to live with.
* <p>
* Global variables (settings):<ul>
* <li>%ps.trigsetup.hide_empty_groups -- if $true hide groups with 0 configured triggers (except custom)
* <li>%ps.trigsetup.groupview_as_tree -- if $true show PSC-style treeview instead of flat list
* <li>%ps.trigsetup.sort -- Number of column by which to sort the triggerview
* <li>%ps.trigsetup.show_meta_* -- if $true show the metagroup of this type
* </ul>
*/





/****************************************************************************************
* Init MDX components and start pserve.exe with IPC connection
* @param void @return void
*/
alias PSCC_CreateTab1900 {
  ; Create Host Window for the right click menus
  var %dname = $1
  var %ps = $PS_Mdx(SetControlMDX,1901 window > [ $PS_ddll ] )
  window -hp @PSCC_Rclick
  did -a $dname 1901 grab $window(@PSCC_Rclick).hwnd @PSCC_Rclick

  ; Groupview (tree)
  $PSCC_MakeTreeview(1914, haslines linesatroot hasbuttons showsel notooltips)
  did -i %dname 1914 1 setitemheight 14

  ; Groupview (list)
  $PSCC_MakeListview(%dname,1913, single showsel rowselect report, 250:1 35:2 0:3, +l Name, +l Trigs, +l File)

  ; Trigview 
  $PSCC_MakeListview(%dname,1931, single showsel rowselect report headerdrag, 150:1 80:2 45:3 45:4 45:5 19:6 26:7 60:8 50:9 60:10 100:11 100:12 100:13 100:14, +l Name, +l Trigger, +c Status, +l Count, +l Total, +l R, +l C, +c Backup ID, +l Sends, +l Burn/Rem, +l Path, +l Csv, +l Report, +l Url)

  PSEXE_OpenConnection
}


/****************************************************************************************
* Populate user interface components with data
* @param void @return void
*/
alias PSCC_PopulateTab1900 {
  var %dname = $1

  if (%ps.trigsetup.hide_empty_groups) did -c %dname 1911  
  if (%ps.trigsetup.groupview_as_tree) did -c %dname 1912

  ; Channel filter dropdown
  did -ac %dname 1903 AllChannels
  didtok %dname 1903 59 $PS_Channel(list,active)
  var %activechanline = $didwm(%dname,1903,$eval($+(%,ps.active.,$PS_network,.chan),2))
  if (%activechanline != 0) did -c %dname 1903 %activechanline

  ; Search 
  did -ac %dname 1926 Trig
  did -a %dname 1926 Name
  did -a %dname 1926 CSV
  did -a %dname 1926 Url
  did -a %dname 1926 Backup ID
  did -a %dname 1926 Path

  if ($isdir($PS_UnloadedTriggersDir $+ $PS.Version.date)) {
    did -ra %dname 1919 Restore Empty Groups
    did -b %dname 1911
  }


  .enable #PSTS_psCollectionChanged
  .timer 1 0 PSTS_PopulateGroupview
}
















/****************************************************************************************
* [Re]populate group list. If "hide empty groups" is on, check the .trg file for line
* starting with "path=" - if none are found the group is empty and not displayed. Empty
* custom are groups displayed, however, as the user may have just created that group.
* Takes current filtering setting (drop down box) in to account.
* <p>This alias bypasses the PSTC-API for sake of efficiency. Tests showed that using
* the API would double the time requirement, not acceptable for an already slow
* interactive task. @param void @return void
*/
alias -l PSTS_PopulateGroupview {
  var %dname = PS_Dlg_AX, %chan = $did(%dname,1903).seltext
  var %selgroup = $PSTS_GetSelectedGroup
  window -lsh @PSTS_Grouptemp
  did -r %dname 1913,1914
  if (%ps.trigsetup.groupview_as_tree) {
    did -h %dname 1913
    did -v %dname 1914
  }
  else {
    did -v %dname 1913
    did -h %dname 1914
  } 

  ; Find all .trg files and add their info in the hidden, autosorting window
  var %i = $findfile($PS_TriggersDir, *.trg, 0, 1, PSTS_AddGroupviewWin %chan $1-) 

  ; Copy lines from the window to the dialog. Flat list is very simple (one line),
  ; treeview is a little more coplex as you need to create the subgroups.
  var %i = 1, %prevfolder = $null
  while (%i <= $line(@PSTS_Grouptemp,0)) {
    var %line = $line(@PSTS_Grouptemp,%i)
    var %trgfile = $gettok($gettok(%line,-1,9),-1,32)

    if (!%ps.trigsetup.groupview_as_tree) {
      did -a %dname 1913 %line
    }
    elseif ($numtok(%line,$asc(\)) == 2) {
      did -i %dname 1914 1 cb root
      if ($gettok(%line,1,$asc(\)) != %prevfolder) did -a %dname 1914 $gettok(%line,1,$asc(\))
      did -i %dname 1914 1 cb root last
      did -a %dname 1914 $gettok(%line,2-,$asc(\))
      %prevfolder = $gettok(%line,1,$asc(\))
    }
    else {
      did -i %dname 1914 1 cb root
      did -a %dname 1914 %line
      %prevfolder = $null
    }

    ; Preserve current selection when possible
    if (%selgroup == %trgfile) {
      if (%ps.trigsetup.groupview_as_tree) {
        did -c %dname 1914 $did(%dname,1914).lines
      }
      else {
        did -c %dname 1913 $did(%dname,1913).lines
      }
    }
    inc %i
  }

  did -i %dname 1914 1 cb root
  $PSTS_AddGroupViewMetaGroup(%selgroup, incomplete, Incomplete)
  $PSTS_AddGroupViewMetaGroup(%selgroup, complete, Complete)
  $PSTS_AddGroupViewMetaGroup(%selgroup, unburned, Not Backed Up)
  $PSTS_AddGroupViewMetaGroup(%selgroup, burned, Backed Up)
  $PSTS_AddGroupViewMetaGroup(%selgroup, offline, Offline)
  $PSTS_AddGroupViewMetaGroup(%selgroup, online, Online)
  $PSTS_AddGroupViewMetaGroup(%selgroup, reburn, Reburn)
  $PSTS_AddGroupViewMetaGroup(%selgroup, final, Final)
  $PSTS_AddGroupViewMetaGroup(%selgroup, prefinal, Pre-Final)
  $PSTS_AddGroupViewMetaGroup(%selgroup, ongoing, Ongoing)
  $PSTS_AddGroupViewMetaGroup(%selgroup, torrents, Torrents)

  did -i $+ $iif(%selgroup == search,c) %dname 1913 2 + 0 0 0 [Search] $+ $chr(9) $+ + 0 0 0 - $+ $chr(9) $+ + 0 0 0 search
  did -i %dname 1914 2 + 0 0 0 0 0 [Search] $+ $chr(9) $+ search

  window -c @PSTS_Grouptemp
  PSTS_RepaintGroupControls
  PSTS_PopulateTrigview
}



/****************************************************************************************
* Adds a meta-group to first line of the grouplist. If user has selected that the 
* meta-group specified by Group should not be shown, this a (very slow) no-op.
* @param selgroup currently selected group. This function tries to retain current
* selection in the grouplist. @return void
*/
alias -l PSTS_AddGroupViewMetaGroup {
  var %selgroup = $1, %group = $2, %name = $3-

  var %dname = PS_Dlg_AX
  var %show   = $eval(% $+ ps.trigsetup.show_meta_ $+ %group, 2)
  var %select = $iif(%selgroup == %group, $true, $false)

  if (%ps.trigsetup.groupview_as_tree) {
    if (%show) did -i %dname 1914 2 + 0 0 0 0 0 $chr(91) $+ %name $+ $chr(93) $+ $chr(9) $+ %group
  }
  else {
    if (%show) did -i $+ $iif(%select,c) %dname 1913 2 + 0 0 0 $chr(91) $+ %name $+ $chr(93) $+ $chr(9) $+ + 0 0 0 - $+ $chr(9) $+ + 0 0 0 %group
  }
}






/****************************************************************************************
* Adds data from one .trg file to the temp window (helper for PSTS_PopulateGroupview).
* <p>This alias bypasses the PSTC-API for sake of efficiency. Tests showed that using
* the API would double the time requirement, not acceptable for an already slow
* interactive task.
* @param trgfile full path and filename of a single .trg file @return void
*/
alias -l PSTS_AddGroupviewWin {
  var %chan = $1, %trg = $2-, %group = $nopath(%trg)

  if (!$PSF_GroupIsVisible(%group,%chan)) return
  if (%ps.trigsetup.hide_empty_groups) {
    if (($read(%trg,nw,path=*) == $null) && ($readini(%trg,n,info,type) != custom)) return
  }

  var %folder = $readini(%trg,n,info,subfolder)
  var %name = $readini(%trg,n,info,shortname)
  if (%name == $null) %name = $PSTC_GetGroupShortname(%group)
  if (%ps.trigsetup.groupview_as_tree) {
    if (%folder != $null) {
      aline @PSTS_Grouptemp + 0 0 0 0 0 %folder $+ \ $+ + 0 0 0 0 0 %name $+ $chr(9) $+ %group
    }
    else {
      aline @PSTS_Grouptemp + 0 0 0 0 0 %name $+ $chr(9) $+ %group
    }
  }
  else {
    if (%folder != $null) {
      aline @PSTS_Grouptemp + 0 0 0 %folder - %name $+ $chr(9) $+ + 0 0 0 $calc($ini(%trg,0) - 1) $+ $chr(9) $+ + 0 0 0 %group
    }
    else {
      aline @PSTS_Grouptemp + 0 0 0 %name $+ $chr(9) $+ + 0 0 0 $calc($ini(%trg,0) - 1) $+ $chr(9) $+ + 0 0 0 %group
    }
  }
}



/****************************************************************************************
* Changed channel filter setting.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1903: {
  var %newchan = $did($dname,$did).seltext
  if ($me ison %newchan) set $eval($+(%,ps.active.,$ps_netWork,.chan),1) %newchan
  PSTS_PopulateGroupview
}

/****************************************************************************************
* User toggled "Hide empty groups" 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1911: {
  %ps.trigsetup.hide_empty_groups = $iif($did($dname,$did).state == 1,$true,$false)
  PSTS_PopulateGroupview
}

/****************************************************************************************
* User toggled "Tree List". 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1912: {
  %ps.trigsetup.groupview_as_tree = $iif($did($dname,$did).state == 1,$true,$false)
  PSTS_PopulateGroupview
}


/****************************************************************************************
* Return currently selected Group. This does NOT mean group of the currently selected
* trigger - 'search' and 'torrents' (and possible other future meta-groups) can have
* triggers from any group. It's also possible to have a trigger selected, but no group
* (and vice versa). @param void @return Group group / metagroup, or $null
*/
alias -l PSTS_GetSelectedGroup {
  var %dname = PS_DLG_AX, %listid = 1913, %treeid = 1914

  if ($did(%dname,%treeid).visible) {
    did -i %dname %treeid 1 page select
    var %treepath = $gettok($did(%dname,%treeid,1),4-,32)
    did -i %dname %treeid 1 cb root %treepath up 
    var %branch = $gettok(%treepath,-1,32)
    var %branchtext = $did(%dname,%treeid,%branch)
    if ($numtok(%branchtext,9) == 2) {
      return $gettok(%branchtext,-1,9)
    }
    else {
      ; Selected folder, nothing to show so return null
      return $null
    }
  }
  else {
    return $gettok($did(%dname,%listid).seltext,-1,32)
  }
}


/****************************************************************************************
* Clicked or rightclicked in Groupview (listview). 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1913: {
  var %action = $gettok($did($dname, $did, 1), 1, 32)  
  if (%action == item) {
    PSTS_RepaintGroupControls
    PSTS_PopulateTrigview
  }
}


/****************************************************************************************
* Clicked or rightclicked in Groupview (treeview). 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1914: {
  var %action = $gettok($did($dname, $did, 1), 1, 32)  
  if (%action == slclick) {
    PSTS_RepaintGroupControls
    PSTS_PopulateTrigview
  }
}


/****************************************************************************************
* Enable/disable group buttons depending on what group is selected. Also does the "Add
* Trig" button, even though it is in the TriggerView area. @param void @return void
*/
alias -l PSTS_RepaintGroupControls {
  var %dname = PS_DLG_AX, %selgroup = $PSTS_GetSelectedGroup
  did -b %dname 1915,1918,1939

  if ($PSTC_Iteration(PsMassCount) != $null) {
    if ($PSTC_Iteration(PsMassCount).ispaused) did -rae %dname 1915 Resume Count
    else                                       did -rae %dname 1915 Pause Count
    did -ra %dname 1917 Cancel Count
  }
  else {
    did -ra %dname 1915 Count Group
    did -ra %dname 1917 Count All
  }

  if (*.trg iswm %selgroup) {
    did -e %dname 1915
    if ($PSTC_GetGroupType(%selgroup) == custom) {
      did -e %dname 1939
      if ($ini($PS_TriggersDir $+ %selgroup, 0) < 2) did -e %dname 1918
    }
  }
}



menu @PSCC_Rclick_1913,@PSCC_Rclick_1914 {
  Show Special Groups
  .$iif(%ps.trigsetup.show_meta_torrents, $style(1)) Torrents:  { set %ps.trigsetup.show_meta_torrents $iif(%ps.trigsetup.show_meta_torrents, $false, $true) | PSTS_PopulateGroupView }
  .-
  .$iif(%ps.trigsetup.show_meta_ongoing,  $style(1)) Ongoing:   { set %ps.trigsetup.show_meta_ongoing  $iif(%ps.trigsetup.show_meta_ongoing,  $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_prefinal, $style(1)) Pre-Final: { set %ps.trigsetup.show_meta_prefinal $iif(%ps.trigsetup.show_meta_prefinal, $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_final,    $style(1)) Final:     { set %ps.trigsetup.show_meta_final    $iif(%ps.trigsetup.show_meta_final,    $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_reburn,   $style(1)) Reburn:    { set %ps.trigsetup.show_meta_reburn   $iif(%ps.trigsetup.show_meta_reburn,   $false, $true) | PSTS_PopulateGroupView }
  .-
  .$iif(%ps.trigsetup.show_meta_online,   $style(1)) Online:    { set %ps.trigsetup.show_meta_online   $iif(%ps.trigsetup.show_meta_online,   $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_offline,  $style(1)) Offline:   { set %ps.trigsetup.show_meta_offline  $iif(%ps.trigsetup.show_meta_offline,  $false, $true) | PSTS_PopulateGroupView }
  .-
  .$iif(%ps.trigsetup.show_meta_burned,   $style(1)) Backed Up:    { set %ps.trigsetup.show_meta_burned   $iif(%ps.trigsetup.show_meta_burned,   $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_unburned,   $style(1)) Not Backed Up:    { set %ps.trigsetup.show_meta_unburned   $iif(%ps.trigsetup.show_meta_unburned,   $false, $true) | PSTS_PopulateGroupView }
  .-
  .$iif(%ps.trigsetup.show_meta_complete,   $style(1)) Complete:    { set %ps.trigsetup.show_meta_complete   $iif(%ps.trigsetup.show_meta_complete,   $false, $true) | PSTS_PopulateGroupView }
  .$iif(%ps.trigsetup.show_meta_incomplete,   $style(1)) Incomplete:    { set %ps.trigsetup.show_meta_incomplete   $iif(%ps.trigsetup.show_meta_incomplete,   $false, $true) | PSTS_PopulateGroupView }
  -
  $iif($PSTC_GetGroupType($PSTS_GetSelectedGroup) == custom, $null, $style(2)) Edit .trg File: run notepad $PS_TriggersDir $+ $PSTS_GetSelectedGroup $+ "
}




/****************************************************************************************
* Count Group / Pause Count / Resume Count button
*/
on *:DIALOG:PS_Dlg_AX:sclick:1915: {
  if ($PSTC_Iteration(PsMassCount) == $null) {
    $PSTC_IterateGroupTrigs(PsMassCount, async, $PSTS_GetSelectedGroup, PSTC_Count)
  }
  elseif ($PSTC_Iteration(PsMassCount).ispaused) {
    $PSTC_Iteration(PsMassCount).resume
  }
  else {
    $PSTC_Iteration(PsMassCount).pause
  }
  PSTS_RepaintGroupControls
  .timerPstsMassCount 0 1 if ($PSTC_Iteration(PsMassCount) == $!null) .timerPstsMassCount off $chr(124) PSTS_RepaintGroupControls
}

/****************************************************************************************
* Create Group button.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1916: {
  PSTC_AddCustomGroup
  dialog -v $dname
  PSTS_PopulateGroupview
}

/****************************************************************************************
* Count ALL / Cancel Count button
*/
on *:DIALOG:PS_Dlg_AX:sclick:1917: {
  if ($PSTC_Iteration(PsMassCount) == $null) {
    $PSTC_IterateAllTrigs(PsMassCount, async, PSTC_Count)
  }
  else {
    $PSTC_Iteration(PsMassCount).stop
  }
  PSTS_RepaintGroupControls
  .timerPstsMassCount 0 1 if ($PSTC_Iteration(PsMassCount) == $!null) .timerPstsMassCount off $chr(124) PSTS_RepaintGroupControls
}

/****************************************************************************************
* Remove Group button
*/
on *:DIALOG:PS_Dlg_AX:sclick:1918: {
  $PSTC_RemoveCustomGroup($PSTS_GetSelectedGroup)
  PSTS_PopulateGroupview
}

/****************************************************************************************
* Unload/Reload Empty Groups button
*/
on *:DIALOG:PS_Dlg_AX:sclick:1919: {
  if (!$isdir($PS_UnloadedTriggersDir $+ $PS.Version.date)) {
    var %message = This function unloads groups that have no configured triggers. It is $&
      like having "Hide Empty Groups" permanently on, but unloading the *.trg files will $&
      speed up pserve operation. The groups can be reloaded by pressing the button again, or by $&
      running a trigger update. $+ $crlf $+ $crlf $+ Unload empty trigger files?

    if ($input(%message, yaui, Unload empty groups?)) {
      PSTC_PurgeEmptyGroups
      did -ra $dname 1919 Restore Empty Groups
      set %ps.trigsetup.hide_empty_groups $false
      did -ub $dname 1911
      PSTS_PopulateGroupview
    }
  }
  else {
    PSTC_RestoreEmptyGroups
    did -ra $dname 1919 Unload Empty Groups
    set %ps.trigsetup.hide_empty_groups $false
    did -ue $dname 1911
    PSTS_PopulateGroupview
  }
}



/****************************************************************************************
* Changed search type (cd, path, name, etc)
*/
on *:DIALOG:PS_Dlg_AX:sclick:1926: {
  did -c $dname 1913 2
  did -i $dname 1914 1 cb root
  did -c $dname 1914 2
  PSTS_RepaintGroupControls
  PSTS_PopulateTrigview
}

/****************************************************************************************
* Typed text in search field
*/
on *:DIALOG:PS_Dlg_AX:edit:1927: {
  did -c $dname 1913 2
  did -i $dname 1914 1 cb root
  did -c $dname 1914 2
  PSTS_RepaintGroupControls
  .timerPSTS_Search -m 1 200 PSTS_PopulateTrigview
}

/****************************************************************************************
* Changed the search results range.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1991: {
  var %listviewbuf = $PS_TriggersDir(PSTS_Sclick_1991) $+ ListView.txt"
  loadbuf $did($dname,$did).text -or $dname 1931 %listviewbuf
}






/****************************************************************************************
* Ask pserve exe to create listview buffer for current group. The actual populating of
* listview happens in PSTS_TrigviewLoadbuf, when pserve.exe signals it has completed the
* request made here. @param void @return void
*/
alias -l PSTS_PopulateTrigview {
  var %dname = PS_Dlg_AX, %chan = $did(%dname,1903).seltext, %group = $PSTS_GetSelectedGroup
  did -r %dname 1931
  if ((%group == $null) || (%chan == $null)) return
  PSTS_RepaintTriggerControls

  if (%group == Search) { 
    if ($did(%dname,1927) == $null) return

    ; Determine field by which to search. Here "CSV" actually means "csvfile" (csv path is ignored).
    ; The UI-label "Backup ID" is replaced with "CD" which is the internal name of that field.
    var %field = $did(%dname,1926)
    if (%field == csv) %field = csvfile
    if (%field == backup id) %field = CD

    ; MIME-encode search term to simplify boundary detection
    var %term = $encode($did(%dname,1927),m)
    $PSEXE_WriteConnection(TrigviewSearch $PS.Version.date %field %term %chan $PSTS_GetTrigviewSort(0), PSTS_TrigviewLoadbuf)
  }  
  elseif (*.trg iswm %group) {
    $PSEXE_WriteConnection(TrigviewGroup %group %chan $PSTS_GetTrigviewSort(0), PSTS_TrigviewLoadbuf)
  }
  else {
    $PSEXE_WriteConnection(TrigviewMeta %group %chan $PSTS_GetTrigviewSort(0), PSTS_TrigviewLoadbuf)
  }
}


/****************************************************************************************
* Populate trigview with the content of \Triggers\ListView.txt. If the file contains more
* than 500 lines (possible when searching), show only the first 500 and make the range
* selector visible. This alias is public only because it runs as a callback from another
* module. @param void @return void
*/
alias PSTS_TrigviewLoadbuf {
  var %dname = PS_DLG_AX, %listviewbuf = $PS_TriggersDir(PSTS_TrigviewLoadbuf) $+ ListView.txt"
  did -r %dname 1931

  var %maxtrigs = 500
  did -rac %dname 1991 1- $+ %maxtrigs
  var %lines = $lines(%listviewbuf), %added = %maxtrigs
  while (%lines > %added) {
    if (%lines < $calc(%added + %maxtrigs)) {
      did -a %dname 1991 $calc(%added + 1) $+ - $+ %lines
    }
    else {
      did -a %dname 1991 $calc(%added + 1) $+ - $+ $calc(%added + %maxtrigs)
    }   
    %added = %added + %maxtrigs
  }

  if (%lines == 0) {
    did -a %dname 1931 No matches found
  }
  else {
    loadbuf 1- $+ %maxtrigs -o %dname 1931 %listviewbuf
  }

  ; Hide/unhide the result range selector
  var %h = $dialog(%dname).ch, %w = $dialog(%dname).cw
  if (%lines > %maxtrigs) {
    did -v %dname 1990,1991
    PS_Mdx MoveControl %dname 1931 * 85 $calc(%w - 219) $calc(%h - 220)
  }
  else {
    did -h %dname 1990,1991
    PS_Mdx MoveControl %dname 1931 * 60 $calc(%w - 219) $calc(%h - 195)
  }

  PSTS_RepaintTriggerControls
  return

  ; It is possible, though extremely rare, for the listviewbuf file to disappear after
  ; counting %lines but before doing the /loadbuf. Happpens if you select two groups in
  ; rapid succession and pserve.exe deletes the first listviewbuf before the /loadbuf.
  ; This is harmless but causes an error message, which we suppress right here:
  :error
  reseterror
}

/****************************************************************************************
* Mircscript version of PSTS_PopulateTrigview. Unused. This is slower and does not
* support sorting (but sorting could easily be added). @param void @return void
*/
alias -l PSTS_PopulateTrigview_mircscript {
  var %dname = PS_Dlg_AX, %chan = $did(%dname,1903).seltext, %group = $PSTS_GetSelectedGroup

  did -r %dname 1931
  if ((%group == $null) || (%chan == $null)) return
  PSTS_RepaintTriggerControls
  if (*.trg !iswm %group) return

  $PSTC_IterateGroupTrigs(PSTC_Trigview, sync, %group, PSTS_TrigviewAddTrig_mircscript)
}

/****************************************************************************************
* Helper for PSTS_PopulateTrigview_mircscript (unused). @return void
*/
alias PSTS_TrigviewAddTrig_mircscript {
  var %trig = $1
  did -a PS_Dlg_AX 1931 $PSTS_MakeTrigviewLine(%trig)
}




/****************************************************************************************
* Return currently selected Trig. @param void @return Trig Trigger, or $null
*/
alias -l PSTS_GetSelectedTrig {
  var %dname = PS_DLG_AX, %listid = 1931
  return $right($gettok($did(%dname,%listid,2).seltext,2,9),-10)
}


/****************************************************************************************
* Repaints all trigger controls. This just a cool way of saying it enables the buttons
* that should be enabled, disables that ones that shouldn't, and add correct text to the
* path/csv/url/cd/etc fields. @param void @return void
*/
alias PSTS_RepaintTriggerControls {
  var %dname = PS_DLG_AX, %seltrig = $PSTS_GetSelectedTrig, %selgroup = $PSTS_GetSelectedGroup
  var %focusID = $dialog(%dname).focus

  did -b %dname 1933,1934,1935,1936,1937,1938,1940,1952,1953,1962,1963,1972,1973,1986
  did -r %dname 1933,1951,1961,1971,1981,1983,1985

  if (%ps_servonlytrig != $null) {
    did -rae %dname 1937 Cancel 24h
  }
  elseif (%seltrig != $null) {
    did -ra %dname 1937 24hr Serv
  }


  if (%seltrig == $null) return
  var %seltriggroup = $PSTC_GetGroup(%seltrig)

  did -e %dname 1938,1952,1962,1963,1972,1973
  if ($PSTC_GetType(%seltrig) == custom) did -e %dname 1940
  did -a %dname 1983 $PSTC_GetGroupName(%seltriggroup)
  did -a %dname 1971 $PSTC_GetReport(%seltrig)

  var %csv = $PSTC_GetCSV(%seltrig)
  did -a %dname 1961 %csv

  ;  var %sends = $PSTC_GetSendCount(%seltrig)
  ;  did -a %dname 1981 $iif(%sends != $null,%sends,0)

  var %size = $PSTC_GetSize(%seltrig)
  %size = $round($calc(%size / 1024 / 1024), 0)
  did -a %dname 1981 $iif(%size != $null,%size,0) MB

  var %path = $PSTC_GetPath(%seltrig)
  if (%path != $null) { 
    did -a %dname 1951 %path 
    did -e %dname 1953,1936,1933

    var %status = $PSTC_GetStatus(%seltrig)
    if (%status == OFF) {
      did -ra %dname 1936 Turn ON
    }
    else {
      did -ra %dname 1936 Turn OFF
      did -e %dname 1935,1937
    }
    if (%csv == $null) {
      did -ra %dname 1961 *** Remember to configure CSV also ***
    }
  }

  var %url = $PSTC_GetURL(%seltrig)
  if (%url != $null) {
    did -a %dname 1985 %url
    ; Spaces or lack of dot (.) is a sure sign the URL is not valid:
    if (($pos(%url,$chr(32),1) == $null) && ($pos(%url,.,1) != $null)) did -e %dname 1986
  }

  ; This populates the Backup combobox with all the CD-names from %seltrigfile. First i did
  ; this by looping the trgfile with $ini and $readini, but using regular $read is faster
  if (%path != $null) {
    var %trg = " $+ $PSTC_GetTRG(%seltrig) $+ "
    var %trigcd = $PSTC_GetCD(%seltrig)
    var %somecd = $right($read(%trg,nw,cd=*,1),-3)
    while (%somecd != $null) {
      if ($didwm(%dname,1933,%somecd) == 0) {
        if (%somecd == %trigcd) {
          did -ac %dname 1933 $upper(%somecd)
          did -e %dname 1934
        }
        else {
          did -a %dname 1933 $upper(%somecd)
        }
      }
      %somecd = $right($read(%trg,nw,cd=*,$calc($readn + 1)),-3)
    }
  }

  if (%focusID isnum 1900-1999) did -f %dname %focusID
}


/****************************************************************************************
* Clicked or rightclicked in trigview. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1931: {
  var %action = $gettok($did($dname, $did, 1), 1, 32)  
  if (%action == headerclick) {
    var %column = $gettok($did($dname, $did, 1), 3, 32)
    PSTS_SetTrigviewSort %column
    PSTS_PopulateTrigview
  }
  elseif (%action == item) {
    var %trig = $PSTS_GetSelectedTrig
    if (%trig != $null) $PSTS_UpdateTrigviewLine($did($dname,$did,1).sel,%trig)
    PSTS_RepaintTriggerControls
  }
}


****************************************************************************************
* User doubleclicked on trigger, open trigger configuration dialog.
*/
on *:DIALOG:PS_Dlg_AX:dclick:1931: {
  var %trig = $PSTS_GetSelectedTrig
  if (%trig == $null) return
  $PSTC_ConfigureAll(%trig)
}


/****************************************************************************************
* Set trig backup id by typing name in combobox, or unset by erasing all text
*/
on *:DIALOG:PS_Dlg_AX:edit:1933: {
  var %trig = $PSTS_GetSelectedTrig, %cd = $upper($did($dname,$did).text)
  $PSTC_SetCD(%trig, %cd)
  if (%cd != $null) $PSTC_SetReport(%trig, $null)
}

/****************************************************************************************
* Set trig backup id by selecting an existing one from the combobox
*/
on *:DIALOG:PS_Dlg_AX:sclick:1933: {
  var %trig = $PSTS_GetSelectedTrig, %cd = $upper($did($dname,$did).text)
  $PSTC_SetCD(%trig, %cd)
  if (%cd != $null) $PSTC_SetReport(%trig, $null)
}

/****************************************************************************************
* Set Drive button. Changes path for all trigs that are on the same backup id as
* currently selected trig.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1934: {
  var %trig = $PSTS_GetSelectedTrig

  var %newdrive = $??="Enter the new Drive letter ex. Z"
  dialog -v $dname
  if (%newdrive == $null) return

  var %newdrive = $left($upper(%newdrive),1) $+ :
  if (!$isdir(%newdrive)) {
    echo $ps_n -sat --> The drive $+ $ps_kh %newdrive does 4NOT exist.
    goto end
  }

  var %cdtrigs = $PSTC_GetCDTrigs(%trig)
  var %i = $numtok(%cdtrigs, 32)
  while (%i > 0) {
    var %cdtrig = $gettok(%cdtrigs, %i, 32)
    var %oldpath = $PSTC_GetPath(%cdtrig)
    if (%oldpath == $null) goto nexttrig
    var %newpath = %newdrive $+ $right(%oldpath,-2)
    $PSTC_SetPath(%cdtrig, %newpath)
    dec %i
  }
}

/****************************************************************************************
* Count button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1935: {
  $PSTC_Count($PSTS_GetSelectedTrig)
}

/****************************************************************************************
* On/off button. If the trig is set on CD containing multiple trigs, ask whether the
* other trigs should also be turned on/off.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1936: {
  $PSTC_SetStatus($PSTS_GetSelectedTrig, $gettok($did($did).text,-1,32))
  dialog -v $dname
}

/****************************************************************************************
* 24hr Serv button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1937: {
  if (%ps_servonlytrig != $null) {
    echo $ps_n -st --> Canceled exclusive serv of $+ $ps_kh %ps_servonlytrig 
    unset %ps_servonly*
  }
  elseif ($?!="Do you want to exclusively serve $PSTS_GetSelectedTrig for the next 24hrs?") {
    set %ps_servonlytrig $PSTS_GetSelectedTrig
    set %ps_servonlytime $ctime
    echo $ps_n -st --> Exclusively serving $+ $ps_kh %ps_servonlytrig for the next $+ $ps_kh 24 hrs
    dialog -v $dname
  }
  PSTS_RepaintTriggerControls
}

/****************************************************************************************
* Unset button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1938: {
  $PSTC_UnsetTrig($PSTS_GetSelectedTrig)
  dialog -v $dname
}

/****************************************************************************************
* Add Trig button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1939: {
  $PSTC_AddCustomTrig($PSTS_GetSelectedGroup)
}

/****************************************************************************************
* Rem Trig button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1940: {
  $PSTC_RemoveCustomTrig($PSTS_GetSelectedTrig)
  PSTS_PopulateTrigview
}

/****************************************************************************************
* Browse Path button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1952: {
  $PSTC_ConfigurePath($PSTS_GetSelectedTrig)
}

/****************************************************************************************
* Explore Path button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1953: {
  run explorer.exe /n, /e, " $+ $PSTC_GetPath($PSTS_GetSelectedTrig) $+ "
}

/****************************************************************************************
* Browse CSV button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1962: {
  $PSTC_ConfigureCSV($PSTS_GetSelectedTrig)
}

/****************************************************************************************
* El-Toro button. 
*/
on *:DIALOG:PS_Dlg_AX:sclick:1963: {
  PSCSV_LookupTrig $PSTS_GetSelectedTrig
}

/****************************************************************************************
* Browse Report button. Path and CSV will be set if that info is found in the report.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1972: {
  $PSTC_ConfigureReport($PSTS_GetSelectedTrig)
}

/****************************************************************************************
* !WhereIs button.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1973: {
  $PS_WhereIs($PSTS_GetSelectedTrig)
}

/****************************************************************************************
* Visit Site button.
*/
on *:DIALOG:PS_Dlg_AX:sclick:1986: {
  run $PSTC_GetUrl($PSTS_GetSelectedTrig).valid
}


/****************************************************************************************
* Returns Nth level sorting order, $null if not set. If N = 0, returns all orders
* separated by spaces. If no sortorer has been set, defaults to +name (which also
* means N=0 and N=1 never return $null).
* @prop sign get only the sign part (does not work with N=0)
* @prop nosign get only the Field part (does not work with N=0)
* @return string Nth level sort order
*/
alias -l PSTS_GetTrigviewSort {
  var %n = $1
  if (!$regex(%ps.trigsetup.sort,/^[\+\-\w ]+$/i)) set %ps.trigsetup.sort +name
  if (%n == 0) return %ps.trigsetup.sort
  if ($prop == nosign) return $right($gettok(%ps.trigsetup.sort,$1,32),-1)
  if ($prop == sign)   return $left($gettok(%ps.trigsetup.sort,$1,32),1)
  return $gettok(%ps.trigsetup.sort,$1,32)
}

/****************************************************************************************
* Set primary sorting according to Nth column. Previous primary sorting order becomes new
* secondary sorting order, and so on. If primary sorting order was already set for this
* column, reverse its direction. @return void
*/
Alias -l PSTS_SetTrigviewSort {
  var %n = $1
  if (%n == 1) var %clickedon = name
  elseif (%n == 2) var %clickedon = trig
  elseif (%n == 3) var %clickedon = status
  elseif (%n == 4) var %clickedon = count
  elseif (%n == 5) var %clickedon = csvcount
  elseif (%n == 6) var %clickedon = flagrep
  elseif (%n == 7) var %clickedon = flagcsv
  elseif (%n == 8) var %clickedon = cd
  elseif (%n == 9) var %clickedon = sends
  elseif (%n == 10) var %clickedon = daystooff
  elseif (%n == 11) var %clickedon = path
  elseif (%n == 12) var %clickedon = csvfile
  elseif (%n == 13) var %clickedon = repfile
  elseif (%n == 14) var %clickedon = url
  else return

  if (%clickedon == $PSTS_GetTrigviewSort(1).nosign) {
    var %newsign = $iif($PSTS_GetTrigviewSort(1).sign == -,+,-)
    set %ps.trigsetup.sort $puttok(%ps.trigsetup.sort,%newsign $+ $PSTS_GetTrigviewSort(1).nosign,1,32)
  }
  else {
    set %ps.trigsetup.sort + $+ %clickedon %ps.trigsetup.sort
    if ($numtok(%ps.trigsetup.sort,32) > 4) set %ps.trigsetup.sort $deltok(%ps.trigsetup.sort,5-,32)
  }
}


menu @PSCC_Rclick_Header_1931 {
  $submenu($PSTS_TrigviewHeaderSubmenu($1))
}

/****************************************************************************************
* Options to hide and display trigview colums
* columns. @param n $1 autoincrement variable. @return popup
*/
alias -l PSTS_TrigviewHeaderSubmenu {
  var %n = $1, %dname = PS_DLG_AX, %did = 1931, %titles = Name;Trigger;Status;Count;Total;R;C;Backup ID;Sends;Burn/Rem;Path;Csv;Report;Url;

  did -i %dname %did 1 page headerdims 
  var %currentdims = $gettok($did(%dname, %did, 1),3-,32)
  if (%n <= $numtok(%titles,$asc(;))) {
    return $iif(0:* !iswm $gettok(%currentdims,%n,32),$style(1)) $gettok(%titles,%n,$asc(;)) $+ : PSTS_ToggleTrigviewColumn %n
  } 
  if (%n == 15) return -
  if (%n == 16) return Reset: PSTS_ToggleTrigviewColumn 0
}

/****************************************************************************************
* Toggles the visibility of Colnum in Trigview. Colnum = 0 resets all columns to
* default. @param colnum the number of the column, leftmost being 1 @return void
*/
alias -l PSTS_ToggleTrigviewColumn {
  var %colnum = $1, %dname = PS_DLG_AX, %did = 1931

  did -i %dname %did 1 page headerdims 
  var %currentdims = $gettok($did(%dname, %did, 1),3-,32)
  var %defaultdims = 150:1 80:2 45:3 45:4 45:5 19:6 26:7 60:8 50:9 60:10 100:11 100:12 100:13 100:14

  if (%colnum == 0) {
    %currentdims = %defaultdims
  }  
  elseif (0:* iswm $gettok(%currentdims, %colnum, 32)) {
    %currentdims = $puttok(%currentdims, $gettok(%defaultdims,%colnum,32),%colnum,32)
  }
  else {
    %currentdims = $puttok(%currentdims,0:15,%colnum,32)
  }  
  did -i %dname %did 1 headerdims %currentdims
}




menu @PSCC_Rclick_1931 {
  Say in $eval($+(%,ps.active.,$ps_netWork,.chan),2)
  .$submenu($PSTS_TrigSaySubmenu($1))
  -
  $iif($PSTC_GetCSV($PSTS_GetSelectedTrig).valid == $null, $style(2)) View CSV: run $PS_ProgramDir $+ CSViewer.exe" " $+ $PSTC_GetCSV($PSTS_GetSelectedTrig) $+ "
}


/****************************************************************************************
* Submenu holding a bunch of "say.." menuitems
* items. @param n $1 autoincrement variable. @return popup
*/
alias -l PSTS_TrigSaySubmenu {
  var %n = $1
  var %trig = $PSTS_GetSelectedTrig, %chan = $eval($+(%,ps.active.,$ps_netWork,.chan),2)

  if ($me !ison %chan) {
    if (%n == 1) return Select Channel: did -f PS_DLG_AX 1903
  }
  else {
    if (%trig == $null)                          var %disableall = $style(2), %disableIfOff = $style(2)
    elseif ($PSTC_GetPath(%trig) == $null)       var %disableIfOff = $style(2)
    elseif ($PSTC_GetStatus(%trig).check != ON)  var %disableIfOff = $style(2)

    if (%n == 1) return %disableIfOff Request Trigger:               PS_TrigReq %trig %chan Request
    if (%n == 2) return %disableIfOff Requested Trigger (CD Loaded): PS_TrigReq %trig %chan Loaded
    if (%n == 3) return -
    if (%n == 4) return %disableIfOff Trigger Update Channel News:   PS_TrigNews %trig %chan El-toro
    if (%n == 5) return %disableIfOff Trigger Update Private News:   PS_TrigNews %trig %chan Private
    if (%n == 6) return -
    if (%n == 7) return %disableIfOff Trigger Count:                 PS_TrigStatus %trig %chan Channel
    if (%n == 8) return -
    if (%n == 9) return %disableall !WhereIs %trig :                 PSTS_SayWhereis %trig %chan
  }
}


/****************************************************************************************
* Do a quick whereis for Trig in Chan. @return void
*/
alias -l PSTS_SayWhereis {
  var %trig = $1, %chan = $2

  if ($readini($PS_ServeSettings(PSTS_SayWhereis),n,#Whereis,#Filter) != OFF) {
    dialog -ma PS_WhereIsFilter PS_WhereIsFilter
    did -ra PS_WhereIsFilter 4 %trig
    did -ra PS_WhereIsFilter 6 $calc(1 + $PSTC_GetCount(%trig))
    did -ra PS_WhereIsFilter 10 %chan
  }
  else {
    set %ps_wi_filter_ping $ctime
    if ($PS_WhereIsPing == ON) set -u $+ [ $PS_WhereIsPingtime ] %ps_wi_filter_ping $ctime
    msg %chan !WheReIs $PSL_getWhereIsAddress %trig
  }
}


/****************************************************************************************
* Update trigview line on Linenum for Trig. @return void
*/
Alias -l PSTS_UpdateTrigviewLine {
  var %linenum = $1, %trig = $2, %dname = PS_DLG_AX, %tviewid = 1931
  if (!$dialog(%dname)) return

  if (%trig != $gettok($gettok($did(%dname,%tviewid,%linenum),2,9),5,32)) return
  var %newline = $PSTS_MakeTrigviewLine(%trig)
  if (%newline == $null) return
  if ($did(%dname,%tviewid,1).sel == %linenum) {
    did -o %dname %tviewid %linenum %newline 
    did -c %dname %tviewid %linenum
  }
  else {
    did -o %dname %tviewid %linenum %newline 
  }
}


/****************************************************************************************
* Generates a trigview line for Trig. <p> Bypass PSTC-API for efficiency. For single
* trig we could go via the API without problems, but PSTS_PopulateTrigview_mircscript
* needs the alias to be fast. While currently PSTS_PopulateTrigview_mircscript is not
* used, it might be some day. @return String trigview line or $null
*/
alias -l PSTS_MakeTrigviewLine {
  var %trig = $1
  if (%trig == $null) return
  var %trg = $PSTC_GetTRG(%trig)
  if (!$isfile(%trg)) return

  var %name = $readini(%trg, n, %trig, name)
  if (%name == $null) return

  var %trig = $upper(%trig)

  var %path = $readini(%trg, n, %trig, path)

  if (%path == $null) {
    var %status = $null
  }
  else {
    var %status = $iif($readini(%trg,n,%trig,status) == OFF, OFF, $iif($isdir(%path),ON,FAIL))
    var %btstate = $readini(%trg, n, %trig, btstate)
    if (%btstate == locked) %status = BT Leech
    if (%btstate == seed)   %status = BT Seed
  }

  var %count = $readini(%trg, n, %trig, count)
  var %csvcount = $readini(%trg, n, %trig, csvcount)
  var %csvfile = $nopath($PSTC_GetCSV(%trig))
  var %repfile = $nopath($readini(%trg, n, %trig, rep))
  var %cd = $upper($readini(%trg, n, %trig, cd))
  var %flagcsv = $iif(%csvfile != $null, C, $null)
  var %flagrep = $iif(%repfile != $null, R, $null)
  var %sends = $readini(%trg, n, %trig, sends)
  if ((%path != $null) && (%sends == $null)) %sends = 0
  var %url = $readini(%trg, n, %trig, url)

  if ($regex(%csvfile, /\(pre-?final.*\)/i))             var %flagfin = P
  elseif ($regex(%csvfile, /[-_(]fin(al|ished)[-_)]?/i)) var %flagfin = F
  elseif ($regex(%csvfile, /\((re-?burn|revised).*\)/i)) var %flagfin = R
  else                                                  var %flagfin = $null

  var %lastdl = $readini(%trg, n, %trig, lastdl)

  if (%status == $null) {
    var %daystooff = $null 
  }
  elseif ((%flagfin == F) || (%flagfin == R)) {
    var %daystooff = $round($calc((%lastdl + 864000 - $ctime) / 86400), 1);
    if (%daystooff > 0) %daystooff = in %daystooff days
    else %daystooff = OK
  }
  else { 
    var %daystooff = $null
  }

  ; Now that we have all the variables retrieved, it's time to add formatting. 
  ; Variables starting with an _underscore are formatted versions, meaning they
  ; have the leading "+ 0 0 0" required by MDX and tab separators in them.

  var %_name = + 0 0 0 %name $+ $chr(9)
  var %_trig = + 0 0 0 %trig $+ $chr(9)
  var %_status = + 0 0 0 %status $+ $chr(9)

  if ((%count != $null) && (%csvcount == $null)) {
    var %_count = + 0 0 0 ~ $+ %count $+ ~ $+ $chr(9)
    var %_csvcount = + 0 0 0 $chr(9)
  }
  elseif (%count > %csvcount) {
    var %_count = + 0 0 0 ~ $+ %count $+ ~ $+ $chr(9)
    var %_csvcount = + 0 0 0 %csvcount $+ $chr(9)
  }
  else  {
    var %_count = + 0 0 0 %count $+ $chr(9)
    var %_csvcount = + 0 0 0 %csvcount $+ $chr(9)
  }

  var %_flagrep = + 0 0 0 %flagrep $+ $chr(9)
  var %_flagcsv = + 0 0 0 %flagcsv $+ %flagfin $+ $chr(9)
  var %_cd = + 0 0 0 %cd $+ $chr(9)
  var %_sends = + 0 0 0 %sends $+ $chr(9)
  var %_daystooff = + 0 0 0 %daystooff $+ $chr(9)
  var %_path = + 0 0 0 %path $+ $chr(9)
  var %_csvfile = + 0 0 0 %csvfile $+ $chr(9)
  var %_repfile = + 0 0 0 %repfile $+ $chr(9)
  var %_url = + 0 0 0 %url $+ $chr(9)

  return $+(%_name,%_trig,%_status,%_count,%_csvcount,%_flagrep,%_flagcsv,%_cd,%_sends,%_daystooff,%_path,%_csvfile,%_repfile,%_url)
}


/****************************************************************************************
* Update trigview and repaint buttons when collections change.
*/
#PSTS_psCollectionChanged off
on *:SIGNAL:psCollectionChanged: {
  var %trig = $1, %setting = $2, %newvalue = $3-, %dname = PS_DLG_AX
  var %trigviewID = 1931, %cdcomboID = 1933, %cddriveID = 1934

  if (!$dialog(%dname)) {
    .disable #PSTS_psCollectionChanged
    return
  }

  ; Update trigger manipulation buttons and associated info. Full repaint steals
  ; focus (really bad when you are typing new CD name), so avoid if not needed.
  if (%trig == $PSTS_GetSelectedTrig) {
    if ((%setting == cd) && ($did(%dname,%cdcomboID).seltext == %newval)) did - $+ $iif(%newvalue != $null,e,b) %dname %cddriveID
    elseif (%setting == rep) did -ra %dname 1971 %newvalue
    elseif ($istok(path status csv url cd,%setting,32)) PSTS_RepaintTriggerControls
  }

  ; Setting/Unsetting a name probably means a custom trigger was added/removed - repopulate
  if (%setting == name) {
    PSTS_PopulateTrigview
    PSTS_PopulateGroupview
  }

  ; Update trigger info in listview
  if (!$istok(count csvcount path status cd csv sends url rep,$2,32)) return
  var %lineindex = $did(%dname,%trigviewID).lines
  while (%lineindex > 1) {
    if (%trig == $gettok($gettok($did(%dname,%trigviewID,%lineindex),2,9),5,32)) {
      .timerPSTS_UPDATE_TRIG_ $+ %trig 1 0 PSTS_UpdateTrigviewLine %lineindex %trig
      return
    }
    dec %lineindex
  }
}
#PSTS_psCollectionChanged end


/****************************************************************************************
* Move controls on dialog resize.
* @param w new width of the dialog @param h new height of the dialog @return void
*/
alias PSCC_ResizeTab1900 {
  var %w = $1, %h = $2, %dname = $3

  ;Groupbox
  PS_Mdx MoveControl %dname 1910 * * * $calc(%h - 122)
  PS_Mdx MoveControl %dname 1913 * * * $calc(%h - 243)
  PS_Mdx MoveControl %dname 1914 * * * $calc(%h - 243)
  PS_Mdx MoveControl %dname 1915 * $calc(%h - 130) * *
  PS_Mdx MoveControl %dname 1916 * $calc(%h - 130) * *
  PS_Mdx MoveControl %dname 1917 * $calc(%h - 106) * *
  PS_Mdx MoveControl %dname 1918 * $calc(%h - 106) * *
  PS_Mdx MoveControl %dname 1919 * $calc(%h - 82) * *
  PS_Mdx MoveControl %dname 1920 * $calc(%h - 82) * *

  ; Searchbox
  PS_Mdx MoveControl %dname 1925 * $calc(%h - 58) * *
  PS_Mdx MoveControl %dname 1926 * $calc(%h - 40) * *
  PS_Mdx MoveControl %dname 1927 * $calc(%h - 40) * *

  ; Triggerbox (The height of trigview depends on whether the result range selector is visible)
  PS_Mdx MoveControl %dname 1930 * * $calc(%w - 209) $calc(%h - 50)
  PS_Mdx MoveControl %dname 1931 * * $calc(%w - 219) $calc(%h - $iif($did(%dname,1990).visible,220,195))
  PS_Mdx MoveControl %dname 1932 * $calc(%h - 125) * *
  PS_Mdx MoveControl %dname 1933 251 $calc(%h - 130) * *
  PS_Mdx MoveControl %dname 1934 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1935 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1936 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1937 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1938 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1939 * $calc(%h - 131) * *
  PS_Mdx MoveControl %dname 1940 * $calc(%h - 131) * *

  PS_Mdx MoveControl %dname 1950 * $calc(%h - 102) * *
  PS_Mdx MoveControl %dname 1951 * $calc(%h - 106) * *
  PS_Mdx MoveControl %dname 1952 * $calc(%h - 106) * *
  PS_Mdx MoveControl %dname 1953 * $calc(%h - 106) * *

  PS_Mdx MoveControl %dname 1960 * $calc(%h - 78) * *
  PS_Mdx MoveControl %dname 1961 * $calc(%h - 82) * *
  PS_Mdx MoveControl %dname 1962 * $calc(%h - 82) * *
  PS_Mdx MoveControl %dname 1963 * $calc(%h - 82) * *

  PS_Mdx MoveControl %dname 1970 * $calc(%h - 54) * *
  PS_Mdx MoveControl %dname 1971 * $calc(%h - 58) * *
  PS_Mdx MoveControl %dname 1972 * $calc(%h - 58) * *
  PS_Mdx MoveControl %dname 1973 * $calc(%h - 58) * *

  PS_Mdx MoveControl %dname 1980 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1981 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1982 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1983 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1984 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1985 * $calc(%h - 30) * *
  PS_Mdx MoveControl %dname 1986 * $calc(%h - 34) * *
}


/****************************************************************************************
* Pserve fly-over help (tooltips)
*/
on *:DIALOG:PS_Dlg_AX:mouse:*: {
  if ((%PS_help_on == on) && ($dialog($dname).tab == 1900)) {
    var %x = $mouse.x, %y = $mouse.y, %h = $dialog($dname).ch, %w = $dialog($dname).cw
    ; Uncomment to draw a red rectacangle to help determine box coordinates
    ;  clear @PSCC_Rclick
    ;  drawrect -c @PSCC_Rclick 4 2 130 87 60 16
    ;  did - $+ $iif($did($dname,1901).visible,h,v) $dname 1901

    if ($inrect(%x,%y,48,48,150,25))                 { did -a $dname 997 Show triggers and groups available in #Channel. "AllChannels" shows all triggers | return }
    if ($inrect(%x,%y,14,87,110,16))                 { did -a $dname 997 Hide groups with zero configured triggers from the list below. Does not apply to custom groups | return }
    if ($inrect(%x,%y,130,87,60,16))                 { did -a $dname 997 Toggle PSC-style TreeView for the group list | return }
    if ($inrect(%x,%y,12,126,170,$calc(%h - 260)))   { did -a $dname 997 Select a group to view its triggers | return }
    if ($inrect(%x,%y,14,$calc(%h - 130),88,22))     { did -a $dname 997 Count all online triggers in selected group | return }
    if ($inrect(%x,%y,14,$calc(%h - 106),88,22))     { did -a $dname 997 Count all online triggers in ALL groups. ***This can take a VERY long time if you have many online triggers*** | return }
    if ($inrect(%x,%y,14,$calc(%h - 82),182,22))     { did -a $dname 997 Unload/reload groups with zero configured triggers. Unloading can sometimes significantly improve performance | return }
    if ($inrect(%x,%y,108,$calc(%h - 130),88,22))    { did -a $dname 997 Adds new custom group to the list | return }
    if ($inrect(%x,%y,108,$calc(%h - 106),88,22))    { did -a $dname 997 Remove selected custom group. The group must be empty, remove triggers first | return }
    if ($inrect(%x,%y,14,$calc(%h - 41),66,22))      { did -a $dname 997 Select the field which you want searhed | return }
    if ($inrect(%x,%y,84,$calc(%h - 41),110,22))     { did -a $dname 997 Type the string you are searching for in here. The search is executed when you stop typing | return }
    if ($inrect(%x,%y,208,60,$calc(%w - 222),20))    { did -a $dname 997 Right Click to hide columns. You can also resize or reorder the columns by dragging with mouse | return }
    if ($inrect(%x,%y,208,80,$calc(%w - 222),$calc(%h - 228)))  { did -a $dname 997 Select a trigger to manipulate. Double click to open "old" trigger configuration dialog. | return }
    if ($inrect(%x,%y,250,$calc(%h - 130),90,20))    { did -a $dname 997 Set trigger backup ID typing the name here, or by selecting existing ID from the menu. Erase text to unset backup status | return }
    if ($inrect(%x,%y,343,$calc(%h - 132),60,24))    { did -a $dname 997 Change the drive letter for all trigger on this backup | return }
    if ($inrect(%x,%y,419,$calc(%h - 132),60,24))    { did -a $dname 997 Updates file count for the selected trigger | return }
    if ($inrect(%x,%y,481,$calc(%h - 132),60,24))    { did -a $dname 997 Turn selected trigger (or CD, you will be prompted if this is a multi-trig CD) ON or OFF | return }
    if ($inrect(%x,%y,543,$calc(%h - 132),60,24))    { did -a $dname 997 Your PhotoServe will only send files from the specified trigger for 24 hrs.  Useful for sending updates for popular triggers | return }
    if ($inrect(%x,%y,605,$calc(%h - 132),60,24))    { did -a $dname 997 Unset selected trigger. Custom triggers can be unset without limitations, others only if the count is below 300 | return }
    if ($inrect(%x,%y,667,$calc(%h - 132),60,24))    { did -a $dname 997 Add new trigger to selected custom group | return }
    if ($inrect(%x,%y,729,$calc(%h - 132),60,24))    { did -a $dname 997 Completely remove selected custom trigger | return }
    if ($inrect(%x,%y,667,$calc(%h - 107),60,24))    { did -a $dname 997 Set new path for selected trigger | return }
    if ($inrect(%x,%y,729,$calc(%h - 107),60,24))    { did -a $dname 997 Open the path of selected trigger in Windows Explorer | return }
    if ($inrect(%x,%y,667,$calc(%h - 83),60,24))     { did -a $dname 997 Set CSV for the selected trigger. You MUST set CSV for triggers that also have path set | return }
    if ($inrect(%x,%y,729,$calc(%h - 83),60,24))     { did -a $dname 997 Check online CSV repository for latest CSV of the selected trigger | return }
    if ($inrect(%x,%y,667,$calc(%h - 59),60,24))     { did -a $dname 997 Set report for the selected trigger. You MUST have a report for all online triggers that have not been backed up | return }
    if ($inrect(%x,%y,729,$calc(%h - 59),60,24))     { did -a $dname 997 Do a !WhereIs for the selected trigger | return }
    if ($inrect(%x,%y,729,$calc(%h - 35),60,24))     { did -a $dname 997 Visit the website of this trigger | return }
    return
  }
}



/****************************************************************************************
* Save header settings and free resources on dialog close.
*/ 
on *:DIALOG:PS_Dlg_AX:close:0: {
  PSEXE_CloseConnection
  window -c @PSCC_Rclick
  if ($isfile($PS_TriggersDir $+ ListView.txt")) .remove $PS_TriggersDir $+ ListView.txt"
  .disable #PSTS_psCollectionChanged
  .timerPstsMassCount off
}



/****************************************************************************************
* Open a listening socket and launch pserve.exe with instructions to connect to it. It is
* safe to call this alias multiple times, if the connection is already open this is a no-op.
* @param void @return void
*/ 
alias PSEXE_OpenConnection {
  ; Create the listening socket in a random port
  if ($sock(PSERVE_EXE_IPC*) == $null) {
    var %randport = $rand(1024, 65535)
    while (!$portfree(%randport)) %randport = $rand(1024, 65535)
    socklisten -d 127.0.0.1 PSERVE_EXE_IPC_LISTEN %randport
  }
  ; Launch pserve.exe and create a timer to close the listening socket in case pserve.exe does not connet
  if ($sock(PSERVE_EXE_IPC) == $null) {
    $PS_RunPserveExeAsync(ConnectSocket, $sock(PSERVE_EXE_IPC_LISTEN).bindport)
    .timerPSEXE_CloseListeningSock 1 15 if ($ $+ sock(PSERVE_EXE_IPC_LISTEN)) sockclose PSERVE_EXE_IPC_LISTEN
  }
}

/****************************************************************************************
* Accept connection from pserve.exe and close the listening socket
*/ 
on *:socklisten:PSERVE_EXE_IPC_LISTEN: {
  sockaccept PSERVE_EXE_IPC
  sockclose  PSERVE_EXE_IPC_LISTEN
}

/****************************************************************************************
* Send a command to pserve.exe over the IPC connection. Pserve.exe will execute
* the connection and reply with the callback, which is then executed in the sockread
* event handler. If the IPC connection is down we instead run pserve.exe syncronously
* and execute the callback immediately when pserve.exe returns.
* @param command command and params for pserve.exe (only special socket commands!)
* @param callback mirc callback to execute upon return. 
* @return void
*/ 
alias PSEXE_WriteConnection {
  var %command = $1, %callback = $2

  if ($sock(PSERVE_EXE_IPC) != $null) {
    ; The six colons separate command and callback (not very robust but enough)
    sockwrite -n PSERVE_EXE_IPC %command :::::: %callback
  }
  else {
    var %result = $PS_RunPserveExeSync(RunSocketCommand, %command)
    %callback
  }
}


/****************************************************************************************
* Read callback from the pserve.exe IPC connection and execute it.
*/
on *:sockread:PSERVE_EXE_IPC: {
  var %callback
  sockread %callback
  %callback
}


/****************************************************************************************
* Close pserve.exe IPC connection @param void @return void
*/
alias PSEXE_CloseConnection {
  sockclose PSERVE_EXE_IPC*
}
