;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####

alias -l GeneralInit {
  echo -set -> $script init. Mirc $version - PhotoServe $PS.Version $PS.Version.beta
  titlebar $version - PhotoServe $PS.Version $PS.Version.beta
}

on *:SIGNAL:PSUPDATEDONE:{
  GeneralInit
}
on *:start:{
  GeneralInit
}


alias PS.Version {
  var %ps_a = PS_Version
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version * $1-

  return $+($PS.Version.main,.,$PS.Version.date)
}


alias PS.Version.main {
  var %ps_a = PS_Version_Main
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Main * $1-

  return 4.20
}


alias PS.Version.beta {
  var %ps_a = PS_Version_Beta
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Beta * $1-

  return +n/a
}


alias PS.Version.date {
  var %ps_a = PS_Version_Date
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Date * $1-

  if ($isfile($PS.Version.date.file)) {
    var %ps_temp_read = $remove($read($PS.Version.date.file,n,1),Date:)
    if (%ps_temp_read == $null) var %ps_temp_read = none
    return %ps_temp_read
  }
  else return n/a
}


alias PS.Version.date.file {
  var %ps_a = PS_Version_Date_File
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Date.File * $1-

  ;; > no need to copy any random datefile to the triggers > $PS.Version.date.file.move
  var %ps_temp = $PS_TriggersDir(PS.Version.date.file) $+ PSTrigRev.txt $+ "
  if (!$isfile(%ps_temp)) $PS_Write(PS.Version.date.file,%ps_temp,n/a)
  return %ps_temp
}


alias PS.Version.date.file.move {
  var %ps_a = PS_Version_Date_File_Move
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Date.File.Move * $1-

  var %ps_temp = $+(",$findfile($mircdir,PSTrigRev.txt,1,2),")
  if (%ps_temp != $null) {
    $PS.Version.date.file.copy(%ps_temp,go)
    $PS.Version.date.file.delete(%ps_temp)
  }
}


alias PS.Version.date.file.copy {
  var %ps_a = PS_Version_Date_File_Copy
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Date.File.Copy * $1-

  .copy -o $1 $+($PS_TriggersDir(ps.version.date.file.copy),$nopath($1),")
}


alias PS.Version.date.file.delete {
  var %ps_a = PS_Version_Date_File_Delete
  if (%ps_debug_alias != $null) echo $ps_h -st * PS.Version.Date.File.Delete * $1-

  .timer 1 0 .remove $1
}
