
;  PhotoServe 4.20

; ##### Disabling functions or modifying the PhotoServe script will earn you a permanent ban.  NO excuses. #####
; ##### If you have found a problem or are looking to make an enhancement please see a PhotoServe author or Channel Operator (in that order) before proceeding #####



/****************************************************************************************
* <b>PSDV - PhotoServe Dialog Viewer</b> - PSCC Tab for reviewing recent download history
* <p>
* Pserve components that handle downloaded files log transfers using a set of
* <code>PSDV_LogXXXXXX</code> aliases provided here. The log is stored in MDX-listview
* format so it can /loadbuf'd or /filter'd directly to the list (fast). An auxiliary file
* is maintained that tracks which triggers can be found in the main log. This index file
* is used for populating the Trig-filter combobox, sparing us from having to read the
* entire mainlog line by line.
* <p>
* Global variables (settings):<ul>
* <li>%ps.viewer.filter.lines -- How many files at most to show in the listview
* <li>%ps.viewer.filter.trig  -- Show 'Samples', 'All Leeches', 'Misc Downloads', 'Everything' or TRIGGER
* <li>%ps.viewer.filter.type  -- Show 'Pictures', 'Non-Pics', 'All Content'
* <li>%ps.viewer.divider.pos  -- X coordinate of the divider control
* <li>%ps.viewer.disable_large_file_bugfix -- Scaneater wanted a way to disable this (sloooow system9
* </ul>
* Transient globals:<ul>
* <li>%ps_viewer_sortcolumn -- Column number by which to sort. Sort by leech order if not set
* </ul>
*/





/****************************************************************************************
* Select specified line of Text in combobox ID in dialog Dname. If the text is not found
* nothing is done (current selection remains).
* @param dname dialog name
* @param id id of the combobox control
* @param text the text to search and select
* @return void
*/
alias PS_ComboSelect {
  var %dname = $1, %id = $2, %text = $3-
  var %i = $did(%dname, %id).lines
  while (%i > 0) {
    if ($did(%dname, %id, %i).text == %text) did -c %dname %id %i
    dec %i
  }
}



/****************************************************************************************
* This alias is called when PSCC is opened. Only the absolute minimum amount of work
* should be done here, in this case MDX'ifying the ListView component. All other
* initialisation work is perform on-demand in PSCC_PopulateTab2200
* @param void @return void
*/
alias PSCC_CreateTab2200 {
  var %dname = $1
  unset %ps.viewer.headerdims

  var %ps = $PS_Mdx(SetControlMDX, %dname 2210 window > [ $PS_ddll ] )
  window -hp @PSCC_Rclick
  did -a %dname 2210 grab $window(@PSCC_Rclick).hwnd @PSCC_Rclick

  $PSCC_MakeListview(%dname,2210, single showsel rowselect report infotip headerdrag, 70:1 70:2 130:3 400:4, +l Trig, +l Nick, +l File, +l Path)

  var %PS = $PS_Mdx(SetControlMDX, 2211 divider vertical > [ $PS_gdll ] )

  ; Make sure people can't entirely lose the divider (these seem to be a good values for that)
  if (%ps.viewer.divider.pos < 20) set %ps.viewer.divider.pos 20
  if (%ps.viewer.divider.pos >= $calc($dialog(%dname).w - 20)) set %ps.viewer.divider.pos $calc($dialog(%dname).w - 20)
  if (%ps.viewer.divider.pos != $null) PS_Mdx MoveControl %dname 2211 %ps.viewer.divider.pos * * *
}


/****************************************************************************************
* This alias is called when Tab 2200 is first made visible. If the user clicks on another
* tab and then back to 2200, this alias is NOT called again. @param void @return void
*/
alias PSCC_PopulateTab2200 {
  var %dname = $1

  did -r %dname 2202,2204,2206

  if (%ps.viewer.filter.lines == $null) set %ps.viewer.filter.lines 250
  did -a %dname 2202 250
  did -a %dname 2202 500
  did -a %dname 2202 1000
  did -a %dname 2202 2000
  did -a %dname 2202 3000
  did -a %dname 2202 4000
  did -a %dname 2202 5000
  PS_ComboSelect %dname 2202 %ps.viewer.filter.lines

  if (%ps.viewer.filter.type == $null) set %ps.viewer.filter.type Pictures
  did -a %dname 2204 Pictures
  did -a %dname 2204 Non-Pics
  did -a %dname 2204 All Content
  PS_ComboSelect %dname 2204 %ps.viewer.filter.type

  if (%ps.viewer.filter.trig == $null) set %ps.viewer.filter.type All Leeches
  var %inifile = $PSDV_IndexFile
  did -a %dname 2206 All Leeches
  did -a %dname 2206 Misc Downloads
  did -a %dname 2206 Samples
  did -a %dname 2206 Everything
  did -a %dname 2206 ----------------------
  var %i = $ini(%inifile, downloads, 0)
  while (%i > 0) {
    var %trig = $ini(%inifile, downloads, %i)
    if ((<*> !iswm %trig) && (%trig != N/A)) {
      did -a %dname 2206 $upper(%trig)
    }
    dec %i
  }
  ; If %ps.viewer.filter.trig is invalid (trig no longer in logs) the All Leeches selection will remain:
  PS_ComboSelect %dname 2206 All Leeches
  PS_ComboSelect %dname 2206 %ps.viewer.filter.trig

  ; Autoswitch allways on by default
  did -c %dname 2209

  $PSDV_PopulateList($did(%dname,2206).text, $did(%dname,2204).text, %ps.viewer.filter.lines, %dname)
}


/****************************************************************************************
* This alias is called to lay out Tab 2200 when PSCC is resized. The visible tab is
* resized "live", whereas invisible tabs are resized only at the end when user releases
* the mouse button. This makes resizing somewhat smoother experience.
* @param w new width of the dialog @param h new height of the dialog @return void
*/
alias PSCC_ResizeTab2200 {
  var %w = $1, %h = $2, %dname = $3
  var %divl = $gettok($did(%dname, 2211),3,32)
  var %divr = $gettok($did(%dname, 2211),4,32)
  if (%divl !isnum) return

  PS_Mdx MoveControl %dname 2210 * * $calc(%divl - 5) $calc(%h - $dbuh * 65)
  PS_Mdx MoveControl %dname 2211 * * * $calc(%h - $dbuh * 27)
  PS_Mdx MoveControl %dname 2250 %divr * $calc(%w - %divr - 6) $calc(%h - $dbuh * 25)
  PS_Mdx MoveControl %dname 2251 $calc(%divr + 2) * $calc(%w - %divr - 10) $calc(%h - $dbuh * 30)
}


/****************************************************************************************
* User moved divider. 
*/
on *:DIALOG:PS_DLG_AX:sclick:2211: {
  var %action = $gettok($did($dname, $did),1,32)
  if (%action == move) {
    $PSCC_ResizeTab2200($dialog($dname).cw, $dialog($dname).ch, $dname)
    set %ps.viewer.divider.pos $gettok($did($dname, $did),3,32)
  }
}





/****************************************************************************************
* Reset button - clear list and Trig-filters, delete logs
*/
on *:DIALOG:PS_DLG_AX:sclick:2207 {
  did -r $dname 2210
  if ($did($dname, 2206, 1).sel > 4) did -c $dname 2206 1
  while ($did($dname, 2206).lines > 5) {
    did -d $dname 2206 6
  }
  .remove $PSDV_LogFile
  .remove $PSDV_IndexFile
  did -ra $dname 2250 Viewer (click for fullscreen)
  did -g $dname 2251 $PS_IconDir $+ placeholder.png"
  did -b $dname 2208
}

/****************************************************************************************
* External Viewer button
*/
on *:DIALOG:PS_DLG_AX:sclick:2208 {
  var %file = $PSDV_GetSelectedFile($dname)
  if ($isfile(%file)) run %file
}

/****************************************************************************************
* Autoswitch checkbox
*/
on *:DIALOG:PS_DLG_AX:sclick:2209 {
  did -c $dname 2210 $did($dname,2210).lines
  if ($did($did).state == 1) {
    PSDV_DisplaySelected $dname
  }
}

/****************************************************************************************
* Repopulate listview when options in any of the three comboxes change.
*/
on *:DIALOG:PS_DLG_AX:sclick:2202,2204,2206 {
  if ($did($dname, 2206).text == ----------------------) did -c $dname 2206 4
  set %ps.viewer.filter.lines $did($dname, 2202).text
  set %ps.viewer.filter.type  $did($dname, 2204).text
  set %ps.viewer.filter.trig  $did($dname, 2206).text
  $PSDV_PopulateList(%ps.viewer.filter.trig, %ps.viewer.filter.type, %ps.viewer.filter.lines, $dname)
}

/****************************************************************************************
* Display image and repaint buttons when a file is selected from the listview. If the
* list header is cliked sort the list based on the column. Filename is treated same as
* path, if you really want to sort by file you have to do it via the right click menu.
*/
on *:DIALOG:PS_DLG_AX:sclick:2210 {
  var %action = $gettok($did($dname, $did, 1), 1, 32)  
  if (%action == headerclick) {
    set %ps_viewer_sortcolumn $gettok($did($dname, $did, 1), 3, 32)
    if (%ps_viewer_sortcolumn == 3) set %ps_viewer_sortcolumn 4
    $PSDV_PopulateList($did($dname,2206).text, $did($dname,2204).text, %ps.viewer.filter.lines, $dname)
  }
  if (%action == item) {
    if ($did($dname,$did,1).sel != $did($dname,$did).lines) did -u $dname 2209
    .timerPSDV_DisplaySelected -m 1 40 PSDV_DisplaySelected $dname
  }
}

/****************************************************************************************
* Launch external viewer when a list item is double clicked. Because it's not possible
* to disable double click event, check the enabled-status of the "External Viewer"
* button. This provides the same protection against potentially dangerous files.
*/
on *:DIALOG:PS_DLG_AX:dclick:2210 {
  if ($did($dname, 2208).enabled == $false) return
  var %file = $PSDV_GetSelectedFile($dname)
  if ($isfile(%file)) run %file
}

/****************************************************************************************
* Clicked on icon - display fullscreen
*/
on *:DIALOG:PS_DLG_AX:sclick:2251 {
  if ($version >= 6.3) {
    var %file = $did($dname,$did).text
  }
  else {
    var %file = $right($did($dname,$did).text, -2)
  }
  if ($isfile(%file)) $PSS_DisplayFullscreen(%file)
}


/****************************************************************************************
* Reset sorting order to leech-order when dialog is closed
*/
on *:DIALOG:PS_DLG_AX:close:0 {
  unset %ps_viewer_sortcolumn
}

/****************************************************************************************
* Sorting options for the main filelist and the header
*/
menu @PSCC_Rclick*2210 {
  Sort By
  .$iif(%ps_viewer_sortcolumn == 1,$style(1)) Trigger: { set %ps_viewer_sortcolumn 1 | $PSDV_PopulateList($did(PS_DLG_AX,2206).text, $did(PS_DLG_AX,2204).text, %ps.viewer.filter.lines,PS_Dlg_AX) }
  .$iif(%ps_viewer_sortcolumn == 2,$style(1)) Nick: { set %ps_viewer_sortcolumn 2 | $PSDV_PopulateList($did(PS_DLG_AX,2206).text, $did(PS_DLG_AX,2204).text, %ps.viewer.filter.lines,PS_Dlg_AX) }
  .$iif(%ps_viewer_sortcolumn == 3,$style(1)) Filename: { set %ps_viewer_sortcolumn 3 | $PSDV_PopulateList($did(PS_DLG_AX,2206).text, $did(PS_DLG_AX,2204).text, %ps.viewer.filter.lines,PS_Dlg_AX) }
  .$iif(%ps_viewer_sortcolumn == 4,$style(1)) Path: { set %ps_viewer_sortcolumn 4 | $PSDV_PopulateList($did(PS_DLG_AX,2206).text, $did(PS_DLG_AX,2204).text, %ps.viewer.filter.lines,PS_Dlg_AX) }
  .$iif(%ps_viewer_sortcolumn == $null,$style(1)) Leech order: { unset %ps_viewer_sortcolumn | $PSDV_PopulateList($did(PS_DLG_AX,2206).text, $did(PS_DLG_AX,2204).text, %ps.viewer.filter.lines,PS_Dlg_AX) }
  -
}

/****************************************************************************************
* Right click menu for the filelist
*/
menu @PSCC_Rclick_2210 {
  Explore Dir
  .$submenu($PSDV_ExploreSubmenu($1))
}


/****************************************************************************************
* Explore dir submenu. Unfortunately the returned label can not contain ':' so
* we will have to get by with its ugly cousin ';' 
* @param n the $1 autoincrement variable used for submenus 
* @return popup menu items
*/
alias PSDV_ExploreSubmenu {
  var %dname = PS_Dlg_AX
  var %n = $1, %dir = $nofile($PSDV_GetSelectedFile(%dname))
  if ((%n == begin) || (%n == end)) return

  while ((%dir != $null) && (!$isdir(%dir))) {
    %dir = $nofile($left(%dir,-1))
  }
  while (%n > 1) {
    %dir = $nofile($left(%dir,-1))
    dec %n
  }

  if ($len(%dir) >= 3) return $replace(%dir,:,;) $+ : run explorer.exe /n, /e, " $+ %dir $+ "
}





/****************************************************************************************
* Display currently selected image and enable/disable buttons. If the viewer tab is not
* currently visible, the image display is deferred until the tab is made visible again.
* If fullscreen mode is enabled, show the image in the fullscreen window instead.
* @param void @return void
*/
alias PSDV_DisplaySelected {
  var %dname = $1, %externalid = 2208, %iconid = 2251
  var %selfile = $PSDV_GetSelectedFile(%dname)

  if ((%selfile == $null) || ($dialog(%dname).tab != 2200)) {
    did -b %dname %externalid
    return
  }  

  var %extension = ' $+ $gettok($nopath(%selfile), -1, $asc(.)) $+ '
  if (!$isfile(%selfile)) {
    did -b %dname %externalid
    did -g %dname %iconid $PS_IconDir $+ FileNotFound.png"
  }
  else if (%extension isin 'jpg'jpeg'jpe'bmp'png'gif') {
    did -e %dname %externalid
    if ($window(@PSS_FS_Display) != $null) {
      $PSS_DisplayFullscreen(%selfile)
    }
    else {
      ; Use placeholder and timer to work around mirc image loading bug
      if (!%ps.viewer.disable_large_file_bugfix) {
        did -g %dname %iconid $PS_IconDir $+ placeholder.png"
      }
      .timer 1 0 did -g %dname %iconid %selfile
    }
  }  
  else {
    if (%extension isin 'zip'rar'txt'log'pdf'avi'mpe'mpeg'mpg'ogm'mov'qt'wmv'mp4'divx'xvid'mkv'rm'swf'flv'vob'mpv'm2v'aac'ac3'asf'wma'mp3'wav'ogg'mka'm4a') {
      did -e %dname %externalid
    }
    else {
      ; Disable /run command for unknown (=unsafe) file extensions
      did -b %dname %externalid
    }
    did -g %dname %iconid $PS_SplashDir $+ splashmain.jpg"
  }

  ; Show filename. The list indexes need to be adjusted -1 because MDX lists start at line 2
  did -ra %dname 2250 $chr($asc([)) $calc($did(%dname, 2210,1).sel - 1) / $calc($did(%dname, 2210).lines - 1) $chr($asc(]))
}


/****************************************************************************************
* Return absolute filename of the file selected in listview. Does not guarantee that 
* the file actually exists on disk. @param void
* @return file double quoted filename with full path, $null if nothing is selected
*/
alias -l PSDV_GetSelectedFile {
  var %dname = $1
  if ($did(%dname, 2210).seltext == $null) return

  tokenize 9 $did(PS_DLG_AX, 2210).seltext
  var %trig = $gettok($1, 6, 32)
  var %path = $gettok($4, 5-, 32)
  if (%trig == N/A) {
    return " $+ %path $+ "
  }
  elseif (<*> iswm %trig) {
    return " $+ %ps.downp $+ PSSamples $+ %path $+ "
  }
  else {
    ; No way to know if file was leeched with autosort on, try both options
    var %sortedlocation = " $+ $PSTC_GetPath(%trig) $+ $right(%path, -1) $+ " 
    var %unsortlocation = " $+ %PS.downp $+ %trig $+ %path $+ "
    if ($isfile(%sortedlocation)) return %sortedlocation
    if ($isfile(%unsortlocation)) return %unsortlocation
    if ($PSTC_GetPath(%trig) != null) return %sortedlocation
    return %unsortlocation
  }
}



/****************************************************************************************
* Clear and populate the listview, filtering for Trig and Type. Current selection is
* maintained when possible.
* @param trig single trigger or word 'Samples', 'Misc', 'Triggers'
* @param type either 'Pictures', 'Other' or 'Everything'
* @param maxlines maximum number of lines to add
* @return void
*/
alias -l PSDV_PopulateList {
  var %trig = $1, %type = $2, %maxlines = $3, %dname = $4
  var %seltext = $did(%dname, 2210).seltext
  did -r %dname 2210

  if (%trig == All Leeches)    var %re = /^\+ 0 0 0 [A-Z0-9\-]+  $+ $chr(9)
  elseif (%trig == Samples)    var %re = /^\+ 0 0 0 <.+?> $+ $chr(9)
  elseif (%trig == Misc Downloads) var %re = /^\+ 0 0 0 N\/A  $+ $chr(9)
  elseif (%trig == Everything) var %re = /^\+ 0 0 0 .+    $+ $chr(9)
  else                         var %re = /^\+ 0 0 0 %trig $+ $chr(9)
  if (%type == All Content)    %re = %re $+ .+/i
  elseif (%type == Pictures)   %re = %re $+ .+\.(jpg|jpeg|jpe|bmp|png)$/i
  ; Negative lookbehind requires fixed lenght substring so we must test for "peg" instead of "jpeg":
  elseif (%type == Non-Pics)   %re = %re $+ .+(?<!(jpg|peg|jpe|bmp|png))$/i

  var %templog = $PS_TmpDir $+ PSDV_PopulateList.tmp"
  filter -cg $PSDV_LogFile %templog %re
  if (%ps_viewer_sortcolumn == $null) {
    loadbuf %maxlines -or %dname 2210 %templog
  }
  else {
    var %range = $calc($lines(%templog) - %maxlines + 1) $+ -999999
    filter -cogtr %range %ps_viewer_sortcolumn 9 %templog %dname 2210 %re
  }
  .remove %templog

  ; Retain old selection when possible. Fields in selected line have flags "+fs", the lines
  ; just added have only "+". To find the correct line we must first remove the "fs"
  var %selline = $didwm(%dname, 2210, $replace(%seltext,+fs,+))
  if (%selline > 1) {
    did -fc %dname 2210 %selline
    did -u %dname 2209
  }
  else {
    did -fc %dname 2210 $did(%dname, 2210).lines
    did -c %dname 2209
  }
  PSDV_DisplaySelected %dname
}



/****************************************************************************************
* Return location of the main logfile (enclosed with double quotes). Also ensures that
* the file exists by creating 0-byte file, so you don't get "unable to open" etc errors
* trying to access it. @param void @return logfile double quoted filename with full path
*/
alias -l PSDV_LogFile {
  var %logfile = $PS_DownloadLogDir $+ FileDownloads.log"
  if (!$isfile(%logfile)) write %logfile
  return %logfile
}

/****************************************************************************************
* Return location of the index file (enclosed with double quotes). Also ensures that
* the file exists by creating 0-byte file, so you don't get "unable to open" etc errors
* trying to access it. @param void @return inifile double quoted filename with full path
*/
alias -l PSDV_IndexFile {
  var %inifile = $PS_DownloadLogDir $+ TrigDownloads.ini"
  if (!$isfile(%inifile)) write %inifile
  return %inifile
}



/****************************************************************************************
* Add entry in the logfile for leeched file. 
* @param nick who the file was downloaded from
* @param relpath path of the file, relative to collection dir (eg. \Shoot 34\Pic01.jpg)
* @return void
*/
alias PSDV_LogLeechDownload {
  var %nick = $1, %trig = $2, %relpath = $3-
  write $PSDV_LogFile + 0 0 0 $upper(%trig) $+ $chr(9) $+ + 0 0 0 %nick $+ $chr(9) $+ + 0 0 0 $nopath(%relpath) $+ $chr(9) $+ + 0 0 0 %relpath
  if ($readini($PSDV_IndexFile, n, downloads, %trig) != 1) writeini $PSDV_IndexFile downloads %trig 1
  if ($dialog(PS_DLG_AX)) $PSDV_AppendListview(%nick, $upper(%trig), %relpath)
}



/****************************************************************************************
* Add entry in the logfile for downloaded sample. 
* @param nick who the file was downloaded from
* @param file filename witout any path info (eg. Shoot_34_Pic01.jpg)
* @return void
*/
alias PSDV_LogSampleDownload {
  var %nick = $1, %trig = $2, %file = $3-
  write $PSDV_LogFile + 0 0 0 < $+ $upper(%trig) $+ > $+ $chr(9) $+ + 0 0 0 %nick $+ $chr(9) $+ + 0 0 0 %file $+ $chr(9) $+ + 0 0 0 \ $+ %trig $+ \ $+ %file
  writeini $PSDV_IndexFile downloads < $+ %trig $+ > 1
  if ($dialog(PS_DLG_AX)) $PSDV_AppendListview(%nick, < $+ $upper(%trig) $+ >, \ $+ %trig $+ \ $+ %file)
}


/****************************************************************************************
* Add entry in the logfile for misc received file, be it pserve related or not. You 
* should call this alias via a timer so that if some other script moves or deletes the
* file this alias can detect the missing file and not add a useless entry in logs.
* @param nick who the file was downloaded from 
* @param abspath full path and filename (eg. C:\Downloads\Mirc\Q4-Earnings-report.doc)
* @return void
*/
alias PSDV_LogMiscDownload {
  var %nick = $1, %abspath = $2-
  if (!$isfile(%abspath)) return
  write $PSDV_LogFile + 0 0 0 N/A $+ $chr(9) $+ + 0 0 0 %nick $+ $chr(9) $+ + 0 0 0 $nopath(%abspath) $+ $chr(9) $+ + 0 0 0 %abspath
  if ($dialog(PS_DLG_AX)) $PSDV_AppendListview(%nick, N/A, %abspath)
}


/****************************************************************************************
* Add new entry in the listview (unless prohibited by current filter settings). If auto-
* switch is enabled, select the new line and show the image. 
* @return void
*/
alias -l PSDV_AppendListview {
  var %nick = $1, %trig = $2, %path = $3-
  var %dname = PS_DLG_AX, %listid = 2210, %typefilter = $did(%dname, 2204).seltext, %trigfilter = $did(%dname, 2206).seltext
  if ((%typefilter == $null) || (%trigfilter == $null)) return

  if (($PSTC_IsTrig(%trig)) && (%trig !isin $didtok(%dname,2206,32))) {
    did -a %dname 2206 %trig
  }

  if ((%typefilter == Pictures) && (!$regex(%path, /\.(jpg|jpeg|jpe|bmp|png)$/i))) return
  if ((%typefilter == Non-Pics) && ($regex(%path, /\.(jpg|jpeg|jpe|bmp|png)$/i)))  return

  if (%trigfilter == Everything) {
    ; allow all
  }
  elseif (%trigfilter = All Leeches) {
    if ((<*> iswm %trig) || (%trig == N/A)) return
  }
  elseif (%trigfilter = Samples) {
    if (<*> !iswm %trig) return
  }
  elseif (%trigfilter = Misc Downloads) {
    if (%trig != N/A) return
  }
  else {
    if (%trig != %trigfilter) return
  }

  ; Autoswitch if enabled
  if ($did(%dname, 2209).state == 0) {
    did -a %dname %listid + 0 0 0 %trig $+ $chr(9) $+ + 0 0 0 %nick $+ $chr(9) $+ + 0 0 0 $nopath(%path) $+ $chr(9) $+ + 0 0 0 %path
    did -ra %dname 2250 $chr($asc([)) $calc($did(%dname, 2210,1).sel - 1) / $calc($did(%dname, 2210).lines - 1) $chr($asc(]))
  }
  else {
    did -ac %dname %listid + 0 0 0 %trig $+ $chr(9) $+ + 0 0 0 %nick $+ $chr(9) $+ + 0 0 0 $nopath(%path) $+ $chr(9) $+ + 0 0 0 %path
    PSDV_DisplaySelected %dname
  }

  ; The list must not grow uncontrollably if PSCC is left open for a long time. Deletions are really annoying because
  ; they alter the scroll position of the list. Solution: wait until we are 10% over the limit and then delete the 10%
  if ($did(%dname, %listid).lines > $calc(%ps.viewer.filter.lines * 1.1)) {
    while ($did(%dname, %listid).lines > %ps.viewer.filter.lines) did -d %dname %listid 2
  }
}

;; Update viewer picture when switching back to viewer tab
on *:DIALOG:PS_DLG_AX:sclick:2200 {
  if ($did(2209).state == 1) {
    .timer 1 0 PSDV_DisplaySelected $dname
  }
}


/****************************************************************************************
* If logfile is over 15 000 lines trim it 10 000 lines. The inifile (that keeps track of
* which trigs are represented in the main logfile) is also updated.
* @param void @return void
*/
alias PSDV_TrimLog {
  var %logfile = $PSDV_LogFile

  var %lines = $lines(%logfile)
  if (%lines < 15000) return
  echo $ps_n -st --> Trimming downloads logfile to 10 000 lines

  ; Load last 10000 lines to a hidden window, overwrite old file with window contents
  window -lh @PSDV_TrimLog
  loadbuf 10000 @PSDV_TrimLog %logfile
  savebuf @PSDV_TrimLog %logfile

  ; Update trig occurrance index
  .remove $PSDV_IndexFile
  var %i = 1
  while (%i <= 10000) {
    hadd -m PSDV_TrimLog $gettok($gettok($line(@PSDV_TrimLog, %i), 5, 32), 1, 9) 1
    inc %i
  }
  hsave -i PSDV_TrimLog $PSDV_IndexFile downloads
  hfree PSDV_TrimLog
  window -c @PSDV_TrimLog
}


/*
if ($dialog($1).tab == 1700) {
  if ($inrect($2,$3,20,50,500,390)) { did -a $1 997 This is a preview box which will display the last picture you downloaded. | return }
  if ($inrect($2,$3,518,45,135,25)) { did -a $1 997 Enables the preview box picture viewer. | return }
  if ($inrect($2,$3,655,45,85,20)) { did -a $1 997 Resets the list of downloaded files displayed in the listbox. | return }
  if ($inrect($2,$3,518,70,230,17)) { did -a $1 997 This is the number of files loaded into the list below.  A high number will slow down loading of the PS Control Center. | return }
  if ($inrect($2,$3,518,90,135,20)) { did -a $1 997 Lists all files download if enabled otherwise it lists only pserve leeched files. | return }
  if ($inrect($2,$3,655,90,85,20)) { did -a $1 997 Opens up a Windows File Explorer window in the directory of the selected file. | return }
  if ($inrect($2,$3,518,110,135,20)) { did -a $1 997 Stop the auto display of downloaded images, Manual selection req'd to update viewer picture. | return }
  if ($inrect($2,$3,655,110,85,20)) { did -a $1 997 Filter the Download list by the Trigger or Nick listed in the dropdown. | return }
  if ($inrect($2,$3,518,140,240,325)) { did -a $1 997 Lists the files you have downloaded.  Single click to display in the preview box, Double click to open the file. | return }
}
*/
